import {useState, useEffect} from 'react';
import './SortingVisualizer.css'
import BubbleSort from "./BubbleSort";
import RangeSlider from 'react-bootstrap-range-slider';
import 'react-bootstrap-range-slider/dist/react-bootstrap-range-slider.css';
import {Dropdown} from 'react-bootstrap';
import 'bootstrap/dist/css/bootstrap.min.css';


function SortingVisualizer() {

    const moduloFive = ((window.innerWidth / 45)).toFixed(0) % 5;
    const monitorSize = (window.innerWidth / 45).toFixed(0) - moduloFive;
    const [BarNumber, setBarNumber] = useState(() => monitorSize > 100 ? 100 : monitorSize); // max of 100 bars
    const [bars, setbars] = useState(() => generateArray(BarNumber));
    const [sorting, setSorting] = useState(false);
    const [alreadySorted, setAlreadySorted] = useState();
    const [isSorted, setIsSorted] = useState(false);
    const [sortSpeed, setSortSpeed] = useState('40');

    const SliderWithInputFormControl = () => {
        const [sliderValue_intern, setSliderValue_intern] = useState(BarNumber);
        return (
            <RangeSlider
                value={sliderValue_intern}
                step={5}
                max={100}
                min={5}
                disabled={sorting}
                onChange={changeEvent => setSliderValue_intern(Number(changeEvent.target.value))}
                onAfterChange={() => setBarNumber(sliderValue_intern)}
            />
        );
    };

    useEffect(() => {
        resetBars();
    }, [BarNumber]);

    function getRandomArbitrary(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }

    function generateArray(numberBars) {
        return Array.from({length: numberBars}, () => getRandomArbitrary(50, 300));
    }

    async function handleSorting() {
        if (sorting) return;
        setSorting(true);
        await BubbleSort(bars, setbars, setAlreadySorted, sortSpeed);
        setSorting(false);
    }

    function resetBars() {
        setAlreadySorted(1000);
        setbars(generateArray(BarNumber));
        let ColoredBars = document.getElementsByClassName('sorted');
        document.getElementById('startButton').innerText = 'Sort!';
        while (ColoredBars.length > 0) {
            ColoredBars[0].className = 'bar';
        }
        setIsSorted(false);


    }

    function finishAnimation() {
        let ColoredBars = document.getElementsByClassName('sorted');
        while (ColoredBars.length > 0) {
            ColoredBars[0].className = 'finished';
        }
    }

    function handleButton() {
        if (!sorting && !isSorted) {
            setAlreadySorted(1000);
            handleSorting();
        } else if (isSorted) {
            resetBars();

        }
    }

    useEffect(() => {
        if (alreadySorted == 0) {
            setIsSorted(true);
            finishAnimation();
            document.getElementById('startButton').innerText = 'Reset!';
        }
    }, [alreadySorted]);


    return (
        <>
            <div className='Container'>
                <div id='ToolBar'>
                    <div className="Label">How many Bars?</div>
                    <SliderWithInputFormControl style={{className: 'range-slider'}}/>
                    <input type='number' max={100} min={0} disabled={sorting}
                           onChange={changeEvent => {
                               let value = Number(changeEvent.target.value);
                               if (value > 100) value = 100;
                               if (value < 5) value = 5;
                               setBarNumber(value);
                           }} defaultValue={BarNumber}
                           value={BarNumber} style={{
                        width: '42px',
                        margin: '10px',
                        borderRadius: '5px',
                        border: 'none',
                        textAlign: 'center'
                    }}/>
                    <div style={{background: 'gray', height: '70%', marginLeft: '10px', width: '2px'}}></div>
                    <Dropdown id="dropdown">
                        <Dropdown.Toggle
                            id="dropdown"
                            disabled={sorting}
                        >
                            Sorting-Speed: {
                            {
                                100: 'Slow',
                                40: 'Medium',
                                0: 'Fast'
                            }[sortSpeed] || ''
                        }
                        </Dropdown.Toggle>
                        <Dropdown.Menu id="dropdown-menu">
                            <Dropdown.Item id="dropdown-item" onClick={() => setSortSpeed(100)}>
                                Slow
                            </Dropdown.Item>
                            <Dropdown.Item id="dropdown-item" onClick={() => setSortSpeed(40)}>
                                Medium
                            </Dropdown.Item>
                            <Dropdown.Item id="dropdown-item" onClick={() => setSortSpeed(0)}>
                                Fast
                            </Dropdown.Item>
                        </Dropdown.Menu>
                    </Dropdown>
                    <button id='startButton' className="Button" disabled={sorting}
                            style={{background: `${sorting ? 'red' : ''}`}} onClick={() => {
                        handleButton()
                    }}>{sorting ? 'Sorting...' : 'Sort!'}</button>
                </div>
                <div className='DivArray'>
                    {bars.map((height, index) => (<div key={index} data-key={index}
                                                       className={`bar + ${alreadySorted <= index ? 'sorted' : ''}`}
                                                       style={{height: `${height}px`}}></div>))}
                </div>

            </div>
        </>
    )
};
export default SortingVisualizer;