package main

import (
	"log"
	"os"

	"code.fbi.h-da.de/danet/gosdn/controller/plugin/shared"
	generated "code.fbi.h-da.de/danet/gosdn/models/generated/openconfig"
	"code.fbi.h-da.de/danet/gosdn/plugins/sdk"
	"github.com/hashicorp/go-plugin"
)

func main() {
	deviceModel, err := sdk.NewDeviceModel(generated.Schema, generated.Unmarshal, generated.SchemaTreeGzip)
	if err != nil {
		log.Println(err)
		os.Exit(1)
	}
	plugin.Serve(&plugin.ServeConfig{
		HandshakeConfig: shared.Handshake,
		Plugins: map[string]plugin.Plugin{
			"deviceModel": &shared.DeviceModelPlugin{Impl: deviceModel},
		},
		GRPCServer: plugin.DefaultGRPCServer,
	})
}
