package main

import (
	"fmt"

	pb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/plugin-registry"
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/plugin"
	"github.com/google/uuid"
)

type Plugin struct {
	ID       uuid.UUID        `json:"id,omitempty"`
	Path     string           `json:"path,omitempty"`
	Manifest *plugin.Manifest `json:"manifest,omitempty"`
}

type PluginRegistry struct {
	Plugins []*Plugin `json:"plugins,omitempty"`
}

func (pr *PluginRegistry) GetPluginByID(id uuid.UUID) (*Plugin, error) {
	for _, plugin := range pr.Plugins {
		if plugin.ID == id {
			return plugin, nil
		}
	}
	return nil, fmt.Errorf("couldn't find plugin with ID: %s", id.String())
}

func (pr *PluginRegistry) GetPluginByName(s string) (*Plugin, error) {
	for _, plugin := range pr.Plugins {
		if plugin.Manifest.Name == s {
			return plugin, nil
		}
	}
	return nil, fmt.Errorf("couldn't find plugin with ID: %s", s)
}

func pluginConverter(p *Plugin) *pb.Plugin {
	return &pb.Plugin{
		Id: p.ID.String(),
		Manifest: &pb.Manifest{
			Name:     p.Manifest.Name,
			Firmware: p.Manifest.Firmware,
			Author:   p.Manifest.Author,
			Version:  p.Manifest.Version,
		},
	}
}
