ARG GOLANG_VERSION=1.19
ARG BUILDARGS
ARG $GITLAB_PROXY

FROM ${GITLAB_PROXY}golang:$GOLANG_VERSION-buster as builder
WORKDIR /plugin-registry/
RUN apt-get update
RUN apt-get -y install --no-install-recommends zip
COPY . .

RUN --mount=type=cache,target=/root/go/pkg/mod \
    --mount=type=cache,target=/root/.cache/go-build \
    make build-plugin-registry-debug

FROM scratch
WORKDIR /app/
COPY --from=builder /plugin-registry/artifacts/plugin-registry .
COPY --from=builder /plugin-registry/plugin-registry/plugins ./plugins
ENTRYPOINT ["./plugin-registry", "-socket", "55057"]
