/*
Package openconfig is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was false
in this case).

This package was generated by /home/bob/go/pkg/mod/github.com/openconfig/ygot@v0.27.0/genutil/names.go
using the following YANG input files:
	- ../../../models/openconfig/release/models/system/openconfig-system.yang
	- ../../../models/openconfig/release/models/system/openconfig-messages.yang
	- ../../../models/openconfig/release/models/interfaces/openconfig-interfaces.yang
	- ../../../models/openconfig/release/models/interfaces/openconfig-if-ethernet.yang
	- ../../../models/openconfig/release/models/interfaces/openconfig-if-ip.yang
	- ../../../models/openconfig/release/models/network-instance/openconfig-network-instance.yang
	- ../../../models/openconfig/release/models/acl/openconfig-acl.yang
	- ../../../models/openconfig/release/models/bgp/openconfig-bgp.yang
	- ../../../models/openconfig/release/models/platform/openconfig-platform.yang
	- ../../../models/openconfig/release/models/local-routing/openconfig-local-routing.yang
	- ../../../models/openconfig/release/models/policy/openconfig-routing-policy.yang
	- ../../../models/openconfig/release/models/lldp/openconfig-lldp.yang
	- ../../../models/arista/EOS-4.28.2F/release/openconfig/models/lldp/arista-lldp-augments.yang
	- ../../../models/arista/EOS-4.28.2F/release/openconfig/models/lldp/arista-lldp-deviations.yang
Imported modules were sourced from:
	- ../../../models/openconfig/...
*/
package openconfig

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ytypes"
	gpb "github.com/openconfig/gnmi/proto/gnmi"
)

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

// UnionInt8 is an int8 type assignable to unions of which it is a subtype.
type UnionInt8 int8

// UnionInt16 is an int16 type assignable to unions of which it is a subtype.
type UnionInt16 int16

// UnionInt32 is an int32 type assignable to unions of which it is a subtype.
type UnionInt32 int32

// UnionInt64 is an int64 type assignable to unions of which it is a subtype.
type UnionInt64 int64

// UnionUint8 is a uint8 type assignable to unions of which it is a subtype.
type UnionUint8 uint8

// UnionUint16 is a uint16 type assignable to unions of which it is a subtype.
type UnionUint16 uint16

// UnionUint32 is a uint32 type assignable to unions of which it is a subtype.
type UnionUint32 uint32

// UnionUint64 is a uint64 type assignable to unions of which it is a subtype.
type UnionUint64 uint64

// UnionFloat64 is a float64 type assignable to unions of which it is a subtype.
type UnionFloat64 float64

// UnionString is a string type assignable to unions of which it is a subtype.
type UnionString string

// UnionBool is a bool type assignable to unions of which it is a subtype.
type UnionBool bool

// UnionUnsupported is an interface{} wrapper type for unsupported types. It is
// assignable to unions of which it is a subtype.
type UnionUnsupported struct {
	Value interface{}
}

var (
	SchemaTree map[string]*yang.Entry
	ΛEnumTypes map[string][]reflect.Type
)

func init() {
	var err error
	initΛEnumTypes()
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " +  err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root: &Device{},
		SchemaTree: uzp,
		Unmarshal: Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn )
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}
// ΓModelData contains the catalogue information corresponding to the modules for
// which Go code was generated.
var ΓModelData = []*gpb.ModelData{
	{
		Name: "arista-lldp-augments",
		Organization: "Arista Networks, Inc.",
		Version: "1.0.1",
	},
	{
		Name: "arista-lldp-deviations",
		Organization: "Arista Networks, Inc.",
		Version: "1.1.0",
	},
	{
		Name: "iana-if-type",
		Organization: "IANA",
	},
	{
		Name: "ietf-inet-types",
		Organization: "IETF NETMOD (NETCONF Data Modeling Language) Working Group",
	},
	{
		Name: "ietf-interfaces",
		Organization: "IETF NETMOD (Network Modeling) Working Group",
	},
	{
		Name: "ietf-yang-types",
		Organization: "IETF NETMOD (NETCONF Data Modeling Language) Working Group",
	},
	{
		Name: "openconfig-aaa",
		Organization: "OpenConfig working group",
		Version: "1.0.0",
	},
	{
		Name: "openconfig-aaa-types",
		Organization: "OpenConfig working group",
		Version: "0.4.1",
	},
	{
		Name: "openconfig-acl",
		Organization: "OpenConfig working group",
		Version: "1.3.2",
	},
	{
		Name: "openconfig-aft",
		Organization: "OpenConfig working group",
		Version: "2.2.0",
	},
	{
		Name: "openconfig-aft-types",
		Organization: "OpenConfig Working Group",
		Version: "1.1.0",
	},
	{
		Name: "openconfig-alarm-types",
		Organization: "OpenConfig working group",
		Version: "0.2.1",
	},
	{
		Name: "openconfig-alarms",
		Organization: "OpenConfig working group",
		Version: "0.3.2",
	},
	{
		Name: "openconfig-bfd",
		Organization: "OpenConfig working group",
		Version: "0.2.4",
	},
	{
		Name: "openconfig-bgp",
		Organization: "OpenConfig working group",
		Version: "9.2.0",
	},
	{
		Name: "openconfig-bgp-types",
		Organization: "OpenConfig working group",
		Version: "5.3.1",
	},
	{
		Name: "openconfig-defined-sets",
		Organization: "OpenConfig working group",
		Version: "1.0.0",
	},
	{
		Name: "openconfig-evpn",
		Organization: "OpenConfig working group",
		Version: "0.3.0",
	},
	{
		Name: "openconfig-evpn-types",
		Organization: "OpenConfig working group",
		Version: "0.2.0",
	},
	{
		Name: "openconfig-extensions",
		Organization: "OpenConfig working group",
		Version: "0.5.1",
	},
	{
		Name: "openconfig-if-aggregate",
		Organization: "OpenConfig working group",
		Version: "2.4.4",
	},
	{
		Name: "openconfig-if-ethernet",
		Organization: "OpenConfig working group",
		Version: "2.12.2",
	},
	{
		Name: "openconfig-if-ip",
		Organization: "OpenConfig working group",
		Version: "3.1.0",
	},
	{
		Name: "openconfig-igmp",
		Organization: "OpenConfig working group",
		Version: "0.3.0",
	},
	{
		Name: "openconfig-igmp-types",
		Organization: "OpenConfig working group",
		Version: "0.1.1",
	},
	{
		Name: "openconfig-inet-types",
		Organization: "OpenConfig working group",
		Version: "0.5.0",
	},
	{
		Name: "openconfig-interfaces",
		Organization: "OpenConfig working group",
		Version: "2.5.0",
	},
	{
		Name: "openconfig-isis",
		Organization: "OpenConfig working group",
		Version: "1.1.0",
	},
	{
		Name: "openconfig-isis-lsdb-types",
		Organization: "OpenConfig working group",
		Version: "0.4.2",
	},
	{
		Name: "openconfig-isis-types",
		Organization: "OpenConfig working group",
		Version: "0.6.0",
	},
	{
		Name: "openconfig-keychain",
		Organization: "OpenConfig working group",
		Version: "0.4.0",
	},
	{
		Name: "openconfig-keychain-types",
		Organization: "OpenConfig working group",
		Version: "0.2.0",
	},
	{
		Name: "openconfig-license",
		Organization: "OpenConfig working group",
		Version: "0.2.0",
	},
	{
		Name: "openconfig-lldp",
		Organization: "OpenConfig working group",
		Version: "0.2.1",
	},
	{
		Name: "openconfig-lldp-types",
		Organization: "OpenConfig working group",
		Version: "0.1.1",
	},
	{
		Name: "openconfig-local-routing",
		Organization: "OpenConfig working group",
		Version: "2.0.1",
	},
	{
		Name: "openconfig-messages",
		Organization: "OpenConfig working group",
		Version: "0.0.1",
	},
	{
		Name: "openconfig-mpls",
		Organization: "OpenConfig working group",
		Version: "3.3.0",
	},
	{
		Name: "openconfig-mpls-ldp",
		Organization: "OpenConfig working group",
		Version: "3.2.0",
	},
	{
		Name: "openconfig-mpls-rsvp",
		Organization: "OpenConfig working group",
		Version: "4.0.0",
	},
	{
		Name: "openconfig-mpls-sr",
		Organization: "OpenConfig working group",
		Version: "3.0.1",
	},
	{
		Name: "openconfig-mpls-types",
		Organization: "OpenConfig working group",
		Version: "3.4.0",
	},
	{
		Name: "openconfig-network-instance",
		Organization: "OpenConfig working group",
		Version: "4.0.0",
	},
	{
		Name: "openconfig-network-instance-l3",
		Organization: "OpenConfig working group",
		Version: "2.0.0",
	},
	{
		Name: "openconfig-network-instance-types",
		Organization: "OpenConfig working group",
		Version: "0.9.3",
	},
	{
		Name: "openconfig-ospf-types",
		Organization: "OpenConfig working group",
		Version: "0.1.3",
	},
	{
		Name: "openconfig-ospfv2",
		Organization: "OpenConfig working group",
		Version: "0.4.0",
	},
	{
		Name: "openconfig-packet-match",
		Organization: "OpenConfig working group",
		Version: "1.4.0",
	},
	{
		Name: "openconfig-packet-match-types",
		Organization: "OpenConfig working group",
		Version: "1.3.2",
	},
	{
		Name: "openconfig-pcep",
		Organization: "OpenConfig working group",
		Version: "0.1.0",
	},
	{
		Name: "openconfig-pim",
		Organization: "OpenConfig working group",
		Version: "0.4.2",
	},
	{
		Name: "openconfig-pim-types",
		Organization: "OpenConfig working group",
		Version: "0.1.1",
	},
	{
		Name: "openconfig-platform",
		Organization: "OpenConfig working group",
		Version: "0.22.0",
	},
	{
		Name: "openconfig-platform-types",
		Organization: "OpenConfig working group",
		Version: "1.5.0",
	},
	{
		Name: "openconfig-policy-forwarding",
		Organization: "OpenConfig working group",
		Version: "0.5.0",
	},
	{
		Name: "openconfig-policy-types",
		Organization: "OpenConfig working group",
		Version: "3.2.3",
	},
	{
		Name: "openconfig-procmon",
		Organization: "OpenConfig working group",
		Version: "0.4.0",
	},
	{
		Name: "openconfig-rib-bgp",
		Organization: "OpenConfig working group",
		Version: "0.9.0",
	},
	{
		Name: "openconfig-rib-bgp-types",
		Organization: "OpenConfig working group",
		Version: "0.5.0",
	},
	{
		Name: "openconfig-routing-policy",
		Organization: "OpenConfig working group",
		Version: "3.3.0",
	},
	{
		Name: "openconfig-segment-routing",
		Organization: "OpenConfig working group",
		Version: "0.3.1",
	},
	{
		Name: "openconfig-segment-routing-types",
		Organization: "OpenConfig working group",
		Version: "0.2.0",
	},
	{
		Name: "openconfig-srte-policy",
		Organization: "OpenConfig working group",
		Version: "0.2.3",
	},
	{
		Name: "openconfig-system",
		Organization: "OpenConfig working group",
		Version: "0.17.0",
	},
	{
		Name: "openconfig-system-logging",
		Organization: "OpenConfig working group",
		Version: "0.4.1",
	},
	{
		Name: "openconfig-system-terminal",
		Organization: "OpenConfig working group",
		Version: "0.3.1",
	},
	{
		Name: "openconfig-types",
		Organization: "OpenConfig working group",
		Version: "0.6.0",
	},
	{
		Name: "openconfig-vlan",
		Organization: "OpenConfig working group",
		Version: "3.2.1",
	},
	{
		Name: "openconfig-vlan-types",
		Organization: "OpenConfig working group",
		Version: "3.2.0",
	},
	{
		Name: "openconfig-yang-types",
		Organization: "OpenConfig working group",
		Version: "0.3.1",
	},
}

// Device represents the /device YANG schema element.
type Device struct {
	Acl	*OpenconfigAcl_Acl	`path:"acl" module:"openconfig-acl"`
	Bfd	*OpenconfigBfd_Bfd	`path:"bfd" module:"openconfig-bfd"`
	Components	*OpenconfigPlatform_Components	`path:"components" module:"openconfig-platform"`
	DefinedSets	*OpenconfigDefinedSets_DefinedSets	`path:"defined-sets" module:"openconfig-defined-sets"`
	Interfaces	*OpenconfigInterfaces_Interfaces	`path:"interfaces" module:"openconfig-interfaces"`
	Keychains	*OpenconfigKeychain_Keychains	`path:"keychains" module:"openconfig-keychain"`
	Lldp	*OpenconfigLldp_Lldp	`path:"lldp" module:"openconfig-lldp"`
	Messages	*OpenconfigMessages_Messages	`path:"messages" module:"openconfig-messages"`
	NetworkInstances	*OpenconfigNetworkInstance_NetworkInstances	`path:"network-instances" module:"openconfig-network-instance"`
	RoutingPolicy	*OpenconfigRoutingPolicy_RoutingPolicy	`path:"routing-policy" module:"openconfig-routing-policy"`
	System	*OpenconfigSystem_System	`path:"system" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Device.
func (*Device) ΛBelongingModule() string {
	return ""
}


// OpenconfigAcl_Acl represents the /openconfig-acl/acl YANG schema element.
type OpenconfigAcl_Acl struct {
	AclSets	*OpenconfigAcl_Acl_AclSets	`path:"acl-sets" module:"openconfig-acl"`
	Config	*OpenconfigAcl_Acl_Config	`path:"config" module:"openconfig-acl"`
	Interfaces	*OpenconfigAcl_Acl_Interfaces	`path:"interfaces" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl.
func (*OpenconfigAcl_Acl) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets represents the /openconfig-acl/acl/acl-sets YANG schema element.
type OpenconfigAcl_Acl_AclSets struct {
	AclSet	map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet	`path:"acl-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_AclSets_AclSet_Key represents the key for list AclSet of element /openconfig-acl/acl/acl-sets.
type OpenconfigAcl_Acl_AclSets_AclSet_Key struct {
	Name	string	`path:"name"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type"`
}

// IsYANGGoKeyStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigAcl_Acl_AclSets_AclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigAcl_Acl_AclSets_AclSet_Key key struct.
func (t OpenconfigAcl_Acl_AclSets_AclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"name": t.Name,
		"type": t.Type,
	}, nil
}

// NewAclSet creates a new entry in the AclSet list of the
// OpenconfigAcl_Acl_AclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_AclSets) NewAclSet(Name string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_AclSets_AclSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclSet == nil {
		t.AclSet = make(map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet)
	}

	key := OpenconfigAcl_Acl_AclSets_AclSet_Key{
		Name: Name,
		Type: Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclSet", key)
	}

	t.AclSet[key] = &OpenconfigAcl_Acl_AclSets_AclSet{
		Name: &Name,
		Type: Type,
	}

	return t.AclSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets.
func (*OpenconfigAcl_Acl_AclSets) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet represents the /openconfig-acl/acl/acl-sets/acl-set YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet struct {
	AclEntries	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries	`path:"acl-entries" module:"openconfig-acl"`
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_Config	`path:"config" module:"openconfig-acl"`
	Name	*string	`path:"name" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_State	`path:"state" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_AclSets_AclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}


	return map[string]interface{}{
		"name": *t.Name,
		"type": t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet.
func (*OpenconfigAcl_Acl_AclSets_AclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries struct {
	AclEntry	map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry	`path:"acl-entry" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry struct {
	Actions	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions	`path:"actions" module:"openconfig-acl"`
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config	`path:"config" module:"openconfig-acl"`
	InputInterface	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface	`path:"input-interface" module:"openconfig-acl"`
	Ipv4	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4	`path:"ipv4" module:"openconfig-acl"`
	Ipv6	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6	`path:"ipv6" module:"openconfig-acl"`
	L2	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2	`path:"l2" module:"openconfig-acl"`
	Mpls	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls	`path:"mpls" module:"openconfig-acl"`
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State	`path:"state" module:"openconfig-acl"`
	Transport	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport	`path:"transport" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config struct {
	ForwardingAction	E_OpenconfigAcl_FORWARDING_ACTION	`path:"forwarding-action" module:"openconfig-acl"`
	LogAction	E_OpenconfigAcl_LOG_ACTION	`path:"log-action" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State struct {
	ForwardingAction	E_OpenconfigAcl_FORWARDING_ACTION	`path:"forwarding-action" module:"openconfig-acl"`
	LogAction	E_OpenconfigAcl_LOG_ACTION	`path:"log-action" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config struct {
	Description	*string	`path:"description" module:"openconfig-acl"`
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config	`path:"config" module:"openconfig-acl"`
	InterfaceRef	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef	`path:"interface-ref" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-acl"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-acl"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State struct {
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config struct {
	DestinationAddress	*string	`path:"destination-address" module:"openconfig-acl"`
	DestinationAddressPrefixSet	*string	`path:"destination-address-prefix-set" module:"openconfig-acl"`
	Dscp	*uint8	`path:"dscp" module:"openconfig-acl"`
	DscpSet	[]uint8	`path:"dscp-set" module:"openconfig-acl"`
	HopLimit	*uint8	`path:"hop-limit" module:"openconfig-acl"`
	Protocol	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union	`path:"protocol" module:"openconfig-acl"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-acl"`
	SourceAddressPrefixSet	*string	`path:"source-address-prefix-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State struct {
	DestinationAddress	*string	`path:"destination-address" module:"openconfig-acl"`
	DestinationAddressPrefixSet	*string	`path:"destination-address-prefix-set" module:"openconfig-acl"`
	Dscp	*uint8	`path:"dscp" module:"openconfig-acl"`
	DscpSet	[]uint8	`path:"dscp-set" module:"openconfig-acl"`
	HopLimit	*uint8	`path:"hop-limit" module:"openconfig-acl"`
	Protocol	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union	`path:"protocol" module:"openconfig-acl"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-acl"`
	SourceAddressPrefixSet	*string	`path:"source-address-prefix-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config struct {
	DestinationAddress	*string	`path:"destination-address" module:"openconfig-acl"`
	DestinationAddressPrefixSet	*string	`path:"destination-address-prefix-set" module:"openconfig-acl"`
	DestinationFlowLabel	*uint32	`path:"destination-flow-label" module:"openconfig-acl"`
	Dscp	*uint8	`path:"dscp" module:"openconfig-acl"`
	DscpSet	[]uint8	`path:"dscp-set" module:"openconfig-acl"`
	HopLimit	*uint8	`path:"hop-limit" module:"openconfig-acl"`
	Protocol	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union	`path:"protocol" module:"openconfig-acl"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-acl"`
	SourceAddressPrefixSet	*string	`path:"source-address-prefix-set" module:"openconfig-acl"`
	SourceFlowLabel	*uint32	`path:"source-flow-label" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State struct {
	DestinationAddress	*string	`path:"destination-address" module:"openconfig-acl"`
	DestinationAddressPrefixSet	*string	`path:"destination-address-prefix-set" module:"openconfig-acl"`
	DestinationFlowLabel	*uint32	`path:"destination-flow-label" module:"openconfig-acl"`
	Dscp	*uint8	`path:"dscp" module:"openconfig-acl"`
	DscpSet	[]uint8	`path:"dscp-set" module:"openconfig-acl"`
	HopLimit	*uint8	`path:"hop-limit" module:"openconfig-acl"`
	Protocol	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union	`path:"protocol" module:"openconfig-acl"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-acl"`
	SourceAddressPrefixSet	*string	`path:"source-address-prefix-set" module:"openconfig-acl"`
	SourceFlowLabel	*uint32	`path:"source-flow-label" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config struct {
	DestinationMac	*string	`path:"destination-mac" module:"openconfig-acl"`
	DestinationMacMask	*string	`path:"destination-mac-mask" module:"openconfig-acl"`
	Ethertype	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union	`path:"ethertype" module:"openconfig-acl"`
	SourceMac	*string	`path:"source-mac" module:"openconfig-acl"`
	SourceMacMask	*string	`path:"source-mac-mask" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union ensures that E_OpenconfigPacketMatchTypes_ETHERTYPE
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface.
func (E_OpenconfigPacketMatchTypes_ETHERTYPE) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_ETHERTYPE, uint16]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State struct {
	DestinationMac	*string	`path:"destination-mac" module:"openconfig-acl"`
	DestinationMacMask	*string	`path:"destination-mac-mask" module:"openconfig-acl"`
	Ethertype	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union	`path:"ethertype" module:"openconfig-acl"`
	SourceMac	*string	`path:"source-mac" module:"openconfig-acl"`
	SourceMacMask	*string	`path:"source-mac-mask" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state/ethertype within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union ensures that E_OpenconfigPacketMatchTypes_ETHERTYPE
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface.
func (E_OpenconfigPacketMatchTypes_ETHERTYPE) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_ETHERTYPE, uint16]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config struct {
	EndLabelValue	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union	`path:"end-label-value" module:"openconfig-acl"`
	StartLabelValue	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union	`path:"start-label-value" module:"openconfig-acl"`
	TrafficClass	*uint8	`path:"traffic-class" module:"openconfig-acl"`
	TtlValue	*uint8	`path:"ttl-value" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/end-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, uint32]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/start-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, uint32]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State struct {
	EndLabelValue	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union	`path:"end-label-value" module:"openconfig-acl"`
	StartLabelValue	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union	`path:"start-label-value" module:"openconfig-acl"`
	TrafficClass	*uint8	`path:"traffic-class" module:"openconfig-acl"`
	TtlValue	*uint8	`path:"ttl-value" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state/end-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, uint32]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state/start-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, uint32]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State struct {
	Description	*string	`path:"description" module:"openconfig-acl"`
	MatchedOctets	*uint64	`path:"matched-octets" module:"openconfig-acl"`
	MatchedPackets	*uint64	`path:"matched-packets" module:"openconfig-acl"`
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config struct {
	DestinationPort	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union	`path:"destination-port" module:"openconfig-acl"`
	DestinationPortSet	*string	`path:"destination-port-set" module:"openconfig-acl"`
	SourcePort	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union	`path:"source-port" module:"openconfig-acl"`
	SourcePortSet	*string	`path:"source-port-set" module:"openconfig-acl"`
	TcpFlags	[]E_OpenconfigPacketMatchTypes_TCP_FLAGS	`path:"tcp-flags" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, string, uint16]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, string, uint16]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State struct {
	DestinationPort	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union	`path:"destination-port" module:"openconfig-acl"`
	DestinationPortSet	*string	`path:"destination-port-set" module:"openconfig-acl"`
	SourcePort	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union	`path:"source-port" module:"openconfig-acl"`
	SourcePortSet	*string	`path:"source-port-set" module:"openconfig-acl"`
	TcpFlags	[]E_OpenconfigPacketMatchTypes_TCP_FLAGS	`path:"tcp-flags" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/destination-port within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, string, uint16]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/source-port within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, string, uint16]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_Config represents the /openconfig-acl/acl/acl-sets/acl-set/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_Config struct {
	Description	*string	`path:"description" module:"openconfig-acl"`
	Name	*string	`path:"name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_State represents the /openconfig-acl/acl/acl-sets/acl-set/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_State struct {
	Description	*string	`path:"description" module:"openconfig-acl"`
	Name	*string	`path:"name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Config represents the /openconfig-acl/acl/config YANG schema element.
type OpenconfigAcl_Acl_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Config.
func (*OpenconfigAcl_Acl_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces represents the /openconfig-acl/acl/interfaces YANG schema element.
type OpenconfigAcl_Acl_Interfaces struct {
	Interface	map[string]*OpenconfigAcl_Acl_Interfaces_Interface	`path:"interface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigAcl_Acl_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces) NewInterface(Id string) (*OpenconfigAcl_Acl_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigAcl_Acl_Interfaces_Interface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigAcl_Acl_Interfaces_Interface{
		Id: &Id,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces.
func (*OpenconfigAcl_Acl_Interfaces) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface represents the /openconfig-acl/acl/interfaces/interface YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface struct {
	Config	*OpenconfigAcl_Acl_Interfaces_Interface_Config	`path:"config" module:"openconfig-acl"`
	EgressAclSets	*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets	`path:"egress-acl-sets" module:"openconfig-acl"`
	Id	*string	`path:"id" module:"openconfig-acl"`
	IngressAclSets	*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets	`path:"ingress-acl-sets" module:"openconfig-acl"`
	InterfaceRef	*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef	`path:"interface-ref" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface.
func (*OpenconfigAcl_Acl_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_Config represents the /openconfig-acl/acl/interfaces/interface/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_Config struct {
	Id	*string	`path:"id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets struct {
	EgressAclSet	map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet	`path:"egress-acl-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key represents the key for list EgressAclSet of element /openconfig-acl/acl/interfaces/interface/egress-acl-sets.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key struct {
	SetName	string	`path:"set-name"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type"`
}

// IsYANGGoKeyStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key key struct.
func (t OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"set-name": t.SetName,
		"type": t.Type,
	}, nil
}

// NewEgressAclSet creates a new entry in the EgressAclSet list of the
// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) NewEgressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.EgressAclSet == nil {
		t.EgressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet)
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key{
		SetName: SetName,
		Type: Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.EgressAclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list EgressAclSet", key)
	}

	t.EgressAclSet[key] = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet{
		SetName: &SetName,
		Type: Type,
	}

	return t.EgressAclSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet struct {
	AclEntries	*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries	`path:"acl-entries" module:"openconfig-acl"`
	Config	*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config	`path:"config" module:"openconfig-acl"`
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State	`path:"state" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SetName == nil {
		return nil, fmt.Errorf("nil value for key SetName")
	}


	return map[string]interface{}{
		"set-name": *t.SetName,
		"type": t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries struct {
	AclEntry	map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry	`path:"acl-entry" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry struct {
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State struct {
	MatchedOctets	*uint64	`path:"matched-octets" module:"openconfig-acl"`
	MatchedPackets	*uint64	`path:"matched-packets" module:"openconfig-acl"`
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config struct {
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State struct {
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets struct {
	IngressAclSet	map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet	`path:"ingress-acl-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key represents the key for list IngressAclSet of element /openconfig-acl/acl/interfaces/interface/ingress-acl-sets.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key struct {
	SetName	string	`path:"set-name"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type"`
}

// IsYANGGoKeyStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key key struct.
func (t OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"set-name": t.SetName,
		"type": t.Type,
	}, nil
}

// NewIngressAclSet creates a new entry in the IngressAclSet list of the
// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) NewIngressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.IngressAclSet == nil {
		t.IngressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet)
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key{
		SetName: SetName,
		Type: Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.IngressAclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list IngressAclSet", key)
	}

	t.IngressAclSet[key] = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet{
		SetName: &SetName,
		Type: Type,
	}

	return t.IngressAclSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet struct {
	AclEntries	*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries	`path:"acl-entries" module:"openconfig-acl"`
	Config	*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config	`path:"config" module:"openconfig-acl"`
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State	`path:"state" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SetName == nil {
		return nil, fmt.Errorf("nil value for key SetName")
	}


	return map[string]interface{}{
		"set-name": *t.SetName,
		"type": t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries struct {
	AclEntry	map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry	`path:"acl-entry" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry struct {
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State struct {
	MatchedOctets	*uint64	`path:"matched-octets" module:"openconfig-acl"`
	MatchedPackets	*uint64	`path:"matched-packets" module:"openconfig-acl"`
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config struct {
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State struct {
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef represents the /openconfig-acl/acl/interfaces/interface/interface-ref YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef struct {
	Config	*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config represents the /openconfig-acl/acl/interfaces/interface/interface-ref/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-acl"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State represents the /openconfig-acl/acl/interfaces/interface/interface-ref/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-acl"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_State represents the /openconfig-acl/acl/interfaces/interface/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_State struct {
	Id	*string	`path:"id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_State represents the /openconfig-acl/acl/state YANG schema element.
type OpenconfigAcl_Acl_State struct {
	CounterCapability	E_OpenconfigAcl_ACL_COUNTER_CAPABILITY	`path:"counter-capability" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_State.
func (*OpenconfigAcl_Acl_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigBfd_Bfd represents the /openconfig-bfd/bfd YANG schema element.
type OpenconfigBfd_Bfd struct {
	Interfaces	*OpenconfigBfd_Bfd_Interfaces	`path:"interfaces" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd.
func (*OpenconfigBfd_Bfd) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces represents the /openconfig-bfd/bfd/interfaces YANG schema element.
type OpenconfigBfd_Bfd_Interfaces struct {
	Interface	map[string]*OpenconfigBfd_Bfd_Interfaces_Interface	`path:"interface" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigBfd_Bfd_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces) NewInterface(Id string) (*OpenconfigBfd_Bfd_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigBfd_Bfd_Interfaces_Interface{
		Id: &Id,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces.
func (*OpenconfigBfd_Bfd_Interfaces) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface represents the /openconfig-bfd/bfd/interfaces/interface YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface struct {
	Config	*OpenconfigBfd_Bfd_Interfaces_Interface_Config	`path:"config" module:"openconfig-bfd"`
	Id	*string	`path:"id" module:"openconfig-bfd"`
	InterfaceRef	*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef	`path:"interface-ref" module:"openconfig-bfd"`
	MicroBfdSessions	*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions	`path:"micro-bfd-sessions" module:"openconfig-bfd"`
	Peers	*OpenconfigBfd_Bfd_Interfaces_Interface_Peers	`path:"peers" module:"openconfig-bfd"`
	State	*OpenconfigBfd_Bfd_Interfaces_Interface_State	`path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface.
func (*OpenconfigBfd_Bfd_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Config represents the /openconfig-bfd/bfd/interfaces/interface/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Config struct {
	DesiredMinimumTxInterval	*uint32	`path:"desired-minimum-tx-interval" module:"openconfig-bfd"`
	DetectionMultiplier	*uint8	`path:"detection-multiplier" module:"openconfig-bfd"`
	EnablePerMemberLink	*bool	`path:"enable-per-member-link" module:"openconfig-bfd"`
	Enabled	*bool	`path:"enabled" module:"openconfig-bfd"`
	Id	*string	`path:"id" module:"openconfig-bfd"`
	LocalAddress	*string	`path:"local-address" module:"openconfig-bfd"`
	RequiredMinimumReceive	*uint32	`path:"required-minimum-receive" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Config.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef struct {
	Config	*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config	`path:"config" module:"openconfig-bfd"`
	State	*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State	`path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-bfd"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-bfd"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions struct {
	MicroBfdSession	map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession	`path:"micro-bfd-session" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) IsYANGGoStruct() {}

// NewMicroBfdSession creates a new entry in the MicroBfdSession list of the
// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) NewMicroBfdSession(MemberInterface string) (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.MicroBfdSession == nil {
		t.MicroBfdSession = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession)
	}

	key := MemberInterface

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.MicroBfdSession[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list MicroBfdSession", key)
	}

	t.MicroBfdSession[key] = &OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession{
		MemberInterface: &MemberInterface,
	}

	return t.MicroBfdSession[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession struct {
	Config	*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config	`path:"config" module:"openconfig-bfd"`
	MemberInterface	*string	`path:"member-interface" module:"openconfig-bfd"`
	State	*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State	`path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛListKeyMap() (map[string]interface{}, error) {
	if t.MemberInterface == nil {
		return nil, fmt.Errorf("nil value for key MemberInterface")
	}

	return map[string]interface{}{
		"member-interface": *t.MemberInterface,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config struct {
	LocalAddress	*string	`path:"local-address" module:"openconfig-bfd"`
	MemberInterface	*string	`path:"member-interface" module:"openconfig-bfd"`
	RemoteAddress	*string	`path:"remote-address" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State struct {
	Async	*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async	`path:"async" module:"openconfig-bfd"`
	DemandModeRequested	*bool	`path:"demand-mode-requested" module:"openconfig-bfd"`
	FailureTransitions	*uint64	`path:"failure-transitions" module:"openconfig-bfd"`
	LastFailureTime	*uint64	`path:"last-failure-time" module:"openconfig-bfd"`
	LocalAddress	*string	`path:"local-address" module:"openconfig-bfd"`
	LocalDiagnosticCode	E_OpenconfigBfd_BfdDiagnosticCode	`path:"local-diagnostic-code" module:"openconfig-bfd"`
	LocalDiscriminator	*string	`path:"local-discriminator" module:"openconfig-bfd"`
	MemberInterface	*string	`path:"member-interface" module:"openconfig-bfd"`
	RemoteAddress	*string	`path:"remote-address" module:"openconfig-bfd"`
	RemoteAuthenticationEnabled	*bool	`path:"remote-authentication-enabled" module:"openconfig-bfd"`
	RemoteControlPlaneIndependent	*bool	`path:"remote-control-plane-independent" module:"openconfig-bfd"`
	RemoteDiagnosticCode	E_OpenconfigBfd_BfdDiagnosticCode	`path:"remote-diagnostic-code" module:"openconfig-bfd"`
	RemoteDiscriminator	*string	`path:"remote-discriminator" module:"openconfig-bfd"`
	RemoteMinimumReceiveInterval	*uint32	`path:"remote-minimum-receive-interval" module:"openconfig-bfd"`
	RemoteSessionState	E_OpenconfigBfd_BfdSessionState	`path:"remote-session-state" module:"openconfig-bfd"`
	SessionState	E_OpenconfigBfd_BfdSessionState	`path:"session-state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async struct {
	LastPacketReceived	*uint64	`path:"last-packet-received" module:"openconfig-bfd"`
	LastPacketTransmitted	*uint64	`path:"last-packet-transmitted" module:"openconfig-bfd"`
	ReceivedPackets	*uint64	`path:"received-packets" module:"openconfig-bfd"`
	TransmittedPackets	*uint64	`path:"transmitted-packets" module:"openconfig-bfd"`
	UpTransitions	*uint64	`path:"up-transitions" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Peers represents the /openconfig-bfd/bfd/interfaces/interface/peers YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers struct {
	Peer	map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer	`path:"peer" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers) IsYANGGoStruct() {}

// NewPeer creates a new entry in the Peer list of the
// OpenconfigBfd_Bfd_Interfaces_Interface_Peers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) NewPeer(LocalDiscriminator string) (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Peer == nil {
		t.Peer = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer)
	}

	key := LocalDiscriminator

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Peer[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Peer", key)
	}

	t.Peer[key] = &OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer{
		LocalDiscriminator: &LocalDiscriminator,
	}

	return t.Peer[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer struct {
	LocalDiscriminator	*string	`path:"local-discriminator" module:"openconfig-bfd"`
	State	*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State	`path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛListKeyMap() (map[string]interface{}, error) {
	if t.LocalDiscriminator == nil {
		return nil, fmt.Errorf("nil value for key LocalDiscriminator")
	}

	return map[string]interface{}{
		"local-discriminator": *t.LocalDiscriminator,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State struct {
	Async	*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async	`path:"async" module:"openconfig-bfd"`
	DemandModeRequested	*bool	`path:"demand-mode-requested" module:"openconfig-bfd"`
	Echo	*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo	`path:"echo" module:"openconfig-bfd"`
	FailureTransitions	*uint64	`path:"failure-transitions" module:"openconfig-bfd"`
	LastFailureTime	*uint64	`path:"last-failure-time" module:"openconfig-bfd"`
	LocalAddress	*string	`path:"local-address" module:"openconfig-bfd"`
	LocalDiagnosticCode	E_OpenconfigBfd_BfdDiagnosticCode	`path:"local-diagnostic-code" module:"openconfig-bfd"`
	LocalDiscriminator	*string	`path:"local-discriminator" module:"openconfig-bfd"`
	RemoteAddress	*string	`path:"remote-address" module:"openconfig-bfd"`
	RemoteAuthenticationEnabled	*bool	`path:"remote-authentication-enabled" module:"openconfig-bfd"`
	RemoteControlPlaneIndependent	*bool	`path:"remote-control-plane-independent" module:"openconfig-bfd"`
	RemoteDiagnosticCode	E_OpenconfigBfd_BfdDiagnosticCode	`path:"remote-diagnostic-code" module:"openconfig-bfd"`
	RemoteDiscriminator	*string	`path:"remote-discriminator" module:"openconfig-bfd"`
	RemoteMinimumReceiveInterval	*uint32	`path:"remote-minimum-receive-interval" module:"openconfig-bfd"`
	RemoteSessionState	E_OpenconfigBfd_BfdSessionState	`path:"remote-session-state" module:"openconfig-bfd"`
	SessionState	E_OpenconfigBfd_BfdSessionState	`path:"session-state" module:"openconfig-bfd"`
	SubscribedProtocols	[]E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE	`path:"subscribed-protocols" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async struct {
	LastPacketReceived	*uint64	`path:"last-packet-received" module:"openconfig-bfd"`
	LastPacketTransmitted	*uint64	`path:"last-packet-transmitted" module:"openconfig-bfd"`
	ReceivedPackets	*uint64	`path:"received-packets" module:"openconfig-bfd"`
	TransmittedPackets	*uint64	`path:"transmitted-packets" module:"openconfig-bfd"`
	UpTransitions	*uint64	`path:"up-transitions" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo struct {
	Active	*bool	`path:"active" module:"openconfig-bfd"`
	LastPacketReceived	*uint64	`path:"last-packet-received" module:"openconfig-bfd"`
	LastPacketTransmitted	*uint64	`path:"last-packet-transmitted" module:"openconfig-bfd"`
	ReceivedPackets	*uint64	`path:"received-packets" module:"openconfig-bfd"`
	TransmittedPackets	*uint64	`path:"transmitted-packets" module:"openconfig-bfd"`
	UpTransitions	*uint64	`path:"up-transitions" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_State represents the /openconfig-bfd/bfd/interfaces/interface/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_State struct {
	DesiredMinimumTxInterval	*uint32	`path:"desired-minimum-tx-interval" module:"openconfig-bfd"`
	DetectionMultiplier	*uint8	`path:"detection-multiplier" module:"openconfig-bfd"`
	EnablePerMemberLink	*bool	`path:"enable-per-member-link" module:"openconfig-bfd"`
	Enabled	*bool	`path:"enabled" module:"openconfig-bfd"`
	Id	*string	`path:"id" module:"openconfig-bfd"`
	LocalAddress	*string	`path:"local-address" module:"openconfig-bfd"`
	RequiredMinimumReceive	*uint32	`path:"required-minimum-receive" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigDefinedSets_DefinedSets represents the /openconfig-defined-sets/defined-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets struct {
	Ipv4PrefixSets	*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets	`path:"ipv4-prefix-sets" module:"openconfig-defined-sets"`
	Ipv6PrefixSets	*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets	`path:"ipv6-prefix-sets" module:"openconfig-defined-sets"`
	PortSets	*OpenconfigDefinedSets_DefinedSets_PortSets	`path:"port-sets" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets.
func (*OpenconfigDefinedSets_DefinedSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets struct {
	Ipv4PrefixSet	map[string]*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet	`path:"ipv4-prefix-set" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) IsYANGGoStruct() {}

// NewIpv4PrefixSet creates a new entry in the Ipv4PrefixSet list of the
// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) NewIpv4PrefixSet(Name string) (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Ipv4PrefixSet == nil {
		t.Ipv4PrefixSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Ipv4PrefixSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Ipv4PrefixSet", key)
	}

	t.Ipv4PrefixSet[key] = &OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet{
		Name: &Name,
	}

	return t.Ipv4PrefixSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets/ipv4-prefix-set YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet struct {
	Config	*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config	`path:"config" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	State	*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State	`path:"state" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet struct, which is a YANG list entry.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets/ipv4-prefix-set/config YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Prefix	[]string	`path:"prefix" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets/ipv4-prefix-set/state YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Prefix	[]string	`path:"prefix" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets struct {
	Ipv6PrefixSet	map[string]*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet	`path:"ipv6-prefix-set" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) IsYANGGoStruct() {}

// NewIpv6PrefixSet creates a new entry in the Ipv6PrefixSet list of the
// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) NewIpv6PrefixSet(Name string) (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Ipv6PrefixSet == nil {
		t.Ipv6PrefixSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Ipv6PrefixSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Ipv6PrefixSet", key)
	}

	t.Ipv6PrefixSet[key] = &OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet{
		Name: &Name,
	}

	return t.Ipv6PrefixSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets/ipv6-prefix-set YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet struct {
	Config	*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config	`path:"config" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	State	*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State	`path:"state" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet struct, which is a YANG list entry.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets/ipv6-prefix-set/config YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Prefix	[]string	`path:"prefix" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets/ipv6-prefix-set/state YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Prefix	[]string	`path:"prefix" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_PortSets represents the /openconfig-defined-sets/defined-sets/port-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets struct {
	PortSet	map[string]*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet	`path:"port-set" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets) IsYANGGoStruct() {}

// NewPortSet creates a new entry in the PortSet list of the
// OpenconfigDefinedSets_DefinedSets_PortSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) NewPortSet(Name string) (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.PortSet == nil {
		t.PortSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.PortSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list PortSet", key)
	}

	t.PortSet[key] = &OpenconfigDefinedSets_DefinedSets_PortSets_PortSet{
		Name: &Name,
	}

	return t.PortSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets.
func (*OpenconfigDefinedSets_DefinedSets_PortSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet represents the /openconfig-defined-sets/defined-sets/port-sets/port-set YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet struct {
	Config	*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config	`path:"config" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	State	*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State	`path:"state" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets_PortSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet struct, which is a YANG list entry.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets_PortSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets_PortSet.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config represents the /openconfig-defined-sets/defined-sets/port-sets/port-set/config YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Port	[]OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union	`path:"port" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-defined-sets/defined-sets/port-sets/port-set/config/port within the YANG schema.
// Union type can be one of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, UnionString, UnionUint16].
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface {
	// Union type can be one of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, UnionString, UnionUint16]
	Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union()
}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union ensures that E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface.
func (E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union() {}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union ensures that UnionString
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface.
func (UnionString) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union() {}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union ensures that UnionUint16
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface.
func (UnionUint16) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union() {}

// To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union(i interface{}) (OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union, error) {
	if v, ok := i.(OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union, unknown union type, got: %T, want any of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, string, uint16]", i, i)
}


// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State represents the /openconfig-defined-sets/defined-sets/port-sets/port-set/state YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Port	[]OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union	`path:"port" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-defined-sets/defined-sets/port-sets/port-set/state/port within the YANG schema.
// Union type can be one of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, UnionString, UnionUint16].
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface {
	// Union type can be one of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, UnionString, UnionUint16]
	Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union()
}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union ensures that E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface.
func (E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union() {}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union ensures that UnionString
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface.
func (UnionString) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union() {}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union ensures that UnionUint16
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface.
func (UnionUint16) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union() {}

// To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union(i interface{}) (OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union, error) {
	if v, ok := i.(OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union, unknown union type, got: %T, want any of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces represents the /openconfig-interfaces/interfaces YANG schema element.
type OpenconfigInterfaces_Interfaces struct {
	Interface	map[string]*OpenconfigInterfaces_Interfaces_Interface	`path:"interface" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigInterfaces_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces) NewInterface(Name string) (*OpenconfigInterfaces_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigInterfaces_Interfaces_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces.
func (*OpenconfigInterfaces_Interfaces) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface represents the /openconfig-interfaces/interfaces/interface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface struct {
	Aggregation	*OpenconfigInterfaces_Interfaces_Interface_Aggregation	`path:"aggregation" module:"openconfig-if-aggregate"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_Config	`path:"config" module:"openconfig-interfaces"`
	Ethernet	*OpenconfigInterfaces_Interfaces_Interface_Ethernet	`path:"ethernet" module:"openconfig-if-ethernet"`
	HoldTime	*OpenconfigInterfaces_Interfaces_Interface_HoldTime	`path:"hold-time" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	RoutedVlan	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan	`path:"routed-vlan" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_State	`path:"state" module:"openconfig-interfaces"`
	Subinterfaces	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces	`path:"subinterfaces" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface.
func (*OpenconfigInterfaces_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation represents the /openconfig-interfaces/interfaces/interface/aggregation YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config	`path:"config" module:"openconfig-if-aggregate"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Aggregation_State	`path:"state" module:"openconfig-if-aggregate"`
	SwitchedVlan	*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan	`path:"switched-vlan" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation) ΛBelongingModule() string {
	return "openconfig-if-aggregate"
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config represents the /openconfig-interfaces/interfaces/interface/aggregation/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config struct {
	LagType	E_OpenconfigIfAggregate_AggregationType	`path:"lag-type" module:"openconfig-if-aggregate"`
	MinLinks	*uint16	`path:"min-links" module:"openconfig-if-aggregate"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) ΛBelongingModule() string {
	return "openconfig-if-aggregate"
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation_State represents the /openconfig-interfaces/interfaces/interface/aggregation/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_State struct {
	LagSpeed	*uint32	`path:"lag-speed" module:"openconfig-if-aggregate"`
	LagType	E_OpenconfigIfAggregate_AggregationType	`path:"lag-type" module:"openconfig-if-aggregate"`
	Member	[]string	`path:"member" module:"openconfig-if-aggregate"`
	MinLinks	*uint16	`path:"min-links" module:"openconfig-if-aggregate"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) ΛBelongingModule() string {
	return "openconfig-if-aggregate"
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan represents the /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config represents the /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config struct {
	AccessVlan	*uint16	`path:"access-vlan" module:"openconfig-vlan"`
	InterfaceMode	E_OpenconfigVlan_VlanModeType	`path:"interface-mode" module:"openconfig-vlan"`
	NativeVlan	*uint16	`path:"native-vlan" module:"openconfig-vlan"`
	TrunkVlans	[]OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union	`path:"trunk-vlans" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/config/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State represents the /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State struct {
	AccessVlan	*uint16	`path:"access-vlan" module:"openconfig-vlan"`
	InterfaceMode	E_OpenconfigVlan_VlanModeType	`path:"interface-mode" module:"openconfig-vlan"`
	NativeVlan	*uint16	`path:"native-vlan" module:"openconfig-vlan"`
	TrunkVlans	[]OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union	`path:"trunk-vlans" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/state/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_Config represents the /openconfig-interfaces/interfaces/interface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Config struct {
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	LoopbackMode	*bool	`path:"loopback-mode" module:"openconfig-interfaces"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	Type	E_IETFInterfaces_InterfaceType	`path:"type" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet represents the /openconfig-interfaces/interfaces/interface/ethernet YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config	`path:"config" module:"openconfig-if-ethernet"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State	`path:"state" module:"openconfig-if-ethernet"`
	SwitchedVlan	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan	`path:"switched-vlan" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config represents the /openconfig-interfaces/interfaces/interface/ethernet/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config struct {
	AggregateId	*string	`path:"aggregate-id" module:"openconfig-if-aggregate"`
	AutoNegotiate	*bool	`path:"auto-negotiate" module:"openconfig-if-ethernet"`
	DuplexMode	E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode	`path:"duplex-mode" module:"openconfig-if-ethernet"`
	EnableFlowControl	*bool	`path:"enable-flow-control" module:"openconfig-if-ethernet"`
	FecMode	E_OpenconfigIfEthernet_INTERFACE_FEC	`path:"fec-mode" module:"openconfig-if-ethernet"`
	MacAddress	*string	`path:"mac-address" module:"openconfig-if-ethernet"`
	PortSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"port-speed" module:"openconfig-if-ethernet"`
	StandaloneLinkTraining	*bool	`path:"standalone-link-training" module:"openconfig-if-ethernet"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State represents the /openconfig-interfaces/interfaces/interface/ethernet/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_State struct {
	AggregateId	*string	`path:"aggregate-id" module:"openconfig-if-aggregate"`
	AutoNegotiate	*bool	`path:"auto-negotiate" module:"openconfig-if-ethernet"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters	`path:"counters" module:"openconfig-if-ethernet"`
	DuplexMode	E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode	`path:"duplex-mode" module:"openconfig-if-ethernet"`
	EnableFlowControl	*bool	`path:"enable-flow-control" module:"openconfig-if-ethernet"`
	FecMode	E_OpenconfigIfEthernet_INTERFACE_FEC	`path:"fec-mode" module:"openconfig-if-ethernet"`
	HwMacAddress	*string	`path:"hw-mac-address" module:"openconfig-if-ethernet"`
	MacAddress	*string	`path:"mac-address" module:"openconfig-if-ethernet"`
	NegotiatedDuplexMode	E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode	`path:"negotiated-duplex-mode" module:"openconfig-if-ethernet"`
	NegotiatedPortSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"negotiated-port-speed" module:"openconfig-if-ethernet"`
	PortSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"port-speed" module:"openconfig-if-ethernet"`
	StandaloneLinkTraining	*bool	`path:"standalone-link-training" module:"openconfig-if-ethernet"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters represents the /openconfig-interfaces/interfaces/interface/ethernet/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters struct {
	In_8021QFrames	*uint64	`path:"in-8021q-frames" module:"openconfig-if-ethernet"`
	InBlockErrors	*uint64	`path:"in-block-errors" module:"openconfig-if-ethernet"`
	InCarrierErrors	*uint64	`path:"in-carrier-errors" module:"openconfig-if-ethernet"`
	InCrcErrors	*uint64	`path:"in-crc-errors" module:"openconfig-if-ethernet"`
	InFragmentFrames	*uint64	`path:"in-fragment-frames" module:"openconfig-if-ethernet"`
	InInterruptedTx	*uint64	`path:"in-interrupted-tx" module:"openconfig-if-ethernet"`
	InJabberFrames	*uint64	`path:"in-jabber-frames" module:"openconfig-if-ethernet"`
	InLateCollision	*uint64	`path:"in-late-collision" module:"openconfig-if-ethernet"`
	InMacControlFrames	*uint64	`path:"in-mac-control-frames" module:"openconfig-if-ethernet"`
	InMacErrorsRx	*uint64	`path:"in-mac-errors-rx" module:"openconfig-if-ethernet"`
	InMacPauseFrames	*uint64	`path:"in-mac-pause-frames" module:"openconfig-if-ethernet"`
	InMaxsizeExceeded	*uint64	`path:"in-maxsize-exceeded" module:"openconfig-if-ethernet"`
	InOversizeFrames	*uint64	`path:"in-oversize-frames" module:"openconfig-if-ethernet"`
	InSingleCollision	*uint64	`path:"in-single-collision" module:"openconfig-if-ethernet"`
	InSymbolError	*uint64	`path:"in-symbol-error" module:"openconfig-if-ethernet"`
	InUndersizeFrames	*uint64	`path:"in-undersize-frames" module:"openconfig-if-ethernet"`
	Out_8021QFrames	*uint64	`path:"out-8021q-frames" module:"openconfig-if-ethernet"`
	OutMacControlFrames	*uint64	`path:"out-mac-control-frames" module:"openconfig-if-ethernet"`
	OutMacErrorsTx	*uint64	`path:"out-mac-errors-tx" module:"openconfig-if-ethernet"`
	OutMacPauseFrames	*uint64	`path:"out-mac-pause-frames" module:"openconfig-if-ethernet"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan represents the /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config represents the /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config struct {
	AccessVlan	*uint16	`path:"access-vlan" module:"openconfig-vlan"`
	InterfaceMode	E_OpenconfigVlan_VlanModeType	`path:"interface-mode" module:"openconfig-vlan"`
	NativeVlan	*uint16	`path:"native-vlan" module:"openconfig-vlan"`
	TrunkVlans	[]OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union	`path:"trunk-vlans" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/config/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State represents the /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State struct {
	AccessVlan	*uint16	`path:"access-vlan" module:"openconfig-vlan"`
	InterfaceMode	E_OpenconfigVlan_VlanModeType	`path:"interface-mode" module:"openconfig-vlan"`
	NativeVlan	*uint16	`path:"native-vlan" module:"openconfig-vlan"`
	TrunkVlans	[]OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union	`path:"trunk-vlans" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/state/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_HoldTime represents the /openconfig-interfaces/interfaces/interface/hold-time YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config	`path:"config" module:"openconfig-interfaces"`
	State	*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State	`path:"state" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config represents the /openconfig-interfaces/interfaces/interface/hold-time/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config struct {
	Down	*uint32	`path:"down" module:"openconfig-interfaces"`
	Up	*uint32	`path:"up" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_HoldTime_State represents the /openconfig-interfaces/interfaces/interface/hold-time/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime_State struct {
	Down	*uint32	`path:"down" module:"openconfig-interfaces"`
	Up	*uint32	`path:"up" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime_State.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan represents the /openconfig-interfaces/interfaces/interface/routed-vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config	`path:"config" module:"openconfig-vlan"`
	Ipv4	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4	`path:"ipv4" module:"openconfig-if-ip"`
	Ipv6	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6	`path:"ipv6" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config struct {
	Vlan	OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union	`path:"vlan" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/routed-vlan/config/vlan within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4 represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4 YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4 struct {
	Addresses	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses	`path:"addresses" module:"openconfig-if-ip"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config	`path:"config" module:"openconfig-if-ip"`
	Neighbors	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors	`path:"neighbors" module:"openconfig-if-ip"`
	ProxyArp	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp	`path:"proxy-arp" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State	`path:"state" module:"openconfig-if-ip"`
	Unnumbered	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered	`path:"unnumbered" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses struct {
	Address	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address	`path:"address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) IsYANGGoStruct() {}

// NewAddress creates a new entry in the Address list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) NewAddress(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Address == nil {
		t.Address = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Address[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Address", key)
	}

	t.Address[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address{
		Ip: &Ip,
	}

	return t.Address[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State	`path:"state" module:"openconfig-if-ip"`
	Vrrp	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp	`path:"vrrp" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_IpAddressOrigin	`path:"origin" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp struct {
	VrrpGroup	map[uint8]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup	`path:"vrrp-group" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) IsYANGGoStruct() {}

// NewVrrpGroup creates a new entry in the VrrpGroup list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) NewVrrpGroup(VirtualRouterId uint8) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VrrpGroup == nil {
		t.VrrpGroup = make(map[uint8]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup)
	}

	key := VirtualRouterId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VrrpGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VrrpGroup", key)
	}

	t.VrrpGroup[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup{
		VirtualRouterId: &VirtualRouterId,
	}

	return t.VrrpGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceTracking	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking	`path:"interface-tracking" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State	`path:"state" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.VirtualRouterId == nil {
		return nil, fmt.Errorf("nil value for key VirtualRouterId")
	}

	return map[string]interface{}{
		"virtual-router-id": *t.VirtualRouterId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddress	[]string	`path:"virtual-address" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/interface-tracking YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/interface-tracking/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config struct {
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"openconfig-if-ip"`
	TrackInterface	[]string	`path:"track-interface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/interface-tracking/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State struct {
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"openconfig-if-ip"`
	TrackInterface	[]string	`path:"track-interface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	CurrentPriority	*uint8	`path:"current-priority" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddress	[]string	`path:"virtual-address" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config struct {
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/neighbors YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors struct {
	Neighbor	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) NewNeighbor(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor{
		Ip: &Ip,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/neighbors/neighbor YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/neighbors/neighbor/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/neighbors/neighbor/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_NeighborOrigin	`path:"origin" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/proxy-arp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/proxy-arp/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config struct {
	Mode	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config_Mode	`path:"mode" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/proxy-arp/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State struct {
	Mode	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config_Mode	`path:"mode" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State struct {
	Counters	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters	`path:"counters" module:"openconfig-if-ip"`
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters struct {
	InDiscardedPkts	*uint64	`path:"in-discarded-pkts" module:"openconfig-if-ip"`
	InErrorPkts	*uint64	`path:"in-error-pkts" module:"openconfig-if-ip"`
	InForwardedOctets	*uint64	`path:"in-forwarded-octets" module:"openconfig-if-ip"`
	InForwardedPkts	*uint64	`path:"in-forwarded-pkts" module:"openconfig-if-ip"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-if-ip"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-if-ip"`
	OutDiscardedPkts	*uint64	`path:"out-discarded-pkts" module:"openconfig-if-ip"`
	OutErrorPkts	*uint64	`path:"out-error-pkts" module:"openconfig-if-ip"`
	OutForwardedOctets	*uint64	`path:"out-forwarded-octets" module:"openconfig-if-ip"`
	OutForwardedPkts	*uint64	`path:"out-forwarded-pkts" module:"openconfig-if-ip"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-if-ip"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceRef	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef	`path:"interface-ref" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered/interface-ref YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered/interface-ref/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered/interface-ref/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6 represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6 YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6 struct {
	Addresses	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses	`path:"addresses" module:"openconfig-if-ip"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config	`path:"config" module:"openconfig-if-ip"`
	Neighbors	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors	`path:"neighbors" module:"openconfig-if-ip"`
	RouterAdvertisement	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement	`path:"router-advertisement" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State	`path:"state" module:"openconfig-if-ip"`
	Unnumbered	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered	`path:"unnumbered" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses struct {
	Address	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address	`path:"address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) IsYANGGoStruct() {}

// NewAddress creates a new entry in the Address list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) NewAddress(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Address == nil {
		t.Address = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Address[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Address", key)
	}

	t.Address[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address{
		Ip: &Ip,
	}

	return t.Address[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State	`path:"state" module:"openconfig-if-ip"`
	Vrrp	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp	`path:"vrrp" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_IpAddressOrigin	`path:"origin" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
	Status	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State_Status	`path:"status" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp struct {
	VrrpGroup	map[uint8]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup	`path:"vrrp-group" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) IsYANGGoStruct() {}

// NewVrrpGroup creates a new entry in the VrrpGroup list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) NewVrrpGroup(VirtualRouterId uint8) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VrrpGroup == nil {
		t.VrrpGroup = make(map[uint8]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup)
	}

	key := VirtualRouterId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VrrpGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VrrpGroup", key)
	}

	t.VrrpGroup[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup{
		VirtualRouterId: &VirtualRouterId,
	}

	return t.VrrpGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceTracking	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking	`path:"interface-tracking" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State	`path:"state" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.VirtualRouterId == nil {
		return nil, fmt.Errorf("nil value for key VirtualRouterId")
	}

	return map[string]interface{}{
		"virtual-router-id": *t.VirtualRouterId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddress	[]string	`path:"virtual-address" module:"openconfig-if-ip"`
	VirtualLinkLocal	*string	`path:"virtual-link-local" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/interface-tracking YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/interface-tracking/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config struct {
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"openconfig-if-ip"`
	TrackInterface	[]string	`path:"track-interface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/interface-tracking/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State struct {
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"openconfig-if-ip"`
	TrackInterface	[]string	`path:"track-interface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	CurrentPriority	*uint8	`path:"current-priority" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddress	[]string	`path:"virtual-address" module:"openconfig-if-ip"`
	VirtualLinkLocal	*string	`path:"virtual-link-local" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config struct {
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	DupAddrDetectTransmits	*uint32	`path:"dup-addr-detect-transmits" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint32	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/neighbors YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors struct {
	Neighbor	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) NewNeighbor(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor{
		Ip: &Ip,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/neighbors/neighbor YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/neighbors/neighbor/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/neighbors/neighbor/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	IsRouter	*bool	`path:"is-router" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
	NeighborState	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State_NeighborState	`path:"neighbor-state" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_NeighborOrigin	`path:"origin" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config	`path:"config" module:"openconfig-if-ip"`
	Prefixes	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes	`path:"prefixes" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config struct {
	Interval	*uint32	`path:"interval" module:"openconfig-if-ip"`
	Lifetime	*uint32	`path:"lifetime" module:"openconfig-if-ip"`
	Managed	*bool	`path:"managed" module:"openconfig-if-ip"`
	OtherConfig	*bool	`path:"other-config" module:"openconfig-if-ip"`
	Suppress	*bool	`path:"suppress" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/prefixes YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes struct {
	Prefix	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix	`path:"prefix" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) IsYANGGoStruct() {}

// NewPrefix creates a new entry in the Prefix list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) NewPrefix(Prefix string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Prefix == nil {
		t.Prefix = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix)
	}

	key := Prefix

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Prefix[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Prefix", key)
	}

	t.Prefix[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix{
		Prefix: &Prefix,
	}

	return t.Prefix[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/prefixes/prefix YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config	`path:"config" module:"openconfig-if-ip"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"prefix": *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/prefixes/prefix/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config struct {
	DisableAdvertisement	*bool	`path:"disable-advertisement" module:"openconfig-if-ip"`
	DisableAutoconfiguration	*bool	`path:"disable-autoconfiguration" module:"openconfig-if-ip"`
	EnableOnlink	*bool	`path:"enable-onlink" module:"openconfig-if-ip"`
	PreferredLifetime	*uint32	`path:"preferred-lifetime" module:"openconfig-if-ip"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-ip"`
	ValidLifetime	*uint32	`path:"valid-lifetime" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/prefixes/prefix/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State struct {
	DisableAdvertisement	*bool	`path:"disable-advertisement" module:"openconfig-if-ip"`
	DisableAutoconfiguration	*bool	`path:"disable-autoconfiguration" module:"openconfig-if-ip"`
	EnableOnlink	*bool	`path:"enable-onlink" module:"openconfig-if-ip"`
	PreferredLifetime	*uint32	`path:"preferred-lifetime" module:"openconfig-if-ip"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-ip"`
	ValidLifetime	*uint32	`path:"valid-lifetime" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State struct {
	Interval	*uint32	`path:"interval" module:"openconfig-if-ip"`
	Lifetime	*uint32	`path:"lifetime" module:"openconfig-if-ip"`
	Managed	*bool	`path:"managed" module:"openconfig-if-ip"`
	OtherConfig	*bool	`path:"other-config" module:"openconfig-if-ip"`
	Suppress	*bool	`path:"suppress" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State struct {
	Counters	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters	`path:"counters" module:"openconfig-if-ip"`
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	DupAddrDetectTransmits	*uint32	`path:"dup-addr-detect-transmits" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint32	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters struct {
	InDiscardedPkts	*uint64	`path:"in-discarded-pkts" module:"openconfig-if-ip"`
	InErrorPkts	*uint64	`path:"in-error-pkts" module:"openconfig-if-ip"`
	InForwardedOctets	*uint64	`path:"in-forwarded-octets" module:"openconfig-if-ip"`
	InForwardedPkts	*uint64	`path:"in-forwarded-pkts" module:"openconfig-if-ip"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-if-ip"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-if-ip"`
	OutDiscardedPkts	*uint64	`path:"out-discarded-pkts" module:"openconfig-if-ip"`
	OutErrorPkts	*uint64	`path:"out-error-pkts" module:"openconfig-if-ip"`
	OutForwardedOctets	*uint64	`path:"out-forwarded-octets" module:"openconfig-if-ip"`
	OutForwardedPkts	*uint64	`path:"out-forwarded-pkts" module:"openconfig-if-ip"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-if-ip"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceRef	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef	`path:"interface-ref" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered/interface-ref YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered/interface-ref/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered/interface-ref/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State struct {
	Vlan	OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union	`path:"vlan" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/routed-vlan/state/vlan within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_State represents the /openconfig-interfaces/interfaces/interface/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_State struct {
	AdminStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus	`path:"admin-status" module:"openconfig-interfaces"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_State_Counters	`path:"counters" module:"openconfig-interfaces"`
	Cpu	*bool	`path:"cpu" module:"openconfig-interfaces"`
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Ifindex	*uint32	`path:"ifindex" module:"openconfig-interfaces"`
	LastChange	*uint64	`path:"last-change" module:"openconfig-interfaces"`
	Logical	*bool	`path:"logical" module:"openconfig-interfaces"`
	LoopbackMode	*bool	`path:"loopback-mode" module:"openconfig-interfaces"`
	Management	*bool	`path:"management" module:"openconfig-interfaces"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	OperStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus	`path:"oper-status" module:"openconfig-interfaces"`
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	Type	E_IETFInterfaces_InterfaceType	`path:"type" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_State.
func (*OpenconfigInterfaces_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_State_Counters represents the /openconfig-interfaces/interfaces/interface/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_State_Counters struct {
	CarrierTransitions	*uint64	`path:"carrier-transitions" module:"openconfig-interfaces"`
	InBroadcastPkts	*uint64	`path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	InDiscards	*uint64	`path:"in-discards" module:"openconfig-interfaces"`
	InErrors	*uint64	`path:"in-errors" module:"openconfig-interfaces"`
	InFcsErrors	*uint64	`path:"in-fcs-errors" module:"openconfig-interfaces"`
	InMulticastPkts	*uint64	`path:"in-multicast-pkts" module:"openconfig-interfaces"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-interfaces"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-interfaces"`
	InUnicastPkts	*uint64	`path:"in-unicast-pkts" module:"openconfig-interfaces"`
	InUnknownProtos	*uint64	`path:"in-unknown-protos" module:"openconfig-interfaces"`
	LastClear	*uint64	`path:"last-clear" module:"openconfig-interfaces"`
	OutBroadcastPkts	*uint64	`path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	OutDiscards	*uint64	`path:"out-discards" module:"openconfig-interfaces"`
	OutErrors	*uint64	`path:"out-errors" module:"openconfig-interfaces"`
	OutMulticastPkts	*uint64	`path:"out-multicast-pkts" module:"openconfig-interfaces"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-interfaces"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-interfaces"`
	OutUnicastPkts	*uint64	`path:"out-unicast-pkts" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces represents the /openconfig-interfaces/interfaces/interface/subinterfaces YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct {
	Subinterface	map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface	`path:"subinterface" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) IsYANGGoStruct() {}

// NewSubinterface creates a new entry in the Subinterface list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) NewSubinterface(Index uint32) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subinterface == nil {
		t.Subinterface = make(map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Subinterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Subinterface", key)
	}

	t.Subinterface[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface{
		Index: &Index,
	}

	return t.Subinterface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config	`path:"config" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
	Ipv4	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4	`path:"ipv4" module:"openconfig-if-ip"`
	Ipv6	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6	`path:"ipv6" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State	`path:"state" module:"openconfig-interfaces"`
	Vlan	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan	`path:"vlan" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config struct {
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4 represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4 YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4 struct {
	Addresses	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses	`path:"addresses" module:"openconfig-if-ip"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config	`path:"config" module:"openconfig-if-ip"`
	Neighbors	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors	`path:"neighbors" module:"openconfig-if-ip"`
	ProxyArp	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp	`path:"proxy-arp" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State	`path:"state" module:"openconfig-if-ip"`
	Unnumbered	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered	`path:"unnumbered" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses struct {
	Address	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address	`path:"address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) IsYANGGoStruct() {}

// NewAddress creates a new entry in the Address list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) NewAddress(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Address == nil {
		t.Address = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Address[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Address", key)
	}

	t.Address[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address{
		Ip: &Ip,
	}

	return t.Address[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State	`path:"state" module:"openconfig-if-ip"`
	Vrrp	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp	`path:"vrrp" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_IpAddressOrigin	`path:"origin" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp struct {
	VrrpGroup	map[uint8]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup	`path:"vrrp-group" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) IsYANGGoStruct() {}

// NewVrrpGroup creates a new entry in the VrrpGroup list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) NewVrrpGroup(VirtualRouterId uint8) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VrrpGroup == nil {
		t.VrrpGroup = make(map[uint8]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup)
	}

	key := VirtualRouterId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VrrpGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VrrpGroup", key)
	}

	t.VrrpGroup[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup{
		VirtualRouterId: &VirtualRouterId,
	}

	return t.VrrpGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceTracking	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking	`path:"interface-tracking" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State	`path:"state" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.VirtualRouterId == nil {
		return nil, fmt.Errorf("nil value for key VirtualRouterId")
	}

	return map[string]interface{}{
		"virtual-router-id": *t.VirtualRouterId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddress	[]string	`path:"virtual-address" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/interface-tracking YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/interface-tracking/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config struct {
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"openconfig-if-ip"`
	TrackInterface	[]string	`path:"track-interface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/interface-tracking/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State struct {
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"openconfig-if-ip"`
	TrackInterface	[]string	`path:"track-interface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	CurrentPriority	*uint8	`path:"current-priority" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddress	[]string	`path:"virtual-address" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config struct {
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/neighbors YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors struct {
	Neighbor	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) NewNeighbor(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor{
		Ip: &Ip,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/neighbors/neighbor YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/neighbors/neighbor/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/neighbors/neighbor/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_NeighborOrigin	`path:"origin" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/proxy-arp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/proxy-arp/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config struct {
	Mode	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config_Mode	`path:"mode" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/proxy-arp/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State struct {
	Mode	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config_Mode	`path:"mode" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_ProxyArp_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State struct {
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters	`path:"counters" module:"openconfig-if-ip"`
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters struct {
	InDiscardedPkts	*uint64	`path:"in-discarded-pkts" module:"openconfig-if-ip"`
	InErrorPkts	*uint64	`path:"in-error-pkts" module:"openconfig-if-ip"`
	InForwardedOctets	*uint64	`path:"in-forwarded-octets" module:"openconfig-if-ip"`
	InForwardedPkts	*uint64	`path:"in-forwarded-pkts" module:"openconfig-if-ip"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-if-ip"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-if-ip"`
	OutDiscardedPkts	*uint64	`path:"out-discarded-pkts" module:"openconfig-if-ip"`
	OutErrorPkts	*uint64	`path:"out-error-pkts" module:"openconfig-if-ip"`
	OutForwardedOctets	*uint64	`path:"out-forwarded-octets" module:"openconfig-if-ip"`
	OutForwardedPkts	*uint64	`path:"out-forwarded-pkts" module:"openconfig-if-ip"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-if-ip"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceRef	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef	`path:"interface-ref" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered/interface-ref YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered/interface-ref/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered/interface-ref/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6 represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6 YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6 struct {
	Addresses	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses	`path:"addresses" module:"openconfig-if-ip"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config	`path:"config" module:"openconfig-if-ip"`
	Neighbors	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors	`path:"neighbors" module:"openconfig-if-ip"`
	RouterAdvertisement	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement	`path:"router-advertisement" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State	`path:"state" module:"openconfig-if-ip"`
	Unnumbered	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered	`path:"unnumbered" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses struct {
	Address	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address	`path:"address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) IsYANGGoStruct() {}

// NewAddress creates a new entry in the Address list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) NewAddress(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Address == nil {
		t.Address = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Address[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Address", key)
	}

	t.Address[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address{
		Ip: &Ip,
	}

	return t.Address[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State	`path:"state" module:"openconfig-if-ip"`
	Vrrp	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp	`path:"vrrp" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_IpAddressOrigin	`path:"origin" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
	Status	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State_Status	`path:"status" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp struct {
	VrrpGroup	map[uint8]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup	`path:"vrrp-group" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) IsYANGGoStruct() {}

// NewVrrpGroup creates a new entry in the VrrpGroup list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) NewVrrpGroup(VirtualRouterId uint8) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VrrpGroup == nil {
		t.VrrpGroup = make(map[uint8]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup)
	}

	key := VirtualRouterId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VrrpGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VrrpGroup", key)
	}

	t.VrrpGroup[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup{
		VirtualRouterId: &VirtualRouterId,
	}

	return t.VrrpGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceTracking	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking	`path:"interface-tracking" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State	`path:"state" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.VirtualRouterId == nil {
		return nil, fmt.Errorf("nil value for key VirtualRouterId")
	}

	return map[string]interface{}{
		"virtual-router-id": *t.VirtualRouterId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddress	[]string	`path:"virtual-address" module:"openconfig-if-ip"`
	VirtualLinkLocal	*string	`path:"virtual-link-local" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/interface-tracking YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/interface-tracking/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config struct {
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"openconfig-if-ip"`
	TrackInterface	[]string	`path:"track-interface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/interface-tracking/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State struct {
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"openconfig-if-ip"`
	TrackInterface	[]string	`path:"track-interface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_InterfaceTracking_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	CurrentPriority	*uint8	`path:"current-priority" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddress	[]string	`path:"virtual-address" module:"openconfig-if-ip"`
	VirtualLinkLocal	*string	`path:"virtual-link-local" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config struct {
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	DupAddrDetectTransmits	*uint32	`path:"dup-addr-detect-transmits" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint32	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/neighbors YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors struct {
	Neighbor	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) NewNeighbor(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor{
		Ip: &Ip,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/neighbors/neighbor YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/neighbors/neighbor/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/neighbors/neighbor/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	IsRouter	*bool	`path:"is-router" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
	NeighborState	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State_NeighborState	`path:"neighbor-state" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_NeighborOrigin	`path:"origin" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/router-advertisement YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config	`path:"config" module:"openconfig-if-ip"`
	Prefixes	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes	`path:"prefixes" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/router-advertisement/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config struct {
	Interval	*uint32	`path:"interval" module:"openconfig-if-ip"`
	Lifetime	*uint32	`path:"lifetime" module:"openconfig-if-ip"`
	Managed	*bool	`path:"managed" module:"openconfig-if-ip"`
	OtherConfig	*bool	`path:"other-config" module:"openconfig-if-ip"`
	Suppress	*bool	`path:"suppress" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/router-advertisement/prefixes YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes struct {
	Prefix	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix	`path:"prefix" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes) IsYANGGoStruct() {}

// NewPrefix creates a new entry in the Prefix list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes) NewPrefix(Prefix string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Prefix == nil {
		t.Prefix = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix)
	}

	key := Prefix

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Prefix[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Prefix", key)
	}

	t.Prefix[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix{
		Prefix: &Prefix,
	}

	return t.Prefix[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/router-advertisement/prefixes/prefix YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config	`path:"config" module:"openconfig-if-ip"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"prefix": *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/router-advertisement/prefixes/prefix/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config struct {
	DisableAdvertisement	*bool	`path:"disable-advertisement" module:"openconfig-if-ip"`
	DisableAutoconfiguration	*bool	`path:"disable-autoconfiguration" module:"openconfig-if-ip"`
	EnableOnlink	*bool	`path:"enable-onlink" module:"openconfig-if-ip"`
	PreferredLifetime	*uint32	`path:"preferred-lifetime" module:"openconfig-if-ip"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-ip"`
	ValidLifetime	*uint32	`path:"valid-lifetime" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/router-advertisement/prefixes/prefix/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State struct {
	DisableAdvertisement	*bool	`path:"disable-advertisement" module:"openconfig-if-ip"`
	DisableAutoconfiguration	*bool	`path:"disable-autoconfiguration" module:"openconfig-if-ip"`
	EnableOnlink	*bool	`path:"enable-onlink" module:"openconfig-if-ip"`
	PreferredLifetime	*uint32	`path:"preferred-lifetime" module:"openconfig-if-ip"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-ip"`
	ValidLifetime	*uint32	`path:"valid-lifetime" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/router-advertisement/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State struct {
	Interval	*uint32	`path:"interval" module:"openconfig-if-ip"`
	Lifetime	*uint32	`path:"lifetime" module:"openconfig-if-ip"`
	Managed	*bool	`path:"managed" module:"openconfig-if-ip"`
	OtherConfig	*bool	`path:"other-config" module:"openconfig-if-ip"`
	Suppress	*bool	`path:"suppress" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_RouterAdvertisement_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State struct {
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters	`path:"counters" module:"openconfig-if-ip"`
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	DupAddrDetectTransmits	*uint32	`path:"dup-addr-detect-transmits" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint32	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters struct {
	InDiscardedPkts	*uint64	`path:"in-discarded-pkts" module:"openconfig-if-ip"`
	InErrorPkts	*uint64	`path:"in-error-pkts" module:"openconfig-if-ip"`
	InForwardedOctets	*uint64	`path:"in-forwarded-octets" module:"openconfig-if-ip"`
	InForwardedPkts	*uint64	`path:"in-forwarded-pkts" module:"openconfig-if-ip"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-if-ip"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-if-ip"`
	OutDiscardedPkts	*uint64	`path:"out-discarded-pkts" module:"openconfig-if-ip"`
	OutErrorPkts	*uint64	`path:"out-error-pkts" module:"openconfig-if-ip"`
	OutForwardedOctets	*uint64	`path:"out-forwarded-octets" module:"openconfig-if-ip"`
	OutForwardedPkts	*uint64	`path:"out-forwarded-pkts" module:"openconfig-if-ip"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-if-ip"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceRef	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef	`path:"interface-ref" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered/interface-ref YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered/interface-ref/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered/interface-ref/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State struct {
	AdminStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus	`path:"admin-status" module:"openconfig-interfaces"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters	`path:"counters" module:"openconfig-interfaces"`
	Cpu	*bool	`path:"cpu" module:"openconfig-interfaces"`
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Ifindex	*uint32	`path:"ifindex" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
	LastChange	*uint64	`path:"last-change" module:"openconfig-interfaces"`
	Logical	*bool	`path:"logical" module:"openconfig-interfaces"`
	Management	*bool	`path:"management" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	OperStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus	`path:"oper-status" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters struct {
	CarrierTransitions	*uint64	`path:"carrier-transitions" module:"openconfig-interfaces"`
	InBroadcastPkts	*uint64	`path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	InDiscards	*uint64	`path:"in-discards" module:"openconfig-interfaces"`
	InErrors	*uint64	`path:"in-errors" module:"openconfig-interfaces"`
	InFcsErrors	*uint64	`path:"in-fcs-errors" module:"openconfig-interfaces"`
	InMulticastPkts	*uint64	`path:"in-multicast-pkts" module:"openconfig-interfaces"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-interfaces"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-interfaces"`
	InUnicastPkts	*uint64	`path:"in-unicast-pkts" module:"openconfig-interfaces"`
	InUnknownProtos	*uint64	`path:"in-unknown-protos" module:"openconfig-interfaces"`
	LastClear	*uint64	`path:"last-clear" module:"openconfig-interfaces"`
	OutBroadcastPkts	*uint64	`path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	OutDiscards	*uint64	`path:"out-discards" module:"openconfig-interfaces"`
	OutErrors	*uint64	`path:"out-errors" module:"openconfig-interfaces"`
	OutMulticastPkts	*uint64	`path:"out-multicast-pkts" module:"openconfig-interfaces"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-interfaces"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-interfaces"`
	OutUnicastPkts	*uint64	`path:"out-unicast-pkts" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config	`path:"config" module:"openconfig-vlan"`
	EgressMapping	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping	`path:"egress-mapping" module:"openconfig-vlan"`
	IngressMapping	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping	`path:"ingress-mapping" module:"openconfig-vlan"`
	Match	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match	`path:"match" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config struct {
	VlanId	OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union	`path:"vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/config/vlan-id within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/egress-mapping YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/egress-mapping/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config struct {
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
	VlanStackAction	E_OpenconfigVlan_VlanStackAction	`path:"vlan-stack-action" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/egress-mapping/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State struct {
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
	VlanStackAction	E_OpenconfigVlan_VlanStackAction	`path:"vlan-stack-action" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/ingress-mapping YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/ingress-mapping/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config struct {
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
	VlanStackAction	E_OpenconfigVlan_VlanStackAction	`path:"vlan-stack-action" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/ingress-mapping/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State struct {
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
	VlanStackAction	E_OpenconfigVlan_VlanStackAction	`path:"vlan-stack-action" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match struct {
	DoubleTagged	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged	`path:"double-tagged" module:"openconfig-vlan"`
	DoubleTaggedInnerList	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList	`path:"double-tagged-inner-list" module:"openconfig-vlan"`
	DoubleTaggedInnerOuterRange	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange	`path:"double-tagged-inner-outer-range" module:"openconfig-vlan"`
	DoubleTaggedInnerRange	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange	`path:"double-tagged-inner-range" module:"openconfig-vlan"`
	DoubleTaggedOuterList	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList	`path:"double-tagged-outer-list" module:"openconfig-vlan"`
	DoubleTaggedOuterRange	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange	`path:"double-tagged-outer-range" module:"openconfig-vlan"`
	SingleTagged	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged	`path:"single-tagged" module:"openconfig-vlan"`
	SingleTaggedList	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList	`path:"single-tagged-list" module:"openconfig-vlan"`
	SingleTaggedRange	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange	`path:"single-tagged-range" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-list YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-list/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config struct {
	InnerVlanIds	[]uint16	`path:"inner-vlan-ids" module:"openconfig-vlan"`
	OuterVlanId	*uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-list/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State struct {
	InnerVlanIds	[]uint16	`path:"inner-vlan-ids" module:"openconfig-vlan"`
	OuterVlanId	*uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-outer-range YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-outer-range/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config struct {
	InnerHighVlanId	*uint16	`path:"inner-high-vlan-id" module:"openconfig-vlan"`
	InnerLowVlanId	*uint16	`path:"inner-low-vlan-id" module:"openconfig-vlan"`
	OuterHighVlanId	*uint16	`path:"outer-high-vlan-id" module:"openconfig-vlan"`
	OuterLowVlanId	*uint16	`path:"outer-low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-outer-range/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State struct {
	InnerHighVlanId	*uint16	`path:"inner-high-vlan-id" module:"openconfig-vlan"`
	InnerLowVlanId	*uint16	`path:"inner-low-vlan-id" module:"openconfig-vlan"`
	OuterHighVlanId	*uint16	`path:"outer-high-vlan-id" module:"openconfig-vlan"`
	OuterLowVlanId	*uint16	`path:"outer-low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-range YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-range/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config struct {
	InnerHighVlanId	*uint16	`path:"inner-high-vlan-id" module:"openconfig-vlan"`
	InnerLowVlanId	*uint16	`path:"inner-low-vlan-id" module:"openconfig-vlan"`
	OuterVlanId	[]uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-range/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State struct {
	InnerHighVlanId	*uint16	`path:"inner-high-vlan-id" module:"openconfig-vlan"`
	InnerLowVlanId	*uint16	`path:"inner-low-vlan-id" module:"openconfig-vlan"`
	OuterVlanId	[]uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-list YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-list/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterVlanIds	[]uint16	`path:"outer-vlan-ids" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-list/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterVlanIds	[]uint16	`path:"outer-vlan-ids" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-range YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-range/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterHighVlanId	*uint16	`path:"outer-high-vlan-id" module:"openconfig-vlan"`
	OuterLowVlanId	*uint16	`path:"outer-low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-range/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterHighVlanId	*uint16	`path:"outer-high-vlan-id" module:"openconfig-vlan"`
	OuterLowVlanId	*uint16	`path:"outer-low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterVlanId	*uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterVlanId	*uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-list YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-list/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config struct {
	VlanIds	[]uint16	`path:"vlan-ids" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-list/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State struct {
	VlanIds	[]uint16	`path:"vlan-ids" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-range YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-range/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config struct {
	HighVlanId	*uint16	`path:"high-vlan-id" module:"openconfig-vlan"`
	LowVlanId	*uint16	`path:"low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-range/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State struct {
	HighVlanId	*uint16	`path:"high-vlan-id" module:"openconfig-vlan"`
	LowVlanId	*uint16	`path:"low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config struct {
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State struct {
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State struct {
	VlanId	OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union	`path:"vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/state/vlan-id within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) To_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigKeychain_Keychains represents the /openconfig-keychain/keychains YANG schema element.
type OpenconfigKeychain_Keychains struct {
	Keychain	map[string]*OpenconfigKeychain_Keychains_Keychain	`path:"keychain" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains) IsYANGGoStruct() {}

// NewKeychain creates a new entry in the Keychain list of the
// OpenconfigKeychain_Keychains struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigKeychain_Keychains) NewKeychain(Name string) (*OpenconfigKeychain_Keychains_Keychain, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Keychain == nil {
		t.Keychain = make(map[string]*OpenconfigKeychain_Keychains_Keychain)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Keychain[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Keychain", key)
	}

	t.Keychain[key] = &OpenconfigKeychain_Keychains_Keychain{
		Name: &Name,
	}

	return t.Keychain[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains.
func (*OpenconfigKeychain_Keychains) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain represents the /openconfig-keychain/keychains/keychain YANG schema element.
type OpenconfigKeychain_Keychains_Keychain struct {
	Config	*OpenconfigKeychain_Keychains_Keychain_Config	`path:"config" module:"openconfig-keychain"`
	Keys	*OpenconfigKeychain_Keychains_Keychain_Keys	`path:"keys" module:"openconfig-keychain"`
	Name	*string	`path:"name" module:"openconfig-keychain"`
	State	*OpenconfigKeychain_Keychains_Keychain_State	`path:"state" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigKeychain_Keychains_Keychain struct, which is a YANG list entry.
func (t *OpenconfigKeychain_Keychains_Keychain) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain.
func (*OpenconfigKeychain_Keychains_Keychain) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Config represents the /openconfig-keychain/keychains/keychain/config YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Config struct {
	Name	*string	`path:"name" module:"openconfig-keychain"`
	Tolerance	OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union	`path:"tolerance" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Config.
func (*OpenconfigKeychain_Keychains_Keychain_Config) ΛBelongingModule() string {
	return "openconfig-keychain"
}

// OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-keychain/keychains/keychain/config/tolerance within the YANG schema.
// Union type can be one of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, UnionUint32].
type OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union interface {
	// Union type can be one of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, UnionUint32]
	Documentation_for_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union()
}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union ensures that E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance
// implements the OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union interface.
func (E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union() {}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union ensures that UnionUint32
// implements the OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union interface.
func (UnionUint32) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union() {}

// To_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigKeychain_Keychains_Keychain_Config) To_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union(i interface{}) (OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union, error) {
	if v, ok := i.(OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union, unknown union type, got: %T, want any of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, uint32]", i, i)
}


// OpenconfigKeychain_Keychains_Keychain_Keys represents the /openconfig-keychain/keychains/keychain/keys YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys struct {
	Key	map[OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union]*OpenconfigKeychain_Keychains_Keychain_Keys_Key	`path:"key" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys) IsYANGGoStruct() {}

// NewKey creates a new entry in the Key list of the
// OpenconfigKeychain_Keychains_Keychain_Keys struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys) NewKey(KeyId OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union) (*OpenconfigKeychain_Keychains_Keychain_Keys_Key, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Key == nil {
		t.Key = make(map[OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union]*OpenconfigKeychain_Keychains_Keychain_Keys_Key)
	}

	key := KeyId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Key[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Key", key)
	}

	t.Key[key] = &OpenconfigKeychain_Keychains_Keychain_Keys_Key{
		KeyId: KeyId,
	}

	return t.Key[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys.
func (*OpenconfigKeychain_Keychains_Keychain_Keys) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key represents the /openconfig-keychain/keychains/keychain/keys/key YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key struct {
	Config	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config	`path:"config" module:"openconfig-keychain"`
	KeyId	OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union	`path:"key-id" module:"openconfig-keychain"`
	ReceiveLifetime	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime	`path:"receive-lifetime" module:"openconfig-keychain"`
	SendLifetime	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime	`path:"send-lifetime" module:"openconfig-keychain"`
	State	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_State	`path:"state" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigKeychain_Keychains_Keychain_Keys_Key struct, which is a YANG list entry.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"key-id": t.KeyId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key) ΛBelongingModule() string {
	return "openconfig-keychain"
}

// OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-keychain/keychains/keychain/keys/key/key-id within the YANG schema.
// Union type can be one of [UnionString, UnionUint64].
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union interface {
	// Union type can be one of [UnionString, UnionUint64]
	Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union()
}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union ensures that UnionString
// implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union interface.
func (UnionString) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union() {}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union ensures that UnionUint64
// implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union interface.
func (UnionUint64) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union() {}

// To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key) To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union(i interface{}) (OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union, error) {
	if v, ok := i.(OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint64:
		return UnionUint64(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union, unknown union type, got: %T, want any of [string, uint64]", i, i)
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config represents the /openconfig-keychain/keychains/keychain/keys/key/config YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config struct {
	CryptoAlgorithm	E_OpenconfigKeychainTypes_CRYPTO_TYPE	`path:"crypto-algorithm" module:"openconfig-keychain"`
	KeyId	OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union	`path:"key-id" module:"openconfig-keychain"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) ΛBelongingModule() string {
	return "openconfig-keychain"
}

// To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union(i interface{}) (OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union, error) {
	if v, ok := i.(OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint64:
		return UnionUint64(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union, unknown union type, got: %T, want any of [string, uint64]", i, i)
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime represents the /openconfig-keychain/keychains/keychain/keys/key/receive-lifetime YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime struct {
	Config	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config	`path:"config" module:"openconfig-keychain"`
	State	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State	`path:"state" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config represents the /openconfig-keychain/keychains/keychain/keys/key/receive-lifetime/config YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config struct {
	EndTime	*uint64	`path:"end-time" module:"openconfig-keychain"`
	StartTime	*uint64	`path:"start-time" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State represents the /openconfig-keychain/keychains/keychain/keys/key/receive-lifetime/state YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State struct {
	EndTime	*uint64	`path:"end-time" module:"openconfig-keychain"`
	StartTime	*uint64	`path:"start-time" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime represents the /openconfig-keychain/keychains/keychain/keys/key/send-lifetime YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime struct {
	Config	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config	`path:"config" module:"openconfig-keychain"`
	State	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State	`path:"state" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config represents the /openconfig-keychain/keychains/keychain/keys/key/send-lifetime/config YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config struct {
	EndTime	*uint64	`path:"end-time" module:"openconfig-keychain"`
	SendAndReceive	*bool	`path:"send-and-receive" module:"openconfig-keychain"`
	StartTime	*uint64	`path:"start-time" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State represents the /openconfig-keychain/keychains/keychain/keys/key/send-lifetime/state YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State struct {
	EndTime	*uint64	`path:"end-time" module:"openconfig-keychain"`
	SendAndReceive	*bool	`path:"send-and-receive" module:"openconfig-keychain"`
	StartTime	*uint64	`path:"start-time" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_State represents the /openconfig-keychain/keychains/keychain/keys/key/state YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_State struct {
	CryptoAlgorithm	E_OpenconfigKeychainTypes_CRYPTO_TYPE	`path:"crypto-algorithm" module:"openconfig-keychain"`
	KeyId	OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union	`path:"key-id" module:"openconfig-keychain"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_State.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) ΛBelongingModule() string {
	return "openconfig-keychain"
}

// OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-keychain/keychains/keychain/keys/key/state/key-id within the YANG schema.
// Union type can be one of [UnionString, UnionUint64].
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union interface {
	// Union type can be one of [UnionString, UnionUint64]
	Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union()
}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union ensures that UnionString
// implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union interface.
func (UnionString) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union() {}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union ensures that UnionUint64
// implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union interface.
func (UnionUint64) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union() {}

// To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union(i interface{}) (OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union, error) {
	if v, ok := i.(OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint64:
		return UnionUint64(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union, unknown union type, got: %T, want any of [string, uint64]", i, i)
}


// OpenconfigKeychain_Keychains_Keychain_State represents the /openconfig-keychain/keychains/keychain/state YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_State struct {
	Name	*string	`path:"name" module:"openconfig-keychain"`
	Tolerance	OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union	`path:"tolerance" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_State.
func (*OpenconfigKeychain_Keychains_Keychain_State) ΛBelongingModule() string {
	return "openconfig-keychain"
}

// OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-keychain/keychains/keychain/state/tolerance within the YANG schema.
// Union type can be one of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, UnionUint32].
type OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union interface {
	// Union type can be one of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, UnionUint32]
	Documentation_for_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union()
}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union ensures that E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance
// implements the OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union interface.
func (E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance) Documentation_for_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union() {}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union ensures that UnionUint32
// implements the OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union interface.
func (UnionUint32) Documentation_for_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union() {}

// To_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigKeychain_Keychains_Keychain_State) To_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union(i interface{}) (OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union, error) {
	if v, ok := i.(OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union, unknown union type, got: %T, want any of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, uint32]", i, i)
}


// OpenconfigLldp_Lldp represents the /openconfig-lldp/lldp YANG schema element.
type OpenconfigLldp_Lldp struct {
	Config	*OpenconfigLldp_Lldp_Config	`path:"config" module:"openconfig-lldp"`
	Interfaces	*OpenconfigLldp_Lldp_Interfaces	`path:"interfaces" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp.
func (*OpenconfigLldp_Lldp) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Config represents the /openconfig-lldp/lldp/config YANG schema element.
type OpenconfigLldp_Lldp_Config struct {
	ChassisId	*string	`path:"chassis-id" module:"openconfig-lldp"`
	ChassisIdType	E_OpenconfigLldp_ChassisIdType	`path:"chassis-id-type" module:"openconfig-lldp"`
	Enabled	*bool	`path:"enabled" module:"openconfig-lldp"`
	HelloTimer	*uint64	`path:"hello-timer" module:"openconfig-lldp"`
	ManagementAddress	*OpenconfigLldp_Lldp_Config_ManagementAddress	`path:"management-address" module:"arista-lldp-augments"`
	SuppressTlvAdvertisement	[]E_OpenconfigLldpTypes_LLDP_TLV	`path:"suppress-tlv-advertisement" module:"openconfig-lldp"`
	SystemDescription	*string	`path:"system-description" module:"openconfig-lldp"`
	SystemName	*string	`path:"system-name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Config.
func (*OpenconfigLldp_Lldp_Config) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Config_ManagementAddress represents the /openconfig-lldp/lldp/config/management-address YANG schema element.
type OpenconfigLldp_Lldp_Config_ManagementAddress struct {
	Interface	*string	`path:"interface" module:"arista-lldp-augments"`
	NetworkInstance	*string	`path:"network-instance" module:"arista-lldp-augments"`
	TransmitMode	E_AristaLldpAugments_TransmitModeEnum	`path:"transmit-mode" module:"arista-lldp-augments"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Config_ManagementAddress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Config_ManagementAddress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Config_ManagementAddress) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Config_ManagementAddress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Config_ManagementAddress) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Config_ManagementAddress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Config_ManagementAddress.
func (*OpenconfigLldp_Lldp_Config_ManagementAddress) ΛBelongingModule() string {
	return "arista-lldp-augments"
}


// OpenconfigLldp_Lldp_Interfaces represents the /openconfig-lldp/lldp/interfaces YANG schema element.
type OpenconfigLldp_Lldp_Interfaces struct {
	Interface	map[string]*OpenconfigLldp_Lldp_Interfaces_Interface	`path:"interface" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigLldp_Lldp_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces) NewInterface(Name string) (*OpenconfigLldp_Lldp_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigLldp_Lldp_Interfaces_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigLldp_Lldp_Interfaces_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces.
func (*OpenconfigLldp_Lldp_Interfaces) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface represents the /openconfig-lldp/lldp/interfaces/interface YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface struct {
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Config	`path:"config" module:"openconfig-lldp"`
	Name	*string	`path:"name" module:"openconfig-lldp"`
	Neighbors	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors	`path:"neighbors" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface.
func (*OpenconfigLldp_Lldp_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Config represents the /openconfig-lldp/lldp/interfaces/interface/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Config struct {
	Enabled	OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union	`path:"enabled" module:"openconfig-lldp"`
	Name	*string	`path:"name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Config.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-lldp"
}

// OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-lldp/lldp/interfaces/interface/config/enabled within the YANG schema.
// Union type can be one of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, UnionBool].
type OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union interface {
	// Union type can be one of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, UnionBool]
	Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union()
}

// Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union ensures that E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled
// implements the OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union interface.
func (E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled) Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union() {}

// Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union ensures that UnionBool
// implements the OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union interface.
func (UnionBool) Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union() {}

// To_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Config) To_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union(i interface{}) (OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union, error) {
	if v, ok := i.(OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case bool:
		return UnionBool(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union, unknown union type, got: %T, want any of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, bool]", i, i)
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors represents the /openconfig-lldp/lldp/interfaces/interface/neighbors YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors struct {
	Neighbor	map[string]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) NewNeighbor(Id string) (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor{
		Id: &Id,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor struct {
	Capabilities	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities	`path:"capabilities" module:"openconfig-lldp"`
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-lldp"`
	CustomTlvs	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs	`path:"custom-tlvs" module:"openconfig-lldp"`
	Id	*string	`path:"id" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities struct {
	Capability	map[E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability	`path:"capability" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) IsYANGGoStruct() {}

// NewCapability creates a new entry in the Capability list of the
// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) NewCapability(Name E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY) (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Capability == nil {
		t.Capability = make(map[E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Capability[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Capability", key)
	}

	t.Capability[key] = &OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability{
		Name: Name,
	}

	return t.Capability[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability struct {
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config	`path:"config" module:"openconfig-lldp"`
	Name	E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY	`path:"name" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"name": t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-lldp"`
	Name	E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY	`path:"name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs struct {
	Tlv	map[OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv	`path:"tlv" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) IsYANGGoStruct() {}

// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key represents the key for list Tlv of element /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key struct {
	Type	int32	`path:"type"`
	Oui	string	`path:"oui"`
	OuiSubtype	string	`path:"oui-subtype"`
}

// IsYANGGoKeyStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key key struct.
func (t OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"type": t.Type,
		"oui": t.Oui,
		"oui-subtype": t.OuiSubtype,
	}, nil
}

// NewTlv creates a new entry in the Tlv list of the
// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) NewTlv(Type int32, Oui string, OuiSubtype string) (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Tlv == nil {
		t.Tlv = make(map[OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv)
	}

	key := OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key{
		Type: Type,
		Oui: Oui,
		OuiSubtype: OuiSubtype,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Tlv[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Tlv", key)
	}

	t.Tlv[key] = &OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv{
		Type: &Type,
		Oui: &Oui,
		OuiSubtype: &OuiSubtype,
	}

	return t.Tlv[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv struct {
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config	`path:"config" module:"openconfig-lldp"`
	Oui	*string	`path:"oui" module:"openconfig-lldp"`
	OuiSubtype	*string	`path:"oui-subtype" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State	`path:"state" module:"openconfig-lldp"`
	Type	*int32	`path:"type" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Oui == nil {
		return nil, fmt.Errorf("nil value for key Oui")
	}

	if t.OuiSubtype == nil {
		return nil, fmt.Errorf("nil value for key OuiSubtype")
	}

	if t.Type == nil {
		return nil, fmt.Errorf("nil value for key Type")
	}

	return map[string]interface{}{
		"oui": *t.Oui,
		"oui-subtype": *t.OuiSubtype,
		"type": *t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State struct {
	Oui	*string	`path:"oui" module:"openconfig-lldp"`
	OuiSubtype	*string	`path:"oui-subtype" module:"openconfig-lldp"`
	Type	*int32	`path:"type" module:"openconfig-lldp"`
	Value	Binary	`path:"value" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State struct {
	ChassisId	*string	`path:"chassis-id" module:"openconfig-lldp"`
	ChassisIdType	E_OpenconfigLldp_ChassisIdType	`path:"chassis-id-type" module:"openconfig-lldp"`
	Id	*string	`path:"id" module:"openconfig-lldp"`
	LastUpdateTime	*uint64	`path:"last-update-time" module:"arista-lldp-augments"`
	ManagementAddress	*string	`path:"management-address" module:"openconfig-lldp"`
	ManagementAddressType	*string	`path:"management-address-type" module:"openconfig-lldp"`
	PortDescription	*string	`path:"port-description" module:"openconfig-lldp"`
	PortId	*string	`path:"port-id" module:"openconfig-lldp"`
	PortIdType	E_OpenconfigLldp_PortIdType	`path:"port-id-type" module:"openconfig-lldp"`
	RegistrationTime	*uint64	`path:"registration-time" module:"arista-lldp-augments"`
	SystemDescription	*string	`path:"system-description" module:"openconfig-lldp"`
	SystemName	*string	`path:"system-name" module:"openconfig-lldp"`
	Ttl	*uint16	`path:"ttl" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_State represents the /openconfig-lldp/lldp/interfaces/interface/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_State struct {
	Counters	*OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters	`path:"counters" module:"openconfig-lldp"`
	Enabled	OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union	`path:"enabled" module:"openconfig-lldp"`
	Name	*string	`path:"name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_State.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-lldp"
}

// OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-lldp/lldp/interfaces/interface/state/enabled within the YANG schema.
// Union type can be one of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, UnionBool].
type OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union interface {
	// Union type can be one of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, UnionBool]
	Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union()
}

// Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union ensures that E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled
// implements the OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union interface.
func (E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled) Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union() {}

// Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union ensures that UnionBool
// implements the OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union interface.
func (UnionBool) Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union() {}

// To_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State) To_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union(i interface{}) (OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union, error) {
	if v, ok := i.(OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case bool:
		return UnionBool(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union, unknown union type, got: %T, want any of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, bool]", i, i)
}


// OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters represents the /openconfig-lldp/lldp/interfaces/interface/state/counters YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters struct {
	FrameDiscard	*uint64	`path:"frame-discard" module:"openconfig-lldp"`
	FrameErrorIn	*uint64	`path:"frame-error-in" module:"openconfig-lldp"`
	FrameErrorOut	*uint64	`path:"frame-error-out" module:"openconfig-lldp"`
	FrameIn	*uint64	`path:"frame-in" module:"openconfig-lldp"`
	FrameOut	*uint64	`path:"frame-out" module:"openconfig-lldp"`
	LastClear	*string	`path:"last-clear" module:"openconfig-lldp"`
	TlvDiscard	*uint64	`path:"tlv-discard" module:"openconfig-lldp"`
	TlvUnknown	*uint64	`path:"tlv-unknown" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_State represents the /openconfig-lldp/lldp/state YANG schema element.
type OpenconfigLldp_Lldp_State struct {
	ChassisId	*string	`path:"chassis-id" module:"openconfig-lldp"`
	ChassisIdType	E_OpenconfigLldp_ChassisIdType	`path:"chassis-id-type" module:"openconfig-lldp"`
	Counters	*OpenconfigLldp_Lldp_State_Counters	`path:"counters" module:"openconfig-lldp"`
	Enabled	*bool	`path:"enabled" module:"openconfig-lldp"`
	HelloTimer	*uint64	`path:"hello-timer" module:"openconfig-lldp"`
	SuppressTlvAdvertisement	[]E_OpenconfigLldpTypes_LLDP_TLV	`path:"suppress-tlv-advertisement" module:"openconfig-lldp"`
	SystemDescription	*string	`path:"system-description" module:"openconfig-lldp"`
	SystemName	*string	`path:"system-name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_State.
func (*OpenconfigLldp_Lldp_State) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_State_Counters represents the /openconfig-lldp/lldp/state/counters YANG schema element.
type OpenconfigLldp_Lldp_State_Counters struct {
	EntriesAgedOut	*uint64	`path:"entries-aged-out" module:"openconfig-lldp"`
	FrameDiscard	*uint64	`path:"frame-discard" module:"openconfig-lldp"`
	FrameErrorIn	*uint64	`path:"frame-error-in" module:"openconfig-lldp"`
	FrameIn	*uint64	`path:"frame-in" module:"openconfig-lldp"`
	FrameOut	*uint64	`path:"frame-out" module:"openconfig-lldp"`
	LastClear	*string	`path:"last-clear" module:"openconfig-lldp"`
	TlvAccepted	*uint64	`path:"tlv-accepted" module:"openconfig-lldp"`
	TlvDiscard	*uint64	`path:"tlv-discard" module:"openconfig-lldp"`
	TlvUnknown	*uint64	`path:"tlv-unknown" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_State_Counters.
func (*OpenconfigLldp_Lldp_State_Counters) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigMessages_Messages represents the /openconfig-messages/messages YANG schema element.
type OpenconfigMessages_Messages struct {
	Config	*OpenconfigMessages_Messages_Config	`path:"config" module:"openconfig-messages"`
	DebugEntries	*OpenconfigMessages_Messages_DebugEntries	`path:"debug-entries" module:"openconfig-messages"`
	State	*OpenconfigMessages_Messages_State	`path:"state" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages.
func (*OpenconfigMessages_Messages) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_Config represents the /openconfig-messages/messages/config YANG schema element.
type OpenconfigMessages_Messages_Config struct {
	Severity	E_OpenconfigMessages_SyslogSeverity	`path:"severity" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_Config.
func (*OpenconfigMessages_Messages_Config) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries represents the /openconfig-messages/messages/debug-entries YANG schema element.
type OpenconfigMessages_Messages_DebugEntries struct {
	DebugService	map[E_OpenconfigMessages_DEBUG_SERVICE]*OpenconfigMessages_Messages_DebugEntries_DebugService	`path:"debug-service" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries) IsYANGGoStruct() {}

// NewDebugService creates a new entry in the DebugService list of the
// OpenconfigMessages_Messages_DebugEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigMessages_Messages_DebugEntries) NewDebugService(Service E_OpenconfigMessages_DEBUG_SERVICE) (*OpenconfigMessages_Messages_DebugEntries_DebugService, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.DebugService == nil {
		t.DebugService = make(map[E_OpenconfigMessages_DEBUG_SERVICE]*OpenconfigMessages_Messages_DebugEntries_DebugService)
	}

	key := Service

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.DebugService[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list DebugService", key)
	}

	t.DebugService[key] = &OpenconfigMessages_Messages_DebugEntries_DebugService{
		Service: Service,
	}

	return t.DebugService[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries.
func (*OpenconfigMessages_Messages_DebugEntries) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries_DebugService represents the /openconfig-messages/messages/debug-entries/debug-service YANG schema element.
type OpenconfigMessages_Messages_DebugEntries_DebugService struct {
	Config	*OpenconfigMessages_Messages_DebugEntries_DebugService_Config	`path:"config" module:"openconfig-messages"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-messages"`
	State	*OpenconfigMessages_Messages_DebugEntries_DebugService_State	`path:"state" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries_DebugService implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigMessages_Messages_DebugEntries_DebugService struct, which is a YANG list entry.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"service": t.Service,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries_DebugService"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries_DebugService.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries_DebugService_Config represents the /openconfig-messages/messages/debug-entries/debug-service/config YANG schema element.
type OpenconfigMessages_Messages_DebugEntries_DebugService_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-messages"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries_DebugService_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries_DebugService_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries_DebugService_Config.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_Config) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries_DebugService_State represents the /openconfig-messages/messages/debug-entries/debug-service/state YANG schema element.
type OpenconfigMessages_Messages_DebugEntries_DebugService_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-messages"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries_DebugService_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries_DebugService_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries_DebugService_State.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_State) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_State represents the /openconfig-messages/messages/state YANG schema element.
type OpenconfigMessages_Messages_State struct {
	Message	*OpenconfigMessages_Messages_State_Message	`path:"message" module:"openconfig-messages"`
	Severity	E_OpenconfigMessages_SyslogSeverity	`path:"severity" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_State.
func (*OpenconfigMessages_Messages_State) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_State_Message represents the /openconfig-messages/messages/state/message YANG schema element.
type OpenconfigMessages_Messages_State_Message struct {
	AppName	*string	`path:"app-name" module:"openconfig-messages"`
	Msg	*string	`path:"msg" module:"openconfig-messages"`
	Msgid	*string	`path:"msgid" module:"openconfig-messages"`
	Priority	*uint8	`path:"priority" module:"openconfig-messages"`
	Procid	*string	`path:"procid" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_State_Message implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_State_Message) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State_Message) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_State_Message"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State_Message) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_State_Message) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_State_Message.
func (*OpenconfigMessages_Messages_State_Message) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigNetworkInstance_NetworkInstances represents the /openconfig-network-instance/network-instances YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances struct {
	NetworkInstance	map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance	`path:"network-instance" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances) IsYANGGoStruct() {}

// NewNetworkInstance creates a new entry in the NetworkInstance list of the
// OpenconfigNetworkInstance_NetworkInstances struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances) NewNetworkInstance(Name string) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.NetworkInstance == nil {
		t.NetworkInstance = make(map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.NetworkInstance[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list NetworkInstance", key)
	}

	t.NetworkInstance[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance{
		Name: &Name,
	}

	return t.NetworkInstance[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances.
func (*OpenconfigNetworkInstance_NetworkInstances) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance represents the /openconfig-network-instance/network-instances/network-instance YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance struct {
	Afts	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts	`path:"afts" module:"openconfig-network-instance"`
	Config	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config	`path:"config" module:"openconfig-network-instance"`
	ConnectionPoints	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints	`path:"connection-points" module:"openconfig-network-instance"`
	Encapsulation	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Encapsulation	`path:"encapsulation" module:"openconfig-network-instance"`
	Evpn	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Evpn	`path:"evpn" module:"openconfig-network-instance"`
	Fdb	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Fdb	`path:"fdb" module:"openconfig-network-instance"`
	InterInstancePolicies	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_InterInstancePolicies	`path:"inter-instance-policies" module:"openconfig-network-instance"`
	Interfaces	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Interfaces	`path:"interfaces" module:"openconfig-network-instance"`
	Mpls	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Mpls	`path:"mpls" module:"openconfig-network-instance"`
	Name	*string	`path:"name" module:"openconfig-network-instance"`
	PolicyForwarding	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_PolicyForwarding	`path:"policy-forwarding" module:"openconfig-network-instance"`
	Protocols	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Protocols	`path:"protocols" module:"openconfig-network-instance"`
	RouteLimits	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_RouteLimits	`path:"route-limits" module:"openconfig-network-instance"`
	SegmentRouting	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_SegmentRouting	`path:"segment-routing" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_State	`path:"state" module:"openconfig-network-instance"`
	TableConnections	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_TableConnections	`path:"table-connections" module:"openconfig-network-instance"`
	Tables	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Tables	`path:"tables" module:"openconfig-network-instance"`
	Vlans	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Vlans	`path:"vlans" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts represents the /openconfig-network-instance/network-instances/network-instance/afts YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts struct {
	Ethernet	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet	`path:"ethernet" module:"openconfig-network-instance"`
	Ipv4Unicast	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast	`path:"ipv4-unicast" module:"openconfig-network-instance"`
	Ipv6Unicast	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast	`path:"ipv6-unicast" module:"openconfig-network-instance"`
	Mpls	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls	`path:"mpls" module:"openconfig-network-instance"`
	NextHopGroups	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups	`path:"next-hop-groups" module:"openconfig-network-instance"`
	NextHops	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops	`path:"next-hops" module:"openconfig-network-instance"`
	PolicyForwarding	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding	`path:"policy-forwarding" module:"openconfig-network-instance"`
	StateSynced	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced	`path:"state-synced" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet represents the /openconfig-network-instance/network-instances/network-instance/afts/ethernet YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet struct {
	MacEntry	map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry	`path:"mac-entry" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet) IsYANGGoStruct() {}

// NewMacEntry creates a new entry in the MacEntry list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet) NewMacEntry(MacAddress string) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.MacEntry == nil {
		t.MacEntry = make(map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry)
	}

	key := MacAddress

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.MacEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list MacEntry", key)
	}

	t.MacEntry[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry{
		MacAddress: &MacAddress,
	}

	return t.MacEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry represents the /openconfig-network-instance/network-instances/network-instance/afts/ethernet/mac-entry YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry struct {
	MacAddress	*string	`path:"mac-address" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.MacAddress == nil {
		return nil, fmt.Errorf("nil value for key MacAddress")
	}

	return map[string]interface{}{
		"mac-address": *t.MacAddress,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State represents the /openconfig-network-instance/network-instances/network-instance/afts/ethernet/mac-entry/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State struct {
	Counters	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters	`path:"counters" module:"openconfig-network-instance"`
	EntryMetadata	Binary	`path:"entry-metadata" module:"openconfig-network-instance"`
	MacAddress	*string	`path:"mac-address" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters represents the /openconfig-network-instance/network-instances/network-instance/afts/ethernet/mac-entry/state/counters YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters struct {
	OctetsForwarded	*uint64	`path:"octets-forwarded" module:"openconfig-network-instance"`
	PacketsForwarded	*uint64	`path:"packets-forwarded" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ethernet_MacEntry_State_Counters) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast represents the /openconfig-network-instance/network-instances/network-instance/afts/ipv4-unicast YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast struct {
	Ipv4Entry	map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry	`path:"ipv4-entry" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast) IsYANGGoStruct() {}

// NewIpv4Entry creates a new entry in the Ipv4Entry list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast) NewIpv4Entry(Prefix string) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Ipv4Entry == nil {
		t.Ipv4Entry = make(map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry)
	}

	key := Prefix

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Ipv4Entry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Ipv4Entry", key)
	}

	t.Ipv4Entry[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry{
		Prefix: &Prefix,
	}

	return t.Ipv4Entry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry represents the /openconfig-network-instance/network-instances/network-instance/afts/ipv4-unicast/ipv4-entry YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry struct {
	Prefix	*string	`path:"prefix" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"prefix": *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State represents the /openconfig-network-instance/network-instances/network-instance/afts/ipv4-unicast/ipv4-entry/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State struct {
	Counters	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters	`path:"counters" module:"openconfig-network-instance"`
	DecapsulateHeader	E_OpenconfigAft_EncapsulationHeaderType	`path:"decapsulate-header" module:"openconfig-network-instance"`
	EntryMetadata	Binary	`path:"entry-metadata" module:"openconfig-network-instance"`
	OriginProtocol	E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE	`path:"origin-protocol" module:"openconfig-network-instance"`
	Prefix	*string	`path:"prefix" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters represents the /openconfig-network-instance/network-instances/network-instance/afts/ipv4-unicast/ipv4-entry/state/counters YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters struct {
	OctetsForwarded	*uint64	`path:"octets-forwarded" module:"openconfig-network-instance"`
	PacketsForwarded	*uint64	`path:"packets-forwarded" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv4Unicast_Ipv4Entry_State_Counters) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast represents the /openconfig-network-instance/network-instances/network-instance/afts/ipv6-unicast YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast struct {
	Ipv6Entry	map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry	`path:"ipv6-entry" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast) IsYANGGoStruct() {}

// NewIpv6Entry creates a new entry in the Ipv6Entry list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast) NewIpv6Entry(Prefix string) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Ipv6Entry == nil {
		t.Ipv6Entry = make(map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry)
	}

	key := Prefix

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Ipv6Entry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Ipv6Entry", key)
	}

	t.Ipv6Entry[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry{
		Prefix: &Prefix,
	}

	return t.Ipv6Entry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry represents the /openconfig-network-instance/network-instances/network-instance/afts/ipv6-unicast/ipv6-entry YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry struct {
	Prefix	*string	`path:"prefix" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"prefix": *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State represents the /openconfig-network-instance/network-instances/network-instance/afts/ipv6-unicast/ipv6-entry/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State struct {
	Counters	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters	`path:"counters" module:"openconfig-network-instance"`
	DecapsulateHeader	E_OpenconfigAft_EncapsulationHeaderType	`path:"decapsulate-header" module:"openconfig-network-instance"`
	EntryMetadata	Binary	`path:"entry-metadata" module:"openconfig-network-instance"`
	OriginProtocol	E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE	`path:"origin-protocol" module:"openconfig-network-instance"`
	Prefix	*string	`path:"prefix" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters represents the /openconfig-network-instance/network-instances/network-instance/afts/ipv6-unicast/ipv6-entry/state/counters YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters struct {
	OctetsForwarded	*uint64	`path:"octets-forwarded" module:"openconfig-network-instance"`
	PacketsForwarded	*uint64	`path:"packets-forwarded" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Ipv6Unicast_Ipv6Entry_State_Counters) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls represents the /openconfig-network-instance/network-instances/network-instance/afts/mpls YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls struct {
	LabelEntry	map[OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry	`path:"label-entry" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls) IsYANGGoStruct() {}

// NewLabelEntry creates a new entry in the LabelEntry list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls) NewLabelEntry(Label OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.LabelEntry == nil {
		t.LabelEntry = make(map[OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry)
	}

	key := Label

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.LabelEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list LabelEntry", key)
	}

	t.LabelEntry[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry{
		Label: Label,
	}

	return t.LabelEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry represents the /openconfig-network-instance/network-instances/network-instance/afts/mpls/label-entry YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry struct {
	Label	OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union	`path:"label" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"label": t.Label,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry) ΛBelongingModule() string {
	return "openconfig-network-instance"
}

// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-network-instance/network-instances/network-instance/afts/mpls/label-entry/label within the YANG schema.
// Union type can be one of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label, UnionUint32].
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union interface {
	// Union type can be one of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label, UnionUint32]
	Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union()
}

// Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union ensures that E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label
// implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union interface.
func (E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label) Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union() {}

// Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union ensures that UnionUint32
// implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union interface.
func (UnionUint32) Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union() {}

// To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry) To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union(i interface{}) (OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union, error) {
	if v, ok := i.(OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union, unknown union type, got: %T, want any of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label, uint32]", i, i)
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State represents the /openconfig-network-instance/network-instances/network-instance/afts/mpls/label-entry/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State struct {
	Counters	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters	`path:"counters" module:"openconfig-network-instance"`
	EntryMetadata	Binary	`path:"entry-metadata" module:"openconfig-network-instance"`
	Label	OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union	`path:"label" module:"openconfig-network-instance"`
	PoppedMplsLabelStack	[]OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union	`path:"popped-mpls-label-stack" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}

// To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State) To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union(i interface{}) (OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union, error) {
	if v, ok := i.(OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label_Union, unknown union type, got: %T, want any of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Label, uint32]", i, i)
}

// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-network-instance/network-instances/network-instance/afts/mpls/label-entry/state/popped-mpls-label-stack within the YANG schema.
// Union type can be one of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack, UnionUint32].
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union interface {
	// Union type can be one of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack, UnionUint32]
	Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union()
}

// Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union ensures that E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack
// implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union interface.
func (E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack) Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union() {}

// Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union ensures that UnionUint32
// implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union interface.
func (UnionUint32) Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union() {}

// To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State) To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union(i interface{}) (OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union, error) {
	if v, ok := i.(OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack_Union, unknown union type, got: %T, want any of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_PoppedMplsLabelStack, uint32]", i, i)
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters represents the /openconfig-network-instance/network-instances/network-instance/afts/mpls/label-entry/state/counters YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters struct {
	OctetsForwarded	*uint64	`path:"octets-forwarded" module:"openconfig-network-instance"`
	PacketsForwarded	*uint64	`path:"packets-forwarded" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_Mpls_LabelEntry_State_Counters) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups struct {
	NextHopGroup	map[uint64]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup	`path:"next-hop-group" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups) IsYANGGoStruct() {}

// NewNextHopGroup creates a new entry in the NextHopGroup list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups) NewNextHopGroup(Id uint64) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.NextHopGroup == nil {
		t.NextHopGroup = make(map[uint64]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.NextHopGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list NextHopGroup", key)
	}

	t.NextHopGroup[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup{
		Id: &Id,
	}

	return t.NextHopGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup struct {
	Conditional	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional	`path:"conditional" module:"openconfig-network-instance"`
	Id	*uint64	`path:"id" module:"openconfig-network-instance"`
	NextHops	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops	`path:"next-hops" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group/conditional YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional struct {
	Condition	map[uint64]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition	`path:"condition" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional) IsYANGGoStruct() {}

// NewCondition creates a new entry in the Condition list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional) NewCondition(Id uint64) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Condition == nil {
		t.Condition = make(map[uint64]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Condition[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Condition", key)
	}

	t.Condition[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition{
		Id: &Id,
	}

	return t.Condition[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group/conditional/condition YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition struct {
	Id	*uint64	`path:"id" module:"openconfig-network-instance"`
	InputInterfaces	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces	`path:"input-interfaces" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group/conditional/condition/input-interfaces YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces struct {
	InputInterface	map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface	`path:"input-interface" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces) IsYANGGoStruct() {}

// NewInputInterface creates a new entry in the InputInterface list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces) NewInputInterface(Id string) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.InputInterface == nil {
		t.InputInterface = make(map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.InputInterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list InputInterface", key)
	}

	t.InputInterface[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface{
		Id: &Id,
	}

	return t.InputInterface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group/conditional/condition/input-interfaces/input-interface YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface struct {
	Id	*string	`path:"id" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group/conditional/condition/input-interfaces/input-interface/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State struct {
	Id	*string	`path:"id" module:"openconfig-network-instance"`
	Interface	*string	`path:"interface" module:"openconfig-network-instance"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_InputInterfaces_InputInterface_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group/conditional/condition/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State struct {
	Dscp	[]uint8	`path:"dscp" module:"openconfig-network-instance"`
	Id	*uint64	`path:"id" module:"openconfig-network-instance"`
	NextHopGroup	*uint64	`path:"next-hop-group" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_Conditional_Condition_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group/next-hops YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops struct {
	NextHop	map[uint64]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop	`path:"next-hop" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops) IsYANGGoStruct() {}

// NewNextHop creates a new entry in the NextHop list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops) NewNextHop(Index uint64) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.NextHop == nil {
		t.NextHop = make(map[uint64]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.NextHop[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list NextHop", key)
	}

	t.NextHop[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop{
		Index: &Index,
	}

	return t.NextHop[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group/next-hops/next-hop YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop struct {
	Index	*uint64	`path:"index" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group/next-hops/next-hop/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State struct {
	Index	*uint64	`path:"index" module:"openconfig-network-instance"`
	Weight	*uint64	`path:"weight" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_NextHops_NextHop_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hop-groups/next-hop-group/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State struct {
	BackupNextHopGroup	*uint64	`path:"backup-next-hop-group" module:"openconfig-network-instance"`
	Color	*uint64	`path:"color" module:"openconfig-network-instance"`
	Id	*uint64	`path:"id" module:"openconfig-network-instance"`
	ProgrammedId	*uint64	`path:"programmed-id" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHopGroups_NextHopGroup_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hops YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops struct {
	NextHop	map[uint64]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop	`path:"next-hop" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops) IsYANGGoStruct() {}

// NewNextHop creates a new entry in the NextHop list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops) NewNextHop(Index uint64) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.NextHop == nil {
		t.NextHop = make(map[uint64]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.NextHop[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list NextHop", key)
	}

	t.NextHop[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop{
		Index: &Index,
	}

	return t.NextHop[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hops/next-hop YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop struct {
	Index	*uint64	`path:"index" module:"openconfig-network-instance"`
	InterfaceRef	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef	`path:"interface-ref" module:"openconfig-network-instance"`
	IpInIp	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp	`path:"ip-in-ip" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hops/next-hop/interface-ref YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef struct {
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hops/next-hop/interface-ref/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-network-instance"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hops/next-hop/ip-in-ip YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp struct {
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hops/next-hop/ip-in-ip/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State struct {
	DstIp	*string	`path:"dst-ip" module:"openconfig-network-instance"`
	SrcIp	*string	`path:"src-ip" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_IpInIp_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hops/next-hop/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State struct {
	Counters	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters	`path:"counters" module:"openconfig-network-instance"`
	DecapsulateHeader	E_OpenconfigAft_EncapsulationHeaderType	`path:"decapsulate-header" module:"openconfig-network-instance"`
	EncapsulateHeader	E_OpenconfigAft_EncapsulationHeaderType	`path:"encapsulate-header" module:"openconfig-network-instance"`
	Index	*uint64	`path:"index" module:"openconfig-network-instance"`
	IpAddress	*string	`path:"ip-address" module:"openconfig-network-instance"`
	LspName	*string	`path:"lsp-name" module:"openconfig-network-instance"`
	MacAddress	*string	`path:"mac-address" module:"openconfig-network-instance"`
	OriginProtocol	E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE	`path:"origin-protocol" module:"openconfig-network-instance"`
	PopTopLabel	*bool	`path:"pop-top-label" module:"openconfig-network-instance"`
	ProgrammedIndex	*uint64	`path:"programmed-index" module:"openconfig-network-instance"`
	PushedMplsLabelStack	[]OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union	`path:"pushed-mpls-label-stack" module:"openconfig-network-instance"`
	TunnelSrcIpAddress	*string	`path:"tunnel-src-ip-address" module:"openconfig-network-instance"`
	VniLabel	*uint32	`path:"vni-label" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}

// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-network-instance/network-instances/network-instance/afts/next-hops/next-hop/state/pushed-mpls-label-stack within the YANG schema.
// Union type can be one of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack, UnionUint32].
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union interface {
	// Union type can be one of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack, UnionUint32]
	Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union()
}

// Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union ensures that E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack
// implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union interface.
func (E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack) Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union() {}

// Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union ensures that UnionUint32
// implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union interface.
func (UnionUint32) Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union() {}

// To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State) To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union(i interface{}) (OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union, error) {
	if v, ok := i.(OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack_Union, unknown union type, got: %T, want any of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_PushedMplsLabelStack, uint32]", i, i)
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters represents the /openconfig-network-instance/network-instances/network-instance/afts/next-hops/next-hop/state/counters YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters struct {
	OctetsForwarded	*uint64	`path:"octets-forwarded" module:"openconfig-network-instance"`
	PacketsForwarded	*uint64	`path:"packets-forwarded" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_NextHops_NextHop_State_Counters) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding represents the /openconfig-network-instance/network-instances/network-instance/afts/policy-forwarding YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding struct {
	PolicyForwardingEntry	map[uint64]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry	`path:"policy-forwarding-entry" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding) IsYANGGoStruct() {}

// NewPolicyForwardingEntry creates a new entry in the PolicyForwardingEntry list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding) NewPolicyForwardingEntry(Index uint64) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.PolicyForwardingEntry == nil {
		t.PolicyForwardingEntry = make(map[uint64]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.PolicyForwardingEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list PolicyForwardingEntry", key)
	}

	t.PolicyForwardingEntry[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry{
		Index: &Index,
	}

	return t.PolicyForwardingEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry represents the /openconfig-network-instance/network-instances/network-instance/afts/policy-forwarding/policy-forwarding-entry YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry struct {
	Index	*uint64	`path:"index" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State represents the /openconfig-network-instance/network-instances/network-instance/afts/policy-forwarding/policy-forwarding-entry/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State struct {
	Counters	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters	`path:"counters" module:"openconfig-network-instance"`
	EntryMetadata	Binary	`path:"entry-metadata" module:"openconfig-network-instance"`
	Index	*uint64	`path:"index" module:"openconfig-network-instance"`
	IpDscp	*uint8	`path:"ip-dscp" module:"openconfig-network-instance"`
	IpPrefix	*string	`path:"ip-prefix" module:"openconfig-network-instance"`
	IpProtocol	OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union	`path:"ip-protocol" module:"openconfig-network-instance"`
	L4DstPort	*uint16	`path:"l4-dst-port" module:"openconfig-network-instance"`
	L4SrcPort	*uint16	`path:"l4-src-port" module:"openconfig-network-instance"`
	MacAddress	*string	`path:"mac-address" module:"openconfig-network-instance"`
	MplsLabel	OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union	`path:"mpls-label" module:"openconfig-network-instance"`
	MplsTc	*uint8	`path:"mpls-tc" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}

// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-network-instance/network-instances/network-instance/afts/policy-forwarding/policy-forwarding-entry/state/ip-protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union()
}

// Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union() {}

// Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union ensures that UnionUint8
// implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union() {}

// To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State) To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union(i interface{}) (OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union, error) {
	if v, ok := i.(OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_IpProtocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}

// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-network-instance/network-instances/network-instance/afts/policy-forwarding/policy-forwarding-entry/state/mpls-label within the YANG schema.
// Union type can be one of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel, UnionUint32].
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union interface {
	// Union type can be one of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel, UnionUint32]
	Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union()
}

// Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union ensures that E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel
// implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union interface.
func (E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel) Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union() {}

// Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union ensures that UnionUint32
// implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union interface.
func (UnionUint32) Documentation_for_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union() {}

// To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State) To_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union(i interface{}) (OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union, error) {
	if v, ok := i.(OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel_Union, unknown union type, got: %T, want any of [E_OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_MplsLabel, uint32]", i, i)
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters represents the /openconfig-network-instance/network-instances/network-instance/afts/policy-forwarding/policy-forwarding-entry/state/counters YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters struct {
	OctetsForwarded	*uint64	`path:"octets-forwarded" module:"openconfig-network-instance"`
	PacketsForwarded	*uint64	`path:"packets-forwarded" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_PolicyForwarding_PolicyForwardingEntry_State_Counters) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced represents the /openconfig-network-instance/network-instances/network-instance/afts/state-synced YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced struct {
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State represents the /openconfig-network-instance/network-instances/network-instance/afts/state-synced/state YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State struct {
	Ipv4Unicast	*bool	`path:"ipv4-unicast" module:"openconfig-network-instance"`
	Ipv6Unicast	*bool	`path:"ipv6-unicast" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Afts_StateSynced_State) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config represents the /openconfig-network-instance/network-instances/network-instance/config YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config struct {
	Description	*string	`path:"description" module:"openconfig-network-instance"`
	FallbackNetworkInstance	*string	`path:"fallback-network-instance" module:"openconfig-network-instance"`
	Name	*string	`path:"name" module:"openconfig-network-instance"`
	RouteDistinguisher	*string	`path:"route-distinguisher" module:"openconfig-network-instance"`
	RouterId	*string	`path:"router-id" module:"openconfig-network-instance"`
	Type	E_OpenconfigNetworkInstanceTypes_NETWORK_INSTANCE_TYPE	`path:"type" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_Config) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints represents the /openconfig-network-instance/network-instances/network-instance/connection-points YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints struct {
	ConnectionPoint	map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint	`path:"connection-point" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints) IsYANGGoStruct() {}

// NewConnectionPoint creates a new entry in the ConnectionPoint list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints) NewConnectionPoint(ConnectionPointId string) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.ConnectionPoint == nil {
		t.ConnectionPoint = make(map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint)
	}

	key := ConnectionPointId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.ConnectionPoint[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list ConnectionPoint", key)
	}

	t.ConnectionPoint[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint{
		ConnectionPointId: &ConnectionPointId,
	}

	return t.ConnectionPoint[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint represents the /openconfig-network-instance/network-instances/network-instance/connection-points/connection-point YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint struct {
	Config	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config	`path:"config" module:"openconfig-network-instance"`
	ConnectionPointId	*string	`path:"connection-point-id" module:"openconfig-network-instance"`
	Endpoints	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints	`path:"endpoints" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint) ΛListKeyMap() (map[string]interface{}, error) {
	if t.ConnectionPointId == nil {
		return nil, fmt.Errorf("nil value for key ConnectionPointId")
	}

	return map[string]interface{}{
		"connection-point-id": *t.ConnectionPointId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config represents the /openconfig-network-instance/network-instances/network-instance/connection-points/connection-point/config YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config struct {
	ConnectionPointId	*string	`path:"connection-point-id" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Config) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints represents the /openconfig-network-instance/network-instances/network-instance/connection-points/connection-point/endpoints YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints struct {
	Endpoint	map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint	`path:"endpoint" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints) IsYANGGoStruct() {}

// NewEndpoint creates a new entry in the Endpoint list of the
// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints) NewEndpoint(EndpointId string) (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Endpoint == nil {
		t.Endpoint = make(map[string]*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint)
	}

	key := EndpointId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Endpoint[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Endpoint", key)
	}

	t.Endpoint[key] = &OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint{
		EndpointId: &EndpointId,
	}

	return t.Endpoint[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint represents the /openconfig-network-instance/network-instances/network-instance/connection-points/connection-point/endpoints/endpoint YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint struct {
	Config	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config	`path:"config" module:"openconfig-network-instance"`
	EndpointId	*string	`path:"endpoint-id" module:"openconfig-network-instance"`
	Local	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Local	`path:"local" module:"openconfig-network-instance"`
	Remote	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Remote	`path:"remote" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_State	`path:"state" module:"openconfig-network-instance"`
	Vxlan	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Vxlan	`path:"vxlan" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint struct, which is a YANG list entry.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint) ΛListKeyMap() (map[string]interface{}, error) {
	if t.EndpointId == nil {
		return nil, fmt.Errorf("nil value for key EndpointId")
	}

	return map[string]interface{}{
		"endpoint-id": *t.EndpointId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config represents the /openconfig-network-instance/network-instances/network-instance/connection-points/connection-point/endpoints/endpoint/config YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config struct {
	EndpointId	*string	`path:"endpoint-id" module:"openconfig-network-instance"`
	Precedence	*uint16	`path:"precedence" module:"openconfig-network-instance"`
	Type	E_OpenconfigNetworkInstanceTypes_ENDPOINT_TYPE	`path:"type" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Config) ΛBelongingModule() string {
	return "openconfig-network-instance"
}


// OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Local represents the /openconfig-network-instance/network-instances/network-instance/connection-points/connection-point/endpoints/endpoint/local YANG schema element.
type OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Local struct {
	Config	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Local_Config	`path:"config" module:"openconfig-network-instance"`
	State	*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Local_State	`path:"state" module:"openconfig-network-instance"`
}

// IsYANGGoStruct ensures that OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Local implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_ConnectionPoint_Endpoints_Endpoint_Local) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigNetworkInstance_NetworkInstances_NetworkInstance_ConnectionPoints_Connec