/*
Package arista is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was false
in this case).

This package was generated by /home/bob/go/pkg/mod/github.com/openconfig/ygot@v0.27.0/genutil/names.go
using the following YANG input files:
	- ../../../models/arista/EOS-4.28.2F/release/openconfig/models/lldp/arista-lldp-augments.yang
	- ../../../models/arista/EOS-4.28.2F/release/openconfig/models/lldp/arista-lldp-deviations.yang
	- ../../../models/arista/EOS-4.28.2F/release/openconfig/models/system/arista-system-augments.yang
	- ../../../models/arista/EOS-4.28.2F/release/openconfig/models/system/arista-system-deviations.yang
	- ../../../models/arista/EOS-4.28.2F/openconfig/public/release/models/system/openconfig-system.yang
	- ../../../models/arista/EOS-4.28.2F/release/openconfig/models/interfaces/arista-intf-augments.yang
	- ../../../models/arista/EOS-4.28.2F/release/openconfig/models/interfaces/arista-intf-deviations.yang
Imported modules were sourced from:
	- ../../../models/openconfig/...
*/
package arista

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ytypes"
	gpb "github.com/openconfig/gnmi/proto/gnmi"
)

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

// UnionInt8 is an int8 type assignable to unions of which it is a subtype.
type UnionInt8 int8

// UnionInt16 is an int16 type assignable to unions of which it is a subtype.
type UnionInt16 int16

// UnionInt32 is an int32 type assignable to unions of which it is a subtype.
type UnionInt32 int32

// UnionInt64 is an int64 type assignable to unions of which it is a subtype.
type UnionInt64 int64

// UnionUint8 is a uint8 type assignable to unions of which it is a subtype.
type UnionUint8 uint8

// UnionUint16 is a uint16 type assignable to unions of which it is a subtype.
type UnionUint16 uint16

// UnionUint32 is a uint32 type assignable to unions of which it is a subtype.
type UnionUint32 uint32

// UnionUint64 is a uint64 type assignable to unions of which it is a subtype.
type UnionUint64 uint64

// UnionFloat64 is a float64 type assignable to unions of which it is a subtype.
type UnionFloat64 float64

// UnionString is a string type assignable to unions of which it is a subtype.
type UnionString string

// UnionBool is a bool type assignable to unions of which it is a subtype.
type UnionBool bool

// UnionUnsupported is an interface{} wrapper type for unsupported types. It is
// assignable to unions of which it is a subtype.
type UnionUnsupported struct {
	Value interface{}
}

var (
	SchemaTree map[string]*yang.Entry
	ΛEnumTypes map[string][]reflect.Type
)

func init() {
	var err error
	initΛEnumTypes()
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " +  err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root: &Device{},
		SchemaTree: uzp,
		Unmarshal: Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn )
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}
// ΓModelData contains the catalogue information corresponding to the modules for
// which Go code was generated.
var ΓModelData = []*gpb.ModelData{
	{
		Name: "arista-intf-augments",
		Organization: "Arista Networks <http://arista.com/>",
		Version: "1.7.0",
	},
	{
		Name: "arista-intf-deviations",
		Organization: "Arista Networks, Inc.",
		Version: "1.0.3",
	},
	{
		Name: "arista-lldp-augments",
		Organization: "Arista Networks, Inc.",
		Version: "1.0.1",
	},
	{
		Name: "arista-lldp-deviations",
		Organization: "Arista Networks, Inc.",
		Version: "1.1.0",
	},
	{
		Name: "arista-system-augments",
		Organization: "Arista Networks, Inc.",
		Version: "1.4.1",
	},
	{
		Name: "arista-system-deviations",
		Organization: "Arista Networks, Inc.",
		Version: "1.3.0",
	},
	{
		Name: "iana-if-type",
		Organization: "IANA",
	},
	{
		Name: "ietf-inet-types",
		Organization: "IETF NETMOD (NETCONF Data Modeling Language) Working Group",
	},
	{
		Name: "ietf-interfaces",
		Organization: "IETF NETMOD (Network Modeling) Working Group",
	},
	{
		Name: "ietf-yang-types",
		Organization: "IETF NETMOD (NETCONF Data Modeling Language) Working Group",
	},
	{
		Name: "openconfig-aaa",
		Organization: "OpenConfig working group",
		Version: "1.0.0",
	},
	{
		Name: "openconfig-aaa-types",
		Organization: "OpenConfig working group",
		Version: "0.4.1",
	},
	{
		Name: "openconfig-acl",
		Organization: "OpenConfig working group",
		Version: "1.3.2",
	},
	{
		Name: "openconfig-aft",
		Organization: "OpenConfig working group",
		Version: "2.2.0",
	},
	{
		Name: "openconfig-aft-types",
		Organization: "OpenConfig Working Group",
		Version: "1.1.0",
	},
	{
		Name: "openconfig-alarm-types",
		Organization: "OpenConfig working group",
		Version: "0.2.1",
	},
	{
		Name: "openconfig-alarms",
		Organization: "OpenConfig working group",
		Version: "0.3.2",
	},
	{
		Name: "openconfig-bfd",
		Organization: "OpenConfig working group",
		Version: "0.2.4",
	},
	{
		Name: "openconfig-bgp",
		Organization: "OpenConfig working group",
		Version: "9.2.0",
	},
	{
		Name: "openconfig-bgp-types",
		Organization: "OpenConfig working group",
		Version: "5.3.1",
	},
	{
		Name: "openconfig-defined-sets",
		Organization: "OpenConfig working group",
		Version: "1.0.0",
	},
	{
		Name: "openconfig-evpn",
		Organization: "OpenConfig working group",
		Version: "0.3.0",
	},
	{
		Name: "openconfig-evpn-types",
		Organization: "OpenConfig working group",
		Version: "0.2.0",
	},
	{
		Name: "openconfig-extensions",
		Organization: "OpenConfig working group",
		Version: "0.5.1",
	},
	{
		Name: "openconfig-if-aggregate",
		Organization: "OpenConfig working group",
		Version: "2.4.4",
	},
	{
		Name: "openconfig-if-ethernet",
		Organization: "OpenConfig working group",
		Version: "2.12.2",
	},
	{
		Name: "openconfig-if-ip",
		Organization: "OpenConfig working group",
		Version: "3.1.0",
	},
	{
		Name: "openconfig-if-poe",
		Organization: "OpenConfig working group",
		Version: "0.1.1",
	},
	{
		Name: "openconfig-if-tunnel",
		Organization: "OpenConfig working group",
		Version: "0.1.1",
	},
	{
		Name: "openconfig-igmp",
		Organization: "OpenConfig working group",
		Version: "0.3.0",
	},
	{
		Name: "openconfig-igmp-types",
		Organization: "OpenConfig working group",
		Version: "0.1.1",
	},
	{
		Name: "openconfig-inet-types",
		Organization: "OpenConfig working group",
		Version: "0.5.0",
	},
	{
		Name: "openconfig-interfaces",
		Organization: "OpenConfig working group",
		Version: "2.5.0",
	},
	{
		Name: "openconfig-isis",
		Organization: "OpenConfig working group",
		Version: "1.1.0",
	},
	{
		Name: "openconfig-isis-lsdb-types",
		Organization: "OpenConfig working group",
		Version: "0.4.2",
	},
	{
		Name: "openconfig-isis-types",
		Organization: "OpenConfig working group",
		Version: "0.6.0",
	},
	{
		Name: "openconfig-keychain",
		Organization: "OpenConfig working group",
		Version: "0.4.0",
	},
	{
		Name: "openconfig-keychain-types",
		Organization: "OpenConfig working group",
		Version: "0.2.0",
	},
	{
		Name: "openconfig-license",
		Organization: "OpenConfig working group",
		Version: "0.2.0",
	},
	{
		Name: "openconfig-lldp",
		Organization: "OpenConfig working group",
		Version: "0.2.1",
	},
	{
		Name: "openconfig-lldp-types",
		Organization: "OpenConfig working group",
		Version: "0.1.1",
	},
	{
		Name: "openconfig-local-routing",
		Organization: "OpenConfig working group",
		Version: "2.0.1",
	},
	{
		Name: "openconfig-messages",
		Organization: "OpenConfig working group",
		Version: "0.0.1",
	},
	{
		Name: "openconfig-mpls",
		Organization: "OpenConfig working group",
		Version: "3.3.0",
	},
	{
		Name: "openconfig-mpls-ldp",
		Organization: "OpenConfig working group",
		Version: "3.2.0",
	},
	{
		Name: "openconfig-mpls-rsvp",
		Organization: "OpenConfig working group",
		Version: "4.0.0",
	},
	{
		Name: "openconfig-mpls-sr",
		Organization: "OpenConfig working group",
		Version: "3.0.1",
	},
	{
		Name: "openconfig-mpls-types",
		Organization: "OpenConfig working group",
		Version: "3.4.0",
	},
	{
		Name: "openconfig-network-instance",
		Organization: "OpenConfig working group",
		Version: "4.0.0",
	},
	{
		Name: "openconfig-network-instance-l3",
		Organization: "OpenConfig working group",
		Version: "2.0.0",
	},
	{
		Name: "openconfig-network-instance-types",
		Organization: "OpenConfig working group",
		Version: "0.9.3",
	},
	{
		Name: "openconfig-ospf-types",
		Organization: "OpenConfig working group",
		Version: "0.1.3",
	},
	{
		Name: "openconfig-ospfv2",
		Organization: "OpenConfig working group",
		Version: "0.4.0",
	},
	{
		Name: "openconfig-packet-match",
		Organization: "OpenConfig working group",
		Version: "1.4.0",
	},
	{
		Name: "openconfig-packet-match-types",
		Organization: "OpenConfig working group",
		Version: "1.3.2",
	},
	{
		Name: "openconfig-pcep",
		Organization: "OpenConfig working group",
		Version: "0.1.0",
	},
	{
		Name: "openconfig-pim",
		Organization: "OpenConfig working group",
		Version: "0.4.2",
	},
	{
		Name: "openconfig-pim-types",
		Organization: "OpenConfig working group",
		Version: "0.1.1",
	},
	{
		Name: "openconfig-platform",
		Organization: "OpenConfig working group",
		Version: "0.22.0",
	},
	{
		Name: "openconfig-platform-types",
		Organization: "OpenConfig working group",
		Version: "1.5.0",
	},
	{
		Name: "openconfig-policy-forwarding",
		Organization: "OpenConfig working group",
		Version: "0.5.0",
	},
	{
		Name: "openconfig-policy-types",
		Organization: "OpenConfig working group",
		Version: "3.2.3",
	},
	{
		Name: "openconfig-procmon",
		Organization: "OpenConfig working group",
		Version: "0.4.0",
	},
	{
		Name: "openconfig-rib-bgp",
		Organization: "OpenConfig working group",
		Version: "0.9.0",
	},
	{
		Name: "openconfig-rib-bgp-types",
		Organization: "OpenConfig working group",
		Version: "0.5.0",
	},
	{
		Name: "openconfig-routing-policy",
		Organization: "OpenConfig working group",
		Version: "3.3.0",
	},
	{
		Name: "openconfig-segment-routing",
		Organization: "OpenConfig working group",
		Version: "0.3.1",
	},
	{
		Name: "openconfig-segment-routing-types",
		Organization: "OpenConfig working group",
		Version: "0.2.0",
	},
	{
		Name: "openconfig-srte-policy",
		Organization: "OpenConfig working group",
		Version: "0.2.3",
	},
	{
		Name: "openconfig-system",
		Organization: "OpenConfig working group",
		Version: "0.13.0",
	},
	{
		Name: "openconfig-system-grpc",
		Organization: "OpenConfig working group",
		Version: "1.0.0",
	},
	{
		Name: "openconfig-system-logging",
		Organization: "OpenConfig working group",
		Version: "0.4.1",
	},
	{
		Name: "openconfig-system-terminal",
		Organization: "OpenConfig working group",
		Version: "0.3.1",
	},
	{
		Name: "openconfig-types",
		Organization: "OpenConfig working group",
		Version: "0.6.0",
	},
	{
		Name: "openconfig-vlan",
		Organization: "OpenConfig working group",
		Version: "3.2.1",
	},
	{
		Name: "openconfig-vlan-types",
		Organization: "OpenConfig working group",
		Version: "3.2.0",
	},
	{
		Name: "openconfig-yang-types",
		Organization: "OpenConfig working group",
		Version: "0.3.1",
	},
}

// Device represents the /device YANG schema element.
type Device struct {
	Acl	*OpenconfigAcl_Acl	`path:"acl" module:"openconfig-acl"`
	Bfd	*OpenconfigBfd_Bfd	`path:"bfd" module:"openconfig-bfd"`
	Components	*OpenconfigPlatform_Components	`path:"components" module:"openconfig-platform"`
	DefinedSets	*OpenconfigDefinedSets_DefinedSets	`path:"defined-sets" module:"openconfig-defined-sets"`
	Interfaces	*OpenconfigInterfaces_Interfaces	`path:"interfaces" module:"openconfig-interfaces"`
	Keychains	*OpenconfigKeychain_Keychains	`path:"keychains" module:"openconfig-keychain"`
	Lldp	*OpenconfigLldp_Lldp	`path:"lldp" module:"openconfig-lldp"`
	Messages	*OpenconfigMessages_Messages	`path:"messages" module:"openconfig-messages"`
	NetworkInstances	*OpenconfigNetworkInstance_NetworkInstances	`path:"network-instances" module:"openconfig-network-instance"`
	RoutingPolicy	*OpenconfigRoutingPolicy_RoutingPolicy	`path:"routing-policy" module:"openconfig-routing-policy"`
	System	*OpenconfigSystem_System	`path:"system" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Device.
func (*Device) ΛBelongingModule() string {
	return ""
}


// OpenconfigAcl_Acl represents the /openconfig-acl/acl YANG schema element.
type OpenconfigAcl_Acl struct {
	AclSets	*OpenconfigAcl_Acl_AclSets	`path:"acl-sets" module:"openconfig-acl"`
	Config	*OpenconfigAcl_Acl_Config	`path:"config" module:"openconfig-acl"`
	Interfaces	*OpenconfigAcl_Acl_Interfaces	`path:"interfaces" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl.
func (*OpenconfigAcl_Acl) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets represents the /openconfig-acl/acl/acl-sets YANG schema element.
type OpenconfigAcl_Acl_AclSets struct {
	AclSet	map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet	`path:"acl-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_AclSets_AclSet_Key represents the key for list AclSet of element /openconfig-acl/acl/acl-sets.
type OpenconfigAcl_Acl_AclSets_AclSet_Key struct {
	Name	string	`path:"name"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type"`
}

// IsYANGGoKeyStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigAcl_Acl_AclSets_AclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigAcl_Acl_AclSets_AclSet_Key key struct.
func (t OpenconfigAcl_Acl_AclSets_AclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"name": t.Name,
		"type": t.Type,
	}, nil
}

// NewAclSet creates a new entry in the AclSet list of the
// OpenconfigAcl_Acl_AclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_AclSets) NewAclSet(Name string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_AclSets_AclSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclSet == nil {
		t.AclSet = make(map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet)
	}

	key := OpenconfigAcl_Acl_AclSets_AclSet_Key{
		Name: Name,
		Type: Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclSet", key)
	}

	t.AclSet[key] = &OpenconfigAcl_Acl_AclSets_AclSet{
		Name: &Name,
		Type: Type,
	}

	return t.AclSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets.
func (*OpenconfigAcl_Acl_AclSets) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet represents the /openconfig-acl/acl/acl-sets/acl-set YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet struct {
	AclEntries	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries	`path:"acl-entries" module:"openconfig-acl"`
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_Config	`path:"config" module:"openconfig-acl"`
	Name	*string	`path:"name" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_State	`path:"state" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_AclSets_AclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}


	return map[string]interface{}{
		"name": *t.Name,
		"type": t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet.
func (*OpenconfigAcl_Acl_AclSets_AclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries struct {
	AclEntry	map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry	`path:"acl-entry" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry struct {
	Actions	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions	`path:"actions" module:"openconfig-acl"`
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config	`path:"config" module:"openconfig-acl"`
	InputInterface	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface	`path:"input-interface" module:"openconfig-acl"`
	Ipv4	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4	`path:"ipv4" module:"openconfig-acl"`
	Ipv6	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6	`path:"ipv6" module:"openconfig-acl"`
	L2	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2	`path:"l2" module:"openconfig-acl"`
	Mpls	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls	`path:"mpls" module:"openconfig-acl"`
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State	`path:"state" module:"openconfig-acl"`
	Transport	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport	`path:"transport" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config struct {
	ForwardingAction	E_OpenconfigAcl_FORWARDING_ACTION	`path:"forwarding-action" module:"openconfig-acl"`
	LogAction	E_OpenconfigAcl_LOG_ACTION	`path:"log-action" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State struct {
	ForwardingAction	E_OpenconfigAcl_FORWARDING_ACTION	`path:"forwarding-action" module:"openconfig-acl"`
	LogAction	E_OpenconfigAcl_LOG_ACTION	`path:"log-action" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config struct {
	Description	*string	`path:"description" module:"openconfig-acl"`
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config	`path:"config" module:"openconfig-acl"`
	InterfaceRef	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef	`path:"interface-ref" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-acl"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-acl"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State struct {
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config struct {
	DestinationAddress	*string	`path:"destination-address" module:"openconfig-acl"`
	DestinationAddressPrefixSet	*string	`path:"destination-address-prefix-set" module:"openconfig-acl"`
	Dscp	*uint8	`path:"dscp" module:"openconfig-acl"`
	DscpSet	[]uint8	`path:"dscp-set" module:"openconfig-acl"`
	HopLimit	*uint8	`path:"hop-limit" module:"openconfig-acl"`
	Protocol	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union	`path:"protocol" module:"openconfig-acl"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-acl"`
	SourceAddressPrefixSet	*string	`path:"source-address-prefix-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State struct {
	DestinationAddress	*string	`path:"destination-address" module:"openconfig-acl"`
	DestinationAddressPrefixSet	*string	`path:"destination-address-prefix-set" module:"openconfig-acl"`
	Dscp	*uint8	`path:"dscp" module:"openconfig-acl"`
	DscpSet	[]uint8	`path:"dscp-set" module:"openconfig-acl"`
	HopLimit	*uint8	`path:"hop-limit" module:"openconfig-acl"`
	Protocol	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union	`path:"protocol" module:"openconfig-acl"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-acl"`
	SourceAddressPrefixSet	*string	`path:"source-address-prefix-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config struct {
	DestinationAddress	*string	`path:"destination-address" module:"openconfig-acl"`
	DestinationAddressPrefixSet	*string	`path:"destination-address-prefix-set" module:"openconfig-acl"`
	DestinationFlowLabel	*uint32	`path:"destination-flow-label" module:"openconfig-acl"`
	Dscp	*uint8	`path:"dscp" module:"openconfig-acl"`
	DscpSet	[]uint8	`path:"dscp-set" module:"openconfig-acl"`
	HopLimit	*uint8	`path:"hop-limit" module:"openconfig-acl"`
	Protocol	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union	`path:"protocol" module:"openconfig-acl"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-acl"`
	SourceAddressPrefixSet	*string	`path:"source-address-prefix-set" module:"openconfig-acl"`
	SourceFlowLabel	*uint32	`path:"source-flow-label" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State struct {
	DestinationAddress	*string	`path:"destination-address" module:"openconfig-acl"`
	DestinationAddressPrefixSet	*string	`path:"destination-address-prefix-set" module:"openconfig-acl"`
	DestinationFlowLabel	*uint32	`path:"destination-flow-label" module:"openconfig-acl"`
	Dscp	*uint8	`path:"dscp" module:"openconfig-acl"`
	DscpSet	[]uint8	`path:"dscp-set" module:"openconfig-acl"`
	HopLimit	*uint8	`path:"hop-limit" module:"openconfig-acl"`
	Protocol	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union	`path:"protocol" module:"openconfig-acl"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-acl"`
	SourceAddressPrefixSet	*string	`path:"source-address-prefix-set" module:"openconfig-acl"`
	SourceFlowLabel	*uint32	`path:"source-flow-label" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state/protocol within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, UnionUint8]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union ensures that E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface.
func (E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union ensures that UnionUint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface.
func (UnionUint8) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint8:
		return UnionUint8(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config struct {
	DestinationMac	*string	`path:"destination-mac" module:"openconfig-acl"`
	DestinationMacMask	*string	`path:"destination-mac-mask" module:"openconfig-acl"`
	Ethertype	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union	`path:"ethertype" module:"openconfig-acl"`
	SourceMac	*string	`path:"source-mac" module:"openconfig-acl"`
	SourceMacMask	*string	`path:"source-mac-mask" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union ensures that E_OpenconfigPacketMatchTypes_ETHERTYPE
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface.
func (E_OpenconfigPacketMatchTypes_ETHERTYPE) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_ETHERTYPE, uint16]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State struct {
	DestinationMac	*string	`path:"destination-mac" module:"openconfig-acl"`
	DestinationMacMask	*string	`path:"destination-mac-mask" module:"openconfig-acl"`
	Ethertype	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union	`path:"ethertype" module:"openconfig-acl"`
	SourceMac	*string	`path:"source-mac" module:"openconfig-acl"`
	SourceMacMask	*string	`path:"source-mac-mask" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state/ethertype within the YANG schema.
// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface {
	// Union type can be one of [E_OpenconfigPacketMatchTypes_ETHERTYPE, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union ensures that E_OpenconfigPacketMatchTypes_ETHERTYPE
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface.
func (E_OpenconfigPacketMatchTypes_ETHERTYPE) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_ETHERTYPE, uint16]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config struct {
	EndLabelValue	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union	`path:"end-label-value" module:"openconfig-acl"`
	StartLabelValue	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union	`path:"start-label-value" module:"openconfig-acl"`
	TrafficClass	*uint8	`path:"traffic-class" module:"openconfig-acl"`
	TtlValue	*uint8	`path:"ttl-value" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/end-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, uint32]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/start-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, uint32]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State struct {
	EndLabelValue	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union	`path:"end-label-value" module:"openconfig-acl"`
	StartLabelValue	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union	`path:"start-label-value" module:"openconfig-acl"`
	TrafficClass	*uint8	`path:"traffic-class" module:"openconfig-acl"`
	TtlValue	*uint8	`path:"ttl-value" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state/end-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_EndLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_EndLabelValue, uint32]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state/start-label-value within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, UnionUint32].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, UnionUint32]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union ensures that UnionUint32
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union interface.
func (UnionUint32) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_State_StartLabelValue_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Mpls_Config_StartLabelValue, uint32]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State struct {
	Description	*string	`path:"description" module:"openconfig-acl"`
	MatchedOctets	*uint64	`path:"matched-octets" module:"openconfig-acl"`
	MatchedPackets	*uint64	`path:"matched-packets" module:"openconfig-acl"`
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport struct {
	Config	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config struct {
	DestinationPort	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union	`path:"destination-port" module:"openconfig-acl"`
	DestinationPortSet	*string	`path:"destination-port-set" module:"openconfig-acl"`
	SourcePort	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union	`path:"source-port" module:"openconfig-acl"`
	SourcePortSet	*string	`path:"source-port-set" module:"openconfig-acl"`
	TcpFlags	[]E_OpenconfigPacketMatchTypes_TCP_FLAGS	`path:"tcp-flags" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, string, uint16]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, string, uint16]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State struct {
	DestinationPort	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union	`path:"destination-port" module:"openconfig-acl"`
	DestinationPortSet	*string	`path:"destination-port-set" module:"openconfig-acl"`
	SourcePort	OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union	`path:"source-port" module:"openconfig-acl"`
	SourcePortSet	*string	`path:"source-port-set" module:"openconfig-acl"`
	TcpFlags	[]E_OpenconfigPacketMatchTypes_TCP_FLAGS	`path:"tcp-flags" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) ΛBelongingModule() string {
	return "openconfig-acl"
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/destination-port within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, string, uint16]", i, i)
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/source-port within the YANG schema.
// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, UnionString, UnionUint16].
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface {
	// Union type can be one of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, UnionString, UnionUint16]
	Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union()
}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that UnionString
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (UnionString) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {}

// Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that UnionUint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (UnionUint16) Documentation_for_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union, error) {
	if v, ok := i.(OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, string, uint16]", i, i)
}


// OpenconfigAcl_Acl_AclSets_AclSet_Config represents the /openconfig-acl/acl/acl-sets/acl-set/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_Config struct {
	Description	*string	`path:"description" module:"openconfig-acl"`
	Name	*string	`path:"name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_Config.
func (*OpenconfigAcl_Acl_AclSets_AclSet_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_AclSets_AclSet_State represents the /openconfig-acl/acl/acl-sets/acl-set/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_State struct {
	Description	*string	`path:"description" module:"openconfig-acl"`
	Name	*string	`path:"name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_AclSets_AclSet_State.
func (*OpenconfigAcl_Acl_AclSets_AclSet_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Config represents the /openconfig-acl/acl/config YANG schema element.
type OpenconfigAcl_Acl_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Config.
func (*OpenconfigAcl_Acl_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces represents the /openconfig-acl/acl/interfaces YANG schema element.
type OpenconfigAcl_Acl_Interfaces struct {
	Interface	map[string]*OpenconfigAcl_Acl_Interfaces_Interface	`path:"interface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigAcl_Acl_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces) NewInterface(Id string) (*OpenconfigAcl_Acl_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigAcl_Acl_Interfaces_Interface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigAcl_Acl_Interfaces_Interface{
		Id: &Id,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces.
func (*OpenconfigAcl_Acl_Interfaces) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface represents the /openconfig-acl/acl/interfaces/interface YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface struct {
	Config	*OpenconfigAcl_Acl_Interfaces_Interface_Config	`path:"config" module:"openconfig-acl"`
	EgressAclSets	*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets	`path:"egress-acl-sets" module:"openconfig-acl"`
	Id	*string	`path:"id" module:"openconfig-acl"`
	IngressAclSets	*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets	`path:"ingress-acl-sets" module:"openconfig-acl"`
	InterfaceRef	*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef	`path:"interface-ref" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface.
func (*OpenconfigAcl_Acl_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_Config represents the /openconfig-acl/acl/interfaces/interface/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_Config struct {
	Id	*string	`path:"id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets struct {
	EgressAclSet	map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet	`path:"egress-acl-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key represents the key for list EgressAclSet of element /openconfig-acl/acl/interfaces/interface/egress-acl-sets.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key struct {
	SetName	string	`path:"set-name"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type"`
}

// IsYANGGoKeyStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key key struct.
func (t OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"set-name": t.SetName,
		"type": t.Type,
	}, nil
}

// NewEgressAclSet creates a new entry in the EgressAclSet list of the
// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) NewEgressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.EgressAclSet == nil {
		t.EgressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet)
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key{
		SetName: SetName,
		Type: Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.EgressAclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list EgressAclSet", key)
	}

	t.EgressAclSet[key] = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet{
		SetName: &SetName,
		Type: Type,
	}

	return t.EgressAclSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet struct {
	AclEntries	*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries	`path:"acl-entries" module:"openconfig-acl"`
	Config	*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config	`path:"config" module:"openconfig-acl"`
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State	`path:"state" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SetName == nil {
		return nil, fmt.Errorf("nil value for key SetName")
	}


	return map[string]interface{}{
		"set-name": *t.SetName,
		"type": t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries struct {
	AclEntry	map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry	`path:"acl-entry" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry struct {
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State struct {
	MatchedOctets	*uint64	`path:"matched-octets" module:"openconfig-acl"`
	MatchedPackets	*uint64	`path:"matched-packets" module:"openconfig-acl"`
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config struct {
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State struct {
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets struct {
	IngressAclSet	map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet	`path:"ingress-acl-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key represents the key for list IngressAclSet of element /openconfig-acl/acl/interfaces/interface/ingress-acl-sets.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key struct {
	SetName	string	`path:"set-name"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type"`
}

// IsYANGGoKeyStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key key struct.
func (t OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"set-name": t.SetName,
		"type": t.Type,
	}, nil
}

// NewIngressAclSet creates a new entry in the IngressAclSet list of the
// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) NewIngressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.IngressAclSet == nil {
		t.IngressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet)
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key{
		SetName: SetName,
		Type: Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.IngressAclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list IngressAclSet", key)
	}

	t.IngressAclSet[key] = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet{
		SetName: &SetName,
		Type: Type,
	}

	return t.IngressAclSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet struct {
	AclEntries	*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries	`path:"acl-entries" module:"openconfig-acl"`
	Config	*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config	`path:"config" module:"openconfig-acl"`
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State	`path:"state" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SetName == nil {
		return nil, fmt.Errorf("nil value for key SetName")
	}


	return map[string]interface{}{
		"set-name": *t.SetName,
		"type": t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries struct {
	AclEntry	map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry	`path:"acl-entry" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry struct {
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State struct {
	MatchedOctets	*uint64	`path:"matched-octets" module:"openconfig-acl"`
	MatchedPackets	*uint64	`path:"matched-packets" module:"openconfig-acl"`
	SequenceId	*uint32	`path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config struct {
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State struct {
	SetName	*string	`path:"set-name" module:"openconfig-acl"`
	Type	E_OpenconfigAcl_ACL_TYPE	`path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef represents the /openconfig-acl/acl/interfaces/interface/interface-ref YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef struct {
	Config	*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config	`path:"config" module:"openconfig-acl"`
	State	*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State	`path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config represents the /openconfig-acl/acl/interfaces/interface/interface-ref/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-acl"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State represents the /openconfig-acl/acl/interfaces/interface/interface-ref/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-acl"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_Interfaces_Interface_State represents the /openconfig-acl/acl/interfaces/interface/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_State struct {
	Id	*string	`path:"id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_Interfaces_Interface_State.
func (*OpenconfigAcl_Acl_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigAcl_Acl_State represents the /openconfig-acl/acl/state YANG schema element.
type OpenconfigAcl_Acl_State struct {
	CounterCapability	E_OpenconfigAcl_ACL_COUNTER_CAPABILITY	`path:"counter-capability" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigAcl_Acl_State.
func (*OpenconfigAcl_Acl_State) ΛBelongingModule() string {
	return "openconfig-acl"
}


// OpenconfigBfd_Bfd represents the /openconfig-bfd/bfd YANG schema element.
type OpenconfigBfd_Bfd struct {
	Interfaces	*OpenconfigBfd_Bfd_Interfaces	`path:"interfaces" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd.
func (*OpenconfigBfd_Bfd) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces represents the /openconfig-bfd/bfd/interfaces YANG schema element.
type OpenconfigBfd_Bfd_Interfaces struct {
	Interface	map[string]*OpenconfigBfd_Bfd_Interfaces_Interface	`path:"interface" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigBfd_Bfd_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces) NewInterface(Id string) (*OpenconfigBfd_Bfd_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigBfd_Bfd_Interfaces_Interface{
		Id: &Id,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces.
func (*OpenconfigBfd_Bfd_Interfaces) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface represents the /openconfig-bfd/bfd/interfaces/interface YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface struct {
	Config	*OpenconfigBfd_Bfd_Interfaces_Interface_Config	`path:"config" module:"openconfig-bfd"`
	Id	*string	`path:"id" module:"openconfig-bfd"`
	InterfaceRef	*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef	`path:"interface-ref" module:"openconfig-bfd"`
	MicroBfdSessions	*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions	`path:"micro-bfd-sessions" module:"openconfig-bfd"`
	Peers	*OpenconfigBfd_Bfd_Interfaces_Interface_Peers	`path:"peers" module:"openconfig-bfd"`
	State	*OpenconfigBfd_Bfd_Interfaces_Interface_State	`path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface.
func (*OpenconfigBfd_Bfd_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Config represents the /openconfig-bfd/bfd/interfaces/interface/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Config struct {
	DesiredMinimumTxInterval	*uint32	`path:"desired-minimum-tx-interval" module:"openconfig-bfd"`
	DetectionMultiplier	*uint8	`path:"detection-multiplier" module:"openconfig-bfd"`
	EnablePerMemberLink	*bool	`path:"enable-per-member-link" module:"openconfig-bfd"`
	Enabled	*bool	`path:"enabled" module:"openconfig-bfd"`
	Id	*string	`path:"id" module:"openconfig-bfd"`
	LocalAddress	*string	`path:"local-address" module:"openconfig-bfd"`
	RequiredMinimumReceive	*uint32	`path:"required-minimum-receive" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Config.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef struct {
	Config	*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config	`path:"config" module:"openconfig-bfd"`
	State	*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State	`path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-bfd"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-bfd"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions struct {
	MicroBfdSession	map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession	`path:"micro-bfd-session" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) IsYANGGoStruct() {}

// NewMicroBfdSession creates a new entry in the MicroBfdSession list of the
// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) NewMicroBfdSession(MemberInterface string) (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.MicroBfdSession == nil {
		t.MicroBfdSession = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession)
	}

	key := MemberInterface

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.MicroBfdSession[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list MicroBfdSession", key)
	}

	t.MicroBfdSession[key] = &OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession{
		MemberInterface: &MemberInterface,
	}

	return t.MicroBfdSession[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession struct {
	Config	*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config	`path:"config" module:"openconfig-bfd"`
	MemberInterface	*string	`path:"member-interface" module:"openconfig-bfd"`
	State	*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State	`path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛListKeyMap() (map[string]interface{}, error) {
	if t.MemberInterface == nil {
		return nil, fmt.Errorf("nil value for key MemberInterface")
	}

	return map[string]interface{}{
		"member-interface": *t.MemberInterface,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config struct {
	LocalAddress	*string	`path:"local-address" module:"openconfig-bfd"`
	MemberInterface	*string	`path:"member-interface" module:"openconfig-bfd"`
	RemoteAddress	*string	`path:"remote-address" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State struct {
	Async	*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async	`path:"async" module:"openconfig-bfd"`
	DemandModeRequested	*bool	`path:"demand-mode-requested" module:"openconfig-bfd"`
	FailureTransitions	*uint64	`path:"failure-transitions" module:"openconfig-bfd"`
	LastFailureTime	*uint64	`path:"last-failure-time" module:"openconfig-bfd"`
	LocalAddress	*string	`path:"local-address" module:"openconfig-bfd"`
	LocalDiagnosticCode	E_OpenconfigBfd_BfdDiagnosticCode	`path:"local-diagnostic-code" module:"openconfig-bfd"`
	LocalDiscriminator	*string	`path:"local-discriminator" module:"openconfig-bfd"`
	MemberInterface	*string	`path:"member-interface" module:"openconfig-bfd"`
	RemoteAddress	*string	`path:"remote-address" module:"openconfig-bfd"`
	RemoteAuthenticationEnabled	*bool	`path:"remote-authentication-enabled" module:"openconfig-bfd"`
	RemoteControlPlaneIndependent	*bool	`path:"remote-control-plane-independent" module:"openconfig-bfd"`
	RemoteDiagnosticCode	E_OpenconfigBfd_BfdDiagnosticCode	`path:"remote-diagnostic-code" module:"openconfig-bfd"`
	RemoteDiscriminator	*string	`path:"remote-discriminator" module:"openconfig-bfd"`
	RemoteMinimumReceiveInterval	*uint32	`path:"remote-minimum-receive-interval" module:"openconfig-bfd"`
	RemoteSessionState	E_OpenconfigBfd_BfdSessionState	`path:"remote-session-state" module:"openconfig-bfd"`
	SessionState	E_OpenconfigBfd_BfdSessionState	`path:"session-state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async struct {
	LastPacketReceived	*uint64	`path:"last-packet-received" module:"openconfig-bfd"`
	LastPacketTransmitted	*uint64	`path:"last-packet-transmitted" module:"openconfig-bfd"`
	ReceivedPackets	*uint64	`path:"received-packets" module:"openconfig-bfd"`
	TransmittedPackets	*uint64	`path:"transmitted-packets" module:"openconfig-bfd"`
	UpTransitions	*uint64	`path:"up-transitions" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Peers represents the /openconfig-bfd/bfd/interfaces/interface/peers YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers struct {
	Peer	map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer	`path:"peer" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers) IsYANGGoStruct() {}

// NewPeer creates a new entry in the Peer list of the
// OpenconfigBfd_Bfd_Interfaces_Interface_Peers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) NewPeer(LocalDiscriminator string) (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Peer == nil {
		t.Peer = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer)
	}

	key := LocalDiscriminator

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Peer[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Peer", key)
	}

	t.Peer[key] = &OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer{
		LocalDiscriminator: &LocalDiscriminator,
	}

	return t.Peer[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer struct {
	LocalDiscriminator	*string	`path:"local-discriminator" module:"openconfig-bfd"`
	State	*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State	`path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛListKeyMap() (map[string]interface{}, error) {
	if t.LocalDiscriminator == nil {
		return nil, fmt.Errorf("nil value for key LocalDiscriminator")
	}

	return map[string]interface{}{
		"local-discriminator": *t.LocalDiscriminator,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State struct {
	Async	*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async	`path:"async" module:"openconfig-bfd"`
	DemandModeRequested	*bool	`path:"demand-mode-requested" module:"openconfig-bfd"`
	Echo	*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo	`path:"echo" module:"openconfig-bfd"`
	FailureTransitions	*uint64	`path:"failure-transitions" module:"openconfig-bfd"`
	LastFailureTime	*uint64	`path:"last-failure-time" module:"openconfig-bfd"`
	LocalAddress	*string	`path:"local-address" module:"openconfig-bfd"`
	LocalDiagnosticCode	E_OpenconfigBfd_BfdDiagnosticCode	`path:"local-diagnostic-code" module:"openconfig-bfd"`
	LocalDiscriminator	*string	`path:"local-discriminator" module:"openconfig-bfd"`
	RemoteAddress	*string	`path:"remote-address" module:"openconfig-bfd"`
	RemoteAuthenticationEnabled	*bool	`path:"remote-authentication-enabled" module:"openconfig-bfd"`
	RemoteControlPlaneIndependent	*bool	`path:"remote-control-plane-independent" module:"openconfig-bfd"`
	RemoteDiagnosticCode	E_OpenconfigBfd_BfdDiagnosticCode	`path:"remote-diagnostic-code" module:"openconfig-bfd"`
	RemoteDiscriminator	*string	`path:"remote-discriminator" module:"openconfig-bfd"`
	RemoteMinimumReceiveInterval	*uint32	`path:"remote-minimum-receive-interval" module:"openconfig-bfd"`
	RemoteSessionState	E_OpenconfigBfd_BfdSessionState	`path:"remote-session-state" module:"openconfig-bfd"`
	SessionState	E_OpenconfigBfd_BfdSessionState	`path:"session-state" module:"openconfig-bfd"`
	SubscribedProtocols	[]E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE	`path:"subscribed-protocols" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async struct {
	LastPacketReceived	*uint64	`path:"last-packet-received" module:"openconfig-bfd"`
	LastPacketTransmitted	*uint64	`path:"last-packet-transmitted" module:"openconfig-bfd"`
	ReceivedPackets	*uint64	`path:"received-packets" module:"openconfig-bfd"`
	TransmittedPackets	*uint64	`path:"transmitted-packets" module:"openconfig-bfd"`
	UpTransitions	*uint64	`path:"up-transitions" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo struct {
	Active	*bool	`path:"active" module:"openconfig-bfd"`
	LastPacketReceived	*uint64	`path:"last-packet-received" module:"openconfig-bfd"`
	LastPacketTransmitted	*uint64	`path:"last-packet-transmitted" module:"openconfig-bfd"`
	ReceivedPackets	*uint64	`path:"received-packets" module:"openconfig-bfd"`
	TransmittedPackets	*uint64	`path:"transmitted-packets" module:"openconfig-bfd"`
	UpTransitions	*uint64	`path:"up-transitions" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigBfd_Bfd_Interfaces_Interface_State represents the /openconfig-bfd/bfd/interfaces/interface/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_State struct {
	DesiredMinimumTxInterval	*uint32	`path:"desired-minimum-tx-interval" module:"openconfig-bfd"`
	DetectionMultiplier	*uint8	`path:"detection-multiplier" module:"openconfig-bfd"`
	EnablePerMemberLink	*bool	`path:"enable-per-member-link" module:"openconfig-bfd"`
	Enabled	*bool	`path:"enabled" module:"openconfig-bfd"`
	Id	*string	`path:"id" module:"openconfig-bfd"`
	LocalAddress	*string	`path:"local-address" module:"openconfig-bfd"`
	RequiredMinimumReceive	*uint32	`path:"required-minimum-receive" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigBfd_Bfd_Interfaces_Interface_State.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-bfd"
}


// OpenconfigDefinedSets_DefinedSets represents the /openconfig-defined-sets/defined-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets struct {
	Ipv4PrefixSets	*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets	`path:"ipv4-prefix-sets" module:"openconfig-defined-sets"`
	Ipv6PrefixSets	*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets	`path:"ipv6-prefix-sets" module:"openconfig-defined-sets"`
	PortSets	*OpenconfigDefinedSets_DefinedSets_PortSets	`path:"port-sets" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets.
func (*OpenconfigDefinedSets_DefinedSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets struct {
	Ipv4PrefixSet	map[string]*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet	`path:"ipv4-prefix-set" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) IsYANGGoStruct() {}

// NewIpv4PrefixSet creates a new entry in the Ipv4PrefixSet list of the
// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) NewIpv4PrefixSet(Name string) (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Ipv4PrefixSet == nil {
		t.Ipv4PrefixSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Ipv4PrefixSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Ipv4PrefixSet", key)
	}

	t.Ipv4PrefixSet[key] = &OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet{
		Name: &Name,
	}

	return t.Ipv4PrefixSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets/ipv4-prefix-set YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet struct {
	Config	*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config	`path:"config" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	State	*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State	`path:"state" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet struct, which is a YANG list entry.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets/ipv4-prefix-set/config YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Prefix	[]string	`path:"prefix" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_Config) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State represents the /openconfig-defined-sets/defined-sets/ipv4-prefix-sets/ipv4-prefix-set/state YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Prefix	[]string	`path:"prefix" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State.
func (*OpenconfigDefinedSets_DefinedSets_Ipv4PrefixSets_Ipv4PrefixSet_State) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets struct {
	Ipv6PrefixSet	map[string]*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet	`path:"ipv6-prefix-set" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) IsYANGGoStruct() {}

// NewIpv6PrefixSet creates a new entry in the Ipv6PrefixSet list of the
// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) NewIpv6PrefixSet(Name string) (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Ipv6PrefixSet == nil {
		t.Ipv6PrefixSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Ipv6PrefixSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Ipv6PrefixSet", key)
	}

	t.Ipv6PrefixSet[key] = &OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet{
		Name: &Name,
	}

	return t.Ipv6PrefixSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets/ipv6-prefix-set YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet struct {
	Config	*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config	`path:"config" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	State	*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State	`path:"state" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet struct, which is a YANG list entry.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets/ipv6-prefix-set/config YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Prefix	[]string	`path:"prefix" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_Config) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State represents the /openconfig-defined-sets/defined-sets/ipv6-prefix-sets/ipv6-prefix-set/state YANG schema element.
type OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Prefix	[]string	`path:"prefix" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State.
func (*OpenconfigDefinedSets_DefinedSets_Ipv6PrefixSets_Ipv6PrefixSet_State) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_PortSets represents the /openconfig-defined-sets/defined-sets/port-sets YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets struct {
	PortSet	map[string]*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet	`path:"port-set" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets) IsYANGGoStruct() {}

// NewPortSet creates a new entry in the PortSet list of the
// OpenconfigDefinedSets_DefinedSets_PortSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) NewPortSet(Name string) (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.PortSet == nil {
		t.PortSet = make(map[string]*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.PortSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list PortSet", key)
	}

	t.PortSet[key] = &OpenconfigDefinedSets_DefinedSets_PortSets_PortSet{
		Name: &Name,
	}

	return t.PortSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets.
func (*OpenconfigDefinedSets_DefinedSets_PortSets) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet represents the /openconfig-defined-sets/defined-sets/port-sets/port-set YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet struct {
	Config	*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config	`path:"config" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	State	*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State	`path:"state" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets_PortSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet struct, which is a YANG list entry.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets_PortSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets_PortSet.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}


// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config represents the /openconfig-defined-sets/defined-sets/port-sets/port-set/config YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Port	[]OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union	`path:"port" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-defined-sets/defined-sets/port-sets/port-set/config/port within the YANG schema.
// Union type can be one of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, UnionString, UnionUint16].
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface {
	// Union type can be one of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, UnionString, UnionUint16]
	Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union()
}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union ensures that E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface.
func (E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union() {}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union ensures that UnionString
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface.
func (UnionString) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union() {}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union ensures that UnionUint16
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union interface.
func (UnionUint16) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union() {}

// To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config) To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union(i interface{}) (OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union, error) {
	if v, ok := i.(OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port_Union, unknown union type, got: %T, want any of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, string, uint16]", i, i)
}


// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State represents the /openconfig-defined-sets/defined-sets/port-sets/port-set/state YANG schema element.
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State struct {
	Description	*string	`path:"description" module:"openconfig-defined-sets"`
	Name	*string	`path:"name" module:"openconfig-defined-sets"`
	Port	[]OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union	`path:"port" module:"openconfig-defined-sets"`
}

// IsYANGGoStruct ensures that OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State.
func (*OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) ΛBelongingModule() string {
	return "openconfig-defined-sets"
}

// OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-defined-sets/defined-sets/port-sets/port-set/state/port within the YANG schema.
// Union type can be one of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, UnionString, UnionUint16].
type OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface {
	// Union type can be one of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, UnionString, UnionUint16]
	Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union()
}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union ensures that E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface.
func (E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union() {}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union ensures that UnionString
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface.
func (UnionString) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union() {}

// Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union ensures that UnionUint16
// implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union interface.
func (UnionUint16) Documentation_for_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union() {}

// To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State) To_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union(i interface{}) (OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union, error) {
	if v, ok := i.(OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_State_Port_Union, unknown union type, got: %T, want any of [E_OpenconfigDefinedSets_DefinedSets_PortSets_PortSet_Config_Port, string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces represents the /openconfig-interfaces/interfaces YANG schema element.
type OpenconfigInterfaces_Interfaces struct {
	Interface	map[string]*OpenconfigInterfaces_Interfaces_Interface	`path:"interface" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigInterfaces_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces) NewInterface(Name string) (*OpenconfigInterfaces_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigInterfaces_Interfaces_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces.
func (*OpenconfigInterfaces_Interfaces) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface represents the /openconfig-interfaces/interfaces/interface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface struct {
	Aggregation	*OpenconfigInterfaces_Interfaces_Interface_Aggregation	`path:"aggregation" module:"openconfig-if-aggregate"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_Config	`path:"config" module:"openconfig-interfaces"`
	Ethernet	*OpenconfigInterfaces_Interfaces_Interface_Ethernet	`path:"ethernet" module:"openconfig-if-ethernet"`
	HoldTime	*OpenconfigInterfaces_Interfaces_Interface_HoldTime	`path:"hold-time" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	RoutedVlan	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan	`path:"routed-vlan" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_State	`path:"state" module:"openconfig-interfaces"`
	Subinterfaces	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces	`path:"subinterfaces" module:"openconfig-interfaces"`
	Tunnel	*OpenconfigInterfaces_Interfaces_Interface_Tunnel	`path:"tunnel" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface.
func (*OpenconfigInterfaces_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation represents the /openconfig-interfaces/interfaces/interface/aggregation YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config	`path:"config" module:"openconfig-if-aggregate"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Aggregation_State	`path:"state" module:"openconfig-if-aggregate"`
	SwitchedVlan	*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan	`path:"switched-vlan" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation) ΛBelongingModule() string {
	return "openconfig-if-aggregate"
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config represents the /openconfig-interfaces/interfaces/interface/aggregation/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config struct {
	Fallback	E_AristaIntfAugments_FallbackEnum	`path:"fallback" module:"arista-intf-augments"`
	FallbackTimeout	*uint16	`path:"fallback-timeout" module:"arista-intf-augments"`
	LagType	E_OpenconfigIfAggregate_AggregationType	`path:"lag-type" module:"openconfig-if-aggregate"`
	MinLinks	*uint16	`path:"min-links" module:"openconfig-if-aggregate"`
	Mlag	*uint16	`path:"mlag" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_Config) ΛBelongingModule() string {
	return "openconfig-if-aggregate"
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation_State represents the /openconfig-interfaces/interfaces/interface/aggregation/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_State struct {
	Fallback	E_AristaIntfAugments_FallbackEnum	`path:"fallback" module:"arista-intf-augments"`
	FallbackState	E_AristaIntfAugments_FallbackStateEnum	`path:"fallback-state" module:"arista-intf-augments"`
	LagSpeed	*uint32	`path:"lag-speed" module:"openconfig-if-aggregate"`
	LagType	E_OpenconfigIfAggregate_AggregationType	`path:"lag-type" module:"openconfig-if-aggregate"`
	Member	[]string	`path:"member" module:"openconfig-if-aggregate"`
	MinLinks	*uint16	`path:"min-links" module:"openconfig-if-aggregate"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_State) ΛBelongingModule() string {
	return "openconfig-if-aggregate"
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan represents the /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config represents the /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config struct {
	AccessVlan	*uint16	`path:"access-vlan" module:"openconfig-vlan"`
	InterfaceMode	E_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_InterfaceMode	`path:"interface-mode" module:"openconfig-vlan"`
	NativeVlan	*uint16	`path:"native-vlan" module:"openconfig-vlan"`
	TrunkGroups	[]string	`path:"trunk-groups" module:"arista-intf-augments"`
	TrunkVlans	[]OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union	`path:"trunk-vlans" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/config/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State represents the /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State struct {
	AccessVlan	*uint16	`path:"access-vlan" module:"openconfig-vlan"`
	InterfaceMode	E_OpenconfigVlan_VlanModeType	`path:"interface-mode" module:"openconfig-vlan"`
	NativeVlan	*uint16	`path:"native-vlan" module:"openconfig-vlan"`
	TrunkVlans	[]OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union	`path:"trunk-vlans" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/aggregation/switched-vlan/state/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State) To_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_State_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_Config represents the /openconfig-interfaces/interfaces/interface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Config struct {
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	LoadInterval	*uint16	`path:"load-interval" module:"arista-intf-augments"`
	LoopbackMode	*bool	`path:"loopback-mode" module:"openconfig-interfaces"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	Type	E_IETFInterfaces_InterfaceType	`path:"type" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet represents the /openconfig-interfaces/interfaces/interface/ethernet YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config	`path:"config" module:"openconfig-if-ethernet"`
	Pfc	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc	`path:"pfc" module:"arista-intf-augments"`
	Poe	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe	`path:"poe" module:"openconfig-if-poe"`
	Reflector	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector	`path:"reflector" module:"arista-intf-augments"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State	`path:"state" module:"openconfig-if-ethernet"`
	SwitchedVlan	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan	`path:"switched-vlan" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config represents the /openconfig-interfaces/interfaces/interface/ethernet/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config struct {
	AggregateId	*string	`path:"aggregate-id" module:"openconfig-if-aggregate"`
	AutoNegotiate	*bool	`path:"auto-negotiate" module:"openconfig-if-ethernet"`
	DuplexMode	E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode	`path:"duplex-mode" module:"openconfig-if-ethernet"`
	EnableFlowControl	*bool	`path:"enable-flow-control" module:"openconfig-if-ethernet"`
	FecEncoding	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding	`path:"fec-encoding" module:"arista-intf-augments"`
	FecMode	E_OpenconfigIfEthernet_INTERFACE_FEC	`path:"fec-mode" module:"openconfig-if-ethernet"`
	MacAddress	*string	`path:"mac-address" module:"openconfig-if-ethernet"`
	PortSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"port-speed" module:"openconfig-if-ethernet"`
	Sfp_1000BaseT	*bool	`path:"sfp-1000base-t" module:"arista-intf-augments"`
	StandaloneLinkTraining	*bool	`path:"standalone-link-training" module:"openconfig-if-ethernet"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding represents the /openconfig-interfaces/interfaces/interface/ethernet/config/fec-encoding YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding struct {
	CoherentFecEncoding	E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding_CoherentFecEncoding	`path:"coherent-fec-encoding" module:"arista-intf-augments"`
	Disabled	*bool	`path:"disabled" module:"arista-intf-augments"`
	FireCode	*bool	`path:"fire-code" module:"arista-intf-augments"`
	ReedSolomon	*bool	`path:"reed-solomon" module:"arista-intf-augments"`
	ReedSolomon544	*bool	`path:"reed-solomon544" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_FecEncoding) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc represents the /openconfig-interfaces/interfaces/interface/ethernet/pfc YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc struct {
	Priorities	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities	`path:"priorities" module:"arista-intf-augments"`
	Watchdog	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog	`path:"watchdog" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities represents the /openconfig-interfaces/interfaces/interface/ethernet/pfc/priorities YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities struct {
	Priority	map[uint8]*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority	`path:"priority" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities) IsYANGGoStruct() {}

// NewPriority creates a new entry in the Priority list of the
// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities) NewPriority(Index uint8) (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Priority == nil {
		t.Priority = make(map[uint8]*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Priority[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Priority", key)
	}

	t.Priority[key] = &OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority{
		Index: &Index,
	}

	return t.Priority[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority represents the /openconfig-interfaces/interfaces/interface/ethernet/pfc/priorities/priority YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority struct {
	Index	*uint8	`path:"index" module:"arista-intf-augments"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State	`path:"state" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State represents the /openconfig-interfaces/interfaces/interface/ethernet/pfc/priorities/priority/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State struct {
	InFrames	*uint64	`path:"in-frames" module:"arista-intf-augments"`
	Index	*uint8	`path:"index" module:"arista-intf-augments"`
	OutFrames	*uint64	`path:"out-frames" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Priorities_Priority_State) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog represents the /openconfig-interfaces/interfaces/interface/ethernet/pfc/watchdog YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog struct {
	TxQueues	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues	`path:"tx-queues" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues represents the /openconfig-interfaces/interfaces/interface/ethernet/pfc/watchdog/tx-queues YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues struct {
	TxQueue	map[OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_Key]*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue	`path:"tx-queue" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues) IsYANGGoStruct() {}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_Key represents the key for list TxQueue of element /openconfig-interfaces/interfaces/interface/ethernet/pfc/watchdog/tx-queues.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_Key struct {
	Index	uint8	`path:"index"`
	QueueType	E_AristaIntfAugments_QosQueueType	`path:"queue-type"`
}

// IsYANGGoKeyStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_Key key struct.
func (t OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"index": t.Index,
		"queue-type": t.QueueType,
	}, nil
}

// NewTxQueue creates a new entry in the TxQueue list of the
// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues) NewTxQueue(Index uint8, QueueType E_AristaIntfAugments_QosQueueType) (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.TxQueue == nil {
		t.TxQueue = make(map[OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_Key]*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue)
	}

	key := OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_Key{
		Index: Index,
		QueueType: QueueType,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.TxQueue[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list TxQueue", key)
	}

	t.TxQueue[key] = &OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue{
		Index: &Index,
		QueueType: QueueType,
	}

	return t.TxQueue[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue represents the /openconfig-interfaces/interfaces/interface/ethernet/pfc/watchdog/tx-queues/tx-queue YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue struct {
	Index	*uint8	`path:"index" module:"arista-intf-augments"`
	QueueType	E_AristaIntfAugments_QosQueueType	`path:"queue-type" module:"arista-intf-augments"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State	`path:"state" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}


	return map[string]interface{}{
		"index": *t.Index,
		"queue-type": t.QueueType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State represents the /openconfig-interfaces/interfaces/interface/ethernet/pfc/watchdog/tx-queues/tx-queue/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State struct {
	Index	*uint8	`path:"index" module:"arista-intf-augments"`
	QueueType	E_AristaIntfAugments_QosQueueType	`path:"queue-type" module:"arista-intf-augments"`
	RecoveryCount	*uint32	`path:"recovery-count" module:"arista-intf-augments"`
	StuckCount	*uint32	`path:"stuck-count" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Pfc_Watchdog_TxQueues_TxQueue_State) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe represents the /openconfig-interfaces/interfaces/interface/ethernet/poe YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config	`path:"config" module:"openconfig-if-poe"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State	`path:"state" module:"openconfig-if-poe"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe) ΛBelongingModule() string {
	return "openconfig-if-poe"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config represents the /openconfig-interfaces/interfaces/interface/ethernet/poe/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-poe"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_Config) ΛBelongingModule() string {
	return "openconfig-if-poe"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State represents the /openconfig-interfaces/interfaces/interface/ethernet/poe/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-poe"`
	PowerClass	*uint8	`path:"power-class" module:"openconfig-if-poe"`
	PowerUsed	*float64	`path:"power-used" module:"openconfig-if-poe"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Poe_State) ΛBelongingModule() string {
	return "openconfig-if-poe"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector represents the /openconfig-interfaces/interfaces/interface/ethernet/reflector YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config	`path:"config" module:"arista-intf-augments"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State	`path:"state" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config represents the /openconfig-interfaces/interfaces/interface/ethernet/reflector/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config struct {
	Direction	E_AristaIntfAugments_ReflectorDirection	`path:"direction" module:"arista-intf-augments"`
	MacAction	E_AristaIntfAugments_ReflectorMacAction	`path:"mac-action" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_Config) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State represents the /openconfig-interfaces/interfaces/interface/ethernet/reflector/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State struct {
	Direction	E_AristaIntfAugments_ReflectorDirection	`path:"direction" module:"arista-intf-augments"`
	MacAction	E_AristaIntfAugments_ReflectorMacAction	`path:"mac-action" module:"arista-intf-augments"`
	Status	E_AristaIntfAugments_ReflectorHwStatus	`path:"status" module:"arista-intf-augments"`
	StatusReason	*string	`path:"status-reason" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_Reflector_State) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State represents the /openconfig-interfaces/interfaces/interface/ethernet/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_State struct {
	AggregateId	*string	`path:"aggregate-id" module:"openconfig-if-aggregate"`
	AggregateMemberRxEnabled	*bool	`path:"aggregate-member-rx-enabled" module:"arista-intf-augments"`
	AutoNegotiate	*bool	`path:"auto-negotiate" module:"openconfig-if-ethernet"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters	`path:"counters" module:"openconfig-if-ethernet"`
	DuplexMode	E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_Config_DuplexMode	`path:"duplex-mode" module:"openconfig-if-ethernet"`
	EnableFlowControl	*bool	`path:"enable-flow-control" module:"openconfig-if-ethernet"`
	FecMode	E_OpenconfigIfEthernet_INTERFACE_FEC	`path:"fec-mode" module:"openconfig-if-ethernet"`
	HwMacAddress	*string	`path:"hw-mac-address" module:"openconfig-if-ethernet"`
	MacAddress	*string	`path:"mac-address" module:"openconfig-if-ethernet"`
	NegotiatedDuplexMode	E_OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_NegotiatedDuplexMode	`path:"negotiated-duplex-mode" module:"openconfig-if-ethernet"`
	NegotiatedPortSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"negotiated-port-speed" module:"openconfig-if-ethernet"`
	PoeSupported	*bool	`path:"poe-supported" module:"arista-intf-augments"`
	PortSpeed	E_OpenconfigIfEthernet_ETHERNET_SPEED	`path:"port-speed" module:"openconfig-if-ethernet"`
	StandaloneLinkTraining	*bool	`path:"standalone-link-training" module:"openconfig-if-ethernet"`
	SupportedSpeeds	[]string	`path:"supported-speeds" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters represents the /openconfig-interfaces/interfaces/interface/ethernet/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters struct {
	InBlockErrors	*uint64	`path:"in-block-errors" module:"openconfig-if-ethernet"`
	InCarrierErrors	*uint64	`path:"in-carrier-errors" module:"openconfig-if-ethernet"`
	InCrcErrors	*uint64	`path:"in-crc-errors" module:"openconfig-if-ethernet"`
	InFragmentFrames	*uint64	`path:"in-fragment-frames" module:"openconfig-if-ethernet"`
	InInterruptedTx	*uint64	`path:"in-interrupted-tx" module:"openconfig-if-ethernet"`
	InJabberFrames	*uint64	`path:"in-jabber-frames" module:"openconfig-if-ethernet"`
	InLateCollision	*uint64	`path:"in-late-collision" module:"openconfig-if-ethernet"`
	InMacControlFrames	*uint64	`path:"in-mac-control-frames" module:"openconfig-if-ethernet"`
	InMacErrorsRx	*uint64	`path:"in-mac-errors-rx" module:"openconfig-if-ethernet"`
	InMacPauseFrames	*uint64	`path:"in-mac-pause-frames" module:"openconfig-if-ethernet"`
	InMaxsizeExceeded	*uint64	`path:"in-maxsize-exceeded" module:"openconfig-if-ethernet"`
	InOversizeFrames	*uint64	`path:"in-oversize-frames" module:"openconfig-if-ethernet"`
	InSingleCollision	*uint64	`path:"in-single-collision" module:"openconfig-if-ethernet"`
	InSymbolError	*uint64	`path:"in-symbol-error" module:"openconfig-if-ethernet"`
	InUndersizeFrames	*uint64	`path:"in-undersize-frames" module:"openconfig-if-ethernet"`
	OutMacControlFrames	*uint64	`path:"out-mac-control-frames" module:"openconfig-if-ethernet"`
	OutMacErrorsTx	*uint64	`path:"out-mac-errors-tx" module:"openconfig-if-ethernet"`
	OutMacPauseFrames	*uint64	`path:"out-mac-pause-frames" module:"openconfig-if-ethernet"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ethernet"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan represents the /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config represents the /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config struct {
	AccessVlan	*uint16	`path:"access-vlan" module:"openconfig-vlan"`
	InterfaceMode	E_OpenconfigInterfaces_Interfaces_Interface_Aggregation_SwitchedVlan_Config_InterfaceMode	`path:"interface-mode" module:"openconfig-vlan"`
	NativeVlan	*uint16	`path:"native-vlan" module:"openconfig-vlan"`
	TrunkGroups	[]string	`path:"trunk-groups" module:"arista-intf-augments"`
	TrunkVlans	[]OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union	`path:"trunk-vlans" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/config/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_Config_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State represents the /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State struct {
	AccessVlan	*uint16	`path:"access-vlan" module:"openconfig-vlan"`
	InterfaceMode	E_OpenconfigVlan_VlanModeType	`path:"interface-mode" module:"openconfig-vlan"`
	NativeVlan	*uint16	`path:"native-vlan" module:"openconfig-vlan"`
	TrunkVlans	[]OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union	`path:"trunk-vlans" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/ethernet/switched-vlan/state/trunk-vlans within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State) To_OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Ethernet_SwitchedVlan_State_TrunkVlans_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_HoldTime represents the /openconfig-interfaces/interfaces/interface/hold-time YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config	`path:"config" module:"openconfig-interfaces"`
	State	*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State	`path:"state" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config represents the /openconfig-interfaces/interfaces/interface/hold-time/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config struct {
	Down	*uint32	`path:"down" module:"openconfig-interfaces"`
	Up	*uint32	`path:"up" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_HoldTime_State represents the /openconfig-interfaces/interfaces/interface/hold-time/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_HoldTime_State struct {
	Down	*uint32	`path:"down" module:"openconfig-interfaces"`
	Up	*uint32	`path:"up" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_HoldTime_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_HoldTime_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_HoldTime_State.
func (*OpenconfigInterfaces_Interfaces_Interface_HoldTime_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan represents the /openconfig-interfaces/interfaces/interface/routed-vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config	`path:"config" module:"openconfig-vlan"`
	Ipv4	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4	`path:"ipv4" module:"openconfig-if-ip"`
	Ipv6	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6	`path:"ipv6" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config struct {
	Vlan	OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union	`path:"vlan" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/routed-vlan/config/vlan within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Config_Vlan_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4 represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4 YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4 struct {
	Addresses	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses	`path:"addresses" module:"openconfig-if-ip"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config	`path:"config" module:"openconfig-if-ip"`
	Neighbors	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors	`path:"neighbors" module:"openconfig-if-ip"`
	ProxyArp	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp	`path:"proxy-arp" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State	`path:"state" module:"openconfig-if-ip"`
	Unnumbered	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered	`path:"unnumbered" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses struct {
	Address	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address	`path:"address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) IsYANGGoStruct() {}

// NewAddress creates a new entry in the Address list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) NewAddress(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Address == nil {
		t.Address = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Address[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Address", key)
	}

	t.Address[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address{
		Ip: &Ip,
	}

	return t.Address[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State	`path:"state" module:"openconfig-if-ip"`
	Vrrp	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp	`path:"vrrp" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config struct {
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State struct {
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_IpAddressOrigin	`path:"origin" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp struct {
	VrrpGroup	map[uint8]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup	`path:"vrrp-group" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) IsYANGGoStruct() {}

// NewVrrpGroup creates a new entry in the VrrpGroup list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) NewVrrpGroup(VirtualRouterId uint8) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VrrpGroup == nil {
		t.VrrpGroup = make(map[uint8]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup)
	}

	key := VirtualRouterId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VrrpGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VrrpGroup", key)
	}

	t.VrrpGroup[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup{
		VirtualRouterId: &VirtualRouterId,
	}

	return t.VrrpGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State	`path:"state" module:"openconfig-if-ip"`
	TrackInterfaces	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces	`path:"track-interfaces" module:"arista-intf-augments"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.VirtualRouterId == nil {
		return nil, fmt.Errorf("nil value for key VirtualRouterId")
	}

	return map[string]interface{}{
		"virtual-router-id": *t.VirtualRouterId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config struct {
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddresses	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses	`path:"virtual-addresses" module:"arista-intf-augments"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) IsYANGGoStruct() {}

// NewVirtualAddresses creates a new entry in the VirtualAddresses list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) NewVirtualAddresses(Addr string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VirtualAddresses == nil {
		t.VirtualAddresses = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses)
	}

	key := Addr

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VirtualAddresses[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VirtualAddresses", key)
	}

	t.VirtualAddresses[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses{
		Addr: &Addr,
	}

	return t.VirtualAddresses[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/config/virtual-addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	VirtualAddress	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress	`path:"virtual-address" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Addr == nil {
		return nil, fmt.Errorf("nil value for key Addr")
	}

	return map[string]interface{}{
		"addr": *t.Addr,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/config/virtual-addresses/virtual-address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	CurrentPriority	*uint8	`path:"current-priority" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddresses	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses	`path:"virtual-addresses" module:"arista-intf-augments"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) IsYANGGoStruct() {}

// NewVirtualAddresses creates a new entry in the VirtualAddresses list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) NewVirtualAddresses(Addr string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VirtualAddresses == nil {
		t.VirtualAddresses = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses)
	}

	key := Addr

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VirtualAddresses[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VirtualAddresses", key)
	}

	t.VirtualAddresses[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses{
		Addr: &Addr,
	}

	return t.VirtualAddresses[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/state/virtual-addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	VirtualAddress	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress	`path:"virtual-address" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Addr == nil {
		return nil, fmt.Errorf("nil value for key Addr")
	}

	return map[string]interface{}{
		"addr": *t.Addr,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/state/virtual-addresses/virtual-address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/track-interfaces YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces struct {
	TrackInterface	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface	`path:"track-interface" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) IsYANGGoStruct() {}

// NewTrackInterface creates a new entry in the TrackInterface list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) NewTrackInterface(Name string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.TrackInterface == nil {
		t.TrackInterface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.TrackInterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list TrackInterface", key)
	}

	t.TrackInterface[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface{
		Name: &Name,
	}

	return t.TrackInterface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/track-interfaces/track-interface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config	`path:"config" module:"arista-intf-augments"`
	Name	*string	`path:"name" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/addresses/address/vrrp/vrrp-group/track-interfaces/track-interface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config struct {
	Name	*string	`path:"name" module:"arista-intf-augments"`
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config struct {
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/neighbors YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors struct {
	Neighbor	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) NewNeighbor(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor{
		Ip: &Ip,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/neighbors/neighbor YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/neighbors/neighbor/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/neighbors/neighbor/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_NeighborOrigin	`path:"origin" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/proxy-arp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/proxy-arp/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config struct {
	Mode	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config_Mode	`path:"mode" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/proxy-arp/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State struct {
	Mode	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config_Mode	`path:"mode" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State struct {
	Counters	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters	`path:"counters" module:"openconfig-if-ip"`
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters struct {
	InDiscardedPkts	*uint64	`path:"in-discarded-pkts" module:"openconfig-if-ip"`
	InErrorPkts	*uint64	`path:"in-error-pkts" module:"openconfig-if-ip"`
	InForwardedOctets	*uint64	`path:"in-forwarded-octets" module:"openconfig-if-ip"`
	InForwardedPkts	*uint64	`path:"in-forwarded-pkts" module:"openconfig-if-ip"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-if-ip"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-if-ip"`
	OutDiscardedPkts	*uint64	`path:"out-discarded-pkts" module:"openconfig-if-ip"`
	OutErrorPkts	*uint64	`path:"out-error-pkts" module:"openconfig-if-ip"`
	OutForwardedOctets	*uint64	`path:"out-forwarded-octets" module:"openconfig-if-ip"`
	OutForwardedPkts	*uint64	`path:"out-forwarded-pkts" module:"openconfig-if-ip"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-if-ip"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceRef	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef	`path:"interface-ref" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered/interface-ref YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered/interface-ref/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered/interface-ref/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv4/unnumbered/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_Unnumbered_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6 represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6 YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6 struct {
	Addresses	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses	`path:"addresses" module:"openconfig-if-ip"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config	`path:"config" module:"openconfig-if-ip"`
	Neighbors	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors	`path:"neighbors" module:"openconfig-if-ip"`
	RouterAdvertisement	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement	`path:"router-advertisement" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State	`path:"state" module:"openconfig-if-ip"`
	Unnumbered	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered	`path:"unnumbered" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses struct {
	Address	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address	`path:"address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) IsYANGGoStruct() {}

// NewAddress creates a new entry in the Address list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) NewAddress(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Address == nil {
		t.Address = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Address[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Address", key)
	}

	t.Address[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address{
		Ip: &Ip,
	}

	return t.Address[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State	`path:"state" module:"openconfig-if-ip"`
	Vrrp	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp	`path:"vrrp" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_IpAddressOrigin	`path:"origin" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
	Status	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State_Status	`path:"status" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp struct {
	VrrpGroup	map[uint8]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup	`path:"vrrp-group" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) IsYANGGoStruct() {}

// NewVrrpGroup creates a new entry in the VrrpGroup list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) NewVrrpGroup(VirtualRouterId uint8) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VrrpGroup == nil {
		t.VrrpGroup = make(map[uint8]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup)
	}

	key := VirtualRouterId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VrrpGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VrrpGroup", key)
	}

	t.VrrpGroup[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup{
		VirtualRouterId: &VirtualRouterId,
	}

	return t.VrrpGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State	`path:"state" module:"openconfig-if-ip"`
	TrackInterfaces	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces	`path:"track-interfaces" module:"arista-intf-augments"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.VirtualRouterId == nil {
		return nil, fmt.Errorf("nil value for key VirtualRouterId")
	}

	return map[string]interface{}{
		"virtual-router-id": *t.VirtualRouterId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config struct {
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddresses	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses	`path:"virtual-addresses" module:"arista-intf-augments"`
	VirtualLinkLocal	*string	`path:"virtual-link-local" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) IsYANGGoStruct() {}

// NewVirtualAddresses creates a new entry in the VirtualAddresses list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) NewVirtualAddresses(Addr string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VirtualAddresses == nil {
		t.VirtualAddresses = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses)
	}

	key := Addr

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VirtualAddresses[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VirtualAddresses", key)
	}

	t.VirtualAddresses[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses{
		Addr: &Addr,
	}

	return t.VirtualAddresses[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/config/virtual-addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	VirtualAddress	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress	`path:"virtual-address" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Addr == nil {
		return nil, fmt.Errorf("nil value for key Addr")
	}

	return map[string]interface{}{
		"addr": *t.Addr,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/config/virtual-addresses/virtual-address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	CurrentPriority	*uint8	`path:"current-priority" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddresses	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses	`path:"virtual-addresses" module:"arista-intf-augments"`
	VirtualLinkLocal	*string	`path:"virtual-link-local" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) IsYANGGoStruct() {}

// NewVirtualAddresses creates a new entry in the VirtualAddresses list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) NewVirtualAddresses(Addr string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VirtualAddresses == nil {
		t.VirtualAddresses = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses)
	}

	key := Addr

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VirtualAddresses[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VirtualAddresses", key)
	}

	t.VirtualAddresses[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses{
		Addr: &Addr,
	}

	return t.VirtualAddresses[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/state/virtual-addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	VirtualAddress	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress	`path:"virtual-address" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Addr == nil {
		return nil, fmt.Errorf("nil value for key Addr")
	}

	return map[string]interface{}{
		"addr": *t.Addr,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/state/virtual-addresses/virtual-address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/track-interfaces YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces struct {
	TrackInterface	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface	`path:"track-interface" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) IsYANGGoStruct() {}

// NewTrackInterface creates a new entry in the TrackInterface list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) NewTrackInterface(Name string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.TrackInterface == nil {
		t.TrackInterface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.TrackInterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list TrackInterface", key)
	}

	t.TrackInterface[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface{
		Name: &Name,
	}

	return t.TrackInterface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/track-interfaces/track-interface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config	`path:"config" module:"arista-intf-augments"`
	Name	*string	`path:"name" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/addresses/address/vrrp/vrrp-group/track-interfaces/track-interface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config struct {
	Name	*string	`path:"name" module:"arista-intf-augments"`
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config struct {
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	DupAddrDetectTransmits	*uint32	`path:"dup-addr-detect-transmits" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint32	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/neighbors YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors struct {
	Neighbor	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) NewNeighbor(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor{
		Ip: &Ip,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/neighbors/neighbor YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/neighbors/neighbor/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/neighbors/neighbor/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	IsRouter	*bool	`path:"is-router" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
	NeighborState	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State_NeighborState	`path:"neighbor-state" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_NeighborOrigin	`path:"origin" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config	`path:"config" module:"openconfig-if-ip"`
	Prefixes	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes	`path:"prefixes" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config struct {
	Interval	*uint32	`path:"interval" module:"openconfig-if-ip"`
	Lifetime	*uint32	`path:"lifetime" module:"openconfig-if-ip"`
	Managed	*bool	`path:"managed" module:"openconfig-if-ip"`
	OtherConfig	*bool	`path:"other-config" module:"openconfig-if-ip"`
	Suppress	*bool	`path:"suppress" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/prefixes YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes struct {
	Prefix	map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix	`path:"prefix" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) IsYANGGoStruct() {}

// NewPrefix creates a new entry in the Prefix list of the
// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) NewPrefix(Prefix string) (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Prefix == nil {
		t.Prefix = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix)
	}

	key := Prefix

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Prefix[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Prefix", key)
	}

	t.Prefix[key] = &OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix{
		Prefix: &Prefix,
	}

	return t.Prefix[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/prefixes/prefix YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config	`path:"config" module:"openconfig-if-ip"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"prefix": *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/prefixes/prefix/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config struct {
	DisableAdvertisement	*bool	`path:"disable-advertisement" module:"openconfig-if-ip"`
	DisableAutoconfiguration	*bool	`path:"disable-autoconfiguration" module:"openconfig-if-ip"`
	EnableOnlink	*bool	`path:"enable-onlink" module:"openconfig-if-ip"`
	PreferredLifetime	*uint32	`path:"preferred-lifetime" module:"openconfig-if-ip"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-ip"`
	ValidLifetime	*uint32	`path:"valid-lifetime" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/prefixes/prefix/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State struct {
	DisableAdvertisement	*bool	`path:"disable-advertisement" module:"openconfig-if-ip"`
	DisableAutoconfiguration	*bool	`path:"disable-autoconfiguration" module:"openconfig-if-ip"`
	EnableOnlink	*bool	`path:"enable-onlink" module:"openconfig-if-ip"`
	PreferredLifetime	*uint32	`path:"preferred-lifetime" module:"openconfig-if-ip"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-ip"`
	ValidLifetime	*uint32	`path:"valid-lifetime" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/router-advertisement/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State struct {
	Interval	*uint32	`path:"interval" module:"openconfig-if-ip"`
	Lifetime	*uint32	`path:"lifetime" module:"openconfig-if-ip"`
	Managed	*bool	`path:"managed" module:"openconfig-if-ip"`
	OtherConfig	*bool	`path:"other-config" module:"openconfig-if-ip"`
	Suppress	*bool	`path:"suppress" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_RouterAdvertisement_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State struct {
	Counters	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters	`path:"counters" module:"openconfig-if-ip"`
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	DupAddrDetectTransmits	*uint32	`path:"dup-addr-detect-transmits" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint32	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters struct {
	InDiscardedPkts	*uint64	`path:"in-discarded-pkts" module:"openconfig-if-ip"`
	InErrorPkts	*uint64	`path:"in-error-pkts" module:"openconfig-if-ip"`
	InForwardedOctets	*uint64	`path:"in-forwarded-octets" module:"openconfig-if-ip"`
	InForwardedPkts	*uint64	`path:"in-forwarded-pkts" module:"openconfig-if-ip"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-if-ip"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-if-ip"`
	OutDiscardedPkts	*uint64	`path:"out-discarded-pkts" module:"openconfig-if-ip"`
	OutErrorPkts	*uint64	`path:"out-error-pkts" module:"openconfig-if-ip"`
	OutForwardedOctets	*uint64	`path:"out-forwarded-octets" module:"openconfig-if-ip"`
	OutForwardedPkts	*uint64	`path:"out-forwarded-pkts" module:"openconfig-if-ip"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-if-ip"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceRef	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef	`path:"interface-ref" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered/interface-ref YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered/interface-ref/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered/interface-ref/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/ipv6/unnumbered/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Unnumbered_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State represents the /openconfig-interfaces/interfaces/interface/routed-vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State struct {
	Vlan	OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union	`path:"vlan" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/routed-vlan/state/vlan within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State) To_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_State_Vlan_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_State represents the /openconfig-interfaces/interfaces/interface/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_State struct {
	AdminStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus	`path:"admin-status" module:"openconfig-interfaces"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_State_Counters	`path:"counters" module:"openconfig-interfaces"`
	Cpu	*bool	`path:"cpu" module:"openconfig-interfaces"`
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Ifindex	*uint32	`path:"ifindex" module:"openconfig-interfaces"`
	Inactive	*bool	`path:"inactive" module:"arista-intf-augments"`
	LastChange	*uint64	`path:"last-change" module:"openconfig-interfaces"`
	Logical	*bool	`path:"logical" module:"openconfig-interfaces"`
	LoopbackMode	*bool	`path:"loopback-mode" module:"openconfig-interfaces"`
	Management	*bool	`path:"management" module:"openconfig-interfaces"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	OperStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus	`path:"oper-status" module:"openconfig-interfaces"`
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	Type	E_IETFInterfaces_InterfaceType	`path:"type" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_State.
func (*OpenconfigInterfaces_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_State_Counters represents the /openconfig-interfaces/interfaces/interface/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_State_Counters struct {
	InBroadcastPkts	*uint64	`path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	InDiscards	*uint64	`path:"in-discards" module:"openconfig-interfaces"`
	InErrors	*uint64	`path:"in-errors" module:"openconfig-interfaces"`
	InFcsErrors	*uint64	`path:"in-fcs-errors" module:"openconfig-interfaces"`
	InMulticastPkts	*uint64	`path:"in-multicast-pkts" module:"openconfig-interfaces"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-interfaces"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-interfaces"`
	InUnicastPkts	*uint64	`path:"in-unicast-pkts" module:"openconfig-interfaces"`
	OutBroadcastPkts	*uint64	`path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	OutDiscards	*uint64	`path:"out-discards" module:"openconfig-interfaces"`
	OutErrors	*uint64	`path:"out-errors" module:"openconfig-interfaces"`
	OutMulticastPkts	*uint64	`path:"out-multicast-pkts" module:"openconfig-interfaces"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-interfaces"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-interfaces"`
	OutUnicastPkts	*uint64	`path:"out-unicast-pkts" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_State_Counters) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces represents the /openconfig-interfaces/interfaces/interface/subinterfaces YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct {
	Subinterface	map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface	`path:"subinterface" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) IsYANGGoStruct() {}

// NewSubinterface creates a new entry in the Subinterface list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) NewSubinterface(Index uint32) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subinterface == nil {
		t.Subinterface = make(map[uint32]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Subinterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Subinterface", key)
	}

	t.Subinterface[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface{
		Index: &Index,
	}

	return t.Subinterface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config	`path:"config" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
	Ipv4	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4	`path:"ipv4" module:"openconfig-if-ip"`
	Ipv6	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6	`path:"ipv6" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State	`path:"state" module:"openconfig-interfaces"`
	Vlan	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan	`path:"vlan" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Index == nil {
		return nil, fmt.Errorf("nil value for key Index")
	}

	return map[string]interface{}{
		"index": *t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config struct {
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
	L2ProtocolForwardingProfile	*string	`path:"l2protocol-forwarding-profile" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Config) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4 represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4 YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4 struct {
	Addresses	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses	`path:"addresses" module:"openconfig-if-ip"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config	`path:"config" module:"openconfig-if-ip"`
	Neighbors	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors	`path:"neighbors" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State	`path:"state" module:"openconfig-if-ip"`
	Unnumbered	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered	`path:"unnumbered" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses struct {
	Address	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address	`path:"address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) IsYANGGoStruct() {}

// NewAddress creates a new entry in the Address list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) NewAddress(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Address == nil {
		t.Address = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Address[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Address", key)
	}

	t.Address[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address{
		Ip: &Ip,
	}

	return t.Address[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State	`path:"state" module:"openconfig-if-ip"`
	Vrrp	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp	`path:"vrrp" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config struct {
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State struct {
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_IpAddressOrigin	`path:"origin" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp struct {
	VrrpGroup	map[uint8]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup	`path:"vrrp-group" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) IsYANGGoStruct() {}

// NewVrrpGroup creates a new entry in the VrrpGroup list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) NewVrrpGroup(VirtualRouterId uint8) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VrrpGroup == nil {
		t.VrrpGroup = make(map[uint8]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup)
	}

	key := VirtualRouterId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VrrpGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VrrpGroup", key)
	}

	t.VrrpGroup[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup{
		VirtualRouterId: &VirtualRouterId,
	}

	return t.VrrpGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State	`path:"state" module:"openconfig-if-ip"`
	TrackInterfaces	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces	`path:"track-interfaces" module:"arista-intf-augments"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.VirtualRouterId == nil {
		return nil, fmt.Errorf("nil value for key VirtualRouterId")
	}

	return map[string]interface{}{
		"virtual-router-id": *t.VirtualRouterId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config struct {
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddresses	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses	`path:"virtual-addresses" module:"arista-intf-augments"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) IsYANGGoStruct() {}

// NewVirtualAddresses creates a new entry in the VirtualAddresses list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) NewVirtualAddresses(Addr string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VirtualAddresses == nil {
		t.VirtualAddresses = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses)
	}

	key := Addr

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VirtualAddresses[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VirtualAddresses", key)
	}

	t.VirtualAddresses[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses{
		Addr: &Addr,
	}

	return t.VirtualAddresses[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/config/virtual-addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	VirtualAddress	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress	`path:"virtual-address" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Addr == nil {
		return nil, fmt.Errorf("nil value for key Addr")
	}

	return map[string]interface{}{
		"addr": *t.Addr,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/config/virtual-addresses/virtual-address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	CurrentPriority	*uint8	`path:"current-priority" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddresses	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses	`path:"virtual-addresses" module:"arista-intf-augments"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) IsYANGGoStruct() {}

// NewVirtualAddresses creates a new entry in the VirtualAddresses list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) NewVirtualAddresses(Addr string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VirtualAddresses == nil {
		t.VirtualAddresses = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses)
	}

	key := Addr

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VirtualAddresses[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VirtualAddresses", key)
	}

	t.VirtualAddresses[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses{
		Addr: &Addr,
	}

	return t.VirtualAddresses[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/state/virtual-addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	VirtualAddress	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress	`path:"virtual-address" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Addr == nil {
		return nil, fmt.Errorf("nil value for key Addr")
	}

	return map[string]interface{}{
		"addr": *t.Addr,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/state/virtual-addresses/virtual-address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/track-interfaces YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces struct {
	TrackInterface	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface	`path:"track-interface" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) IsYANGGoStruct() {}

// NewTrackInterface creates a new entry in the TrackInterface list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) NewTrackInterface(Name string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.TrackInterface == nil {
		t.TrackInterface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.TrackInterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list TrackInterface", key)
	}

	t.TrackInterface[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface{
		Name: &Name,
	}

	return t.TrackInterface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/track-interfaces/track-interface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config	`path:"config" module:"arista-intf-augments"`
	Name	*string	`path:"name" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/addresses/address/vrrp/vrrp-group/track-interfaces/track-interface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config struct {
	Name	*string	`path:"name" module:"arista-intf-augments"`
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config struct {
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/neighbors YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors struct {
	Neighbor	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) NewNeighbor(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor{
		Ip: &Ip,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/neighbors/neighbor YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/neighbors/neighbor/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/neighbors/neighbor/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_NeighborOrigin	`path:"origin" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State struct {
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters	`path:"counters" module:"openconfig-if-ip"`
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters struct {
	InDiscardedPkts	*uint64	`path:"in-discarded-pkts" module:"openconfig-if-ip"`
	InErrorPkts	*uint64	`path:"in-error-pkts" module:"openconfig-if-ip"`
	InForwardedOctets	*uint64	`path:"in-forwarded-octets" module:"openconfig-if-ip"`
	InForwardedPkts	*uint64	`path:"in-forwarded-pkts" module:"openconfig-if-ip"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-if-ip"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-if-ip"`
	OutDiscardedPkts	*uint64	`path:"out-discarded-pkts" module:"openconfig-if-ip"`
	OutErrorPkts	*uint64	`path:"out-error-pkts" module:"openconfig-if-ip"`
	OutForwardedOctets	*uint64	`path:"out-forwarded-octets" module:"openconfig-if-ip"`
	OutForwardedPkts	*uint64	`path:"out-forwarded-pkts" module:"openconfig-if-ip"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-if-ip"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceRef	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef	`path:"interface-ref" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered/interface-ref YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered/interface-ref/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered/interface-ref/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv4/unnumbered/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv4_Unnumbered_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6 represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6 YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6 struct {
	Addresses	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses	`path:"addresses" module:"openconfig-if-ip"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config	`path:"config" module:"openconfig-if-ip"`
	Neighbors	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors	`path:"neighbors" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State	`path:"state" module:"openconfig-if-ip"`
	Unnumbered	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered	`path:"unnumbered" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses struct {
	Address	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address	`path:"address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) IsYANGGoStruct() {}

// NewAddress creates a new entry in the Address list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) NewAddress(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Address == nil {
		t.Address = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Address[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Address", key)
	}

	t.Address[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address{
		Ip: &Ip,
	}

	return t.Address[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State	`path:"state" module:"openconfig-if-ip"`
	Vrrp	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp	`path:"vrrp" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_IpAddressOrigin	`path:"origin" module:"openconfig-if-ip"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-ip"`
	Status	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State_Status	`path:"status" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp struct {
	VrrpGroup	map[uint8]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup	`path:"vrrp-group" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) IsYANGGoStruct() {}

// NewVrrpGroup creates a new entry in the VrrpGroup list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) NewVrrpGroup(VirtualRouterId uint8) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VrrpGroup == nil {
		t.VrrpGroup = make(map[uint8]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup)
	}

	key := VirtualRouterId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VrrpGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VrrpGroup", key)
	}

	t.VrrpGroup[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup{
		VirtualRouterId: &VirtualRouterId,
	}

	return t.VrrpGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State	`path:"state" module:"openconfig-if-ip"`
	TrackInterfaces	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces	`path:"track-interfaces" module:"arista-intf-augments"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.VirtualRouterId == nil {
		return nil, fmt.Errorf("nil value for key VirtualRouterId")
	}

	return map[string]interface{}{
		"virtual-router-id": *t.VirtualRouterId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config struct {
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddresses	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses	`path:"virtual-addresses" module:"arista-intf-augments"`
	VirtualLinkLocal	*string	`path:"virtual-link-local" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) IsYANGGoStruct() {}

// NewVirtualAddresses creates a new entry in the VirtualAddresses list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) NewVirtualAddresses(Addr string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VirtualAddresses == nil {
		t.VirtualAddresses = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses)
	}

	key := Addr

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VirtualAddresses[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VirtualAddresses", key)
	}

	t.VirtualAddresses[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses{
		Addr: &Addr,
	}

	return t.VirtualAddresses[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/config/virtual-addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	VirtualAddress	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress	`path:"virtual-address" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Addr == nil {
		return nil, fmt.Errorf("nil value for key Addr")
	}

	return map[string]interface{}{
		"addr": *t.Addr,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/config/virtual-addresses/virtual-address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_Config_VirtualAddresses_VirtualAddress) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State struct {
	AcceptMode	*bool	`path:"accept-mode" module:"openconfig-if-ip"`
	AdvertisementInterval	*uint16	`path:"advertisement-interval" module:"openconfig-if-ip"`
	CurrentPriority	*uint8	`path:"current-priority" module:"openconfig-if-ip"`
	Preempt	*bool	`path:"preempt" module:"openconfig-if-ip"`
	PreemptDelay	*uint16	`path:"preempt-delay" module:"openconfig-if-ip"`
	Priority	*uint8	`path:"priority" module:"openconfig-if-ip"`
	VirtualAddresses	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses	`path:"virtual-addresses" module:"arista-intf-augments"`
	VirtualLinkLocal	*string	`path:"virtual-link-local" module:"openconfig-if-ip"`
	VirtualRouterId	*uint8	`path:"virtual-router-id" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) IsYANGGoStruct() {}

// NewVirtualAddresses creates a new entry in the VirtualAddresses list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) NewVirtualAddresses(Addr string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.VirtualAddresses == nil {
		t.VirtualAddresses = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses)
	}

	key := Addr

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.VirtualAddresses[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list VirtualAddresses", key)
	}

	t.VirtualAddresses[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses{
		Addr: &Addr,
	}

	return t.VirtualAddresses[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/state/virtual-addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	VirtualAddress	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress	`path:"virtual-address" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Addr == nil {
		return nil, fmt.Errorf("nil value for key Addr")
	}

	return map[string]interface{}{
		"addr": *t.Addr,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/state/virtual-addresses/virtual-address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress struct {
	Addr	*string	`path:"addr" module:"arista-intf-augments"`
	AddrType	E_AristaIntfAugments_AristaAddrType	`path:"addr-type" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_State_VirtualAddresses_VirtualAddress) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/track-interfaces YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces struct {
	TrackInterface	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface	`path:"track-interface" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) IsYANGGoStruct() {}

// NewTrackInterface creates a new entry in the TrackInterface list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) NewTrackInterface(Name string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.TrackInterface == nil {
		t.TrackInterface = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.TrackInterface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list TrackInterface", key)
	}

	t.TrackInterface[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface{
		Name: &Name,
	}

	return t.TrackInterface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/track-interfaces/track-interface YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config	`path:"config" module:"arista-intf-augments"`
	Name	*string	`path:"name" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/addresses/address/vrrp/vrrp-group/track-interfaces/track-interface/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config struct {
	Name	*string	`path:"name" module:"arista-intf-augments"`
	PriorityDecrement	*uint8	`path:"priority-decrement" module:"arista-intf-augments"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Addresses_Address_Vrrp_VrrpGroup_TrackInterfaces_TrackInterface_Config) ΛBelongingModule() string {
	return "arista-intf-augments"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config struct {
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	DupAddrDetectTransmits	*uint32	`path:"dup-addr-detect-transmits" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint32	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/neighbors YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors struct {
	Neighbor	map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) NewNeighbor(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor{
		Ip: &Ip,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/neighbors/neighbor YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-if-ip"`
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/neighbors/neighbor/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/neighbors/neighbor/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-ip"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-ip"`
	NeighborState	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State_NeighborState	`path:"neighbor-state" module:"openconfig-if-ip"`
	Origin	E_OpenconfigIfIp_NeighborOrigin	`path:"origin" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State struct {
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters	`path:"counters" module:"openconfig-if-ip"`
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-ip"`
	DupAddrDetectTransmits	*uint32	`path:"dup-addr-detect-transmits" module:"openconfig-if-ip"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
	Mtu	*uint32	`path:"mtu" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters struct {
	InDiscardedPkts	*uint64	`path:"in-discarded-pkts" module:"openconfig-if-ip"`
	InErrorPkts	*uint64	`path:"in-error-pkts" module:"openconfig-if-ip"`
	InForwardedOctets	*uint64	`path:"in-forwarded-octets" module:"openconfig-if-ip"`
	InForwardedPkts	*uint64	`path:"in-forwarded-pkts" module:"openconfig-if-ip"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-if-ip"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-if-ip"`
	OutDiscardedPkts	*uint64	`path:"out-discarded-pkts" module:"openconfig-if-ip"`
	OutErrorPkts	*uint64	`path:"out-error-pkts" module:"openconfig-if-ip"`
	OutForwardedOctets	*uint64	`path:"out-forwarded-octets" module:"openconfig-if-ip"`
	OutForwardedPkts	*uint64	`path:"out-forwarded-pkts" module:"openconfig-if-ip"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-if-ip"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config	`path:"config" module:"openconfig-if-ip"`
	InterfaceRef	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef	`path:"interface-ref" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered/interface-ref YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config	`path:"config" module:"openconfig-if-ip"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State	`path:"state" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered/interface-ref/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered/interface-ref/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-if-ip"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/ipv6/unnumbered/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-ip"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Ipv6_Unnumbered_State) ΛBelongingModule() string {
	return "openconfig-if-ip"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State struct {
	AdminStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_AdminStatus	`path:"admin-status" module:"openconfig-interfaces"`
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters	`path:"counters" module:"openconfig-interfaces"`
	Cpu	*bool	`path:"cpu" module:"openconfig-interfaces"`
	Description	*string	`path:"description" module:"openconfig-interfaces"`
	Enabled	*bool	`path:"enabled" module:"openconfig-interfaces"`
	Ifindex	*uint32	`path:"ifindex" module:"openconfig-interfaces"`
	Index	*uint32	`path:"index" module:"openconfig-interfaces"`
	LastChange	*uint64	`path:"last-change" module:"openconfig-interfaces"`
	Logical	*bool	`path:"logical" module:"openconfig-interfaces"`
	Management	*bool	`path:"management" module:"openconfig-interfaces"`
	Name	*string	`path:"name" module:"openconfig-interfaces"`
	OperStatus	E_OpenconfigInterfaces_Interfaces_Interface_State_OperStatus	`path:"oper-status" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters struct {
	CarrierTransitions	*uint64	`path:"carrier-transitions" module:"openconfig-interfaces"`
	InBroadcastPkts	*uint64	`path:"in-broadcast-pkts" module:"openconfig-interfaces"`
	InDiscards	*uint64	`path:"in-discards" module:"openconfig-interfaces"`
	InErrors	*uint64	`path:"in-errors" module:"openconfig-interfaces"`
	InFcsErrors	*uint64	`path:"in-fcs-errors" module:"openconfig-interfaces"`
	InMulticastPkts	*uint64	`path:"in-multicast-pkts" module:"openconfig-interfaces"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-interfaces"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-interfaces"`
	InUnicastPkts	*uint64	`path:"in-unicast-pkts" module:"openconfig-interfaces"`
	InUnknownProtos	*uint64	`path:"in-unknown-protos" module:"openconfig-interfaces"`
	LastClear	*uint64	`path:"last-clear" module:"openconfig-interfaces"`
	OutBroadcastPkts	*uint64	`path:"out-broadcast-pkts" module:"openconfig-interfaces"`
	OutDiscards	*uint64	`path:"out-discards" module:"openconfig-interfaces"`
	OutErrors	*uint64	`path:"out-errors" module:"openconfig-interfaces"`
	OutMulticastPkts	*uint64	`path:"out-multicast-pkts" module:"openconfig-interfaces"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-interfaces"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-interfaces"`
	OutUnicastPkts	*uint64	`path:"out-unicast-pkts" module:"openconfig-interfaces"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_State_Counters) ΛBelongingModule() string {
	return "openconfig-interfaces"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config	`path:"config" module:"openconfig-vlan"`
	EgressMapping	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping	`path:"egress-mapping" module:"openconfig-vlan"`
	IngressMapping	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping	`path:"ingress-mapping" module:"openconfig-vlan"`
	Match	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match	`path:"match" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config struct {
	VlanId	OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union	`path:"vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/config/vlan-id within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config) To_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Config_VlanId_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/egress-mapping YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/egress-mapping/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config struct {
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
	VlanStackAction	E_OpenconfigVlan_VlanStackAction	`path:"vlan-stack-action" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/egress-mapping/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State struct {
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
	VlanStackAction	E_OpenconfigVlan_VlanStackAction	`path:"vlan-stack-action" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_EgressMapping_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/ingress-mapping YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/ingress-mapping/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config struct {
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
	VlanStackAction	E_OpenconfigVlan_VlanStackAction	`path:"vlan-stack-action" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/ingress-mapping/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State struct {
	Tpid	E_OpenconfigVlanTypes_TPID_TYPES	`path:"tpid" module:"openconfig-vlan"`
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
	VlanStackAction	E_OpenconfigVlan_VlanStackAction	`path:"vlan-stack-action" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_IngressMapping_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match struct {
	DoubleTagged	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged	`path:"double-tagged" module:"openconfig-vlan"`
	DoubleTaggedInnerList	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList	`path:"double-tagged-inner-list" module:"openconfig-vlan"`
	DoubleTaggedInnerOuterRange	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange	`path:"double-tagged-inner-outer-range" module:"openconfig-vlan"`
	DoubleTaggedInnerRange	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange	`path:"double-tagged-inner-range" module:"openconfig-vlan"`
	DoubleTaggedOuterList	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList	`path:"double-tagged-outer-list" module:"openconfig-vlan"`
	DoubleTaggedOuterRange	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange	`path:"double-tagged-outer-range" module:"openconfig-vlan"`
	SingleTagged	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged	`path:"single-tagged" module:"openconfig-vlan"`
	SingleTaggedList	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList	`path:"single-tagged-list" module:"openconfig-vlan"`
	SingleTaggedRange	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange	`path:"single-tagged-range" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-list YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-list/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config struct {
	InnerVlanIds	[]uint16	`path:"inner-vlan-ids" module:"openconfig-vlan"`
	OuterVlanId	*uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-list/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State struct {
	InnerVlanIds	[]uint16	`path:"inner-vlan-ids" module:"openconfig-vlan"`
	OuterVlanId	*uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerList_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-outer-range YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-outer-range/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config struct {
	InnerHighVlanId	*uint16	`path:"inner-high-vlan-id" module:"openconfig-vlan"`
	InnerLowVlanId	*uint16	`path:"inner-low-vlan-id" module:"openconfig-vlan"`
	OuterHighVlanId	*uint16	`path:"outer-high-vlan-id" module:"openconfig-vlan"`
	OuterLowVlanId	*uint16	`path:"outer-low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-outer-range/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State struct {
	InnerHighVlanId	*uint16	`path:"inner-high-vlan-id" module:"openconfig-vlan"`
	InnerLowVlanId	*uint16	`path:"inner-low-vlan-id" module:"openconfig-vlan"`
	OuterHighVlanId	*uint16	`path:"outer-high-vlan-id" module:"openconfig-vlan"`
	OuterLowVlanId	*uint16	`path:"outer-low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerOuterRange_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-range YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-range/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config struct {
	InnerHighVlanId	*uint16	`path:"inner-high-vlan-id" module:"openconfig-vlan"`
	InnerLowVlanId	*uint16	`path:"inner-low-vlan-id" module:"openconfig-vlan"`
	OuterVlanId	[]uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-inner-range/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State struct {
	InnerHighVlanId	*uint16	`path:"inner-high-vlan-id" module:"openconfig-vlan"`
	InnerLowVlanId	*uint16	`path:"inner-low-vlan-id" module:"openconfig-vlan"`
	OuterVlanId	[]uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedInnerRange_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-list YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-list/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterVlanIds	[]uint16	`path:"outer-vlan-ids" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-list/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterVlanIds	[]uint16	`path:"outer-vlan-ids" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterList_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-range YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-range/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterHighVlanId	*uint16	`path:"outer-high-vlan-id" module:"openconfig-vlan"`
	OuterLowVlanId	*uint16	`path:"outer-low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged-outer-range/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterHighVlanId	*uint16	`path:"outer-high-vlan-id" module:"openconfig-vlan"`
	OuterLowVlanId	*uint16	`path:"outer-low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTaggedOuterRange_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterVlanId	*uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/double-tagged/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State struct {
	InnerVlanId	*uint16	`path:"inner-vlan-id" module:"openconfig-vlan"`
	OuterVlanId	*uint16	`path:"outer-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_DoubleTagged_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-list YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-list/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config struct {
	VlanIds	[]uint16	`path:"vlan-ids" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-list/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State struct {
	VlanIds	[]uint16	`path:"vlan-ids" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedList_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-range YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config	`path:"config" module:"openconfig-vlan"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State	`path:"state" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-range/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config struct {
	HighVlanId	*uint16	`path:"high-vlan-id" module:"openconfig-vlan"`
	LowVlanId	*uint16	`path:"low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged-range/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State struct {
	HighVlanId	*uint16	`path:"high-vlan-id" module:"openconfig-vlan"`
	LowVlanId	*uint16	`path:"low-vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTaggedRange_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config struct {
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_Config) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/match/single-tagged/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State struct {
	VlanId	*uint16	`path:"vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_Match_SingleTagged_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}


// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State represents the /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State struct {
	VlanId	OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union	`path:"vlan-id" module:"openconfig-vlan"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) ΛBelongingModule() string {
	return "openconfig-vlan"
}

// OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-interfaces/interfaces/interface/subinterfaces/subinterface/vlan/state/vlan-id within the YANG schema.
// Union type can be one of [UnionString, UnionUint16].
type OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union interface {
	// Union type can be one of [UnionString, UnionUint16]
	Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union()
}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union ensures that UnionString
// implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union interface.
func (UnionString) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union() {}

// Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union ensures that UnionUint16
// implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union interface.
func (UnionUint16) Documentation_for_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union() {}

// To_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State) To_OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union(i interface{}) (OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union, error) {
	if v, ok := i.(OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint16:
		return UnionUint16(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigInterfaces_Interfaces_Interface_Subinterfaces_Subinterface_Vlan_State_VlanId_Union, unknown union type, got: %T, want any of [string, uint16]", i, i)
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel represents the /openconfig-interfaces/interfaces/interface/tunnel YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config	`path:"config" module:"openconfig-if-tunnel"`
	Ipv4	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4	`path:"ipv4" module:"openconfig-if-tunnel"`
	Ipv6	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6	`path:"ipv6" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config struct {
	Dst	*string	`path:"dst" module:"openconfig-if-tunnel"`
	GreKey	*uint32	`path:"gre-key" module:"openconfig-if-tunnel"`
	Src	*string	`path:"src" module:"openconfig-if-tunnel"`
	Ttl	*uint8	`path:"ttl" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4 represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4 YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4 struct {
	Addresses	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses	`path:"addresses" module:"openconfig-if-tunnel"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config	`path:"config" module:"openconfig-if-tunnel"`
	Neighbors	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors	`path:"neighbors" module:"openconfig-if-tunnel"`
	ProxyArp	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp	`path:"proxy-arp" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State	`path:"state" module:"openconfig-if-tunnel"`
	Unnumbered	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered	`path:"unnumbered" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses struct {
	Address	map[string]*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address	`path:"address" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses) IsYANGGoStruct() {}

// NewAddress creates a new entry in the Address list of the
// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses) NewAddress(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Address == nil {
		t.Address = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Address[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Address", key)
	}

	t.Address[key] = &OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address{
		Ip: &Ip,
	}

	return t.Address[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/addresses/address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config	`path:"config" module:"openconfig-if-tunnel"`
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/addresses/address/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/addresses/address/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	Origin	E_OpenconfigIfIp_IpAddressOrigin	`path:"origin" module:"openconfig-if-tunnel"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Addresses_Address_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config struct {
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-tunnel"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-tunnel"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/neighbors YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors struct {
	Neighbor	map[string]*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors) NewNeighbor(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor{
		Ip: &Ip,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/neighbors/neighbor YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-if-tunnel"`
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/neighbors/neighbor/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/neighbors/neighbor/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-tunnel"`
	Origin	E_OpenconfigIfIp_NeighborOrigin	`path:"origin" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/proxy-arp YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config	`path:"config" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/proxy-arp/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config struct {
	Mode	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config_Mode	`path:"mode" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/proxy-arp/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State struct {
	Mode	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv4_ProxyArp_Config_Mode	`path:"mode" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_ProxyArp_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State struct {
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters	`path:"counters" module:"openconfig-if-tunnel"`
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-tunnel"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-tunnel"`
	Mtu	*uint16	`path:"mtu" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters struct {
	InDiscardedPkts	*uint64	`path:"in-discarded-pkts" module:"openconfig-if-tunnel"`
	InErrorPkts	*uint64	`path:"in-error-pkts" module:"openconfig-if-tunnel"`
	InForwardedOctets	*uint64	`path:"in-forwarded-octets" module:"openconfig-if-tunnel"`
	InForwardedPkts	*uint64	`path:"in-forwarded-pkts" module:"openconfig-if-tunnel"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-if-tunnel"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-if-tunnel"`
	OutDiscardedPkts	*uint64	`path:"out-discarded-pkts" module:"openconfig-if-tunnel"`
	OutErrorPkts	*uint64	`path:"out-error-pkts" module:"openconfig-if-tunnel"`
	OutForwardedOctets	*uint64	`path:"out-forwarded-octets" module:"openconfig-if-tunnel"`
	OutForwardedPkts	*uint64	`path:"out-forwarded-pkts" module:"openconfig-if-tunnel"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-if-tunnel"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/unnumbered YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config	`path:"config" module:"openconfig-if-tunnel"`
	InterfaceRef	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef	`path:"interface-ref" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/unnumbered/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/unnumbered/interface-ref YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config	`path:"config" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/unnumbered/interface-ref/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-if-tunnel"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/unnumbered/interface-ref/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-if-tunnel"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv4/unnumbered/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv4_Unnumbered_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6 represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6 YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6 struct {
	Addresses	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses	`path:"addresses" module:"openconfig-if-tunnel"`
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config	`path:"config" module:"openconfig-if-tunnel"`
	Neighbors	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors	`path:"neighbors" module:"openconfig-if-tunnel"`
	RouterAdvertisement	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement	`path:"router-advertisement" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State	`path:"state" module:"openconfig-if-tunnel"`
	Unnumbered	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered	`path:"unnumbered" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/addresses YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses struct {
	Address	map[string]*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address	`path:"address" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses) IsYANGGoStruct() {}

// NewAddress creates a new entry in the Address list of the
// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses) NewAddress(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Address == nil {
		t.Address = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Address[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Address", key)
	}

	t.Address[key] = &OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address{
		Ip: &Ip,
	}

	return t.Address[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/addresses/address YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config	`path:"config" module:"openconfig-if-tunnel"`
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/addresses/address/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/addresses/address/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	Origin	E_OpenconfigIfIp_IpAddressOrigin	`path:"origin" module:"openconfig-if-tunnel"`
	PrefixLength	*uint8	`path:"prefix-length" module:"openconfig-if-tunnel"`
	Status	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Addresses_Address_State_Status	`path:"status" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Addresses_Address_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config struct {
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-tunnel"`
	DupAddrDetectTransmits	*uint32	`path:"dup-addr-detect-transmits" module:"openconfig-if-tunnel"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-tunnel"`
	Mtu	*uint32	`path:"mtu" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/neighbors YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors struct {
	Neighbor	map[string]*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors) NewNeighbor(Ip string) (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor)
	}

	key := Ip

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor{
		Ip: &Ip,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/neighbors/neighbor YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-if-tunnel"`
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Ip == nil {
		return nil, fmt.Errorf("nil value for key Ip")
	}

	return map[string]interface{}{
		"ip": *t.Ip,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/neighbors/neighbor/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config struct {
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/neighbors/neighbor/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State struct {
	Ip	*string	`path:"ip" module:"openconfig-if-tunnel"`
	IsRouter	*bool	`path:"is-router" module:"openconfig-if-tunnel"`
	LinkLayerAddress	*string	`path:"link-layer-address" module:"openconfig-if-tunnel"`
	NeighborState	E_OpenconfigInterfaces_Interfaces_Interface_RoutedVlan_Ipv6_Neighbors_Neighbor_State_NeighborState	`path:"neighbor-state" module:"openconfig-if-tunnel"`
	Origin	E_OpenconfigIfIp_NeighborOrigin	`path:"origin" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/router-advertisement YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config	`path:"config" module:"openconfig-if-tunnel"`
	Prefixes	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes	`path:"prefixes" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/router-advertisement/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config struct {
	Interval	*uint32	`path:"interval" module:"openconfig-if-tunnel"`
	Lifetime	*uint32	`path:"lifetime" module:"openconfig-if-tunnel"`
	Managed	*bool	`path:"managed" module:"openconfig-if-tunnel"`
	OtherConfig	*bool	`path:"other-config" module:"openconfig-if-tunnel"`
	Suppress	*bool	`path:"suppress" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/router-advertisement/prefixes YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes struct {
	Prefix	map[string]*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix	`path:"prefix" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes) IsYANGGoStruct() {}

// NewPrefix creates a new entry in the Prefix list of the
// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes) NewPrefix(Prefix string) (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Prefix == nil {
		t.Prefix = make(map[string]*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix)
	}

	key := Prefix

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Prefix[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Prefix", key)
	}

	t.Prefix[key] = &OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix{
		Prefix: &Prefix,
	}

	return t.Prefix[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/router-advertisement/prefixes/prefix YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config	`path:"config" module:"openconfig-if-tunnel"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix struct, which is a YANG list entry.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"prefix": *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/router-advertisement/prefixes/prefix/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config struct {
	DisableAdvertisement	*bool	`path:"disable-advertisement" module:"openconfig-if-tunnel"`
	DisableAutoconfiguration	*bool	`path:"disable-autoconfiguration" module:"openconfig-if-tunnel"`
	EnableOnlink	*bool	`path:"enable-onlink" module:"openconfig-if-tunnel"`
	PreferredLifetime	*uint32	`path:"preferred-lifetime" module:"openconfig-if-tunnel"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-tunnel"`
	ValidLifetime	*uint32	`path:"valid-lifetime" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/router-advertisement/prefixes/prefix/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State struct {
	DisableAdvertisement	*bool	`path:"disable-advertisement" module:"openconfig-if-tunnel"`
	DisableAutoconfiguration	*bool	`path:"disable-autoconfiguration" module:"openconfig-if-tunnel"`
	EnableOnlink	*bool	`path:"enable-onlink" module:"openconfig-if-tunnel"`
	PreferredLifetime	*uint32	`path:"preferred-lifetime" module:"openconfig-if-tunnel"`
	Prefix	*string	`path:"prefix" module:"openconfig-if-tunnel"`
	ValidLifetime	*uint32	`path:"valid-lifetime" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_Prefixes_Prefix_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/router-advertisement/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State struct {
	Interval	*uint32	`path:"interval" module:"openconfig-if-tunnel"`
	Lifetime	*uint32	`path:"lifetime" module:"openconfig-if-tunnel"`
	Managed	*bool	`path:"managed" module:"openconfig-if-tunnel"`
	OtherConfig	*bool	`path:"other-config" module:"openconfig-if-tunnel"`
	Suppress	*bool	`path:"suppress" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_RouterAdvertisement_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State struct {
	Counters	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters	`path:"counters" module:"openconfig-if-tunnel"`
	DhcpClient	*bool	`path:"dhcp-client" module:"openconfig-if-tunnel"`
	DupAddrDetectTransmits	*uint32	`path:"dup-addr-detect-transmits" module:"openconfig-if-tunnel"`
	Enabled	*bool	`path:"enabled" module:"openconfig-if-tunnel"`
	Mtu	*uint32	`path:"mtu" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/state/counters YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters struct {
	InDiscardedPkts	*uint64	`path:"in-discarded-pkts" module:"openconfig-if-tunnel"`
	InErrorPkts	*uint64	`path:"in-error-pkts" module:"openconfig-if-tunnel"`
	InForwardedOctets	*uint64	`path:"in-forwarded-octets" module:"openconfig-if-tunnel"`
	InForwardedPkts	*uint64	`path:"in-forwarded-pkts" module:"openconfig-if-tunnel"`
	InOctets	*uint64	`path:"in-octets" module:"openconfig-if-tunnel"`
	InPkts	*uint64	`path:"in-pkts" module:"openconfig-if-tunnel"`
	OutDiscardedPkts	*uint64	`path:"out-discarded-pkts" module:"openconfig-if-tunnel"`
	OutErrorPkts	*uint64	`path:"out-error-pkts" module:"openconfig-if-tunnel"`
	OutForwardedOctets	*uint64	`path:"out-forwarded-octets" module:"openconfig-if-tunnel"`
	OutForwardedPkts	*uint64	`path:"out-forwarded-pkts" module:"openconfig-if-tunnel"`
	OutOctets	*uint64	`path:"out-octets" module:"openconfig-if-tunnel"`
	OutPkts	*uint64	`path:"out-pkts" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_State_Counters) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/unnumbered YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config	`path:"config" module:"openconfig-if-tunnel"`
	InterfaceRef	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef	`path:"interface-ref" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/unnumbered/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/unnumbered/interface-ref YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef struct {
	Config	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config	`path:"config" module:"openconfig-if-tunnel"`
	State	*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State	`path:"state" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/unnumbered/interface-ref/config YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config struct {
	Interface	*string	`path:"interface" module:"openconfig-if-tunnel"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_Config) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/unnumbered/interface-ref/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State struct {
	Interface	*string	`path:"interface" module:"openconfig-if-tunnel"`
	Subinterface	*uint32	`path:"subinterface" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_InterfaceRef_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State represents the /openconfig-interfaces/interfaces/interface/tunnel/ipv6/unnumbered/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_Ipv6_Unnumbered_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigInterfaces_Interfaces_Interface_Tunnel_State represents the /openconfig-interfaces/interfaces/interface/tunnel/state YANG schema element.
type OpenconfigInterfaces_Interfaces_Interface_Tunnel_State struct {
	Dst	*string	`path:"dst" module:"openconfig-if-tunnel"`
	GreKey	*uint32	`path:"gre-key" module:"openconfig-if-tunnel"`
	Src	*string	`path:"src" module:"openconfig-if-tunnel"`
	Ttl	*uint8	`path:"ttl" module:"openconfig-if-tunnel"`
}

// IsYANGGoStruct ensures that OpenconfigInterfaces_Interfaces_Interface_Tunnel_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigInterfaces_Interfaces_Interface_Tunnel_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigInterfaces_Interfaces_Interface_Tunnel_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigInterfaces_Interfaces_Interface_Tunnel_State.
func (*OpenconfigInterfaces_Interfaces_Interface_Tunnel_State) ΛBelongingModule() string {
	return "openconfig-if-tunnel"
}


// OpenconfigKeychain_Keychains represents the /openconfig-keychain/keychains YANG schema element.
type OpenconfigKeychain_Keychains struct {
	Keychain	map[string]*OpenconfigKeychain_Keychains_Keychain	`path:"keychain" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains) IsYANGGoStruct() {}

// NewKeychain creates a new entry in the Keychain list of the
// OpenconfigKeychain_Keychains struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigKeychain_Keychains) NewKeychain(Name string) (*OpenconfigKeychain_Keychains_Keychain, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Keychain == nil {
		t.Keychain = make(map[string]*OpenconfigKeychain_Keychains_Keychain)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Keychain[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Keychain", key)
	}

	t.Keychain[key] = &OpenconfigKeychain_Keychains_Keychain{
		Name: &Name,
	}

	return t.Keychain[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains.
func (*OpenconfigKeychain_Keychains) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain represents the /openconfig-keychain/keychains/keychain YANG schema element.
type OpenconfigKeychain_Keychains_Keychain struct {
	Config	*OpenconfigKeychain_Keychains_Keychain_Config	`path:"config" module:"openconfig-keychain"`
	Keys	*OpenconfigKeychain_Keychains_Keychain_Keys	`path:"keys" module:"openconfig-keychain"`
	Name	*string	`path:"name" module:"openconfig-keychain"`
	State	*OpenconfigKeychain_Keychains_Keychain_State	`path:"state" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigKeychain_Keychains_Keychain struct, which is a YANG list entry.
func (t *OpenconfigKeychain_Keychains_Keychain) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain.
func (*OpenconfigKeychain_Keychains_Keychain) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Config represents the /openconfig-keychain/keychains/keychain/config YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Config struct {
	Name	*string	`path:"name" module:"openconfig-keychain"`
	Tolerance	OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union	`path:"tolerance" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Config.
func (*OpenconfigKeychain_Keychains_Keychain_Config) ΛBelongingModule() string {
	return "openconfig-keychain"
}

// OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-keychain/keychains/keychain/config/tolerance within the YANG schema.
// Union type can be one of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, UnionUint32].
type OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union interface {
	// Union type can be one of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, UnionUint32]
	Documentation_for_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union()
}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union ensures that E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance
// implements the OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union interface.
func (E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union() {}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union ensures that UnionUint32
// implements the OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union interface.
func (UnionUint32) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union() {}

// To_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigKeychain_Keychains_Keychain_Config) To_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union(i interface{}) (OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union, error) {
	if v, ok := i.(OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigKeychain_Keychains_Keychain_Config_Tolerance_Union, unknown union type, got: %T, want any of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, uint32]", i, i)
}


// OpenconfigKeychain_Keychains_Keychain_Keys represents the /openconfig-keychain/keychains/keychain/keys YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys struct {
	Key	map[OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union]*OpenconfigKeychain_Keychains_Keychain_Keys_Key	`path:"key" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys) IsYANGGoStruct() {}

// NewKey creates a new entry in the Key list of the
// OpenconfigKeychain_Keychains_Keychain_Keys struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys) NewKey(KeyId OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union) (*OpenconfigKeychain_Keychains_Keychain_Keys_Key, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Key == nil {
		t.Key = make(map[OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union]*OpenconfigKeychain_Keychains_Keychain_Keys_Key)
	}

	key := KeyId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Key[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Key", key)
	}

	t.Key[key] = &OpenconfigKeychain_Keychains_Keychain_Keys_Key{
		KeyId: KeyId,
	}

	return t.Key[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys.
func (*OpenconfigKeychain_Keychains_Keychain_Keys) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key represents the /openconfig-keychain/keychains/keychain/keys/key YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key struct {
	Config	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config	`path:"config" module:"openconfig-keychain"`
	KeyId	OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union	`path:"key-id" module:"openconfig-keychain"`
	ReceiveLifetime	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime	`path:"receive-lifetime" module:"openconfig-keychain"`
	SendLifetime	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime	`path:"send-lifetime" module:"openconfig-keychain"`
	State	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_State	`path:"state" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigKeychain_Keychains_Keychain_Keys_Key struct, which is a YANG list entry.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"key-id": t.KeyId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key) ΛBelongingModule() string {
	return "openconfig-keychain"
}

// OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-keychain/keychains/keychain/keys/key/key-id within the YANG schema.
// Union type can be one of [UnionString, UnionUint64].
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union interface {
	// Union type can be one of [UnionString, UnionUint64]
	Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union()
}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union ensures that UnionString
// implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union interface.
func (UnionString) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union() {}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union ensures that UnionUint64
// implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union interface.
func (UnionUint64) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union() {}

// To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key) To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union(i interface{}) (OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union, error) {
	if v, ok := i.(OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint64:
		return UnionUint64(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union, unknown union type, got: %T, want any of [string, uint64]", i, i)
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config represents the /openconfig-keychain/keychains/keychain/keys/key/config YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config struct {
	CryptoAlgorithm	E_OpenconfigKeychainTypes_CRYPTO_TYPE	`path:"crypto-algorithm" module:"openconfig-keychain"`
	KeyId	OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union	`path:"key-id" module:"openconfig-keychain"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) ΛBelongingModule() string {
	return "openconfig-keychain"
}

// To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config) To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union(i interface{}) (OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union, error) {
	if v, ok := i.(OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint64:
		return UnionUint64(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigKeychain_Keychains_Keychain_Keys_Key_Config_KeyId_Union, unknown union type, got: %T, want any of [string, uint64]", i, i)
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime represents the /openconfig-keychain/keychains/keychain/keys/key/receive-lifetime YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime struct {
	Config	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config	`path:"config" module:"openconfig-keychain"`
	State	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State	`path:"state" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config represents the /openconfig-keychain/keychains/keychain/keys/key/receive-lifetime/config YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config struct {
	EndTime	*uint64	`path:"end-time" module:"openconfig-keychain"`
	StartTime	*uint64	`path:"start-time" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_Config) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State represents the /openconfig-keychain/keychains/keychain/keys/key/receive-lifetime/state YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State struct {
	EndTime	*uint64	`path:"end-time" module:"openconfig-keychain"`
	StartTime	*uint64	`path:"start-time" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_ReceiveLifetime_State) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime represents the /openconfig-keychain/keychains/keychain/keys/key/send-lifetime YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime struct {
	Config	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config	`path:"config" module:"openconfig-keychain"`
	State	*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State	`path:"state" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config represents the /openconfig-keychain/keychains/keychain/keys/key/send-lifetime/config YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config struct {
	EndTime	*uint64	`path:"end-time" module:"openconfig-keychain"`
	SendAndReceive	*bool	`path:"send-and-receive" module:"openconfig-keychain"`
	StartTime	*uint64	`path:"start-time" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_Config) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State represents the /openconfig-keychain/keychains/keychain/keys/key/send-lifetime/state YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State struct {
	EndTime	*uint64	`path:"end-time" module:"openconfig-keychain"`
	SendAndReceive	*bool	`path:"send-and-receive" module:"openconfig-keychain"`
	StartTime	*uint64	`path:"start-time" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_SendLifetime_State) ΛBelongingModule() string {
	return "openconfig-keychain"
}


// OpenconfigKeychain_Keychains_Keychain_Keys_Key_State represents the /openconfig-keychain/keychains/keychain/keys/key/state YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_State struct {
	CryptoAlgorithm	E_OpenconfigKeychainTypes_CRYPTO_TYPE	`path:"crypto-algorithm" module:"openconfig-keychain"`
	KeyId	OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union	`path:"key-id" module:"openconfig-keychain"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_Keys_Key_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_Keys_Key_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_Keys_Key_State.
func (*OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) ΛBelongingModule() string {
	return "openconfig-keychain"
}

// OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-keychain/keychains/keychain/keys/key/state/key-id within the YANG schema.
// Union type can be one of [UnionString, UnionUint64].
type OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union interface {
	// Union type can be one of [UnionString, UnionUint64]
	Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union()
}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union ensures that UnionString
// implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union interface.
func (UnionString) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union() {}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union ensures that UnionUint64
// implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union interface.
func (UnionUint64) Documentation_for_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union() {}

// To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigKeychain_Keychains_Keychain_Keys_Key_State) To_OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union(i interface{}) (OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union, error) {
	if v, ok := i.(OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case string:
		return UnionString(v), nil
	case uint64:
		return UnionUint64(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigKeychain_Keychains_Keychain_Keys_Key_State_KeyId_Union, unknown union type, got: %T, want any of [string, uint64]", i, i)
}


// OpenconfigKeychain_Keychains_Keychain_State represents the /openconfig-keychain/keychains/keychain/state YANG schema element.
type OpenconfigKeychain_Keychains_Keychain_State struct {
	Name	*string	`path:"name" module:"openconfig-keychain"`
	Tolerance	OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union	`path:"tolerance" module:"openconfig-keychain"`
}

// IsYANGGoStruct ensures that OpenconfigKeychain_Keychains_Keychain_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigKeychain_Keychains_Keychain_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigKeychain_Keychains_Keychain_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigKeychain_Keychains_Keychain_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigKeychain_Keychains_Keychain_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigKeychain_Keychains_Keychain_State.
func (*OpenconfigKeychain_Keychains_Keychain_State) ΛBelongingModule() string {
	return "openconfig-keychain"
}

// OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-keychain/keychains/keychain/state/tolerance within the YANG schema.
// Union type can be one of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, UnionUint32].
type OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union interface {
	// Union type can be one of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, UnionUint32]
	Documentation_for_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union()
}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union ensures that E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance
// implements the OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union interface.
func (E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance) Documentation_for_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union() {}

// Documentation_for_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union ensures that UnionUint32
// implements the OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union interface.
func (UnionUint32) Documentation_for_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union() {}

// To_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigKeychain_Keychains_Keychain_State) To_OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union(i interface{}) (OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union, error) {
	if v, ok := i.(OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case uint32:
		return UnionUint32(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigKeychain_Keychains_Keychain_State_Tolerance_Union, unknown union type, got: %T, want any of [E_OpenconfigKeychain_Keychains_Keychain_Config_Tolerance, uint32]", i, i)
}


// OpenconfigLldp_Lldp represents the /openconfig-lldp/lldp YANG schema element.
type OpenconfigLldp_Lldp struct {
	Config	*OpenconfigLldp_Lldp_Config	`path:"config" module:"openconfig-lldp"`
	Interfaces	*OpenconfigLldp_Lldp_Interfaces	`path:"interfaces" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp.
func (*OpenconfigLldp_Lldp) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Config represents the /openconfig-lldp/lldp/config YANG schema element.
type OpenconfigLldp_Lldp_Config struct {
	ChassisId	*string	`path:"chassis-id" module:"openconfig-lldp"`
	ChassisIdType	E_OpenconfigLldp_ChassisIdType	`path:"chassis-id-type" module:"openconfig-lldp"`
	Enabled	*bool	`path:"enabled" module:"openconfig-lldp"`
	HelloTimer	*uint64	`path:"hello-timer" module:"openconfig-lldp"`
	ManagementAddress	*OpenconfigLldp_Lldp_Config_ManagementAddress	`path:"management-address" module:"arista-lldp-augments"`
	SuppressTlvAdvertisement	[]E_OpenconfigLldpTypes_LLDP_TLV	`path:"suppress-tlv-advertisement" module:"openconfig-lldp"`
	SystemDescription	*string	`path:"system-description" module:"openconfig-lldp"`
	SystemName	*string	`path:"system-name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Config.
func (*OpenconfigLldp_Lldp_Config) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Config_ManagementAddress represents the /openconfig-lldp/lldp/config/management-address YANG schema element.
type OpenconfigLldp_Lldp_Config_ManagementAddress struct {
	Interface	*string	`path:"interface" module:"arista-lldp-augments"`
	NetworkInstance	*string	`path:"network-instance" module:"arista-lldp-augments"`
	TransmitMode	E_AristaLldpAugments_TransmitModeEnum	`path:"transmit-mode" module:"arista-lldp-augments"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Config_ManagementAddress implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Config_ManagementAddress) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Config_ManagementAddress) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Config_ManagementAddress"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Config_ManagementAddress) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Config_ManagementAddress) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Config_ManagementAddress.
func (*OpenconfigLldp_Lldp_Config_ManagementAddress) ΛBelongingModule() string {
	return "arista-lldp-augments"
}


// OpenconfigLldp_Lldp_Interfaces represents the /openconfig-lldp/lldp/interfaces YANG schema element.
type OpenconfigLldp_Lldp_Interfaces struct {
	Interface	map[string]*OpenconfigLldp_Lldp_Interfaces_Interface	`path:"interface" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigLldp_Lldp_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces) NewInterface(Name string) (*OpenconfigLldp_Lldp_Interfaces_Interface, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigLldp_Lldp_Interfaces_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigLldp_Lldp_Interfaces_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces.
func (*OpenconfigLldp_Lldp_Interfaces) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface represents the /openconfig-lldp/lldp/interfaces/interface YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface struct {
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Config	`path:"config" module:"openconfig-lldp"`
	Name	*string	`path:"name" module:"openconfig-lldp"`
	Neighbors	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors	`path:"neighbors" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface.
func (*OpenconfigLldp_Lldp_Interfaces_Interface) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Config represents the /openconfig-lldp/lldp/interfaces/interface/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Config struct {
	Enabled	OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union	`path:"enabled" module:"openconfig-lldp"`
	Name	*string	`path:"name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Config.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Config) ΛBelongingModule() string {
	return "openconfig-lldp"
}

// OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-lldp/lldp/interfaces/interface/config/enabled within the YANG schema.
// Union type can be one of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, UnionBool].
type OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union interface {
	// Union type can be one of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, UnionBool]
	Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union()
}

// Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union ensures that E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled
// implements the OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union interface.
func (E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled) Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union() {}

// Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union ensures that UnionBool
// implements the OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union interface.
func (UnionBool) Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union() {}

// To_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Config) To_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union(i interface{}) (OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union, error) {
	if v, ok := i.(OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case bool:
		return UnionBool(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled_Union, unknown union type, got: %T, want any of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, bool]", i, i)
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors represents the /openconfig-lldp/lldp/interfaces/interface/neighbors YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors struct {
	Neighbor	map[string]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor	`path:"neighbor" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) NewNeighbor(Id string) (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor{
		Id: &Id,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor struct {
	Capabilities	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities	`path:"capabilities" module:"openconfig-lldp"`
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config	`path:"config" module:"openconfig-lldp"`
	CustomTlvs	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs	`path:"custom-tlvs" module:"openconfig-lldp"`
	Id	*string	`path:"id" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities struct {
	Capability	map[E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability	`path:"capability" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) IsYANGGoStruct() {}

// NewCapability creates a new entry in the Capability list of the
// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) NewCapability(Name E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY) (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Capability == nil {
		t.Capability = make(map[E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Capability[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Capability", key)
	}

	t.Capability[key] = &OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability{
		Name: Name,
	}

	return t.Capability[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability struct {
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config	`path:"config" module:"openconfig-lldp"`
	Name	E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY	`path:"name" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State	`path:"state" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"name": t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_Config) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/capabilities/capability/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-lldp"`
	Name	E_OpenconfigLldpTypes_LLDP_SYSTEM_CAPABILITY	`path:"name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Capabilities_Capability_State) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_Config) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs struct {
	Tlv	map[OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv	`path:"tlv" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) IsYANGGoStruct() {}

// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key represents the key for list Tlv of element /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key struct {
	Type	int32	`path:"type"`
	Oui	string	`path:"oui"`
	OuiSubtype	string	`path:"oui-subtype"`
}

// IsYANGGoKeyStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key partially implements the
// yang.GoKeyStruct interface. This allows functions that need to
// handle this key struct to identify it as being generated by gogen.
func (OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key) IsYANGGoKeyStruct() {}

// ΛListKeyMap returns the values of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key key struct.
func (t OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key) ΛListKeyMap() (map[string]interface{}, error) {
	return map[string]interface{}{
		"type": t.Type,
		"oui": t.Oui,
		"oui-subtype": t.OuiSubtype,
	}, nil
}

// NewTlv creates a new entry in the Tlv list of the
// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) NewTlv(Type int32, Oui string, OuiSubtype string) (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Tlv == nil {
		t.Tlv = make(map[OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key]*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv)
	}

	key := OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Key{
		Type: Type,
		Oui: Oui,
		OuiSubtype: OuiSubtype,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Tlv[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Tlv", key)
	}

	t.Tlv[key] = &OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv{
		Type: &Type,
		Oui: &Oui,
		OuiSubtype: &OuiSubtype,
	}

	return t.Tlv[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv struct {
	Config	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config	`path:"config" module:"openconfig-lldp"`
	Oui	*string	`path:"oui" module:"openconfig-lldp"`
	OuiSubtype	*string	`path:"oui-subtype" module:"openconfig-lldp"`
	State	*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State	`path:"state" module:"openconfig-lldp"`
	Type	*int32	`path:"type" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv struct, which is a YANG list entry.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Oui == nil {
		return nil, fmt.Errorf("nil value for key Oui")
	}

	if t.OuiSubtype == nil {
		return nil, fmt.Errorf("nil value for key OuiSubtype")
	}

	if t.Type == nil {
		return nil, fmt.Errorf("nil value for key Type")
	}

	return map[string]interface{}{
		"oui": *t.Oui,
		"oui-subtype": *t.OuiSubtype,
		"type": *t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv/config YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_Config) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/custom-tlvs/tlv/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State struct {
	Oui	*string	`path:"oui" module:"openconfig-lldp"`
	OuiSubtype	*string	`path:"oui-subtype" module:"openconfig-lldp"`
	Type	*int32	`path:"type" module:"openconfig-lldp"`
	Value	Binary	`path:"value" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_CustomTlvs_Tlv_State) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State represents the /openconfig-lldp/lldp/interfaces/interface/neighbors/neighbor/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State struct {
	ChassisId	*string	`path:"chassis-id" module:"openconfig-lldp"`
	ChassisIdType	E_OpenconfigLldp_ChassisIdType	`path:"chassis-id-type" module:"openconfig-lldp"`
	Id	*string	`path:"id" module:"openconfig-lldp"`
	LastUpdateTime	*uint64	`path:"last-update-time" module:"arista-lldp-augments"`
	ManagementAddress	*string	`path:"management-address" module:"openconfig-lldp"`
	ManagementAddressType	*string	`path:"management-address-type" module:"openconfig-lldp"`
	PortDescription	*string	`path:"port-description" module:"openconfig-lldp"`
	PortId	*string	`path:"port-id" module:"openconfig-lldp"`
	PortIdType	E_OpenconfigLldp_PortIdType	`path:"port-id-type" module:"openconfig-lldp"`
	RegistrationTime	*uint64	`path:"registration-time" module:"arista-lldp-augments"`
	SystemDescription	*string	`path:"system-description" module:"openconfig-lldp"`
	SystemName	*string	`path:"system-name" module:"openconfig-lldp"`
	Ttl	*uint16	`path:"ttl" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_Neighbors_Neighbor_State) ΛBelongingModule() string {
	return "openconfig-lldp"
}


// OpenconfigLldp_Lldp_Interfaces_Interface_State represents the /openconfig-lldp/lldp/interfaces/interface/state YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_State struct {
	Counters	*OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters	`path:"counters" module:"openconfig-lldp"`
	Enabled	OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union	`path:"enabled" module:"openconfig-lldp"`
	Name	*string	`path:"name" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigLldp_Lldp_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigLldp_Lldp_Interfaces_Interface_State.
func (*OpenconfigLldp_Lldp_Interfaces_Interface_State) ΛBelongingModule() string {
	return "openconfig-lldp"
}

// OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-lldp/lldp/interfaces/interface/state/enabled within the YANG schema.
// Union type can be one of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, UnionBool].
type OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union interface {
	// Union type can be one of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, UnionBool]
	Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union()
}

// Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union ensures that E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled
// implements the OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union interface.
func (E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled) Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union() {}

// Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union ensures that UnionBool
// implements the OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union interface.
func (UnionBool) Documentation_for_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union() {}

// To_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigLldp_Lldp_Interfaces_Interface_State) To_OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union(i interface{}) (OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union, error) {
	if v, ok := i.(OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union); ok {
		return v, nil
	}
	switch v := i.(type) {
	case bool:
		return UnionBool(v), nil
	}
	return nil, fmt.Errorf("cannot convert %v to OpenconfigLldp_Lldp_Interfaces_Interface_State_Enabled_Union, unknown union type, got: %T, want any of [E_OpenconfigLldp_Lldp_Interfaces_Interface_Config_Enabled, bool]", i, i)
}


// OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters represents the /openconfig-lldp/lldp/interfaces/interface/state/counters YANG schema element.
type OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters struct {
	FrameDiscard	*uint64	`path:"frame-discard" module:"openconfig-lldp"`
	FrameErrorIn	*uint64	`path:"frame-error-in" module:"openconfig-lldp"`
	FrameErrorOut	*uint64	`path:"frame-error-out" module:"openconfig-lldp"`
	FrameIn	*uint64	`path:"frame-in" module:"openconfig-lldp"`
	FrameOut	*uint64	`path:"frame-out" module:"openconfig-lldp"`
	LastClear	*string	`path:"last-clear" module:"openconfig-lldp"`
	TlvDiscard	*uint64	`path:"tlv-discard" module:"openconfig-lldp"`
	TlvUnknown	*uint64	`path:"tlv-unknown" module:"openconfig-lldp"`
}

// IsYANGGoStruct ensures that OpenconfigLldp_Lldp_Interfaces_Interface_State_Counters implements the yang.GoStruct
// interface. This allows functions t