package csbi

import (
	"context"
	"testing"

	spb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/southbound"
	"github.com/openconfig/ygot/gogen"
	"google.golang.org/grpc/peer"
)

func Test_write(t *testing.T) {
	type args struct {
		code    *gogen.GeneratedCode
		path    string
		sbiType spb.Type
	}
	tests := []struct {
		name    string
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if err := write(context.Background(), tt.args.code, tt.args.path, tt.args.sbiType); (err != nil) != tt.wantErr {
				t.Errorf("write() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func Test_writeCsbi(t *testing.T) {
	type args struct {
		code *gogen.GeneratedCode
		path string
	}
	tests := []struct {
		name    string
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if err := writeCsbi(peer.NewContext(context.Background(), &peer.Peer{}), tt.args.code, tt.args.path); (err != nil) != tt.wantErr {
				t.Errorf("writeCsbi() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func Test_writePlugin(t *testing.T) {
	type args struct {
		code *gogen.GeneratedCode
		path string
	}
	tests := []struct {
		name    string
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if err := writePlugin(tt.args.code, tt.args.path); (err != nil) != tt.wantErr {
				t.Errorf("writePlugin() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func Test_copyFile(t *testing.T) {
	type args struct {
		path     string
		filename string
	}
	tests := []struct {
		name    string
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if err := copyFile(tt.args.path, tt.args.filename); (err != nil) != tt.wantErr {
				t.Errorf("copyFile() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func Test_writeCode(t *testing.T) {
	type args struct {
		path string
		code *gogen.GeneratedCode
	}
	tests := []struct {
		name    string
		args    args
		wantErr bool
	}{
		// TODO: Add test cases.
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if err := writeCode(tt.args.path, tt.args.code, spb.Type_TYPE_PLUGIN); (err != nil) != tt.wantErr {
				t.Errorf("writeCode() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}
