/*
Package main is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was false
in this case).

This package was generated by /Users/mk/go/pkg/mod/github.com/openconfig/ygot@v0.10.13/genutil/names.go
using the following YANG input files:
	- models/openconfig/public/release/models/interfaces/openconfig-interfaces.yang
	- models/openconfig/public/release/models/openflow/openconfig-openflow.yang
	- models/openconfig/public/release/models/platform/openconfig-platform.yang
	- models/openconfig/public/release/models/system/openconfig-system.yang
	- models/openconfig/public/release/models/acl/openconfig-acl.yang
	- models/openconfig/public/release/models/network-instance/openconfig-network-instance.yang
Imported modules were sourced from:
	- models/...
*/
package main

import (
	"encoding/json"
	"fmt"
	"reflect"

	gpb "github.com/openconfig/gnmi/proto/gnmi"
	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/ygot/ytypes"

	spb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/southbound"
	"github.com/google/uuid"
	"github.com/openconfig/ygot/util"
	log "github.com/sirupsen/logrus"
)

var PluginSymbol Csbi

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

var (
	SchemaTree map[string]*yang.Entry
)

func init() {
	var err error
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " + err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root:       &Device{},
		SchemaTree: uzp,
		Unmarshal:  Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn)
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}

// ΓModelData contains the catalogue information corresponding to the modules for
// which Go code was generated.
var ΓModelData = []*gpb.ModelData{
	{
		Name:         "iana-if-type",
		Organization: "IANA",
	},
	{
		Name:         "ietf-inet-types",
		Organization: "IETF NETMOD (NETCONF Data Modeling Language) Working Group",
	},
	{
		Name:         "ietf-interfaces",
		Organization: "IETF NETMOD (Network Modeling) Working Group",
	},
	{
		Name:         "ietf-yang-types",
		Organization: "IETF NETMOD (NETCONF Data Modeling Language) Working Group",
	},
	{
		Name:         "openconfig-aaa",
		Organization: "OpenConfig working group",
		Version:      "0.5.0",
	},
	{
		Name:         "openconfig-aaa-types",
		Organization: "OpenConfig working group",
		Version:      "0.4.1",
	},
	{
		Name:         "openconfig-acl",
		Organization: "OpenConfig working group",
		Version:      "1.1.1",
	},
	{
		Name:         "openconfig-aft",
		Organization: "OpenConfig working group",
		Version:      "0.6.0",
	},
	{
		Name:         "openconfig-aft-types",
		Organization: "OpenConfig Working Group",
		Version:      "0.3.4",
	},
	{
		Name:         "openconfig-alarm-types",
		Organization: "OpenConfig working group",
		Version:      "0.2.1",
	},
	{
		Name:         "openconfig-alarms",
		Organization: "OpenConfig working group",
		Version:      "0.3.2",
	},
	{
		Name:         "openconfig-bfd",
		Organization: "OpenConfig working group",
		Version:      "0.2.2",
	},
	{
		Name:         "openconfig-bgp",
		Organization: "OpenConfig working group",
		Version:      "0.6.1",
	},
	{
		Name:         "openconfig-bgp-types",
		Organization: "OpenConfig working group",
		Version:      "5.3.0",
	},
	{
		Name:         "openconfig-extensions",
		Organization: "OpenConfig working group",
	},
	{
		Name:         "openconfig-if-aggregate",
		Organization: "OpenConfig working group",
		Version:      "2.4.3",
	},
	{
		Name:         "openconfig-if-ethernet",
		Organization: "OpenConfig working group",
		Version:      "2.10.0",
	},
	{
		Name:         "openconfig-if-types",
		Organization: "OpenConfig working group",
		Version:      "0.2.1",
	},
	{
		Name:         "openconfig-igmp",
		Organization: "OpenConfig working group",
		Version:      "0.2.0",
	},
	{
		Name:         "openconfig-igmp-types",
		Organization: "OpenConfig working group",
		Version:      "0.1.1",
	},
	{
		Name:         "openconfig-inet-types",
		Organization: "OpenConfig working group",
		Version:      "0.4.0",
	},
	{
		Name:         "openconfig-interfaces",
		Organization: "OpenConfig working group",
		Version:      "2.5.0",
	},
	{
		Name:         "openconfig-isis",
		Organization: "OpenConfig working group",
		Version:      "0.6.1",
	},
	{
		Name:         "openconfig-isis-lsdb-types",
		Organization: "OpenConfig working group",
		Version:      "0.4.2",
	},
	{
		Name:         "openconfig-isis-types",
		Organization: "OpenConfig working group",
		Version:      "0.4.3",
	},
	{
		Name:         "openconfig-license",
		Organization: "OpenConfig working group",
		Version:      "0.2.0",
	},
	{
		Name:         "openconfig-local-routing",
		Organization: "OpenConfig working group",
		Version:      "1.2.0",
	},
	{
		Name:         "openconfig-messages",
		Organization: "OpenConfig working group",
		Version:      "0.0.1",
	},
	{
		Name:         "openconfig-mpls",
		Organization: "OpenConfig working group",
		Version:      "3.1.0",
	},
	{
		Name:         "openconfig-mpls-ldp",
		Organization: "OpenConfig working group",
		Version:      "3.1.0",
	},
	{
		Name:         "openconfig-mpls-rsvp",
		Organization: "OpenConfig working group",
		Version:      "3.0.2",
	},
	{
		Name:         "openconfig-mpls-sr",
		Organization: "OpenConfig working group",
		Version:      "3.0.1",
	},
	{
		Name:         "openconfig-mpls-types",
		Organization: "OpenConfig working group",
		Version:      "3.2.0",
	},
	{
		Name:         "openconfig-network-instance",
		Organization: "OpenConfig working group",
		Version:      "0.14.0",
	},
	{
		Name:         "openconfig-network-instance-l3",
		Organization: "OpenConfig working group",
		Version:      "0.11.1",
	},
	{
		Name:         "openconfig-network-instance-types",
		Organization: "OpenConfig working group",
		Version:      "0.9.0",
	},
	{
		Name:         "openconfig-openflow",
		Organization: "OpenConfig working group",
		Version:      "0.1.2",
	},
	{
		Name:         "openconfig-openflow-types",
		Organization: "OpenConfig working group",
		Version:      "0.1.3",
	},
	{
		Name:         "openconfig-ospf-types",
		Organization: "OpenConfig working group",
		Version:      "0.1.3",
	},
	{
		Name:         "openconfig-ospfv2",
		Organization: "OpenConfig working group",
		Version:      "0.2.3",
	},
	{
		Name:         "openconfig-packet-match",
		Organization: "OpenConfig working group",
		Version:      "1.1.1",
	},
	{
		Name:         "openconfig-packet-match-types",
		Organization: "OpenConfig working group",
		Version:      "1.1.0",
	},
	{
		Name:         "openconfig-pim",
		Organization: "OpenConfig working group",
		Version:      "0.4.1",
	},
	{
		Name:         "openconfig-pim-types",
		Organization: "OpenConfig working group",
		Version:      "0.1.1",
	},
	{
		Name:         "openconfig-platform",
		Organization: "OpenConfig working group",
		Version:      "0.13.0",
	},
	{
		Name:         "openconfig-platform-types",
		Organization: "OpenConfig working group",
		Version:      "1.1.0",
	},
	{
		Name:         "openconfig-policy-forwarding",
		Organization: "OpenConfig working group",
		Version:      "0.2.1",
	},
	{
		Name:         "openconfig-policy-types",
		Organization: "OpenConfig working group",
		Version:      "3.1.1",
	},
	{
		Name:         "openconfig-procmon",
		Organization: "OpenConfig working group",
		Version:      "0.4.0",
	},
	{
		Name:         "openconfig-rib-bgp",
		Organization: "OpenConfig working group",
		Version:      "0.7.0",
	},
	{
		Name:         "openconfig-rib-bgp-types",
		Organization: "OpenConfig working group",
		Version:      "0.5.0",
	},
	{
		Name:         "openconfig-routing-policy",
		Organization: "OpenConfig working group",
		Version:      "3.2.2",
	},
	{
		Name:         "openconfig-segment-routing",
		Organization: "OpenConfig working group",
		Version:      "0.3.0",
	},
	{
		Name:         "openconfig-segment-routing-types",
		Organization: "OpenConfig working group",
		Version:      "0.2.0",
	},
	{
		Name:         "openconfig-srte-policy",
		Organization: "OpenConfig working group",
		Version:      "0.2.2",
	},
	{
		Name:         "openconfig-system",
		Organization: "OpenConfig working group",
		Version:      "0.9.1",
	},
	{
		Name:         "openconfig-system-logging",
		Organization: "OpenConfig working group",
		Version:      "0.3.1",
	},
	{
		Name:         "openconfig-system-management",
		Organization: "OpenConfig working group",
		Version:      "0.3.0",
	},
	{
		Name:         "openconfig-system-terminal",
		Organization: "OpenConfig working group",
		Version:      "0.3.1",
	},
	{
		Name:         "openconfig-types",
		Organization: "OpenConfig working group",
		Version:      "0.6.0",
	},
	{
		Name:         "openconfig-vlan",
		Organization: "OpenConfig working group",
		Version:      "3.2.0",
	},
	{
		Name:         "openconfig-vlan-types",
		Organization: "OpenConfig working group",
		Version:      "3.1.1",
	},
	{
		Name:         "openconfig-yang-types",
		Organization: "OpenConfig working group",
		Version:      "0.3.0",
	},
}

// Device represents the /device YANG schema element.
type Device struct {
	Acl              *OpenconfigAcl_Acl                          `path:"acl" module:"openconfig-acl"`
	Bfd              *OpenconfigBfd_Bfd                          `path:"bfd" module:"openconfig-bfd"`
	Bgp              *OpenconfigBgp_Bgp                          `path:"bgp" module:"openconfig-bgp"`
	Components       *OpenconfigPlatform_Components              `path:"components" module:"openconfig-platform"`
	Interfaces       *IETFInterfaces_Interfaces                  `path:"interfaces" module:"ietf-interfaces"`
	InterfacesState  *IETFInterfaces_InterfacesState             `path:"interfaces-state" module:"ietf-interfaces"`
	LocalRoutes      *OpenconfigLocalRouting_LocalRoutes         `path:"local-routes" module:"openconfig-local-routing"`
	Messages         *OpenconfigMessages_Messages                `path:"messages" module:"openconfig-messages"`
	NetworkInstances *OpenconfigNetworkInstance_NetworkInstances `path:"network-instances" module:"openconfig-network-instance"`
	RoutingPolicy    *OpenconfigRoutingPolicy_RoutingPolicy      `path:"routing-policy" module:"openconfig-routing-policy"`
	System           *OpenconfigSystem_System                    `path:"system" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// IETFInterfaces_Interfaces represents the /ietf-interfaces/interfaces YANG schema element.
type IETFInterfaces_Interfaces struct {
	Interface map[string]*IETFInterfaces_Interfaces_Interface `path:"interface" module:"ietf-interfaces"`
}

// IsYANGGoStruct ensures that IETFInterfaces_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*IETFInterfaces_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// IETFInterfaces_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *IETFInterfaces_Interfaces) NewInterface(Name string) (*IETFInterfaces_Interfaces_Interface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*IETFInterfaces_Interfaces_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &IETFInterfaces_Interfaces_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *IETFInterfaces_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["IETFInterfaces_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *IETFInterfaces_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// IETFInterfaces_InterfacesState represents the /ietf-interfaces/interfaces-state YANG schema element.
type IETFInterfaces_InterfacesState struct {
	Interface map[string]*IETFInterfaces_InterfacesState_Interface `path:"interface" module:"ietf-interfaces"`
}

// IsYANGGoStruct ensures that IETFInterfaces_InterfacesState implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*IETFInterfaces_InterfacesState) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// IETFInterfaces_InterfacesState struct. The keys of the list are populated from the input
// arguments.
func (t *IETFInterfaces_InterfacesState) NewInterface(Name string) (*IETFInterfaces_InterfacesState_Interface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*IETFInterfaces_InterfacesState_Interface)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &IETFInterfaces_InterfacesState_Interface{
		Name: &Name,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *IETFInterfaces_InterfacesState) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["IETFInterfaces_InterfacesState"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *IETFInterfaces_InterfacesState) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// IETFInterfaces_InterfacesState_Interface represents the /ietf-interfaces/interfaces-state/interface YANG schema element.
type IETFInterfaces_InterfacesState_Interface struct {
	AdminStatus   E_IETFInterfaces_InterfacesState_Interface_AdminStatus `path:"admin-status" module:"ietf-interfaces"`
	HigherLayerIf []string                                               `path:"higher-layer-if" module:"ietf-interfaces"`
	IfIndex       *int32                                                 `path:"if-index" module:"ietf-interfaces"`
	LastChange    *string                                                `path:"last-change" module:"ietf-interfaces"`
	LowerLayerIf  []string                                               `path:"lower-layer-if" module:"ietf-interfaces"`
	Name          *string                                                `path:"name" module:"ietf-interfaces"`
	OperStatus    E_IETFInterfaces_InterfacesState_Interface_OperStatus  `path:"oper-status" module:"ietf-interfaces"`
	PhysAddress   *string                                                `path:"phys-address" module:"ietf-interfaces"`
	Speed         *uint64                                                `path:"speed" module:"ietf-interfaces"`
	Statistics    *IETFInterfaces_InterfacesState_Interface_Statistics   `path:"statistics" module:"ietf-interfaces"`
	Type          E_IETFInterfaces_InterfaceType                         `path:"type" module:"ietf-interfaces"`
}

// IsYANGGoStruct ensures that IETFInterfaces_InterfacesState_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*IETFInterfaces_InterfacesState_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the IETFInterfaces_InterfacesState_Interface struct, which is a YANG list entry.
func (t *IETFInterfaces_InterfacesState_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *IETFInterfaces_InterfacesState_Interface) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["IETFInterfaces_InterfacesState_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *IETFInterfaces_InterfacesState_Interface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// IETFInterfaces_InterfacesState_Interface_Statistics represents the /ietf-interfaces/interfaces-state/interface/statistics YANG schema element.
type IETFInterfaces_InterfacesState_Interface_Statistics struct {
	DiscontinuityTime *string `path:"discontinuity-time" module:"ietf-interfaces"`
	InBroadcastPkts   *uint64 `path:"in-broadcast-pkts" module:"ietf-interfaces"`
	InDiscards        *uint32 `path:"in-discards" module:"ietf-interfaces"`
	InErrors          *uint32 `path:"in-errors" module:"ietf-interfaces"`
	InMulticastPkts   *uint64 `path:"in-multicast-pkts" module:"ietf-interfaces"`
	InOctets          *uint64 `path:"in-octets" module:"ietf-interfaces"`
	InUnicastPkts     *uint64 `path:"in-unicast-pkts" module:"ietf-interfaces"`
	InUnknownProtos   *uint32 `path:"in-unknown-protos" module:"ietf-interfaces"`
	OutBroadcastPkts  *uint64 `path:"out-broadcast-pkts" module:"ietf-interfaces"`
	OutDiscards       *uint32 `path:"out-discards" module:"ietf-interfaces"`
	OutErrors         *uint32 `path:"out-errors" module:"ietf-interfaces"`
	OutMulticastPkts  *uint64 `path:"out-multicast-pkts" module:"ietf-interfaces"`
	OutOctets         *uint64 `path:"out-octets" module:"ietf-interfaces"`
	OutUnicastPkts    *uint64 `path:"out-unicast-pkts" module:"ietf-interfaces"`
}

// IsYANGGoStruct ensures that IETFInterfaces_InterfacesState_Interface_Statistics implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*IETFInterfaces_InterfacesState_Interface_Statistics) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *IETFInterfaces_InterfacesState_Interface_Statistics) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["IETFInterfaces_InterfacesState_Interface_Statistics"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *IETFInterfaces_InterfacesState_Interface_Statistics) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// IETFInterfaces_Interfaces_Interface represents the /ietf-interfaces/interfaces/interface YANG schema element.
type IETFInterfaces_Interfaces_Interface struct {
	AdminStatus          E_IETFInterfaces_Interfaces_Interface_AdminStatus          `path:"admin-status" module:"ietf-interfaces"`
	Description          *string                                                    `path:"description" module:"ietf-interfaces"`
	Enabled              *bool                                                      `path:"enabled" module:"ietf-interfaces"`
	HigherLayerIf        []string                                                   `path:"higher-layer-if" module:"ietf-interfaces"`
	IfIndex              *int32                                                     `path:"if-index" module:"ietf-interfaces"`
	LastChange           *string                                                    `path:"last-change" module:"ietf-interfaces"`
	LinkUpDownTrapEnable E_IETFInterfaces_Interfaces_Interface_LinkUpDownTrapEnable `path:"link-up-down-trap-enable" module:"ietf-interfaces"`
	LowerLayerIf         []string                                                   `path:"lower-layer-if" module:"ietf-interfaces"`
	Name                 *string                                                    `path:"name" module:"ietf-interfaces"`
	OperStatus           E_IETFInterfaces_Interfaces_Interface_OperStatus           `path:"oper-status" module:"ietf-interfaces"`
	PhysAddress          *string                                                    `path:"phys-address" module:"ietf-interfaces"`
	Speed                *uint64                                                    `path:"speed" module:"ietf-interfaces"`
	Statistics           *IETFInterfaces_Interfaces_Interface_Statistics            `path:"statistics" module:"ietf-interfaces"`
	Type                 E_IETFInterfaces_InterfaceType                             `path:"type" module:"ietf-interfaces"`
}

// IsYANGGoStruct ensures that IETFInterfaces_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*IETFInterfaces_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the IETFInterfaces_Interfaces_Interface struct, which is a YANG list entry.
func (t *IETFInterfaces_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *IETFInterfaces_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["IETFInterfaces_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *IETFInterfaces_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// IETFInterfaces_Interfaces_Interface_Statistics represents the /ietf-interfaces/interfaces/interface/statistics YANG schema element.
type IETFInterfaces_Interfaces_Interface_Statistics struct {
	DiscontinuityTime *string `path:"discontinuity-time" module:"ietf-interfaces"`
	InBroadcastPkts   *uint64 `path:"in-broadcast-pkts" module:"ietf-interfaces"`
	InDiscards        *uint32 `path:"in-discards" module:"ietf-interfaces"`
	InErrors          *uint32 `path:"in-errors" module:"ietf-interfaces"`
	InMulticastPkts   *uint64 `path:"in-multicast-pkts" module:"ietf-interfaces"`
	InOctets          *uint64 `path:"in-octets" module:"ietf-interfaces"`
	InUnicastPkts     *uint64 `path:"in-unicast-pkts" module:"ietf-interfaces"`
	InUnknownProtos   *uint32 `path:"in-unknown-protos" module:"ietf-interfaces"`
	OutBroadcastPkts  *uint64 `path:"out-broadcast-pkts" module:"ietf-interfaces"`
	OutDiscards       *uint32 `path:"out-discards" module:"ietf-interfaces"`
	OutErrors         *uint32 `path:"out-errors" module:"ietf-interfaces"`
	OutMulticastPkts  *uint64 `path:"out-multicast-pkts" module:"ietf-interfaces"`
	OutOctets         *uint64 `path:"out-octets" module:"ietf-interfaces"`
	OutUnicastPkts    *uint64 `path:"out-unicast-pkts" module:"ietf-interfaces"`
}

// IsYANGGoStruct ensures that IETFInterfaces_Interfaces_Interface_Statistics implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*IETFInterfaces_Interfaces_Interface_Statistics) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *IETFInterfaces_Interfaces_Interface_Statistics) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["IETFInterfaces_Interfaces_Interface_Statistics"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *IETFInterfaces_Interfaces_Interface_Statistics) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl represents the /openconfig-acl/acl YANG schema element.
type OpenconfigAcl_Acl struct {
	AclSets    *OpenconfigAcl_Acl_AclSets    `path:"acl-sets" module:"openconfig-acl"`
	Config     *OpenconfigAcl_Acl_Config     `path:"config" module:"openconfig-acl"`
	Interfaces *OpenconfigAcl_Acl_Interfaces `path:"interfaces" module:"openconfig-acl"`
	State      *OpenconfigAcl_Acl_State      `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigAcl_Acl_AclSets represents the /openconfig-acl/acl/acl-sets YANG schema element.
type OpenconfigAcl_Acl_AclSets struct {
	AclSet map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet `path:"acl-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_AclSets_AclSet_Key represents the key for list AclSet of element /openconfig-acl/acl/acl-sets.
type OpenconfigAcl_Acl_AclSets_AclSet_Key struct {
	Name string                   `path:"name"`
	Type E_OpenconfigAcl_ACL_TYPE `path:"type"`
}

// NewAclSet creates a new entry in the AclSet list of the
// OpenconfigAcl_Acl_AclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_AclSets) NewAclSet(Name string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_AclSets_AclSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclSet == nil {
		t.AclSet = make(map[OpenconfigAcl_Acl_AclSets_AclSet_Key]*OpenconfigAcl_Acl_AclSets_AclSet)
	}

	key := OpenconfigAcl_Acl_AclSets_AclSet_Key{
		Name: Name,
		Type: Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclSet", key)
	}

	t.AclSet[key] = &OpenconfigAcl_Acl_AclSets_AclSet{
		Name: &Name,
		Type: Type,
	}

	return t.AclSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigAcl_Acl_AclSets_AclSet represents the /openconfig-acl/acl/acl-sets/acl-set YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet struct {
	AclEntries *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries `path:"acl-entries" module:"openconfig-acl"`
	Config     *OpenconfigAcl_Acl_AclSets_AclSet_Config     `path:"config" module:"openconfig-acl"`
	Name       *string                                      `path:"name" module:"openconfig-acl"`
	State      *OpenconfigAcl_Acl_AclSets_AclSet_State      `path:"state" module:"openconfig-acl"`
	Type       E_OpenconfigAcl_ACL_TYPE                     `path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_AclSets_AclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
		"type": t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries struct {
	AclEntry map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry `path:"acl-entry" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) IsYANGGoStruct() {}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry struct {
	Actions        *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions        `path:"actions" module:"openconfig-acl"`
	Config         *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config         `path:"config" module:"openconfig-acl"`
	InputInterface *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface `path:"input-interface" module:"openconfig-acl"`
	Ipv4           *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4           `path:"ipv4" module:"openconfig-acl"`
	Ipv6           *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6           `path:"ipv6" module:"openconfig-acl"`
	L2             *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2             `path:"l2" module:"openconfig-acl"`
	SequenceId     *uint32                                                              `path:"sequence-id" module:"openconfig-acl"`
	State          *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State          `path:"state" module:"openconfig-acl"`
	Transport      *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport      `path:"transport" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions struct {
	Config *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config `path:"config" module:"openconfig-acl"`
	State  *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State  `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config struct {
	ForwardingAction E_OpenconfigAcl_FORWARDING_ACTION `path:"forwarding-action" module:"openconfig-acl"`
	LogAction        E_OpenconfigAcl_LOG_ACTION        `path:"log-action" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State struct {
	ForwardingAction E_OpenconfigAcl_FORWARDING_ACTION `path:"forwarding-action" module:"openconfig-acl"`
	LogAction        E_OpenconfigAcl_LOG_ACTION        `path:"log-action" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Actions_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config struct {
	Description *string `path:"description" module:"openconfig-acl"`
	SequenceId  *uint32 `path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface struct {
	Config       *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config       `path:"config" module:"openconfig-acl"`
	InterfaceRef *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef `path:"interface-ref" module:"openconfig-acl"`
	State        *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State        `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef struct {
	Config *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config `path:"config" module:"openconfig-acl"`
	State  *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State  `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config struct {
	Interface    *string `path:"interface" module:"openconfig-acl"`
	Subinterface *uint32 `path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State struct {
	Interface    *string `path:"interface" module:"openconfig-acl"`
	Subinterface *uint32 `path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State struct {
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_InputInterface_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 struct {
	Config *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config `path:"config" module:"openconfig-acl"`
	State  *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State  `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config struct {
	DestinationAddress *string                                                                         `path:"destination-address" module:"openconfig-acl"`
	Dscp               *uint8                                                                          `path:"dscp" module:"openconfig-acl"`
	HopLimit           *uint8                                                                          `path:"hop-limit" module:"openconfig-acl"`
	Protocol           OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union `path:"protocol" module:"openconfig-acl"`
	SourceAddress      *string                                                                         `path:"source-address" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol within the YANG schema.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface {
	Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union()
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol
// is to be set to a E_OpenconfigPacketMatchTypes_IP_PROTOCOL value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL struct {
	E_OpenconfigPacketMatchTypes_IP_PROTOCOL E_OpenconfigPacketMatchTypes_IP_PROTOCOL
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union_Uint8 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol
// is to be set to a uint8 value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union_Uint8 struct {
	Uint8 uint8
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union_Uint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union_Uint8) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPacketMatchTypes_IP_PROTOCOL:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL{v}, nil
	case uint8:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union_Uint8{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_Config_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
	}
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State struct {
	DestinationAddress *string                                                                        `path:"destination-address" module:"openconfig-acl"`
	Dscp               *uint8                                                                         `path:"dscp" module:"openconfig-acl"`
	HopLimit           *uint8                                                                         `path:"hop-limit" module:"openconfig-acl"`
	Protocol           OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union `path:"protocol" module:"openconfig-acl"`
	SourceAddress      *string                                                                        `path:"source-address" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state/protocol within the YANG schema.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface {
	Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union()
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state/protocol
// is to be set to a E_OpenconfigPacketMatchTypes_IP_PROTOCOL value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL struct {
	E_OpenconfigPacketMatchTypes_IP_PROTOCOL E_OpenconfigPacketMatchTypes_IP_PROTOCOL
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union_Uint8 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state/protocol
// is to be set to a uint8 value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union_Uint8 struct {
	Uint8 uint8
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union_Uint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union_Uint8) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPacketMatchTypes_IP_PROTOCOL:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL{v}, nil
	case uint8:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union_Uint8{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv4_State_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
	}
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 struct {
	Config *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config `path:"config" module:"openconfig-acl"`
	State  *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State  `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config struct {
	DestinationAddress   *string                                                                         `path:"destination-address" module:"openconfig-acl"`
	DestinationFlowLabel *uint32                                                                         `path:"destination-flow-label" module:"openconfig-acl"`
	Dscp                 *uint8                                                                          `path:"dscp" module:"openconfig-acl"`
	HopLimit             *uint8                                                                          `path:"hop-limit" module:"openconfig-acl"`
	Protocol             OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union `path:"protocol" module:"openconfig-acl"`
	SourceAddress        *string                                                                         `path:"source-address" module:"openconfig-acl"`
	SourceFlowLabel      *uint32                                                                         `path:"source-flow-label" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol within the YANG schema.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface {
	Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union()
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol
// is to be set to a E_OpenconfigPacketMatchTypes_IP_PROTOCOL value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL struct {
	E_OpenconfigPacketMatchTypes_IP_PROTOCOL E_OpenconfigPacketMatchTypes_IP_PROTOCOL
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union_Uint8 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol
// is to be set to a uint8 value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union_Uint8 struct {
	Uint8 uint8
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union_Uint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union_Uint8) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPacketMatchTypes_IP_PROTOCOL:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL{v}, nil
	case uint8:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union_Uint8{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_Config_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
	}
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State struct {
	DestinationAddress   *string                                                                        `path:"destination-address" module:"openconfig-acl"`
	DestinationFlowLabel *uint32                                                                        `path:"destination-flow-label" module:"openconfig-acl"`
	Dscp                 *uint8                                                                         `path:"dscp" module:"openconfig-acl"`
	HopLimit             *uint8                                                                         `path:"hop-limit" module:"openconfig-acl"`
	Protocol             OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union `path:"protocol" module:"openconfig-acl"`
	SourceAddress        *string                                                                        `path:"source-address" module:"openconfig-acl"`
	SourceFlowLabel      *uint32                                                                        `path:"source-flow-label" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state/protocol within the YANG schema.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface {
	Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union()
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state/protocol
// is to be set to a E_OpenconfigPacketMatchTypes_IP_PROTOCOL value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL struct {
	E_OpenconfigPacketMatchTypes_IP_PROTOCOL E_OpenconfigPacketMatchTypes_IP_PROTOCOL
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union_Uint8 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state/protocol
// is to be set to a uint8 value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union_Uint8 struct {
	Uint8 uint8
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union_Uint8
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union_Uint8) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPacketMatchTypes_IP_PROTOCOL:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union_E_OpenconfigPacketMatchTypes_IP_PROTOCOL{v}, nil
	case uint8:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union_Uint8{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Ipv6_State_Protocol_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_IP_PROTOCOL, uint8]", i, i)
	}
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2 YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 struct {
	Config *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config `path:"config" module:"openconfig-acl"`
	State  *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State  `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config struct {
	DestinationMac     *string                                                                        `path:"destination-mac" module:"openconfig-acl"`
	DestinationMacMask *string                                                                        `path:"destination-mac-mask" module:"openconfig-acl"`
	Ethertype          OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union `path:"ethertype" module:"openconfig-acl"`
	SourceMac          *string                                                                        `path:"source-mac" module:"openconfig-acl"`
	SourceMacMask      *string                                                                        `path:"source-mac-mask" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype within the YANG schema.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface {
	Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union()
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union_E_OpenconfigPacketMatchTypes_ETHERTYPE is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype
// is to be set to a E_OpenconfigPacketMatchTypes_ETHERTYPE value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union_E_OpenconfigPacketMatchTypes_ETHERTYPE struct {
	E_OpenconfigPacketMatchTypes_ETHERTYPE E_OpenconfigPacketMatchTypes_ETHERTYPE
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union_E_OpenconfigPacketMatchTypes_ETHERTYPE
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union_E_OpenconfigPacketMatchTypes_ETHERTYPE) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union_Uint16 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype
// is to be set to a uint16 value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union_Uint16 struct {
	Uint16 uint16
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union_Uint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union_Uint16) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPacketMatchTypes_ETHERTYPE:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union_E_OpenconfigPacketMatchTypes_ETHERTYPE{v}, nil
	case uint16:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union_Uint16{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_Config_Ethertype_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_ETHERTYPE, uint16]", i, i)
	}
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State struct {
	DestinationMac     *string                                                                       `path:"destination-mac" module:"openconfig-acl"`
	DestinationMacMask *string                                                                       `path:"destination-mac-mask" module:"openconfig-acl"`
	Ethertype          OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union `path:"ethertype" module:"openconfig-acl"`
	SourceMac          *string                                                                       `path:"source-mac" module:"openconfig-acl"`
	SourceMacMask      *string                                                                       `path:"source-mac-mask" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state/ethertype within the YANG schema.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface {
	Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union()
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union_E_OpenconfigPacketMatchTypes_ETHERTYPE is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state/ethertype
// is to be set to a E_OpenconfigPacketMatchTypes_ETHERTYPE value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union_E_OpenconfigPacketMatchTypes_ETHERTYPE struct {
	E_OpenconfigPacketMatchTypes_ETHERTYPE E_OpenconfigPacketMatchTypes_ETHERTYPE
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union_E_OpenconfigPacketMatchTypes_ETHERTYPE
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union_E_OpenconfigPacketMatchTypes_ETHERTYPE) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union_Uint16 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state/ethertype
// is to be set to a uint16 value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union_Uint16 struct {
	Uint16 uint16
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union_Uint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union_Uint16) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPacketMatchTypes_ETHERTYPE:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union_E_OpenconfigPacketMatchTypes_ETHERTYPE{v}, nil
	case uint16:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union_Uint16{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_L2_State_Ethertype_Union, unknown union type, got: %T, want any of [E_OpenconfigPacketMatchTypes_ETHERTYPE, uint16]", i, i)
	}
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State struct {
	Description    *string `path:"description" module:"openconfig-acl"`
	MatchedOctets  *uint64 `path:"matched-octets" module:"openconfig-acl"`
	MatchedPackets *uint64 `path:"matched-packets" module:"openconfig-acl"`
	SequenceId     *uint32 `path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport struct {
	Config *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config `path:"config" module:"openconfig-acl"`
	State  *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State  `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config struct {
	DestinationPort OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union `path:"destination-port" module:"openconfig-acl"`
	SourcePort      OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union      `path:"source-port" module:"openconfig-acl"`
	TcpFlags        []E_OpenconfigPacketMatchTypes_TCP_FLAGS                                                    `path:"tcp-flags" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port within the YANG schema.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface {
	Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union()
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port
// is to be set to a E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort struct {
	E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_String is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port
// is to be set to a string value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_String struct {
	String string
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_String
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_String) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_Uint16 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port
// is to be set to a uint16 value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_Uint16 struct {
	Uint16 uint16
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_Uint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_Uint16) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort{v}, nil
	case string:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_String{v}, nil
	case uint16:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union_Uint16{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, string, uint16]", i, i)
	}
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port within the YANG schema.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface {
	Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union()
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port
// is to be set to a E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort struct {
	E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_String is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port
// is to be set to a string value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_String struct {
	String string
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_String
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_String) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_Uint16 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port
// is to be set to a uint16 value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_Uint16 struct {
	Uint16 uint16
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_Uint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_Uint16) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort{v}, nil
	case string:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_String{v}, nil
	case uint16:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union_Uint16{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, string, uint16]", i, i)
	}
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State struct {
	DestinationPort OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union `path:"destination-port" module:"openconfig-acl"`
	SourcePort      OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union      `path:"source-port" module:"openconfig-acl"`
	TcpFlags        []E_OpenconfigPacketMatchTypes_TCP_FLAGS                                                   `path:"tcp-flags" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/destination-port within the YANG schema.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface {
	Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union()
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/destination-port
// is to be set to a E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort struct {
	E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_String is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/destination-port
// is to be set to a string value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_String struct {
	String string
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_String
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_String) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_Uint16 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/destination-port
// is to be set to a uint16 value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_Uint16 struct {
	Uint16 uint16
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_Uint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_Uint16) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort{v}, nil
	case string:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_String{v}, nil
	case uint16:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union_Uint16{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_DestinationPort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_DestinationPort, string, uint16]", i, i)
	}
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/source-port within the YANG schema.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface {
	Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union()
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/source-port
// is to be set to a E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort struct {
	E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_String is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/source-port
// is to be set to a string value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_String struct {
	String string
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_String
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_String) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {
}

// OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_Uint16 is used when /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state/source-port
// is to be set to a uint16 value.
type OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_Uint16 struct {
	Uint16 uint16
}

// Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union ensures that OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_Uint16
// implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union interface.
func (*OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_Uint16) Is_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union() {
}

// To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State) To_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union(i interface{}) (OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort{v}, nil
	case string:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_String{v}, nil
	case uint16:
		return &OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union_Uint16{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_State_SourcePort_Union, unknown union type, got: %T, want any of [E_OpenconfigAcl_Acl_AclSets_AclSet_AclEntries_AclEntry_Transport_Config_SourcePort, string, uint16]", i, i)
	}
}

// OpenconfigAcl_Acl_AclSets_AclSet_Config represents the /openconfig-acl/acl/acl-sets/acl-set/config YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_Config struct {
	Description *string                  `path:"description" module:"openconfig-acl"`
	Name        *string                  `path:"name" module:"openconfig-acl"`
	Type        E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_AclSets_AclSet_State represents the /openconfig-acl/acl/acl-sets/acl-set/state YANG schema element.
type OpenconfigAcl_Acl_AclSets_AclSet_State struct {
	Description *string                  `path:"description" module:"openconfig-acl"`
	Name        *string                  `path:"name" module:"openconfig-acl"`
	Type        E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_AclSets_AclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_AclSets_AclSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_AclSets_AclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_AclSets_AclSet_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Config represents the /openconfig-acl/acl/config YANG schema element.
type OpenconfigAcl_Acl_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigAcl_Acl_Interfaces represents the /openconfig-acl/acl/interfaces YANG schema element.
type OpenconfigAcl_Acl_Interfaces struct {
	Interface map[string]*OpenconfigAcl_Acl_Interfaces_Interface `path:"interface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigAcl_Acl_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces) NewInterface(Id string) (*OpenconfigAcl_Acl_Interfaces_Interface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigAcl_Acl_Interfaces_Interface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigAcl_Acl_Interfaces_Interface{
		Id: &Id,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigAcl_Acl_Interfaces_Interface represents the /openconfig-acl/acl/interfaces/interface YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface struct {
	Config         *OpenconfigAcl_Acl_Interfaces_Interface_Config         `path:"config" module:"openconfig-acl"`
	EgressAclSets  *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets  `path:"egress-acl-sets" module:"openconfig-acl"`
	Id             *string                                                `path:"id" module:"openconfig-acl"`
	IngressAclSets *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets `path:"ingress-acl-sets" module:"openconfig-acl"`
	InterfaceRef   *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef   `path:"interface-ref" module:"openconfig-acl"`
	State          *OpenconfigAcl_Acl_Interfaces_Interface_State          `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_Config represents the /openconfig-acl/acl/interfaces/interface/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_Config struct {
	Id *string `path:"id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets struct {
	EgressAclSet map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet `path:"egress-acl-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key represents the key for list EgressAclSet of element /openconfig-acl/acl/interfaces/interface/egress-acl-sets.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key struct {
	SetName string                   `path:"set-name"`
	Type    E_OpenconfigAcl_ACL_TYPE `path:"type"`
}

// NewEgressAclSet creates a new entry in the EgressAclSet list of the
// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) NewEgressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.EgressAclSet == nil {
		t.EgressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet)
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.EgressAclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list EgressAclSet", key)
	}

	t.EgressAclSet[key] = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet{
		SetName: &SetName,
		Type:    Type,
	}

	return t.EgressAclSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet struct {
	AclEntries *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries `path:"acl-entries" module:"openconfig-acl"`
	Config     *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config     `path:"config" module:"openconfig-acl"`
	SetName    *string                                                                       `path:"set-name" module:"openconfig-acl"`
	State      *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State      `path:"state" module:"openconfig-acl"`
	Type       E_OpenconfigAcl_ACL_TYPE                                                      `path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SetName == nil {
		return nil, fmt.Errorf("nil value for key SetName")
	}

	return map[string]interface{}{
		"set-name": *t.SetName,
		"type":     t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries struct {
	AclEntry map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry `path:"acl-entry" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) IsYANGGoStruct() {
}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry struct {
	SequenceId *uint32                                                                                      `path:"sequence-id" module:"openconfig-acl"`
	State      *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State struct {
	MatchedOctets  *uint64 `path:"matched-octets" module:"openconfig-acl"`
	MatchedPackets *uint64 `path:"matched-packets" module:"openconfig-acl"`
	SequenceId     *uint32 `path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config struct {
	SetName *string                  `path:"set-name" module:"openconfig-acl"`
	Type    E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State struct {
	SetName *string                  `path:"set-name" module:"openconfig-acl"`
	Type    E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_EgressAclSets_EgressAclSet_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets struct {
	IngressAclSet map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet `path:"ingress-acl-set" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) IsYANGGoStruct() {}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key represents the key for list IngressAclSet of element /openconfig-acl/acl/interfaces/interface/ingress-acl-sets.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key struct {
	SetName string                   `path:"set-name"`
	Type    E_OpenconfigAcl_ACL_TYPE `path:"type"`
}

// NewIngressAclSet creates a new entry in the IngressAclSet list of the
// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) NewIngressAclSet(SetName string, Type E_OpenconfigAcl_ACL_TYPE) (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.IngressAclSet == nil {
		t.IngressAclSet = make(map[OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet)
	}

	key := OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Key{
		SetName: SetName,
		Type:    Type,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.IngressAclSet[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list IngressAclSet", key)
	}

	t.IngressAclSet[key] = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet{
		SetName: &SetName,
		Type:    Type,
	}

	return t.IngressAclSet[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet struct {
	AclEntries *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries `path:"acl-entries" module:"openconfig-acl"`
	Config     *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config     `path:"config" module:"openconfig-acl"`
	SetName    *string                                                                         `path:"set-name" module:"openconfig-acl"`
	State      *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State      `path:"state" module:"openconfig-acl"`
	Type       E_OpenconfigAcl_ACL_TYPE                                                        `path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SetName == nil {
		return nil, fmt.Errorf("nil value for key SetName")
	}

	return map[string]interface{}{
		"set-name": *t.SetName,
		"type":     t.Type,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries struct {
	AclEntry map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry `path:"acl-entry" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) IsYANGGoStruct() {
}

// NewAclEntry creates a new entry in the AclEntry list of the
// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) NewAclEntry(SequenceId uint32) (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AclEntry == nil {
		t.AclEntry = make(map[uint32]*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry)
	}

	key := SequenceId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AclEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AclEntry", key)
	}

	t.AclEntry[key] = &OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry{
		SequenceId: &SequenceId,
	}

	return t.AclEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry struct {
	SequenceId *uint32                                                                                        `path:"sequence-id" module:"openconfig-acl"`
	State      *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry struct, which is a YANG list entry.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.SequenceId == nil {
		return nil, fmt.Errorf("nil value for key SequenceId")
	}

	return map[string]interface{}{
		"sequence-id": *t.SequenceId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State struct {
	MatchedOctets  *uint64 `path:"matched-octets" module:"openconfig-acl"`
	MatchedPackets *uint64 `path:"matched-packets" module:"openconfig-acl"`
	SequenceId     *uint32 `path:"sequence-id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_AclEntries_AclEntry_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config struct {
	SetName *string                  `path:"set-name" module:"openconfig-acl"`
	Type    E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State struct {
	SetName *string                  `path:"set-name" module:"openconfig-acl"`
	Type    E_OpenconfigAcl_ACL_TYPE `path:"type" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_IngressAclSets_IngressAclSet_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef represents the /openconfig-acl/acl/interfaces/interface/interface-ref YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef struct {
	Config *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config `path:"config" module:"openconfig-acl"`
	State  *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State  `path:"state" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config represents the /openconfig-acl/acl/interfaces/interface/interface-ref/config YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config struct {
	Interface    *string `path:"interface" module:"openconfig-acl"`
	Subinterface *uint32 `path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State represents the /openconfig-acl/acl/interfaces/interface/interface-ref/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State struct {
	Interface    *string `path:"interface" module:"openconfig-acl"`
	Subinterface *uint32 `path:"subinterface" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_Interfaces_Interface_State represents the /openconfig-acl/acl/interfaces/interface/state YANG schema element.
type OpenconfigAcl_Acl_Interfaces_Interface_State struct {
	Id *string `path:"id" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigAcl_Acl_State represents the /openconfig-acl/acl/state YANG schema element.
type OpenconfigAcl_Acl_State struct {
	CounterCapability E_OpenconfigAcl_ACL_COUNTER_CAPABILITY `path:"counter-capability" module:"openconfig-acl"`
}

// IsYANGGoStruct ensures that OpenconfigAcl_Acl_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigAcl_Acl_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigAcl_Acl_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigAcl_Acl_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigAcl_Acl_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigBfd_Bfd represents the /openconfig-bfd/bfd YANG schema element.
type OpenconfigBfd_Bfd struct {
	Interfaces *OpenconfigBfd_Bfd_Interfaces `path:"interfaces" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigBfd_Bfd_Interfaces represents the /openconfig-bfd/bfd/interfaces YANG schema element.
type OpenconfigBfd_Bfd_Interfaces struct {
	Interface map[string]*OpenconfigBfd_Bfd_Interfaces_Interface `path:"interface" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces) IsYANGGoStruct() {}

// NewInterface creates a new entry in the Interface list of the
// OpenconfigBfd_Bfd_Interfaces struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces) NewInterface(Id string) (*OpenconfigBfd_Bfd_Interfaces_Interface, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Interface == nil {
		t.Interface = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Interface[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Interface", key)
	}

	t.Interface[key] = &OpenconfigBfd_Bfd_Interfaces_Interface{
		Id: &Id,
	}

	return t.Interface[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigBfd_Bfd_Interfaces_Interface represents the /openconfig-bfd/bfd/interfaces/interface YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface struct {
	Config           *OpenconfigBfd_Bfd_Interfaces_Interface_Config           `path:"config" module:"openconfig-bfd"`
	Id               *string                                                  `path:"id" module:"openconfig-bfd"`
	InterfaceRef     *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef     `path:"interface-ref" module:"openconfig-bfd"`
	MicroBfdSessions *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions `path:"micro-bfd-sessions" module:"openconfig-bfd"`
	Peers            *OpenconfigBfd_Bfd_Interfaces_Interface_Peers            `path:"peers" module:"openconfig-bfd"`
	State            *OpenconfigBfd_Bfd_Interfaces_Interface_State            `path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Config represents the /openconfig-bfd/bfd/interfaces/interface/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Config struct {
	DesiredMinimumTxInterval *uint32 `path:"desired-minimum-tx-interval" module:"openconfig-bfd"`
	DetectionMultiplier      *uint8  `path:"detection-multiplier" module:"openconfig-bfd"`
	EnablePerMemberLink      *bool   `path:"enable-per-member-link" module:"openconfig-bfd"`
	Enabled                  *bool   `path:"enabled" module:"openconfig-bfd"`
	Id                       *string `path:"id" module:"openconfig-bfd"`
	LocalAddress             *string `path:"local-address" module:"openconfig-bfd"`
	RequiredMinimumReceive   *uint32 `path:"required-minimum-receive" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef struct {
	Config *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config `path:"config" module:"openconfig-bfd"`
	State  *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State  `path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config struct {
	Interface    *string `path:"interface" module:"openconfig-bfd"`
	Subinterface *uint32 `path:"subinterface" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State struct {
	Interface    *string `path:"interface" module:"openconfig-bfd"`
	Subinterface *uint32 `path:"subinterface" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_InterfaceRef_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions struct {
	MicroBfdSession map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession `path:"micro-bfd-session" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) IsYANGGoStruct() {}

// NewMicroBfdSession creates a new entry in the MicroBfdSession list of the
// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) NewMicroBfdSession(MemberInterface string) (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.MicroBfdSession == nil {
		t.MicroBfdSession = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession)
	}

	key := MemberInterface

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.MicroBfdSession[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list MicroBfdSession", key)
	}

	t.MicroBfdSession[key] = &OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession{
		MemberInterface: &MemberInterface,
	}

	return t.MicroBfdSession[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession struct {
	Config          *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config `path:"config" module:"openconfig-bfd"`
	MemberInterface *string                                                                         `path:"member-interface" module:"openconfig-bfd"`
	State           *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State  `path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛListKeyMap() (map[string]interface{}, error) {
	if t.MemberInterface == nil {
		return nil, fmt.Errorf("nil value for key MemberInterface")
	}

	return map[string]interface{}{
		"member-interface": *t.MemberInterface,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config struct {
	LocalAddress    *string `path:"local-address" module:"openconfig-bfd"`
	MemberInterface *string `path:"member-interface" module:"openconfig-bfd"`
	RemoteAddress   *string `path:"remote-address" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State struct {
	Async                         *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async `path:"async" module:"openconfig-bfd"`
	DemandModeRequested           *bool                                                                                `path:"demand-mode-requested" module:"openconfig-bfd"`
	FailureTransitions            *uint64                                                                              `path:"failure-transitions" module:"openconfig-bfd"`
	LastFailureTime               *uint64                                                                              `path:"last-failure-time" module:"openconfig-bfd"`
	LocalAddress                  *string                                                                              `path:"local-address" module:"openconfig-bfd"`
	LocalDiagnosticCode           E_OpenconfigBfd_BfdDiagnosticCode                                                    `path:"local-diagnostic-code" module:"openconfig-bfd"`
	LocalDiscriminator            *string                                                                              `path:"local-discriminator" module:"openconfig-bfd"`
	MemberInterface               *string                                                                              `path:"member-interface" module:"openconfig-bfd"`
	RemoteAddress                 *string                                                                              `path:"remote-address" module:"openconfig-bfd"`
	RemoteAuthenticationEnabled   *bool                                                                                `path:"remote-authentication-enabled" module:"openconfig-bfd"`
	RemoteControlPlaneIndependent *bool                                                                                `path:"remote-control-plane-independent" module:"openconfig-bfd"`
	RemoteDiagnosticCode          E_OpenconfigBfd_BfdDiagnosticCode                                                    `path:"remote-diagnostic-code" module:"openconfig-bfd"`
	RemoteDiscriminator           *string                                                                              `path:"remote-discriminator" module:"openconfig-bfd"`
	RemoteMinimumReceiveInterval  *uint32                                                                              `path:"remote-minimum-receive-interval" module:"openconfig-bfd"`
	RemoteSessionState            E_OpenconfigBfd_BfdSessionState                                                      `path:"remote-session-state" module:"openconfig-bfd"`
	SessionState                  E_OpenconfigBfd_BfdSessionState                                                      `path:"session-state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async struct {
	LastPacketReceived    *uint64 `path:"last-packet-received" module:"openconfig-bfd"`
	LastPacketTransmitted *uint64 `path:"last-packet-transmitted" module:"openconfig-bfd"`
	ReceivedPackets       *uint64 `path:"received-packets" module:"openconfig-bfd"`
	TransmittedPackets    *uint64 `path:"transmitted-packets" module:"openconfig-bfd"`
	UpTransitions         *uint64 `path:"up-transitions" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_MicroBfdSessions_MicroBfdSession_State_Async) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Peers represents the /openconfig-bfd/bfd/interfaces/interface/peers YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers struct {
	Peer map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer `path:"peer" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers) IsYANGGoStruct() {}

// NewPeer creates a new entry in the Peer list of the
// OpenconfigBfd_Bfd_Interfaces_Interface_Peers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) NewPeer(LocalDiscriminator string) (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Peer == nil {
		t.Peer = make(map[string]*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer)
	}

	key := LocalDiscriminator

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Peer[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Peer", key)
	}

	t.Peer[key] = &OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer{
		LocalDiscriminator: &LocalDiscriminator,
	}

	return t.Peer[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer struct {
	LocalDiscriminator *string                                                  `path:"local-discriminator" module:"openconfig-bfd"`
	State              *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State `path:"state" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer struct, which is a YANG list entry.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛListKeyMap() (map[string]interface{}, error) {
	if t.LocalDiscriminator == nil {
		return nil, fmt.Errorf("nil value for key LocalDiscriminator")
	}

	return map[string]interface{}{
		"local-discriminator": *t.LocalDiscriminator,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State struct {
	Async                         *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async `path:"async" module:"openconfig-bfd"`
	DemandModeRequested           *bool                                                          `path:"demand-mode-requested" module:"openconfig-bfd"`
	Echo                          *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo  `path:"echo" module:"openconfig-bfd"`
	FailureTransitions            *uint64                                                        `path:"failure-transitions" module:"openconfig-bfd"`
	LastFailureTime               *uint64                                                        `path:"last-failure-time" module:"openconfig-bfd"`
	LocalAddress                  *string                                                        `path:"local-address" module:"openconfig-bfd"`
	LocalDiagnosticCode           E_OpenconfigBfd_BfdDiagnosticCode                              `path:"local-diagnostic-code" module:"openconfig-bfd"`
	LocalDiscriminator            *string                                                        `path:"local-discriminator" module:"openconfig-bfd"`
	RemoteAddress                 *string                                                        `path:"remote-address" module:"openconfig-bfd"`
	RemoteAuthenticationEnabled   *bool                                                          `path:"remote-authentication-enabled" module:"openconfig-bfd"`
	RemoteControlPlaneIndependent *bool                                                          `path:"remote-control-plane-independent" module:"openconfig-bfd"`
	RemoteDiagnosticCode          E_OpenconfigBfd_BfdDiagnosticCode                              `path:"remote-diagnostic-code" module:"openconfig-bfd"`
	RemoteDiscriminator           *string                                                        `path:"remote-discriminator" module:"openconfig-bfd"`
	RemoteMinimumReceiveInterval  *uint32                                                        `path:"remote-minimum-receive-interval" module:"openconfig-bfd"`
	RemoteSessionState            E_OpenconfigBfd_BfdSessionState                                `path:"remote-session-state" module:"openconfig-bfd"`
	SessionState                  E_OpenconfigBfd_BfdSessionState                                `path:"session-state" module:"openconfig-bfd"`
	SubscribedProtocols           []E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE                `path:"subscribed-protocols" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async struct {
	LastPacketReceived    *uint64 `path:"last-packet-received" module:"openconfig-bfd"`
	LastPacketTransmitted *uint64 `path:"last-packet-transmitted" module:"openconfig-bfd"`
	ReceivedPackets       *uint64 `path:"received-packets" module:"openconfig-bfd"`
	TransmittedPackets    *uint64 `path:"transmitted-packets" module:"openconfig-bfd"`
	UpTransitions         *uint64 `path:"up-transitions" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Async) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo struct {
	Active                *bool   `path:"active" module:"openconfig-bfd"`
	LastPacketReceived    *uint64 `path:"last-packet-received" module:"openconfig-bfd"`
	LastPacketTransmitted *uint64 `path:"last-packet-transmitted" module:"openconfig-bfd"`
	ReceivedPackets       *uint64 `path:"received-packets" module:"openconfig-bfd"`
	TransmittedPackets    *uint64 `path:"transmitted-packets" module:"openconfig-bfd"`
	UpTransitions         *uint64 `path:"up-transitions" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_Peers_Peer_State_Echo) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBfd_Bfd_Interfaces_Interface_State represents the /openconfig-bfd/bfd/interfaces/interface/state YANG schema element.
type OpenconfigBfd_Bfd_Interfaces_Interface_State struct {
	DesiredMinimumTxInterval *uint32 `path:"desired-minimum-tx-interval" module:"openconfig-bfd"`
	DetectionMultiplier      *uint8  `path:"detection-multiplier" module:"openconfig-bfd"`
	EnablePerMemberLink      *bool   `path:"enable-per-member-link" module:"openconfig-bfd"`
	Enabled                  *bool   `path:"enabled" module:"openconfig-bfd"`
	Id                       *string `path:"id" module:"openconfig-bfd"`
	LocalAddress             *string `path:"local-address" module:"openconfig-bfd"`
	RequiredMinimumReceive   *uint32 `path:"required-minimum-receive" module:"openconfig-bfd"`
}

// IsYANGGoStruct ensures that OpenconfigBfd_Bfd_Interfaces_Interface_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBfd_Bfd_Interfaces_Interface_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBfd_Bfd_Interfaces_Interface_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBfd_Bfd_Interfaces_Interface_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp represents the /openconfig-bgp/bgp YANG schema element.
type OpenconfigBgp_Bgp struct {
	Global     *OpenconfigBgp_Bgp_Global     `path:"global" module:"openconfig-bgp"`
	Neighbors  *OpenconfigBgp_Bgp_Neighbors  `path:"neighbors" module:"openconfig-bgp"`
	PeerGroups *OpenconfigBgp_Bgp_PeerGroups `path:"peer-groups" module:"openconfig-bgp"`
	Rib        *OpenconfigBgp_Bgp_Rib        `path:"rib" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigBgp_Bgp_Global represents the /openconfig-bgp/bgp/global YANG schema element.
type OpenconfigBgp_Bgp_Global struct {
	AfiSafis                *OpenconfigBgp_Bgp_Global_AfiSafis                `path:"afi-safis" module:"openconfig-bgp"`
	Confederation           *OpenconfigBgp_Bgp_Global_Confederation           `path:"confederation" module:"openconfig-bgp"`
	Config                  *OpenconfigBgp_Bgp_Global_Config                  `path:"config" module:"openconfig-bgp"`
	DefaultRouteDistance    *OpenconfigBgp_Bgp_Global_DefaultRouteDistance    `path:"default-route-distance" module:"openconfig-bgp"`
	DynamicNeighborPrefixes *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes `path:"dynamic-neighbor-prefixes" module:"openconfig-bgp"`
	GracefulRestart         *OpenconfigBgp_Bgp_Global_GracefulRestart         `path:"graceful-restart" module:"openconfig-bgp"`
	RouteSelectionOptions   *OpenconfigBgp_Bgp_Global_RouteSelectionOptions   `path:"route-selection-options" module:"openconfig-bgp"`
	State                   *OpenconfigBgp_Bgp_Global_State                   `path:"state" module:"openconfig-bgp"`
	UseMultiplePaths        *OpenconfigBgp_Bgp_Global_UseMultiplePaths        `path:"use-multiple-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigBgp_Bgp_Global_AfiSafis represents the /openconfig-bgp/bgp/global/afi-safis YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis struct {
	AfiSafi map[E_OpenconfigBgpTypes_AFI_SAFI_TYPE]*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi `path:"afi-safi" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis) IsYANGGoStruct() {}

// NewAfiSafi creates a new entry in the AfiSafi list of the
// OpenconfigBgp_Bgp_Global_AfiSafis struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis) NewAfiSafi(AfiSafiName E_OpenconfigBgpTypes_AFI_SAFI_TYPE) (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AfiSafi == nil {
		t.AfiSafi = make(map[E_OpenconfigBgpTypes_AFI_SAFI_TYPE]*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi)
	}

	key := AfiSafiName

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AfiSafi[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AfiSafi", key)
	}

	t.AfiSafi[key] = &OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi{
		AfiSafiName: AfiSafiName,
	}

	return t.AfiSafi[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi struct {
	AddPaths              *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths              `path:"add-paths" module:"openconfig-bgp"`
	AfiSafiName           E_OpenconfigBgpTypes_AFI_SAFI_TYPE                               `path:"afi-safi-name" module:"openconfig-bgp"`
	Config                *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Config                `path:"config" module:"openconfig-bgp"`
	GracefulRestart       *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart       `path:"graceful-restart" module:"openconfig-bgp"`
	Ipv4LabeledUnicast    *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast    `path:"ipv4-labeled-unicast" module:"openconfig-bgp"`
	Ipv4Unicast           *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast           `path:"ipv4-unicast" module:"openconfig-bgp"`
	Ipv6LabeledUnicast    *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast    `path:"ipv6-labeled-unicast" module:"openconfig-bgp"`
	Ipv6Unicast           *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast           `path:"ipv6-unicast" module:"openconfig-bgp"`
	L2VpnEvpn             *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn             `path:"l2vpn-evpn" module:"openconfig-bgp"`
	L2VpnVpls             *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls             `path:"l2vpn-vpls" module:"openconfig-bgp"`
	L3VpnIpv4Multicast    *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast    `path:"l3vpn-ipv4-multicast" module:"openconfig-bgp"`
	L3VpnIpv4Unicast      *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast      `path:"l3vpn-ipv4-unicast" module:"openconfig-bgp"`
	L3VpnIpv6Multicast    *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast    `path:"l3vpn-ipv6-multicast" module:"openconfig-bgp"`
	L3VpnIpv6Unicast      *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast      `path:"l3vpn-ipv6-unicast" module:"openconfig-bgp"`
	RouteSelectionOptions *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions `path:"route-selection-options" module:"openconfig-bgp"`
	SrtePolicyIpv4        *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4        `path:"srte-policy-ipv4" module:"openconfig-bgp"`
	SrtePolicyIpv6        *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6        `path:"srte-policy-ipv6" module:"openconfig-bgp"`
	State                 *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_State                 `path:"state" module:"openconfig-bgp"`
	UseMultiplePaths      *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths      `path:"use-multiple-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"afi-safi-name": t.AfiSafiName,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/add-paths YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/add-paths/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_Config struct {
	EligiblePrefixPolicy *string `path:"eligible-prefix-policy" module:"openconfig-bgp"`
	Receive              *bool   `path:"receive" module:"openconfig-bgp"`
	Send                 *bool   `path:"send" module:"openconfig-bgp"`
	SendMax              *uint8  `path:"send-max" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/add-paths/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_State struct {
	EligiblePrefixPolicy *string `path:"eligible-prefix-policy" module:"openconfig-bgp"`
	Receive              *bool   `path:"receive" module:"openconfig-bgp"`
	Send                 *bool   `path:"send" module:"openconfig-bgp"`
	SendMax              *uint8  `path:"send-max" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_AddPaths_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Config struct {
	AfiSafiName E_OpenconfigBgpTypes_AFI_SAFI_TYPE `path:"afi-safi-name" module:"openconfig-bgp"`
	Enabled     *bool                              `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/graceful-restart YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/graceful-restart/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/graceful-restart/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_State struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_GracefulRestart_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv4-labeled-unicast YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv4-labeled-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv4-labeled-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv4-labeled-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv4-unicast YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast struct {
	Config      *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_Config      `path:"config" module:"openconfig-bgp"`
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
	State       *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_State       `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv4-unicast/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_Config struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv4-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv4-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv4-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv4-unicast/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_State struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv4Unicast_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv6-labeled-unicast YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv6-labeled-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv6-labeled-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv6-labeled-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv6-unicast YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast struct {
	Config      *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_Config      `path:"config" module:"openconfig-bgp"`
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
	State       *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_State       `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv6-unicast/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_Config struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv6-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv6-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv6-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/ipv6-unicast/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_State struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_Ipv6Unicast_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l2vpn-evpn YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn struct {
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l2vpn-evpn/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l2vpn-evpn/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l2vpn-evpn/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l2vpn-vpls YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls struct {
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l2vpn-vpls/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l2vpn-vpls/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l2vpn-vpls/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv4-multicast YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv4-multicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv4-multicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv4-multicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv4-unicast YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv4-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv4-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv4-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv6-multicast YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv6-multicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv6-multicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv6-multicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv6-unicast YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv6-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv6-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/l3vpn-ipv6-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/route-selection-options YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/route-selection-options/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_Config struct {
	AdvertiseInactiveRoutes *bool `path:"advertise-inactive-routes" module:"openconfig-bgp"`
	AlwaysCompareMed        *bool `path:"always-compare-med" module:"openconfig-bgp"`
	EnableAigp              *bool `path:"enable-aigp" module:"openconfig-bgp"`
	ExternalCompareRouterId *bool `path:"external-compare-router-id" module:"openconfig-bgp"`
	IgnoreAsPathLength      *bool `path:"ignore-as-path-length" module:"openconfig-bgp"`
	IgnoreNextHopIgpMetric  *bool `path:"ignore-next-hop-igp-metric" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/route-selection-options/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_State struct {
	AdvertiseInactiveRoutes *bool `path:"advertise-inactive-routes" module:"openconfig-bgp"`
	AlwaysCompareMed        *bool `path:"always-compare-med" module:"openconfig-bgp"`
	EnableAigp              *bool `path:"enable-aigp" module:"openconfig-bgp"`
	ExternalCompareRouterId *bool `path:"external-compare-router-id" module:"openconfig-bgp"`
	IgnoreAsPathLength      *bool `path:"ignore-as-path-length" module:"openconfig-bgp"`
	IgnoreNextHopIgpMetric  *bool `path:"ignore-next-hop-igp-metric" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_RouteSelectionOptions_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4 represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/srte-policy-ipv4 YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4 struct {
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/srte-policy-ipv4/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/srte-policy-ipv4/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/srte-policy-ipv4/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6 represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/srte-policy-ipv6 YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6 struct {
	PrefixLimit *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/srte-policy-ipv6/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/srte-policy-ipv6/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/srte-policy-ipv6/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_State struct {
	AfiSafiName   E_OpenconfigBgpTypes_AFI_SAFI_TYPE `path:"afi-safi-name" module:"openconfig-bgp"`
	Enabled       *bool                              `path:"enabled" module:"openconfig-bgp"`
	TotalPaths    *uint32                            `path:"total-paths" module:"openconfig-bgp"`
	TotalPrefixes *uint32                            `path:"total-prefixes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/use-multiple-paths YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Config `path:"config" module:"openconfig-bgp"`
	Ebgp   *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp   `path:"ebgp" module:"openconfig-bgp"`
	Ibgp   *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp   `path:"ibgp" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/use-multiple-paths/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/use-multiple-paths/ebgp YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/use-multiple-paths/ebgp/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config struct {
	AllowMultipleAs *bool   `path:"allow-multiple-as" module:"openconfig-bgp"`
	MaximumPaths    *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/use-multiple-paths/ebgp/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State struct {
	AllowMultipleAs *bool   `path:"allow-multiple-as" module:"openconfig-bgp"`
	MaximumPaths    *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/use-multiple-paths/ibgp YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp struct {
	Config *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/use-multiple-paths/ibgp/config YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config struct {
	MaximumPaths *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/use-multiple-paths/ibgp/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State struct {
	MaximumPaths *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_State represents the /openconfig-bgp/bgp/global/afi-safis/afi-safi/use-multiple-paths/state YANG schema element.
type OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_State struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_AfiSafis_AfiSafi_UseMultiplePaths_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_Confederation represents the /openconfig-bgp/bgp/global/confederation YANG schema element.
type OpenconfigBgp_Bgp_Global_Confederation struct {
	Config *OpenconfigBgp_Bgp_Global_Confederation_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_Confederation_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_Confederation implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_Confederation) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_Confederation) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_Confederation"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_Confederation) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_Confederation_Config represents the /openconfig-bgp/bgp/global/confederation/config YANG schema element.
type OpenconfigBgp_Bgp_Global_Confederation_Config struct {
	Identifier *uint32  `path:"identifier" module:"openconfig-bgp"`
	MemberAs   []uint32 `path:"member-as" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_Confederation_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_Confederation_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_Confederation_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_Confederation_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_Confederation_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_Confederation_State represents the /openconfig-bgp/bgp/global/confederation/state YANG schema element.
type OpenconfigBgp_Bgp_Global_Confederation_State struct {
	Identifier *uint32  `path:"identifier" module:"openconfig-bgp"`
	MemberAs   []uint32 `path:"member-as" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_Confederation_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_Confederation_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_Confederation_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_Confederation_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_Confederation_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_Config represents the /openconfig-bgp/bgp/global/config YANG schema element.
type OpenconfigBgp_Bgp_Global_Config struct {
	As       *uint32 `path:"as" module:"openconfig-bgp"`
	RouterId *string `path:"router-id" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_DefaultRouteDistance represents the /openconfig-bgp/bgp/global/default-route-distance YANG schema element.
type OpenconfigBgp_Bgp_Global_DefaultRouteDistance struct {
	Config *OpenconfigBgp_Bgp_Global_DefaultRouteDistance_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_DefaultRouteDistance_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_DefaultRouteDistance implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_DefaultRouteDistance) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_DefaultRouteDistance) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_DefaultRouteDistance"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_DefaultRouteDistance) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_DefaultRouteDistance_Config represents the /openconfig-bgp/bgp/global/default-route-distance/config YANG schema element.
type OpenconfigBgp_Bgp_Global_DefaultRouteDistance_Config struct {
	ExternalRouteDistance *uint8 `path:"external-route-distance" module:"openconfig-bgp"`
	InternalRouteDistance *uint8 `path:"internal-route-distance" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_DefaultRouteDistance_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_DefaultRouteDistance_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_DefaultRouteDistance_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_DefaultRouteDistance_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_DefaultRouteDistance_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_DefaultRouteDistance_State represents the /openconfig-bgp/bgp/global/default-route-distance/state YANG schema element.
type OpenconfigBgp_Bgp_Global_DefaultRouteDistance_State struct {
	ExternalRouteDistance *uint8 `path:"external-route-distance" module:"openconfig-bgp"`
	InternalRouteDistance *uint8 `path:"internal-route-distance" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_DefaultRouteDistance_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_DefaultRouteDistance_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_DefaultRouteDistance_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_DefaultRouteDistance_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_DefaultRouteDistance_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes represents the /openconfig-bgp/bgp/global/dynamic-neighbor-prefixes YANG schema element.
type OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes struct {
	DynamicNeighborPrefix map[string]*OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix `path:"dynamic-neighbor-prefix" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes) IsYANGGoStruct() {}

// NewDynamicNeighborPrefix creates a new entry in the DynamicNeighborPrefix list of the
// OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes) NewDynamicNeighborPrefix(Prefix string) (*OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.DynamicNeighborPrefix == nil {
		t.DynamicNeighborPrefix = make(map[string]*OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix)
	}

	key := Prefix

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.DynamicNeighborPrefix[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list DynamicNeighborPrefix", key)
	}

	t.DynamicNeighborPrefix[key] = &OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix{
		Prefix: &Prefix,
	}

	return t.DynamicNeighborPrefix[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix represents the /openconfig-bgp/bgp/global/dynamic-neighbor-prefixes/dynamic-neighbor-prefix YANG schema element.
type OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix struct {
	Config *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_Config `path:"config" module:"openconfig-bgp"`
	Prefix *string                                                                        `path:"prefix" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"prefix": *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_Config represents the /openconfig-bgp/bgp/global/dynamic-neighbor-prefixes/dynamic-neighbor-prefix/config YANG schema element.
type OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_Config struct {
	PeerGroup *string `path:"peer-group" module:"openconfig-bgp"`
	Prefix    *string `path:"prefix" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_State represents the /openconfig-bgp/bgp/global/dynamic-neighbor-prefixes/dynamic-neighbor-prefix/state YANG schema element.
type OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_State struct {
	PeerGroup *string `path:"peer-group" module:"openconfig-bgp"`
	Prefix    *string `path:"prefix" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_DynamicNeighborPrefixes_DynamicNeighborPrefix_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_GracefulRestart represents the /openconfig-bgp/bgp/global/graceful-restart YANG schema element.
type OpenconfigBgp_Bgp_Global_GracefulRestart struct {
	Config *OpenconfigBgp_Bgp_Global_GracefulRestart_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_GracefulRestart_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_GracefulRestart implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_GracefulRestart) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_GracefulRestart) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_GracefulRestart"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_GracefulRestart) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_GracefulRestart_Config represents the /openconfig-bgp/bgp/global/graceful-restart/config YANG schema element.
type OpenconfigBgp_Bgp_Global_GracefulRestart_Config struct {
	Enabled         *bool    `path:"enabled" module:"openconfig-bgp"`
	HelperOnly      *bool    `path:"helper-only" module:"openconfig-bgp"`
	RestartTime     *uint16  `path:"restart-time" module:"openconfig-bgp"`
	StaleRoutesTime *float64 `path:"stale-routes-time" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_GracefulRestart_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_GracefulRestart_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_GracefulRestart_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_GracefulRestart_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_GracefulRestart_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_GracefulRestart_State represents the /openconfig-bgp/bgp/global/graceful-restart/state YANG schema element.
type OpenconfigBgp_Bgp_Global_GracefulRestart_State struct {
	Enabled         *bool    `path:"enabled" module:"openconfig-bgp"`
	HelperOnly      *bool    `path:"helper-only" module:"openconfig-bgp"`
	RestartTime     *uint16  `path:"restart-time" module:"openconfig-bgp"`
	StaleRoutesTime *float64 `path:"stale-routes-time" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_GracefulRestart_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_GracefulRestart_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_GracefulRestart_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_GracefulRestart_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_GracefulRestart_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_RouteSelectionOptions represents the /openconfig-bgp/bgp/global/route-selection-options YANG schema element.
type OpenconfigBgp_Bgp_Global_RouteSelectionOptions struct {
	Config *OpenconfigBgp_Bgp_Global_RouteSelectionOptions_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_RouteSelectionOptions_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_RouteSelectionOptions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_RouteSelectionOptions) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_RouteSelectionOptions) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_RouteSelectionOptions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_RouteSelectionOptions) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_RouteSelectionOptions_Config represents the /openconfig-bgp/bgp/global/route-selection-options/config YANG schema element.
type OpenconfigBgp_Bgp_Global_RouteSelectionOptions_Config struct {
	AdvertiseInactiveRoutes *bool `path:"advertise-inactive-routes" module:"openconfig-bgp"`
	AlwaysCompareMed        *bool `path:"always-compare-med" module:"openconfig-bgp"`
	EnableAigp              *bool `path:"enable-aigp" module:"openconfig-bgp"`
	ExternalCompareRouterId *bool `path:"external-compare-router-id" module:"openconfig-bgp"`
	IgnoreAsPathLength      *bool `path:"ignore-as-path-length" module:"openconfig-bgp"`
	IgnoreNextHopIgpMetric  *bool `path:"ignore-next-hop-igp-metric" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_RouteSelectionOptions_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_RouteSelectionOptions_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_RouteSelectionOptions_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_RouteSelectionOptions_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_RouteSelectionOptions_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_RouteSelectionOptions_State represents the /openconfig-bgp/bgp/global/route-selection-options/state YANG schema element.
type OpenconfigBgp_Bgp_Global_RouteSelectionOptions_State struct {
	AdvertiseInactiveRoutes *bool `path:"advertise-inactive-routes" module:"openconfig-bgp"`
	AlwaysCompareMed        *bool `path:"always-compare-med" module:"openconfig-bgp"`
	EnableAigp              *bool `path:"enable-aigp" module:"openconfig-bgp"`
	ExternalCompareRouterId *bool `path:"external-compare-router-id" module:"openconfig-bgp"`
	IgnoreAsPathLength      *bool `path:"ignore-as-path-length" module:"openconfig-bgp"`
	IgnoreNextHopIgpMetric  *bool `path:"ignore-next-hop-igp-metric" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_RouteSelectionOptions_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_RouteSelectionOptions_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_RouteSelectionOptions_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_RouteSelectionOptions_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_RouteSelectionOptions_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_State represents the /openconfig-bgp/bgp/global/state YANG schema element.
type OpenconfigBgp_Bgp_Global_State struct {
	As            *uint32 `path:"as" module:"openconfig-bgp"`
	RouterId      *string `path:"router-id" module:"openconfig-bgp"`
	TotalPaths    *uint32 `path:"total-paths" module:"openconfig-bgp"`
	TotalPrefixes *uint32 `path:"total-prefixes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_UseMultiplePaths represents the /openconfig-bgp/bgp/global/use-multiple-paths YANG schema element.
type OpenconfigBgp_Bgp_Global_UseMultiplePaths struct {
	Config *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Config `path:"config" module:"openconfig-bgp"`
	Ebgp   *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp   `path:"ebgp" module:"openconfig-bgp"`
	Ibgp   *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp   `path:"ibgp" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_UseMultiplePaths_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_UseMultiplePaths implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_UseMultiplePaths) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_UseMultiplePaths"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_UseMultiplePaths_Config represents the /openconfig-bgp/bgp/global/use-multiple-paths/config YANG schema element.
type OpenconfigBgp_Bgp_Global_UseMultiplePaths_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_UseMultiplePaths_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_UseMultiplePaths_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_UseMultiplePaths_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp represents the /openconfig-bgp/bgp/global/use-multiple-paths/ebgp YANG schema element.
type OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp struct {
	Config *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_Config represents the /openconfig-bgp/bgp/global/use-multiple-paths/ebgp/config YANG schema element.
type OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_Config struct {
	AllowMultipleAs *bool   `path:"allow-multiple-as" module:"openconfig-bgp"`
	MaximumPaths    *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_State represents the /openconfig-bgp/bgp/global/use-multiple-paths/ebgp/state YANG schema element.
type OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_State struct {
	AllowMultipleAs *bool   `path:"allow-multiple-as" module:"openconfig-bgp"`
	MaximumPaths    *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ebgp_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp represents the /openconfig-bgp/bgp/global/use-multiple-paths/ibgp YANG schema element.
type OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp struct {
	Config *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_Config represents the /openconfig-bgp/bgp/global/use-multiple-paths/ibgp/config YANG schema element.
type OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_Config struct {
	MaximumPaths *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_State represents the /openconfig-bgp/bgp/global/use-multiple-paths/ibgp/state YANG schema element.
type OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_State struct {
	MaximumPaths *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_Ibgp_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Global_UseMultiplePaths_State represents the /openconfig-bgp/bgp/global/use-multiple-paths/state YANG schema element.
type OpenconfigBgp_Bgp_Global_UseMultiplePaths_State struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Global_UseMultiplePaths_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Global_UseMultiplePaths_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Global_UseMultiplePaths_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Global_UseMultiplePaths_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors represents the /openconfig-bgp/bgp/neighbors YANG schema element.
type OpenconfigBgp_Bgp_Neighbors struct {
	Neighbor map[string]*OpenconfigBgp_Bgp_Neighbors_Neighbor `path:"neighbor" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigBgp_Bgp_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Neighbors) NewNeighbor(NeighborAddress string) (*OpenconfigBgp_Bgp_Neighbors_Neighbor, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigBgp_Bgp_Neighbors_Neighbor)
	}

	key := NeighborAddress

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigBgp_Bgp_Neighbors_Neighbor{
		NeighborAddress: &NeighborAddress,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigBgp_Bgp_Neighbors_Neighbor represents the /openconfig-bgp/bgp/neighbors/neighbor YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor struct {
	AfiSafis         *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis         `path:"afi-safis" module:"openconfig-bgp"`
	ApplyPolicy      *OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy      `path:"apply-policy" module:"openconfig-bgp"`
	AsPathOptions    *OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions    `path:"as-path-options" module:"openconfig-bgp"`
	Config           *OpenconfigBgp_Bgp_Neighbors_Neighbor_Config           `path:"config" module:"openconfig-bgp"`
	EbgpMultihop     *OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop     `path:"ebgp-multihop" module:"openconfig-bgp"`
	EnableBfd        *OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd        `path:"enable-bfd" module:"openconfig-bgp"`
	ErrorHandling    *OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling    `path:"error-handling" module:"openconfig-bgp"`
	GracefulRestart  *OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart  `path:"graceful-restart" module:"openconfig-bgp"`
	LoggingOptions   *OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions   `path:"logging-options" module:"openconfig-bgp"`
	NeighborAddress  *string                                                `path:"neighbor-address" module:"openconfig-bgp"`
	RouteReflector   *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector   `path:"route-reflector" module:"openconfig-bgp"`
	State            *OpenconfigBgp_Bgp_Neighbors_Neighbor_State            `path:"state" module:"openconfig-bgp"`
	Timers           *OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers           `path:"timers" module:"openconfig-bgp"`
	Transport        *OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport        `path:"transport" module:"openconfig-bgp"`
	UseMultiplePaths *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths `path:"use-multiple-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.NeighborAddress == nil {
		return nil, fmt.Errorf("nil value for key NeighborAddress")
	}

	return map[string]interface{}{
		"neighbor-address": *t.NeighborAddress,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis struct {
	AfiSafi map[E_OpenconfigBgpTypes_AFI_SAFI_TYPE]*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi `path:"afi-safi" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis) IsYANGGoStruct() {}

// NewAfiSafi creates a new entry in the AfiSafi list of the
// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis) NewAfiSafi(AfiSafiName E_OpenconfigBgpTypes_AFI_SAFI_TYPE) (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AfiSafi == nil {
		t.AfiSafi = make(map[E_OpenconfigBgpTypes_AFI_SAFI_TYPE]*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi)
	}

	key := AfiSafiName

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AfiSafi[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AfiSafi", key)
	}

	t.AfiSafi[key] = &OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi{
		AfiSafiName: AfiSafiName,
	}

	return t.AfiSafi[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi struct {
	AddPaths           *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths           `path:"add-paths" module:"openconfig-bgp"`
	AfiSafiName        E_OpenconfigBgpTypes_AFI_SAFI_TYPE                                        `path:"afi-safi-name" module:"openconfig-bgp"`
	ApplyPolicy        *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy        `path:"apply-policy" module:"openconfig-bgp"`
	Config             *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Config             `path:"config" module:"openconfig-bgp"`
	GracefulRestart    *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart    `path:"graceful-restart" module:"openconfig-bgp"`
	Ipv4LabeledUnicast *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast `path:"ipv4-labeled-unicast" module:"openconfig-bgp"`
	Ipv4Unicast        *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast        `path:"ipv4-unicast" module:"openconfig-bgp"`
	Ipv6LabeledUnicast *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast `path:"ipv6-labeled-unicast" module:"openconfig-bgp"`
	Ipv6Unicast        *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast        `path:"ipv6-unicast" module:"openconfig-bgp"`
	L2VpnEvpn          *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn          `path:"l2vpn-evpn" module:"openconfig-bgp"`
	L2VpnVpls          *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls          `path:"l2vpn-vpls" module:"openconfig-bgp"`
	L3VpnIpv4Multicast *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast `path:"l3vpn-ipv4-multicast" module:"openconfig-bgp"`
	L3VpnIpv4Unicast   *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast   `path:"l3vpn-ipv4-unicast" module:"openconfig-bgp"`
	L3VpnIpv6Multicast *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast `path:"l3vpn-ipv6-multicast" module:"openconfig-bgp"`
	L3VpnIpv6Unicast   *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast   `path:"l3vpn-ipv6-unicast" module:"openconfig-bgp"`
	SrtePolicyIpv4     *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4     `path:"srte-policy-ipv4" module:"openconfig-bgp"`
	SrtePolicyIpv6     *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6     `path:"srte-policy-ipv6" module:"openconfig-bgp"`
	State              *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State              `path:"state" module:"openconfig-bgp"`
	UseMultiplePaths   *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths   `path:"use-multiple-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"afi-safi-name": t.AfiSafiName,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/add-paths YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/add-paths/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_Config struct {
	EligiblePrefixPolicy *string `path:"eligible-prefix-policy" module:"openconfig-bgp"`
	Receive              *bool   `path:"receive" module:"openconfig-bgp"`
	Send                 *bool   `path:"send" module:"openconfig-bgp"`
	SendMax              *uint8  `path:"send-max" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/add-paths/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_State struct {
	EligiblePrefixPolicy *string `path:"eligible-prefix-policy" module:"openconfig-bgp"`
	Receive              *bool   `path:"receive" module:"openconfig-bgp"`
	Send                 *bool   `path:"send" module:"openconfig-bgp"`
	SendMax              *uint8  `path:"send-max" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_AddPaths_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/apply-policy YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/apply-policy/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_Config struct {
	DefaultExportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-export-policy" module:"openconfig-bgp"`
	DefaultImportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-import-policy" module:"openconfig-bgp"`
	ExportPolicy        []string                                    `path:"export-policy" module:"openconfig-bgp"`
	ImportPolicy        []string                                    `path:"import-policy" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/apply-policy/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_State struct {
	DefaultExportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-export-policy" module:"openconfig-bgp"`
	DefaultImportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-import-policy" module:"openconfig-bgp"`
	ExportPolicy        []string                                    `path:"export-policy" module:"openconfig-bgp"`
	ImportPolicy        []string                                    `path:"import-policy" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_ApplyPolicy_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Config struct {
	AfiSafiName E_OpenconfigBgpTypes_AFI_SAFI_TYPE `path:"afi-safi-name" module:"openconfig-bgp"`
	Enabled     *bool                              `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/graceful-restart YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/graceful-restart/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/graceful-restart/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_State struct {
	Advertised *bool `path:"advertised" module:"openconfig-bgp"`
	Enabled    *bool `path:"enabled" module:"openconfig-bgp"`
	Received   *bool `path:"received" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_GracefulRestart_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-labeled-unicast YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-labeled-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-labeled-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-labeled-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-unicast YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast struct {
	Config      *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_Config      `path:"config" module:"openconfig-bgp"`
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
	State       *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_State       `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-unicast/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_Config struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv4-unicast/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_State struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv4Unicast_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-labeled-unicast YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-labeled-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-labeled-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-labeled-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-unicast YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast struct {
	Config      *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_Config      `path:"config" module:"openconfig-bgp"`
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
	State       *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_State       `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-unicast/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_Config struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/ipv6-unicast/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_State struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_Ipv6Unicast_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l2vpn-evpn YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn struct {
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l2vpn-evpn/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l2vpn-evpn/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l2vpn-evpn/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l2vpn-vpls YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls struct {
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l2vpn-vpls/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l2vpn-vpls/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l2vpn-vpls/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv4-multicast YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv4-multicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv4-multicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv4-multicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv4-unicast YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv4-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv4-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv4-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv6-multicast YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv6-multicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv6-multicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv6-multicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv6-unicast YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv6-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv6-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/l3vpn-ipv6-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4 represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/srte-policy-ipv4 YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4 struct {
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/srte-policy-ipv4/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/srte-policy-ipv4/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/srte-policy-ipv4/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6 represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/srte-policy-ipv6 YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6 struct {
	PrefixLimit *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/srte-policy-ipv6/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/srte-policy-ipv6/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/srte-policy-ipv6/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State struct {
	Active      *bool                                                                 `path:"active" module:"openconfig-bgp"`
	AfiSafiName E_OpenconfigBgpTypes_AFI_SAFI_TYPE                                    `path:"afi-safi-name" module:"openconfig-bgp"`
	Enabled     *bool                                                                 `path:"enabled" module:"openconfig-bgp"`
	Prefixes    *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State_Prefixes `path:"prefixes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State_Prefixes represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/state/prefixes YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State_Prefixes struct {
	Installed         *uint32 `path:"installed" module:"openconfig-bgp"`
	Received          *uint32 `path:"received" module:"openconfig-bgp"`
	ReceivedPrePolicy *uint32 `path:"received-pre-policy" module:"openconfig-bgp"`
	Sent              *uint32 `path:"sent" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State_Prefixes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State_Prefixes) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State_Prefixes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State_Prefixes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_State_Prefixes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/use-multiple-paths YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Config `path:"config" module:"openconfig-bgp"`
	Ebgp   *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp   `path:"ebgp" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/use-multiple-paths/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/use-multiple-paths/ebgp YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/use-multiple-paths/ebgp/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config struct {
	AllowMultipleAs *bool `path:"allow-multiple-as" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/use-multiple-paths/ebgp/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State struct {
	AllowMultipleAs *bool `path:"allow-multiple-as" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_State represents the /openconfig-bgp/bgp/neighbors/neighbor/afi-safis/afi-safi/use-multiple-paths/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_State struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AfiSafis_AfiSafi_UseMultiplePaths_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy represents the /openconfig-bgp/bgp/neighbors/neighbor/apply-policy YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/apply-policy/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_Config struct {
	DefaultExportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-export-policy" module:"openconfig-bgp"`
	DefaultImportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-import-policy" module:"openconfig-bgp"`
	ExportPolicy        []string                                    `path:"export-policy" module:"openconfig-bgp"`
	ImportPolicy        []string                                    `path:"import-policy" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_State represents the /openconfig-bgp/bgp/neighbors/neighbor/apply-policy/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_State struct {
	DefaultExportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-export-policy" module:"openconfig-bgp"`
	DefaultImportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-import-policy" module:"openconfig-bgp"`
	ExportPolicy        []string                                    `path:"export-policy" module:"openconfig-bgp"`
	ImportPolicy        []string                                    `path:"import-policy" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ApplyPolicy_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions represents the /openconfig-bgp/bgp/neighbors/neighbor/as-path-options YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/as-path-options/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_Config struct {
	AllowOwnAs          *uint8 `path:"allow-own-as" module:"openconfig-bgp"`
	DisablePeerAsFilter *bool  `path:"disable-peer-as-filter" module:"openconfig-bgp"`
	ReplacePeerAs       *bool  `path:"replace-peer-as" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_State represents the /openconfig-bgp/bgp/neighbors/neighbor/as-path-options/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_State struct {
	AllowOwnAs          *uint8 `path:"allow-own-as" module:"openconfig-bgp"`
	DisablePeerAsFilter *bool  `path:"disable-peer-as-filter" module:"openconfig-bgp"`
	ReplacePeerAs       *bool  `path:"replace-peer-as" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_AsPathOptions_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_Config struct {
	AuthPassword     *string                               `path:"auth-password" module:"openconfig-bgp"`
	Description      *string                               `path:"description" module:"openconfig-bgp"`
	Enabled          *bool                                 `path:"enabled" module:"openconfig-bgp"`
	LocalAs          *uint32                               `path:"local-as" module:"openconfig-bgp"`
	NeighborAddress  *string                               `path:"neighbor-address" module:"openconfig-bgp"`
	PeerAs           *uint32                               `path:"peer-as" module:"openconfig-bgp"`
	PeerGroup        *string                               `path:"peer-group" module:"openconfig-bgp"`
	PeerType         E_OpenconfigBgp_PeerType              `path:"peer-type" module:"openconfig-bgp"`
	RemovePrivateAs  E_OpenconfigBgp_RemovePrivateAsOption `path:"remove-private-as" module:"openconfig-bgp"`
	RouteFlapDamping *bool                                 `path:"route-flap-damping" module:"openconfig-bgp"`
	SendCommunity    E_OpenconfigBgp_CommunityType         `path:"send-community" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop represents the /openconfig-bgp/bgp/neighbors/neighbor/ebgp-multihop YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/ebgp-multihop/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_Config struct {
	Enabled     *bool  `path:"enabled" module:"openconfig-bgp"`
	MultihopTtl *uint8 `path:"multihop-ttl" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_State represents the /openconfig-bgp/bgp/neighbors/neighbor/ebgp-multihop/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_State struct {
	Enabled     *bool  `path:"enabled" module:"openconfig-bgp"`
	MultihopTtl *uint8 `path:"multihop-ttl" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EbgpMultihop_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd represents the /openconfig-bgp/bgp/neighbors/neighbor/enable-bfd YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/enable-bfd/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_State represents the /openconfig-bgp/bgp/neighbors/neighbor/enable-bfd/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_State struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_EnableBfd_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling represents the /openconfig-bgp/bgp/neighbors/neighbor/error-handling YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/error-handling/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_Config struct {
	TreatAsWithdraw *bool `path:"treat-as-withdraw" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_State represents the /openconfig-bgp/bgp/neighbors/neighbor/error-handling/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_State struct {
	ErroneousUpdateMessages *uint32 `path:"erroneous-update-messages" module:"openconfig-bgp"`
	TreatAsWithdraw         *bool   `path:"treat-as-withdraw" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_ErrorHandling_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart represents the /openconfig-bgp/bgp/neighbors/neighbor/graceful-restart YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/graceful-restart/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_Config struct {
	Enabled         *bool    `path:"enabled" module:"openconfig-bgp"`
	HelperOnly      *bool    `path:"helper-only" module:"openconfig-bgp"`
	RestartTime     *uint16  `path:"restart-time" module:"openconfig-bgp"`
	StaleRoutesTime *float64 `path:"stale-routes-time" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_State represents the /openconfig-bgp/bgp/neighbors/neighbor/graceful-restart/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_State struct {
	Enabled         *bool                                                             `path:"enabled" module:"openconfig-bgp"`
	HelperOnly      *bool                                                             `path:"helper-only" module:"openconfig-bgp"`
	LocalRestarting *bool                                                             `path:"local-restarting" module:"openconfig-bgp"`
	Mode            E_OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_State_Mode `path:"mode" module:"openconfig-bgp"`
	PeerRestartTime *uint16                                                           `path:"peer-restart-time" module:"openconfig-bgp"`
	PeerRestarting  *bool                                                             `path:"peer-restarting" module:"openconfig-bgp"`
	RestartTime     *uint16                                                           `path:"restart-time" module:"openconfig-bgp"`
	StaleRoutesTime *float64                                                          `path:"stale-routes-time" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_GracefulRestart_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions represents the /openconfig-bgp/bgp/neighbors/neighbor/logging-options YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/logging-options/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_Config struct {
	LogNeighborStateChanges *bool `path:"log-neighbor-state-changes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_State represents the /openconfig-bgp/bgp/neighbors/neighbor/logging-options/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_State struct {
	LogNeighborStateChanges *bool `path:"log-neighbor-state-changes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_LoggingOptions_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector represents the /openconfig-bgp/bgp/neighbors/neighbor/route-reflector YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/route-reflector/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config struct {
	RouteReflectorClient    *bool                                                                                    `path:"route-reflector-client" module:"openconfig-bgp"`
	RouteReflectorClusterId OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union `path:"route-reflector-cluster-id" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-bgp/bgp/neighbors/neighbor/route-reflector/config/route-reflector-cluster-id within the YANG schema.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union interface {
	Is_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union()
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union_String is used when /openconfig-bgp/bgp/neighbors/neighbor/route-reflector/config/route-reflector-cluster-id
// is to be set to a string value.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union_String struct {
	String string
}

// Is_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union_String
// implements the OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union interface.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union_String) Is_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union() {
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union_Uint32 is used when /openconfig-bgp/bgp/neighbors/neighbor/route-reflector/config/route-reflector-cluster-id
// is to be set to a uint32 value.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union_Uint32 struct {
	Uint32 uint32
}

// Is_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union_Uint32
// implements the OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union interface.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union_Uint32) Is_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union() {
}

// To_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config) To_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union(i interface{}) (OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union, error) {
	switch v := i.(type) {
	case string:
		return &OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union_String{v}, nil
	case uint32:
		return &OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union_Uint32{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_Config_RouteReflectorClusterId_Union, unknown union type, got: %T, want any of [string, uint32]", i, i)
	}
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State represents the /openconfig-bgp/bgp/neighbors/neighbor/route-reflector/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State struct {
	RouteReflectorClient    *bool                                                                                   `path:"route-reflector-client" module:"openconfig-bgp"`
	RouteReflectorClusterId OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union `path:"route-reflector-cluster-id" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-bgp/bgp/neighbors/neighbor/route-reflector/state/route-reflector-cluster-id within the YANG schema.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union interface {
	Is_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union()
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union_String is used when /openconfig-bgp/bgp/neighbors/neighbor/route-reflector/state/route-reflector-cluster-id
// is to be set to a string value.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union_String struct {
	String string
}

// Is_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union_String
// implements the OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union interface.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union_String) Is_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union() {
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union_Uint32 is used when /openconfig-bgp/bgp/neighbors/neighbor/route-reflector/state/route-reflector-cluster-id
// is to be set to a uint32 value.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union_Uint32 struct {
	Uint32 uint32
}

// Is_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union_Uint32
// implements the OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union interface.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union_Uint32) Is_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union() {
}

// To_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State) To_OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union(i interface{}) (OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union, error) {
	switch v := i.(type) {
	case string:
		return &OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union_String{v}, nil
	case uint32:
		return &OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union_Uint32{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigBgp_Bgp_Neighbors_Neighbor_RouteReflector_State_RouteReflectorClusterId_Union, unknown union type, got: %T, want any of [string, uint32]", i, i)
	}
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_State represents the /openconfig-bgp/bgp/neighbors/neighbor/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_State struct {
	AuthPassword           *string                                                   `path:"auth-password" module:"openconfig-bgp"`
	Description            *string                                                   `path:"description" module:"openconfig-bgp"`
	DynamicallyConfigured  *bool                                                     `path:"dynamically-configured" module:"openconfig-bgp"`
	Enabled                *bool                                                     `path:"enabled" module:"openconfig-bgp"`
	EstablishedTransitions *uint64                                                   `path:"established-transitions" module:"openconfig-bgp"`
	LastEstablished        *uint64                                                   `path:"last-established" module:"openconfig-bgp"`
	LocalAs                *uint32                                                   `path:"local-as" module:"openconfig-bgp"`
	Messages               *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages      `path:"messages" module:"openconfig-bgp"`
	NeighborAddress        *string                                                   `path:"neighbor-address" module:"openconfig-bgp"`
	PeerAs                 *uint32                                                   `path:"peer-as" module:"openconfig-bgp"`
	PeerGroup              *string                                                   `path:"peer-group" module:"openconfig-bgp"`
	PeerType               E_OpenconfigBgp_PeerType                                  `path:"peer-type" module:"openconfig-bgp"`
	Queues                 *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Queues        `path:"queues" module:"openconfig-bgp"`
	RemovePrivateAs        E_OpenconfigBgp_RemovePrivateAsOption                     `path:"remove-private-as" module:"openconfig-bgp"`
	RouteFlapDamping       *bool                                                     `path:"route-flap-damping" module:"openconfig-bgp"`
	SendCommunity          E_OpenconfigBgp_CommunityType                             `path:"send-community" module:"openconfig-bgp"`
	SessionState           E_OpenconfigBgp_Bgp_Neighbors_Neighbor_State_SessionState `path:"session-state" module:"openconfig-bgp"`
	SupportedCapabilities  []E_OpenconfigBgpTypes_BGP_CAPABILITY                     `path:"supported-capabilities" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages represents the /openconfig-bgp/bgp/neighbors/neighbor/state/messages YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages struct {
	Received *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Received `path:"received" module:"openconfig-bgp"`
	Sent     *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Sent     `path:"sent" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Received represents the /openconfig-bgp/bgp/neighbors/neighbor/state/messages/received YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Received struct {
	NOTIFICATION                 *uint64                                `path:"NOTIFICATION" module:"openconfig-bgp"`
	UPDATE                       *uint64                                `path:"UPDATE" module:"openconfig-bgp"`
	LastNotificationErrorCode    E_OpenconfigBgpTypes_BGP_ERROR_CODE    `path:"last-notification-error-code" module:"openconfig-bgp"`
	LastNotificationErrorSubcode E_OpenconfigBgpTypes_BGP_ERROR_SUBCODE `path:"last-notification-error-subcode" module:"openconfig-bgp"`
	LastNotificationTime         *uint64                                `path:"last-notification-time" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Received implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Received) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Received) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Received"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Received) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Sent represents the /openconfig-bgp/bgp/neighbors/neighbor/state/messages/sent YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Sent struct {
	NOTIFICATION                 *uint64                                `path:"NOTIFICATION" module:"openconfig-bgp"`
	UPDATE                       *uint64                                `path:"UPDATE" module:"openconfig-bgp"`
	LastNotificationErrorCode    E_OpenconfigBgpTypes_BGP_ERROR_CODE    `path:"last-notification-error-code" module:"openconfig-bgp"`
	LastNotificationErrorSubcode E_OpenconfigBgpTypes_BGP_ERROR_SUBCODE `path:"last-notification-error-subcode" module:"openconfig-bgp"`
	LastNotificationTime         *uint64                                `path:"last-notification-time" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Sent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Sent) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Sent) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Sent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Messages_Sent) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Queues represents the /openconfig-bgp/bgp/neighbors/neighbor/state/queues YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Queues struct {
	Input  *uint32 `path:"input" module:"openconfig-bgp"`
	Output *uint32 `path:"output" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Queues implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Queues) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Queues) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Queues"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_State_Queues) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers represents the /openconfig-bgp/bgp/neighbors/neighbor/timers YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/timers/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_Config struct {
	ConnectRetry                 *float64 `path:"connect-retry" module:"openconfig-bgp"`
	HoldTime                     *float64 `path:"hold-time" module:"openconfig-bgp"`
	KeepaliveInterval            *float64 `path:"keepalive-interval" module:"openconfig-bgp"`
	MinimumAdvertisementInterval *float64 `path:"minimum-advertisement-interval" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_State represents the /openconfig-bgp/bgp/neighbors/neighbor/timers/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_State struct {
	ConnectRetry                 *float64 `path:"connect-retry" module:"openconfig-bgp"`
	HoldTime                     *float64 `path:"hold-time" module:"openconfig-bgp"`
	KeepaliveInterval            *float64 `path:"keepalive-interval" module:"openconfig-bgp"`
	MinimumAdvertisementInterval *float64 `path:"minimum-advertisement-interval" module:"openconfig-bgp"`
	NegotiatedHoldTime           *float64 `path:"negotiated-hold-time" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Timers_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport represents the /openconfig-bgp/bgp/neighbors/neighbor/transport YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/transport/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_Config struct {
	LocalAddress *string `path:"local-address" module:"openconfig-bgp"`
	MtuDiscovery *bool   `path:"mtu-discovery" module:"openconfig-bgp"`
	PassiveMode  *bool   `path:"passive-mode" module:"openconfig-bgp"`
	TcpMss       *uint16 `path:"tcp-mss" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_State represents the /openconfig-bgp/bgp/neighbors/neighbor/transport/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_State struct {
	LocalAddress  *string `path:"local-address" module:"openconfig-bgp"`
	LocalPort     *uint16 `path:"local-port" module:"openconfig-bgp"`
	MtuDiscovery  *bool   `path:"mtu-discovery" module:"openconfig-bgp"`
	PassiveMode   *bool   `path:"passive-mode" module:"openconfig-bgp"`
	RemoteAddress *string `path:"remote-address" module:"openconfig-bgp"`
	RemotePort    *uint16 `path:"remote-port" module:"openconfig-bgp"`
	TcpMss        *uint16 `path:"tcp-mss" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_Transport_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths represents the /openconfig-bgp/bgp/neighbors/neighbor/use-multiple-paths YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Config `path:"config" module:"openconfig-bgp"`
	Ebgp   *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp   `path:"ebgp" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/use-multiple-paths/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp represents the /openconfig-bgp/bgp/neighbors/neighbor/use-multiple-paths/ebgp YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp struct {
	Config *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_Config represents the /openconfig-bgp/bgp/neighbors/neighbor/use-multiple-paths/ebgp/config YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_Config struct {
	AllowMultipleAs *bool `path:"allow-multiple-as" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_State represents the /openconfig-bgp/bgp/neighbors/neighbor/use-multiple-paths/ebgp/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_State struct {
	AllowMultipleAs *bool `path:"allow-multiple-as" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_Ebgp_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_State represents the /openconfig-bgp/bgp/neighbors/neighbor/use-multiple-paths/state YANG schema element.
type OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_State struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Neighbors_Neighbor_UseMultiplePaths_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups represents the /openconfig-bgp/bgp/peer-groups YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups struct {
	PeerGroup map[string]*OpenconfigBgp_Bgp_PeerGroups_PeerGroup `path:"peer-group" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups) IsYANGGoStruct() {}

// NewPeerGroup creates a new entry in the PeerGroup list of the
// OpenconfigBgp_Bgp_PeerGroups struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_PeerGroups) NewPeerGroup(PeerGroupName string) (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.PeerGroup == nil {
		t.PeerGroup = make(map[string]*OpenconfigBgp_Bgp_PeerGroups_PeerGroup)
	}

	key := PeerGroupName

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.PeerGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list PeerGroup", key)
	}

	t.PeerGroup[key] = &OpenconfigBgp_Bgp_PeerGroups_PeerGroup{
		PeerGroupName: &PeerGroupName,
	}

	return t.PeerGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup represents the /openconfig-bgp/bgp/peer-groups/peer-group YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup struct {
	AfiSafis         *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis         `path:"afi-safis" module:"openconfig-bgp"`
	ApplyPolicy      *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy      `path:"apply-policy" module:"openconfig-bgp"`
	AsPathOptions    *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions    `path:"as-path-options" module:"openconfig-bgp"`
	Config           *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Config           `path:"config" module:"openconfig-bgp"`
	EbgpMultihop     *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop     `path:"ebgp-multihop" module:"openconfig-bgp"`
	EnableBfd        *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd        `path:"enable-bfd" module:"openconfig-bgp"`
	ErrorHandling    *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling    `path:"error-handling" module:"openconfig-bgp"`
	GracefulRestart  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart  `path:"graceful-restart" module:"openconfig-bgp"`
	LoggingOptions   *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions   `path:"logging-options" module:"openconfig-bgp"`
	PeerGroupName    *string                                                  `path:"peer-group-name" module:"openconfig-bgp"`
	RouteReflector   *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector   `path:"route-reflector" module:"openconfig-bgp"`
	State            *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_State            `path:"state" module:"openconfig-bgp"`
	Timers           *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers           `path:"timers" module:"openconfig-bgp"`
	Transport        *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport        `path:"transport" module:"openconfig-bgp"`
	UseMultiplePaths *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths `path:"use-multiple-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_PeerGroups_PeerGroup struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.PeerGroupName == nil {
		return nil, fmt.Errorf("nil value for key PeerGroupName")
	}

	return map[string]interface{}{
		"peer-group-name": *t.PeerGroupName,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis struct {
	AfiSafi map[E_OpenconfigBgpTypes_AFI_SAFI_TYPE]*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi `path:"afi-safi" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis) IsYANGGoStruct() {}

// NewAfiSafi creates a new entry in the AfiSafi list of the
// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis) NewAfiSafi(AfiSafiName E_OpenconfigBgpTypes_AFI_SAFI_TYPE) (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AfiSafi == nil {
		t.AfiSafi = make(map[E_OpenconfigBgpTypes_AFI_SAFI_TYPE]*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi)
	}

	key := AfiSafiName

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AfiSafi[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AfiSafi", key)
	}

	t.AfiSafi[key] = &OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi{
		AfiSafiName: AfiSafiName,
	}

	return t.AfiSafi[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi struct {
	AddPaths           *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths           `path:"add-paths" module:"openconfig-bgp"`
	AfiSafiName        E_OpenconfigBgpTypes_AFI_SAFI_TYPE                                          `path:"afi-safi-name" module:"openconfig-bgp"`
	ApplyPolicy        *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy        `path:"apply-policy" module:"openconfig-bgp"`
	Config             *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Config             `path:"config" module:"openconfig-bgp"`
	GracefulRestart    *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart    `path:"graceful-restart" module:"openconfig-bgp"`
	Ipv4LabeledUnicast *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast `path:"ipv4-labeled-unicast" module:"openconfig-bgp"`
	Ipv4Unicast        *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast        `path:"ipv4-unicast" module:"openconfig-bgp"`
	Ipv6LabeledUnicast *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast `path:"ipv6-labeled-unicast" module:"openconfig-bgp"`
	Ipv6Unicast        *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast        `path:"ipv6-unicast" module:"openconfig-bgp"`
	L2VpnEvpn          *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn          `path:"l2vpn-evpn" module:"openconfig-bgp"`
	L2VpnVpls          *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls          `path:"l2vpn-vpls" module:"openconfig-bgp"`
	L3VpnIpv4Multicast *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast `path:"l3vpn-ipv4-multicast" module:"openconfig-bgp"`
	L3VpnIpv4Unicast   *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast   `path:"l3vpn-ipv4-unicast" module:"openconfig-bgp"`
	L3VpnIpv6Multicast *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast `path:"l3vpn-ipv6-multicast" module:"openconfig-bgp"`
	L3VpnIpv6Unicast   *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast   `path:"l3vpn-ipv6-unicast" module:"openconfig-bgp"`
	SrtePolicyIpv4     *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4     `path:"srte-policy-ipv4" module:"openconfig-bgp"`
	SrtePolicyIpv6     *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6     `path:"srte-policy-ipv6" module:"openconfig-bgp"`
	State              *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_State              `path:"state" module:"openconfig-bgp"`
	UseMultiplePaths   *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths   `path:"use-multiple-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"afi-safi-name": t.AfiSafiName,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/add-paths YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/add-paths/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_Config struct {
	EligiblePrefixPolicy *string `path:"eligible-prefix-policy" module:"openconfig-bgp"`
	Receive              *bool   `path:"receive" module:"openconfig-bgp"`
	Send                 *bool   `path:"send" module:"openconfig-bgp"`
	SendMax              *uint8  `path:"send-max" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/add-paths/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_State struct {
	EligiblePrefixPolicy *string `path:"eligible-prefix-policy" module:"openconfig-bgp"`
	Receive              *bool   `path:"receive" module:"openconfig-bgp"`
	Send                 *bool   `path:"send" module:"openconfig-bgp"`
	SendMax              *uint8  `path:"send-max" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_AddPaths_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/apply-policy YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/apply-policy/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_Config struct {
	DefaultExportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-export-policy" module:"openconfig-bgp"`
	DefaultImportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-import-policy" module:"openconfig-bgp"`
	ExportPolicy        []string                                    `path:"export-policy" module:"openconfig-bgp"`
	ImportPolicy        []string                                    `path:"import-policy" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/apply-policy/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_State struct {
	DefaultExportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-export-policy" module:"openconfig-bgp"`
	DefaultImportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-import-policy" module:"openconfig-bgp"`
	ExportPolicy        []string                                    `path:"export-policy" module:"openconfig-bgp"`
	ImportPolicy        []string                                    `path:"import-policy" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_ApplyPolicy_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Config struct {
	AfiSafiName E_OpenconfigBgpTypes_AFI_SAFI_TYPE `path:"afi-safi-name" module:"openconfig-bgp"`
	Enabled     *bool                              `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/graceful-restart YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/graceful-restart/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/graceful-restart/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_State struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_GracefulRestart_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-labeled-unicast YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-labeled-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-labeled-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-labeled-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4LabeledUnicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-unicast YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast struct {
	Config      *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_Config      `path:"config" module:"openconfig-bgp"`
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
	State       *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_State       `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-unicast/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_Config struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv4-unicast/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_State struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv4Unicast_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-labeled-unicast YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-labeled-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-labeled-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-labeled-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6LabeledUnicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-unicast YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast struct {
	Config      *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_Config      `path:"config" module:"openconfig-bgp"`
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
	State       *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_State       `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-unicast/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_Config struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/ipv6-unicast/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_State struct {
	SendDefaultRoute *bool `path:"send-default-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_Ipv6Unicast_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l2vpn-evpn YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn struct {
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l2vpn-evpn/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l2vpn-evpn/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l2vpn-evpn/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnEvpn_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l2vpn-vpls YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls struct {
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l2vpn-vpls/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l2vpn-vpls/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l2vpn-vpls/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L2VpnVpls_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv4-multicast YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv4-multicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv4-multicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv4-multicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Multicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv4-unicast YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv4-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv4-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv4-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv4Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv6-multicast YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv6-multicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv6-multicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv6-multicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Multicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv6-unicast YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast struct {
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv6-unicast/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv6-unicast/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/l3vpn-ipv6-unicast/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_L3VpnIpv6Unicast_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4 represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/srte-policy-ipv4 YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4 struct {
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/srte-policy-ipv4/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/srte-policy-ipv4/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/srte-policy-ipv4/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv4_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6 represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/srte-policy-ipv6 YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6 struct {
	PrefixLimit *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit `path:"prefix-limit" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/srte-policy-ipv6/prefix-limit YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/srte-policy-ipv6/prefix-limit/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/srte-policy-ipv6/prefix-limit/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State struct {
	MaxPrefixes         *uint32  `path:"max-prefixes" module:"openconfig-bgp"`
	PreventTeardown     *bool    `path:"prevent-teardown" module:"openconfig-bgp"`
	RestartTimer        *float64 `path:"restart-timer" module:"openconfig-bgp"`
	WarningThresholdPct *uint8   `path:"warning-threshold-pct" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_SrtePolicyIpv6_PrefixLimit_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_State struct {
	AfiSafiName E_OpenconfigBgpTypes_AFI_SAFI_TYPE `path:"afi-safi-name" module:"openconfig-bgp"`
	Enabled     *bool                              `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/use-multiple-paths YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Config `path:"config" module:"openconfig-bgp"`
	Ebgp   *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp   `path:"ebgp" module:"openconfig-bgp"`
	Ibgp   *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp   `path:"ibgp" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/use-multiple-paths/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/use-multiple-paths/ebgp YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/use-multiple-paths/ebgp/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config struct {
	AllowMultipleAs *bool   `path:"allow-multiple-as" module:"openconfig-bgp"`
	MaximumPaths    *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/use-multiple-paths/ebgp/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State struct {
	AllowMultipleAs *bool   `path:"allow-multiple-as" module:"openconfig-bgp"`
	MaximumPaths    *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ebgp_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/use-multiple-paths/ibgp YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/use-multiple-paths/ibgp/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config struct {
	MaximumPaths *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/use-multiple-paths/ibgp/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State struct {
	MaximumPaths *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_Ibgp_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/afi-safis/afi-safi/use-multiple-paths/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_State struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AfiSafis_AfiSafi_UseMultiplePaths_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy represents the /openconfig-bgp/bgp/peer-groups/peer-group/apply-policy YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/apply-policy/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_Config struct {
	DefaultExportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-export-policy" module:"openconfig-bgp"`
	DefaultImportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-import-policy" module:"openconfig-bgp"`
	ExportPolicy        []string                                    `path:"export-policy" module:"openconfig-bgp"`
	ImportPolicy        []string                                    `path:"import-policy" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/apply-policy/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_State struct {
	DefaultExportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-export-policy" module:"openconfig-bgp"`
	DefaultImportPolicy E_OpenconfigRoutingPolicy_DefaultPolicyType `path:"default-import-policy" module:"openconfig-bgp"`
	ExportPolicy        []string                                    `path:"export-policy" module:"openconfig-bgp"`
	ImportPolicy        []string                                    `path:"import-policy" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ApplyPolicy_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions represents the /openconfig-bgp/bgp/peer-groups/peer-group/as-path-options YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/as-path-options/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_Config struct {
	AllowOwnAs          *uint8 `path:"allow-own-as" module:"openconfig-bgp"`
	DisablePeerAsFilter *bool  `path:"disable-peer-as-filter" module:"openconfig-bgp"`
	ReplacePeerAs       *bool  `path:"replace-peer-as" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/as-path-options/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_State struct {
	AllowOwnAs          *uint8 `path:"allow-own-as" module:"openconfig-bgp"`
	DisablePeerAsFilter *bool  `path:"disable-peer-as-filter" module:"openconfig-bgp"`
	ReplacePeerAs       *bool  `path:"replace-peer-as" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_AsPathOptions_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Config struct {
	AuthPassword     *string                               `path:"auth-password" module:"openconfig-bgp"`
	Description      *string                               `path:"description" module:"openconfig-bgp"`
	LocalAs          *uint32                               `path:"local-as" module:"openconfig-bgp"`
	PeerAs           *uint32                               `path:"peer-as" module:"openconfig-bgp"`
	PeerGroupName    *string                               `path:"peer-group-name" module:"openconfig-bgp"`
	PeerType         E_OpenconfigBgp_PeerType              `path:"peer-type" module:"openconfig-bgp"`
	RemovePrivateAs  E_OpenconfigBgp_RemovePrivateAsOption `path:"remove-private-as" module:"openconfig-bgp"`
	RouteFlapDamping *bool                                 `path:"route-flap-damping" module:"openconfig-bgp"`
	SendCommunity    E_OpenconfigBgp_CommunityType         `path:"send-community" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop represents the /openconfig-bgp/bgp/peer-groups/peer-group/ebgp-multihop YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/ebgp-multihop/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_Config struct {
	Enabled     *bool  `path:"enabled" module:"openconfig-bgp"`
	MultihopTtl *uint8 `path:"multihop-ttl" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/ebgp-multihop/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_State struct {
	Enabled     *bool  `path:"enabled" module:"openconfig-bgp"`
	MultihopTtl *uint8 `path:"multihop-ttl" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EbgpMultihop_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd represents the /openconfig-bgp/bgp/peer-groups/peer-group/enable-bfd YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/enable-bfd/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/enable-bfd/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_State struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_EnableBfd_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling represents the /openconfig-bgp/bgp/peer-groups/peer-group/error-handling YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/error-handling/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_Config struct {
	TreatAsWithdraw *bool `path:"treat-as-withdraw" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/error-handling/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_State struct {
	TreatAsWithdraw *bool `path:"treat-as-withdraw" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_ErrorHandling_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart represents the /openconfig-bgp/bgp/peer-groups/peer-group/graceful-restart YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/graceful-restart/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_Config struct {
	Enabled         *bool    `path:"enabled" module:"openconfig-bgp"`
	HelperOnly      *bool    `path:"helper-only" module:"openconfig-bgp"`
	RestartTime     *uint16  `path:"restart-time" module:"openconfig-bgp"`
	StaleRoutesTime *float64 `path:"stale-routes-time" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/graceful-restart/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_State struct {
	Enabled         *bool    `path:"enabled" module:"openconfig-bgp"`
	HelperOnly      *bool    `path:"helper-only" module:"openconfig-bgp"`
	RestartTime     *uint16  `path:"restart-time" module:"openconfig-bgp"`
	StaleRoutesTime *float64 `path:"stale-routes-time" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_GracefulRestart_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions represents the /openconfig-bgp/bgp/peer-groups/peer-group/logging-options YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/logging-options/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_Config struct {
	LogNeighborStateChanges *bool `path:"log-neighbor-state-changes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/logging-options/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_State struct {
	LogNeighborStateChanges *bool `path:"log-neighbor-state-changes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_LoggingOptions_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector represents the /openconfig-bgp/bgp/peer-groups/peer-group/route-reflector YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/route-reflector/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config struct {
	RouteReflectorClient    *bool                                                                                      `path:"route-reflector-client" module:"openconfig-bgp"`
	RouteReflectorClusterId OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union `path:"route-reflector-cluster-id" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-bgp/bgp/peer-groups/peer-group/route-reflector/config/route-reflector-cluster-id within the YANG schema.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union interface {
	Is_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union()
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union_String is used when /openconfig-bgp/bgp/peer-groups/peer-group/route-reflector/config/route-reflector-cluster-id
// is to be set to a string value.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union_String struct {
	String string
}

// Is_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union_String
// implements the OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union interface.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union_String) Is_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union() {
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union_Uint32 is used when /openconfig-bgp/bgp/peer-groups/peer-group/route-reflector/config/route-reflector-cluster-id
// is to be set to a uint32 value.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union_Uint32 struct {
	Uint32 uint32
}

// Is_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union_Uint32
// implements the OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union interface.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union_Uint32) Is_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union() {
}

// To_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config) To_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union(i interface{}) (OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union, error) {
	switch v := i.(type) {
	case string:
		return &OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union_String{v}, nil
	case uint32:
		return &OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union_Uint32{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_Config_RouteReflectorClusterId_Union, unknown union type, got: %T, want any of [string, uint32]", i, i)
	}
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/route-reflector/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State struct {
	RouteReflectorClient    *bool                                                                                     `path:"route-reflector-client" module:"openconfig-bgp"`
	RouteReflectorClusterId OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union `path:"route-reflector-cluster-id" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-bgp/bgp/peer-groups/peer-group/route-reflector/state/route-reflector-cluster-id within the YANG schema.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union interface {
	Is_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union()
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union_String is used when /openconfig-bgp/bgp/peer-groups/peer-group/route-reflector/state/route-reflector-cluster-id
// is to be set to a string value.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union_String struct {
	String string
}

// Is_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union_String
// implements the OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union interface.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union_String) Is_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union() {
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union_Uint32 is used when /openconfig-bgp/bgp/peer-groups/peer-group/route-reflector/state/route-reflector-cluster-id
// is to be set to a uint32 value.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union_Uint32 struct {
	Uint32 uint32
}

// Is_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union_Uint32
// implements the OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union interface.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union_Uint32) Is_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union() {
}

// To_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State) To_OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union(i interface{}) (OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union, error) {
	switch v := i.(type) {
	case string:
		return &OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union_String{v}, nil
	case uint32:
		return &OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union_Uint32{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigBgp_Bgp_PeerGroups_PeerGroup_RouteReflector_State_RouteReflectorClusterId_Union, unknown union type, got: %T, want any of [string, uint32]", i, i)
	}
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_State struct {
	AuthPassword     *string                               `path:"auth-password" module:"openconfig-bgp"`
	Description      *string                               `path:"description" module:"openconfig-bgp"`
	LocalAs          *uint32                               `path:"local-as" module:"openconfig-bgp"`
	PeerAs           *uint32                               `path:"peer-as" module:"openconfig-bgp"`
	PeerGroupName    *string                               `path:"peer-group-name" module:"openconfig-bgp"`
	PeerType         E_OpenconfigBgp_PeerType              `path:"peer-type" module:"openconfig-bgp"`
	RemovePrivateAs  E_OpenconfigBgp_RemovePrivateAsOption `path:"remove-private-as" module:"openconfig-bgp"`
	RouteFlapDamping *bool                                 `path:"route-flap-damping" module:"openconfig-bgp"`
	SendCommunity    E_OpenconfigBgp_CommunityType         `path:"send-community" module:"openconfig-bgp"`
	TotalPaths       *uint32                               `path:"total-paths" module:"openconfig-bgp"`
	TotalPrefixes    *uint32                               `path:"total-prefixes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers represents the /openconfig-bgp/bgp/peer-groups/peer-group/timers YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/timers/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_Config struct {
	ConnectRetry                 *float64 `path:"connect-retry" module:"openconfig-bgp"`
	HoldTime                     *float64 `path:"hold-time" module:"openconfig-bgp"`
	KeepaliveInterval            *float64 `path:"keepalive-interval" module:"openconfig-bgp"`
	MinimumAdvertisementInterval *float64 `path:"minimum-advertisement-interval" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/timers/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_State struct {
	ConnectRetry                 *float64 `path:"connect-retry" module:"openconfig-bgp"`
	HoldTime                     *float64 `path:"hold-time" module:"openconfig-bgp"`
	KeepaliveInterval            *float64 `path:"keepalive-interval" module:"openconfig-bgp"`
	MinimumAdvertisementInterval *float64 `path:"minimum-advertisement-interval" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Timers_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport represents the /openconfig-bgp/bgp/peer-groups/peer-group/transport YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/transport/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_Config struct {
	LocalAddress *string `path:"local-address" module:"openconfig-bgp"`
	MtuDiscovery *bool   `path:"mtu-discovery" module:"openconfig-bgp"`
	PassiveMode  *bool   `path:"passive-mode" module:"openconfig-bgp"`
	TcpMss       *uint16 `path:"tcp-mss" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/transport/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_State struct {
	LocalAddress *string `path:"local-address" module:"openconfig-bgp"`
	MtuDiscovery *bool   `path:"mtu-discovery" module:"openconfig-bgp"`
	PassiveMode  *bool   `path:"passive-mode" module:"openconfig-bgp"`
	TcpMss       *uint16 `path:"tcp-mss" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_Transport_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths represents the /openconfig-bgp/bgp/peer-groups/peer-group/use-multiple-paths YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Config `path:"config" module:"openconfig-bgp"`
	Ebgp   *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp   `path:"ebgp" module:"openconfig-bgp"`
	Ibgp   *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp   `path:"ibgp" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/use-multiple-paths/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Config struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp represents the /openconfig-bgp/bgp/peer-groups/peer-group/use-multiple-paths/ebgp YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/use-multiple-paths/ebgp/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_Config struct {
	AllowMultipleAs *bool   `path:"allow-multiple-as" module:"openconfig-bgp"`
	MaximumPaths    *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/use-multiple-paths/ebgp/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_State struct {
	AllowMultipleAs *bool   `path:"allow-multiple-as" module:"openconfig-bgp"`
	MaximumPaths    *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ebgp_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp represents the /openconfig-bgp/bgp/peer-groups/peer-group/use-multiple-paths/ibgp YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp struct {
	Config *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_Config `path:"config" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_Config represents the /openconfig-bgp/bgp/peer-groups/peer-group/use-multiple-paths/ibgp/config YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_Config struct {
	MaximumPaths *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_Config) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_Config) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/use-multiple-paths/ibgp/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_State struct {
	MaximumPaths *uint32 `path:"maximum-paths" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_Ibgp_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_State represents the /openconfig-bgp/bgp/peer-groups/peer-group/use-multiple-paths/state YANG schema element.
type OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_State struct {
	Enabled *bool `path:"enabled" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_PeerGroups_PeerGroup_UseMultiplePaths_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib represents the /openconfig-bgp/bgp/rib YANG schema element.
type OpenconfigBgp_Bgp_Rib struct {
	AfiSafis       *OpenconfigBgp_Bgp_Rib_AfiSafis       `path:"afi-safis" module:"openconfig-bgp"`
	AttrSets       *OpenconfigBgp_Bgp_Rib_AttrSets       `path:"attr-sets" module:"openconfig-bgp"`
	Communities    *OpenconfigBgp_Bgp_Rib_Communities    `path:"communities" module:"openconfig-bgp"`
	ExtCommunities *OpenconfigBgp_Bgp_Rib_ExtCommunities `path:"ext-communities" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// OpenconfigBgp_Bgp_Rib_AfiSafis represents the /openconfig-bgp/bgp/rib/afi-safis YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis struct {
	AfiSafi map[E_OpenconfigBgpTypes_AFI_SAFI_TYPE]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi `path:"afi-safi" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis) IsYANGGoStruct() {}

// NewAfiSafi creates a new entry in the AfiSafi list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis) NewAfiSafi(AfiSafiName E_OpenconfigBgpTypes_AFI_SAFI_TYPE) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.AfiSafi == nil {
		t.AfiSafi = make(map[E_OpenconfigBgpTypes_AFI_SAFI_TYPE]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi)
	}

	key := AfiSafiName

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.AfiSafi[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list AfiSafi", key)
	}

	t.AfiSafi[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi{
		AfiSafiName: AfiSafiName,
	}

	return t.AfiSafi[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi struct {
	AfiSafiName    E_OpenconfigBgpTypes_AFI_SAFI_TYPE                     `path:"afi-safi-name" module:"openconfig-bgp"`
	Ipv4SrtePolicy *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy `path:"ipv4-srte-policy" module:"openconfig-bgp"`
	Ipv4Unicast    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast    `path:"ipv4-unicast" module:"openconfig-bgp"`
	Ipv6SrtePolicy *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy `path:"ipv6-srte-policy" module:"openconfig-bgp"`
	Ipv6Unicast    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6Unicast    `path:"ipv6-unicast" module:"openconfig-bgp"`
	State          *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_State          `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"afi-safi-name": t.AfiSafiName,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy struct {
	LocRib    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib    `path:"loc-rib" module:"openconfig-bgp"`
	Neighbors *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors `path:"neighbors" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/loc-rib YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes `path:"routes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/loc-rib/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes) IsYANGGoStruct() {}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/loc-rib/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_Key struct {
	PathId   uint32 `path:"path-id"`
	Endpoint string `path:"endpoint"`
	Color    uint32 `path:"color"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes) NewRoute(PathId uint32, Endpoint string, Color uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_Key{
		PathId:   PathId,
		Endpoint: Endpoint,
		Color:    Color,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route{
		PathId:   &PathId,
		Endpoint: &Endpoint,
		Color:    &Color,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/loc-rib/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route struct {
	Color             *uint32                                                                                      `path:"color" module:"openconfig-bgp"`
	Endpoint          *string                                                                                      `path:"endpoint" module:"openconfig-bgp"`
	PathId            *uint32                                                                                      `path:"path-id" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Color == nil {
		return nil, fmt.Errorf("nil value for key Color")
	}

	if t.Endpoint == nil {
		return nil, fmt.Errorf("nil value for key Endpoint")
	}

	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	return map[string]interface{}{
		"color":    *t.Color,
		"endpoint": *t.Endpoint,
		"path-id":  *t.PathId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/loc-rib/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	Color             *uint32                                      `path:"color" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	Endpoint          *string                                      `path:"endpoint" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/loc-rib/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/loc-rib/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                              `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/loc-rib/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors struct {
	Neighbor map[string]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor `path:"neighbor" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors) NewNeighbor(NeighborAddress string) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor)
	}

	key := NeighborAddress

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor{
		NeighborAddress: &NeighborAddress,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor struct {
	AdjRibInPost    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost  `path:"adj-rib-in-post" module:"openconfig-bgp"`
	AdjRibInPre     *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre   `path:"adj-rib-in-pre" module:"openconfig-bgp"`
	AdjRibOutPost   *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost `path:"adj-rib-out-post" module:"openconfig-bgp"`
	AdjRibOutPre    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre  `path:"adj-rib-out-pre" module:"openconfig-bgp"`
	NeighborAddress *string                                                                                 `path:"neighbor-address" module:"openconfig-bgp"`
	State           *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_State         `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.NeighborAddress == nil {
		return nil, fmt.Errorf("nil value for key NeighborAddress")
	}

	return map[string]interface{}{
		"neighbor-address": *t.NeighborAddress,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-post YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes `path:"routes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-post/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes) IsYANGGoStruct() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-post/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key struct {
	PathId   uint32 `path:"path-id"`
	Endpoint string `path:"endpoint"`
	Color    uint32 `path:"color"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes) NewRoute(PathId uint32, Endpoint string, Color uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key{
		PathId:   PathId,
		Endpoint: Endpoint,
		Color:    Color,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route{
		PathId:   &PathId,
		Endpoint: &Endpoint,
		Color:    &Color,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-post/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route struct {
	Color             *uint32                                                                                                               `path:"color" module:"openconfig-bgp"`
	Endpoint          *string                                                                                                               `path:"endpoint" module:"openconfig-bgp"`
	PathId            *uint32                                                                                                               `path:"path-id" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Color == nil {
		return nil, fmt.Errorf("nil value for key Color")
	}

	if t.Endpoint == nil {
		return nil, fmt.Errorf("nil value for key Endpoint")
	}

	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	return map[string]interface{}{
		"color":    *t.Color,
		"endpoint": *t.Endpoint,
		"path-id":  *t.PathId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-post/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	BestPath          *bool                                        `path:"best-path" module:"openconfig-bgp"`
	Color             *uint32                                      `path:"color" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	Endpoint          *string                                      `path:"endpoint" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-post/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-post/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                                                       `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-post/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-pre YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes `path:"routes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes) IsYANGGoStruct() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key struct {
	PathId   uint32 `path:"path-id"`
	Endpoint string `path:"endpoint"`
	Color    uint32 `path:"color"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes) NewRoute(PathId uint32, Endpoint string, Color uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key{
		PathId:   PathId,
		Endpoint: Endpoint,
		Color:    Color,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route{
		PathId:   &PathId,
		Endpoint: &Endpoint,
		Color:    &Color,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route struct {
	Color             *uint32                                                                                                              `path:"color" module:"openconfig-bgp"`
	Endpoint          *string                                                                                                              `path:"endpoint" module:"openconfig-bgp"`
	PathId            *uint32                                                                                                              `path:"path-id" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Color == nil {
		return nil, fmt.Errorf("nil value for key Color")
	}

	if t.Endpoint == nil {
		return nil, fmt.Errorf("nil value for key Endpoint")
	}

	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	return map[string]interface{}{
		"color":    *t.Color,
		"endpoint": *t.Endpoint,
		"path-id":  *t.PathId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	Color             *uint32                                      `path:"color" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	Endpoint          *string                                      `path:"endpoint" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                                                      `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-post YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes `path:"routes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-post/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes) IsYANGGoStruct() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-post/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_Key struct {
	PathId   uint32 `path:"path-id"`
	Endpoint string `path:"endpoint"`
	Color    uint32 `path:"color"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes) NewRoute(PathId uint32, Endpoint string, Color uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_Key{
		PathId:   PathId,
		Endpoint: Endpoint,
		Color:    Color,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route{
		PathId:   &PathId,
		Endpoint: &Endpoint,
		Color:    &Color,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-post/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route struct {
	Color             *uint32                                                                                                                `path:"color" module:"openconfig-bgp"`
	Endpoint          *string                                                                                                                `path:"endpoint" module:"openconfig-bgp"`
	PathId            *uint32                                                                                                                `path:"path-id" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Color == nil {
		return nil, fmt.Errorf("nil value for key Color")
	}

	if t.Endpoint == nil {
		return nil, fmt.Errorf("nil value for key Endpoint")
	}

	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	return map[string]interface{}{
		"color":    *t.Color,
		"endpoint": *t.Endpoint,
		"path-id":  *t.PathId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-post/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	Color             *uint32                                      `path:"color" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	Endpoint          *string                                      `path:"endpoint" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-post/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-post/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                                                        `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-post/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-pre YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes `path:"routes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-pre/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes) IsYANGGoStruct() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-pre/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_Key struct {
	PathId   uint32 `path:"path-id"`
	Endpoint string `path:"endpoint"`
	Color    uint32 `path:"color"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes) NewRoute(PathId uint32, Endpoint string, Color uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_Key{
		PathId:   PathId,
		Endpoint: Endpoint,
		Color:    Color,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route{
		PathId:   &PathId,
		Endpoint: &Endpoint,
		Color:    &Color,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-pre/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route struct {
	Color             *uint32                                                                                                               `path:"color" module:"openconfig-bgp"`
	Endpoint          *string                                                                                                               `path:"endpoint" module:"openconfig-bgp"`
	PathId            *uint32                                                                                                               `path:"path-id" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Color == nil {
		return nil, fmt.Errorf("nil value for key Color")
	}

	if t.Endpoint == nil {
		return nil, fmt.Errorf("nil value for key Endpoint")
	}

	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	return map[string]interface{}{
		"color":    *t.Color,
		"endpoint": *t.Endpoint,
		"path-id":  *t.PathId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-pre/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	Color             *uint32                                      `path:"color" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	Endpoint          *string                                      `path:"endpoint" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-pre/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-pre/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                                                       `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/adj-rib-out-pre/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-srte-policy/neighbors/neighbor/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_State struct {
	NeighborAddress *string `path:"neighbor-address" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4SrtePolicy_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast struct {
	LocRib    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib    `path:"loc-rib" module:"openconfig-bgp"`
	Neighbors *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors `path:"neighbors" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes `path:"routes" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes) IsYANGGoStruct() {}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_Key struct {
	Prefix string                                                                                    `path:"prefix"`
	Origin OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union `path:"origin"`
	PathId uint32                                                                                    `path:"path-id"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes) NewRoute(Prefix string, Origin OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union, PathId uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_Key{
		Prefix: Prefix,
		Origin: Origin,
		PathId: PathId,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route{
		Prefix: &Prefix,
		Origin: Origin,
		PathId: &PathId,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route struct {
	Origin            OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union `path:"origin" module:"openconfig-bgp"`
	PathId            *uint32                                                                                   `path:"path-id" module:"openconfig-bgp"`
	Prefix            *string                                                                                   `path:"prefix" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {

	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"origin":  t.Origin,
		"path-id": *t.PathId,
		"prefix":  *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/routes/route/origin within the YANG schema.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union interface {
	Is_OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union()
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE is used when /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/routes/route/origin
// is to be set to a E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE value.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE struct {
	E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE
}

// Is_OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE
// implements the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union interface.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE) Is_OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_String is used when /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/routes/route/origin
// is to be set to a string value.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_String struct {
	String string
}

// Is_OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_String
// implements the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union interface.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_String) Is_OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union() {
}

// To_OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route) To_OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union(i interface{}) (OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE:
		return &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE{v}, nil
	case string:
		return &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union, unknown union type, got: %T, want any of [E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE, string]", i, i)
	}
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State struct {
	AttrIndex         *uint64                                                                                   `path:"attr-index" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                                                                   `path:"community-index" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                                                                   `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON                                              `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                                                                   `path:"last-modified" module:"openconfig-bgp"`
	Origin            OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union `path:"origin" module:"openconfig-bgp"`
	PathId            *uint32                                                                                   `path:"path-id" module:"openconfig-bgp"`
	Prefix            *string                                                                                   `path:"prefix" module:"openconfig-bgp"`
	ValidRoute        *bool                                                                                     `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// To_OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State) To_OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union(i interface{}) (OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE:
		return &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE{v}, nil
	case string:
		return &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_State_Origin_Union, unknown union type, got: %T, want any of [E_OpenconfigPolicyTypes_INSTALL_PROTOCOL_TYPE, string]", i, i)
	}
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                           `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/loc-rib/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_State struct {
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_LocRib_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors struct {
	Neighbor map[string]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor `path:"neighbor" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors) NewNeighbor(NeighborAddress string) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor)
	}

	key := NeighborAddress

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor{
		NeighborAddress: &NeighborAddress,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor struct {
	AdjRibInPost    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost  `path:"adj-rib-in-post" module:"openconfig-bgp"`
	AdjRibInPre     *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre   `path:"adj-rib-in-pre" module:"openconfig-bgp"`
	AdjRibOutPost   *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost `path:"adj-rib-out-post" module:"openconfig-bgp"`
	AdjRibOutPre    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre  `path:"adj-rib-out-pre" module:"openconfig-bgp"`
	NeighborAddress *string                                                                              `path:"neighbor-address" module:"openconfig-bgp"`
	State           *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_State         `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.NeighborAddress == nil {
		return nil, fmt.Errorf("nil value for key NeighborAddress")
	}

	return map[string]interface{}{
		"neighbor-address": *t.NeighborAddress,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-post YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes `path:"routes" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-post/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes) IsYANGGoStruct() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-post/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key struct {
	Prefix string `path:"prefix"`
	PathId uint32 `path:"path-id"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes) NewRoute(Prefix string, PathId uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key{
		Prefix: Prefix,
		PathId: PathId,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route{
		Prefix: &Prefix,
		PathId: &PathId,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-post/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route struct {
	PathId            *uint32                                                                                                            `path:"path-id" module:"openconfig-bgp"`
	Prefix            *string                                                                                                            `path:"prefix" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"path-id": *t.PathId,
		"prefix":  *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-post/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	BestPath          *bool                                        `path:"best-path" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	Prefix            *string                                      `path:"prefix" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-post/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-post/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                                                    `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-post/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-post/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_State struct {
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPost_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-pre YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes `path:"routes" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-pre/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes) IsYANGGoStruct() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-pre/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key struct {
	Prefix string `path:"prefix"`
	PathId uint32 `path:"path-id"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes) NewRoute(Prefix string, PathId uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key{
		Prefix: Prefix,
		PathId: PathId,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route{
		Prefix: &Prefix,
		PathId: &PathId,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-pre/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route struct {
	PathId            *uint32                                                                                                           `path:"path-id" module:"openconfig-bgp"`
	Prefix            *string                                                                                                           `path:"prefix" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"path-id": *t.PathId,
		"prefix":  *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-pre/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	Prefix            *string                                      `path:"prefix" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-pre/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-pre/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                                                   `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-pre/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-in-pre/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_State struct {
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibInPre_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-post YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes `path:"routes" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-post/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes) IsYANGGoStruct() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-post/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_Key struct {
	Prefix string `path:"prefix"`
	PathId uint32 `path:"path-id"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes) NewRoute(Prefix string, PathId uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_Key{
		Prefix: Prefix,
		PathId: PathId,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route{
		Prefix: &Prefix,
		PathId: &PathId,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-post/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route struct {
	PathId            *uint32                                                                                                             `path:"path-id" module:"openconfig-bgp"`
	Prefix            *string                                                                                                             `path:"prefix" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"path-id": *t.PathId,
		"prefix":  *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-post/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	Prefix            *string                                      `path:"prefix" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-post/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-post/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                                                     `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-post/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-post/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_State struct {
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPost_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-pre YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes `path:"routes" module:"openconfig-bgp"`
	State  *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_State  `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-pre/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes) IsYANGGoStruct() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-pre/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_Key struct {
	Prefix string `path:"prefix"`
	PathId uint32 `path:"path-id"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes) NewRoute(Prefix string, PathId uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_Key{
		Prefix: Prefix,
		PathId: PathId,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route{
		Prefix: &Prefix,
		PathId: &PathId,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-pre/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route struct {
	PathId            *uint32                                                                                                            `path:"path-id" module:"openconfig-bgp"`
	Prefix            *string                                                                                                            `path:"prefix" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	if t.Prefix == nil {
		return nil, fmt.Errorf("nil value for key Prefix")
	}

	return map[string]interface{}{
		"path-id": *t.PathId,
		"prefix":  *t.Prefix,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-pre/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	Prefix            *string                                      `path:"prefix" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-pre/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-pre/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                                                    `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-pre/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/adj-rib-out-pre/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_State struct {
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_AdjRibOutPre_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv4-unicast/neighbors/neighbor/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_State struct {
	NeighborAddress *string `path:"neighbor-address" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv4Unicast_Neighbors_Neighbor_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy struct {
	LocRib    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib    `path:"loc-rib" module:"openconfig-bgp"`
	Neighbors *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors `path:"neighbors" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/loc-rib YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes `path:"routes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/loc-rib/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes) IsYANGGoStruct() {}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/loc-rib/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_Key struct {
	PathId   uint32 `path:"path-id"`
	Endpoint string `path:"endpoint"`
	Color    uint32 `path:"color"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes) NewRoute(PathId uint32, Endpoint string, Color uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_Key{
		PathId:   PathId,
		Endpoint: Endpoint,
		Color:    Color,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route{
		PathId:   &PathId,
		Endpoint: &Endpoint,
		Color:    &Color,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/loc-rib/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route struct {
	Color             *uint32                                                                                      `path:"color" module:"openconfig-bgp"`
	Endpoint          *string                                                                                      `path:"endpoint" module:"openconfig-bgp"`
	PathId            *uint32                                                                                      `path:"path-id" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Color == nil {
		return nil, fmt.Errorf("nil value for key Color")
	}

	if t.Endpoint == nil {
		return nil, fmt.Errorf("nil value for key Endpoint")
	}

	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	return map[string]interface{}{
		"color":    *t.Color,
		"endpoint": *t.Endpoint,
		"path-id":  *t.PathId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/loc-rib/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	Color             *uint32                                      `path:"color" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	Endpoint          *string                                      `path:"endpoint" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/loc-rib/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/loc-rib/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                              `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/loc-rib/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_LocRib_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors struct {
	Neighbor map[string]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor `path:"neighbor" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors) IsYANGGoStruct() {}

// NewNeighbor creates a new entry in the Neighbor list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors) NewNeighbor(NeighborAddress string) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Neighbor == nil {
		t.Neighbor = make(map[string]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor)
	}

	key := NeighborAddress

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Neighbor[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Neighbor", key)
	}

	t.Neighbor[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor{
		NeighborAddress: &NeighborAddress,
	}

	return t.Neighbor[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor struct {
	AdjRibInPost    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost  `path:"adj-rib-in-post" module:"openconfig-bgp"`
	AdjRibInPre     *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre   `path:"adj-rib-in-pre" module:"openconfig-bgp"`
	AdjRibOutPost   *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibOutPost `path:"adj-rib-out-post" module:"openconfig-bgp"`
	AdjRibOutPre    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibOutPre  `path:"adj-rib-out-pre" module:"openconfig-bgp"`
	NeighborAddress *string                                                                                 `path:"neighbor-address" module:"openconfig-bgp"`
	State           *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_State         `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor) ΛListKeyMap() (map[string]interface{}, error) {
	if t.NeighborAddress == nil {
		return nil, fmt.Errorf("nil value for key NeighborAddress")
	}

	return map[string]interface{}{
		"neighbor-address": *t.NeighborAddress,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-post YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes `path:"routes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-post/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes) IsYANGGoStruct() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-post/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key struct {
	PathId   uint32 `path:"path-id"`
	Endpoint string `path:"endpoint"`
	Color    uint32 `path:"color"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes) NewRoute(PathId uint32, Endpoint string, Color uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_Key{
		PathId:   PathId,
		Endpoint: Endpoint,
		Color:    Color,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route{
		PathId:   &PathId,
		Endpoint: &Endpoint,
		Color:    &Color,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-post/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route struct {
	Color             *uint32                                                                                                               `path:"color" module:"openconfig-bgp"`
	Endpoint          *string                                                                                                               `path:"endpoint" module:"openconfig-bgp"`
	PathId            *uint32                                                                                                               `path:"path-id" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Color == nil {
		return nil, fmt.Errorf("nil value for key Color")
	}

	if t.Endpoint == nil {
		return nil, fmt.Errorf("nil value for key Endpoint")
	}

	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	return map[string]interface{}{
		"color":    *t.Color,
		"endpoint": *t.Endpoint,
		"path-id":  *t.PathId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-post/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	BestPath          *bool                                        `path:"best-path" module:"openconfig-bgp"`
	Color             *uint32                                      `path:"color" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	Endpoint          *string                                      `path:"endpoint" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-post/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-post/routes/route/unknown-attributes/unknown-attribute YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute struct {
	AttrType *uint8                                                                                                                                       `path:"attr-type" module:"openconfig-bgp"`
	State    *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State `path:"state" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) ΛListKeyMap() (map[string]interface{}, error) {
	if t.AttrType == nil {
		return nil, fmt.Errorf("nil value for key AttrType")
	}

	return map[string]interface{}{
		"attr-type": *t.AttrType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-post/routes/route/unknown-attributes/unknown-attribute/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State struct {
	AttrLen    *uint16 `path:"attr-len" module:"openconfig-bgp"`
	AttrType   *uint8  `path:"attr-type" module:"openconfig-bgp"`
	AttrValue  Binary  `path:"attr-value" module:"openconfig-bgp"`
	Extended   *bool   `path:"extended" module:"openconfig-bgp"`
	Optional   *bool   `path:"optional" module:"openconfig-bgp"`
	Partial    *bool   `path:"partial" module:"openconfig-bgp"`
	Transitive *bool   `path:"transitive" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPost_Routes_Route_UnknownAttributes_UnknownAttribute_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-pre YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre struct {
	Routes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes `path:"routes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes struct {
	Route map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route `path:"route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes) IsYANGGoStruct() {
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key represents the key for list Route of element /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key struct {
	PathId   uint32 `path:"path-id"`
	Endpoint string `path:"endpoint"`
	Color    uint32 `path:"color"`
}

// NewRoute creates a new entry in the Route list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes) NewRoute(PathId uint32, Endpoint string, Color uint32) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Route == nil {
		t.Route = make(map[OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route)
	}

	key := OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_Key{
		PathId:   PathId,
		Endpoint: Endpoint,
		Color:    Color,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Route[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Route", key)
	}

	t.Route[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route{
		PathId:   &PathId,
		Endpoint: &Endpoint,
		Color:    &Color,
	}

	return t.Route[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes/route YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route struct {
	Color             *uint32                                                                                                              `path:"color" module:"openconfig-bgp"`
	Endpoint          *string                                                                                                              `path:"endpoint" module:"openconfig-bgp"`
	PathId            *uint32                                                                                                              `path:"path-id" module:"openconfig-bgp"`
	State             *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State             `path:"state" module:"openconfig-bgp"`
	UnknownAttributes *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes `path:"unknown-attributes" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route) IsYANGGoStruct() {
}

// ΛListKeyMap returns the keys of the OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route struct, which is a YANG list entry.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Color == nil {
		return nil, fmt.Errorf("nil value for key Color")
	}

	if t.Endpoint == nil {
		return nil, fmt.Errorf("nil value for key Endpoint")
	}

	if t.PathId == nil {
		return nil, fmt.Errorf("nil value for key PathId")
	}

	return map[string]interface{}{
		"color":    *t.Color,
		"endpoint": *t.Endpoint,
		"path-id":  *t.PathId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes/route/state YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State struct {
	AttrIndex         *uint64                                      `path:"attr-index" module:"openconfig-bgp"`
	Color             *uint32                                      `path:"color" module:"openconfig-bgp"`
	CommunityIndex    *uint64                                      `path:"community-index" module:"openconfig-bgp"`
	Endpoint          *string                                      `path:"endpoint" module:"openconfig-bgp"`
	ExtCommunityIndex *uint64                                      `path:"ext-community-index" module:"openconfig-bgp"`
	InvalidReason     E_OpenconfigRibBgpTypes_INVALID_ROUTE_REASON `path:"invalid-reason" module:"openconfig-bgp"`
	LastModified      *uint64                                      `path:"last-modified" module:"openconfig-bgp"`
	PathId            *uint32                                      `path:"path-id" module:"openconfig-bgp"`
	ValidRoute        *bool                                        `path:"valid-route" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State) IsYANGGoStruct() {
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_State) ΛEnumTypeMap() map[string][]reflect.Type {
	return ΛEnumTypes
}

// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes represents the /openconfig-bgp/bgp/rib/afi-safis/afi-safi/ipv6-srte-policy/neighbors/neighbor/adj-rib-in-pre/routes/route/unknown-attributes YANG schema element.
type OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes struct {
	UnknownAttribute map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute `path:"unknown-attribute" module:"openconfig-bgp"`
}

// IsYANGGoStruct ensures that OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) IsYANGGoStruct() {
}

// NewUnknownAttribute creates a new entry in the UnknownAttribute list of the
// OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) NewUnknownAttribute(AttrType uint8) (*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.UnknownAttribute == nil {
		t.UnknownAttribute = make(map[uint8]*OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute)
	}

	key := AttrType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.UnknownAttribute[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list UnknownAttribute", key)
	}

	t.UnknownAttribute[key] = &OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes_UnknownAttribute{
		AttrType: &AttrType,
	}

	return t.UnknownAttribute[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes) Validate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigBgp_Bgp_Rib_AfiSafis_AfiSafi_Ipv6SrtePolicy_Neighbors_Neighbor_AdjRibInPre_Routes_Route_UnknownAttributes