ARG GOLANG_VERSION=1.20.1
ARG BUILDARGS
ARG $GITLAB_PROXY

FROM ${GITLAB_PROXY}golang:$GOLANG_VERSION-alpine AS builder
WORKDIR /gosdn/
RUN apk add build-base
COPY ./models ./models
COPY ./forks ./forks
COPY ./Makefile .
COPY ./api ./api
COPY ./controller ./controller
COPY ./csbi ./csbi
COPY go.* ./
RUN --mount=type=cache,target=/root/go/pkg/mod \
    --mount=type=cache,target=/root/.cache/go-build \
    make build-orchestrator

FROM ${GITLAB_PROXY}golang:$GOLANG_VERSION-alpine
RUN apk add --no-cache git make build-base
RUN apk add --update --no-cache alpine-sdk
COPY --from=builder gosdn/artifacts/orchestrator .
COPY --from=builder gosdn/csbi/resources ./resources
COPY --from=builder gosdn/models/arista/EOS-4.27.2F ./models/arista
COPY --from=builder gosdn/models/YangModels/standard/ietf/RFC ./models/IETF
EXPOSE 55056
ENTRYPOINT [ "./orchestrator" ]
CMD [""]
