package routingtables

import "github.com/google/uuid"

// RoutingTable is the routing table of a network element.
type RoutingTable struct {
	ID     uuid.UUID `bson:"_id"`
	NodeID uuid.UUID `bson:"node_id"`
	Routes []Route   `bson:"routes"`
}

// GetID returns the id of a routingtable.
func (r RoutingTable) GetID() uuid.UUID {
	return r.ID
}
