package routingtables

import (
	"code.fbi.h-da.de/danet/gosdn/controller/conflict"
	"github.com/google/uuid"
)

// Route is a routing table entry on a network element.
type Route struct {
	ID            uuid.UUID         `bson:"_id"`
	Metadata      conflict.Metadata `bson:"metadata"`
	TargetIPRange string            `bson:"target_ip_range"`
	NextHopIP     string            `bson:"next_hop_ip"`
	PortID        uuid.UUID         `bson:"port_id"`
	Metric        string            `bson:"metric"`
}
