package ports

import (
	"code.fbi.h-da.de/danet/gosdn/controller/conflict"
	"code.fbi.h-da.de/danet/gosdn/controller/topology/ports/configuration"
	"github.com/google/uuid"
)

// Port is a representation of physical port on a network element.
type Port struct {
	ID            uuid.UUID              `bson:"_id"`
	Metadata      conflict.Metadata      `bson:"metadata"`
	Name          string                 `bson:"name,omitempty"`
	Configuration configuration.IPConfig `bson:"configuration,omitempty"`
}

// GetID returns the id of a port.
func (p Port) GetID() uuid.UUID {
	return p.ID
}
