package configuration

import (
	"fmt"
	"net"
)

// IPConfig represents an interface configuration for a cEOS instance.
type IPConfig struct {
	IP           net.IP `bson:"ip,omitempty"`
	PrefixLength int64  `bson:"prefix_length,omitempty"`
}

// New creates a new IPConfig.
func New(ip string, prefixLength int64) (IPConfig, error) {
	newIPConfig := IPConfig{}
	parsedIP := net.ParseIP(ip)
	if parsedIP == nil {
		return newIPConfig, fmt.Errorf("%s can not be parsed to an IP", ip)
	}

	newIPConfig.IP = parsedIP
	newIPConfig.PrefixLength = prefixLength

	return newIPConfig, nil
}
