package links

import (
	"code.fbi.h-da.de/danet/gosdn/controller/conflict"
	"code.fbi.h-da.de/danet/gosdn/controller/topology/nodes"
	"code.fbi.h-da.de/danet/gosdn/controller/topology/ports"
	"github.com/google/uuid"
)

// Link is a representation of a physical or virtual link between two nodes and their ports.
type Link struct {
	ID         uuid.UUID         `bson:"_id"`
	Metadata   conflict.Metadata `bson:"metadata"`
	Name       string            `bson:"name,omitempty"`
	SourceNode nodes.Node        `bson:"source_node,omitempty"`
	TargetNode nodes.Node        `bson:"target_node,omitempty"`
	SourcePort ports.Port        `bson:"source_port,omitempty"`
	TargetPort ports.Port        `bson:"target_port,omitempty"`
}

// GetID returns the id of a link.
func (l Link) GetID() uuid.UUID {
	return l.ID
}
