/*
Package yang is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was false
in this case).

This package was generated by /home/aps/go/pkg/mod/github.com/openconfig/ygot@v0.18.1/genutil/names.go
using the following YANG input files:
	- test.yang
Imported modules were sourced from:
*/
package yang

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/ygot/ytypes"
)

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

var (
	SchemaTree map[string]*yang.Entry
)

func init() {
	var err error
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " + err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root:       &Device{},
		SchemaTree: uzp,
		Unmarshal:  Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn)
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}

// Device represents the /device YANG schema element.
type Device struct {
	Container1 *Test_Container1 `path:"container1" module:"test"`
	Container2 *Test_Container2 `path:"container2" module:"test"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module in whose namespace
// Device belongs.
func (*Device) ΛBelongingModule() string {
	return ""
}

// Test_Container1 represents the /test/container1 YANG schema element.
type Test_Container1 struct {
	List1 map[string]*Test_Container1_List1 `path:"list1" module:"test"`
}

// IsYANGGoStruct ensures that Test_Container1 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Test_Container1) IsYANGGoStruct() {}

// NewList1 creates a new entry in the List1 list of the
// Test_Container1 struct. The keys of the list are populated from the input
// arguments.
func (t *Test_Container1) NewList1(Leaf1 string) (*Test_Container1_List1, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.List1 == nil {
		t.List1 = make(map[string]*Test_Container1_List1)
	}

	key := Leaf1

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.List1[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list List1", key)
	}

	t.List1[key] = &Test_Container1_List1{
		Leaf1: &Leaf1,
	}

	return t.List1[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Test_Container1) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Test_Container1"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Test_Container1) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Test_Container1) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module in whose namespace
// Test_Container1 belongs.
func (*Test_Container1) ΛBelongingModule() string {
	return "test"
}

// Test_Container1_List1 represents the /test/container1/list1 YANG schema element.
type Test_Container1_List1 struct {
	LeafList1 []string `path:"leaf-list1" module:"test"`
	Leaf1     *string  `path:"leaf1" module:"test"`
	Leaf2     *string  `path:"leaf2" module:"test"`
}

// IsYANGGoStruct ensures that Test_Container1_List1 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Test_Container1_List1) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the Test_Container1_List1 struct, which is a YANG list entry.
func (t *Test_Container1_List1) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Leaf1 == nil {
		return nil, fmt.Errorf("nil value for key Leaf1")
	}

	return map[string]interface{}{
		"leaf1": *t.Leaf1,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Test_Container1_List1) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Test_Container1_List1"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Test_Container1_List1) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Test_Container1_List1) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module in whose namespace
// Test_Container1_List1 belongs.
func (*Test_Container1_List1) ΛBelongingModule() string {
	return "test"
}

// Test_Container2 represents the /test/container2 YANG schema element.
type Test_Container2 struct {
	List1 map[string]*Test_Container2_List1 `path:"list1" module:"test"`
}

// IsYANGGoStruct ensures that Test_Container2 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Test_Container2) IsYANGGoStruct() {}

// NewList1 creates a new entry in the List1 list of the
// Test_Container2 struct. The keys of the list are populated from the input
// arguments.
func (t *Test_Container2) NewList1(Leaf1 string) (*Test_Container2_List1, error) {

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.List1 == nil {
		t.List1 = make(map[string]*Test_Container2_List1)
	}

	key := Leaf1

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.List1[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list List1", key)
	}

	t.List1[key] = &Test_Container2_List1{
		Leaf1: &Leaf1,
	}

	return t.List1[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Test_Container2) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Test_Container2"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Test_Container2) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Test_Container2) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module in whose namespace
// Test_Container2 belongs.
func (*Test_Container2) ΛBelongingModule() string {
	return "test"
}

// Test_Container2_List1 represents the /test/container2/list1 YANG schema element.
type Test_Container2_List1 struct {
	LeafList1 []string `path:"leaf-list1" module:"test"`
	Leaf1     *string  `path:"leaf1" module:"test"`
	Leaf2     *string  `path:"leaf2" module:"test"`
}

// IsYANGGoStruct ensures that Test_Container2_List1 implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Test_Container2_List1) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the Test_Container2_List1 struct, which is a YANG list entry.
func (t *Test_Container2_List1) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Leaf1 == nil {
		return nil, fmt.Errorf("nil value for key Leaf1")
	}

	return map[string]interface{}{
		"leaf1": *t.Leaf1,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Test_Container2_List1) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Test_Container2_List1"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Test_Container2_List1) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Test_Container2_List1) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module in whose namespace
// Test_Container2_List1 belongs.
func (*Test_Container2_List1) ΛBelongingModule() string {
	return "test"
}

var (
	// ySchema is a byte slice contain a gzip compressed representation of the
	// YANG schema from which the Go code was generated. When uncompressed the
	// contents of the byte slice is a JSON document containing an object, keyed
	// on the name of the generated struct, and containing the JSON marshalled
	// contents of a goyang yang.Entry struct, which defines the schema for the
	// fields within the struct.
	ySchema = []byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x59, 0xdf, 0x6f, 0xda, 0x30,
		0x10, 0x7e, 0xcf, 0x5f, 0x61, 0xf9, 0x99, 0x09, 0xe2, 0x41, 0xe9, 0xf2, 0xc6, 0xda, 0x4d, 0x93,
		0xda, 0x6e, 0xd3, 0xd6, 0xf7, 0xca, 0x4a, 0x0e, 0x6a, 0x0d, 0x6c, 0x64, 0x3b, 0x5b, 0xa3, 0x89,
		0xff, 0x7d, 0x22, 0xa1, 0xf9, 0x45, 0x12, 0xdb, 0x30, 0x69, 0x4c, 0xf2, 0x23, 0xf6, 0x5d, 0xee,
		0xbb, 0xfb, 0xee, 0x72, 0xf9, 0xc4, 0xef, 0x00, 0x21, 0x84, 0xf0, 0x67, 0xba, 0x01, 0x1c, 0x21,
		0x9c, 0xc0, 0x4f, 0x16, 0x03, 0x1e, 0x15, 0xa7, 0x77, 0x8c, 0x27, 0x38, 0x42, 0xe1, 0xe1, 0xe7,
		0x8d, 0xe0, 0x4b, 0xb6, 0xc2, 0x11, 0x9a, 0x1c, 0x0e, 0x6e, 0x99, 0xc4, 0x11, 0x2a, 0x1e, 0x91,
		0x1f, 0xc4, 0x82, 0x6b, 0xca, 0x38, 0xc8, 0xb0, 0x71, 0xde, 0x08, 0x51, 0xb3, 0x19, 0x35, 0x2d,
		0x9a, 0xe1, 0xca, 0xe3, 0x76, 0xd8, 0xf2, 0xe2, 0xab, 0x84, 0x25, 0x7b, 0x39, 0x8a, 0xd4, 0x8a,
		0x16, 0xb7, 0xc2, 0xe4, 0xd7, 0xdf, 0x45, 0x2a, 0x63, 0xe8, 0x74, 0x2d, 0xa0, 0x40, 0xf6, 0x4b,
		0xc8, 0x3d, 0x1a, 0xbc, 0x2d, 0xa2, 0x8c, 0xba, 0x0d, 0x3f, 0x51, 0xb5, 0x90, 0xab, 0x74, 0x03,
		0x5c, 0xe3, 0x08, 0x69, 0x99, 0x42, 0x8f, 0x61, 0xcd, 0x2a, 0x07, 0x75, 0x64, 0xb5, 0x6b, 0x9c,
		0xec, 0x5a, 0xb9, 0xb6, 0x4b, 0x5d, 0x5e, 0xac, 0x99, 0xd2, 0x61, 0x7f, 0x22, 0xaf, 0x75, 0x28,
		0xcc, 0x7a, 0xb0, 0x75, 0x17, 0xde, 0x48, 0x80, 0x0d, 0x11, 0x96, 0x84, 0xd8, 0x12, 0xe3, 0x4c,
		0x90, 0x33, 0x51, 0xf6, 0x84, 0x75, 0x13, 0xd7, 0x43, 0xa0, 0x91, 0xc8, 0x8a, 0x50, 0xa0, 0xcb,
		0x37, 0xc3, 0xac, 0x1e, 0xb3, 0x5b, 0xf9, 0x18, 0xb2, 0x3a, 0x50, 0x3d, 0x31, 0x98, 0x95, 0x94,
		0x87, 0x06, 0x43, 0x0b, 0xea, 0x1d, 0x5b, 0xc0, 0xb5, 0x15, 0x4e, 0x6e, 0x89, 0x93, 0x5b, 0xc3,
		0xbd, 0x45, 0x86, 0x5b, 0xc5, 0xd0, 0x32, 0x65, 0xb8, 0xc7, 0x6c, 0x0b, 0x6e, 0x95, 0x56, 0x5a,
		0x32, 0xbe, 0xb2, 0x29, 0xf6, 0xeb, 0x2b, 0xe0, 0xfa, 0x2c, 0x84, 0xf7, 0x4c, 0xe9, 0x85, 0xd6,
		0xd2, 0x0e, 0xe5, 0x03, 0xe3, 0x1f, 0xd6, 0xb0, 0x2f, 0xa0, 0x32, 0xb7, 0x64, 0xe1, 0x41, 0x5f,
		0x6a, 0x1e, 0xe1, 0xf5, 0x74, 0x7a, 0x35, 0x9f, 0x4e, 0x27, 0xf3, 0xb7, 0xf3, 0xc9, 0xbb, 0xd9,
		0x2c, 0xbc, 0x0a, 0x67, 0x16, 0x0f, 0xf9, 0x22, 0x13, 0x90, 0x90, 0xbc, 0xcf, 0x70, 0x84, 0x78,
		0xba, 0x5e, 0x07, 0xa7, 0x31, 0x36, 0x50, 0x8b, 0x7c, 0x1e, 0x1d, 0xc7, 0xf7, 0xaf, 0x4f, 0x2e,
		0xf1, 0x93, 0x7b, 0x31, 0x93, 0xfb, 0x40, 0x79, 0x42, 0xb5, 0x90, 0x99, 0xc5, 0x1b, 0xf5, 0x02,
		0xa6, 0xfc, 0xe4, 0x9e, 0x27, 0x6e, 0x3d, 0x4f, 0xfc, 0xb6, 0xf2, 0xdb, 0xea, 0x9f, 0xf4, 0xb1,
		0xd3, 0x27, 0xdb, 0x1d, 0x64, 0xa6, 0xb7, 0xb4, 0xdd, 0xe6, 0xb3, 0xdf, 0x78, 0x67, 0x6d, 0x3a,
		0xbb, 0x0d, 0xd7, 0x97, 0xed, 0x82, 0x73, 0xa1, 0xa9, 0x66, 0x82, 0x0f, 0xe7, 0xa2, 0xe2, 0x67,
		0xd8, 0xd0, 0x2d, 0xd5, 0xcf, 0xfb, 0xe2, 0x8c, 0x35, 0x28, 0x3d, 0xae, 0xb4, 0xdd, 0xd8, 0xf4,
		0x35, 0xba, 0x67, 0x3b, 0x8d, 0x35, 0x3f, 0x70, 0xff, 0x08, 0x4a, 0x3f, 0xdd, 0x94, 0xee, 0x4f,
		0xf7, 0xb9, 0x7b, 0x60, 0x47, 0xde, 0xb0, 0x74, 0x32, 0x24, 0x64, 0x48, 0xa4, 0x4b, 0x3d, 0x0e,
		0x42, 0x6f, 0x82, 0xae, 0xa0, 0xd5, 0x60, 0x55, 0x1a, 0x98, 0x58, 0xe8, 0x64, 0xe2, 0x75, 0xb2,
		0xd7, 0xc9, 0x5e, 0x27, 0x7b, 0x9d, 0xec, 0xbf, 0x3c, 0xbc, 0x4e, 0xf6, 0x3a, 0xd9, 0xeb, 0x64,
		0xaf, 0x93, 0xbd, 0x4e, 0xf6, 0xdb, 0xca, 0x6f, 0x2b, 0xaf, 0x93, 0xff, 0x7b, 0x9d, 0x4c, 0xce,
		0xd3, 0xc9, 0xe4, 0x62, 0x74, 0x32, 0x71, 0xd5, 0xc9, 0xa4, 0x57, 0x27, 0x07, 0x35, 0x70, 0x7d,
		0xa0, 0x30, 0x53, 0x1f, 0xe9, 0x0f, 0xf8, 0x26, 0xc4, 0xf1, 0x70, 0xb7, 0x81, 0xe2, 0xfa, 0x55,
		0x03, 0xd1, 0x6d, 0xf1, 0x6f, 0x77, 0x11, 0x30, 0xd8, 0xfd, 0x01, 0x00, 0x00, 0xff, 0xff, 0x01,
		0x00, 0x00, 0xff, 0xff, 0x0c, 0xf4, 0xf2, 0x38, 0x0c, 0x1f, 0x00, 0x00,
	}
)

// ΛEnumTypes is a map, keyed by a YANG schema path, of the enumerated types that
// correspond with the leaf. The type is represented as a reflect.Type. The naming
// of the map ensures that there are no clashes with valid YANG identifiers.
var ΛEnumTypes = map[string][]reflect.Type{}
