resource "docker_container" "gosdn" {
  depends_on = [
    docker_container.ceos]
  name = "contoller-${random_id.server.hex}"
  image = docker_image.gosdn.name
  restart = "always"

  networks_advanced {
    name = "ci"
    ipv4_address = var.gosdn_address
  }
}

# create arista container
# namespace is french cheeses
resource "docker_container" "ceos" {
  name  = "ceos-${random_id.server.hex}"
  image = docker_image.ceos.name
  restart = "always"

  networks_advanced {
    name = "ci"
    ipv4_address = var.ceos_address
  }

  command = ["/sbin/init",
    "systemd.setenv=INTFTYPE=eth",
    "systemd.setenv=ETBA=4",
    "systemd.setenv=SKIP_ZEROTOUCH_BARRIER_IN_SYSDBINIT=1",
    "systemd.setenv=CEOS=1",
    "systemd.setenv=EOS_PLATFORM=ceoslab",
    "systemd.setenv=container=docker",
    "MGMT_INTF=eth0"]

  env =     ["INTFTYPE=eth",
    "ETBA=4",
    "SKIP_ZEROTOUCH_BARRIER_IN_SYSDBINIT=1",
    "CEOS=1",
    "EOS_PLATFORM=ceoslab",
    "container=docker",
    "MGMT_INTF=eth0"]
  privileged = true

  volumes {
    host_path = "/usr/local/etc/terraform/arista"
    container_path = "/mnt/flash"
  }
}
