/*
Package main is a generated package which contains definitions
of structs which represent a YANG schema. The generated schema can be
compressed by a series of transformations (compression was false
in this case).

This package was generated by /home/aps/go/pkg/mod/github.com/openconfig/ygot@v0.20.0/genutil/names.go
using the following YANG input files:
	- ../../models/openconfig/release/models/system/openconfig-system.yang
Imported modules were sourced from:
	- ../../models/openconfig/...
*/
package main

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ytypes"
	gpb "github.com/openconfig/gnmi/proto/gnmi"
)

// Binary is a type that is used for fields that have a YANG type of
// binary. It is used such that binary fields can be distinguished from
// leaf-lists of uint8s (which are mapped to []uint8, equivalent to
// []byte in reflection).
type Binary []byte

// YANGEmpty is a type that is used for fields that have a YANG type of
// empty. It is used such that empty fields can be distinguished from boolean fields
// in the generated code.
type YANGEmpty bool

var (
	SchemaTree map[string]*yang.Entry
	ΛEnumTypes map[string][]reflect.Type
)

func init() {
	var err error
	initΛEnumTypes()
	if SchemaTree, err = UnzipSchema(); err != nil {
		panic("schema error: " +  err.Error())
	}
}

// Schema returns the details of the generated schema.
func Schema() (*ytypes.Schema, error) {
	uzp, err := UnzipSchema()
	if err != nil {
		return nil, fmt.Errorf("cannot unzip schema, %v", err)
	}

	return &ytypes.Schema{
		Root: &Device{},
		SchemaTree: uzp,
		Unmarshal: Unmarshal,
	}, nil
}

// UnzipSchema unzips the zipped schema and returns a map of yang.Entry nodes,
// keyed by the name of the struct that the yang.Entry describes the schema for.
func UnzipSchema() (map[string]*yang.Entry, error) {
	var schemaTree map[string]*yang.Entry
	var err error
	if schemaTree, err = ygot.GzipToSchema(ySchema); err != nil {
		return nil, fmt.Errorf("could not unzip the schema; %v", err)
	}
	return schemaTree, nil
}

// Unmarshal unmarshals data, which must be RFC7951 JSON format, into
// destStruct, which must be non-nil and the correct GoStruct type. It returns
// an error if the destStruct is not found in the schema or the data cannot be
// unmarshaled. The supplied options (opts) are used to control the behaviour
// of the unmarshal function - for example, determining whether errors are
// thrown for unknown fields in the input JSON.
func Unmarshal(data []byte, destStruct ygot.GoStruct, opts ...ytypes.UnmarshalOpt) error {
	tn := reflect.TypeOf(destStruct).Elem().Name()
	schema, ok := SchemaTree[tn]
	if !ok {
		return fmt.Errorf("could not find schema for type %s", tn )
	}
	var jsonTree interface{}
	if err := json.Unmarshal([]byte(data), &jsonTree); err != nil {
		return err
	}
	return ytypes.Unmarshal(schema, destStruct, jsonTree, opts...)
}
// ΓModelData contains the catalogue information corresponding to the modules for
// which Go code was generated.
var ΓModelData = []*gpb.ModelData{
    {
		Name: "openconfig-aaa",
		Organization: "OpenConfig working group",
		Version: "0.5.0",
	},
    {
		Name: "openconfig-aaa-types",
		Organization: "OpenConfig working group",
		Version: "0.4.1",
	},
    {
		Name: "openconfig-alarm-types",
		Organization: "OpenConfig working group",
		Version: "0.2.1",
	},
    {
		Name: "openconfig-alarms",
		Organization: "OpenConfig working group",
		Version: "0.3.2",
	},
    {
		Name: "openconfig-extensions",
		Organization: "OpenConfig working group",
	},
    {
		Name: "openconfig-inet-types",
		Organization: "OpenConfig working group",
		Version: "0.5.0",
	},
    {
		Name: "openconfig-license",
		Organization: "OpenConfig working group",
		Version: "0.2.0",
	},
    {
		Name: "openconfig-messages",
		Organization: "OpenConfig working group",
		Version: "0.0.1",
	},
    {
		Name: "openconfig-platform",
		Organization: "OpenConfig working group",
		Version: "0.15.0",
	},
    {
		Name: "openconfig-platform-types",
		Organization: "OpenConfig working group",
		Version: "1.4.0",
	},
    {
		Name: "openconfig-procmon",
		Organization: "OpenConfig working group",
		Version: "0.4.0",
	},
    {
		Name: "openconfig-system",
		Organization: "OpenConfig working group",
		Version: "0.13.0",
	},
    {
		Name: "openconfig-system-logging",
		Organization: "OpenConfig working group",
		Version: "0.3.1",
	},
    {
		Name: "openconfig-system-terminal",
		Organization: "OpenConfig working group",
		Version: "0.3.1",
	},
    {
		Name: "openconfig-types",
		Organization: "OpenConfig working group",
		Version: "0.6.0",
	},
    {
		Name: "openconfig-yang-types",
		Organization: "OpenConfig working group",
		Version: "0.3.1",
	},
}

// Device represents the /device YANG schema element.
type Device struct {
	Components	*OpenconfigPlatform_Components	`path:"components" module:"openconfig-platform"`
	Messages	*OpenconfigMessages_Messages	`path:"messages" module:"openconfig-messages"`
	System	*OpenconfigSystem_System	`path:"system" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that Device implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*Device) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["Device"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *Device) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *Device) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of Device.
func (*Device) ΛBelongingModule() string {
	return ""
}


// OpenconfigMessages_Messages represents the /openconfig-messages/messages YANG schema element.
type OpenconfigMessages_Messages struct {
	Config	*OpenconfigMessages_Messages_Config	`path:"config" module:"openconfig-messages"`
	DebugEntries	*OpenconfigMessages_Messages_DebugEntries	`path:"debug-entries" module:"openconfig-messages"`
	State	*OpenconfigMessages_Messages_State	`path:"state" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages.
func (*OpenconfigMessages_Messages) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_Config represents the /openconfig-messages/messages/config YANG schema element.
type OpenconfigMessages_Messages_Config struct {
	Severity	E_OpenconfigMessages_SyslogSeverity	`path:"severity" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_Config.
func (*OpenconfigMessages_Messages_Config) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries represents the /openconfig-messages/messages/debug-entries YANG schema element.
type OpenconfigMessages_Messages_DebugEntries struct {
	DebugService	map[E_OpenconfigMessages_DEBUG_SERVICE]*OpenconfigMessages_Messages_DebugEntries_DebugService	`path:"debug-service" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries) IsYANGGoStruct() {}

// NewDebugService creates a new entry in the DebugService list of the
// OpenconfigMessages_Messages_DebugEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigMessages_Messages_DebugEntries) NewDebugService(Service E_OpenconfigMessages_DEBUG_SERVICE) (*OpenconfigMessages_Messages_DebugEntries_DebugService, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.DebugService == nil {
		t.DebugService = make(map[E_OpenconfigMessages_DEBUG_SERVICE]*OpenconfigMessages_Messages_DebugEntries_DebugService)
	}

	key := Service

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.DebugService[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list DebugService", key)
	}

	t.DebugService[key] = &OpenconfigMessages_Messages_DebugEntries_DebugService{
		Service: Service,
	}

	return t.DebugService[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries.
func (*OpenconfigMessages_Messages_DebugEntries) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries_DebugService represents the /openconfig-messages/messages/debug-entries/debug-service YANG schema element.
type OpenconfigMessages_Messages_DebugEntries_DebugService struct {
	Config	*OpenconfigMessages_Messages_DebugEntries_DebugService_Config	`path:"config" module:"openconfig-messages"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-messages"`
	State	*OpenconfigMessages_Messages_DebugEntries_DebugService_State	`path:"state" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries_DebugService implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigMessages_Messages_DebugEntries_DebugService struct, which is a YANG list entry.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"service": t.Service,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries_DebugService"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries_DebugService.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries_DebugService_Config represents the /openconfig-messages/messages/debug-entries/debug-service/config YANG schema element.
type OpenconfigMessages_Messages_DebugEntries_DebugService_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-messages"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries_DebugService_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries_DebugService_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries_DebugService_Config.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_Config) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_DebugEntries_DebugService_State represents the /openconfig-messages/messages/debug-entries/debug-service/state YANG schema element.
type OpenconfigMessages_Messages_DebugEntries_DebugService_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-messages"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_DebugEntries_DebugService_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_DebugEntries_DebugService_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_DebugEntries_DebugService_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_DebugEntries_DebugService_State.
func (*OpenconfigMessages_Messages_DebugEntries_DebugService_State) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_State represents the /openconfig-messages/messages/state YANG schema element.
type OpenconfigMessages_Messages_State struct {
	Message	*OpenconfigMessages_Messages_State_Message	`path:"message" module:"openconfig-messages"`
	Severity	E_OpenconfigMessages_SyslogSeverity	`path:"severity" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_State.
func (*OpenconfigMessages_Messages_State) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigMessages_Messages_State_Message represents the /openconfig-messages/messages/state/message YANG schema element.
type OpenconfigMessages_Messages_State_Message struct {
	AppName	*string	`path:"app-name" module:"openconfig-messages"`
	Msg	*string	`path:"msg" module:"openconfig-messages"`
	Msgid	*string	`path:"msgid" module:"openconfig-messages"`
	Priority	*uint8	`path:"priority" module:"openconfig-messages"`
	Procid	*string	`path:"procid" module:"openconfig-messages"`
}

// IsYANGGoStruct ensures that OpenconfigMessages_Messages_State_Message implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigMessages_Messages_State_Message) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State_Message) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigMessages_Messages_State_Message"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigMessages_Messages_State_Message) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigMessages_Messages_State_Message) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigMessages_Messages_State_Message.
func (*OpenconfigMessages_Messages_State_Message) ΛBelongingModule() string {
	return "openconfig-messages"
}


// OpenconfigPlatform_Components represents the /openconfig-platform/components YANG schema element.
type OpenconfigPlatform_Components struct {
	Component	map[string]*OpenconfigPlatform_Components_Component	`path:"component" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components) IsYANGGoStruct() {}

// NewComponent creates a new entry in the Component list of the
// OpenconfigPlatform_Components struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigPlatform_Components) NewComponent(Name string) (*OpenconfigPlatform_Components_Component, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Component == nil {
		t.Component = make(map[string]*OpenconfigPlatform_Components_Component)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Component[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Component", key)
	}

	t.Component[key] = &OpenconfigPlatform_Components_Component{
		Name: &Name,
	}

	return t.Component[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components.
func (*OpenconfigPlatform_Components) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component represents the /openconfig-platform/components/component YANG schema element.
type OpenconfigPlatform_Components_Component struct {
	Backplane	*OpenconfigPlatform_Components_Component_Backplane	`path:"backplane" module:"openconfig-platform"`
	Chassis	*OpenconfigPlatform_Components_Component_Chassis	`path:"chassis" module:"openconfig-platform"`
	Config	*OpenconfigPlatform_Components_Component_Config	`path:"config" module:"openconfig-platform"`
	Cpu	*OpenconfigPlatform_Components_Component_Cpu	`path:"cpu" module:"openconfig-platform"`
	Fabric	*OpenconfigPlatform_Components_Component_Fabric	`path:"fabric" module:"openconfig-platform"`
	Fan	*OpenconfigPlatform_Components_Component_Fan	`path:"fan" module:"openconfig-platform"`
	IntegratedCircuit	*OpenconfigPlatform_Components_Component_IntegratedCircuit	`path:"integrated-circuit" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	Port	*OpenconfigPlatform_Components_Component_Port	`path:"port" module:"openconfig-platform"`
	PowerSupply	*OpenconfigPlatform_Components_Component_PowerSupply	`path:"power-supply" module:"openconfig-platform"`
	Properties	*OpenconfigPlatform_Components_Component_Properties	`path:"properties" module:"openconfig-platform"`
	SoftwareModule	*OpenconfigPlatform_Components_Component_SoftwareModule	`path:"software-module" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_State	`path:"state" module:"openconfig-platform"`
	Storage	*OpenconfigPlatform_Components_Component_Storage	`path:"storage" module:"openconfig-platform"`
	Subcomponents	*OpenconfigPlatform_Components_Component_Subcomponents	`path:"subcomponents" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigPlatform_Components_Component struct, which is a YANG list entry.
func (t *OpenconfigPlatform_Components_Component) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component.
func (*OpenconfigPlatform_Components_Component) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Backplane represents the /openconfig-platform/components/component/backplane YANG schema element.
type OpenconfigPlatform_Components_Component_Backplane struct {
	Config	*OpenconfigPlatform_Components_Component_Backplane_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Backplane_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Backplane implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Backplane) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Backplane"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Backplane) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Backplane.
func (*OpenconfigPlatform_Components_Component_Backplane) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Backplane_Config represents the /openconfig-platform/components/component/backplane/config YANG schema element.
type OpenconfigPlatform_Components_Component_Backplane_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Backplane_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Backplane_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Backplane_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Backplane_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Backplane_Config.
func (*OpenconfigPlatform_Components_Component_Backplane_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Backplane_State represents the /openconfig-platform/components/component/backplane/state YANG schema element.
type OpenconfigPlatform_Components_Component_Backplane_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Backplane_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Backplane_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Backplane_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Backplane_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Backplane_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Backplane_State.
func (*OpenconfigPlatform_Components_Component_Backplane_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Chassis represents the /openconfig-platform/components/component/chassis YANG schema element.
type OpenconfigPlatform_Components_Component_Chassis struct {
	Config	*OpenconfigPlatform_Components_Component_Chassis_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Chassis_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Chassis implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Chassis) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Chassis"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Chassis) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Chassis.
func (*OpenconfigPlatform_Components_Component_Chassis) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Chassis_Config represents the /openconfig-platform/components/component/chassis/config YANG schema element.
type OpenconfigPlatform_Components_Component_Chassis_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Chassis_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Chassis_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Chassis_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Chassis_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Chassis_Config.
func (*OpenconfigPlatform_Components_Component_Chassis_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Chassis_State represents the /openconfig-platform/components/component/chassis/state YANG schema element.
type OpenconfigPlatform_Components_Component_Chassis_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Chassis_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Chassis_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Chassis_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Chassis_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Chassis_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Chassis_State.
func (*OpenconfigPlatform_Components_Component_Chassis_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Config represents the /openconfig-platform/components/component/config YANG schema element.
type OpenconfigPlatform_Components_Component_Config struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Config.
func (*OpenconfigPlatform_Components_Component_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Cpu represents the /openconfig-platform/components/component/cpu YANG schema element.
type OpenconfigPlatform_Components_Component_Cpu struct {
	Config	*OpenconfigPlatform_Components_Component_Cpu_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Cpu_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Cpu implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Cpu) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Cpu"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Cpu) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Cpu.
func (*OpenconfigPlatform_Components_Component_Cpu) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Cpu_Config represents the /openconfig-platform/components/component/cpu/config YANG schema element.
type OpenconfigPlatform_Components_Component_Cpu_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Cpu_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Cpu_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Cpu_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Cpu_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Cpu_Config.
func (*OpenconfigPlatform_Components_Component_Cpu_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Cpu_State represents the /openconfig-platform/components/component/cpu/state YANG schema element.
type OpenconfigPlatform_Components_Component_Cpu_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Cpu_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Cpu_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Cpu_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Cpu_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Cpu_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Cpu_State.
func (*OpenconfigPlatform_Components_Component_Cpu_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fabric represents the /openconfig-platform/components/component/fabric YANG schema element.
type OpenconfigPlatform_Components_Component_Fabric struct {
	Config	*OpenconfigPlatform_Components_Component_Fabric_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Fabric_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fabric implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fabric) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fabric"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fabric) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fabric.
func (*OpenconfigPlatform_Components_Component_Fabric) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fabric_Config represents the /openconfig-platform/components/component/fabric/config YANG schema element.
type OpenconfigPlatform_Components_Component_Fabric_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fabric_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fabric_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fabric_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fabric_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fabric_Config.
func (*OpenconfigPlatform_Components_Component_Fabric_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fabric_State represents the /openconfig-platform/components/component/fabric/state YANG schema element.
type OpenconfigPlatform_Components_Component_Fabric_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fabric_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fabric_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fabric_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fabric_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fabric_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fabric_State.
func (*OpenconfigPlatform_Components_Component_Fabric_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fan represents the /openconfig-platform/components/component/fan YANG schema element.
type OpenconfigPlatform_Components_Component_Fan struct {
	Config	*OpenconfigPlatform_Components_Component_Fan_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Fan_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fan implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fan) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fan"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fan) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fan.
func (*OpenconfigPlatform_Components_Component_Fan) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fan_Config represents the /openconfig-platform/components/component/fan/config YANG schema element.
type OpenconfigPlatform_Components_Component_Fan_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fan_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fan_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fan_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fan_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fan_Config.
func (*OpenconfigPlatform_Components_Component_Fan_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Fan_State represents the /openconfig-platform/components/component/fan/state YANG schema element.
type OpenconfigPlatform_Components_Component_Fan_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Fan_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Fan_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Fan_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Fan_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Fan_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Fan_State.
func (*OpenconfigPlatform_Components_Component_Fan_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_IntegratedCircuit represents the /openconfig-platform/components/component/integrated-circuit YANG schema element.
type OpenconfigPlatform_Components_Component_IntegratedCircuit struct {
	Config	*OpenconfigPlatform_Components_Component_IntegratedCircuit_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_IntegratedCircuit_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_IntegratedCircuit implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_IntegratedCircuit"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_IntegratedCircuit.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_IntegratedCircuit_Config represents the /openconfig-platform/components/component/integrated-circuit/config YANG schema element.
type OpenconfigPlatform_Components_Component_IntegratedCircuit_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_IntegratedCircuit_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_IntegratedCircuit_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_IntegratedCircuit_Config.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_IntegratedCircuit_State represents the /openconfig-platform/components/component/integrated-circuit/state YANG schema element.
type OpenconfigPlatform_Components_Component_IntegratedCircuit_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_IntegratedCircuit_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_IntegratedCircuit_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_IntegratedCircuit_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_IntegratedCircuit_State.
func (*OpenconfigPlatform_Components_Component_IntegratedCircuit_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Port represents the /openconfig-platform/components/component/port YANG schema element.
type OpenconfigPlatform_Components_Component_Port struct {
	Config	*OpenconfigPlatform_Components_Component_Port_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Port_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Port.
func (*OpenconfigPlatform_Components_Component_Port) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Port_Config represents the /openconfig-platform/components/component/port/config YANG schema element.
type OpenconfigPlatform_Components_Component_Port_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Port_Config.
func (*OpenconfigPlatform_Components_Component_Port_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Port_State represents the /openconfig-platform/components/component/port/state YANG schema element.
type OpenconfigPlatform_Components_Component_Port_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Port_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Port_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Port_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Port_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Port_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Port_State.
func (*OpenconfigPlatform_Components_Component_Port_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_PowerSupply represents the /openconfig-platform/components/component/power-supply YANG schema element.
type OpenconfigPlatform_Components_Component_PowerSupply struct {
	Config	*OpenconfigPlatform_Components_Component_PowerSupply_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_PowerSupply_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_PowerSupply implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_PowerSupply) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_PowerSupply"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_PowerSupply) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_PowerSupply.
func (*OpenconfigPlatform_Components_Component_PowerSupply) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_PowerSupply_Config represents the /openconfig-platform/components/component/power-supply/config YANG schema element.
type OpenconfigPlatform_Components_Component_PowerSupply_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_PowerSupply_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_PowerSupply_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_PowerSupply_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_PowerSupply_Config.
func (*OpenconfigPlatform_Components_Component_PowerSupply_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_PowerSupply_State represents the /openconfig-platform/components/component/power-supply/state YANG schema element.
type OpenconfigPlatform_Components_Component_PowerSupply_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_PowerSupply_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_PowerSupply_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_PowerSupply_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_PowerSupply_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_PowerSupply_State.
func (*OpenconfigPlatform_Components_Component_PowerSupply_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Properties represents the /openconfig-platform/components/component/properties YANG schema element.
type OpenconfigPlatform_Components_Component_Properties struct {
	Property	map[string]*OpenconfigPlatform_Components_Component_Properties_Property	`path:"property" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties) IsYANGGoStruct() {}

// NewProperty creates a new entry in the Property list of the
// OpenconfigPlatform_Components_Component_Properties struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigPlatform_Components_Component_Properties) NewProperty(Name string) (*OpenconfigPlatform_Components_Component_Properties_Property, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Property == nil {
		t.Property = make(map[string]*OpenconfigPlatform_Components_Component_Properties_Property)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Property[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Property", key)
	}

	t.Property[key] = &OpenconfigPlatform_Components_Component_Properties_Property{
		Name: &Name,
	}

	return t.Property[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Properties.
func (*OpenconfigPlatform_Components_Component_Properties) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Properties_Property represents the /openconfig-platform/components/component/properties/property YANG schema element.
type OpenconfigPlatform_Components_Component_Properties_Property struct {
	Config	*OpenconfigPlatform_Components_Component_Properties_Property_Config	`path:"config" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Properties_Property_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties_Property implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties_Property) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigPlatform_Components_Component_Properties_Property struct, which is a YANG list entry.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties_Property"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties_Property) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Properties_Property.
func (*OpenconfigPlatform_Components_Component_Properties_Property) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Properties_Property_Config represents the /openconfig-platform/components/component/properties/property/config YANG schema element.
type OpenconfigPlatform_Components_Component_Properties_Property_Config struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
	Value	OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union	`path:"value" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties_Property_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Properties_Property_Config.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/properties/property/config/value within the YANG schema.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface {
	Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union()
}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a bool value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool struct {
	Bool	bool
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a float64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64 struct {
	Float64	float64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a int64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64 struct {
	Int64	int64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a string value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String struct {
	String	string
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64 is used when /openconfig-platform/components/component/properties/property/config/value
// is to be set to a uint64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64 struct {
	Uint64	uint64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64) Is_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union() {}

// To_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_Config) To_OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union(i interface{}) (OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union, error) {
	switch v := i.(type) {
	case bool:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Bool{v}, nil
	case float64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Float64{v}, nil
	case int64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Int64{v}, nil
	case string:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_String{v}, nil
	case uint64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union_Uint64{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigPlatform_Components_Component_Properties_Property_Config_Value_Union, unknown union type, got: %T, want any of [bool, float64, int64, string, uint64]", i, i)
	}
}


// OpenconfigPlatform_Components_Component_Properties_Property_State represents the /openconfig-platform/components/component/properties/property/state YANG schema element.
type OpenconfigPlatform_Components_Component_Properties_Property_State struct {
	Configurable	*bool	`path:"configurable" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	Value	OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union	`path:"value" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Properties_Property_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Properties_Property_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Properties_Property_State.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State) ΛBelongingModule() string {
	return "openconfig-platform"
}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/properties/property/state/value within the YANG schema.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface {
	Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union()
}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a bool value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool struct {
	Bool	bool
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64 is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a float64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64 struct {
	Float64	float64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64 is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a int64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64 struct {
	Int64	int64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a string value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String struct {
	String	string
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64 is used when /openconfig-platform/components/component/properties/property/state/value
// is to be set to a uint64 value.
type OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64 struct {
	Uint64	uint64
}

// Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union ensures that OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64
// implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union interface.
func (*OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64) Is_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union() {}

// To_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigPlatform_Components_Component_Properties_Property_State) To_OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union(i interface{}) (OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union, error) {
	switch v := i.(type) {
	case bool:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Bool{v}, nil
	case float64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Float64{v}, nil
	case int64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Int64{v}, nil
	case string:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_String{v}, nil
	case uint64:
		return &OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union_Uint64{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigPlatform_Components_Component_Properties_Property_State_Value_Union, unknown union type, got: %T, want any of [bool, float64, int64, string, uint64]", i, i)
	}
}


// OpenconfigPlatform_Components_Component_SoftwareModule represents the /openconfig-platform/components/component/software-module YANG schema element.
type OpenconfigPlatform_Components_Component_SoftwareModule struct {
	Config	*OpenconfigPlatform_Components_Component_SoftwareModule_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_SoftwareModule_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_SoftwareModule implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_SoftwareModule) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_SoftwareModule"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_SoftwareModule.
func (*OpenconfigPlatform_Components_Component_SoftwareModule) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_SoftwareModule_Config represents the /openconfig-platform/components/component/software-module/config YANG schema element.
type OpenconfigPlatform_Components_Component_SoftwareModule_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_SoftwareModule_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_SoftwareModule_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_SoftwareModule_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_SoftwareModule_Config.
func (*OpenconfigPlatform_Components_Component_SoftwareModule_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_SoftwareModule_State represents the /openconfig-platform/components/component/software-module/state YANG schema element.
type OpenconfigPlatform_Components_Component_SoftwareModule_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_SoftwareModule_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_SoftwareModule_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_SoftwareModule_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_SoftwareModule_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_SoftwareModule_State.
func (*OpenconfigPlatform_Components_Component_SoftwareModule_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State represents the /openconfig-platform/components/component/state YANG schema element.
type OpenconfigPlatform_Components_Component_State struct {
	AllocatedPower	*uint32	`path:"allocated-power" module:"openconfig-platform"`
	Description	*string	`path:"description" module:"openconfig-platform"`
	Empty	*bool	`path:"empty" module:"openconfig-platform"`
	EquipmentFailure	*bool	`path:"equipment-failure" module:"openconfig-alarms"`
	EquipmentMismatch	*bool	`path:"equipment-mismatch" module:"openconfig-alarms"`
	FirmwareVersion	*string	`path:"firmware-version" module:"openconfig-platform"`
	HardwareVersion	*string	`path:"hardware-version" module:"openconfig-platform"`
	Id	*string	`path:"id" module:"openconfig-platform"`
	LastRebootReason	E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON	`path:"last-reboot-reason" module:"openconfig-platform"`
	LastRebootTime	*uint64	`path:"last-reboot-time" module:"openconfig-platform"`
	LastSwitchoverReason	*OpenconfigPlatform_Components_Component_State_LastSwitchoverReason	`path:"last-switchover-reason" module:"openconfig-platform"`
	LastSwitchoverTime	*uint64	`path:"last-switchover-time" module:"openconfig-platform"`
	Location	*string	`path:"location" module:"openconfig-platform"`
	Memory	*OpenconfigPlatform_Components_Component_State_Memory	`path:"memory" module:"openconfig-platform"`
	MfgDate	*string	`path:"mfg-date" module:"openconfig-platform"`
	MfgName	*string	`path:"mfg-name" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	OperStatus	E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS	`path:"oper-status" module:"openconfig-platform"`
	Parent	*string	`path:"parent" module:"openconfig-platform"`
	PartNo	*string	`path:"part-no" module:"openconfig-platform"`
	Pcie	*OpenconfigPlatform_Components_Component_State_Pcie	`path:"pcie" module:"openconfig-platform"`
	RedundantRole	E_OpenconfigPlatform_ComponentRedundantRole	`path:"redundant-role" module:"openconfig-platform"`
	Removable	*bool	`path:"removable" module:"openconfig-platform"`
	SerialNo	*string	`path:"serial-no" module:"openconfig-platform"`
	SoftwareVersion	*string	`path:"software-version" module:"openconfig-platform"`
	Temperature	*OpenconfigPlatform_Components_Component_State_Temperature	`path:"temperature" module:"openconfig-platform"`
	Type	OpenconfigPlatform_Components_Component_State_Type_Union	`path:"type" module:"openconfig-platform"`
	UsedPower	*uint32	`path:"used-power" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State.
func (*OpenconfigPlatform_Components_Component_State) ΛBelongingModule() string {
	return "openconfig-platform"
}

// OpenconfigPlatform_Components_Component_State_Type_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-platform/components/component/state/type within the YANG schema.
type OpenconfigPlatform_Components_Component_State_Type_Union interface {
	Is_OpenconfigPlatform_Components_Component_State_Type_Union()
}

// OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT is used when /openconfig-platform/components/component/state/type
// is to be set to a E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT value.
type OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT struct {
	E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT	E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
}

// Is_OpenconfigPlatform_Components_Component_State_Type_Union ensures that OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
// implements the OpenconfigPlatform_Components_Component_State_Type_Union interface.
func (*OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) Is_OpenconfigPlatform_Components_Component_State_Type_Union() {}

// OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT is used when /openconfig-platform/components/component/state/type
// is to be set to a E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT value.
type OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT struct {
	E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT	E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
}

// Is_OpenconfigPlatform_Components_Component_State_Type_Union ensures that OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
// implements the OpenconfigPlatform_Components_Component_State_Type_Union interface.
func (*OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) Is_OpenconfigPlatform_Components_Component_State_Type_Union() {}

// To_OpenconfigPlatform_Components_Component_State_Type_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigPlatform_Components_Component_State_Type_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigPlatform_Components_Component_State) To_OpenconfigPlatform_Components_Component_State_Type_Union(i interface{}) (OpenconfigPlatform_Components_Component_State_Type_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT:
		return &OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT{v}, nil
	case E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT:
		return &OpenconfigPlatform_Components_Component_State_Type_Union_E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigPlatform_Components_Component_State_Type_Union, unknown union type, got: %T, want any of [E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT, E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT]", i, i)
	}
}


// OpenconfigPlatform_Components_Component_State_LastSwitchoverReason represents the /openconfig-platform/components/component/state/last-switchover-reason YANG schema element.
type OpenconfigPlatform_Components_Component_State_LastSwitchoverReason struct {
	Details	*string	`path:"details" module:"openconfig-platform"`
	Trigger	E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger	`path:"trigger" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_LastSwitchoverReason implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_LastSwitchoverReason) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_LastSwitchoverReason) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_LastSwitchoverReason"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_LastSwitchoverReason) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_LastSwitchoverReason) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_LastSwitchoverReason.
func (*OpenconfigPlatform_Components_Component_State_LastSwitchoverReason) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Memory represents the /openconfig-platform/components/component/state/memory YANG schema element.
type OpenconfigPlatform_Components_Component_State_Memory struct {
	Available	*uint64	`path:"available" module:"openconfig-platform"`
	Utilized	*uint64	`path:"utilized" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Memory implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Memory) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Memory) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Memory"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Memory) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Memory) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Memory.
func (*OpenconfigPlatform_Components_Component_State_Memory) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Pcie represents the /openconfig-platform/components/component/state/pcie YANG schema element.
type OpenconfigPlatform_Components_Component_State_Pcie struct {
	CorrectableErrors	*OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors	`path:"correctable-errors" module:"openconfig-platform"`
	FatalErrors	*OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors	`path:"fatal-errors" module:"openconfig-platform"`
	NonFatalErrors	*OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors	`path:"non-fatal-errors" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Pcie implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Pcie) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Pcie"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Pcie) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Pcie.
func (*OpenconfigPlatform_Components_Component_State_Pcie) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors represents the /openconfig-platform/components/component/state/pcie/correctable-errors YANG schema element.
type OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors struct {
	AdvisoryNonFatalErrors	*uint64	`path:"advisory-non-fatal-errors" module:"openconfig-platform"`
	BadDllpErrors	*uint64	`path:"bad-dllp-errors" module:"openconfig-platform"`
	BadTlpErrors	*uint64	`path:"bad-tlp-errors" module:"openconfig-platform"`
	HdrLogOverflowErrors	*uint64	`path:"hdr-log-overflow-errors" module:"openconfig-platform"`
	InternalErrors	*uint64	`path:"internal-errors" module:"openconfig-platform"`
	ReceiverErrors	*uint64	`path:"receiver-errors" module:"openconfig-platform"`
	RelayRolloverErrors	*uint64	`path:"relay-rollover-errors" module:"openconfig-platform"`
	ReplayTimeoutErrors	*uint64	`path:"replay-timeout-errors" module:"openconfig-platform"`
	TotalErrors	*uint64	`path:"total-errors" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors.
func (*OpenconfigPlatform_Components_Component_State_Pcie_CorrectableErrors) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors represents the /openconfig-platform/components/component/state/pcie/fatal-errors YANG schema element.
type OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors struct {
	AcsViolationErrors	*uint64	`path:"acs-violation-errors" module:"openconfig-platform"`
	AtomicOpBlockedErrors	*uint64	`path:"atomic-op-blocked-errors" module:"openconfig-platform"`
	BlockedTlpErrors	*uint64	`path:"blocked-tlp-errors" module:"openconfig-platform"`
	CompletionAbortErrors	*uint64	`path:"completion-abort-errors" module:"openconfig-platform"`
	CompletionTimeoutErrors	*uint64	`path:"completion-timeout-errors" module:"openconfig-platform"`
	DataLinkErrors	*uint64	`path:"data-link-errors" module:"openconfig-platform"`
	EcrcErrors	*uint64	`path:"ecrc-errors" module:"openconfig-platform"`
	FlowControlProtocolErrors	*uint64	`path:"flow-control-protocol-errors" module:"openconfig-platform"`
	InternalErrors	*uint64	`path:"internal-errors" module:"openconfig-platform"`
	MalformedTlpErrors	*uint64	`path:"malformed-tlp-errors" module:"openconfig-platform"`
	PoisonedTlpErrors	*uint64	`path:"poisoned-tlp-errors" module:"openconfig-platform"`
	ReceiverOverflowErrors	*uint64	`path:"receiver-overflow-errors" module:"openconfig-platform"`
	SurpriseDownErrors	*uint64	`path:"surprise-down-errors" module:"openconfig-platform"`
	TlpPrefixBlockedErrors	*uint64	`path:"tlp-prefix-blocked-errors" module:"openconfig-platform"`
	TotalErrors	*uint64	`path:"total-errors" module:"openconfig-platform"`
	UndefinedErrors	*uint64	`path:"undefined-errors" module:"openconfig-platform"`
	UnexpectedCompletionErrors	*uint64	`path:"unexpected-completion-errors" module:"openconfig-platform"`
	UnsupportedRequestErrors	*uint64	`path:"unsupported-request-errors" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors.
func (*OpenconfigPlatform_Components_Component_State_Pcie_FatalErrors) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors represents the /openconfig-platform/components/component/state/pcie/non-fatal-errors YANG schema element.
type OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors struct {
	AcsViolationErrors	*uint64	`path:"acs-violation-errors" module:"openconfig-platform"`
	AtomicOpBlockedErrors	*uint64	`path:"atomic-op-blocked-errors" module:"openconfig-platform"`
	BlockedTlpErrors	*uint64	`path:"blocked-tlp-errors" module:"openconfig-platform"`
	CompletionAbortErrors	*uint64	`path:"completion-abort-errors" module:"openconfig-platform"`
	CompletionTimeoutErrors	*uint64	`path:"completion-timeout-errors" module:"openconfig-platform"`
	DataLinkErrors	*uint64	`path:"data-link-errors" module:"openconfig-platform"`
	EcrcErrors	*uint64	`path:"ecrc-errors" module:"openconfig-platform"`
	FlowControlProtocolErrors	*uint64	`path:"flow-control-protocol-errors" module:"openconfig-platform"`
	InternalErrors	*uint64	`path:"internal-errors" module:"openconfig-platform"`
	MalformedTlpErrors	*uint64	`path:"malformed-tlp-errors" module:"openconfig-platform"`
	PoisonedTlpErrors	*uint64	`path:"poisoned-tlp-errors" module:"openconfig-platform"`
	ReceiverOverflowErrors	*uint64	`path:"receiver-overflow-errors" module:"openconfig-platform"`
	SurpriseDownErrors	*uint64	`path:"surprise-down-errors" module:"openconfig-platform"`
	TlpPrefixBlockedErrors	*uint64	`path:"tlp-prefix-blocked-errors" module:"openconfig-platform"`
	TotalErrors	*uint64	`path:"total-errors" module:"openconfig-platform"`
	UndefinedErrors	*uint64	`path:"undefined-errors" module:"openconfig-platform"`
	UnexpectedCompletionErrors	*uint64	`path:"unexpected-completion-errors" module:"openconfig-platform"`
	UnsupportedRequestErrors	*uint64	`path:"unsupported-request-errors" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors.
func (*OpenconfigPlatform_Components_Component_State_Pcie_NonFatalErrors) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_State_Temperature represents the /openconfig-platform/components/component/state/temperature YANG schema element.
type OpenconfigPlatform_Components_Component_State_Temperature struct {
	AlarmSeverity	E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY	`path:"alarm-severity" module:"openconfig-platform"`
	AlarmStatus	*bool	`path:"alarm-status" module:"openconfig-platform"`
	AlarmThreshold	*uint32	`path:"alarm-threshold" module:"openconfig-platform"`
	Avg	*float64	`path:"avg" module:"openconfig-platform"`
	Instant	*float64	`path:"instant" module:"openconfig-platform"`
	Interval	*uint64	`path:"interval" module:"openconfig-platform"`
	Max	*float64	`path:"max" module:"openconfig-platform"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-platform"`
	Min	*float64	`path:"min" module:"openconfig-platform"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_State_Temperature implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_State_Temperature) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Temperature) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_State_Temperature"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_State_Temperature) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_State_Temperature) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_State_Temperature.
func (*OpenconfigPlatform_Components_Component_State_Temperature) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Storage represents the /openconfig-platform/components/component/storage YANG schema element.
type OpenconfigPlatform_Components_Component_Storage struct {
	Config	*OpenconfigPlatform_Components_Component_Storage_Config	`path:"config" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Storage_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Storage implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Storage) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Storage"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Storage) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Storage.
func (*OpenconfigPlatform_Components_Component_Storage) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Storage_Config represents the /openconfig-platform/components/component/storage/config YANG schema element.
type OpenconfigPlatform_Components_Component_Storage_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Storage_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Storage_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Storage_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Storage_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Storage_Config.
func (*OpenconfigPlatform_Components_Component_Storage_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Storage_State represents the /openconfig-platform/components/component/storage/state YANG schema element.
type OpenconfigPlatform_Components_Component_Storage_State struct {
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Storage_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Storage_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Storage_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Storage_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Storage_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Storage_State.
func (*OpenconfigPlatform_Components_Component_Storage_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Subcomponents represents the /openconfig-platform/components/component/subcomponents YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents struct {
	Subcomponent	map[string]*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent	`path:"subcomponent" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents) IsYANGGoStruct() {}

// NewSubcomponent creates a new entry in the Subcomponent list of the
// OpenconfigPlatform_Components_Component_Subcomponents struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) NewSubcomponent(Name string) (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Subcomponent == nil {
		t.Subcomponent = make(map[string]*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Subcomponent[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Subcomponent", key)
	}

	t.Subcomponent[key] = &OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent{
		Name: &Name,
	}

	return t.Subcomponent[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Subcomponents.
func (*OpenconfigPlatform_Components_Component_Subcomponents) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent represents the /openconfig-platform/components/component/subcomponents/subcomponent YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent struct {
	Config	*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config	`path:"config" module:"openconfig-platform"`
	Name	*string	`path:"name" module:"openconfig-platform"`
	State	*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State	`path:"state" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent struct, which is a YANG list entry.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config represents the /openconfig-platform/components/component/subcomponents/subcomponent/config YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_Config) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State represents the /openconfig-platform/components/component/subcomponents/subcomponent/state YANG schema element.
type OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State struct {
	Name	*string	`path:"name" module:"openconfig-platform"`
}

// IsYANGGoStruct ensures that OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State.
func (*OpenconfigPlatform_Components_Component_Subcomponents_Subcomponent_State) ΛBelongingModule() string {
	return "openconfig-platform"
}


// OpenconfigSystem_System represents the /openconfig-system/system YANG schema element.
type OpenconfigSystem_System struct {
	Aaa	*OpenconfigSystem_System_Aaa	`path:"aaa" module:"openconfig-system"`
	Alarms	*OpenconfigSystem_System_Alarms	`path:"alarms" module:"openconfig-system"`
	Clock	*OpenconfigSystem_System_Clock	`path:"clock" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Config	`path:"config" module:"openconfig-system"`
	Cpus	*OpenconfigSystem_System_Cpus	`path:"cpus" module:"openconfig-system"`
	Dns	*OpenconfigSystem_System_Dns	`path:"dns" module:"openconfig-system"`
	License	*OpenconfigSystem_System_License	`path:"license" module:"openconfig-system"`
	Logging	*OpenconfigSystem_System_Logging	`path:"logging" module:"openconfig-system"`
	Memory	*OpenconfigSystem_System_Memory	`path:"memory" module:"openconfig-system"`
	Messages	*OpenconfigSystem_System_Messages	`path:"messages" module:"openconfig-system"`
	MountPoints	*OpenconfigSystem_System_MountPoints	`path:"mount-points" module:"openconfig-system"`
	Ntp	*OpenconfigSystem_System_Ntp	`path:"ntp" module:"openconfig-system"`
	Processes	*OpenconfigSystem_System_Processes	`path:"processes" module:"openconfig-system"`
	SshServer	*OpenconfigSystem_System_SshServer	`path:"ssh-server" module:"openconfig-system"`
	State	*OpenconfigSystem_System_State	`path:"state" module:"openconfig-system"`
	TelnetServer	*OpenconfigSystem_System_TelnetServer	`path:"telnet-server" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System.
func (*OpenconfigSystem_System) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa represents the /openconfig-system/system/aaa YANG schema element.
type OpenconfigSystem_System_Aaa struct {
	Accounting	*OpenconfigSystem_System_Aaa_Accounting	`path:"accounting" module:"openconfig-system"`
	Authentication	*OpenconfigSystem_System_Aaa_Authentication	`path:"authentication" module:"openconfig-system"`
	Authorization	*OpenconfigSystem_System_Aaa_Authorization	`path:"authorization" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Aaa_Config	`path:"config" module:"openconfig-system"`
	ServerGroups	*OpenconfigSystem_System_Aaa_ServerGroups	`path:"server-groups" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa.
func (*OpenconfigSystem_System_Aaa) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting represents the /openconfig-system/system/aaa/accounting YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting struct {
	Config	*OpenconfigSystem_System_Aaa_Accounting_Config	`path:"config" module:"openconfig-system"`
	Events	*OpenconfigSystem_System_Aaa_Accounting_Events	`path:"events" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Accounting_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting.
func (*OpenconfigSystem_System_Aaa_Accounting) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting_Config represents the /openconfig-system/system/aaa/accounting/config YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_Config struct {
	AccountingMethod	[]OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union	`path:"accounting-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_Config.
func (*OpenconfigSystem_System_Aaa_Accounting_Config) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/accounting/config/accounting-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union()
}

// OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/accounting/config/accounting-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union ensures that OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union() {}

// OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_String is used when /openconfig-system/system/aaa/accounting/config/accounting-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union ensures that OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Accounting_Config) To_OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Accounting_Config_AccountingMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Accounting_Events represents the /openconfig-system/system/aaa/accounting/events YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_Events struct {
	Event	map[E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE]*OpenconfigSystem_System_Aaa_Accounting_Events_Event	`path:"event" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_Events implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_Events) IsYANGGoStruct() {}

// NewEvent creates a new entry in the Event list of the
// OpenconfigSystem_System_Aaa_Accounting_Events struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events) NewEvent(EventType E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE) (*OpenconfigSystem_System_Aaa_Accounting_Events_Event, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Event == nil {
		t.Event = make(map[E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE]*OpenconfigSystem_System_Aaa_Accounting_Events_Event)
	}

	key := EventType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Event[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Event", key)
	}

	t.Event[key] = &OpenconfigSystem_System_Aaa_Accounting_Events_Event{
		EventType: EventType,
	}

	return t.Event[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_Events"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_Events.
func (*OpenconfigSystem_System_Aaa_Accounting_Events) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting_Events_Event represents the /openconfig-system/system/aaa/accounting/events/event YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_Events_Event struct {
	Config	*OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config	`path:"config" module:"openconfig-system"`
	EventType	E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Accounting_Events_Event_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_Events_Event implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Aaa_Accounting_Events_Event struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"event-type": t.EventType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_Events_Event"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_Events_Event.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config represents the /openconfig-system/system/aaa/accounting/events/event/config YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config struct {
	EventType	E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
	Record	E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record	`path:"record" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting_Events_Event_State represents the /openconfig-system/system/aaa/accounting/events/event/state YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_Events_Event_State struct {
	EventType	E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
	Record	E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record	`path:"record" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_Events_Event_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_Events_Event_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_Events_Event_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_Events_Event_State.
func (*OpenconfigSystem_System_Aaa_Accounting_Events_Event_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Accounting_State represents the /openconfig-system/system/aaa/accounting/state YANG schema element.
type OpenconfigSystem_System_Aaa_Accounting_State struct {
	AccountingMethod	[]OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union	`path:"accounting-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Accounting_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Accounting_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Accounting_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Accounting_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Accounting_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Accounting_State.
func (*OpenconfigSystem_System_Aaa_Accounting_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/accounting/state/accounting-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union()
}

// OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/accounting/state/accounting-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union ensures that OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union() {}

// OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_String is used when /openconfig-system/system/aaa/accounting/state/accounting-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union ensures that OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Accounting_State) To_OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Accounting_State_AccountingMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authentication represents the /openconfig-system/system/aaa/authentication YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication struct {
	AdminUser	*OpenconfigSystem_System_Aaa_Authentication_AdminUser	`path:"admin-user" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Aaa_Authentication_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Authentication_State	`path:"state" module:"openconfig-system"`
	Users	*OpenconfigSystem_System_Aaa_Authentication_Users	`path:"users" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication.
func (*OpenconfigSystem_System_Aaa_Authentication) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_AdminUser represents the /openconfig-system/system/aaa/authentication/admin-user YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_AdminUser struct {
	Config	*OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Authentication_AdminUser_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_AdminUser implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_AdminUser"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_AdminUser.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config represents the /openconfig-system/system/aaa/authentication/admin-user/config YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config struct {
	AdminPassword	*string	`path:"admin-password" module:"openconfig-system"`
	AdminPasswordHashed	*string	`path:"admin-password-hashed" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_AdminUser_State represents the /openconfig-system/system/aaa/authentication/admin-user/state YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_AdminUser_State struct {
	AdminPassword	*string	`path:"admin-password" module:"openconfig-system"`
	AdminPasswordHashed	*string	`path:"admin-password-hashed" module:"openconfig-system"`
	AdminUsername	*string	`path:"admin-username" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_AdminUser_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_AdminUser_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_AdminUser_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_AdminUser_State.
func (*OpenconfigSystem_System_Aaa_Authentication_AdminUser_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_Config represents the /openconfig-system/system/aaa/authentication/config YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_Config struct {
	AuthenticationMethod	[]OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union	`path:"authentication-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_Config.
func (*OpenconfigSystem_System_Aaa_Authentication_Config) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authentication/config/authentication-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union()
}

// OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/authentication/config/authentication-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union() {}

// OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_String is used when /openconfig-system/system/aaa/authentication/config/authentication-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authentication_Config) To_OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authentication_Config_AuthenticationMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authentication_State represents the /openconfig-system/system/aaa/authentication/state YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_State struct {
	AuthenticationMethod	[]OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union	`path:"authentication-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_State.
func (*OpenconfigSystem_System_Aaa_Authentication_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authentication/state/authentication-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union()
}

// OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/authentication/state/authentication-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union() {}

// OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_String is used when /openconfig-system/system/aaa/authentication/state/authentication-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authentication_State) To_OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authentication_State_AuthenticationMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authentication_Users represents the /openconfig-system/system/aaa/authentication/users YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_Users struct {
	User	map[string]*OpenconfigSystem_System_Aaa_Authentication_Users_User	`path:"user" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_Users implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_Users) IsYANGGoStruct() {}

// NewUser creates a new entry in the User list of the
// OpenconfigSystem_System_Aaa_Authentication_Users struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users) NewUser(Username string) (*OpenconfigSystem_System_Aaa_Authentication_Users_User, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.User == nil {
		t.User = make(map[string]*OpenconfigSystem_System_Aaa_Authentication_Users_User)
	}

	key := Username

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.User[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list User", key)
	}

	t.User[key] = &OpenconfigSystem_System_Aaa_Authentication_Users_User{
		Username: &Username,
	}

	return t.User[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_Users"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_Users.
func (*OpenconfigSystem_System_Aaa_Authentication_Users) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_Users_User represents the /openconfig-system/system/aaa/authentication/users/user YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_Users_User struct {
	Config	*OpenconfigSystem_System_Aaa_Authentication_Users_User_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Authentication_Users_User_State	`path:"state" module:"openconfig-system"`
	Username	*string	`path:"username" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Aaa_Authentication_Users_User struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Username == nil {
		return nil, fmt.Errorf("nil value for key Username")
	}

	return map[string]interface{}{
		"username": *t.Username,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_Users_User"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_Users_User.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authentication_Users_User_Config represents the /openconfig-system/system/aaa/authentication/users/user/config YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_Config struct {
	Password	*string	`path:"password" module:"openconfig-system"`
	PasswordHashed	*string	`path:"password-hashed" module:"openconfig-system"`
	Role	OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union	`path:"role" module:"openconfig-system"`
	SshKey	*string	`path:"ssh-key" module:"openconfig-system"`
	Username	*string	`path:"username" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_Users_User_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_Users_User_Config.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authentication/users/user/config/role within the YANG schema.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union()
}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES is used when /openconfig-system/system/aaa/authentication/users/user/config/role
// is to be set to a E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES value.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES struct {
	E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES	E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
// implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES) Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union() {}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_String is used when /openconfig-system/system/aaa/authentication/users/user/config/role
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_String
// implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_String) Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union() {}

// To_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_Config) To_OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES:
		return &OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authentication_Users_User_Config_Role_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authentication_Users_User_State represents the /openconfig-system/system/aaa/authentication/users/user/state YANG schema element.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_State struct {
	Password	*string	`path:"password" module:"openconfig-system"`
	PasswordHashed	*string	`path:"password-hashed" module:"openconfig-system"`
	Role	OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union	`path:"role" module:"openconfig-system"`
	SshKey	*string	`path:"ssh-key" module:"openconfig-system"`
	Username	*string	`path:"username" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authentication_Users_User_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authentication_Users_User_State.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authentication/users/user/state/role within the YANG schema.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union()
}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES is used when /openconfig-system/system/aaa/authentication/users/user/state/role
// is to be set to a E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES value.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES struct {
	E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES	E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
// implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES) Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union() {}

// OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_String is used when /openconfig-system/system/aaa/authentication/users/user/state/role
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union ensures that OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_String
// implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union interface.
func (*OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_String) Is_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union() {}

// To_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authentication_Users_User_State) To_OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES:
		return &OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authentication_Users_User_State_Role_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authorization represents the /openconfig-system/system/aaa/authorization YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization struct {
	Config	*OpenconfigSystem_System_Aaa_Authorization_Config	`path:"config" module:"openconfig-system"`
	Events	*OpenconfigSystem_System_Aaa_Authorization_Events	`path:"events" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Authorization_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization.
func (*OpenconfigSystem_System_Aaa_Authorization) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authorization_Config represents the /openconfig-system/system/aaa/authorization/config YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_Config struct {
	AuthorizationMethod	[]OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union	`path:"authorization-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_Config.
func (*OpenconfigSystem_System_Aaa_Authorization_Config) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authorization/config/authorization-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union()
}

// OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/authorization/config/authorization-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union() {}

// OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_String is used when /openconfig-system/system/aaa/authorization/config/authorization-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authorization_Config) To_OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authorization_Config_AuthorizationMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Authorization_Events represents the /openconfig-system/system/aaa/authorization/events YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_Events struct {
	Event	map[E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE]*OpenconfigSystem_System_Aaa_Authorization_Events_Event	`path:"event" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_Events implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_Events) IsYANGGoStruct() {}

// NewEvent creates a new entry in the Event list of the
// OpenconfigSystem_System_Aaa_Authorization_Events struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events) NewEvent(EventType E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE) (*OpenconfigSystem_System_Aaa_Authorization_Events_Event, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Event == nil {
		t.Event = make(map[E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE]*OpenconfigSystem_System_Aaa_Authorization_Events_Event)
	}

	key := EventType

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Event[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Event", key)
	}

	t.Event[key] = &OpenconfigSystem_System_Aaa_Authorization_Events_Event{
		EventType: EventType,
	}

	return t.Event[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_Events"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_Events.
func (*OpenconfigSystem_System_Aaa_Authorization_Events) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authorization_Events_Event represents the /openconfig-system/system/aaa/authorization/events/event YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_Events_Event struct {
	Config	*OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config	`path:"config" module:"openconfig-system"`
	EventType	E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_Authorization_Events_Event_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_Events_Event implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Aaa_Authorization_Events_Event struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"event-type": t.EventType,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_Events_Event"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_Events_Event.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config represents the /openconfig-system/system/aaa/authorization/events/event/config YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config struct {
	EventType	E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authorization_Events_Event_State represents the /openconfig-system/system/aaa/authorization/events/event/state YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_Events_Event_State struct {
	EventType	E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE	`path:"event-type" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_Events_Event_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_Events_Event_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_Events_Event_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_Events_Event_State.
func (*OpenconfigSystem_System_Aaa_Authorization_Events_Event_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_Authorization_State represents the /openconfig-system/system/aaa/authorization/state YANG schema element.
type OpenconfigSystem_System_Aaa_Authorization_State struct {
	AuthorizationMethod	[]OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union	`path:"authorization-method" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Authorization_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Authorization_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Authorization_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Authorization_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Authorization_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Authorization_State.
func (*OpenconfigSystem_System_Aaa_Authorization_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/aaa/authorization/state/authorization-method within the YANG schema.
type OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union interface {
	Is_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union()
}

// OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE is used when /openconfig-system/system/aaa/authorization/state/authorization-method
// is to be set to a E_OpenconfigAaaTypes_AAA_METHOD_TYPE value.
type OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE struct {
	E_OpenconfigAaaTypes_AAA_METHOD_TYPE	E_OpenconfigAaaTypes_AAA_METHOD_TYPE
}

// Is_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE
// implements the OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE) Is_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union() {}

// OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_String is used when /openconfig-system/system/aaa/authorization/state/authorization-method
// is to be set to a string value.
type OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union ensures that OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_String
// implements the OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union interface.
func (*OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_String) Is_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union() {}

// To_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Aaa_Authorization_State) To_OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union(i interface{}) (OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAaaTypes_AAA_METHOD_TYPE:
		return &OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_E_OpenconfigAaaTypes_AAA_METHOD_TYPE{v}, nil
	case string:
		return &OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Aaa_Authorization_State_AuthorizationMethod_Union, unknown union type, got: %T, want any of [E_OpenconfigAaaTypes_AAA_METHOD_TYPE, string]", i, i)
	}
}


// OpenconfigSystem_System_Aaa_Config represents the /openconfig-system/system/aaa/config YANG schema element.
type OpenconfigSystem_System_Aaa_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_Config.
func (*OpenconfigSystem_System_Aaa_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups represents the /openconfig-system/system/aaa/server-groups YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups struct {
	ServerGroup	map[string]*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup	`path:"server-group" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups) IsYANGGoStruct() {}

// NewServerGroup creates a new entry in the ServerGroup list of the
// OpenconfigSystem_System_Aaa_ServerGroups struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Aaa_ServerGroups) NewServerGroup(Name string) (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.ServerGroup == nil {
		t.ServerGroup = make(map[string]*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.ServerGroup[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list ServerGroup", key)
	}

	t.ServerGroup[key] = &OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup{
		Name: &Name,
	}

	return t.ServerGroup[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups.
func (*OpenconfigSystem_System_Aaa_ServerGroups) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup represents the /openconfig-system/system/aaa/server-groups/server-group YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup struct {
	Config	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config	`path:"config" module:"openconfig-system"`
	Name	*string	`path:"name" module:"openconfig-system"`
	Servers	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers	`path:"servers" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config represents the /openconfig-system/system/aaa/server-groups/server-group/config YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config struct {
	Name	*string	`path:"name" module:"openconfig-system"`
	Type	E_OpenconfigAaaTypes_AAA_SERVER_TYPE	`path:"type" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers represents the /openconfig-system/system/aaa/server-groups/server-group/servers YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers struct {
	Server	map[string]*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server	`path:"server" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) IsYANGGoStruct() {}

// NewServer creates a new entry in the Server list of the
// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) NewServer(Address string) (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Server == nil {
		t.Server = make(map[string]*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server)
	}

	key := Address

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Server[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Server", key)
	}

	t.Server[key] = &OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server{
		Address: &Address,
	}

	return t.Server[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config	`path:"config" module:"openconfig-system"`
	Radius	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius	`path:"radius" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State	`path:"state" module:"openconfig-system"`
	Tacacs	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs	`path:"tacacs" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Address == nil {
		return nil, fmt.Errorf("nil value for key Address")
	}

	return map[string]interface{}{
		"address": *t.Address,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/config YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Name	*string	`path:"name" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/radius YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius struct {
	Config	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/radius/config YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config struct {
	AcctPort	*uint16	`path:"acct-port" module:"openconfig-system"`
	AuthPort	*uint16	`path:"auth-port" module:"openconfig-system"`
	RetransmitAttempts	*uint8	`path:"retransmit-attempts" module:"openconfig-system"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-system"`
	SecretKeyHashed	*string	`path:"secret-key-hashed" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/radius/state YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State struct {
	AcctPort	*uint16	`path:"acct-port" module:"openconfig-system"`
	AuthPort	*uint16	`path:"auth-port" module:"openconfig-system"`
	Counters	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters	`path:"counters" module:"openconfig-system"`
	RetransmitAttempts	*uint8	`path:"retransmit-attempts" module:"openconfig-system"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-system"`
	SecretKeyHashed	*string	`path:"secret-key-hashed" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/radius/state/counters YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters struct {
	AccessAccepts	*uint64	`path:"access-accepts" module:"openconfig-system"`
	AccessRejects	*uint64	`path:"access-rejects" module:"openconfig-system"`
	RetriedAccessRequests	*uint64	`path:"retried-access-requests" module:"openconfig-system"`
	TimeoutAccessRequests	*uint64	`path:"timeout-access-requests" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Radius_State_Counters) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/state YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	ConnectionAborts	*uint64	`path:"connection-aborts" module:"openconfig-system"`
	ConnectionCloses	*uint64	`path:"connection-closes" module:"openconfig-system"`
	ConnectionFailures	*uint64	`path:"connection-failures" module:"openconfig-system"`
	ConnectionOpens	*uint64	`path:"connection-opens" module:"openconfig-system"`
	ConnectionTimeouts	*uint64	`path:"connection-timeouts" module:"openconfig-system"`
	ErrorsReceived	*uint64	`path:"errors-received" module:"openconfig-system"`
	MessagesReceived	*uint64	`path:"messages-received" module:"openconfig-system"`
	MessagesSent	*uint64	`path:"messages-sent" module:"openconfig-system"`
	Name	*string	`path:"name" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/tacacs YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs struct {
	Config	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/tacacs/config YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config struct {
	Port	*uint16	`path:"port" module:"openconfig-system"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-system"`
	SecretKeyHashed	*string	`path:"secret-key-hashed" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State represents the /openconfig-system/system/aaa/server-groups/server-group/servers/server/tacacs/state YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State struct {
	Port	*uint16	`path:"port" module:"openconfig-system"`
	SecretKey	*string	`path:"secret-key" module:"openconfig-system"`
	SecretKeyHashed	*string	`path:"secret-key-hashed" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_Servers_Server_Tacacs_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State represents the /openconfig-system/system/aaa/server-groups/server-group/state YANG schema element.
type OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State struct {
	Name	*string	`path:"name" module:"openconfig-system"`
	Type	E_OpenconfigAaaTypes_AAA_SERVER_TYPE	`path:"type" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State.
func (*OpenconfigSystem_System_Aaa_ServerGroups_ServerGroup_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Aaa_State represents the /openconfig-system/system/aaa/state YANG schema element.
type OpenconfigSystem_System_Aaa_State struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Aaa_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Aaa_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Aaa_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Aaa_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Aaa_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Aaa_State.
func (*OpenconfigSystem_System_Aaa_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Alarms represents the /openconfig-system/system/alarms YANG schema element.
type OpenconfigSystem_System_Alarms struct {
	Alarm	map[string]*OpenconfigSystem_System_Alarms_Alarm	`path:"alarm" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Alarms implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Alarms) IsYANGGoStruct() {}

// NewAlarm creates a new entry in the Alarm list of the
// OpenconfigSystem_System_Alarms struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Alarms) NewAlarm(Id string) (*OpenconfigSystem_System_Alarms_Alarm, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Alarm == nil {
		t.Alarm = make(map[string]*OpenconfigSystem_System_Alarms_Alarm)
	}

	key := Id

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Alarm[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Alarm", key)
	}

	t.Alarm[key] = &OpenconfigSystem_System_Alarms_Alarm{
		Id: &Id,
	}

	return t.Alarm[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Alarms"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Alarms) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Alarms.
func (*OpenconfigSystem_System_Alarms) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Alarms_Alarm represents the /openconfig-system/system/alarms/alarm YANG schema element.
type OpenconfigSystem_System_Alarms_Alarm struct {
	Config	*OpenconfigSystem_System_Alarms_Alarm_Config	`path:"config" module:"openconfig-system"`
	Id	*string	`path:"id" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Alarms_Alarm_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Alarms_Alarm implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Alarms_Alarm) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Alarms_Alarm struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Alarms_Alarm) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Id == nil {
		return nil, fmt.Errorf("nil value for key Id")
	}

	return map[string]interface{}{
		"id": *t.Id,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Alarms_Alarm"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Alarms_Alarm) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Alarms_Alarm.
func (*OpenconfigSystem_System_Alarms_Alarm) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Alarms_Alarm_Config represents the /openconfig-system/system/alarms/alarm/config YANG schema element.
type OpenconfigSystem_System_Alarms_Alarm_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Alarms_Alarm_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Alarms_Alarm_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Alarms_Alarm_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Alarms_Alarm_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Alarms_Alarm_Config.
func (*OpenconfigSystem_System_Alarms_Alarm_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Alarms_Alarm_State represents the /openconfig-system/system/alarms/alarm/state YANG schema element.
type OpenconfigSystem_System_Alarms_Alarm_State struct {
	Id	*string	`path:"id" module:"openconfig-system"`
	Resource	*string	`path:"resource" module:"openconfig-system"`
	Severity	E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY	`path:"severity" module:"openconfig-system"`
	Text	*string	`path:"text" module:"openconfig-system"`
	TimeCreated	*uint64	`path:"time-created" module:"openconfig-system"`
	TypeId	OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union	`path:"type-id" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Alarms_Alarm_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Alarms_Alarm_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Alarms_Alarm_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Alarms_Alarm_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Alarms_Alarm_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Alarms_Alarm_State.
func (*OpenconfigSystem_System_Alarms_Alarm_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/alarms/alarm/state/type-id within the YANG schema.
type OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union interface {
	Is_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union()
}

// OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID is used when /openconfig-system/system/alarms/alarm/state/type-id
// is to be set to a E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID value.
type OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID struct {
	E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID	E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
}

// Is_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union ensures that OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
// implements the OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union interface.
func (*OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID) Is_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union() {}

// OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_String is used when /openconfig-system/system/alarms/alarm/state/type-id
// is to be set to a string value.
type OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union ensures that OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_String
// implements the OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union interface.
func (*OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_String) Is_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union() {}

// To_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Alarms_Alarm_State) To_OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union(i interface{}) (OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID:
		return &OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID{v}, nil
	case string:
		return &OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Alarms_Alarm_State_TypeId_Union, unknown union type, got: %T, want any of [E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID, string]", i, i)
	}
}


// OpenconfigSystem_System_Clock represents the /openconfig-system/system/clock YANG schema element.
type OpenconfigSystem_System_Clock struct {
	Config	*OpenconfigSystem_System_Clock_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Clock_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Clock implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Clock) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Clock"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Clock) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Clock.
func (*OpenconfigSystem_System_Clock) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Clock_Config represents the /openconfig-system/system/clock/config YANG schema element.
type OpenconfigSystem_System_Clock_Config struct {
	TimezoneName	*string	`path:"timezone-name" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Clock_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Clock_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Clock_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Clock_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Clock_Config.
func (*OpenconfigSystem_System_Clock_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Clock_State represents the /openconfig-system/system/clock/state YANG schema element.
type OpenconfigSystem_System_Clock_State struct {
	TimezoneName	*string	`path:"timezone-name" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Clock_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Clock_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Clock_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Clock_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Clock_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Clock_State.
func (*OpenconfigSystem_System_Clock_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Config represents the /openconfig-system/system/config YANG schema element.
type OpenconfigSystem_System_Config struct {
	DomainName	*string	`path:"domain-name" module:"openconfig-system"`
	Hostname	*string	`path:"hostname" module:"openconfig-system"`
	LoginBanner	*string	`path:"login-banner" module:"openconfig-system"`
	MotdBanner	*string	`path:"motd-banner" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Config.
func (*OpenconfigSystem_System_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus represents the /openconfig-system/system/cpus YANG schema element.
type OpenconfigSystem_System_Cpus struct {
	Cpu	map[OpenconfigSystem_System_Cpus_Cpu_State_Index_Union]*OpenconfigSystem_System_Cpus_Cpu	`path:"cpu" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus) IsYANGGoStruct() {}

// NewCpu creates a new entry in the Cpu list of the
// OpenconfigSystem_System_Cpus struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Cpus) NewCpu(Index OpenconfigSystem_System_Cpus_Cpu_State_Index_Union) (*OpenconfigSystem_System_Cpus_Cpu, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Cpu == nil {
		t.Cpu = make(map[OpenconfigSystem_System_Cpus_Cpu_State_Index_Union]*OpenconfigSystem_System_Cpus_Cpu)
	}

	key := Index

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Cpu[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Cpu", key)
	}

	t.Cpu[key] = &OpenconfigSystem_System_Cpus_Cpu{
		Index: Index,
	}

	return t.Cpu[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus.
func (*OpenconfigSystem_System_Cpus) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu represents the /openconfig-system/system/cpus/cpu YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu struct {
	Index	OpenconfigSystem_System_Cpus_Cpu_State_Index_Union	`path:"index" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Cpus_Cpu_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Cpus_Cpu struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Cpus_Cpu) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"index": t.Index,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu.
func (*OpenconfigSystem_System_Cpus_Cpu) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_Cpus_Cpu_State_Index_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/cpus/cpu/index within the YANG schema.
type OpenconfigSystem_System_Cpus_Cpu_State_Index_Union interface {
	Is_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union()
}

// OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index is used when /openconfig-system/system/cpus/cpu/index
// is to be set to a E_OpenconfigSystem_System_Cpus_Cpu_State_Index value.
type OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index struct {
	E_OpenconfigSystem_System_Cpus_Cpu_State_Index	E_OpenconfigSystem_System_Cpus_Cpu_State_Index
}

// Is_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union ensures that OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index
// implements the OpenconfigSystem_System_Cpus_Cpu_State_Index_Union interface.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index) Is_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union() {}

// OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32 is used when /openconfig-system/system/cpus/cpu/index
// is to be set to a uint32 value.
type OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32 struct {
	Uint32	uint32
}

// Is_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union ensures that OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32
// implements the OpenconfigSystem_System_Cpus_Cpu_State_Index_Union interface.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32) Is_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union() {}

// To_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Cpus_Cpu_State_Index_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Cpus_Cpu) To_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union(i interface{}) (OpenconfigSystem_System_Cpus_Cpu_State_Index_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigSystem_System_Cpus_Cpu_State_Index:
		return &OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index{v}, nil
	case uint32:
		return &OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Cpus_Cpu_State_Index_Union, unknown union type, got: %T, want any of [E_OpenconfigSystem_System_Cpus_Cpu_State_Index, uint32]", i, i)
	}
}


// OpenconfigSystem_System_Cpus_Cpu_State represents the /openconfig-system/system/cpus/cpu/state YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State struct {
	HardwareInterrupt	*OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt	`path:"hardware-interrupt" module:"openconfig-system"`
	Idle	*OpenconfigSystem_System_Cpus_Cpu_State_Idle	`path:"idle" module:"openconfig-system"`
	Index	OpenconfigSystem_System_Cpus_Cpu_State_Index_Union	`path:"index" module:"openconfig-system"`
	Kernel	*OpenconfigSystem_System_Cpus_Cpu_State_Kernel	`path:"kernel" module:"openconfig-system"`
	Nice	*OpenconfigSystem_System_Cpus_Cpu_State_Nice	`path:"nice" module:"openconfig-system"`
	SoftwareInterrupt	*OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt	`path:"software-interrupt" module:"openconfig-system"`
	Total	*OpenconfigSystem_System_Cpus_Cpu_State_Total	`path:"total" module:"openconfig-system"`
	User	*OpenconfigSystem_System_Cpus_Cpu_State_User	`path:"user" module:"openconfig-system"`
	Wait	*OpenconfigSystem_System_Cpus_Cpu_State_Wait	`path:"wait" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State.
func (*OpenconfigSystem_System_Cpus_Cpu_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// To_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_Cpus_Cpu_State_Index_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_Cpus_Cpu_State) To_OpenconfigSystem_System_Cpus_Cpu_State_Index_Union(i interface{}) (OpenconfigSystem_System_Cpus_Cpu_State_Index_Union, error) {
	switch v := i.(type) {
	case E_OpenconfigSystem_System_Cpus_Cpu_State_Index:
		return &OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_E_OpenconfigSystem_System_Cpus_Cpu_State_Index{v}, nil
	case uint32:
		return &OpenconfigSystem_System_Cpus_Cpu_State_Index_Union_Uint32{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_Cpus_Cpu_State_Index_Union, unknown union type, got: %T, want any of [E_OpenconfigSystem_System_Cpus_Cpu_State_Index, uint32]", i, i)
	}
}


// OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt represents the /openconfig-system/system/cpus/cpu/state/hardware-interrupt YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt.
func (*OpenconfigSystem_System_Cpus_Cpu_State_HardwareInterrupt) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_Idle represents the /openconfig-system/system/cpus/cpu/state/idle YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_Idle struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_Idle implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Idle) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Idle) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_Idle"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Idle) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Idle) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_Idle.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Idle) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_Kernel represents the /openconfig-system/system/cpus/cpu/state/kernel YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_Kernel struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_Kernel implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Kernel) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Kernel) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_Kernel"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Kernel) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Kernel) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_Kernel.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Kernel) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_Nice represents the /openconfig-system/system/cpus/cpu/state/nice YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_Nice struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_Nice implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Nice) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Nice) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_Nice"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Nice) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Nice) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_Nice.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Nice) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt represents the /openconfig-system/system/cpus/cpu/state/software-interrupt YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt.
func (*OpenconfigSystem_System_Cpus_Cpu_State_SoftwareInterrupt) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_Total represents the /openconfig-system/system/cpus/cpu/state/total YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_Total struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_Total implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Total) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Total) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_Total"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Total) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Total) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_Total.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Total) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_User represents the /openconfig-system/system/cpus/cpu/state/user YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_User struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_User implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_User) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_User) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_User"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_User) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_User) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_User.
func (*OpenconfigSystem_System_Cpus_Cpu_State_User) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Cpus_Cpu_State_Wait represents the /openconfig-system/system/cpus/cpu/state/wait YANG schema element.
type OpenconfigSystem_System_Cpus_Cpu_State_Wait struct {
	Avg	*uint8	`path:"avg" module:"openconfig-system"`
	Instant	*uint8	`path:"instant" module:"openconfig-system"`
	Interval	*uint64	`path:"interval" module:"openconfig-system"`
	Max	*uint8	`path:"max" module:"openconfig-system"`
	MaxTime	*uint64	`path:"max-time" module:"openconfig-system"`
	Min	*uint8	`path:"min" module:"openconfig-system"`
	MinTime	*uint64	`path:"min-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Cpus_Cpu_State_Wait implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Wait) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Wait) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Cpus_Cpu_State_Wait"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Wait) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Cpus_Cpu_State_Wait) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Cpus_Cpu_State_Wait.
func (*OpenconfigSystem_System_Cpus_Cpu_State_Wait) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns represents the /openconfig-system/system/dns YANG schema element.
type OpenconfigSystem_System_Dns struct {
	Config	*OpenconfigSystem_System_Dns_Config	`path:"config" module:"openconfig-system"`
	HostEntries	*OpenconfigSystem_System_Dns_HostEntries	`path:"host-entries" module:"openconfig-system"`
	Servers	*OpenconfigSystem_System_Dns_Servers	`path:"servers" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Dns_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns.
func (*OpenconfigSystem_System_Dns) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_Config represents the /openconfig-system/system/dns/config YANG schema element.
type OpenconfigSystem_System_Dns_Config struct {
	Search	[]string	`path:"search" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_Config.
func (*OpenconfigSystem_System_Dns_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_HostEntries represents the /openconfig-system/system/dns/host-entries YANG schema element.
type OpenconfigSystem_System_Dns_HostEntries struct {
	HostEntry	map[string]*OpenconfigSystem_System_Dns_HostEntries_HostEntry	`path:"host-entry" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_HostEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_HostEntries) IsYANGGoStruct() {}

// NewHostEntry creates a new entry in the HostEntry list of the
// OpenconfigSystem_System_Dns_HostEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Dns_HostEntries) NewHostEntry(Hostname string) (*OpenconfigSystem_System_Dns_HostEntries_HostEntry, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.HostEntry == nil {
		t.HostEntry = make(map[string]*OpenconfigSystem_System_Dns_HostEntries_HostEntry)
	}

	key := Hostname

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.HostEntry[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list HostEntry", key)
	}

	t.HostEntry[key] = &OpenconfigSystem_System_Dns_HostEntries_HostEntry{
		Hostname: &Hostname,
	}

	return t.HostEntry[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_HostEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_HostEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_HostEntries.
func (*OpenconfigSystem_System_Dns_HostEntries) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_HostEntries_HostEntry represents the /openconfig-system/system/dns/host-entries/host-entry YANG schema element.
type OpenconfigSystem_System_Dns_HostEntries_HostEntry struct {
	Config	*OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config	`path:"config" module:"openconfig-system"`
	Hostname	*string	`path:"hostname" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Dns_HostEntries_HostEntry_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_HostEntries_HostEntry implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Dns_HostEntries_HostEntry struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Hostname == nil {
		return nil, fmt.Errorf("nil value for key Hostname")
	}

	return map[string]interface{}{
		"hostname": *t.Hostname,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_HostEntries_HostEntry"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_HostEntries_HostEntry.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config represents the /openconfig-system/system/dns/host-entries/host-entry/config YANG schema element.
type OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config struct {
	Alias	[]string	`path:"alias" module:"openconfig-system"`
	Hostname	*string	`path:"hostname" module:"openconfig-system"`
	Ipv4Address	[]string	`path:"ipv4-address" module:"openconfig-system"`
	Ipv6Address	[]string	`path:"ipv6-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_HostEntries_HostEntry_State represents the /openconfig-system/system/dns/host-entries/host-entry/state YANG schema element.
type OpenconfigSystem_System_Dns_HostEntries_HostEntry_State struct {
	Alias	[]string	`path:"alias" module:"openconfig-system"`
	Hostname	*string	`path:"hostname" module:"openconfig-system"`
	Ipv4Address	[]string	`path:"ipv4-address" module:"openconfig-system"`
	Ipv6Address	[]string	`path:"ipv6-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_HostEntries_HostEntry_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_HostEntries_HostEntry_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_HostEntries_HostEntry_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_HostEntries_HostEntry_State.
func (*OpenconfigSystem_System_Dns_HostEntries_HostEntry_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_Servers represents the /openconfig-system/system/dns/servers YANG schema element.
type OpenconfigSystem_System_Dns_Servers struct {
	Server	map[string]*OpenconfigSystem_System_Dns_Servers_Server	`path:"server" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_Servers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_Servers) IsYANGGoStruct() {}

// NewServer creates a new entry in the Server list of the
// OpenconfigSystem_System_Dns_Servers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Dns_Servers) NewServer(Address string) (*OpenconfigSystem_System_Dns_Servers_Server, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Server == nil {
		t.Server = make(map[string]*OpenconfigSystem_System_Dns_Servers_Server)
	}

	key := Address

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Server[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Server", key)
	}

	t.Server[key] = &OpenconfigSystem_System_Dns_Servers_Server{
		Address: &Address,
	}

	return t.Server[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_Servers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_Servers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_Servers.
func (*OpenconfigSystem_System_Dns_Servers) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_Servers_Server represents the /openconfig-system/system/dns/servers/server YANG schema element.
type OpenconfigSystem_System_Dns_Servers_Server struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Dns_Servers_Server_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Dns_Servers_Server_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_Servers_Server implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_Servers_Server) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Dns_Servers_Server struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Dns_Servers_Server) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Address == nil {
		return nil, fmt.Errorf("nil value for key Address")
	}

	return map[string]interface{}{
		"address": *t.Address,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_Servers_Server"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_Servers_Server) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_Servers_Server.
func (*OpenconfigSystem_System_Dns_Servers_Server) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_Servers_Server_Config represents the /openconfig-system/system/dns/servers/server/config YANG schema element.
type OpenconfigSystem_System_Dns_Servers_Server_Config struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Port	*uint16	`path:"port" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_Servers_Server_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_Servers_Server_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_Servers_Server_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_Servers_Server_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_Servers_Server_Config.
func (*OpenconfigSystem_System_Dns_Servers_Server_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_Servers_Server_State represents the /openconfig-system/system/dns/servers/server/state YANG schema element.
type OpenconfigSystem_System_Dns_Servers_Server_State struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Port	*uint16	`path:"port" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_Servers_Server_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_Servers_Server_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_Servers_Server_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_Servers_Server_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_Servers_Server_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_Servers_Server_State.
func (*OpenconfigSystem_System_Dns_Servers_Server_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Dns_State represents the /openconfig-system/system/dns/state YANG schema element.
type OpenconfigSystem_System_Dns_State struct {
	Search	[]string	`path:"search" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Dns_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Dns_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Dns_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Dns_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Dns_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Dns_State.
func (*OpenconfigSystem_System_Dns_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_License represents the /openconfig-system/system/license YANG schema element.
type OpenconfigSystem_System_License struct {
	Licenses	*OpenconfigSystem_System_License_Licenses	`path:"licenses" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_License implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_License) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_License"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_License) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_License.
func (*OpenconfigSystem_System_License) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_License_Licenses represents the /openconfig-system/system/license/licenses YANG schema element.
type OpenconfigSystem_System_License_Licenses struct {
	License	map[string]*OpenconfigSystem_System_License_Licenses_License	`path:"license" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_License_Licenses implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_License_Licenses) IsYANGGoStruct() {}

// NewLicense creates a new entry in the License list of the
// OpenconfigSystem_System_License_Licenses struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_License_Licenses) NewLicense(LicenseId string) (*OpenconfigSystem_System_License_Licenses_License, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.License == nil {
		t.License = make(map[string]*OpenconfigSystem_System_License_Licenses_License)
	}

	key := LicenseId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.License[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list License", key)
	}

	t.License[key] = &OpenconfigSystem_System_License_Licenses_License{
		LicenseId: &LicenseId,
	}

	return t.License[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_License_Licenses"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_License_Licenses) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_License_Licenses.
func (*OpenconfigSystem_System_License_Licenses) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_License_Licenses_License represents the /openconfig-system/system/license/licenses/license YANG schema element.
type OpenconfigSystem_System_License_Licenses_License struct {
	Config	*OpenconfigSystem_System_License_Licenses_License_Config	`path:"config" module:"openconfig-system"`
	LicenseId	*string	`path:"license-id" module:"openconfig-system"`
	State	*OpenconfigSystem_System_License_Licenses_License_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_License_Licenses_License implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_License_Licenses_License) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_License_Licenses_License struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_License_Licenses_License) ΛListKeyMap() (map[string]interface{}, error) {
	if t.LicenseId == nil {
		return nil, fmt.Errorf("nil value for key LicenseId")
	}

	return map[string]interface{}{
		"license-id": *t.LicenseId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_License_Licenses_License"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_License_Licenses_License) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_License_Licenses_License.
func (*OpenconfigSystem_System_License_Licenses_License) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_License_Licenses_License_Config represents the /openconfig-system/system/license/licenses/license/config YANG schema element.
type OpenconfigSystem_System_License_Licenses_License_Config struct {
	Active	*bool	`path:"active" module:"openconfig-system"`
	LicenseData	OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union	`path:"license-data" module:"openconfig-system"`
	LicenseId	*string	`path:"license-id" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_License_Licenses_License_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_License_Licenses_License_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_License_Licenses_License_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_License_Licenses_License_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_License_Licenses_License_Config.
func (*OpenconfigSystem_System_License_Licenses_License_Config) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/license/licenses/license/config/license-data within the YANG schema.
type OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union interface {
	Is_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union()
}

// OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_Binary is used when /openconfig-system/system/license/licenses/license/config/license-data
// is to be set to a Binary value.
type OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_Binary struct {
	Binary	Binary
}

// Is_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union ensures that OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_Binary
// implements the OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union interface.
func (*OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_Binary) Is_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union() {}

// OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_String is used when /openconfig-system/system/license/licenses/license/config/license-data
// is to be set to a string value.
type OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union ensures that OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_String
// implements the OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union interface.
func (*OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_String) Is_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union() {}

// To_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_License_Licenses_License_Config) To_OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union(i interface{}) (OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union, error) {
	switch v := i.(type) {
	case Binary:
		return &OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_Binary{v}, nil
	case string:
		return &OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_License_Licenses_License_Config_LicenseData_Union, unknown union type, got: %T, want any of [Binary, string]", i, i)
	}
}


// OpenconfigSystem_System_License_Licenses_License_State represents the /openconfig-system/system/license/licenses/license/state YANG schema element.
type OpenconfigSystem_System_License_Licenses_License_State struct {
	Active	*bool	`path:"active" module:"openconfig-system"`
	Description	*string	`path:"description" module:"openconfig-system"`
	ExpirationDate	*uint64	`path:"expiration-date" module:"openconfig-system"`
	Expired	*bool	`path:"expired" module:"openconfig-system"`
	InUse	*bool	`path:"in-use" module:"openconfig-system"`
	IssueDate	*uint64	`path:"issue-date" module:"openconfig-system"`
	LicenseData	OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union	`path:"license-data" module:"openconfig-system"`
	LicenseId	*string	`path:"license-id" module:"openconfig-system"`
	Valid	*bool	`path:"valid" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_License_Licenses_License_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_License_Licenses_License_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_License_Licenses_License_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_License_Licenses_License_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_License_Licenses_License_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_License_Licenses_License_State.
func (*OpenconfigSystem_System_License_Licenses_License_State) ΛBelongingModule() string {
	return "openconfig-system"
}

// OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union is an interface that is implemented by valid types for the union
// for the leaf /openconfig-system/system/license/licenses/license/state/license-data within the YANG schema.
type OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union interface {
	Is_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union()
}

// OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_Binary is used when /openconfig-system/system/license/licenses/license/state/license-data
// is to be set to a Binary value.
type OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_Binary struct {
	Binary	Binary
}

// Is_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union ensures that OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_Binary
// implements the OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union interface.
func (*OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_Binary) Is_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union() {}

// OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_String is used when /openconfig-system/system/license/licenses/license/state/license-data
// is to be set to a string value.
type OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_String struct {
	String	string
}

// Is_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union ensures that OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_String
// implements the OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union interface.
func (*OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_String) Is_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union() {}

// To_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union takes an input interface{} and attempts to convert it to a struct
// which implements the OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union union. It returns an error if the interface{} supplied
// cannot be converted to a type within the union.
func (t *OpenconfigSystem_System_License_Licenses_License_State) To_OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union(i interface{}) (OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union, error) {
	switch v := i.(type) {
	case Binary:
		return &OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_Binary{v}, nil
	case string:
		return &OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union_String{v}, nil
	default:
		return nil, fmt.Errorf("cannot convert %v to OpenconfigSystem_System_License_Licenses_License_State_LicenseData_Union, unknown union type, got: %T, want any of [Binary, string]", i, i)
	}
}


// OpenconfigSystem_System_Logging represents the /openconfig-system/system/logging YANG schema element.
type OpenconfigSystem_System_Logging struct {
	Console	*OpenconfigSystem_System_Logging_Console	`path:"console" module:"openconfig-system"`
	RemoteServers	*OpenconfigSystem_System_Logging_RemoteServers	`path:"remote-servers" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging.
func (*OpenconfigSystem_System_Logging) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console represents the /openconfig-system/system/logging/console YANG schema element.
type OpenconfigSystem_System_Logging_Console struct {
	Config	*OpenconfigSystem_System_Logging_Console_Config	`path:"config" module:"openconfig-system"`
	Selectors	*OpenconfigSystem_System_Logging_Console_Selectors	`path:"selectors" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Logging_Console_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console.
func (*OpenconfigSystem_System_Logging_Console) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_Config represents the /openconfig-system/system/logging/console/config YANG schema element.
type OpenconfigSystem_System_Logging_Console_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_Config.
func (*OpenconfigSystem_System_Logging_Console_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_Selectors represents the /openconfig-system/system/logging/console/selectors YANG schema element.
type OpenconfigSystem_System_Logging_Console_Selectors struct {
	Selector	map[OpenconfigSystem_System_Logging_Console_Selectors_Selector_Key]*OpenconfigSystem_System_Logging_Console_Selectors_Selector	`path:"selector" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_Selectors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_Selectors) IsYANGGoStruct() {}

// OpenconfigSystem_System_Logging_Console_Selectors_Selector_Key represents the key for list Selector of element /openconfig-system/system/logging/console/selectors.
type OpenconfigSystem_System_Logging_Console_Selectors_Selector_Key struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity"`
}

// NewSelector creates a new entry in the Selector list of the
// OpenconfigSystem_System_Logging_Console_Selectors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Logging_Console_Selectors) NewSelector(Facility E_OpenconfigSystemLogging_SYSLOG_FACILITY, Severity E_OpenconfigSystemLogging_SyslogSeverity) (*OpenconfigSystem_System_Logging_Console_Selectors_Selector, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Selector == nil {
		t.Selector = make(map[OpenconfigSystem_System_Logging_Console_Selectors_Selector_Key]*OpenconfigSystem_System_Logging_Console_Selectors_Selector)
	}

	key := OpenconfigSystem_System_Logging_Console_Selectors_Selector_Key{
		Facility: Facility,
		Severity: Severity,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Selector[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Selector", key)
	}

	t.Selector[key] = &OpenconfigSystem_System_Logging_Console_Selectors_Selector{
		Facility: Facility,
		Severity: Severity,
	}

	return t.Selector[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_Selectors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_Selectors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_Selectors.
func (*OpenconfigSystem_System_Logging_Console_Selectors) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_Selectors_Selector represents the /openconfig-system/system/logging/console/selectors/selector YANG schema element.
type OpenconfigSystem_System_Logging_Console_Selectors_Selector struct {
	Config	*OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config	`path:"config" module:"openconfig-system"`
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Logging_Console_Selectors_Selector_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_Selectors_Selector implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Logging_Console_Selectors_Selector struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector) ΛListKeyMap() (map[string]interface{}, error) {


	return map[string]interface{}{
		"facility": t.Facility,
		"severity": t.Severity,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_Selectors_Selector"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_Selectors_Selector.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config represents the /openconfig-system/system/logging/console/selectors/selector/config YANG schema element.
type OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_Selectors_Selector_State represents the /openconfig-system/system/logging/console/selectors/selector/state YANG schema element.
type OpenconfigSystem_System_Logging_Console_Selectors_Selector_State struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_Selectors_Selector_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_Selectors_Selector_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_Selectors_Selector_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_Selectors_Selector_State.
func (*OpenconfigSystem_System_Logging_Console_Selectors_Selector_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_Console_State represents the /openconfig-system/system/logging/console/state YANG schema element.
type OpenconfigSystem_System_Logging_Console_State struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_Console_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_Console_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_Console_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_Console_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_Console_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_Console_State.
func (*OpenconfigSystem_System_Logging_Console_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers represents the /openconfig-system/system/logging/remote-servers YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers struct {
	RemoteServer	map[string]*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer	`path:"remote-server" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers) IsYANGGoStruct() {}

// NewRemoteServer creates a new entry in the RemoteServer list of the
// OpenconfigSystem_System_Logging_RemoteServers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Logging_RemoteServers) NewRemoteServer(Host string) (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.RemoteServer == nil {
		t.RemoteServer = make(map[string]*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer)
	}

	key := Host

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.RemoteServer[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list RemoteServer", key)
	}

	t.RemoteServer[key] = &OpenconfigSystem_System_Logging_RemoteServers_RemoteServer{
		Host: &Host,
	}

	return t.RemoteServer[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers.
func (*OpenconfigSystem_System_Logging_RemoteServers) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer represents the /openconfig-system/system/logging/remote-servers/remote-server YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer struct {
	Config	*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config	`path:"config" module:"openconfig-system"`
	Host	*string	`path:"host" module:"openconfig-system"`
	Selectors	*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors	`path:"selectors" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Logging_RemoteServers_RemoteServer struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Host == nil {
		return nil, fmt.Errorf("nil value for key Host")
	}

	return map[string]interface{}{
		"host": *t.Host,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config represents the /openconfig-system/system/logging/remote-servers/remote-server/config YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config struct {
	Host	*string	`path:"host" module:"openconfig-system"`
	RemotePort	*uint16	`path:"remote-port" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors represents the /openconfig-system/system/logging/remote-servers/remote-server/selectors YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors struct {
	Selector	map[OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Key]*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector	`path:"selector" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) IsYANGGoStruct() {}

// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Key represents the key for list Selector of element /openconfig-system/system/logging/remote-servers/remote-server/selectors.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Key struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity"`
}

// NewSelector creates a new entry in the Selector list of the
// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) NewSelector(Facility E_OpenconfigSystemLogging_SYSLOG_FACILITY, Severity E_OpenconfigSystemLogging_SyslogSeverity) (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Selector == nil {
		t.Selector = make(map[OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Key]*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector)
	}

	key := OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Key{
		Facility: Facility,
		Severity: Severity,
	}

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Selector[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Selector", key)
	}

	t.Selector[key] = &OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector{
		Facility: Facility,
		Severity: Severity,
	}

	return t.Selector[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector represents the /openconfig-system/system/logging/remote-servers/remote-server/selectors/selector YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector struct {
	Config	*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config	`path:"config" module:"openconfig-system"`
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) ΛListKeyMap() (map[string]interface{}, error) {


	return map[string]interface{}{
		"facility": t.Facility,
		"severity": t.Severity,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config represents the /openconfig-system/system/logging/remote-servers/remote-server/selectors/selector/config YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State represents the /openconfig-system/system/logging/remote-servers/remote-server/selectors/selector/state YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State struct {
	Facility	E_OpenconfigSystemLogging_SYSLOG_FACILITY	`path:"facility" module:"openconfig-system"`
	Severity	E_OpenconfigSystemLogging_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_Selectors_Selector_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State represents the /openconfig-system/system/logging/remote-servers/remote-server/state YANG schema element.
type OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State struct {
	Host	*string	`path:"host" module:"openconfig-system"`
	RemotePort	*uint16	`path:"remote-port" module:"openconfig-system"`
	SourceAddress	*string	`path:"source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State.
func (*OpenconfigSystem_System_Logging_RemoteServers_RemoteServer_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Memory represents the /openconfig-system/system/memory YANG schema element.
type OpenconfigSystem_System_Memory struct {
	Config	*OpenconfigSystem_System_Memory_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Memory_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Memory implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Memory) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Memory"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Memory) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Memory.
func (*OpenconfigSystem_System_Memory) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Memory_Config represents the /openconfig-system/system/memory/config YANG schema element.
type OpenconfigSystem_System_Memory_Config struct {
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Memory_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Memory_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Memory_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Memory_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Memory_Config.
func (*OpenconfigSystem_System_Memory_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Memory_State represents the /openconfig-system/system/memory/state YANG schema element.
type OpenconfigSystem_System_Memory_State struct {
	Counters	*OpenconfigSystem_System_Memory_State_Counters	`path:"counters" module:"openconfig-system"`
	Free	*uint64	`path:"free" module:"openconfig-system"`
	Physical	*uint64	`path:"physical" module:"openconfig-system"`
	Reserved	*uint64	`path:"reserved" module:"openconfig-system"`
	Used	*uint64	`path:"used" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Memory_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Memory_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Memory_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Memory_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Memory_State.
func (*OpenconfigSystem_System_Memory_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Memory_State_Counters represents the /openconfig-system/system/memory/state/counters YANG schema element.
type OpenconfigSystem_System_Memory_State_Counters struct {
	CorrectableEccErrors	*uint64	`path:"correctable-ecc-errors" module:"openconfig-system"`
	TotalEccErrors	*uint64	`path:"total-ecc-errors" module:"openconfig-system"`
	UncorrectableEccErrors	*uint64	`path:"uncorrectable-ecc-errors" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Memory_State_Counters implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Memory_State_Counters) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_State_Counters) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Memory_State_Counters"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Memory_State_Counters) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Memory_State_Counters) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Memory_State_Counters.
func (*OpenconfigSystem_System_Memory_State_Counters) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages represents the /openconfig-system/system/messages YANG schema element.
type OpenconfigSystem_System_Messages struct {
	Config	*OpenconfigSystem_System_Messages_Config	`path:"config" module:"openconfig-system"`
	DebugEntries	*OpenconfigSystem_System_Messages_DebugEntries	`path:"debug-entries" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Messages_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages.
func (*OpenconfigSystem_System_Messages) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_Config represents the /openconfig-system/system/messages/config YANG schema element.
type OpenconfigSystem_System_Messages_Config struct {
	Severity	E_OpenconfigMessages_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_Config.
func (*OpenconfigSystem_System_Messages_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_DebugEntries represents the /openconfig-system/system/messages/debug-entries YANG schema element.
type OpenconfigSystem_System_Messages_DebugEntries struct {
	DebugService	map[E_OpenconfigMessages_DEBUG_SERVICE]*OpenconfigSystem_System_Messages_DebugEntries_DebugService	`path:"debug-service" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_DebugEntries implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_DebugEntries) IsYANGGoStruct() {}

// NewDebugService creates a new entry in the DebugService list of the
// OpenconfigSystem_System_Messages_DebugEntries struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Messages_DebugEntries) NewDebugService(Service E_OpenconfigMessages_DEBUG_SERVICE) (*OpenconfigSystem_System_Messages_DebugEntries_DebugService, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.DebugService == nil {
		t.DebugService = make(map[E_OpenconfigMessages_DEBUG_SERVICE]*OpenconfigSystem_System_Messages_DebugEntries_DebugService)
	}

	key := Service

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.DebugService[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list DebugService", key)
	}

	t.DebugService[key] = &OpenconfigSystem_System_Messages_DebugEntries_DebugService{
		Service: Service,
	}

	return t.DebugService[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_DebugEntries"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_DebugEntries) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_DebugEntries.
func (*OpenconfigSystem_System_Messages_DebugEntries) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_DebugEntries_DebugService represents the /openconfig-system/system/messages/debug-entries/debug-service YANG schema element.
type OpenconfigSystem_System_Messages_DebugEntries_DebugService struct {
	Config	*OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config	`path:"config" module:"openconfig-system"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Messages_DebugEntries_DebugService_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_DebugEntries_DebugService implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Messages_DebugEntries_DebugService struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService) ΛListKeyMap() (map[string]interface{}, error) {

	return map[string]interface{}{
		"service": t.Service,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_DebugEntries_DebugService"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_DebugEntries_DebugService.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config represents the /openconfig-system/system/messages/debug-entries/debug-service/config YANG schema element.
type OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-system"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_DebugEntries_DebugService_State represents the /openconfig-system/system/messages/debug-entries/debug-service/state YANG schema element.
type OpenconfigSystem_System_Messages_DebugEntries_DebugService_State struct {
	Enabled	*bool	`path:"enabled" module:"openconfig-system"`
	Service	E_OpenconfigMessages_DEBUG_SERVICE	`path:"service" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_DebugEntries_DebugService_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_DebugEntries_DebugService_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_DebugEntries_DebugService_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_DebugEntries_DebugService_State.
func (*OpenconfigSystem_System_Messages_DebugEntries_DebugService_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_State represents the /openconfig-system/system/messages/state YANG schema element.
type OpenconfigSystem_System_Messages_State struct {
	Message	*OpenconfigSystem_System_Messages_State_Message	`path:"message" module:"openconfig-system"`
	Severity	E_OpenconfigMessages_SyslogSeverity	`path:"severity" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_State.
func (*OpenconfigSystem_System_Messages_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Messages_State_Message represents the /openconfig-system/system/messages/state/message YANG schema element.
type OpenconfigSystem_System_Messages_State_Message struct {
	AppName	*string	`path:"app-name" module:"openconfig-system"`
	Msg	*string	`path:"msg" module:"openconfig-system"`
	Msgid	*string	`path:"msgid" module:"openconfig-system"`
	Priority	*uint8	`path:"priority" module:"openconfig-system"`
	Procid	*string	`path:"procid" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Messages_State_Message implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Messages_State_Message) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_State_Message) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Messages_State_Message"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Messages_State_Message) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Messages_State_Message) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Messages_State_Message.
func (*OpenconfigSystem_System_Messages_State_Message) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_MountPoints represents the /openconfig-system/system/mount-points YANG schema element.
type OpenconfigSystem_System_MountPoints struct {
	MountPoint	map[string]*OpenconfigSystem_System_MountPoints_MountPoint	`path:"mount-point" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_MountPoints implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_MountPoints) IsYANGGoStruct() {}

// NewMountPoint creates a new entry in the MountPoint list of the
// OpenconfigSystem_System_MountPoints struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_MountPoints) NewMountPoint(Name string) (*OpenconfigSystem_System_MountPoints_MountPoint, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.MountPoint == nil {
		t.MountPoint = make(map[string]*OpenconfigSystem_System_MountPoints_MountPoint)
	}

	key := Name

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.MountPoint[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list MountPoint", key)
	}

	t.MountPoint[key] = &OpenconfigSystem_System_MountPoints_MountPoint{
		Name: &Name,
	}

	return t.MountPoint[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_MountPoints"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_MountPoints) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_MountPoints.
func (*OpenconfigSystem_System_MountPoints) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_MountPoints_MountPoint represents the /openconfig-system/system/mount-points/mount-point YANG schema element.
type OpenconfigSystem_System_MountPoints_MountPoint struct {
	Name	*string	`path:"name" module:"openconfig-system"`
	State	*OpenconfigSystem_System_MountPoints_MountPoint_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_MountPoints_MountPoint implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_MountPoints_MountPoint) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_MountPoints_MountPoint struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_MountPoints_MountPoint) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Name == nil {
		return nil, fmt.Errorf("nil value for key Name")
	}

	return map[string]interface{}{
		"name": *t.Name,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints_MountPoint) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_MountPoints_MountPoint"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints_MountPoint) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_MountPoints_MountPoint) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_MountPoints_MountPoint.
func (*OpenconfigSystem_System_MountPoints_MountPoint) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_MountPoints_MountPoint_State represents the /openconfig-system/system/mount-points/mount-point/state YANG schema element.
type OpenconfigSystem_System_MountPoints_MountPoint_State struct {
	Available	*uint64	`path:"available" module:"openconfig-system"`
	Name	*string	`path:"name" module:"openconfig-system"`
	Size	*uint64	`path:"size" module:"openconfig-system"`
	StorageComponent	*string	`path:"storage-component" module:"openconfig-system"`
	Utilized	*uint64	`path:"utilized" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_MountPoints_MountPoint_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_MountPoints_MountPoint_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints_MountPoint_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_MountPoints_MountPoint_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_MountPoints_MountPoint_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_MountPoints_MountPoint_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_MountPoints_MountPoint_State.
func (*OpenconfigSystem_System_MountPoints_MountPoint_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp represents the /openconfig-system/system/ntp YANG schema element.
type OpenconfigSystem_System_Ntp struct {
	Config	*OpenconfigSystem_System_Ntp_Config	`path:"config" module:"openconfig-system"`
	NtpKeys	*OpenconfigSystem_System_Ntp_NtpKeys	`path:"ntp-keys" module:"openconfig-system"`
	Servers	*OpenconfigSystem_System_Ntp_Servers	`path:"servers" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Ntp_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp.
func (*OpenconfigSystem_System_Ntp) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_Config represents the /openconfig-system/system/ntp/config YANG schema element.
type OpenconfigSystem_System_Ntp_Config struct {
	EnableNtpAuth	*bool	`path:"enable-ntp-auth" module:"openconfig-system"`
	Enabled	*bool	`path:"enabled" module:"openconfig-system"`
	NtpSourceAddress	*string	`path:"ntp-source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_Config.
func (*OpenconfigSystem_System_Ntp_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_NtpKeys represents the /openconfig-system/system/ntp/ntp-keys YANG schema element.
type OpenconfigSystem_System_Ntp_NtpKeys struct {
	NtpKey	map[uint16]*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey	`path:"ntp-key" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_NtpKeys implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_NtpKeys) IsYANGGoStruct() {}

// NewNtpKey creates a new entry in the NtpKey list of the
// OpenconfigSystem_System_Ntp_NtpKeys struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Ntp_NtpKeys) NewNtpKey(KeyId uint16) (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.NtpKey == nil {
		t.NtpKey = make(map[uint16]*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey)
	}

	key := KeyId

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.NtpKey[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list NtpKey", key)
	}

	t.NtpKey[key] = &OpenconfigSystem_System_Ntp_NtpKeys_NtpKey{
		KeyId: &KeyId,
	}

	return t.NtpKey[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_NtpKeys"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_NtpKeys) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_NtpKeys.
func (*OpenconfigSystem_System_Ntp_NtpKeys) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_NtpKeys_NtpKey represents the /openconfig-system/system/ntp/ntp-keys/ntp-key YANG schema element.
type OpenconfigSystem_System_Ntp_NtpKeys_NtpKey struct {
	Config	*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config	`path:"config" module:"openconfig-system"`
	KeyId	*uint16	`path:"key-id" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_NtpKeys_NtpKey implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Ntp_NtpKeys_NtpKey struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) ΛListKeyMap() (map[string]interface{}, error) {
	if t.KeyId == nil {
		return nil, fmt.Errorf("nil value for key KeyId")
	}

	return map[string]interface{}{
		"key-id": *t.KeyId,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_NtpKeys_NtpKey"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_NtpKeys_NtpKey.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config represents the /openconfig-system/system/ntp/ntp-keys/ntp-key/config YANG schema element.
type OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config struct {
	KeyId	*uint16	`path:"key-id" module:"openconfig-system"`
	KeyType	E_OpenconfigSystem_NTP_AUTH_TYPE	`path:"key-type" module:"openconfig-system"`
	KeyValue	*string	`path:"key-value" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State represents the /openconfig-system/system/ntp/ntp-keys/ntp-key/state YANG schema element.
type OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State struct {
	KeyId	*uint16	`path:"key-id" module:"openconfig-system"`
	KeyType	E_OpenconfigSystem_NTP_AUTH_TYPE	`path:"key-type" module:"openconfig-system"`
	KeyValue	*string	`path:"key-value" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State.
func (*OpenconfigSystem_System_Ntp_NtpKeys_NtpKey_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_Servers represents the /openconfig-system/system/ntp/servers YANG schema element.
type OpenconfigSystem_System_Ntp_Servers struct {
	Server	map[string]*OpenconfigSystem_System_Ntp_Servers_Server	`path:"server" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_Servers implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_Servers) IsYANGGoStruct() {}

// NewServer creates a new entry in the Server list of the
// OpenconfigSystem_System_Ntp_Servers struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Ntp_Servers) NewServer(Address string) (*OpenconfigSystem_System_Ntp_Servers_Server, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Server == nil {
		t.Server = make(map[string]*OpenconfigSystem_System_Ntp_Servers_Server)
	}

	key := Address

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Server[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Server", key)
	}

	t.Server[key] = &OpenconfigSystem_System_Ntp_Servers_Server{
		Address: &Address,
	}

	return t.Server[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_Servers"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_Servers) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_Servers.
func (*OpenconfigSystem_System_Ntp_Servers) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_Servers_Server represents the /openconfig-system/system/ntp/servers/server YANG schema element.
type OpenconfigSystem_System_Ntp_Servers_Server struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	Config	*OpenconfigSystem_System_Ntp_Servers_Server_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Ntp_Servers_Server_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_Servers_Server implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_Servers_Server) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Ntp_Servers_Server struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Ntp_Servers_Server) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Address == nil {
		return nil, fmt.Errorf("nil value for key Address")
	}

	return map[string]interface{}{
		"address": *t.Address,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_Servers_Server"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_Servers_Server) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_Servers_Server.
func (*OpenconfigSystem_System_Ntp_Servers_Server) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_Servers_Server_Config represents the /openconfig-system/system/ntp/servers/server/config YANG schema element.
type OpenconfigSystem_System_Ntp_Servers_Server_Config struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	AssociationType	E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType	`path:"association-type" module:"openconfig-system"`
	Iburst	*bool	`path:"iburst" module:"openconfig-system"`
	Port	*uint16	`path:"port" module:"openconfig-system"`
	Prefer	*bool	`path:"prefer" module:"openconfig-system"`
	Version	*uint8	`path:"version" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_Servers_Server_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_Servers_Server_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_Servers_Server_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_Servers_Server_Config.
func (*OpenconfigSystem_System_Ntp_Servers_Server_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_Servers_Server_State represents the /openconfig-system/system/ntp/servers/server/state YANG schema element.
type OpenconfigSystem_System_Ntp_Servers_Server_State struct {
	Address	*string	`path:"address" module:"openconfig-system"`
	AssociationType	E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType	`path:"association-type" module:"openconfig-system"`
	Iburst	*bool	`path:"iburst" module:"openconfig-system"`
	Offset	*uint64	`path:"offset" module:"openconfig-system"`
	PollInterval	*uint32	`path:"poll-interval" module:"openconfig-system"`
	Port	*uint16	`path:"port" module:"openconfig-system"`
	Prefer	*bool	`path:"prefer" module:"openconfig-system"`
	RootDelay	*uint32	`path:"root-delay" module:"openconfig-system"`
	RootDispersion	*uint64	`path:"root-dispersion" module:"openconfig-system"`
	Stratum	*uint8	`path:"stratum" module:"openconfig-system"`
	Version	*uint8	`path:"version" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_Servers_Server_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_Servers_Server_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_Servers_Server_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_Servers_Server_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_Servers_Server_State.
func (*OpenconfigSystem_System_Ntp_Servers_Server_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Ntp_State represents the /openconfig-system/system/ntp/state YANG schema element.
type OpenconfigSystem_System_Ntp_State struct {
	AuthMismatch	*uint64	`path:"auth-mismatch" module:"openconfig-system"`
	EnableNtpAuth	*bool	`path:"enable-ntp-auth" module:"openconfig-system"`
	Enabled	*bool	`path:"enabled" module:"openconfig-system"`
	NtpSourceAddress	*string	`path:"ntp-source-address" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Ntp_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Ntp_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Ntp_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Ntp_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Ntp_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Ntp_State.
func (*OpenconfigSystem_System_Ntp_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Processes represents the /openconfig-system/system/processes YANG schema element.
type OpenconfigSystem_System_Processes struct {
	Process	map[uint64]*OpenconfigSystem_System_Processes_Process	`path:"process" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Processes implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Processes) IsYANGGoStruct() {}

// NewProcess creates a new entry in the Process list of the
// OpenconfigSystem_System_Processes struct. The keys of the list are populated from the input
// arguments.
func (t *OpenconfigSystem_System_Processes) NewProcess(Pid uint64) (*OpenconfigSystem_System_Processes_Process, error){

	// Initialise the list within the receiver struct if it has not already been
	// created.
	if t.Process == nil {
		t.Process = make(map[uint64]*OpenconfigSystem_System_Processes_Process)
	}

	key := Pid

	// Ensure that this key has not already been used in the
	// list. Keyed YANG lists do not allow duplicate keys to
	// be created.
	if _, ok := t.Process[key]; ok {
		return nil, fmt.Errorf("duplicate key %v for list Process", key)
	}

	t.Process[key] = &OpenconfigSystem_System_Processes_Process{
		Pid: &Pid,
	}

	return t.Process[key], nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Processes"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Processes) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Processes.
func (*OpenconfigSystem_System_Processes) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Processes_Process represents the /openconfig-system/system/processes/process YANG schema element.
type OpenconfigSystem_System_Processes_Process struct {
	Pid	*uint64	`path:"pid" module:"openconfig-system"`
	State	*OpenconfigSystem_System_Processes_Process_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Processes_Process implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Processes_Process) IsYANGGoStruct() {}

// ΛListKeyMap returns the keys of the OpenconfigSystem_System_Processes_Process struct, which is a YANG list entry.
func (t *OpenconfigSystem_System_Processes_Process) ΛListKeyMap() (map[string]interface{}, error) {
	if t.Pid == nil {
		return nil, fmt.Errorf("nil value for key Pid")
	}

	return map[string]interface{}{
		"pid": *t.Pid,
	}, nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes_Process) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Processes_Process"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes_Process) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Processes_Process) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Processes_Process.
func (*OpenconfigSystem_System_Processes_Process) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_Processes_Process_State represents the /openconfig-system/system/processes/process/state YANG schema element.
type OpenconfigSystem_System_Processes_Process_State struct {
	Args	[]string	`path:"args" module:"openconfig-system"`
	CpuUsageSystem	*uint64	`path:"cpu-usage-system" module:"openconfig-system"`
	CpuUsageUser	*uint64	`path:"cpu-usage-user" module:"openconfig-system"`
	CpuUtilization	*uint8	`path:"cpu-utilization" module:"openconfig-system"`
	MemoryUsage	*uint64	`path:"memory-usage" module:"openconfig-system"`
	MemoryUtilization	*uint8	`path:"memory-utilization" module:"openconfig-system"`
	Name	*string	`path:"name" module:"openconfig-system"`
	Pid	*uint64	`path:"pid" module:"openconfig-system"`
	StartTime	*uint64	`path:"start-time" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_Processes_Process_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_Processes_Process_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes_Process_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_Processes_Process_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_Processes_Process_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_Processes_Process_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_Processes_Process_State.
func (*OpenconfigSystem_System_Processes_Process_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_SshServer represents the /openconfig-system/system/ssh-server YANG schema element.
type OpenconfigSystem_System_SshServer struct {
	Config	*OpenconfigSystem_System_SshServer_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_SshServer_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_SshServer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_SshServer) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_SshServer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_SshServer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_SshServer.
func (*OpenconfigSystem_System_SshServer) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_SshServer_Config represents the /openconfig-system/system/ssh-server/config YANG schema element.
type OpenconfigSystem_System_SshServer_Config struct {
	Enable	*bool	`path:"enable" module:"openconfig-system"`
	ProtocolVersion	E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion	`path:"protocol-version" module:"openconfig-system"`
	RateLimit	*uint16	`path:"rate-limit" module:"openconfig-system"`
	SessionLimit	*uint16	`path:"session-limit" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_SshServer_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_SshServer_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_SshServer_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_SshServer_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_SshServer_Config.
func (*OpenconfigSystem_System_SshServer_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_SshServer_State represents the /openconfig-system/system/ssh-server/state YANG schema element.
type OpenconfigSystem_System_SshServer_State struct {
	Enable	*bool	`path:"enable" module:"openconfig-system"`
	ProtocolVersion	E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion	`path:"protocol-version" module:"openconfig-system"`
	RateLimit	*uint16	`path:"rate-limit" module:"openconfig-system"`
	SessionLimit	*uint16	`path:"session-limit" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_SshServer_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_SshServer_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_SshServer_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_SshServer_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_SshServer_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_SshServer_State.
func (*OpenconfigSystem_System_SshServer_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_State represents the /openconfig-system/system/state YANG schema element.
type OpenconfigSystem_System_State struct {
	BootTime	*uint64	`path:"boot-time" module:"openconfig-system"`
	CurrentDatetime	*string	`path:"current-datetime" module:"openconfig-system"`
	DomainName	*string	`path:"domain-name" module:"openconfig-system"`
	Hostname	*string	`path:"hostname" module:"openconfig-system"`
	LoginBanner	*string	`path:"login-banner" module:"openconfig-system"`
	MotdBanner	*string	`path:"motd-banner" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_State.
func (*OpenconfigSystem_System_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_TelnetServer represents the /openconfig-system/system/telnet-server YANG schema element.
type OpenconfigSystem_System_TelnetServer struct {
	Config	*OpenconfigSystem_System_TelnetServer_Config	`path:"config" module:"openconfig-system"`
	State	*OpenconfigSystem_System_TelnetServer_State	`path:"state" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_TelnetServer implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_TelnetServer) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_TelnetServer"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_TelnetServer) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_TelnetServer.
func (*OpenconfigSystem_System_TelnetServer) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_TelnetServer_Config represents the /openconfig-system/system/telnet-server/config YANG schema element.
type OpenconfigSystem_System_TelnetServer_Config struct {
	Enable	*bool	`path:"enable" module:"openconfig-system"`
	RateLimit	*uint16	`path:"rate-limit" module:"openconfig-system"`
	SessionLimit	*uint16	`path:"session-limit" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_TelnetServer_Config implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_TelnetServer_Config) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer_Config) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_TelnetServer_Config"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer_Config) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_TelnetServer_Config) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_TelnetServer_Config.
func (*OpenconfigSystem_System_TelnetServer_Config) ΛBelongingModule() string {
	return "openconfig-system"
}


// OpenconfigSystem_System_TelnetServer_State represents the /openconfig-system/system/telnet-server/state YANG schema element.
type OpenconfigSystem_System_TelnetServer_State struct {
	Enable	*bool	`path:"enable" module:"openconfig-system"`
	RateLimit	*uint16	`path:"rate-limit" module:"openconfig-system"`
	SessionLimit	*uint16	`path:"session-limit" module:"openconfig-system"`
	Timeout	*uint16	`path:"timeout" module:"openconfig-system"`
}

// IsYANGGoStruct ensures that OpenconfigSystem_System_TelnetServer_State implements the yang.GoStruct
// interface. This allows functions that need to handle this struct to
// identify it as being generated by ygen.
func (*OpenconfigSystem_System_TelnetServer_State) IsYANGGoStruct() {}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer_State) ΛValidate(opts ...ygot.ValidationOption) error {
	if err := ytypes.Validate(SchemaTree["OpenconfigSystem_System_TelnetServer_State"], t, opts...); err != nil {
		return err
	}
	return nil
}

// Validate validates s against the YANG schema corresponding to its type.
func (t *OpenconfigSystem_System_TelnetServer_State) Validate(opts ...ygot.ValidationOption) error {
	return t.ΛValidate(opts...)
}

// ΛEnumTypeMap returns a map, keyed by YANG schema path, of the enumerated types
// that are included in the generated code.
func (t *OpenconfigSystem_System_TelnetServer_State) ΛEnumTypeMap() map[string][]reflect.Type { return ΛEnumTypes }

// ΛBelongingModule returns the name of the module that defines the namespace
// of OpenconfigSystem_System_TelnetServer_State.
func (*OpenconfigSystem_System_TelnetServer_State) ΛBelongingModule() string {
	return "openconfig-system"
}


// E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE. An additional value named
// OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE int64

// IsYANGGoEnum ensures that OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE.
func (E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE.
func (e E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE")
}

const (
	// OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_UNSET corresponds to the value UNSET of OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE
	OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_UNSET E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE = 0
	// OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_AAA_ACCOUNTING_EVENT_COMMAND corresponds to the value AAA_ACCOUNTING_EVENT_COMMAND of OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE
	OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_AAA_ACCOUNTING_EVENT_COMMAND E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE = 1
	// OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_AAA_ACCOUNTING_EVENT_LOGIN corresponds to the value AAA_ACCOUNTING_EVENT_LOGIN of OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE
	OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE_AAA_ACCOUNTING_EVENT_LOGIN E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE = 2
)


// E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE. An additional value named
// OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE int64

// IsYANGGoEnum ensures that OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE.
func (E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE.
func (e E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE")
}

const (
	// OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_UNSET corresponds to the value UNSET of OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE
	OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_UNSET E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE = 0
	// OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_AAA_AUTHORIZATION_EVENT_COMMAND corresponds to the value AAA_AUTHORIZATION_EVENT_COMMAND of OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE
	OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_AAA_AUTHORIZATION_EVENT_COMMAND E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE = 1
	// OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_AAA_AUTHORIZATION_EVENT_CONFIG corresponds to the value AAA_AUTHORIZATION_EVENT_CONFIG of OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE
	OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE_AAA_AUTHORIZATION_EVENT_CONFIG E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE = 2
)


// E_OpenconfigAaaTypes_AAA_METHOD_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigAaaTypes_AAA_METHOD_TYPE. An additional value named
// OpenconfigAaaTypes_AAA_METHOD_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAaaTypes_AAA_METHOD_TYPE int64

// IsYANGGoEnum ensures that OpenconfigAaaTypes_AAA_METHOD_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigAaaTypes_AAA_METHOD_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAaaTypes_AAA_METHOD_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAaaTypes_AAA_METHOD_TYPE.
func (E_OpenconfigAaaTypes_AAA_METHOD_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAaaTypes_AAA_METHOD_TYPE.
func (e E_OpenconfigAaaTypes_AAA_METHOD_TYPE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAaaTypes_AAA_METHOD_TYPE")
}

const (
	// OpenconfigAaaTypes_AAA_METHOD_TYPE_UNSET corresponds to the value UNSET of OpenconfigAaaTypes_AAA_METHOD_TYPE
	OpenconfigAaaTypes_AAA_METHOD_TYPE_UNSET E_OpenconfigAaaTypes_AAA_METHOD_TYPE = 0
	// OpenconfigAaaTypes_AAA_METHOD_TYPE_LOCAL corresponds to the value LOCAL of OpenconfigAaaTypes_AAA_METHOD_TYPE
	OpenconfigAaaTypes_AAA_METHOD_TYPE_LOCAL E_OpenconfigAaaTypes_AAA_METHOD_TYPE = 1
	// OpenconfigAaaTypes_AAA_METHOD_TYPE_RADIUS_ALL corresponds to the value RADIUS_ALL of OpenconfigAaaTypes_AAA_METHOD_TYPE
	OpenconfigAaaTypes_AAA_METHOD_TYPE_RADIUS_ALL E_OpenconfigAaaTypes_AAA_METHOD_TYPE = 2
	// OpenconfigAaaTypes_AAA_METHOD_TYPE_TACACS_ALL corresponds to the value TACACS_ALL of OpenconfigAaaTypes_AAA_METHOD_TYPE
	OpenconfigAaaTypes_AAA_METHOD_TYPE_TACACS_ALL E_OpenconfigAaaTypes_AAA_METHOD_TYPE = 3
)


// E_OpenconfigAaaTypes_AAA_SERVER_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigAaaTypes_AAA_SERVER_TYPE. An additional value named
// OpenconfigAaaTypes_AAA_SERVER_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAaaTypes_AAA_SERVER_TYPE int64

// IsYANGGoEnum ensures that OpenconfigAaaTypes_AAA_SERVER_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigAaaTypes_AAA_SERVER_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAaaTypes_AAA_SERVER_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAaaTypes_AAA_SERVER_TYPE.
func (E_OpenconfigAaaTypes_AAA_SERVER_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAaaTypes_AAA_SERVER_TYPE.
func (e E_OpenconfigAaaTypes_AAA_SERVER_TYPE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAaaTypes_AAA_SERVER_TYPE")
}

const (
	// OpenconfigAaaTypes_AAA_SERVER_TYPE_UNSET corresponds to the value UNSET of OpenconfigAaaTypes_AAA_SERVER_TYPE
	OpenconfigAaaTypes_AAA_SERVER_TYPE_UNSET E_OpenconfigAaaTypes_AAA_SERVER_TYPE = 0
	// OpenconfigAaaTypes_AAA_SERVER_TYPE_RADIUS corresponds to the value RADIUS of OpenconfigAaaTypes_AAA_SERVER_TYPE
	OpenconfigAaaTypes_AAA_SERVER_TYPE_RADIUS E_OpenconfigAaaTypes_AAA_SERVER_TYPE = 1
	// OpenconfigAaaTypes_AAA_SERVER_TYPE_TACACS corresponds to the value TACACS of OpenconfigAaaTypes_AAA_SERVER_TYPE
	OpenconfigAaaTypes_AAA_SERVER_TYPE_TACACS E_OpenconfigAaaTypes_AAA_SERVER_TYPE = 2
)


// E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES is a derived int64 type which is used to represent
// the enumerated node OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES. An additional value named
// OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES int64

// IsYANGGoEnum ensures that OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES implements the yang.GoEnum
// interface. This ensures that OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES.
func (E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES.
func (e E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES")
}

const (
	// OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES_UNSET corresponds to the value UNSET of OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
	OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES_UNSET E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES = 0
	// OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES_SYSTEM_ROLE_ADMIN corresponds to the value SYSTEM_ROLE_ADMIN of OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES
	OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES_SYSTEM_ROLE_ADMIN E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES = 1
)


// E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY is a derived int64 type which is used to represent
// the enumerated node OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY. An additional value named
// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY int64

// IsYANGGoEnum ensures that OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY implements the yang.GoEnum
// interface. This ensures that OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY.
func (E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY.
func (e E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY")
}

const (
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNSET corresponds to the value UNSET of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNSET E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 0
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_CRITICAL corresponds to the value CRITICAL of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_CRITICAL E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 1
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MAJOR corresponds to the value MAJOR of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MAJOR E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 2
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MINOR corresponds to the value MINOR of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_MINOR E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 3
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNKNOWN corresponds to the value UNKNOWN of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_UNKNOWN E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 4
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_WARNING corresponds to the value WARNING of OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY_WARNING E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY = 5
)


// E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID is a derived int64 type which is used to represent
// the enumerated node OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID. An additional value named
// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID int64

// IsYANGGoEnum ensures that OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID implements the yang.GoEnum
// interface. This ensures that OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID.
func (E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID.
func (e E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID")
}

const (
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_UNSET corresponds to the value UNSET of OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_UNSET E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID = 0
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_AIS corresponds to the value AIS of OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_AIS E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID = 1
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_EQPT corresponds to the value EQPT of OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_EQPT E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID = 2
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_LOS corresponds to the value LOS of OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_LOS E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID = 3
	// OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_OTS corresponds to the value OTS of OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID
	OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID_OTS E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID = 4
)


// E_OpenconfigMessages_DEBUG_SERVICE is a derived int64 type which is used to represent
// the enumerated node OpenconfigMessages_DEBUG_SERVICE. An additional value named
// OpenconfigMessages_DEBUG_SERVICE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigMessages_DEBUG_SERVICE int64

// IsYANGGoEnum ensures that OpenconfigMessages_DEBUG_SERVICE implements the yang.GoEnum
// interface. This ensures that OpenconfigMessages_DEBUG_SERVICE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigMessages_DEBUG_SERVICE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigMessages_DEBUG_SERVICE.
func (E_OpenconfigMessages_DEBUG_SERVICE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigMessages_DEBUG_SERVICE.
func (e E_OpenconfigMessages_DEBUG_SERVICE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigMessages_DEBUG_SERVICE")
}

const (
	// OpenconfigMessages_DEBUG_SERVICE_UNSET corresponds to the value UNSET of OpenconfigMessages_DEBUG_SERVICE
	OpenconfigMessages_DEBUG_SERVICE_UNSET E_OpenconfigMessages_DEBUG_SERVICE = 0
)


// E_OpenconfigMessages_SyslogSeverity is a derived int64 type which is used to represent
// the enumerated node OpenconfigMessages_SyslogSeverity. An additional value named
// OpenconfigMessages_SyslogSeverity_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigMessages_SyslogSeverity int64

// IsYANGGoEnum ensures that OpenconfigMessages_SyslogSeverity implements the yang.GoEnum
// interface. This ensures that OpenconfigMessages_SyslogSeverity can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigMessages_SyslogSeverity) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigMessages_SyslogSeverity.
func (E_OpenconfigMessages_SyslogSeverity) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigMessages_SyslogSeverity.
func (e E_OpenconfigMessages_SyslogSeverity) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigMessages_SyslogSeverity")
}

const (
	// OpenconfigMessages_SyslogSeverity_UNSET corresponds to the value UNSET of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_UNSET E_OpenconfigMessages_SyslogSeverity = 0
	// OpenconfigMessages_SyslogSeverity_EMERGENCY corresponds to the value EMERGENCY of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_EMERGENCY E_OpenconfigMessages_SyslogSeverity = 1
	// OpenconfigMessages_SyslogSeverity_ALERT corresponds to the value ALERT of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_ALERT E_OpenconfigMessages_SyslogSeverity = 2
	// OpenconfigMessages_SyslogSeverity_CRITICAL corresponds to the value CRITICAL of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_CRITICAL E_OpenconfigMessages_SyslogSeverity = 3
	// OpenconfigMessages_SyslogSeverity_ERROR corresponds to the value ERROR of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_ERROR E_OpenconfigMessages_SyslogSeverity = 4
	// OpenconfigMessages_SyslogSeverity_WARNING corresponds to the value WARNING of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_WARNING E_OpenconfigMessages_SyslogSeverity = 5
	// OpenconfigMessages_SyslogSeverity_NOTICE corresponds to the value NOTICE of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_NOTICE E_OpenconfigMessages_SyslogSeverity = 6
	// OpenconfigMessages_SyslogSeverity_INFORMATIONAL corresponds to the value INFORMATIONAL of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_INFORMATIONAL E_OpenconfigMessages_SyslogSeverity = 7
	// OpenconfigMessages_SyslogSeverity_DEBUG corresponds to the value DEBUG of OpenconfigMessages_SyslogSeverity
	OpenconfigMessages_SyslogSeverity_DEBUG E_OpenconfigMessages_SyslogSeverity = 8
)


// E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_COMPONENT_OPER_STATUS. An additional value named
// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_COMPONENT_OPER_STATUS implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_COMPONENT_OPER_STATUS can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_COMPONENT_OPER_STATUS.
func (E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS.
func (e E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS")
}

const (
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_UNSET E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 0
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_ACTIVE corresponds to the value ACTIVE of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_ACTIVE E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 1
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_DISABLED corresponds to the value DISABLED of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_DISABLED E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 2
	// OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_INACTIVE corresponds to the value INACTIVE of OpenconfigPlatformTypes_COMPONENT_OPER_STATUS
	OpenconfigPlatformTypes_COMPONENT_OPER_STATUS_INACTIVE E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS = 3
)


// E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON. An additional value named
// OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON.
func (E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON.
func (e E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON")
}

const (
	// OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON
	OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_UNSET E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON = 0
	// OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_CRITICAL_ERROR corresponds to the value REBOOT_CRITICAL_ERROR of OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON
	OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_CRITICAL_ERROR E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON = 1
	// OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_POWER_FAILURE corresponds to the value REBOOT_POWER_FAILURE of OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON
	OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_POWER_FAILURE E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON = 2
	// OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_USER_INITIATED corresponds to the value REBOOT_USER_INITIATED of OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON
	OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON_REBOOT_USER_INITIATED E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON = 3
)


// E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger. An additional value named
// OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger.
func (E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger.
func (e E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger")
}

const (
	// OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger
	OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_UNSET E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger = 0
	// OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_USER_INITIATED corresponds to the value USER_INITIATED of OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger
	OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_USER_INITIATED E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger = 1
	// OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_SYSTEM_INITIATED corresponds to the value SYSTEM_INITIATED of OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger
	OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger_SYSTEM_INITIATED E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger = 2
)


// E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT. An additional value named
// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT.
func (E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT.
func (e E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT")
}

const (
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_UNSET E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 0
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_BACKPLANE corresponds to the value BACKPLANE of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_BACKPLANE E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 1
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CHASSIS corresponds to the value CHASSIS of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CHASSIS E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 2
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CONTROLLER_CARD corresponds to the value CONTROLLER_CARD of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CONTROLLER_CARD E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 3
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CPU corresponds to the value CPU of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_CPU E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 4
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FABRIC corresponds to the value FABRIC of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FABRIC E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 5
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FAN corresponds to the value FAN of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FAN E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 6
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FRU corresponds to the value FRU of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_FRU E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 7
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_INTEGRATED_CIRCUIT corresponds to the value INTEGRATED_CIRCUIT of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_INTEGRATED_CIRCUIT E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 8
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_LINECARD corresponds to the value LINECARD of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_LINECARD E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 9
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_PORT corresponds to the value PORT of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_PORT E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 10
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_POWER_SUPPLY corresponds to the value POWER_SUPPLY of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_POWER_SUPPLY E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 11
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_SENSOR corresponds to the value SENSOR of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_SENSOR E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 12
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_STORAGE corresponds to the value STORAGE of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_STORAGE E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 13
	// OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_TRANSCEIVER corresponds to the value TRANSCEIVER of OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT_TRANSCEIVER E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT = 14
)


// E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT. An additional value named
// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT int64

// IsYANGGoEnum ensures that OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT.
func (E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT.
func (e E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT")
}

const (
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_UNSET corresponds to the value UNSET of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_UNSET E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 0
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_BIOS corresponds to the value BIOS of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_BIOS E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 1
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_BOOT_LOADER corresponds to the value BOOT_LOADER of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_BOOT_LOADER E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 2
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM corresponds to the value OPERATING_SYSTEM of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 3
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM_UPDATE corresponds to the value OPERATING_SYSTEM_UPDATE of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_OPERATING_SYSTEM_UPDATE E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 4
	// OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_SOFTWARE_MODULE corresponds to the value SOFTWARE_MODULE of OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT
	OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT_SOFTWARE_MODULE E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT = 5
)


// E_OpenconfigPlatform_ComponentRedundantRole is a derived int64 type which is used to represent
// the enumerated node OpenconfigPlatform_ComponentRedundantRole. An additional value named
// OpenconfigPlatform_ComponentRedundantRole_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigPlatform_ComponentRedundantRole int64

// IsYANGGoEnum ensures that OpenconfigPlatform_ComponentRedundantRole implements the yang.GoEnum
// interface. This ensures that OpenconfigPlatform_ComponentRedundantRole can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigPlatform_ComponentRedundantRole) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigPlatform_ComponentRedundantRole.
func (E_OpenconfigPlatform_ComponentRedundantRole) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigPlatform_ComponentRedundantRole.
func (e E_OpenconfigPlatform_ComponentRedundantRole) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigPlatform_ComponentRedundantRole")
}

const (
	// OpenconfigPlatform_ComponentRedundantRole_UNSET corresponds to the value UNSET of OpenconfigPlatform_ComponentRedundantRole
	OpenconfigPlatform_ComponentRedundantRole_UNSET E_OpenconfigPlatform_ComponentRedundantRole = 0
	// OpenconfigPlatform_ComponentRedundantRole_PRIMARY corresponds to the value PRIMARY of OpenconfigPlatform_ComponentRedundantRole
	OpenconfigPlatform_ComponentRedundantRole_PRIMARY E_OpenconfigPlatform_ComponentRedundantRole = 1
	// OpenconfigPlatform_ComponentRedundantRole_SECONDARY corresponds to the value SECONDARY of OpenconfigPlatform_ComponentRedundantRole
	OpenconfigPlatform_ComponentRedundantRole_SECONDARY E_OpenconfigPlatform_ComponentRedundantRole = 2
)


// E_OpenconfigSystemLogging_SYSLOG_FACILITY is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystemLogging_SYSLOG_FACILITY. An additional value named
// OpenconfigSystemLogging_SYSLOG_FACILITY_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystemLogging_SYSLOG_FACILITY int64

// IsYANGGoEnum ensures that OpenconfigSystemLogging_SYSLOG_FACILITY implements the yang.GoEnum
// interface. This ensures that OpenconfigSystemLogging_SYSLOG_FACILITY can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystemLogging_SYSLOG_FACILITY) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystemLogging_SYSLOG_FACILITY.
func (E_OpenconfigSystemLogging_SYSLOG_FACILITY) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystemLogging_SYSLOG_FACILITY.
func (e E_OpenconfigSystemLogging_SYSLOG_FACILITY) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystemLogging_SYSLOG_FACILITY")
}

const (
	// OpenconfigSystemLogging_SYSLOG_FACILITY_UNSET corresponds to the value UNSET of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_UNSET E_OpenconfigSystemLogging_SYSLOG_FACILITY = 0
	// OpenconfigSystemLogging_SYSLOG_FACILITY_ALL corresponds to the value ALL of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_ALL E_OpenconfigSystemLogging_SYSLOG_FACILITY = 1
	// OpenconfigSystemLogging_SYSLOG_FACILITY_AUDIT corresponds to the value AUDIT of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_AUDIT E_OpenconfigSystemLogging_SYSLOG_FACILITY = 2
	// OpenconfigSystemLogging_SYSLOG_FACILITY_AUTH corresponds to the value AUTH of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_AUTH E_OpenconfigSystemLogging_SYSLOG_FACILITY = 3
	// OpenconfigSystemLogging_SYSLOG_FACILITY_AUTHPRIV corresponds to the value AUTHPRIV of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_AUTHPRIV E_OpenconfigSystemLogging_SYSLOG_FACILITY = 4
	// OpenconfigSystemLogging_SYSLOG_FACILITY_CONSOLE corresponds to the value CONSOLE of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_CONSOLE E_OpenconfigSystemLogging_SYSLOG_FACILITY = 5
	// OpenconfigSystemLogging_SYSLOG_FACILITY_KERNEL corresponds to the value KERNEL of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_KERNEL E_OpenconfigSystemLogging_SYSLOG_FACILITY = 6
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL0 corresponds to the value LOCAL0 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL0 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 7
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL1 corresponds to the value LOCAL1 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL1 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 8
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL2 corresponds to the value LOCAL2 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL2 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 9
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL3 corresponds to the value LOCAL3 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL3 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 10
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL4 corresponds to the value LOCAL4 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL4 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 11
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL5 corresponds to the value LOCAL5 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL5 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 12
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL6 corresponds to the value LOCAL6 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL6 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 13
	// OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL7 corresponds to the value LOCAL7 of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_LOCAL7 E_OpenconfigSystemLogging_SYSLOG_FACILITY = 14
	// OpenconfigSystemLogging_SYSLOG_FACILITY_MAIL corresponds to the value MAIL of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_MAIL E_OpenconfigSystemLogging_SYSLOG_FACILITY = 15
	// OpenconfigSystemLogging_SYSLOG_FACILITY_NTP corresponds to the value NTP of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_NTP E_OpenconfigSystemLogging_SYSLOG_FACILITY = 16
	// OpenconfigSystemLogging_SYSLOG_FACILITY_SYSLOG corresponds to the value SYSLOG of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_SYSLOG E_OpenconfigSystemLogging_SYSLOG_FACILITY = 17
	// OpenconfigSystemLogging_SYSLOG_FACILITY_SYSTEM_DAEMON corresponds to the value SYSTEM_DAEMON of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_SYSTEM_DAEMON E_OpenconfigSystemLogging_SYSLOG_FACILITY = 18
	// OpenconfigSystemLogging_SYSLOG_FACILITY_USER corresponds to the value USER of OpenconfigSystemLogging_SYSLOG_FACILITY
	OpenconfigSystemLogging_SYSLOG_FACILITY_USER E_OpenconfigSystemLogging_SYSLOG_FACILITY = 19
)


// E_OpenconfigSystemLogging_SyslogSeverity is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystemLogging_SyslogSeverity. An additional value named
// OpenconfigSystemLogging_SyslogSeverity_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystemLogging_SyslogSeverity int64

// IsYANGGoEnum ensures that OpenconfigSystemLogging_SyslogSeverity implements the yang.GoEnum
// interface. This ensures that OpenconfigSystemLogging_SyslogSeverity can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystemLogging_SyslogSeverity) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystemLogging_SyslogSeverity.
func (E_OpenconfigSystemLogging_SyslogSeverity) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystemLogging_SyslogSeverity.
func (e E_OpenconfigSystemLogging_SyslogSeverity) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystemLogging_SyslogSeverity")
}

const (
	// OpenconfigSystemLogging_SyslogSeverity_UNSET corresponds to the value UNSET of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_UNSET E_OpenconfigSystemLogging_SyslogSeverity = 0
	// OpenconfigSystemLogging_SyslogSeverity_EMERGENCY corresponds to the value EMERGENCY of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_EMERGENCY E_OpenconfigSystemLogging_SyslogSeverity = 1
	// OpenconfigSystemLogging_SyslogSeverity_ALERT corresponds to the value ALERT of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_ALERT E_OpenconfigSystemLogging_SyslogSeverity = 2
	// OpenconfigSystemLogging_SyslogSeverity_CRITICAL corresponds to the value CRITICAL of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_CRITICAL E_OpenconfigSystemLogging_SyslogSeverity = 3
	// OpenconfigSystemLogging_SyslogSeverity_ERROR corresponds to the value ERROR of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_ERROR E_OpenconfigSystemLogging_SyslogSeverity = 4
	// OpenconfigSystemLogging_SyslogSeverity_WARNING corresponds to the value WARNING of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_WARNING E_OpenconfigSystemLogging_SyslogSeverity = 5
	// OpenconfigSystemLogging_SyslogSeverity_NOTICE corresponds to the value NOTICE of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_NOTICE E_OpenconfigSystemLogging_SyslogSeverity = 6
	// OpenconfigSystemLogging_SyslogSeverity_INFORMATIONAL corresponds to the value INFORMATIONAL of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_INFORMATIONAL E_OpenconfigSystemLogging_SyslogSeverity = 7
	// OpenconfigSystemLogging_SyslogSeverity_DEBUG corresponds to the value DEBUG of OpenconfigSystemLogging_SyslogSeverity
	OpenconfigSystemLogging_SyslogSeverity_DEBUG E_OpenconfigSystemLogging_SyslogSeverity = 8
)


// E_OpenconfigSystem_NTP_AUTH_TYPE is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystem_NTP_AUTH_TYPE. An additional value named
// OpenconfigSystem_NTP_AUTH_TYPE_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystem_NTP_AUTH_TYPE int64

// IsYANGGoEnum ensures that OpenconfigSystem_NTP_AUTH_TYPE implements the yang.GoEnum
// interface. This ensures that OpenconfigSystem_NTP_AUTH_TYPE can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystem_NTP_AUTH_TYPE) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystem_NTP_AUTH_TYPE.
func (E_OpenconfigSystem_NTP_AUTH_TYPE) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystem_NTP_AUTH_TYPE.
func (e E_OpenconfigSystem_NTP_AUTH_TYPE) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystem_NTP_AUTH_TYPE")
}

const (
	// OpenconfigSystem_NTP_AUTH_TYPE_UNSET corresponds to the value UNSET of OpenconfigSystem_NTP_AUTH_TYPE
	OpenconfigSystem_NTP_AUTH_TYPE_UNSET E_OpenconfigSystem_NTP_AUTH_TYPE = 0
	// OpenconfigSystem_NTP_AUTH_TYPE_NTP_AUTH_MD5 corresponds to the value NTP_AUTH_MD5 of OpenconfigSystem_NTP_AUTH_TYPE
	OpenconfigSystem_NTP_AUTH_TYPE_NTP_AUTH_MD5 E_OpenconfigSystem_NTP_AUTH_TYPE = 1
)


// E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record. An additional value named
// OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record int64

// IsYANGGoEnum ensures that OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record implements the yang.GoEnum
// interface. This ensures that OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record.
func (E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record.
func (e E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record")
}

const (
	// OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_UNSET corresponds to the value UNSET of OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record
	OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_UNSET E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record = 0
	// OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_START_STOP corresponds to the value START_STOP of OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record
	OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_START_STOP E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record = 1
	// OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_STOP corresponds to the value STOP of OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record
	OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record_STOP E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record = 2
)


// E_OpenconfigSystem_System_Cpus_Cpu_State_Index is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystem_System_Cpus_Cpu_State_Index. An additional value named
// OpenconfigSystem_System_Cpus_Cpu_State_Index_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystem_System_Cpus_Cpu_State_Index int64

// IsYANGGoEnum ensures that OpenconfigSystem_System_Cpus_Cpu_State_Index implements the yang.GoEnum
// interface. This ensures that OpenconfigSystem_System_Cpus_Cpu_State_Index can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystem_System_Cpus_Cpu_State_Index) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystem_System_Cpus_Cpu_State_Index.
func (E_OpenconfigSystem_System_Cpus_Cpu_State_Index) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystem_System_Cpus_Cpu_State_Index.
func (e E_OpenconfigSystem_System_Cpus_Cpu_State_Index) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystem_System_Cpus_Cpu_State_Index")
}

const (
	// OpenconfigSystem_System_Cpus_Cpu_State_Index_UNSET corresponds to the value UNSET of OpenconfigSystem_System_Cpus_Cpu_State_Index
	OpenconfigSystem_System_Cpus_Cpu_State_Index_UNSET E_OpenconfigSystem_System_Cpus_Cpu_State_Index = 0
	// OpenconfigSystem_System_Cpus_Cpu_State_Index_ALL corresponds to the value ALL of OpenconfigSystem_System_Cpus_Cpu_State_Index
	OpenconfigSystem_System_Cpus_Cpu_State_Index_ALL E_OpenconfigSystem_System_Cpus_Cpu_State_Index = 1
)


// E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType. An additional value named
// OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType int64

// IsYANGGoEnum ensures that OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType implements the yang.GoEnum
// interface. This ensures that OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType.
func (E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType.
func (e E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType")
}

const (
	// OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_UNSET corresponds to the value UNSET of OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType
	OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_UNSET E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType = 0
	// OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_SERVER corresponds to the value SERVER of OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType
	OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_SERVER E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType = 1
	// OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_PEER corresponds to the value PEER of OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType
	OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_PEER E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType = 2
	// OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_POOL corresponds to the value POOL of OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType
	OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType_POOL E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType = 3
)


// E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion is a derived int64 type which is used to represent
// the enumerated node OpenconfigSystem_System_SshServer_Config_ProtocolVersion. An additional value named
// OpenconfigSystem_System_SshServer_Config_ProtocolVersion_UNSET is added to the enumeration which is used as
// the nil value, indicating that the enumeration was not explicitly set by
// the program importing the generated structures.
type E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion int64

// IsYANGGoEnum ensures that OpenconfigSystem_System_SshServer_Config_ProtocolVersion implements the yang.GoEnum
// interface. This ensures that OpenconfigSystem_System_SshServer_Config_ProtocolVersion can be identified as a
// mapped type for a YANG enumeration.
func (E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion) IsYANGGoEnum() {}

// ΛMap returns the value lookup map associated with  OpenconfigSystem_System_SshServer_Config_ProtocolVersion.
func (E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion) ΛMap() map[string]map[int64]ygot.EnumDefinition { return ΛEnum; }

// String returns a logging-friendly string for E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion.
func (e E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion) String() string {
	return ygot.EnumLogString(e, int64(e), "E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion")
}

const (
	// OpenconfigSystem_System_SshServer_Config_ProtocolVersion_UNSET corresponds to the value UNSET of OpenconfigSystem_System_SshServer_Config_ProtocolVersion
	OpenconfigSystem_System_SshServer_Config_ProtocolVersion_UNSET E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion = 0
	// OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V2 corresponds to the value V2 of OpenconfigSystem_System_SshServer_Config_ProtocolVersion
	OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V2 E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion = 1
	// OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V1 corresponds to the value V1 of OpenconfigSystem_System_SshServer_Config_ProtocolVersion
	OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V1 E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion = 2
	// OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V1_V2 corresponds to the value V1_V2 of OpenconfigSystem_System_SshServer_Config_ProtocolVersion
	OpenconfigSystem_System_SshServer_Config_ProtocolVersion_V1_V2 E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion = 3
)


// ΛEnum is a map, keyed by the name of the type defined for each enum in the
// generated Go code, which provides a mapping between the constant int64 value
// of each value of the enumeration, and the string that is used to represent it
// in the YANG schema. The map is named ΛEnum in order to avoid clash with any
// valid YANG identifier.
var ΛEnum = map[string]map[int64]ygot.EnumDefinition{
	"E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE": {
		1: {Name: "AAA_ACCOUNTING_EVENT_COMMAND", DefiningModule: "openconfig-aaa-types"},
		2: {Name: "AAA_ACCOUNTING_EVENT_LOGIN", DefiningModule: "openconfig-aaa-types"},
	},
	"E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE": {
		1: {Name: "AAA_AUTHORIZATION_EVENT_COMMAND", DefiningModule: "openconfig-aaa-types"},
		2: {Name: "AAA_AUTHORIZATION_EVENT_CONFIG", DefiningModule: "openconfig-aaa-types"},
	},
	"E_OpenconfigAaaTypes_AAA_METHOD_TYPE": {
		1: {Name: "LOCAL", DefiningModule: "openconfig-aaa-types"},
		2: {Name: "RADIUS_ALL", DefiningModule: "openconfig-aaa-types"},
		3: {Name: "TACACS_ALL", DefiningModule: "openconfig-aaa-types"},
	},
	"E_OpenconfigAaaTypes_AAA_SERVER_TYPE": {
		1: {Name: "RADIUS", DefiningModule: "openconfig-aaa"},
		2: {Name: "TACACS", DefiningModule: "openconfig-aaa"},
	},
	"E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES": {
		1: {Name: "SYSTEM_ROLE_ADMIN", DefiningModule: "openconfig-aaa-types"},
	},
	"E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY": {
		1: {Name: "CRITICAL", DefiningModule: "openconfig-alarm-types"},
		2: {Name: "MAJOR", DefiningModule: "openconfig-alarm-types"},
		3: {Name: "MINOR", DefiningModule: "openconfig-alarm-types"},
		4: {Name: "UNKNOWN", DefiningModule: "openconfig-alarm-types"},
		5: {Name: "WARNING", DefiningModule: "openconfig-alarm-types"},
	},
	"E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID": {
		1: {Name: "AIS", DefiningModule: "openconfig-alarm-types"},
		2: {Name: "EQPT", DefiningModule: "openconfig-alarm-types"},
		3: {Name: "LOS", DefiningModule: "openconfig-alarm-types"},
		4: {Name: "OTS", DefiningModule: "openconfig-alarm-types"},
	},
	"E_OpenconfigMessages_DEBUG_SERVICE": {
	},
	"E_OpenconfigMessages_SyslogSeverity": {
		1: {Name: "EMERGENCY"},
		2: {Name: "ALERT"},
		3: {Name: "CRITICAL"},
		4: {Name: "ERROR"},
		5: {Name: "WARNING"},
		6: {Name: "NOTICE"},
		7: {Name: "INFORMATIONAL"},
		8: {Name: "DEBUG"},
	},
	"E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS": {
		1: {Name: "ACTIVE", DefiningModule: "openconfig-platform-types"},
		2: {Name: "DISABLED", DefiningModule: "openconfig-platform-types"},
		3: {Name: "INACTIVE", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON": {
		1: {Name: "REBOOT_CRITICAL_ERROR", DefiningModule: "openconfig-platform-types"},
		2: {Name: "REBOOT_POWER_FAILURE", DefiningModule: "openconfig-platform-types"},
		3: {Name: "REBOOT_USER_INITIATED", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger": {
		1: {Name: "USER_INITIATED"},
		2: {Name: "SYSTEM_INITIATED"},
	},
	"E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT": {
		1: {Name: "BACKPLANE", DefiningModule: "openconfig-platform-types"},
		2: {Name: "CHASSIS", DefiningModule: "openconfig-platform-types"},
		3: {Name: "CONTROLLER_CARD", DefiningModule: "openconfig-platform-types"},
		4: {Name: "CPU", DefiningModule: "openconfig-platform-types"},
		5: {Name: "FABRIC", DefiningModule: "openconfig-platform-types"},
		6: {Name: "FAN", DefiningModule: "openconfig-platform-types"},
		7: {Name: "FRU", DefiningModule: "openconfig-platform-types"},
		8: {Name: "INTEGRATED_CIRCUIT", DefiningModule: "openconfig-platform-types"},
		9: {Name: "LINECARD", DefiningModule: "openconfig-platform-types"},
		10: {Name: "PORT", DefiningModule: "openconfig-platform-types"},
		11: {Name: "POWER_SUPPLY", DefiningModule: "openconfig-platform-types"},
		12: {Name: "SENSOR", DefiningModule: "openconfig-platform-types"},
		13: {Name: "STORAGE", DefiningModule: "openconfig-platform-types"},
		14: {Name: "TRANSCEIVER", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT": {
		1: {Name: "BIOS", DefiningModule: "openconfig-platform-types"},
		2: {Name: "BOOT_LOADER", DefiningModule: "openconfig-platform-types"},
		3: {Name: "OPERATING_SYSTEM", DefiningModule: "openconfig-platform-types"},
		4: {Name: "OPERATING_SYSTEM_UPDATE", DefiningModule: "openconfig-platform-types"},
		5: {Name: "SOFTWARE_MODULE", DefiningModule: "openconfig-platform-types"},
	},
	"E_OpenconfigPlatform_ComponentRedundantRole": {
		1: {Name: "PRIMARY"},
		2: {Name: "SECONDARY"},
	},
	"E_OpenconfigSystemLogging_SYSLOG_FACILITY": {
		1: {Name: "ALL", DefiningModule: "openconfig-system-logging"},
		2: {Name: "AUDIT", DefiningModule: "openconfig-system-logging"},
		3: {Name: "AUTH", DefiningModule: "openconfig-system-logging"},
		4: {Name: "AUTHPRIV", DefiningModule: "openconfig-system-logging"},
		5: {Name: "CONSOLE", DefiningModule: "openconfig-system-logging"},
		6: {Name: "KERNEL", DefiningModule: "openconfig-system-logging"},
		7: {Name: "LOCAL0", DefiningModule: "openconfig-system-logging"},
		8: {Name: "LOCAL1", DefiningModule: "openconfig-system-logging"},
		9: {Name: "LOCAL2", DefiningModule: "openconfig-system-logging"},
		10: {Name: "LOCAL3", DefiningModule: "openconfig-system-logging"},
		11: {Name: "LOCAL4", DefiningModule: "openconfig-system-logging"},
		12: {Name: "LOCAL5", DefiningModule: "openconfig-system-logging"},
		13: {Name: "LOCAL6", DefiningModule: "openconfig-system-logging"},
		14: {Name: "LOCAL7", DefiningModule: "openconfig-system-logging"},
		15: {Name: "MAIL", DefiningModule: "openconfig-system-logging"},
		16: {Name: "NTP", DefiningModule: "openconfig-system-logging"},
		17: {Name: "SYSLOG", DefiningModule: "openconfig-system-logging"},
		18: {Name: "SYSTEM_DAEMON", DefiningModule: "openconfig-system-logging"},
		19: {Name: "USER", DefiningModule: "openconfig-system-logging"},
	},
	"E_OpenconfigSystemLogging_SyslogSeverity": {
		1: {Name: "EMERGENCY"},
		2: {Name: "ALERT"},
		3: {Name: "CRITICAL"},
		4: {Name: "ERROR"},
		5: {Name: "WARNING"},
		6: {Name: "NOTICE"},
		7: {Name: "INFORMATIONAL"},
		8: {Name: "DEBUG"},
	},
	"E_OpenconfigSystem_NTP_AUTH_TYPE": {
		1: {Name: "NTP_AUTH_MD5", DefiningModule: "openconfig-system"},
	},
	"E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record": {
		1: {Name: "START_STOP"},
		2: {Name: "STOP"},
	},
	"E_OpenconfigSystem_System_Cpus_Cpu_State_Index": {
		1: {Name: "ALL"},
	},
	"E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType": {
		1: {Name: "SERVER"},
		2: {Name: "PEER"},
		3: {Name: "POOL"},
	},
	"E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion": {
		1: {Name: "V2"},
		2: {Name: "V1"},
		3: {Name: "V1_V2"},
	},
}


var (
	// ySchema is a byte slice contain a gzip compressed representation of the
	// YANG schema from which the Go code was generated. When uncompressed the
	// contents of the byte slice is a JSON document containing an object, keyed
	// on the name of the generated struct, and containing the JSON marshalled
	// contents of a goyang yang.Entry struct, which defines the schema for the
	// fields within the struct.
	ySchema = []byte{
		0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0xbd, 0xfd, 0x57, 0xe2, 0x48,
		0x1a, 0x3f, 0xfa, 0x7b, 0xff, 0x15, 0x39, 0x9c, 0x3d, 0xe7, 0xca, 0x7e, 0x8d, 0x02, 0x0a, 0xb6,
		0xfe, 0x32, 0x87, 0x56, 0x7a, 0xd6, 0xef, 0xf8, 0x76, 0xd5, 0x9e, 0xdd, 0x59, 0x65, 0x3c, 0x11,
		0x4a, 0xcd, 0x1d, 0x48, 0xd8, 0xa4, 0xb0, 0xdb, 0x69, 0xf9, 0xdf, 0xef, 0x21, 0x40, 0x00, 0x21,
		0x90, 0xaa, 0x7a, 0x2a, 0x24, 0xf0, 0x99, 0xb3, 0x67, 0xb5, 0x91, 0xaa, 0x24, 0x95, 0xe7, 0xe5,
		0xf3, 0xbc, 0xff, 0xfc, 0x64, 0x18, 0x86, 0x91, 0xbb, 0xb0, 0xda, 0x2c, 0x77, 0x64, 0xe4, 0x9a,
		0xec, 0xd5, 0x6e, 0xb0, 0xdc, 0xf6, 0xe0, 0xd3, 0xdf, 0x6c, 0xa7, 0x99, 0x3b, 0x32, 0x8a, 0xc3,
		0x7f, 0x1e, 0xbb, 0xce, 0x93, 0xfd, 0x9c, 0x3b, 0x32, 0x0a, 0xc3, 0x0f, 0x4e, 0x6c, 0x2f, 0x77,
		0x64, 0x0c, 0xb6, 0x08, 0x3e, 0x68, 0xb8, 0xed, 0x8e, 0xeb, 0x30, 0x87, 0xfb, 0x53, 0x9f, 0x4f,
		0x5d, 0x62, 0xe2, 0x3b, 0xdb, 0xd3, 0xdf, 0x98, 0xbe, 0x5c, 0xf8, 0xf1, 0xc7, 0xcb, 0x86, 0x7f,
		0xb8, 0xf2, 0xd8, 0x93, 0xfd, 0x63, 0xe6, 0x4a, 0x53, 0x57, 0x73, 0x1b, 0x66, 0xa7, 0x65, 0xf1,
		0x27, 0xd7, 0x6b, 0x7f, 0xb8, 0x5c, 0xf0, 0xb5, 0x1b, 0xb7, 0xeb, 0x35, 0xd8, 0xdc, 0x2d, 0x06,
		0xb7, 0xc4, 0xde, 0xbe, 0xbb, 0x5e, 0xff, 0xae, 0x72, 0x9d, 0xc1, 0xd5, 0xb6, 0xe7, 0x7f, 0xf1,
		0x5f, 0x96, 0x5f, 0xf5, 0x9e, 0xbb, 0x6d, 0xe6, 0xf0, 0xdc, 0x91, 0xc1, 0xbd, 0x2e, 0x8b, 0xf8,
		0xe2, 0xc4, 0xb7, 0xa6, 0x6e, 0x6e, 0xe6, 0xdb, 0xbd, 0xa9, 0x4f, 0x7a, 0x1f, 0x9e, 0xfd, 0xe3,
		0xd1, 0xcf, 0xbe, 0x82, 0xe8, 0x87, 0x9a, 0x79, 0x13, 0x51, 0x0f, 0x35, 0xff, 0x85, 0x2c, 0x7d,
		0x31, 0x71, 0x5e, 0x90, 0xe0, 0x8b, 0x8a, 0xfb, 0xc2, 0x84, 0x5f, 0x9c, 0xf0, 0x0b, 0x14, 0x7f,
		0x91, 0xf3, 0x5f, 0x68, 0xc4, 0x8b, 0x5d, 0xfa, 0x82, 0xc3, 0x2f, 0x3c, 0x5a, 0x8d, 0xbf, 0x3a,
		0x2d, 0xcb, 0x89, 0x71, 0x18, 0xa3, 0x33, 0x1e, 0x2f, 0x59, 0xf2, 0x6c, 0x8b, 0x5f, 0x7c, 0x6c,
		0x02, 0x10, 0x21, 0x04, 0x49, 0x82, 0x10, 0x25, 0x0c, 0x69, 0x02, 0x91, 0x26, 0x14, 0x79, 0x82,
		0x59, 0x4c, 0x38, 0x4b, 0x08, 0x28, 0x36, 0x21, 0x4d, 0x48, 0x8e, 0xe1, 0xdb, 0x8c, 0x79, 0x82,
		0x63, 0x31, 0x12, 0xac, 0x8b, 0x79, 0x0a, 0xf1, 0x48, 0x4b, 0x98, 0xc4, 0x64, 0x48, 0x4d, 0x91,
		0xe4, 0x64, 0x49, 0x4f, 0x99, 0x04, 0x95, 0x49, 0x51, 0x9d, 0x24, 0xe3, 0x91, 0x66, 0x4c, 0x12,
		0x1d, 0xdf, 0x8e, 0xe3, 0xb8, 0xdc, 0xe2, 0xb6, 0xeb, 0x88, 0xbd, 0x3f, 0xbf, 0xf1, 0xc2, 0xda,
		0x56, 0xc7, 0xe2, 0x2f, 0xfd, 0x07, 0xd9, 0x75, 0x3b, 0xcc, 0x19, 0x10, 0x65, 0xf8, 0x44, 0xbb,
		0x63, 0xd4, 0x31, 0xfe, 0x75, 0x37, 0x94, 0x87, 0xbb, 0x42, 0x34, 0x3c, 0xb8, 0x26, 0xf7, 0xba,
		0x0d, 0xee, 0x0c, 0x29, 0xe7, 0x32, 0xbc, 0xe4, 0xd5, 0xf0, 0x8a, 0x0f, 0xc7, 0xe1, 0x15, 0xc7,
		0xbf, 0x3e, 0x7c, 0x19, 0x5d, 0xf1, 0x61, 0x48, 0xd8, 0x9f, 0x68, 0x4e, 0x39, 0xc6, 0x09, 0xe7,
		0x7c, 0x6e, 0x71, 0x26, 0xce, 0xde, 0x83, 0x65, 0x9a, 0xb9, 0xbb, 0x04, 0xee, 0x06, 0x77, 0x6b,
		0xe3, 0x6e, 0x11, 0x12, 0x26, 0x61, 0xee, 0x9b, 0xe0, 0x82, 0x54, 0xbc, 0xad, 0xa4, 0xfe, 0x05,
		0x4f, 0x5d, 0xfd, 0xb4, 0x73, 0xb1, 0x44, 0x91, 0xd2, 0xf9, 0x2e, 0x3e, 0xd9, 0xe8, 0xf3, 0x5a,
		0x70, 0x56, 0xb9, 0xc6, 0x8b, 0xe5, 0xfb, 0xb6, 0x1f, 0x1f, 0x4c, 0x8f, 0x16, 0x00, 0x4a, 0x03,
		0x4a, 0x03, 0x4a, 0x43, 0xd9, 0x6e, 0xb6, 0xb2, 0x1d, 0x4a, 0xc3, 0xc4, 0x80, 0xf4, 0xf1, 0xe0,
		0x7a, 0x80, 0xd1, 0x80, 0xd1, 0xe0, 0xec, 0x44, 0x38, 0x3b, 0x21, 0x10, 0x3d, 0x62, 0xec, 0x0d,
		0x84, 0xd0, 0xf1, 0x10, 0xa5, 0xfa, 0xd9, 0x6a, 0x81, 0xcf, 0xf1, 0x10, 0x8f, 0x18, 0xd2, 0x01,
		0x78, 0xde, 0x44, 0xf0, 0x3c, 0xa4, 0x6a, 0x41, 0xfd, 0x1a, 0xac, 0x12, 0x53, 0xaf, 0x05, 0x00,
		0x67, 0xa8, 0xd7, 0x8f, 0xb7, 0x73, 0xfb, 0xd6, 0x61, 0x72, 0x6f, 0xce, 0xe7, 0x9e, 0xed, 0x08,
		0x41, 0xdf, 0x91, 0x78, 0xfb, 0xbc, 0x59, 0x6a, 0x2e, 0xae, 0x89, 0x20, 0xab, 0xe5, 0x62, 0x98,
		0x04, 0x92, 0x4a, 0xae, 0xd3, 0x15, 0xd0, 0x70, 0x9d, 0x2e, 0xd4, 0x1b, 0xd4, 0x1b, 0x7c, 0x43,
		0x50, 0x71, 0x9b, 0x6e, 0x41, 0x76, 0xba, 0xc9, 0xf9, 0x85, 0x3a, 0x5d, 0xf8, 0x84, 0xe0, 0x13,
		0x02, 0x47, 0x6b, 0xe7, 0xe8, 0xa4, 0xfc, 0x41, 0x9d, 0xee, 0x46, 0xfa, 0x82, 0x96, 0xa2, 0x47,
		0xb5, 0x33, 0xd5, 0x01, 0x8f, 0x9f, 0xac, 0x47, 0xcf, 0x6e, 0xc4, 0x47, 0xc8, 0xc3, 0xef, 0x03,
		0x24, 0x03, 0x24, 0x03, 0x24, 0x43, 0xa5, 0x6e, 0xb6, 0x4a, 0x1d, 0x08, 0xc3, 0xc4, 0x70, 0xf2,
		0xd7, 0xe0, 0x72, 0x80, 0xca, 0x80, 0xca, 0xe0, 0xeb, 0x24, 0xf8, 0x3a, 0x21, 0xb4, 0x3c, 0x64,
		0xeb, 0x0d, 0x04, 0xcc, 0xb1, 0xc0, 0xa4, 0xf2, 0xc9, 0xea, 0x81, 0xcd, 0x8e, 0x08, 0x66, 0x76,
		0x00, 0x98, 0x01, 0x98, 0x01, 0x98, 0xa1, 0x58, 0x37, 0x5e, 0xb1, 0x3a, 0x09, 0xa2, 0x65, 0x07,
		0x50, 0x19, 0x50, 0x19, 0x1c, 0xad, 0x9d, 0xa3, 0x13, 0xc3, 0xc9, 0xce, 0x66, 0x82, 0x64, 0x47,
		0x27, 0x42, 0x76, 0x74, 0xc0, 0x63, 0xdb, 0xe1, 0xec, 0xd9, 0xb3, 0x38, 0x6b, 0x9a, 0x0d, 0xdb,
		0x6b, 0x74, 0x6d, 0x1e, 0x1f, 0x2d, 0xcf, 0x59, 0x0b, 0xf0, 0x0c, 0xf0, 0x0c, 0xf0, 0x0c, 0x55,
		0xbb, 0xd9, 0xaa, 0x76, 0x56, 0x30, 0x26, 0x86, 0xa5, 0x4f, 0xc3, 0x4b, 0x1f, 0x0f, 0xae, 0x0c,
		0x64, 0x0d, 0x64, 0x0d, 0x76, 0x4f, 0x9a, 0xdd, 0x13, 0x02, 0xda, 0xb3, 0xdc, 0xbe, 0x81, 0xb0,
		0x5b, 0x18, 0x86, 0x52, 0x1e, 0xb8, 0x0e, 0x4c, 0x1e, 0xab, 0x44, 0x43, 0xa4, 0x34, 0x23, 0x66,
		0x49, 0x06, 0x70, 0x77, 0x16, 0x70, 0x77, 0xec, 0x12, 0x8a, 0xf0, 0xe4, 0x5b, 0xcc, 0x7a, 0xf2,
		0xd8, 0x53, 0x9c, 0x53, 0x1f, 0xa9, 0xd5, 0x83, 0x18, 0xdf, 0xbd, 0x1a, 0x72, 0xea, 0xce, 0xce,
		0x10, 0xdd, 0xec, 0x06, 0xa4, 0xa8, 0x81, 0x21, 0x3a, 0xae, 0x27, 0x60, 0x96, 0x06, 0xdf, 0x86,
		0x21, 0x0a, 0x43, 0x14, 0x86, 0x28, 0x90, 0xe9, 0x66, 0x23, 0xd3, 0xbe, 0x28, 0x4c, 0xcc, 0xf4,
		0xbc, 0x72, 0x3d, 0x58, 0x9b, 0xb0, 0x36, 0xc1, 0xd3, 0x09, 0xf0, 0x74, 0x42, 0xf6, 0x65, 0xc0,
		0xd2, 0x1b, 0x68, 0x52, 0xc6, 0x80, 0x90, 0x8a, 0xa7, 0xaa, 0x07, 0x26, 0x7f, 0x67, 0x9e, 0xe9,
		0x77, 0x3b, 0x9d, 0xd6, 0x9b, 0x08, 0x5c, 0x9e, 0x58, 0x05, 0xd8, 0x0c, 0xd8, 0x0c, 0xd8, 0x0c,
		0x15, 0xbb, 0xe9, 0x2a, 0x76, 0x2c, 0x12, 0x13, 0x84, 0xcf, 0xdf, 0x99, 0x77, 0x13, 0x5c, 0x13,
		0x28, 0x1a, 0x28, 0x1a, 0x2c, 0x9e, 0x1c, 0x8b, 0x27, 0x86, 0xa6, 0xc7, 0x1c, 0xbe, 0x91, 0xa0,
		0x3a, 0x36, 0xd0, 0xa4, 0x39, 0x64, 0x2d, 0x18, 0xdb, 0x73, 0x3b, 0xcc, 0xe3, 0x36, 0x13, 0xe8,
		0x65, 0x3c, 0xb1, 0x06, 0xf8, 0x1a, 0xf8, 0x3a, 0x82, 0xa4, 0xde, 0xc4, 0xb5, 0x6f, 0xb8, 0x12,
		0x18, 0x1b, 0x0a, 0x58, 0x51, 0x01, 0xc7, 0x25, 0x57, 0x59, 0xb3, 0x50, 0xcd, 0x3c, 0x94, 0x24,
		0x61, 0x69, 0x52, 0x56, 0x21, 0x69, 0x22, 0xd2, 0x56, 0x25, 0x71, 0x32, 0x52, 0x27, 0x23, 0x79,
		0x3a, 0xd2, 0x17, 0x63, 0x01, 0x41, 0x56, 0x90, 0x66, 0x89, 0x70, 0xa1, 0x50, 0x8f, 0xcd, 0x48,
		0xb2, 0x11, 0xe8, 0xb9, 0x19, 0xc5, 0x26, 0x05, 0xc9, 0xe5, 0xb2, 0xec, 0x42, 0xc1, 0x36, 0xc4,
		0xec, 0x43, 0xc5, 0x46, 0xe4, 0xec, 0x44, 0xce, 0x56, 0xf4, 0xec, 0x25, 0xc7, 0x66, 0x92, 0xec,
		0x16, 0xde, 0xbe, 0x70, 0x8f, 0xd0, 0x05, 0xde, 0x09, 0xc1, 0x9e, 0xa1, 0x91, 0xea, 0xe6, 0xf3,
		0xa7, 0x64, 0xce, 0x4d, 0xe2, 0xcc, 0x72, 0xaf, 0x56, 0xab, 0x4b, 0x20, 0x6e, 0x06, 0xdb, 0x40,
		0xde, 0x40, 0xde, 0x40, 0xde, 0x48, 0x52, 0x4e, 0xd7, 0xb1, 0x5d, 0x87, 0x42, 0xdc, 0x1c, 0x2a,
		0xec, 0x31, 0x7c, 0x9c, 0x3b, 0xa5, 0x77, 0xaa, 0x46, 0xb3, 0xb4, 0x42, 0x98, 0x48, 0x18, 0x2b,
		0x92, 0x89, 0x86, 0x93, 0x79, 0x74, 0xdd, 0x16, 0xb3, 0x1c, 0xca, 0xa3, 0x29, 0xae, 0xc9, 0xd1,
		0xd8, 0x0e, 0xaf, 0xec, 0x13, 0x1e, 0xcc, 0x3e, 0xc1, 0x56, 0xd7, 0x96, 0xf3, 0xac, 0xce, 0x59,
		0x74, 0x87, 0x15, 0xde, 0xd8, 0xb9, 0xed, 0x28, 0xab, 0x99, 0x99, 0x4d, 0x7f, 0x1f, 0xa2, 0x8a,
		0xc3, 0x52, 0x69, 0x6f, 0xef, 0xa0, 0x54, 0xd8, 0xab, 0x7c, 0x2e, 0xef, 0x1f, 0x1c, 0x94, 0x3f,
		0x17, 0x3e, 0x6f, 0xd3, 0x5e, 0xe9, 0xab, 0x67, 0x35, 0xb8, 0xed, 0x3a, 0x27, 0xf6, 0xb3, 0x1d,
		0x8c, 0x36, 0x2f, 0x10, 0x5f, 0xe0, 0x82, 0x3d, 0x5b, 0xdc, 0x7e, 0x65, 0x43, 0x6d, 0x47, 0xb6,
		0x79, 0x6f, 0x9b, 0xf0, 0x1d, 0x5a, 0x3f, 0x92, 0x7c, 0x87, 0x07, 0x19, 0x7e, 0x87, 0x4f, 0x56,
		0xcb, 0x27, 0x7c, 0x89, 0x9f, 0xd2, 0xb1, 0x4b, 0x7d, 0x4d, 0x24, 0x77, 0x97, 0x5a, 0x74, 0x7f,
		0x86, 0xe8, 0x96, 0x64, 0xfb, 0x02, 0x98, 0x3c, 0x6b, 0x92, 0xba, 0xf8, 0x79, 0x7f, 0xbf, 0x72,
		0xb0, 0xbf, 0x5f, 0x38, 0xd8, 0x3b, 0x28, 0x1c, 0x96, 0xcb, 0xc5, 0x4a, 0xb1, 0x8c, 0xb7, 0x08,
		0x51, 0xad, 0x45, 0x54, 0x37, 0x59, 0xc3, 0x6e, 0x5b, 0x2d, 0x52, 0x69, 0x5d, 0x2c, 0x11, 0xec,
		0x35, 0x43, 0xa2, 0x25, 0xe8, 0x80, 0xec, 0xc0, 0xf7, 0x12, 0xe0, 0x7b, 0xe6, 0xe1, 0x7b, 0x09,
		0x3a, 0x21, 0x51, 0x9d, 0xf0, 0x29, 0xd9, 0xeb, 0xf6, 0x52, 0x16, 0x69, 0x95, 0xcc, 0xfe, 0x0b,
		0xd7, 0x4b, 0xa7, 0xa4, 0x85, 0x99, 0x59, 0xa3, 0x5f, 0x25, 0xf2, 0x7d, 0xc7, 0x77, 0x21, 0x97,
		0xb0, 0x16, 0xde, 0xc3, 0xe8, 0x57, 0xb1, 0xfc, 0x5f, 0xf1, 0x37, 0x24, 0xf0, 0x76, 0xe4, 0x42,
		0xd9, 0x2a, 0x21, 0x6c, 0xc9, 0x50, 0x12, 0x32, 0x3c, 0x90, 0xe1, 0x21, 0x2e, 0x77, 0xa4, 0x43,
		0x3f, 0x12, 0xbd, 0x15, 0x22, 0x11, 0xb3, 0x84, 0x32, 0x97, 0xea, 0xbd, 0x90, 0x8c, 0xc0, 0x10,
		0x2b, 0x24, 0x98, 0x39, 0x4f, 0xd1, 0x54, 0x6c, 0x83, 0x22, 0x29, 0xac, 0x04, 0x91, 0x01, 0x91,
		0x11, 0xf3, 0x36, 0xa5, 0x93, 0xc2, 0x06, 0x7c, 0xda, 0xf5, 0xac, 0xc7, 0x16, 0x41, 0xb6, 0xc6,
		0xd4, 0x6e, 0x48, 0xda, 0x40, 0xd2, 0xc6, 0xca, 0xd8, 0x4d, 0xcd, 0x86, 0x59, 0x7d, 0xd2, 0x86,
		0x7a, 0x14, 0x5e, 0x31, 0xfa, 0x9e, 0x4c, 0x96, 0x18, 0x72, 0x52, 0x21, 0x6e, 0x20, 0x6e, 0x90,
		0x93, 0x8a, 0x9c, 0x54, 0xc8, 0x1b, 0xc8, 0x9b, 0xcd, 0x91, 0x37, 0xc8, 0x49, 0xd5, 0x21, 0x84,
		0x89, 0x84, 0xb1, 0x22, 0x99, 0x68, 0x38, 0x19, 0xe4, 0xa4, 0x46, 0x1e, 0x0d, 0x72, 0x52, 0x05,
		0x6e, 0x0c, 0x39, 0xa9, 0x4b, 0x88, 0x0a, 0x41, 0x6d, 0xe4, 0xa4, 0xd2, 0x62, 0x0d, 0xfa, 0x5d,
		0x90, 0x93, 0x1a, 0x21, 0xba, 0x91, 0x93, 0x2a, 0xcb, 0xf6, 0xc8, 0x49, 0xcd, 0x9c, 0xa4, 0x46,
		0x4e, 0x2a, 0x44, 0x75, 0x62, 0xa2, 0x1a, 0x39, 0xa9, 0x80, 0xef, 0x46, 0x2a, 0x5f, 0x16, 0xe0,
		0x3b, 0x72, 0x52, 0x37, 0x4a, 0x27, 0x20, 0x27, 0x35, 0x35, 0x39, 0xa9, 0x32, 0x59, 0x51, 0x06,
		0x6d, 0x4a, 0xaa, 0x40, 0xc3, 0x4a, 0xf1, 0xf7, 0x43, 0xdb, 0xca, 0xec, 0x37, 0xf6, 0x26, 0x18,
		0xab, 0xce, 0x9d, 0xd9, 0x3e, 0xaf, 0x72, 0x2e, 0xd8, 0x02, 0xed, 0xdc, 0x76, 0x6a, 0x2d, 0xd6,
		0xee, 0x9f, 0x9e, 0x18, 0x66, 0xed, 0xcb, 0xe6, 0x89, 0x95, 0x6a, 0x08, 0x3b, 0x77, 0xe9, 0x35,
		0x99, 0xc7, 0x9a, 0x5f, 0xfa, 0x4f, 0xed, 0x74, 0x5b, 0xad, 0x6c, 0x37, 0x66, 0x9d, 0x25, 0xff,
		0x04, 0x3a, 0xb3, 0xce, 0x12, 0xfc, 0x86, 0xf5, 0x66, 0x8d, 0xdb, 0xa2, 0x94, 0xe4, 0x90, 0x75,
		0x34, 0x66, 0xf5, 0xdd, 0x27, 0xfe, 0xdd, 0xf2, 0x98, 0xd9, 0x76, 0x9b, 0xdd, 0x96, 0xc0, 0xfc,
		0xbc, 0x8f, 0x0b, 0xd1, 0xa2, 0x15, 0x2d, 0x5a, 0x3f, 0x7e, 0x11, 0x23, 0x10, 0xd0, 0x9e, 0x75,
		0xb3, 0xfa, 0xa3, 0x7f, 0x90, 0x8a, 0x89, 0x4d, 0x41, 0xb8, 0x19, 0x5e, 0xf7, 0x3c, 0xb8, 0x2c,
		0x06, 0x21, 0x60, 0x10, 0x02, 0x18, 0x3d, 0x51, 0x46, 0x4f, 0x68, 0x16, 0xc2, 0x07, 0x3e, 0xdf,
		0xc0, 0x71, 0x08, 0x62, 0xb8, 0x93, 0xec, 0xa8, 0xb5, 0x60, 0xef, 0x58, 0x32, 0x53, 0x48, 0x56,
		0x0a, 0xe3, 0xec, 0x12, 0x70, 0x76, 0xf6, 0x71, 0xb6, 0xd5, 0x6a, 0xb9, 0x8d, 0x60, 0x92, 0x7b,
		0x30, 0x2c, 0x44, 0x5c, 0x0d, 0x7f, 0xdc, 0x40, 0x4c, 0x21, 0x17, 0x80, 0xbc, 0xa1, 0x90, 0x3f,
		0xde, 0x8e, 0x70, 0x2a, 0xee, 0x54, 0xda, 0xc9, 0x5e, 0x49, 0xe4, 0xa5, 0x0d, 0xe9, 0x50, 0x20,
		0x94, 0x22, 0x19, 0x42, 0x94, 0xf0, 0x67, 0xab, 0x84, 0x04, 0x55, 0xd3, 0x3f, 0xc8, 0x12, 0x04,
		0xd4, 0x83, 0x3e, 0x32, 0xd5, 0x10, 0x2a, 0x91, 0xb8, 0xf0, 0xe8, 0xf6, 0x4b, 0x87, 0xfb, 0x87,
		0x95, 0x83, 0xd2, 0x61, 0x39, 0xfb, 0x67, 0xa8, 0x29, 0x8c, 0x50, 0x4f, 0xd0, 0x4e, 0x6c, 0x32,
		0xbf, 0xe1, 0xd9, 0x1d, 0x21, 0xa0, 0x3e, 0x91, 0xe5, 0x30, 0x5e, 0x0c, 0x15, 0x05, 0x15, 0xb5,
		0x32, 0x15, 0x25, 0x5c, 0x08, 0x21, 0x58, 0xf0, 0x40, 0xc3, 0x6b, 0xac, 0xdd, 0x91, 0x19, 0x8f,
		0x35, 0x58, 0x16, 0x77, 0xfe, 0x11, 0x7b, 0xb2, 0xba, 0x2d, 0x2e, 0xa4, 0x49, 0x73, 0x81, 0xf8,
		0x8b, 0xf7, 0xd6, 0xeb, 0xe0, 0x73, 0xf0, 0xf9, 0xca, 0xf8, 0x5c, 0xbc, 0xac, 0x47, 0xb0, 0x7c,
		0x87, 0x88, 0xd1, 0xff, 0xd7, 0xb5, 0x3b, 0xfd, 0x03, 0x37, 0x9f, 0x2c, 0xbb, 0xd5, 0xf5, 0x24,
		0x1c, 0xb1, 0xb3, 0x5b, 0x40, 0x00, 0x50, 0x0a, 0x00, 0xab, 0x65, 0x79, 0x6d, 0x7f, 0x23, 0xd9,
		0x7f, 0xf8, 0xe8, 0x60, 0x7e, 0xdd, 0xcc, 0xdf, 0xb6, 0xfd, 0xb6, 0xc5, 0x1b, 0x2f, 0x2a, 0xdc,
		0x1f, 0xee, 0x01, 0xf6, 0x07, 0xfb, 0x83, 0xfd, 0xd3, 0xcf, 0xfe, 0x4f, 0xb6, 0xd7, 0x0e, 0xe2,
		0x21, 0xaf, 0xcc, 0xf3, 0xa5, 0xac, 0xea, 0x99, 0x1d, 0x00, 0xb9, 0x01, 0xb9, 0x61, 0x5a, 0x2f,
		0xbc, 0xe6, 0x8b, 0xe5, 0x35, 0xd5, 0xb8, 0x6e, 0x66, 0x07, 0x70, 0x1d, 0xb8, 0x0e, 0x5c, 0xb7,
		0xf0, 0x9a, 0x76, 0x53, 0x9c, 0xcf, 0xec, 0x26, 0x38, 0x0b, 0x9c, 0x05, 0xce, 0x5a, 0x7c, 0xcd,
		0x96, 0xe5, 0x73, 0xd3, 0x63, 0x8f, 0xae, 0xdb, 0xff, 0x61, 0xf9, 0x32, 0x1a, 0x6d, 0xce, 0x1e,
		0xe0, 0x3c, 0x70, 0xde, 0xca, 0x38, 0xcf, 0x6e, 0x32, 0x87, 0xdb, 0xfc, 0x4d, 0xac, 0xcf, 0x78,
		0xc8, 0x7e, 0x22, 0xa5, 0x44, 0xa7, 0xc3, 0x4b, 0x7d, 0xb1, 0x7c, 0x85, 0x26, 0xde, 0xc7, 0x97,
		0xe7, 0x57, 0x97, 0x17, 0xb5, 0x8b, 0xdb, 0x87, 0xeb, 0xda, 0x97, 0xcb, 0xcb, 0xfe, 0x8f, 0xea,
		0xcd, 0xe5, 0x85, 0x28, 0x05, 0x04, 0x91, 0x6f, 0x5f, 0xaa, 0x3c, 0x5a, 0xb1, 0xef, 0xe0, 0xf0,
		0xb6, 0xbf, 0xdd, 0xd4, 0xae, 0x1f, 0x4e, 0x2f, 0x4e, 0x6f, 0x4f, 0xab, 0xb7, 0xb5, 0x93, 0x5c,
		0x12, 0xb9, 0x02, 0x34, 0x37, 0x7e, 0x7c, 0x7d, 0x7a, 0x7b, 0x7a, 0x5c, 0x3d, 0x7b, 0xa8, 0x5d,
		0x5f, 0x5f, 0x5e, 0x67, 0xe8, 0xc6, 0xaf, 0x2e, 0xff, 0x5d, 0xbb, 0x7e, 0xf8, 0x5a, 0x3d, 0x3d,
		0xfb, 0x76, 0x5d, 0xd3, 0xdd, 0xfa, 0xbb, 0x4e, 0x2d, 0x09, 0xc8, 0x35, 0x18, 0xb7, 0xdb, 0x4c,
		0x4d, 0x7f, 0x05, 0x3b, 0x40, 0x7b, 0x41, 0x7b, 0xad, 0x4c, 0x7b, 0xf5, 0x29, 0x90, 0xdb, 0x8d,
		0xbf, 0x7c, 0xa1, 0x9e, 0x1e, 0x12, 0x9d, 0x96, 0x72, 0xdf, 0x9c, 0x41, 0x5e, 0x53, 0xce, 0xb1,
		0x1c, 0xd7, 0x67, 0x0d, 0xd7, 0x69, 0x0a, 0x79, 0xaa, 0x91, 0x4a, 0x27, 0x26, 0xba, 0x33, 0x9b,
		0x4a, 0x47, 0xd7, 0xd1, 0x08, 0x49, 0x75, 0xf4, 0xba, 0xcf, 0xff, 0x6e, 0xf3, 0xc6, 0x8b, 0xfb,
		0xca, 0x3c, 0x35, 0x0b, 0x6e, 0x76, 0x1f, 0xd4, 0x61, 0x42, 0x0f, 0x2a, 0xea, 0x41, 0xd1, 0xf1,
		0x2f, 0xb9, 0x26, 0xe3, 0x96, 0xdd, 0xf2, 0xe5, 0x8d, 0xa9, 0xd1, 0x06, 0x9b, 0x35, 0x46, 0xcd,
		0xe4, 0x6f, 0x1d, 0xe6, 0x63, 0x32, 0xd2, 0x02, 0x16, 0x18, 0x1e, 0xd1, 0xda, 0x8d, 0x54, 0x93,
		0x6e, 0xce, 0x2d, 0xd9, 0x8c, 0x5b, 0xcf, 0x1c, 0x34, 0xee, 0xd9, 0xcf, 0xcf, 0xcc, 0x93, 0xe7,
		0xfb, 0xd1, 0x06, 0xe0, 0x7b, 0xf0, 0xfd, 0x46, 0xf0, 0x7d, 0x58, 0x1a, 0x6b, 0x7a, 0xac, 0xd9,
		0x75, 0x9a, 0x56, 0xff, 0x37, 0xb7, 0xc5, 0x66, 0x81, 0x9c, 0x29, 0xc7, 0x1b, 0x53, 0x32, 0x42,
		0xa2, 0xfb, 0x7a, 0xae, 0xe6, 0x74, 0xdb, 0xfd, 0x67, 0xec, 0x65, 0xa2, 0x0d, 0x56, 0xe2, 0x95,
		0xe4, 0xdc, 0xe2, 0x6c, 0x57, 0x09, 0x7a, 0x1b, 0x0a, 0x55, 0xce, 0xfd, 0xab, 0x3f, 0x9c, 0x59,
		0x3e, 0xbf, 0x09, 0x2f, 0x7e, 0x3d, 0xb8, 0xf6, 0x0a, 0x0d, 0x18, 0x05, 0x07, 0xde, 0xc7, 0x5d,
		0xe0, 0xc4, 0x83, 0xf1, 0x02, 0x27, 0x1e, 0x9c, 0x78, 0x70, 0xe2, 0xc1, 0x89, 0x97, 0x6e, 0x27,
		0x9e, 0xdb, 0xb0, 0xe4, 0xca, 0x62, 0xc3, 0x95, 0xd0, 0x75, 0xd0, 0x75, 0x2b, 0xd3, 0x75, 0xd9,
		0x48, 0x74, 0x6a, 0xb3, 0xb6, 0xeb, 0x49, 0x14, 0xc5, 0x0e, 0xd7, 0xc1, 0x15, 0x0e, 0x0e, 0x4b,
		0xda, 0x15, 0x6e, 0xbd, 0x5a, 0x76, 0x4b, 0x6a, 0xfc, 0xf9, 0xb8, 0xbf, 0x4f, 0xb8, 0xc5, 0x66,
		0xb9, 0xc5, 0xe0, 0x10, 0x23, 0x1d, 0xea, 0x99, 0x76, 0x57, 0x98, 0xf4, 0xc0, 0x2a, 0x85, 0x01,
		0x55, 0x8a, 0xc3, 0x48, 0x14, 0x46, 0x95, 0x52, 0x0c, 0x1b, 0xa1, 0x1a, 0x30, 0x45, 0x3e, 0x8a,
		0x88, 0x6e, 0xcc, 0x84, 0xc2, 0x6c, 0x10, 0x92, 0x59, 0x20, 0x1a, 0x07, 0x42, 0xa5, 0xf9, 0xd4,
		0x13, 0x1a, 0x66, 0x51, 0x4f, 0x41, 0xcc, 0xaa, 0xcb, 0xed, 0x96, 0xfd, 0x37, 0x6b, 0xca, 0xeb,
		0xe7, 0x70, 0x07, 0xa8, 0x67, 0xa8, 0x67, 0xa8, 0x67, 0xa8, 0x67, 0xa8, 0x67, 0xa8, 0x67, 0xa8,
		0xe7, 0xa4, 0x4c, 0xf2, 0xd5, 0x84, 0x7c, 0x85, 0x5c, 0x4a, 0x86, 0x6a, 0x88, 0xf7, 0x7c, 0x70,
		0xb5, 0x24, 0x5d, 0x6d, 0x4f, 0xcf, 0x66, 0x53, 0x6a, 0x2a, 0x40, 0xb8, 0x12, 0x0e, 0x6d, 0xb8,
		0xdb, 0x14, 0x79, 0x5b, 0xde, 0xa1, 0xdd, 0x14, 0xec, 0xe8, 0x1f, 0xba, 0xb3, 0x05, 0xd6, 0x5c,
		0x59, 0x9c, 0x33, 0xcf, 0x11, 0xc6, 0x27, 0xb9, 0xbb, 0x82, 0x79, 0x58, 0xff, 0xb9, 0xdf, 0xbb,
		0xbf, 0x37, 0xb7, 0x0a, 0x77, 0x45, 0xf3, 0xb0, 0xfe, 0x5e, 0xbc, 0x2b, 0x98, 0xa5, 0x7a, 0x7e,
		0xe2, 0x93, 0xbb, 0x62, 0xa9, 0x1e, 0x7c, 0xf1, 0x7d, 0xef, 0xae, 0x50, 0xac, 0xe7, 0xe3, 0xbf,
		0x83, 0xba, 0xc8, 0x33, 0x5c, 0xde, 0x9c, 0xfe, 0x47, 0xfa, 0x41, 0xfe, 0xdc, 0x92, 0x7a, 0x94,
		0xfc, 0x3f, 0x72, 0xa9, 0x8c, 0xe2, 0xf5, 0x45, 0xd7, 0x50, 0x40, 0x4b, 0x08, 0x3d, 0x91, 0xd9,
		0x7b, 0x10, 0x7a, 0x10, 0x7a, 0xf4, 0x42, 0x2f, 0x1b, 0x51, 0x3c, 0x39, 0x0e, 0x03, 0x77, 0x81,
		0xbb, 0xc0, 0x5d, 0xcb, 0xb9, 0xcb, 0xed, 0x30, 0xcf, 0xec, 0xdb, 0x28, 0x5d, 0x5f, 0x9c, 0xc9,
		0x26, 0x17, 0x83, 0xd7, 0xc0, 0x6b, 0x2b, 0xe3, 0xb5, 0x0c, 0xb7, 0xff, 0xb8, 0xbc, 0xaa, 0x5d,
		0x3f, 0xdc, 0xdc, 0x56, 0x6f, 0xbf, 0xdd, 0x64, 0xa7, 0xf9, 0xc7, 0xc9, 0xe9, 0x4d, 0xf5, 0xcb,
		0x59, 0x36, 0xfa, 0x7d, 0x9c, 0x5e, 0x54, 0x8f, 0x6f, 0x4f, 0x7f, 0xaf, 0x65, 0xe1, 0x5e, 0xa5,
		0xef, 0x74, 0x0d, 0x9a, 0x7a, 0x74, 0x2c, 0x6f, 0x20, 0x8a, 0x04, 0x95, 0xd0, 0x70, 0x1d, 0xf4,
		0x0f, 0xf4, 0xcf, 0xca, 0xf4, 0x4f, 0x8b, 0x59, 0x4f, 0x92, 0xba, 0xe7, 0x40, 0xcc, 0x83, 0x14,
		0x78, 0x9f, 0x77, 0x76, 0x76, 0x07, 0xff, 0x1b, 0xbb, 0x99, 0x07, 0xce, 0xe1, 0xdd, 0xc0, 0xec,
		0x49, 0x96, 0x69, 0xb9, 0xe9, 0xb8, 0x52, 0x5c, 0x1b, 0x2c, 0x04, 0xdb, 0x82, 0x6d, 0x61, 0xa2,
		0x2d, 0xe6, 0xb1, 0x86, 0x2d, 0xe1, 0x00, 0x09, 0x56, 0x21, 0x85, 0x19, 0xdc, 0xa5, 0xc8, 0x5d,
		0xc2, 0x29, 0xcc, 0x0d, 0xd7, 0xf3, 0x58, 0x83, 0x5b, 0x8f, 0x2d, 0x66, 0x32, 0xcf, 0x73, 0x3d,
		0x85, 0xc6, 0x1e, 0x73, 0xf6, 0x92, 0xcb, 0x9a, 0x2a, 0x22, 0x6b, 0x2a, 0x31, 0x16, 0x20, 0x63,
		0x05, 0x3a, 0x96, 0x90, 0xb3, 0x93, 0x44, 0xb3, 0xa6, 0x44, 0x59, 0x25, 0x5c, 0x68, 0x35, 0x5f,
		0x6d, 0xdf, 0xf5, 0xde, 0x4c, 0xc7, 0x75, 0xcc, 0x27, 0x8b, 0x5b, 0x2d, 0x59, 0xce, 0x99, 0xa1,
		0xa5, 0xe8, 0xad, 0x25, 0xdf, 0x85, 0x5c, 0x1a, 0xa2, 0x32, 0x63, 0x51, 0x30, 0x18, 0x31, 0xa3,
		0x51, 0x31, 0x1c, 0x39, 0xe3, 0x91, 0x33, 0x20, 0x3d, 0x23, 0xca, 0x31, 0xa4, 0x82, 0x63, 0xc6,
		0x50, 0x4a, 0x6b, 0x9c, 0xa3, 0x98, 0xba, 0x0e, 0x67, 0x9e, 0x54, 0x86, 0xe3, 0x47, 0x56, 0xfa,
		0xac, 0xb0, 0x85, 0x5a, 0xc6, 0xa3, 0x9a, 0xd7, 0x6a, 0xea, 0x46, 0x28, 0x32, 0x20, 0xa7, 0x1d,
		0x9b, 0xea, 0x29, 0x74, 0xe1, 0x7e, 0xd4, 0xb9, 0x79, 0x63, 0x72, 0xa0, 0xca, 0xd1, 0x53, 0xa4,
		0xec, 0xe9, 0x57, 0x41, 0x90, 0x29, 0x39, 0xf3, 0x2a, 0xe8, 0x33, 0x26, 0xb3, 0xf8, 0x76, 0x3e,
		0xad, 0x66, 0x75, 0x3d, 0xa1, 0x0c, 0x4e, 0x99, 0x46, 0x05, 0x8f, 0x56, 0xd3, 0x6c, 0xb6, 0x5a,
		0x1d, 0x32, 0xc4, 0xf2, 0x71, 0x43, 0xe0, 0x14, 0xe0, 0x14, 0xe0, 0x14, 0xe0, 0x14, 0xe0, 0x14,
		0xe0, 0x14, 0xe0, 0x14, 0xe0, 0x14, 0x05, 0x9c, 0xc2, 0x89, 0x61, 0x0a, 0x07, 0x4a, 0x01, 0x4a,
		0x01, 0x4a, 0x01, 0x4a, 0x01, 0x4a, 0x01, 0x4a, 0x01, 0x4a, 0x01, 0x4a, 0x51, 0x46, 0x29, 0x2f,
		0x4d, 0xcf, 0x6c, 0xb9, 0xcf, 0xa6, 0xfb, 0xca, 0xbc, 0xa7, 0x96, 0xfb, 0x9d, 0x0c, 0xae, 0x44,
		0x6d, 0x0c, 0xdc, 0x02, 0xdc, 0x02, 0xdc, 0x02, 0xdc, 0x02, 0xdc, 0x02, 0xdc, 0x02, 0xdc, 0x02,
		0xdc, 0x22, 0x89, 0x5b, 0xec, 0xbe, 0x1c, 0x74, 0x08, 0xf3, 0x56, 0x3e, 0x6e, 0x08, 0x9c, 0x02,
		0x9c, 0x02, 0x9c, 0x02, 0x9c, 0x02, 0x9c, 0x02, 0x9c, 0x02, 0x9c, 0x02, 0x9c, 0x22, 0x89, 0x53,
		0x3c, 0xd6, 0x60, 0xf6, 0x2b, 0xf3, 0xc8, 0x70, 0xca, 0xc7, 0x0d, 0x81, 0x53, 0x80, 0x53, 0x80,
		0x53, 0x80, 0x53, 0x80, 0x53, 0x80, 0x53, 0x80, 0x53, 0x80, 0x53, 0xa4, 0x71, 0x4a, 0xcb, 0x7a,
		0x33, 0x3d, 0xb7, 0xd5, 0x72, 0x69, 0xd1, 0xca, 0xbc, 0x6d, 0x81, 0x59, 0x80, 0x59, 0x80, 0x59,
		0x80, 0x59, 0x80, 0x59, 0x80, 0x59, 0x80, 0x59, 0x80, 0x59, 0xa4, 0x31, 0x4b, 0xa7, 0x8f, 0x2e,
		0xb8, 0xdd, 0x66, 0x6e, 0x97, 0x13, 0x62, 0x96, 0x79, 0xdb, 0x02, 0xb3, 0x00, 0xb3, 0x00, 0xb3,
		0x00, 0xb3, 0x00, 0xb3, 0x00, 0xb3, 0x00, 0xb3, 0x00, 0xb3, 0x48, 0x62, 0x16, 0xee, 0x52, 0x36,
		0x5b, 0x99, 0xda, 0x0d, 0x08, 0x05, 0x08, 0x05, 0x08, 0x05, 0x08, 0x05, 0x08, 0x05, 0x08, 0x05,
		0x08, 0x05, 0x08, 0x45, 0x7b, 0xfb, 0x39, 0xc9, 0xc9, 0x76, 0xe1, 0x7a, 0xb5, 0x09, 0x77, 0x9d,
		0x86, 0xcd, 0x76, 0x95, 0xfb, 0x35, 0x1a, 0xaa, 0xa3, 0xef, 0xae, 0x1a, 0x36, 0x7b, 0x38, 0x1e,
		0xdf, 0x46, 0x6d, 0x70, 0x17, 0x29, 0x98, 0x1c, 0xac, 0xd4, 0xd7, 0x2f, 0x54, 0x8c, 0x0a, 0x2d,
		0xfc, 0xd0, 0x0b, 0x73, 0x75, 0x90, 0x11, 0xbd, 0x30, 0xe3, 0x2e, 0xb4, 0x1a, 0xbe, 0xf9, 0x6a,
		0xbb, 0xad, 0x40, 0x90, 0xd1, 0xb5, 0xc1, 0x9c, 0xb7, 0x2b, 0x2c, 0x34, 0x58, 0x68, 0xb0, 0xd0,
		0x60, 0xa1, 0xc1, 0x42, 0x83, 0x85, 0x06, 0x0b, 0x0d, 0x16, 0x9a, 0xa4, 0x0f, 0xd9, 0xe2, 0x6e,
		0xdb, 0x6e, 0x98, 0x6e, 0xc7, 0x7c, 0x6c, 0xb9, 0x8d, 0xbf, 0x58, 0x93, 0x0e, 0xb5, 0x44, 0xed,
		0x0c, 0xe4, 0x02, 0xe4, 0x02, 0xe4, 0x02, 0xe4, 0x02, 0xe4, 0x02, 0xe4, 0x02, 0xe4, 0x02, 0xe4,
		0x22, 0xdb, 0x13, 0x73, 0x88, 0x2a, 0x48, 0xfb, 0x62, 0xce, 0xee, 0x09, 0xb4, 0x02, 0xb4, 0x02,
		0xb4, 0x02, 0xb4, 0x02, 0xb4, 0x02, 0xb4, 0x02, 0xb4, 0x02, 0xb4, 0x22, 0x89, 0x56, 0x1a, 0x6e,
		0xbb, 0xd3, 0x62, 0x41, 0x00, 0xc7, 0x7a, 0x74, 0x3d, 0xba, 0x0a, 0x83, 0xa8, 0x8d, 0x81, 0x5b,
		0x80, 0x5b, 0x80, 0x5b, 0x80, 0x5b, 0x80, 0x5b, 0x80, 0x5b, 0x80, 0x5b, 0x80, 0x5b, 0xd4, 0x71,
		0x0b, 0x75, 0x6d, 0x64, 0xf4, 0xd6, 0xc0, 0x2e, 0xc0, 0x2e, 0xc0, 0x2e, 0xc0, 0x2e, 0xc0, 0x2e,
		0xc0, 0x2e, 0xc0, 0x2e, 0xc0, 0x2e, 0x92, 0xd8, 0xa5, 0x69, 0x71, 0xcb, 0x6c, 0xd9, 0xce, 0x5f,
		0x64, 0x90, 0x65, 0x66, 0x47, 0x20, 0x15, 0x20, 0x15, 0x20, 0x15, 0x20, 0x15, 0x20, 0x15, 0x20,
		0x15, 0x20, 0x15, 0x20, 0x15, 0x49, 0xa4, 0xc2, 0x1a, 0x5e, 0x83, 0x0c, 0xa4, 0x4c, 0x6e, 0x06,
		0x7c, 0x02, 0x7c, 0x02, 0x7c, 0x02, 0x7c, 0x02, 0x7c, 0x02, 0x7c, 0x02, 0x7c, 0x02, 0x7c, 0x22,
		0x89, 0x4f, 0x82, 0xa1, 0xab, 0x0d, 0xd7, 0xe1, 0x9e, 0xdb, 0x32, 0x3b, 0x9e, 0xcb, 0xdd, 0x86,
		0x4b, 0xd7, 0x79, 0x6a, 0xe1, 0xee, 0x40, 0x30, 0x40, 0x30, 0x40, 0x30, 0x40, 0x30, 0x40, 0x30,
		0x40, 0x30, 0x40, 0x30, 0x40, 0x30, 0x98, 0xf1, 0x0a, 0x9c, 0x02, 0x9c, 0x02, 0x9c, 0x02, 0x9c,
		0x02, 0x9c, 0x02, 0x9c, 0x02, 0x9c, 0xb2, 0x66, 0x38, 0xa5, 0x6d, 0xb5, 0xfa, 0x2a, 0x80, 0xb8,
		0xae, 0x79, 0xee, 0xae, 0x40, 0x2c, 0x40, 0x2c, 0x40, 0x2c, 0x40, 0x2c, 0x40, 0x2c, 0x40, 0x2c,
		0x40, 0x2c, 0x40, 0x2c, 0x92, 0x88, 0xa5, 0xe3, 0xda, 0xbe, 0xeb, 0x10, 0x03, 0x96, 0x79, 0x9b,
		0x02, 0xaf, 0x00, 0xaf, 0x00, 0xaf, 0x00, 0xaf, 0x00, 0xaf, 0x00, 0xaf, 0x00, 0xaf, 0x00, 0xaf,
		0x48, 0x4f, 0x7a, 0x6d, 0x30, 0xfb, 0x95, 0x79, 0xa6, 0xfb, 0xca, 0xbc, 0x20, 0xf5, 0x84, 0x6e,
		0xd8, 0x6b, 0xc4, 0xce, 0x40, 0x2e, 0x40, 0x2e, 0x40, 0x2e, 0x40, 0x2e, 0x40, 0x2e, 0x40, 0x2e,
		0x40, 0x2e, 0x40, 0x2e, 0x92, 0xc8, 0xc5, 0xef, 0x7a, 0x1d, 0xcf, 0xf6, 0x99, 0xd9, 0x74, 0xbf,
		0xd3, 0x4d, 0x17, 0x9a, 0xbb, 0x2b, 0x10, 0x0b, 0x10, 0x0b, 0x10, 0x0b, 0x10, 0x0b, 0x10, 0x0b,
		0x10, 0x0b, 0x10, 0x0b, 0x10, 0x8b, 0xec, 0x84, 0xfa, 0x56, 0xc7, 0x1c, 0x68, 0x2b, 0xf2, 0xf1,
		0x42, 0xd1, 0x5b, 0x03, 0xbb, 0x00, 0xbb, 0x00, 0xbb, 0x00, 0xbb, 0x00, 0xbb, 0x00, 0xbb, 0x00,
		0xbb, 0x00, 0xbb, 0xc8, 0x62, 0x17, 0x97, 0x13, 0x96, 0x0b, 0x4d, 0xed, 0x06, 0x84, 0x02, 0x84,
		0x02, 0x84, 0x02, 0x84, 0x02, 0x84, 0x02, 0x84, 0x02, 0x84, 0x02, 0x84, 0x22, 0x89, 0x50, 0xba,
		0x4e, 0x93, 0x3d, 0xd9, 0x0e, 0xa1, 0x53, 0x65, 0x66, 0x47, 0x20, 0x15, 0x20, 0x15, 0x20, 0x15,
		0x20, 0x15, 0x20, 0x15, 0x20, 0x15, 0x20, 0x15, 0x20, 0x15, 0x69, 0xa4, 0xc2, 0x7e, 0x74, 0x58,
		0x83, 0xb3, 0xa6, 0x39, 0x31, 0xf5, 0x87, 0x0e, 0xb5, 0x2c, 0xd8, 0x1d, 0x08, 0x06, 0x08, 0x06,
		0x08, 0x06, 0x08, 0x06, 0x08, 0x06, 0x08, 0x06, 0x08, 0x06, 0x08, 0x46, 0x1a, 0xc1, 0xf8, 0xdd,
		0x4e, 0xc7, 0xf5, 0xfa, 0x20, 0xc3, 0x63, 0xff, 0xeb, 0x32, 0x9f, 0x13, 0xe2, 0x97, 0xc8, 0xbd,
		0x81, 0x5e, 0x80, 0x5e, 0x80, 0x5e, 0x80, 0x5e, 0x80, 0x5e, 0x80, 0x5e, 0x80, 0x5e, 0x80, 0x5e,
		0x84, 0x57, 0x08, 0xd2, 0x6a, 0xae, 0xea, 0x38, 0x2e, 0xb7, 0xfa, 0x6f, 0x5a, 0x8a, 0x3c, 0x73,
		0x7e, 0xe3, 0x85, 0xb5, 0xad, 0x8e, 0xc5, 0x5f, 0xfa, 0x12, 0x78, 0xd7, 0xed, 0x30, 0xa7, 0x11,
		0xa0, 0x89, 0x50, 0x0f, 0xed, 0x36, 0xdc, 0x76, 0xc7, 0x75, 0x98, 0xc3, 0xfd, 0xf1, 0xaf, 0xbb,
		0x3e, 0xb7, 0x38, 0xdb, 0xed, 0x34, 0x6c, 0xb6, 0xfb, 0x64, 0x29, 0xa5, 0xca, 0xe4, 0x7c, 0xee,
		0x75, 0x1b, 0xdc, 0x19, 0x2a, 0x81, 0xcb, 0xf0, 0x0e, 0xae, 0x86, 0x37, 0xf0, 0x70, 0x1c, 0xde,
		0xc0, 0xf8, 0xd7, 0x87, 0x9b, 0xfe, 0x0d, 0x3c, 0x5c, 0x35, 0x6c, 0xf6, 0xf0, 0xb5, 0x7f, 0x03,
		0xb5, 0xc1, 0xf5, 0x3f, 0xe9, 0x79, 0x35, 0x02, 0xaf, 0x25, 0xe7, 0xb8, 0x8e, 0x39, 0x75, 0x26,
		0xa2, 0x2f, 0x26, 0x54, 0x88, 0x33, 0x3b, 0x09, 0x12, 0xc7, 0x50, 0x17, 0x16, 0x05, 0x97, 0xc9,
		0xc2, 0x49, 0x15, 0x18, 0x49, 0x04, 0x1f, 0x55, 0x61, 0x23, 0x19, 0x5c, 0x24, 0x83, 0x89, 0x74,
		0xf0, 0x50, 0xaf, 0x20, 0x3a, 0xb1, 0x3d, 0xb9, 0x17, 0x6f, 0x35, 0x7c, 0xf3, 0xd5, 0x76, 0x5b,
		0x16, 0xa9, 0x8f, 0x79, 0xee, 0xae, 0xb0, 0xce, 0x60, 0x9d, 0xc1, 0x3a, 0x83, 0x75, 0x06, 0xeb,
		0x0c, 0xd6, 0x19, 0xac, 0x33, 0x58, 0x67, 0x92, 0xbe, 0x65, 0x8b, 0xbb, 0x6d, 0xbb, 0x61, 0xba,
		0x1d, 0xf2, 0x22, 0xc9, 0xc8, 0x9d, 0x81, 0x5c, 0x80, 0x5c, 0x80, 0x5c, 0x80, 0x5c, 0x80, 0x5c,
		0x80, 0x5c, 0x80, 0x5c, 0x80, 0x5c, 0x24, 0x91, 0xcb, 0x08, 0x55, 0x50, 0xb6, 0xfe, 0x9e, 0xb3,
		0x27, 0xd0, 0x0a, 0xd0, 0x0a, 0xd0, 0x0a, 0xd0, 0x0a, 0xd0, 0x0a, 0xd0, 0x0a, 0xd0, 0x0a, 0xd0,
		0x8a, 0x24, 0x5a, 0x99, 0x28, 0x0e, 0xb0, 0x1e, 0x5d, 0x8f, 0x2e, 0x81, 0x2f, 0x6a, 0x63, 0xe0,
		0x16, 0xe0, 0x16, 0xe0, 0x16, 0xe0, 0x16, 0xe0, 0x16, 0xe0, 0x16, 0xe0, 0x16, 0xe0, 0x16, 0x75,
		0xdc, 0xc2, 0xed, 0x36, 0x73, 0xbb, 0x5a, 0x90, 0xcb, 0x87, 0xad, 0x81, 0x5d, 0x80, 0x5d, 0x80,
		0x5d, 0x80, 0x5d, 0x80, 0x5d, 0x80, 0x5d, 0x80, 0x5d, 0x80, 0x5d, 0x24, 0xb1, 0x4b, 0xd3, 0xe2,
		0x96, 0xd9, 0xb2, 0x9d, 0xbf, 0xc8, 0x20, 0xcb, 0xcc, 0x8e, 0x40, 0x2a, 0x40, 0x2a, 0x40, 0x2a,
		0x40, 0x2a, 0x40, 0x2a, 0x40, 0x2a, 0x40, 0x2a, 0x40, 0x2a, 0x92, 0x48, 0x85, 0x35, 0xbc, 0x06,
		0x19, 0x48, 0x99, 0xdc, 0x0c, 0xf8, 0x04, 0xf8, 0x04, 0xf8, 0x04, 0xf8, 0x04, 0xf8, 0x04, 0xf8,
		0x04, 0xf8, 0x04, 0xf8, 0x44, 0x12, 0x9f, 0x04, 0x03, 0xe5, 0x1b, 0xae, 0xc3, 0x3d, 0xb7, 0x65,
		0x76, 0x3c, 0x97, 0xbb, 0x0d, 0x97, 0x6e, 0x3e, 0xc9, 0xc2, 0xdd, 0x81, 0x60, 0x80, 0x60, 0x80,
		0x60, 0x80, 0x60, 0x80, 0x60, 0x80, 0x60, 0x80, 0x60, 0x80, 0x60, 0x24, 0x11, 0x8c, 0xdd, 0x97,
		0x83, 0x0e, 0xe1, 0x50, 0xb5, 0x8f, 0x1b, 0x02, 0xa7, 0x00, 0xa7, 0x00, 0xa7, 0x00, 0xa7, 0x00,
		0xa7, 0x00, 0xa7, 0x00, 0xa7, 0x00, 0xa7, 0x48, 0xe2, 0x94, 0xb6, 0xd5, 0xea, 0xab, 0x00, 0xe2,
		0xba, 0xe6, 0xb9, 0xbb, 0x02, 0xb1, 0x00, 0xb1, 0x00, 0xb1, 0x00, 0xb1, 0x00, 0xb1, 0x00, 0xb1,
		0x00, 0xb1, 0x00, 0xb1, 0x48, 0x22, 0x96, 0x8e, 0x6b, 0xfb, 0xae, 0x43, 0x0c, 0x58, 0xe6, 0x6d,
		0x0a, 0xbc, 0x02, 0xbc, 0x02, 0xbc, 0x02, 0xbc, 0x02, 0xbc, 0x02, 0xbc, 0x02, 0xbc, 0x02, 0xbc,
		0x22, 0x89, 0x57, 0x3c, 0xd6, 0x60, 0xf6, 0x2b, 0xf3, 0x4c, 0xf7, 0x95, 0x79, 0x41, 0xea, 0x09,
		0x15, 0x68, 0x89, 0xdc, 0x19, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8, 0x05, 0xc8,
		0x05, 0xc8, 0x05, 0xc8, 0x45, 0x12, 0xb9, 0xf8, 0x5d, 0xaf, 0xe3, 0xd9, 0x3e, 0x33, 0x9b, 0xee,
		0x77, 0xba, 0xe9, 0x42, 0x73, 0x77, 0x05, 0x62, 0x01, 0x62, 0x01, 0x62, 0x01, 0x62, 0x01, 0x62,
		0x01, 0x62, 0x01, 0x62, 0x01, 0x62, 0x91, 0x44, 0x2c, 0xbc, 0xd5, 0x31, 0x07, 0xda, 0x8a, 0x7c,
		0xbc, 0x50, 0xf4, 0xd6, 0xc0, 0x2e, 0xc0, 0x2e, 0xc0, 0x2e, 0xc0, 0x2e, 0xc0, 0x2e, 0xc0, 0x2e,
		0xc0, 0x2e, 0xc0, 0x2e, 0xb2, 0xd8, 0xc5, 0xe5, 0x84, 0xe5, 0x42, 0x53, 0xbb, 0x01, 0xa1, 0x00,
		0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x00, 0xa1, 0x48, 0x22, 0x94,
		0xae, 0xd3, 0x64, 0x4f, 0xb6, 0x43, 0xe8, 0x54, 0x99, 0xd9, 0x11, 0x48, 0x05, 0x48, 0x05, 0x48,
		0x05, 0x48, 0x05, 0x48, 0x05, 0x48, 0x05, 0x48, 0x05, 0x48, 0x45, 0x1a, 0xa9, 0xb0, 0x1f, 0x1d,
		0xd6, 0xe0, 0xac, 0x69, 0x4e, 0x4c, 0xfd, 0xa1, 0x43, 0x2d, 0x0b, 0x76, 0x07, 0x82, 0x01, 0x82,
		0x01, 0x82, 0x01, 0x82, 0x01, 0x82, 0x01, 0x82, 0x01, 0x82, 0x01, 0x82, 0x91, 0x46, 0x30, 0x7e,
		0xb7, 0xd3, 0x71, 0xbd, 0x3e, 0xc8, 0xf0, 0xd8, 0xff, 0xba, 0xcc, 0xe7, 0x84, 0xf8, 0x25, 0x72,
		0x6f, 0xa0, 0x17, 0xa0, 0x17, 0xa0, 0x17, 0xa0, 0x17, 0xa0, 0x17, 0xa0, 0x17, 0xa0, 0x17, 0xa0,
		0x17, 0xe1, 0x15, 0x82, 0xb4, 0x9a, 0xab, 0x3a, 0x8e, 0xcb, 0xad, 0xfe, 0x9b, 0x96, 0x22, 0xcf,
		0x9c, 0xdf, 0x78, 0x61, 0x6d, 0xab, 0x63, 0xf1, 0x97, 0xbe, 0x04, 0xde, 0x75, 0x3b, 0xcc, 0x69,
		0x04, 0x68, 0x22, 0xd4, 0x43, 0xbb, 0x0d, 0xb7, 0xdd, 0x71, 0x1d, 0xe6, 0x70, 0x7f, 0xfc, 0xeb,
		0xae, 0xcf, 0x2d, 0xce, 0x76, 0x3b, 0x0d, 0x9b, 0xed, 0x3a, 0xae, 0x63, 0x3e, 0x59, 0x4a, 0xe9,
		0x32, 0x39, 0x9f, 0x7b, 0xdd, 0x06, 0x77, 0x86, 0x8a, 0xe0, 0x32, 0xbc, 0x8b, 0xab, 0xe1, 0x4d,
		0x3c, 0x1c, 0x87, 0x37, 0x31, 0xfe, 0xf5, 0xe1, 0xa6, 0x7f, 0x13, 0x0f, 0x57, 0x0d, 0x9b, 0x3d,
		0x5c, 0xb8, 0xce, 0xd7, 0xfe, 0x3d, 0xd4, 0x06, 0xb7, 0xf0, 0x49, 0xcf, 0x1b, 0x8a, 0xf7, 0xcd,
		0x98, 0xef, 0x50, 0xf6, 0xdd, 0x11, 0xbc, 0x33, 0x81, 0x57, 0xa4, 0xfc, 0x6a, 0xe2, 0xbd, 0x8b,
		0xe5, 0x27, 0x1b, 0xe3, 0x54, 0x73, 0x1e, 0x6b, 0x76, 0x9d, 0xa6, 0xe5, 0x70, 0xd3, 0x73, 0x5b,
		0xf1, 0x51, 0xc9, 0x44, 0x47, 0x80, 0xa9, 0xf5, 0x31, 0xdf, 0xa3, 0x18, 0x7a, 0x17, 0x46, 0xeb,
		0x32, 0xe8, 0x5c, 0x11, 0x8d, 0xcb, 0xa2, 0x6f, 0x65, 0xb4, 0xad, 0x8c, 0xae, 0xd5, 0xd1, 0x34,
		0x2d, 0x8f, 0x0b, 0xa3, 0xe3, 0xa9, 0x71, 0xfb, 0x01, 0x2f, 0x99, 0x52, 0x54, 0x39, 0x49, 0x99,
		0xc5, 0x7d, 0x81, 0x35, 0x35, 0xa7, 0xdb, 0xee, 0xdf, 0x71, 0x2f, 0x51, 0xbe, 0x6d, 0xbb, 0xaf,
		0xd6, 0xa3, 0x1c, 0xcb, 0x8e, 0x96, 0x82, 0x5b, 0xc1, 0xad, 0x2b, 0xe3, 0xd6, 0x47, 0xd7, 0x6d,
		0x31, 0xcb, 0x91, 0x61, 0xce, 0x62, 0x82, 0x8c, 0xe6, 0x33, 0xcf, 0xb6, 0x5a, 0xa6, 0xe3, 0x8a,
		0x33, 0xda, 0x78, 0x29, 0x18, 0x0d, 0x8c, 0xb6, 0x32, 0x46, 0xf3, 0xb9, 0x67, 0x3b, 0xcf, 0x32,
		0x7c, 0xf6, 0x39, 0x49, 0x3e, 0x73, 0x9f, 0xf8, 0x77, 0xcb, 0x63, 0xe6, 0x2b, 0xf3, 0x7c, 0x11,
		0x80, 0x3f, 0x7e, 0xce, 0x8f, 0x3b, 0x80, 0xeb, 0xc0, 0x75, 0xe0, 0xba, 0x85, 0xd7, 0xe4, 0xac,
		0xdd, 0x61, 0x9e, 0xc5, 0xbb, 0x9e, 0x04, 0x90, 0x9c, 0x5c, 0x2c, 0xc6, 0x6b, 0x45, 0xf0, 0x1a,
		0x78, 0xed, 0xe3, 0xed, 0x9c, 0xd8, 0x9e, 0xd8, 0x8b, 0xb3, 0x5a, 0x96, 0xd7, 0x36, 0x7d, 0xf6,
		0xca, 0x3c, 0x9b, 0xbf, 0x89, 0xbf, 0x81, 0xd1, 0x8b, 0xff, 0xb0, 0x8f, 0xe0, 0x29, 0xca, 0x45,
		0x22, 0xa5, 0x23, 0x90, 0x2a, 0x91, 0x47, 0xa2, 0x88, 0xa3, 0x6a, 0xa4, 0x91, 0x2c, 0xc2, 0x48,
		0x16, 0x59, 0xa4, 0x8b, 0x28, 0xea, 0xf5, 0x5d, 0x4b, 0x47, 0x0e, 0xc7, 0x43, 0xdd, 0x9a, 0xcc,
		0xe1, 0x36, 0x7f, 0xf3, 0xd8, 0x93, 0xcc, 0x9b, 0x1f, 0xc9, 0x6f, 0x89, 0xa0, 0x4b, 0xee, 0x74,
		0x78, 0xe9, 0x2f, 0x96, 0xcf, 0xd4, 0x53, 0x0a, 0x2e, 0xaf, 0x6a, 0x17, 0xc7, 0x97, 0x17, 0x5f,
		0x4f, 0x7f, 0x7d, 0xa8, 0x9e, 0x55, 0xaf, 0xcf, 0x1f, 0x6e, 0x6a, 0xbf, 0xd7, 0xae, 0x4f, 0x6f,
		0xff, 0x90, 0xa5, 0xa5, 0x20, 0xc4, 0xe4, 0x2b, 0x05, 0x31, 0x15, 0x03, 0xef, 0xa3, 0x47, 0x3b,
		0xbe, 0x3e, 0xbd, 0x3d, 0x3d, 0xae, 0x9e, 0x29, 0xc4, 0xb3, 0xb7, 0x57, 0xfd, 0x0c, 0xe7, 0xd5,
		0xff, 0x7b, 0x79, 0x9d, 0xe5, 0x07, 0xf8, 0x77, 0xf5, 0xfa, 0xe2, 0xf4, 0xe2, 0xd7, 0x2c, 0x3f,
		0xc2, 0xb7, 0x8b, 0xdf, 0x2e, 0x2e, 0xff, 0x7d, 0x91, 0x69, 0x32, 0x3a, 0xbd, 0x50, 0x22, 0x23,
		0xa9, 0x95, 0x75, 0xdd, 0x52, 0xff, 0x93, 0x86, 0x17, 0x30, 0x42, 0x31, 0xdc, 0xe2, 0x5d, 0x5f,
		0x19, 0x0b, 0x0d, 0x76, 0x01, 0x12, 0x02, 0x12, 0x5a, 0x5b, 0x24, 0x24, 0xee, 0x7f, 0x9e, 0x41,
		0x41, 0xc5, 0xd4, 0xb0, 0x3d, 0x7f, 0xf1, 0x98, 0xff, 0xe2, 0xb6, 0x9a, 0xaa, 0x9c, 0x3f, 0xde,
		0x08, 0xcc, 0x0f, 0xe6, 0x5f, 0x5b, 0xe6, 0xef, 0xda, 0x0e, 0xdf, 0x2b, 0x29, 0xf0, 0xfe, 0x81,
		0xc4, 0x52, 0xb5, 0x2c, 0x49, 0x85, 0x74, 0x51, 0x8a, 0xac, 0x48, 0xaa, 0x6c, 0x48, 0xf2, 0x3c,
		0x3b, 0xba, 0xfc, 0x3a, 0x05, 0xb8, 0x4b, 0x92, 0xed, 0x18, 0x1e, 0xf1, 0x7e, 0xe9, 0x70, 0xff,
		0xb0, 0x72, 0x50, 0x3a, 0x2c, 0xaf, 0xef, 0x59, 0x27, 0x94, 0x4b, 0x58, 0x4f, 0x83, 0x8a, 0x7e,
		0x7d, 0x56, 0x50, 0xcb, 0xaf, 0xcf, 0x1b, 0xa6, 0x8a, 0x4d, 0xfe, 0xd6, 0x61, 0x3e, 0x14, 0xf2,
		0x02, 0x85, 0x3c, 0x3c, 0xa2, 0xb5, 0x53, 0xcb, 0x4d, 0xd6, 0xb0, 0xdb, 0x56, 0x4b, 0xaa, 0x9e,
		0x21, 0x44, 0xe5, 0x25, 0x89, 0xb5, 0x33, 0x82, 0xb2, 0xb8, 0xb1, 0xfa, 0xfd, 0xb0, 0x54, 0xda,
		0xdb, 0x3b, 0x28, 0x15, 0xf6, 0x2a, 0x9f, 0xcb, 0xfb, 0x07, 0x07, 0xe5, 0xcf, 0x85, 0xcf, 0xd4,
		0x5a, 0xa8, 0x48, 0xa7, 0x85, 0xfa, 0xbc, 0x95, 0x7d, 0x85, 0x3f, 0x7b, 0xe6, 0x07, 0x29, 0x3e,
		0x73, 0x68, 0xfe, 0xb8, 0x87, 0x66, 0x3b, 0x3e, 0xb7, 0x02, 0xe9, 0x2d, 0xa9, 0xfd, 0x47, 0x1b,
		0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x64, 0x0a,
		0x01, 0x70, 0xe6, 0xbd, 0x5a, 0x2d, 0x15, 0x08, 0x30, 0xdc, 0x61, 0x33, 0x30, 0x00, 0x54, 0x7f,
		0x94, 0xea, 0x5f, 0x53, 0x8d, 0xef, 0x73, 0x8b, 0x9b, 0x92, 0x44, 0x6e, 0xa8, 0xf5, 0x2f, 0xc8,
		0x7d, 0x73, 0x06, 0xa2, 0x31, 0xe7, 0x58, 0x8e, 0xeb, 0xb3, 0x86, 0xeb, 0x34, 0xa5, 0x68, 0x0f,
		0x9e, 0x7d, 0x78, 0xf6, 0x63, 0x1d, 0x31, 0x7d, 0xff, 0x02, 0xf8, 0xf8, 0x53, 0xa1, 0xe7, 0xdb,
		0x12, 0x54, 0x12, 0x8a, 0xc0, 0xfe, 0x62, 0x58, 0xf8, 0x50, 0xf3, 0xb0, 0xf0, 0x61, 0xe1, 0xc3,
		0xc2, 0x87, 0x85, 0x0f, 0x0b, 0x3f, 0x5b, 0x9a, 0xdf, 0xe4, 0x76, 0x9b, 0x29, 0xa9, 0xff, 0xc1,
		0x0e, 0xb0, 0xf0, 0x61, 0xe1, 0xaf, 0xa1, 0xc6, 0xef, 0xd3, 0x36, 0xb7, 0x1b, 0x7f, 0xf9, 0x4a,
		0x3a, 0x1f, 0xf6, 0x3d, 0xec, 0x7b, 0xd8, 0xf7, 0xb0, 0xef, 0x57, 0xa4, 0xe5, 0x25, 0x18, 0x71,
		0xac, 0xe0, 0x6d, 0x07, 0xf6, 0x3d, 0x94, 0x3c, 0xec, 0x7b, 0xd8, 0xf7, 0xb0, 0xef, 0x61, 0xdf,
		0xc3, 0xbe, 0xcf, 0x98, 0xe6, 0x57, 0xb5, 0xef, 0x47, 0x3b, 0xc0, 0xbe, 0x87, 0x7d, 0x0f, 0xfb,
		0x1e, 0xf6, 0x3d, 0xec, 0x7b, 0xd8, 0xf7, 0xb0, 0xef, 0xf5, 0x6b, 0xf9, 0x35, 0xe8, 0x3d, 0x2f,
		0xde, 0x63, 0xcf, 0x50, 0x6d, 0x41, 0x7f, 0x3b, 0x71, 0xc9, 0x24, 0x5b, 0x11, 0x8a, 0xe8, 0xa1,
		0xb1, 0xee, 0xe9, 0xaf, 0x42, 0xa3, 0x4f, 0x34, 0x1f, 0x54, 0xe4, 0x6e, 0xf9, 0x46, 0x9f, 0x5d,
		0x27, 0x7e, 0xaf, 0xd9, 0x29, 0x1f, 0xc7, 0xa1, 0xc0, 0x9a, 0xe1, 0xed, 0x89, 0xe1, 0x13, 0xb4,
		0x89, 0x9b, 0x6a, 0x13, 0xf7, 0xaf, 0xea, 0xf5, 0xc9, 0xbf, 0xab, 0xd7, 0xb5, 0x87, 0xe3, 0xcb,
		0xf3, 0xab, 0xcb, 0x8b, 0xda, 0xc5, 0x6d, 0xf6, 0x5b, 0xc5, 0x7d, 0xa9, 0x1e, 0xff, 0x76, 0x75,
		0x56, 0xbd, 0xa8, 0x65, 0xb9, 0xc9, 0xd7, 0xd7, 0xea, 0x97, 0xeb, 0xd3, 0xe3, 0x2c, 0x3f, 0xc1,
		0xd5, 0xe5, 0xbf, 0x6b, 0xd7, 0x0f, 0x37, 0xdf, 0xae, 0xae, 0xce, 0xfe, 0xc8, 0xf2, 0x73, 0x9c,
		0x5e, 0xdc, 0xd6, 0x7e, 0xbd, 0xae, 0xde, 0xd6, 0x4e, 0x1e, 0x8e, 0x4f, 0xaf, 0x8f, 0xbf, 0x9d,
		0xde, 0x66, 0xf9, 0x69, 0x8e, 0xaf, 0xbe, 0x65, 0x9a, 0x2d, 0xae, 0x33, 0x7d, 0xfb, 0xc7, 0x97,
		0x17, 0xb7, 0xd7, 0x97, 0x67, 0x67, 0xb5, 0xeb, 0x87, 0xe3, 0xea, 0xf5, 0x49, 0xb6, 0x05, 0xd4,
		0x45, 0xb6, 0xa5, 0xd3, 0x75, 0xa6, 0xf9, 0xf8, 0xe6, 0xf6, 0xf2, 0xba, 0xfa, 0x6b, 0xa6, 0x55,
		0xdc, 0xf1, 0xbf, 0xaa, 0x37, 0x37, 0xa7, 0x37, 0x59, 0x7e, 0x84, 0xdb, 0xeb, 0xea, 0xc5, 0xcd,
		0x71, 0xed, 0xf4, 0xf7, 0x5a, 0xa6, 0xfb, 0xba, 0x9e, 0x9d, 0x5e, 0xd4, 0xb2, 0x2e, 0x8f, 0x6e,
		0x6a, 0x17, 0x37, 0x6b, 0xd8, 0x16, 0x75, 0x1b, 0xd6, 0x8d, 0xbc, 0x75, 0x73, 0x73, 0xf9, 0xf5,
		0x76, 0xdd, 0xac, 0x9b, 0xcb, 0xab, 0xda, 0x75, 0xf5, 0xf6, 0xf4, 0xe2, 0xd7, 0x87, 0x9b, 0x3f,
		0x6e, 0x6e, 0x6b, 0xe7, 0x59, 0xe6, 0xd9, 0x8f, 0xcf, 0xf2, 0xf0, 0xed, 0xea, 0xa4, 0x7a, 0x9b,
		0x69, 0xa5, 0x16, 0x92, 0xdc, 0xf9, 0xe5, 0xc9, 0xb7, 0xb3, 0x4c, 0x3f, 0xca, 0x97, 0xcb, 0xcb,
		0xdb, 0x87, 0xb3, 0xcb, 0xea, 0x49, 0xb6, 0x95, 0xdb, 0x97, 0xd3, 0xcb, 0x9b, 0xcd, 0xed, 0x96,
		0x5d, 0x4f, 0xd0, 0x5b, 0xdd, 0xf5, 0x59, 0xd3, 0xec, 0xb8, 0xdf, 0x99, 0x27, 0xee, 0xb3, 0x9e,
		0x58, 0x0b, 0xcf, 0x35, 0x3c, 0xd7, 0x6a, 0xd2, 0x44, 0xc5, 0x73, 0x2d, 0xda, 0x04, 0x57, 0xa2,
		0xf9, 0xad, 0x64, 0x68, 0x5d, 0x02, 0xdc, 0xa9, 0x84, 0xd2, 0x55, 0x43, 0xe8, 0x64, 0x41, 0x5c,
		0xf5, 0xe0, 0xad, 0x84, 0x12, 0x52, 0x0a, 0x91, 0x93, 0x35, 0xad, 0x4d, 0xd3, 0x19, 0xa6, 0x5d,
		0x41, 0x7d, 0x52, 0xa0, 0x80, 0x5c, 0xb5, 0xfb, 0xdc, 0x17, 0x5f, 0xac, 0x19, 0x8b, 0x2b, 0x05,
		0x75, 0xdb, 0xee, 0x84, 0x44, 0x3c, 0x9a, 0x88, 0x6b, 0xcf, 0xfd, 0x78, 0xea, 0xd3, 0x20, 0xde,
		0x1d, 0x57, 0x21, 0x9e, 0x30, 0xbf, 0xe1, 0xd9, 0x9d, 0x61, 0x34, 0x3e, 0x57, 0x6d, 0x36, 0x7d,
		0xc3, 0xef, 0xb0, 0x86, 0xfd, 0x64, 0x37, 0x8c, 0xa0, 0x93, 0xbd, 0x6f, 0x78, 0xac, 0x65, 0x71,
		0xd6, 0x34, 0xb8, 0x6b, 0x58, 0x46, 0x78, 0xcd, 0x9d, 0x35, 0x19, 0x55, 0x37, 0x78, 0xc8, 0x8d,
		0xd4, 0xb8, 0xc3, 0x47, 0xcf, 0xca, 0x98, 0x3a, 0xf6, 0xbf, 0xae, 0xdd, 0xe9, 0xdf, 0xbe, 0xf9,
		0x64, 0xd9, 0x2d, 0x91, 0x49, 0x8b, 0x33, 0xef, 0x7d, 0x76, 0x2b, 0xc1, 0x93, 0xfc, 0xc0, 0x37,
		0xa7, 0x4f, 0x83, 0xd7, 0x61, 0xf0, 0x17, 0x66, 0xbc, 0x58, 0x5e, 0xf3, 0xbb, 0xe5, 0x31, 0xc3,
		0x76, 0x9a, 0x76, 0xc3, 0xe2, 0xcc, 0x37, 0xf8, 0x8b, 0xc5, 0x83, 0xbf, 0x85, 0xec, 0xf3, 0xff,
		0xf8, 0x46, 0xe7, 0xe5, 0xcd, 0xb7, 0x1b, 0x56, 0xcb, 0x08, 0xef, 0xe6, 0xde, 0x79, 0xb1, 0x7c,
		0xa3, 0x7f, 0x4b, 0xac, 0x29, 0x7e, 0x47, 0x4f, 0x56, 0xb7, 0xc5, 0xa5, 0xdc, 0x0d, 0xb9, 0x40,
		0xbc, 0x8b, 0x19, 0x3c, 0xf5, 0xcd, 0x48, 0xc2, 0x15, 0x16, 0x0f, 0xaa, 0x62, 0x82, 0x4c, 0x5c,
		0x90, 0x89, 0x0d, 0x2a, 0xf1, 0x91, 0x88, 0x37, 0x13, 0x03, 0x6d, 0x66, 0xc5, 0x65, 0xdb, 0xf6,
		0xdb, 0x16, 0x6f, 0xbc, 0x50, 0xc8, 0xcb, 0x70, 0xaf, 0xa4, 0x05, 0xa6, 0x61, 0x3b, 0x3e, 0xf3,
		0xfa, 0x38, 0xc4, 0x76, 0xb8, 0xdb, 0xff, 0xdb, 0xbd, 0x63, 0x3d, 0x3d, 0xb1, 0x46, 0xff, 0xa3,
		0xb9, 0x62, 0xb5, 0xe5, 0x36, 0x82, 0x34, 0x43, 0xc3, 0xf6, 0x0d, 0xf7, 0xc9, 0xb0, 0x8c, 0xa6,
		0xfd, 0xf4, 0xc4, 0xbc, 0xfe, 0x5e, 0xfc, 0xad, 0xc3, 0xfa, 0xd7, 0x70, 0x8c, 0xef, 0x2f, 0x16,
		0xbf, 0x77, 0x6c, 0xdf, 0x18, 0xe4, 0xf5, 0x75, 0x3d, 0x48, 0x5e, 0x48, 0x5e, 0x48, 0x5e, 0x48,
		0x5e, 0x39, 0xec, 0xab, 0x68, 0x72, 0xd6, 0x97, 0x99, 0x9c, 0x62, 0xb9, 0xd3, 0x6a, 0x39, 0xd3,
		0x31, 0x5e, 0x83, 0x4a, 0x7e, 0xf4, 0x62, 0xf2, 0x8d, 0x3e, 0xa7, 0x05, 0x64, 0x99, 0xf3, 0xb9,
		0xeb, 0x59, 0xcf, 0xcb, 0xa9, 0x70, 0xa2, 0x69, 0xe6, 0x60, 0xc1, 0x92, 0x73, 0x8f, 0x67, 0xc3,
		0xc6, 0x16, 0x99, 0x22, 0x22, 0x52, 0xd2, 0x3f, 0x2c, 0x2a, 0x04, 0xa5, 0x85, 0x9e, 0xb4, 0x90,
		0x93, 0xf7, 0xff, 0xaa, 0xb9, 0x6d, 0xe2, 0xda, 0x9d, 0xb9, 0xc6, 0xe8, 0x6d, 0x0a, 0xba, 0x6e,
		0x86, 0xeb, 0x30, 0xc9, 0x1f, 0x21, 0x09, 0x45, 0x17, 0x49, 0xf2, 0xa5, 0x32, 0x81, 0x34, 0xdc,
		0x15, 0xa2, 0x60, 0x25, 0x3d, 0x10, 0x5c, 0xef, 0x61, 0x48, 0xd4, 0x09, 0x86, 0x1d, 0x07, 0x0a,
		0x4e, 0x98, 0xb5, 0x85, 0x7c, 0xab, 0xb2, 0x9c, 0x5d, 0x02, 0x67, 0x83, 0xb3, 0x35, 0x71, 0xb6,
		0x08, 0x01, 0x13, 0x30, 0x76, 0x0c, 0xa0, 0x47, 0x05, 0x9d, 0x7b, 0xa9, 0x81, 0xce, 0x71, 0x10,
		0xa5, 0xfa, 0xd9, 0x6a, 0x81, 0xcf, 0xdd, 0xc7, 0xf1, 0x33, 0x09, 0x80, 0xe8, 0xa9, 0x65, 0x80,
		0xd2, 0x80, 0xd2, 0x8b, 0x08, 0x4b, 0x42, 0xeb, 0x4e, 0xae, 0x06, 0xac, 0x86, 0xf2, 0x55, 0x54,
		0xbe, 0xc2, 0x91, 0x47, 0x41, 0x4b, 0x50, 0xcd, 0x22, 0x94, 0x24, 0xe1, 0xd4, 0xf8, 0x6d, 0x31,
		0x09, 0x9e, 0x94, 0xf4, 0x93, 0xf1, 0xdd, 0x8a, 0xb2, 0x44, 0xb8, 0x70, 0x88, 0x5e, 0x14, 0xf3,
		0xef, 0x83, 0x5d, 0x24, 0x4f, 0x58, 0x2e, 0xbc, 0xa1, 0xcc, 0x2e, 0x14, 0x6c, 0x43, 0xcc, 0x3e,
		0x54, 0x6c, 0x44, 0xce, 0x4e, 0xe4, 0x6c, 0x45, 0xcf, 0x5e, 0x72, 0x6c, 0x26, 0xc9, 0x6e, 0xe1,
		0xed, 0x4b, 0x87, 0x4c, 0x66, 0x28, 0xa7, 0xc5, 0xac, 0x27, 0xb9, 0x32, 0x9c, 0x19, 0x7d, 0xa3,
		0xd0, 0x6e, 0x2f, 0x77, 0x35, 0xb4, 0x97, 0x76, 0x76, 0x76, 0x27, 0xff, 0x37, 0x36, 0x8f, 0x06,
		0xaa, 0x70, 0x37, 0x60, 0xf8, 0x84, 0xda, 0xe2, 0xe8, 0x95, 0x9c, 0x92, 0x96, 0xbc, 0xba, 0x9d,
		0x39, 0x69, 0x74, 0x4d, 0xfd, 0x6b, 0x57, 0x0a, 0x6e, 0xa8, 0x58, 0xa4, 0x93, 0xb7, 0x32, 0xf5,
		0x2f, 0x21, 0xcf, 0x9e, 0xf8, 0xfb, 0x12, 0x49, 0x87, 0x90, 0x52, 0x54, 0x2a, 0x0a, 0x2a, 0xeb,
		0xad, 0x87, 0x81, 0xdf, 0x32, 0x84, 0xdf, 0xd4, 0x63, 0xef, 0xf2, 0x0a, 0x44, 0x45, 0x71, 0x4c,
		0x2a, 0x0c, 0x69, 0xd5, 0xa0, 0x47, 0x60, 0x88, 0x85, 0x08, 0x66, 0x9d, 0x16, 0x82, 0x9e, 0x56,
		0x12, 0x93, 0xaf, 0x04, 0x91, 0x01, 0x91, 0x01, 0x93, 0x0f, 0x26, 0x1f, 0x4c, 0x3e, 0x98, 0x7c,
		0x30, 0xf9, 0x36, 0xc7, 0xe4, 0x93, 0x41, 0x1b, 0x7a, 0x2c, 0x3e, 0x81, 0x90, 0xaf, 0x04, 0x7e,
		0x23, 0x8d, 0x03, 0xfc, 0xc6, 0xde, 0x04, 0x35, 0x51, 0xee, 0xcc, 0xf6, 0x79, 0x95, 0x73, 0xc1,
		0xf8, 0xc1, 0xb9, 0xed, 0xd4, 0x5a, 0xac, 0x3d, 0x8c, 0xaa, 0x0a, 0x68, 0x9d, 0xdc, 0xb9, 0xf5,
		0x63, 0x62, 0xa5, 0x5a, 0xd7, 0xe4, 0xdc, 0xa5, 0xd7, 0x64, 0x1e, 0x6b, 0x7e, 0xe9, 0x3f, 0xb5,
		0xd3, 0x6d, 0xb5, 0xb2, 0x9d, 0xd1, 0x10, 0xc9, 0x0c, 0x09, 0xa4, 0x37, 0x44, 0x92, 0xff, 0x86,
		0xe5, 0x3a, 0x08, 0x04, 0xfe, 0xa9, 0x8e, 0x5b, 0x3a, 0xef, 0xe1, 0x93, 0xc0, 0x49, 0xc6, 0x10,
		0x0d, 0xf1, 0x44, 0x41, 0x7c, 0xd6, 0x57, 0x62, 0xf5, 0x78, 0xac, 0x1d, 0xf5, 0xb0, 0x31, 0xc9,
		0x45, 0x96, 0x4c, 0x72, 0x0b, 0x13, 0xb6, 0x25, 0x08, 0x62, 0x3e, 0x09, 0xcc, 0xbe, 0xe0, 0xe9,
		0x4f, 0x3e, 0x3c, 0xfd, 0xb2, 0xa7, 0x16, 0x7b, 0xda, 0x39, 0xcf, 0x28, 0xf2, 0x6c, 0xd3, 0x4f,
		0x34, 0xbe, 0xef, 0x89, 0x7b, 0xce, 0xb5, 0x99, 0xef, 0x5b, 0xcf, 0x6c, 0x36, 0x2f, 0x67, 0x3c,
		0x1f, 0x65, 0xf4, 0x8d, 0x0f, 0x4f, 0x3a, 0xdf, 0xab, 0x10, 0x69, 0x06, 0x2d, 0x32, 0x6f, 0x26,
		0xcd, 0x96, 0x88, 0xcb, 0xc5, 0x31, 0x47, 0x62, 0x9b, 0x19, 0xb1, 0xcd, 0x87, 0x8f, 0x66, 0x41,
		0x78, 0x73, 0x82, 0x54, 0x11, 0x65, 0x15, 0x2f, 0xcb, 0x01, 0x88, 0x17, 0xeb, 0x5f, 0xe2, 0xe0,
		0x59, 0x6a, 0x99, 0xc6, 0xb1, 0x3c, 0x63, 0xbe, 0x22, 0x51, 0xcb, 0x51, 0xd8, 0x32, 0x14, 0xb6,
		0xfc, 0xe2, 0xbf, 0x42, 0x39, 0x99, 0xbe, 0xcc, 0xe1, 0x91, 0xf3, 0xd9, 0x2b, 0xf3, 0x6c, 0xfe,
		0x26, 0x90, 0xf9, 0x36, 0x5a, 0x11, 0x2f, 0xe9, 0xad, 0xb0, 0xe2, 0xa4, 0xb7, 0x18, 0xe4, 0x20,
		0xeb, 0x50, 0x58, 0x7d, 0xd2, 0xdb, 0x72, 0x72, 0xa1, 0x01, 0x57, 0xb1, 0x0d, 0xf8, 0x31, 0x95,
		0xbc, 0xf9, 0x2d, 0xf7, 0xd9, 0x8c, 0x49, 0x2c, 0x53, 0x72, 0x62, 0x3f, 0xc6, 0x77, 0x6b, 0x4e,
		0xb7, 0xdd, 0xbf, 0xa1, 0x5e, 0x22, 0xc8, 0x48, 0x1d, 0x2c, 0x8c, 0x5e, 0xd4, 0x6e, 0xf8, 0xcb,
		0xd2, 0x80, 0x65, 0xa4, 0x2e, 0x3d, 0x1f, 0x6e, 0xf1, 0x10, 0xfe, 0xb2, 0x28, 0xe2, 0x38, 0x07,
		0x22, 0xcc, 0xd1, 0x5d, 0x4d, 0xf6, 0xd8, 0x7d, 0x36, 0x99, 0xc3, 0x3d, 0x9b, 0xf9, 0xcb, 0x05,
		0xfe, 0xf4, 0xd7, 0x21, 0xf7, 0xb3, 0x27, 0xf7, 0x07, 0x6f, 0xd0, 0x67, 0xde, 0xab, 0xdd, 0x10,
		0xa8, 0x1d, 0x9c, 0x5e, 0x96, 0x8d, 0xb4, 0x67, 0x68, 0x00, 0x02, 0x0d, 0x80, 0x0a, 0x42, 0x4d,
		0x24, 0xa7, 0x1a, 0xcd, 0x48, 0x5f, 0xaa, 0x73, 0x7c, 0x92, 0xd4, 0xe3, 0xe2, 0x14, 0x6f, 0xb2,
		0xe4, 0x58, 0x8f, 0xad, 0xa0, 0xa5, 0x99, 0x6c, 0xab, 0x90, 0xe1, 0x06, 0x68, 0xa2, 0x91, 0x86,
		0x64, 0x1e, 0x09, 0xe6, 0x53, 0x65, 0x42, 0x32, 0x66, 0x24, 0x63, 0x4a, 0x3a, 0xe6, 0x4c, 0x26,
		0xbe, 0x84, 0x16, 0x46, 0xa1, 0x41, 0x1e, 0x0f, 0x92, 0x2d, 0xb0, 0xcf, 0xe3, 0x80, 0x33, 0x30,
		0x3b, 0x98, 0x3d, 0xc3, 0xcc, 0xbe, 0x36, 0x53, 0x18, 0x4e, 0x6a, 0x5f, 0xbe, 0xfd, 0xfa, 0x70,
		0x53, 0xbb, 0xfe, 0xfd, 0xf4, 0xb8, 0x96, 0x4b, 0x4d, 0xb7, 0xd9, 0xb4, 0x57, 0x7e, 0xcf, 0xfa,
		0x53, 0xa6, 0x5c, 0x12, 0xbb, 0x53, 0x76, 0x2a, 0x61, 0x6f, 0x87, 0x59, 0xdf, 0xcb, 0x49, 0xff,
		0x4a, 0xb5, 0xc1, 0x65, 0x07, 0xff, 0xb8, 0x19, 0x5c, 0x75, 0x15, 0x1d, 0x1e, 0x04, 0x75, 0x87,
		0xa4, 0xce, 0x48, 0x7b, 0x4b, 0x79, 0x58, 0x5f, 0x2b, 0xb4, 0xbe, 0xe4, 0x5b, 0xca, 0x8b, 0xe7,
		0x76, 0xc9, 0xe4, 0x72, 0xcd, 0xc9, 0xbe, 0x1e, 0x51, 0x3f, 0x7a, 0xb1, 0x24, 0xd9, 0x8b, 0x05,
		0x5c, 0x0a, 0x1f, 0x09, 0x7c, 0x24, 0x30, 0x9b, 0x60, 0x36, 0xc1, 0x47, 0x02, 0x1f, 0x09, 0x98,
		0x1d, 0xcc, 0x0e, 0x1f, 0x09, 0x7c, 0x24, 0x2b, 0xf3, 0x91, 0x90, 0x75, 0xc9, 0x13, 0x71, 0x91,
		0xa4, 0xa8, 0x57, 0xde, 0x30, 0xfb, 0x39, 0x66, 0x6a, 0x83, 0x50, 0x4d, 0x84, 0x78, 0x2d, 0x04,
		0x49, 0x0d, 0x84, 0x58, 0xed, 0x43, 0x72, 0xf9, 0xf5, 0x42, 0x74, 0xa9, 0x92, 0x61, 0x2f, 0x40,
		0x89, 0xb9, 0xcc, 0xe6, 0x91, 0xc5, 0x49, 0xc5, 0x52, 0x38, 0x25, 0x95, 0xa4, 0xb2, 0xc5, 0x4e,
		0x8e, 0x58, 0x4e, 0x8d, 0xd8, 0x49, 0x64, 0x25, 0x24, 0x91, 0x25, 0x9f, 0x44, 0x36, 0xbc, 0x60,
		0xfc, 0xf4, 0xb1, 0xd1, 0x02, 0xe2, 0xc4, 0xb1, 0x12, 0x12, 0xc7, 0x34, 0xe2, 0xde, 0x84, 0x12,
		0xc7, 0xac, 0x4e, 0xc7, 0x14, 0x2a, 0xb3, 0x0f, 0x5f, 0x55, 0xb8, 0x12, 0xe1, 0x0b, 0x38, 0x46,
		0x57, 0x16, 0xbe, 0xf0, 0xb9, 0x67, 0x3b, 0xcf, 0x32, 0xd1, 0x8b, 0xcf, 0xa4, 0x4f, 0xc0, 0x7e,
		0x70, 0xcf, 0x32, 0xbb, 0x8e, 0xcf, 0xad, 0xc7, 0x96, 0xe0, 0xb3, 0x78, 0x2c, 0x18, 0x16, 0xd5,
		0x48, 0x64, 0xe8, 0xee, 0xe8, 0xe0, 0x4e, 0x6b, 0xb7, 0x5f, 0x8d, 0xeb, 0xaf, 0xc7, 0x46, 0x79,
		0xbf, 0xb4, 0xbf, 0x6d, 0xdc, 0xb0, 0x60, 0x92, 0xab, 0x51, 0xd9, 0x29, 0xed, 0x94, 0x77, 0x56,
		0xec, 0xb3, 0x18, 0x1f, 0x48, 0x9a, 0xdc, 0x16, 0x8b, 0x4f, 0x6c, 0x23, 0x67, 0xaa, 0xb7, 0x7d,
		0x89, 0x9c, 0xe3, 0xfe, 0x22, 0xe8, 0x0c, 0xe8, 0x8c, 0xf5, 0xd5, 0x19, 0x54, 0xbc, 0x65, 0x37,
		0xa5, 0xb8, 0xcb, 0x6e, 0x82, 0xbf, 0xc0, 0x5f, 0xc0, 0x64, 0xeb, 0x84, 0xc9, 0x0e, 0x80, 0xc9,
		0x04, 0x31, 0xd9, 0xc1, 0x86, 0x62, 0xb2, 0x8e, 0x67, 0xbb, 0xb1, 0x6a, 0xcb, 0x67, 0xc8, 0x2f,
		0x5c, 0x09, 0xed, 0x01, 0xed, 0xb1, 0x32, 0xed, 0xd1, 0xb5, 0x1d, 0xfe, 0x59, 0x42, 0x79, 0x88,
		0xf4, 0xa7, 0xba, 0xb6, 0x9c, 0xe7, 0x44, 0x24, 0xfb, 0xb9, 0xed, 0xc8, 0x4b, 0xdf, 0xdf, 0xad,
		0x56, 0x97, 0x29, 0x34, 0x8f, 0xfc, 0xea, 0x59, 0x81, 0x38, 0x3c, 0xb1, 0x9f, 0x6d, 0xd1, 0x7e,
		0x60, 0xd3, 0xaf, 0x86, 0x3d, 0x5b, 0xdc, 0x7e, 0xed, 0xdf, 0x4b, 0x90, 0xdc, 0x25, 0x2e, 0x57,
		0x25, 0x74, 0xd7, 0xb9, 0xf5, 0x43, 0xfd, 0xe8, 0x4a, 0xe5, 0x72, 0xf6, 0x0f, 0x6f, 0xb5, 0x4a,
		0x69, 0x03, 0xc1, 0x56, 0x11, 0x58, 0x4b, 0x0c, 0x6b, 0x15, 0x37, 0x15, 0x6a, 0xb9, 0x0d, 0x19,
		0x1b, 0x7d, 0xb8, 0x0e, 0x30, 0x0b, 0x30, 0x0b, 0x46, 0xfa, 0x1a, 0xe9, 0x8d, 0x0a, 0x8c, 0x74,
		0x41, 0xc5, 0x51, 0x59, 0x47, 0x23, 0x5d, 0x29, 0x72, 0x5f, 0xfb, 0x11, 0xa0, 0xcd, 0xe5, 0xe4,
		0x2c, 0x9e, 0xf2, 0xe0, 0x36, 0x4c, 0xf6, 0x83, 0x1f, 0x71, 0xd6, 0x62, 0x6d, 0xc6, 0xbd, 0x37,
		0xd3, 0xe2, 0x6e, 0xdb, 0x6e, 0xc8, 0xe5, 0x40, 0x04, 0x58, 0x56, 0x22, 0x09, 0x42, 0x35, 0xf3,
		0x61, 0x49, 0xa9, 0x88, 0x8c, 0x3c, 0x91, 0x90, 0x23, 0x12, 0x02, 0x77, 0x8a, 0x0b, 0x0c, 0xd3,
		0xb8, 0x7d, 0x61, 0xc6, 0x4d, 0xd0, 0xaf, 0xcd, 0xb8, 0xf2, 0x5c, 0xee, 0x36, 0xdc, 0x56, 0xc2,
		0x2a, 0x54, 0x56, 0x5a, 0xd0, 0x6a, 0xd1, 0x38, 0xe7, 0x42, 0xad, 0x5d, 0x3f, 0xa9, 0xc9, 0x82,
		0x55, 0x66, 0x6d, 0x06, 0x79, 0x7b, 0xbb, 0xf1, 0x52, 0xba, 0x0c, 0xb1, 0x0c, 0xc4, 0x20, 0x2f,
		0x78, 0xf4, 0x4f, 0x2d, 0x53, 0x9f, 0xd1, 0xf6, 0x52, 0x9a, 0x81, 0xd1, 0xf6, 0x72, 0x01, 0x95,
		0xa0, 0xed, 0x65, 0x0c, 0xa1, 0x41, 0x93, 0xa6, 0xbc, 0xa0, 0x78, 0x20, 0xb9, 0xbe, 0xd8, 0x33,
		0x4f, 0x28, 0xd2, 0x15, 0x7b, 0xe6, 0x99, 0xe2, 0xf4, 0xc4, 0xf6, 0xdf, 0x7c, 0xce, 0xda, 0xd1,
		0x1d, 0xb1, 0x87, 0x7f, 0x4f, 0xa6, 0x1f, 0xb6, 0xff, 0x96, 0xce, 0x56, 0xd8, 0xfd, 0xfb, 0xa2,
		0xea, 0x82, 0x6d, 0x59, 0xd6, 0xf2, 0x24, 0xf6, 0xfe, 0x97, 0xd2, 0xd1, 0x07, 0x35, 0xfa, 0x4e,
		0x8c, 0x54, 0x67, 0xaf, 0xf7, 0xef, 0x3b, 0xa9, 0xc4, 0x75, 0xab, 0xd1, 0x70, 0xbb, 0x0e, 0xb7,
		0x9d, 0xe7, 0xf8, 0x00, 0x60, 0x62, 0x4d, 0x36, 0xfa, 0x9e, 0x2e, 0x26, 0x84, 0xec, 0x6a, 0xff,
		0x85, 0x84, 0x42, 0xa3, 0xf8, 0xd1, 0xed, 0x94, 0x9e, 0xd0, 0xd6, 0xcf, 0xe5, 0x1a, 0x8b, 0x10,
		0xf5, 0x78, 0x5b, 0x85, 0xfb, 0x77, 0x8c, 0xa5, 0x97, 0xd9, 0x66, 0xfc, 0xc5, 0x55, 0xe8, 0xe4,
		0x31, 0xbb, 0xd5, 0x66, 0x94, 0xd1, 0x8b, 0x91, 0xb9, 0x0e, 0xa7, 0x6a, 0x3a, 0x2b, 0xe8, 0x85,
		0xd8, 0x40, 0xd2, 0x75, 0x9a, 0x78, 0xf1, 0x7c, 0xd7, 0xe9, 0x1b, 0x03, 0x0a, 0x65, 0xf3, 0x87,
		0x12, 0x6b, 0x87, 0xb7, 0x7d, 0x27, 0xf5, 0x5a, 0x08, 0xa6, 0x2b, 0xaa, 0x75, 0x0c, 0x98, 0x39,
		0x82, 0xb2, 0xc2, 0x1e, 0x24, 0x1d, 0x04, 0x66, 0x1e, 0xb0, 0x5a, 0xad, 0x3e, 0x9c, 0xd7, 0x6e,
		0xff, 0x75, 0x79, 0xf2, 0x70, 0xfb, 0xc7, 0x55, 0x4d, 0x75, 0xce, 0x67, 0x90, 0xdb, 0xe1, 0x4b,
		0xbf, 0x31, 0x9a, 0xb7, 0x37, 0xf7, 0x41, 0xaf, 0xab, 0x27, 0xa7, 0xdf, 0x6e, 0x1e, 0xaa, 0x67,
		0x67, 0x39, 0xe5, 0x8d, 0x7b, 0xdb, 0x69, 0x7b, 0xba, 0xdb, 0xea, 0x71, 0xf5, 0x78, 0x6d, 0x9f,
		0xee, 0xec, 0xf2, 0xb8, 0x4a, 0xf1, 0x60, 0x4a, 0x3b, 0xd4, 0xb3, 0x31, 0x5a, 0x96, 0x40, 0xe8,
		0x09, 0x87, 0x9f, 0x23, 0xe5, 0xdd, 0xe7, 0x84, 0x26, 0xbd, 0xd6, 0xb5, 0xea, 0x4e, 0xa9, 0x71,
		0x9f, 0xe1, 0x6a, 0xe9, 0xb1, 0x9f, 0xe3, 0x1d, 0x08, 0xc7, 0x7f, 0x86, 0x9b, 0x4e, 0xb6, 0xc2,
		0x50, 0xec, 0x46, 0xd3, 0xf5, 0x99, 0x27, 0x0b, 0xc1, 0x08, 0x26, 0x56, 0x4f, 0x85, 0x51, 0x07,
		0x4f, 0x65, 0x3e, 0xbe, 0xa9, 0x90, 0x2f, 0xe5, 0xb4, 0xea, 0x29, 0x6c, 0x18, 0x9c, 0x54, 0x3a,
		0xa7, 0x1f, 0xaf, 0x4d, 0x93, 0x9f, 0x81, 0xb7, 0x77, 0x77, 0xf8, 0xc3, 0xb2, 0xac, 0xdd, 0xb1,
		0x79, 0x46, 0xd8, 0xf7, 0xf8, 0x26, 0xd8, 0xff, 0x61, 0xf8, 0xa3, 0x6a, 0x59, 0x0f, 0xd5, 0xf0,
		0x32, 0x2b, 0x68, 0x74, 0xcc, 0x5e, 0x87, 0xe2, 0x41, 0xd0, 0xed, 0x32, 0x5c, 0x07, 0xb7, 0x0b,
		0xdc, 0x2e, 0xc9, 0xb8, 0x5d, 0x02, 0x82, 0x53, 0x68, 0x9a, 0xfa, 0x2a, 0x36, 0xdb, 0x59, 0x82,
		0x6c, 0xe1, 0x5e, 0x81, 0x7b, 0x45, 0x14, 0x22, 0x8a, 0xb2, 0x41, 0xb8, 0x50, 0xd0, 0x5d, 0x1e,
		0x49, 0x2e, 0xc2, 0x8a, 0x8d, 0x80, 0x41, 0x94, 0x19, 0x85, 0x82, 0x61, 0xe8, 0x18, 0x87, 0x12,
		0x93, 0x92, 0x32, 0x92, 0x16, 0x5c, 0x4a, 0xc6, 0x58, 0x2b, 0xb1, 0x72, 0xa5, 0x19, 0x6e, 0x5a,
		0x0f, 0x99, 0x5c, 0xd6, 0x2d, 0x1a, 0xad, 0x9c, 0x06, 0x7b, 0x2a, 0xbe, 0x18, 0xb9, 0x80, 0x00,
		0x39, 0x63, 0x52, 0x32, 0x28, 0x3d, 0xa3, 0x52, 0x33, 0xac, 0x36, 0xc6, 0xd5, 0xc6, 0xc0, 0x5a,
		0x18, 0x99, 0xc6, 0x5d, 0xa6, 0xe8, 0x45, 0x94, 0x0f, 0x58, 0x44, 0xd2, 0x1b, 0x8d, 0x2f, 0x7f,
		0x46, 0x67, 0x96, 0x09, 0xf6, 0x22, 0xf5, 0xed, 0xcf, 0x3c, 0x78, 0xb5, 0x5a, 0x7d, 0xa8, 0x1e,
		0x1f, 0x5f, 0x7e, 0xbb, 0xb8, 0x3d, 0xbd, 0xf8, 0xf5, 0xa1, 0xf6, 0x7b, 0xed, 0xe2, 0x96, 0xc2,
		0xdb, 0x1f, 0x5e, 0x88, 0xd0, 0xeb, 0xaf, 0xee, 0xc6, 0x14, 0x3f, 0x8a, 0xb3, 0xcb, 0x5f, 0x4f,
		0x2f, 0x72, 0x64, 0x17, 0xec, 0x6d, 0x67, 0xf2, 0x14, 0x8e, 0x2f, 0xcf, 0xcf, 0xab, 0x17, 0x27,
		0x84, 0xe7, 0x40, 0xb2, 0x53, 0x7d, 0xd5, 0x72, 0xec, 0xd3, 0x0a, 0xe8, 0x20, 0xe7, 0xb1, 0xc6,
		0x40, 0x01, 0x11, 0x21, 0x93, 0xe1, 0x7e, 0x40, 0x25, 0x40, 0x25, 0x40, 0x25, 0xa9, 0x42, 0x25,
		0xcc, 0xe9, 0xb6, 0x99, 0x37, 0xf0, 0x80, 0x13, 0xa2, 0x92, 0x7d, 0x82, 0xbd, 0xe2, 0xe5, 0xd6,
		0x6b, 0x14, 0xa0, 0x89, 0x5a, 0x94, 0x92, 0x91, 0x88, 0x99, 0x7d, 0x24, 0x23, 0x13, 0x03, 0x47,
		0xfc, 0xe0, 0xc7, 0xae, 0x92, 0x37, 0xc7, 0x90, 0x0e, 0x5b, 0xd4, 0x82, 0x7b, 0x18, 0xfc, 0x10,
		0x8a, 0x61, 0xa8, 0xbf, 0x39, 0x99, 0x2e, 0x24, 0x04, 0x26, 0x3c, 0x9d, 0xe9, 0xae, 0xa8, 0x1c,
		0xe1, 0x43, 0x83, 0x0f, 0x2d, 0x69, 0x89, 0xa7, 0xac, 0xcc, 0x14, 0x06, 0x55, 0x46, 0x2a, 0xae,
		0x03, 0x85, 0x3d, 0x66, 0x07, 0x59, 0x4e, 0xb0, 0x75, 0x8a, 0x05, 0x99, 0xd8, 0xec, 0xcb, 0xc8,
		0xb7, 0x20, 0x3a, 0xb0, 0x66, 0xee, 0xf9, 0xab, 0x8a, 0xaf, 0x12, 0xc4, 0x17, 0xc4, 0x57, 0x22,
		0xe2, 0x0b, 0x21, 0x00, 0x18, 0xdb, 0x30, 0xb6, 0x61, 0x6c, 0x0b, 0xd0, 0x1b, 0x42, 0x00, 0x08,
		0x01, 0x20, 0x04, 0x80, 0x10, 0x40, 0x62, 0x1e, 0x2c, 0x84, 0x00, 0x80, 0x4a, 0x80, 0x4a, 0x80,
		0x4a, 0x16, 0xdb, 0x0c, 0x08, 0x01, 0xa4, 0xc3, 0xa2, 0x4c, 0x53, 0x08, 0x40, 0xc5, 0x99, 0x63,
		0xd0, 0x44, 0x00, 0x04, 0x66, 0x11, 0x13, 0xf8, 0xcd, 0xb4, 0xe6, 0xe7, 0x0e, 0x67, 0x19, 0x4b,
		0x5b, 0xe7, 0xeb, 0x5f, 0x03, 0xb6, 0x74, 0x1c, 0xb2, 0xea, 0x2b, 0x50, 0x64, 0x2e, 0x0a, 0xa6,
		0xca, 0x49, 0xf9, 0x66, 0x15, 0xd9, 0x28, 0x87, 0x3a, 0xac, 0xa8, 0xb7, 0xa2, 0xbd, 0x0e, 0x6b,
		0xf0, 0x1e, 0x92, 0xac, 0xc3, 0x12, 0x73, 0xe5, 0x4b, 0xb9, 0xee, 0xa5, 0xab, 0xb0, 0x4a, 0xa8,
		0xc2, 0xa2, 0xc4, 0xbc, 0x68, 0x7e, 0x83, 0xe6, 0x37, 0xa8, 0xce, 0x42, 0xf3, 0x9b, 0x58, 0xb2,
		0x1a, 0xcd, 0x6f, 0xd0, 0xfc, 0x26, 0x71, 0xaf, 0x2f, 0x9a, 0xdf, 0xac, 0xc1, 0xd3, 0xa1, 0xf9,
		0x4d, 0xa2, 0x42, 0x0f, 0xcd, 0x6f, 0x36, 0xcc, 0xf1, 0x81, 0xe6, 0x37, 0x7a, 0x70, 0xa1, 0x81,
		0xe6, 0x37, 0x29, 0x73, 0xba, 0x88, 0xba, 0x94, 0xe5, 0x7c, 0x2e, 0x02, 0x5e, 0x63, 0xdd, 0xf3,
		0x7a, 0xe8, 0x66, 0x7d, 0x2c, 0x3a, 0x57, 0x95, 0x41, 0x1f, 0x8b, 0x4e, 0x52, 0xc7, 0x94, 0x0f,
		0xab, 0xcb, 0x5f, 0xfa, 0x48, 0xba, 0x11, 0xef, 0x54, 0xc6, 0x46, 0xfe, 0xf4, 0x3a, 0xb4, 0xfb,
		0x46, 0xbb, 0xef, 0x21, 0x41, 0x35, 0xdb, 0xb6, 0x63, 0x06, 0xa2, 0x5d, 0xd8, 0xe9, 0x39, 0xb1,
		0x16, 0xfd, 0xa7, 0xe0, 0xf9, 0x4c, 0xc6, 0xf3, 0x29, 0xd9, 0x70, 0x47, 0xad, 0xd1, 0x0e, 0x3a,
		0x50, 0xc1, 0xc7, 0x99, 0xd6, 0x0e, 0x54, 0x03, 0x29, 0xdc, 0xb1, 0x7c, 0xff, 0xbb, 0x4a, 0xbe,
		0xd9, 0x07, 0xa9, 0x1e, 0xee, 0x87, 0x6a, 0x3a, 0x94, 0xa3, 0x24, 0xcc, 0x68, 0x2b, 0x71, 0x3d,
		0x11, 0x56, 0xd3, 0xad, 0xdc, 0x05, 0x25, 0x79, 0x02, 0xb1, 0xc7, 0xa3, 0xea, 0xf1, 0x9c, 0xce,
		0x19, 0xa7, 0x3a, 0x61, 0xc1, 0xbd, 0x58, 0xfe, 0x0b, 0x6b, 0x9a, 0xaf, 0x56, 0xab, 0xcb, 0x68,
		0xa9, 0x5e, 0x60, 0xda, 0x6a, 0x2c, 0xb2, 0x4f, 0x9a, 0xe0, 0xeb, 0x89, 0xd4, 0x38, 0x4e, 0xab,
		0x85, 0xe1, 0xeb, 0xa0, 0xd6, 0x36, 0xa3, 0x6d, 0xa1, 0x74, 0xa0, 0x74, 0xa0, 0x74, 0xc4, 0xec,
		0x1a, 0xef, 0xad, 0xc3, 0xc7, 0x8c, 0xa4, 0x58, 0xc1, 0x98, 0x78, 0x10, 0xa4, 0xb7, 0x3e, 0xb9,
		0x8b, 0x53, 0xae, 0xb6, 0xdd, 0xb1, 0x93, 0x44, 0xbe, 0x2b, 0x88, 0x88, 0xfb, 0x71, 0xea, 0xea,
		0x0f, 0xd5, 0xfe, 0xd5, 0xbf, 0xf9, 0xcc, 0x93, 0x6a, 0x07, 0x22, 0xe0, 0x57, 0x17, 0xf2, 0x4a,
		0xcb, 0x54, 0xcb, 0x2b, 0x55, 0xc9, 0x2b, 0xdb, 0xef, 0x25, 0xd8, 0xef, 0xb0, 0xdf, 0x61, 0xbf,
		0x03, 0x4a, 0x01, 0x4a, 0xc1, 0x7e, 0x87, 0xfd, 0x0e, 0xfb, 0x1d, 0xf6, 0x3b, 0xec, 0x77, 0x28,
		0x1d, 0x28, 0x1d, 0xd8, 0xef, 0xaa, 0x22, 0xa9, 0x6f, 0x1a, 0x0f, 0x2d, 0x5b, 0x12, 0x59, 0x14,
		0xee, 0x07, 0x21, 0x04, 0x21, 0x04, 0x21, 0x94, 0x2d, 0xe4, 0x0b, 0xbf, 0xe1, 0x1c, 0xbf, 0xa1,
		0x6c, 0x2b, 0x01, 0x0a, 0xb7, 0xa1, 0x44, 0x0f, 0x81, 0xb5, 0xce, 0xc6, 0x8d, 0x7a, 0x49, 0x9a,
		0xd2, 0x72, 0x23, 0x5e, 0x4b, 0x92, 0x15, 0xd1, 0x82, 0x09, 0x57, 0x72, 0x89, 0x56, 0xc8, 0x0c,
		0x34, 0x90, 0x19, 0xa8, 0xe6, 0x50, 0xfd, 0x90, 0xe3, 0xac, 0x5e, 0x17, 0x3d, 0x77, 0x3b, 0xd4,
		0x46, 0xeb, 0x03, 0x8b, 0x88, 0x3b, 0xa0, 0x36, 0x5a, 0xb3, 0x9f, 0x12, 0xb5, 0xd1, 0x92, 0xdb,
		0xa2, 0x36, 0x7a, 0x35, 0x4f, 0x87, 0xda, 0x68, 0x6d, 0xe6, 0xf6, 0xe8, 0x3f, 0xd4, 0x46, 0xa7,
		0xd7, 0xbc, 0x47, 0x6d, 0xb4, 0xf0, 0xa6, 0xa8, 0x8d, 0x4e, 0xc6, 0x69, 0x88, 0xda, 0xe8, 0xb4,
		0x79, 0x63, 0x84, 0xf3, 0xeb, 0xe4, 0x3d, 0x31, 0x22, 0xd9, 0x74, 0x68, 0x4c, 0x07, 0x27, 0x0c,
		0x9c, 0x30, 0x70, 0xc2, 0xc0, 0x09, 0x03, 0x27, 0x0c, 0x9c, 0x30, 0x70, 0xc2, 0xc0, 0x09, 0x03,
		0x27, 0x0c, 0x9c, 0x30, 0x70, 0xc2, 0xc0, 0x09, 0x03, 0x27, 0x0c, 0x9c, 0x30, 0x70, 0xc2, 0xac,
		0x97, 0x13, 0x46, 0x67, 0x93, 0xba, 0x69, 0x1f, 0x0c, 0x6d, 0xa3, 0xba, 0x18, 0x2e, 0x98, 0x3e,
		0x7d, 0xf9, 0xe2, 0x2e, 0x98, 0xc1, 0x32, 0xe4, 0xc1, 0xc0, 0x05, 0x93, 0x8c, 0x0b, 0x46, 0xa8,
		0x99, 0x1b, 0x85, 0xba, 0x41, 0x77, 0x2c, 0x38, 0x58, 0xd2, 0x5a, 0x5d, 0x2b, 0xd9, 0x2e, 0x6e,
		0x86, 0x5c, 0xa4, 0x6b, 0xf7, 0x0d, 0xca, 0xe1, 0xec, 0xa8, 0x29, 0xd0, 0xc1, 0x48, 0x5a, 0x90,
		0xa9, 0xb1, 0xe1, 0xc3, 0xd9, 0x95, 0x0b, 0xda, 0x67, 0x08, 0x4f, 0xb1, 0xa4, 0xfd, 0x23, 0x33,
		0x62, 0x04, 0x6a, 0x92, 0xcc, 0xaa, 0x8d, 0x69, 0xb5, 0x31, 0xaf, 0x16, 0x26, 0xa6, 0x71, 0x96,
		0xa5, 0x6f, 0x04, 0xaa, 0xb2, 0x53, 0x8b, 0xc8, 0xb9, 0x45, 0x75, 0x42, 0xca, 0xa5, 0xf4, 0xea,
		0x0e, 0xc3, 0x48, 0x27, 0x8c, 0xce, 0xd2, 0xfa, 0x08, 0x6e, 0x22, 0x28, 0xb1, 0x9f, 0xcb, 0x4e,
		0x19, 0xf6, 0x3a, 0x6f, 0xab, 0xab, 0x46, 0xd5, 0x22, 0xfc, 0x48, 0x0d, 0xa9, 0x56, 0x86, 0x0f,
		0x45, 0x09, 0x45, 0x09, 0x45, 0xa9, 0x49, 0x51, 0xd2, 0x96, 0xf9, 0x53, 0x6b, 0xcd, 0x95, 0x88,
		0x43, 0xcf, 0x6d, 0x11, 0x86, 0xdc, 0x83, 0xdd, 0x20, 0xf8, 0x20, 0xf8, 0x20, 0xf8, 0x52, 0x25,
		0xf8, 0x64, 0x13, 0x9c, 0x22, 0x45, 0xdd, 0x21, 0xc1, 0x5e, 0x4a, 0x09, 0x50, 0x7a, 0xa0, 0xbe,
		0x1e, 0xb3, 0x8a, 0x58, 0x51, 0x10, 0x91, 0x99, 0xc6, 0x93, 0xa3, 0x49, 0x2d, 0x8b, 0x3c, 0xbe,
		0x32, 0xe1, 0x9e, 0xa4, 0xa9, 0x67, 0x91, 0x07, 0x72, 0xf3, 0xc7, 0xcd, 0x6d, 0xed, 0xfc, 0xe1,
		0xa4, 0xf6, 0xf5, 0xf4, 0xa2, 0x76, 0xf2, 0x70, 0x7d, 0x79, 0x56, 0xbb, 0x21, 0x3c, 0x19, 0x83,
		0x38, 0x3f, 0x4d, 0x1f, 0x89, 0x2c, 0x3a, 0x9d, 0xfe, 0xa9, 0x3c, 0x54, 0x4f, 0xce, 0x4f, 0x2f,
		0x72, 0xe4, 0xd7, 0xeb, 0x91, 0xee, 0x58, 0xff, 0x94, 0xae, 0xfb, 0x52, 0xdf, 0xa5, 0x9e, 0x41,
		0xe8, 0xea, 0xfb, 0x2f, 0xe6, 0x5f, 0xec, 0x8d, 0x0e, 0xbd, 0x8e, 0x36, 0x04, 0x80, 0x05, 0x80,
		0x05, 0x80, 0x4d, 0x15, 0x80, 0x4d, 0x9d, 0x8b, 0x7b, 0x25, 0x12, 0x4f, 0xb9, 0x5b, 0xdf, 0xac,
		0x61, 0xa0, 0xd6, 0xaf, 0x0f, 0x32, 0x0f, 0x32, 0x0f, 0x32, 0x0f, 0x32, 0x4f, 0xcb, 0x4a, 0xd9,
		0xec, 0x09, 0xc5, 0xbe, 0x81, 0x63, 0x7c, 0x29, 0x9f, 0x87, 0x1b, 0x64, 0x9d, 0xee, 0xaa, 0xcd,
		0x1d, 0x19, 0xdf, 0x87, 0x6c, 0x8e, 0xee, 0xb7, 0xfe, 0x5d, 0x3c, 0x48, 0x0f, 0x20, 0x91, 0x7f,
		0x7b, 0x3d, 0xa9, 0x76, 0x89, 0x32, 0x83, 0x49, 0xe6, 0x30, 0x8d, 0x5c, 0xbb, 0x46, 0x83, 0x32,
		0x53, 0xac, 0x84, 0x4c, 0x31, 0x8d, 0xda, 0x09, 0x99, 0x62, 0xe3, 0x3b, 0x47, 0xa6, 0x18, 0x20,
		0x25, 0x20, 0x25, 0x20, 0x65, 0x56, 0x21, 0x25, 0x32, 0xc5, 0x28, 0xb9, 0x09, 0x99, 0x62, 0x94,
		0xde, 0x16, 0x64, 0x8a, 0x41, 0x51, 0x42, 0x51, 0x6e, 0xa6, 0xa2, 0x44, 0xa6, 0xd8, 0xcc, 0xbd,
		0x23, 0x53, 0x0c, 0x82, 0x0f, 0x82, 0x6f, 0xdd, 0x05, 0x1f, 0x32, 0xc5, 0x56, 0x69, 0x56, 0x11,
		0x2b, 0x0a, 0x22, 0x32, 0xd3, 0x78, 0x72, 0xc8, 0x14, 0xfb, 0x70, 0x20, 0xc8, 0x14, 0x8b, 0x71,
		0x3a, 0xc8, 0x14, 0x5b, 0xdd, 0x2e, 0xc8, 0x14, 0x43, 0xa6, 0x18, 0x00, 0x2c, 0x00, 0x6c, 0x5a,
		0x01, 0x2c, 0x32, 0xc5, 0x90, 0x29, 0x06, 0x99, 0x07, 0x99, 0x07, 0x99, 0x97, 0x49, 0x99, 0xb7,
		0xc1, 0x99, 0x62, 0x2a, 0xa9, 0x4b, 0x06, 0x55, 0xa2, 0x98, 0xc4, 0xc8, 0x59, 0xf9, 0x77, 0x27,
		0x93, 0x27, 0x46, 0x37, 0xb1, 0x1c, 0xb3, 0xca, 0x91, 0x2d, 0xb6, 0x6a, 0x8d, 0x94, 0xd5, 0x59,
		0xe5, 0x2d, 0x66, 0x3d, 0x11, 0x0d, 0x0e, 0x38, 0x50, 0xd8, 0xe3, 0x6a, 0x28, 0x72, 0x77, 0x76,
		0x86, 0x79, 0xb6, 0xbb, 0x21, 0x53, 0xaf, 0xc5, 0x08, 0xf4, 0xdf, 0x02, 0xa7, 0x85, 0xac, 0xa4,
		0x5a, 0xff, 0xee, 0xde, 0x4e, 0xb7, 0xd5, 0x5a, 0xd7, 0x19, 0xf4, 0x63, 0x64, 0x90, 0xe8, 0xf4,
		0xf9, 0x31, 0x16, 0xc0, 0xe0, 0xf9, 0x45, 0x6f, 0x26, 0x91, 0x2e, 0xdb, 0xc1, 0xcb, 0x20, 0xeb,
		0xb2, 0xfd, 0x49, 0xe1, 0xbc, 0x45, 0xcf, 0x59, 0xe1, 0x7c, 0x73, 0xb1, 0x06, 0xb2, 0xc9, 0x9d,
		0xe8, 0xe2, 0xb3, 0x8c, 0x3e, 0xa1, 0x05, 0xa7, 0x13, 0x8c, 0xc9, 0x72, 0x3d, 0xfb, 0xef, 0x78,
		0x87, 0x33, 0x35, 0x5d, 0x6b, 0xbc, 0x6c, 0xc9, 0xe9, 0xc7, 0xab, 0x4c, 0x88, 0x8d, 0x29, 0x45,
		0xb0, 0xa3, 0x38, 0x46, 0x14, 0xc5, 0x82, 0xd2, 0x98, 0x4f, 0x1a, 0xdb, 0x49, 0x61, 0x38, 0x35,
		0xfe, 0x89, 0x9b, 0xa9, 0x2f, 0xda, 0x34, 0x59, 0xae, 0x49, 0x32, 0x5a, 0xdd, 0x1b, 0x68, 0x75,
		0x2f, 0x47, 0xa0, 0xf3, 0xe5, 0x1e, 0xc9, 0xb0, 0xc1, 0x99, 0xdd, 0x30, 0x6b, 0x50, 0x9f, 0xc5,
		0x8d, 0x56, 0xf8, 0x98, 0x35, 0x18, 0xeb, 0x3f, 0xcc, 0x1a, 0x5c, 0xfe, 0x80, 0x98, 0x35, 0x98,
		0x9c, 0x1b, 0x4b, 0xe3, 0xd3, 0x61, 0xd6, 0xa0, 0x36, 0x9f, 0xe5, 0xe8, 0x3f, 0xcc, 0x1a, 0x14,
		0x97, 0x77, 0x98, 0x35, 0x88, 0x59, 0x83, 0x5a, 0xb1, 0xa0, 0x81, 0x59, 0x83, 0x44, 0x78, 0x72,
		0xcd, 0xbd, 0xa0, 0xa1, 0x85, 0x26, 0xde, 0xd7, 0x44, 0xd0, 0x67, 0x17, 0x5e, 0x49, 0xa8, 0x77,
		0x09, 0xcd, 0xac, 0x41, 0xf6, 0x3a, 0x14, 0x12, 0x82, 0x2e, 0x98, 0xe1, 0x3a, 0xb8, 0x60, 0xe0,
		0x82, 0x49, 0xc6, 0x05, 0x13, 0x10, 0x9c, 0xbc, 0xcf, 0x65, 0xb0, 0x1c, 0xf3, 0x06, 0xe1, 0x64,
		0x49, 0x95, 0x93, 0x05, 0xf3, 0x06, 0x91, 0x17, 0xa4, 0x8d, 0x91, 0xb4, 0xa0, 0x53, 0x63, 0xc3,
		0xbb, 0x48, 0x05, 0x8a, 0x64, 0x50, 0x25, 0x4f, 0xe6, 0x52, 0x9b, 0xd8, 0x13, 0x29, 0xe7, 0xfa,
		0x19, 0x95, 0x9a, 0x61, 0xb5, 0x31, 0xae, 0x36, 0x06, 0xd6, 0xc2, 0xc8, 0x34, 0x4e, 0xb3, 0xf4,
		0xa5, 0x9c, 0xd3, 0x16, 0xee, 0x52, 0x16, 0xec, 0xea, 0x29, 0xd4, 0x9d, 0xf2, 0xf4, 0x57, 0xbf,
		0xdd, 0xfe, 0xeb, 0xf2, 0xfa, 0xf4, 0xbf, 0xd5, 0xdb, 0xd3, 0xcb, 0x8b, 0x87, 0xda, 0xef, 0xb5,
		0x8b, 0x5b, 0x0a, 0xb7, 0x7f, 0x78, 0x2d, 0x0d, 0x05, 0xba, 0x9a, 0xca, 0x95, 0xa3, 0x4e, 0xe3,
		0xf8, 0xf2, 0xe2, 0xeb, 0xe9, 0xaf, 0x74, 0xd5, 0xb9, 0xbd, 0xed, 0xec, 0x9e, 0xc4, 0xf9, 0x79,
		0xf5, 0xe2, 0x24, 0x97, 0xb2, 0x42, 0xe0, 0xfa, 0xaa, 0x25, 0x1a, 0x4a, 0x44, 0x62, 0x3a, 0xda,
		0x06, 0x4e, 0xa5, 0xc1, 0x8f, 0xc4, 0xbb, 0x09, 0x8f, 0xbd, 0x70, 0xb5, 0xe0, 0x36, 0x06, 0x3f,
		0x32, 0xd0, 0x4e, 0x98, 0x00, 0x91, 0xd2, 0x21, 0x51, 0x94, 0x8a, 0xc0, 0x24, 0x44, 0xa9, 0x48,
		0xda, 0x4a, 0x45, 0x26, 0xd8, 0x1a, 0x7d, 0xd1, 0x13, 0xf1, 0x68, 0xa1, 0x2f, 0x3a, 0xc4, 0x17,
		0x3c, 0x5a, 0xf0, 0x68, 0xc1, 0xa3, 0x05, 0x8f, 0x16, 0x3c, 0x5a, 0xf0, 0x68, 0xc1, 0xa3, 0x05,
		0x8f, 0x16, 0x3c, 0x5a, 0x9b, 0xed, 0xd1, 0x4a, 0xb8, 0xeb, 0x49, 0x84, 0x43, 0x2b, 0xd9, 0xb6,
		0x27, 0x49, 0xf4, 0x0c, 0x90, 0x06, 0x9b, 0xe8, 0x1a, 0xa0, 0xfc, 0x0a, 0x92, 0xee, 0x1a, 0x30,
		0x9f, 0xb5, 0xf4, 0xb7, 0x0d, 0x98, 0xcf, 0x4c, 0xe8, 0x1b, 0xb0, 0xe8, 0xdd, 0x24, 0x91, 0x31,
		0x3b, 0x78, 0x1b, 0x49, 0x66, 0xcc, 0x8a, 0x79, 0xa9, 0xa4, 0xbc, 0x52, 0xd2, 0xf9, 0xb2, 0x25,
		0xe4, 0xcb, 0x52, 0x1a, 0x99, 0x28, 0x59, 0x46, 0xc9, 0x32, 0xb2, 0x69, 0x29, 0x3d, 0x2b, 0x28,
		0x59, 0x8e, 0xbe, 0x6d, 0x94, 0x2c, 0xa3, 0x64, 0x59, 0xf1, 0x41, 0x51, 0xb2, 0x9c, 0xdd, 0xa7,
		0x43, 0xc9, 0x72, 0xa2, 0x42, 0x0f, 0x25, 0xcb, 0x1b, 0xe6, 0x0a, 0x41, 0xc9, 0xb2, 0x1e, 0x5c,
		0x68, 0xa0, 0x64, 0x39, 0x7d, 0x0e, 0x18, 0x51, 0x57, 0xb3, 0xb4, 0xff, 0x45, 0xc0, 0x9b, 0x9c,
		0xf5, 0xb6, 0x8d, 0x71, 0x3b, 0x18, 0xaa, 0x9c, 0xa7, 0x8e, 0xa6, 0x8d, 0x31, 0x4b, 0x05, 0xc5,
		0x4a, 0x02, 0xd1, 0xa6, 0x91, 0x56, 0xaa, 0xae, 0xa0, 0x4d, 0xa3, 0x4e, 0x7e, 0x89, 0x9d, 0xbc,
		0x2d, 0xc0, 0x28, 0x71, 0x32, 0xb1, 0xe5, 0x38, 0xc4, 0x67, 0xde, 0x2b, 0xf3, 0xcc, 0x67, 0xcf,
		0xed, 0x76, 0xfc, 0xf8, 0x8c, 0x32, 0xbd, 0x0c, 0xfc, 0x82, 0xb6, 0xa6, 0xb3, 0xe4, 0x24, 0x11,
		0x28, 0x98, 0x5c, 0x8d, 0xfe, 0x1a, 0x09, 0xba, 0x4c, 0x37, 0x3a, 0x5e, 0x20, 0xd9, 0x50, 0x40,
		0xad, 0x91, 0x00, 0x3a, 0x6c, 0x24, 0x4a, 0xe0, 0xe4, 0xb6, 0xdf, 0x3a, 0x77, 0xd8, 0xa0, 0x99,
		0xbc, 0x83, 0xa9, 0x3b, 0xa8, 0x45, 0x58, 0x05, 0x53, 0xad, 0xc4, 0x2d, 0x4b, 0x58, 0x4a, 0x95,
		0x3d, 0xf7, 0xac, 0x4c, 0xc5, 0x13, 0x4d, 0xd1, 0x26, 0xca, 0x35, 0x21, 0x63, 0x20, 0x63, 0xc4,
		0xe9, 0x65, 0x23, 0xe2, 0xde, 0x37, 0xb5, 0xeb, 0xdf, 0x6b, 0xd7, 0x6b, 0x1e, 0xf7, 0x1e, 0x44,
		0x86, 0xd7, 0x31, 0x2a, 0x3c, 0x88, 0xe8, 0x6f, 0x5c, 0x58, 0x38, 0x65, 0x46, 0x44, 0x92, 0x59,
		0xce, 0x53, 0x5e, 0xc5, 0xa9, 0x7f, 0xc9, 0xb7, 0xc4, 0x10, 0xf0, 0xb2, 0xde, 0x04, 0x17, 0xfc,
		0x35, 0xb8, 0xfa, 0xe4, 0x3f, 0xa4, 0x1a, 0x61, 0x08, 0x04, 0xdc, 0x04, 0xfc, 0x43, 0x52, 0x96,
		0x99, 0x8a, 0x45, 0x86, 0xd4, 0x45, 0xb8, 0x29, 0x52, 0x9f, 0xba, 0x28, 0xdf, 0x7c, 0x42, 0xa5,
		0xe9, 0xc4, 0x9c, 0x66, 0x13, 0xe2, 0x33, 0x49, 0xf5, 0x88, 0x89, 0x81, 0xe8, 0xf4, 0xe5, 0x25,
		0xc5, 0x68, 0x03, 0xf8, 0x34, 0x21, 0x2c, 0xd6, 0xc3, 0xa7, 0x39, 0xa0, 0x68, 0x82, 0x16, 0x2b,
		0x83, 0x7d, 0xd0, 0x35, 0x18, 0x3e, 0x87, 0x8d, 0xf0, 0x39, 0x28, 0xf7, 0x58, 0xb1, 0x9a, 0x4d,
		0x8f, 0xf9, 0x3e, 0x9d, 0x69, 0x3f, 0xda, 0x10, 0xdd, 0x55, 0xf4, 0xb3, 0x28, 0x35, 0xab, 0x6a,
		0x63, 0x59, 0x6d, 0xac, 0xab, 0x85, 0x85, 0x69, 0x5c, 0x13, 0xe9, 0xeb, 0xae, 0xa2, 0xde, 0x05,
		0x8e, 0x02, 0x98, 0xc7, 0x00, 0xea, 0x23, 0x19, 0xb2, 0xaa, 0x5e, 0x10, 0x0a, 0x4a, 0x53, 0x71,
		0xfc, 0xc1, 0xcc, 0x3b, 0x53, 0x6e, 0x36, 0x4a, 0x00, 0x6c, 0x20, 0x4d, 0x21, 0x4d, 0xb3, 0x2e,
		0x4d, 0x55, 0x81, 0x12, 0x39, 0x60, 0xd2, 0x04, 0x9c, 0x88, 0x01, 0x14, 0x39, 0xeb, 0xeb, 0x10,
		0x01, 0xfa, 0x44, 0x81, 0x2e, 0x91, 0xa0, 0x5d, 0x34, 0x68, 0x17, 0x11, 0x5a, 0x45, 0x05, 0x8d,
		0xc8, 0x20, 0x12, 0x1d, 0xf4, 0x80, 0x6c, 0x86, 0x5e, 0xed, 0x8e, 0x49, 0xcb, 0xfd, 0x86, 0x62,
		0xe5, 0xf7, 0xb2, 0x33, 0xb8, 0x23, 0xa5, 0x21, 0x5a, 0x9e, 0xfa, 0x70, 0xb2, 0xaf, 0xfb, 0x1a,
		0xce, 0x76, 0xe6, 0x8c, 0x3f, 0x6b, 0xd8, 0xfb, 0xca, 0xe2, 0x9c, 0x79, 0x0e, 0xf9, 0x71, 0x87,
		0x17, 0xd8, 0xba, 0x2b, 0x98, 0x87, 0xf5, 0xf7, 0xbb, 0xa2, 0x79, 0x58, 0x1f, 0xfc, 0x5a, 0x0c,
		0x7e, 0xfc, 0x2c, 0xf5, 0xde, 0x4b, 0x77, 0x05, 0x73, 0x7f, 0xf8, 0x69, 0xa9, 0x7c, 0x57, 0x30,
		0xcb, 0xf5, 0xfc, 0xd6, 0xfd, 0xfd, 0x8e, 0xe8, 0x9a, 0xfc, 0xcf, 0xbd, 0x5e, 0x8e, 0xfc, 0xf6,
		0xeb, 0x3a, 0x8e, 0xfb, 0xf2, 0xe6, 0xf4, 0x3f, 0xda, 0xcf, 0xfc, 0xcf, 0xad, 0xa4, 0x4e, 0x3d,
		0xff, 0x0f, 0x0d, 0xe7, 0x4e, 0xba, 0x63, 0x6f, 0x3b, 0x43, 0x62, 0xa4, 0x02, 0x31, 0x12, 0x25,
		0x46, 0x02, 0xea, 0xb4, 0xcc, 0xa7, 0xaa, 0xf9, 0xb5, 0xfe, 0xb3, 0xb8, 0xbd, 0xdf, 0x3b, 0xca,
		0xff, 0x3c, 0xe8, 0x7d, 0xfc, 0xf0, 0x7d, 0xde, 0xd7, 0x8a, 0xdb, 0x07, 0xbd, 0xa3, 0x88, 0xbf,
		0x54, 0x7a, 0x47, 0x31, 0xf7, 0x28, 0xf7, 0xb6, 0x66, 0xbe, 0xda, 0xff, 0xbc, 0x14, 0xb5, 0x60,
		0x3f, 0x62, 0xc1, 0x5e, 0xd4, 0x82, 0xbd, 0x88, 0x05, 0x91, 0xb7, 0x54, 0x8a, 0x58, 0x50, 0xee,
		0xbd, 0xcf, 0x7c, 0x7f, 0x6b, 0xfe, 0x57, 0x2b, 0xbd, 0xfc, 0x7b, 0xd4, 0xdf, 0x0e, 0x7a, 0xef,
		0x47, 0xf9, 0x3c, 0x04, 0xeb, 0x8c, 0x60, 0x05, 0x19, 0x26, 0x4f, 0x86, 0xe9, 0x57, 0x34, 0x9f,
		0xd2, 0x75, 0x5f, 0xbd, 0x34, 0xe4, 0x03, 0xaa, 0xd5, 0x91, 0x44, 0xaa, 0x4a, 0x85, 0xba, 0x12,
		0xf8, 0x30, 0xe0, 0xc3, 0x80, 0x0f, 0x23, 0xa3, 0x3e, 0x0c, 0xe5, 0xba, 0x98, 0x68, 0x50, 0xbc,
		0x46, 0x32, 0x97, 0xdb, 0x6d, 0xe6, 0x76, 0x39, 0xbd, 0xd8, 0x1d, 0x6d, 0x0c, 0xc9, 0x0b, 0xc9,
		0x0b, 0xc9, 0xbb, 0x51, 0x92, 0xb7, 0x6b, 0x3b, 0xbc, 0x58, 0xd1, 0x20, 0x79, 0x2b, 0x84, 0x5b,
		0x5e, 0x5b, 0xce, 0x73, 0x26, 0x3c, 0xc7, 0xe7, 0xb6, 0x43, 0xce, 0xa8, 0xe1, 0xe6, 0x41, 0xa1,
		0x12, 0x9d, 0x18, 0x9c, 0xd9, 0xff, 0xab, 0x67, 0x35, 0xb8, 0xed, 0x3a, 0x27, 0xf6, 0xb3, 0x2d,
		0xdb, 0xf0, 0x2e, 0x1e, 0xed, 0xb1, 0x67, 0x8b, 0xdb, 0xaf, 0xfd, 0x67, 0x79, 0xb2, 0x5a, 0x3e,
		0x23, 0xbf, 0x4a, 0x4f, 0x83, 0x23, 0xe2, 0xdc, 0xfa, 0xa1, 0xff, 0xd5, 0x56, 0xca, 0xe5, 0xbd,
		0x32, 0x5e, 0x6f, 0x62, 0x16, 0xf9, 0x9a, 0xda, 0xf7, 0x2b, 0x4d, 0x96, 0x20, 0x1a, 0x4f, 0x13,
		0xee, 0x47, 0x54, 0x65, 0x36, 0x2c, 0x7b, 0x18, 0xfe, 0xdc, 0x25, 0x49, 0x8d, 0x32, 0x88, 0x8a,
		0xd0, 0x06, 0xbf, 0x8f, 0x3e, 0x53, 0x1a, 0xce, 0xac, 0x4e, 0x03, 0x2a, 0x09, 0x6c, 0x9e, 0xd5,
		0xb4, 0xbb, 0x84, 0xf9, 0xc0, 0xc3, 0xfd, 0x90, 0xc0, 0x96, 0x9c, 0xdd, 0x81, 0x04, 0x36, 0x24,
		0xb0, 0x45, 0x6f, 0x44, 0x94, 0xa1, 0x3a, 0x43, 0xbe, 0x64, 0xe2, 0x98, 0x90, 0xe1, 0xe1, 0x80,
		0x80, 0x03, 0x02, 0x0e, 0x08, 0x5a, 0x01, 0x12, 0x6e, 0x68, 0x35, 0x1a, 0xdc, 0xec, 0xb8, 0x1e,
		0xa7, 0xa7, 0xab, 0x30, 0x27, 0x36, 0xbc, 0x04, 0xf1, 0x6b, 0x3f, 0x61, 0x4f, 0x56, 0xb7, 0xc5,
		0xb5, 0x84, 0xa3, 0x73, 0xc5, 0xcf, 0xc5, 0x3d, 0xda, 0x90, 0x28, 0x71, 0x58, 0x9e, 0xd8, 0xbd,
		0xab, 0x4d, 0xca, 0xea, 0x94, 0xb6, 0xfa, 0xa5, 0xae, 0x6e, 0xe9, 0x9b, 0x98, 0x14, 0x4e, 0x4c,
		0x1a, 0x27, 0x22, 0x95, 0x35, 0xb9, 0x20, 0x88, 0x29, 0x9e, 0xdc, 0x5d, 0x3c, 0x43, 0xef, 0x7d,
		0xb1, 0x6a, 0x3a, 0xdd, 0xf6, 0xa3, 0x74, 0xbd, 0x74, 0x1c, 0x11, 0x53, 0xd1, 0xb0, 0xb5, 0x1e,
		0x5f, 0xf2, 0xe8, 0x3f, 0x3d, 0x4c, 0x6a, 0xe8, 0xf6, 0x2d, 0x87, 0x17, 0xd1, 0xec, 0x63, 0x0e,
		0xaf, 0x93, 0x94, 0x33, 0x72, 0x4c, 0xb8, 0xba, 0x9d, 0x92, 0x9a, 0x78, 0x79, 0x9a, 0x04, 0x34,
		0xfa, 0xa0, 0x67, 0x48, 0x40, 0xa3, 0x2f, 0x7a, 0x13, 0xc8, 0xe0, 0x53, 0x36, 0x76, 0x4d, 0x6b,
		0xae, 0x1c, 0x21, 0x1b, 0x05, 0x63, 0x3e, 0x75, 0xdb, 0x1a, 0xe1, 0x25, 0x32, 0x66, 0x6b, 0x94,
		0x60, 0x6b, 0xc0, 0xd6, 0x80, 0xad, 0x01, 0x5b, 0x03, 0xb6, 0x06, 0x6c, 0x0d, 0xd8, 0x1a, 0xb0,
		0x35, 0x60, 0x6b, 0xc0, 0xd6, 0x80, 0xad, 0x21, 0xfd, 0xd2, 0x3d, 0xc6, 0x3d, 0xcb, 0xf1, 0xdb,
		0x36, 0x37, 0x2d, 0xce, 0x59, 0xbb, 0xc3, 0x7d, 0x7d, 0x56, 0xc7, 0xbc, 0x8b, 0x01, 0x80, 0x03,
		0x80, 0x03, 0x80, 0x03, 0x80, 0x13, 0xd2, 0x7b, 0xd7, 0x76, 0xf8, 0x67, 0x8d, 0xd0, 0xbb, 0x0c,
		0xe8, 0x0d, 0xe8, 0x0d, 0xe8, 0xbd, 0x1a, 0xe8, 0x5d, 0x2a, 0x03, 0x78, 0x03, 0x78, 0x67, 0x1f,
		0x78, 0xfb, 0xac, 0xe1, 0x31, 0x6e, 0xfe, 0xc5, 0xde, 0xf4, 0xe1, 0xed, 0x89, 0x6b, 0x00, 0x66,
		0x03, 0x66, 0x03, 0x66, 0x03, 0x66, 0x53, 0x5a, 0xf3, 0x6e, 0x97, 0xdb, 0xce, 0xb3, 0xd9, 0xb1,
		0x7c, 0x3f, 0x20, 0x1f, 0x9d, 0xbd, 0xa2, 0x36, 0x4a, 0x23, 0x98, 0x2f, 0x96, 0xff, 0xc2, 0x9a,
		0x49, 0x28, 0x86, 0xd1, 0xa5, 0xa0, 0x1f, 0xa0, 0x1f, 0xa0, 0x1f, 0xa0, 0x1f, 0x08, 0xe9, 0xbd,
		0xe1, 0xbd, 0x75, 0x78, 0xa8, 0x1d, 0x4c, 0x85, 0xf9, 0xb8, 0x50, 0x11, 0x23, 0x15, 0x11, 0x30,
		0xba, 0x49, 0xdd, 0x96, 0x7b, 0x56, 0x3f, 0x4c, 0x5f, 0x07, 0xca, 0x01, 0xca, 0x01, 0xca, 0x01,
		0xca, 0x81, 0x90, 0xde, 0xb5, 0x74, 0x01, 0x9f, 0xd1, 0x09, 0x87, 0x1a, 0xf6, 0xd6, 0xd2, 0x15,
		0x7c, 0xf4, 0x9f, 0x46, 0x47, 0x7d, 0x42, 0x5d, 0xc2, 0x67, 0xf5, 0xb2, 0xc6, 0x6b, 0xe8, 0x6e,
		0xb4, 0x1a, 0x5e, 0x28, 0xbb, 0xdd, 0xc3, 0x47, 0xff, 0xd5, 0x75, 0xbe, 0x86, 0x24, 0x9a, 0xde,
		0x86, 0x57, 0xcb, 0x76, 0x57, 0xf1, 0xf0, 0x7d, 0xe8, 0xf1, 0xc5, 0x6f, 0x67, 0x58, 0x2c, 0x55,
		0x20, 0x96, 0x44, 0xc5, 0x12, 0xda, 0x40, 0xaf, 0x4d, 0x37, 0xf2, 0xb5, 0x15, 0xd4, 0x20, 0xcf,
		0xb5, 0xe8, 0x52, 0xae, 0x59, 0x71, 0x6d, 0x4e, 0x10, 0x39, 0x55, 0x8d, 0x32, 0x88, 0xbb, 0x9f,
		0x8d, 0x3d, 0x55, 0x5a, 0xba, 0xa0, 0x0d, 0xfa, 0x6b, 0xed, 0x92, 0x76, 0xdf, 0x31, 0xf4, 0x34,
		0x45, 0xbb, 0x0e, 0x6e, 0x95, 0xa4, 0x37, 0x1a, 0x1d, 0xe5, 0xf4, 0x48, 0xfa, 0xc7, 0x59, 0x5c,
		0x43, 0x2b, 0xfd, 0xc1, 0xb6, 0x29, 0x6f, 0xa8, 0x54, 0x42, 0x43, 0xa5, 0x0c, 0x79, 0x0e, 0xd1,
		0x50, 0x09, 0x0d, 0x95, 0xd0, 0x50, 0x09, 0x45, 0xce, 0x88, 0xdf, 0xac, 0x52, 0x0a, 0x27, 0x26,
		0x8d, 0x13, 0x91, 0xca, 0x7a, 0xec, 0x15, 0x14, 0x39, 0xcf, 0x17, 0x31, 0x28, 0x72, 0x9e, 0xb8,
		0x71, 0x54, 0x5a, 0x28, 0x11, 0x2e, 0x2a, 0x2d, 0x04, 0x49, 0x00, 0x45, 0xce, 0xe9, 0x72, 0x68,
		0x19, 0xa8, 0xb5, 0x90, 0xb5, 0x35, 0xd0, 0x50, 0x29, 0xd2, 0xd6, 0x40, 0x43, 0x25, 0xd8, 0x1a,
		0xb0, 0x35, 0x60, 0x6b, 0xc0, 0xd6, 0x80, 0xad, 0x01, 0x5b, 0x03, 0xb6, 0x06, 0x6c, 0x0d, 0xd8,
		0x1a, 0xb0, 0x35, 0xe4, 0x5f, 0x7a, 0xc3, 0xed, 0x3a, 0x9c, 0x79, 0x1a, 0x8b, 0x33, 0xc2, 0x2b,
		0xe8, 0x81, 0xda, 0x45, 0x40, 0x6d, 0x40, 0x6d, 0x40, 0xed, 0x34, 0x42, 0x6d, 0xea, 0x20, 0xec,
		0xd8, 0x41, 0xd2, 0x68, 0x30, 0xdf, 0x37, 0xfb, 0x3f, 0x74, 0x34, 0x80, 0x9b, 0xf5, 0x96, 0x4c,
		0x5f, 0x4f, 0x13, 0xc1, 0xe8, 0xf1, 0x1d, 0x68, 0x17, 0x6c, 0x49, 0x08, 0xb8, 0xe4, 0x04, 0x5d,
		0x52, 0x02, 0x2f, 0x71, 0xc1, 0x97, 0xb8, 0x00, 0x4c, 0x54, 0x10, 0x6a, 0x86, 0x96, 0x9a, 0x38,
		0x46, 0x9b, 0x2f, 0x22, 0x0a, 0x84, 0x55, 0xf6, 0x13, 0xa8, 0x55, 0xd0, 0x59, 0xaa, 0xa0, 0xd7,
		0x43, 0xa1, 0xdf, 0x53, 0x91, 0xa8, 0xc7, 0x22, 0x69, 0xcf, 0xc5, 0xca, 0x4c, 0xd7, 0xe4, 0x4d,
		0xd8, 0x04, 0x3c, 0x1a, 0x89, 0x7a, 0x36, 0x66, 0x48, 0xa5, 0xf8, 0x79, 0x7f, 0xbf, 0x72, 0xb0,
		0xbf, 0x5f, 0x38, 0xd8, 0x3b, 0x28, 0x1c, 0x96, 0xcb, 0xc5, 0x4a, 0xb1, 0x0c, 0xea, 0xc9, 0x84,
		0xb6, 0xd2, 0xbf, 0x7b, 0x56, 0x6a, 0x2a, 0x34, 0x70, 0xe7, 0xc8, 0x16, 0xf0, 0xd8, 0xff, 0xc7,
		0x1a, 0x09, 0xda, 0x1e, 0xa3, 0xeb, 0xc1, 0xf6, 0x80, 0xed, 0x01, 0xdb, 0x03, 0xb6, 0x07, 0x6c,
		0x0f, 0xd8, 0x1e, 0xb0, 0x3d, 0x60, 0x7b, 0xc0, 0xf6, 0x00, 0xf5, 0xc0, 0xf6, 0xd8, 0x10, 0xdb,
		0xc3, 0x63, 0xdc, 0xb3, 0x59, 0xd3, 0x0c, 0x6d, 0x82, 0xff, 0x75, 0x99, 0x9f, 0x84, 0x11, 0x12,
		0x75, 0x61, 0x58, 0x23, 0xb0, 0x46, 0x60, 0x8d, 0xc0, 0x1a, 0x81, 0x35, 0x02, 0x6b, 0x04, 0xd6,
		0x08, 0xac, 0x11, 0x58, 0x23, 0xa0, 0x1e, 0x58, 0x23, 0x1b, 0x62, 0x8d, 0x70, 0xbb, 0xcd, 0xdc,
		0x2e, 0x4f, 0xde, 0x1a, 0x89, 0xba, 0x30, 0xac, 0x11, 0x58, 0x23, 0xb0, 0x46, 0x60, 0x8d, 0xc0,
		0x1a, 0x81, 0x35, 0x02, 0x6b, 0x04, 0xd6, 0x08, 0xac, 0x11, 0x50, 0x0f, 0xac, 0x91, 0x34, 0x5a,
		0x23, 0xa9, 0x2e, 0x5b, 0xd1, 0xd4, 0x63, 0x36, 0xdc, 0x5f, 0x6b, 0xaf, 0xd9, 0xa0, 0x2f, 0xe9,
		0xae, 0xa6, 0x9a, 0x3b, 0x43, 0x6b, 0xef, 0xd9, 0x9b, 0xfe, 0xad, 0x3f, 0x1c, 0x8f, 0x6e, 0x7d,
		0x03, 0x8a, 0x2f, 0x3d, 0xc6, 0x3d, 0xcb, 0xf1, 0xdb, 0x36, 0x37, 0x2d, 0xce, 0x59, 0x5b, 0x47,
		0x31, 0xd3, 0x54, 0x0c, 0xef, 0xe3, 0xc5, 0xd0, 0xfd, 0x04, 0x25, 0x99, 0x2b, 0xb7, 0x80, 0x51,
		0x92, 0x99, 0x9c, 0x6e, 0xd3, 0xdf, 0xfd, 0xa4, 0x6b, 0x3b, 0xfc, 0xb3, 0xc6, 0xbe, 0x27, 0x65,
		0xf4, 0x3d, 0x49, 0xd6, 0x5a, 0x45, 0xdf, 0x93, 0x34, 0x5b, 0xa3, 0xc9, 0xf6, 0x3d, 0x29, 0x95,
		0xd1, 0xf5, 0x24, 0x5d, 0x66, 0x1f, 0xba, 0x9e, 0x48, 0xd9, 0x30, 0xe1, 0x40, 0xf1, 0x24, 0x86,
		0x96, 0x03, 0x66, 0x03, 0x66, 0x03, 0x66, 0x03, 0x66, 0x93, 0x5a, 0xf3, 0x6e, 0x97, 0xdb, 0xce,
		0x73, 0x38, 0xaf, 0x1c, 0xa3, 0xca, 0xa9, 0x34, 0x82, 0xf9, 0x62, 0xf9, 0x2f, 0xac, 0x99, 0x84,
		0x62, 0x18, 0x5d, 0x0a, 0xfa, 0x01, 0xfa, 0x01, 0xfa, 0x01, 0xfa, 0x81, 0x90, 0xde, 0x1b, 0xde,
		0x5b, 0x87, 0x87, 0xda, 0xc1, 0xe4, 0xfd, 0x0b, 0x42, 0x45, 0xa8, 0xa9, 0x88, 0x80, 0xd1, 0xc3,
		0xa1, 0xbf, 0xfa, 0xf4, 0xc3, 0xf4, 0x75, 0xa0, 0x1c, 0xa0, 0x1c, 0xa0, 0x1c, 0xa0, 0x1c, 0x08,
		0xe9, 0xdd, 0xee, 0x68, 0x1c, 0x5d, 0x1e, 0xea, 0x84, 0x43, 0x0d, 0x7b, 0x0f, 0xcf, 0xe6, 0x2e,
		0xc3, 0x63, 0xe3, 0xf7, 0x31, 0x36, 0x5e, 0xf0, 0x42, 0xc1, 0x60, 0xea, 0xfa, 0xfb, 0x5d, 0xd1,
		0x3c, 0xac, 0x0f, 0x7e, 0x2d, 0x06, 0x3f, 0x7e, 0x96, 0x7a, 0xef, 0xa5, 0xbb, 0x82, 0xb9, 0x3f,
		0xfc, 0xb4, 0x54, 0xbe, 0x2b, 0x98, 0xe5, 0x7a, 0x7e, 0xeb, 0xfe, 0x7e, 0x47, 0x74, 0x4d, 0xfe,
		0xe7, 0x5e, 0x0f, 0x43, 0xd2, 0x97, 0x5f, 0x6d, 0x38, 0x24, 0x3d, 0x81, 0xb7, 0x91, 0xc1, 0xa1,
		0xe0, 0xdb, 0x19, 0x16, 0x4b, 0x15, 0x88, 0x25, 0x51, 0xb1, 0x34, 0x6f, 0x60, 0xfe, 0x41, 0x2f,
		0xe6, 0xa8, 0xff, 0x83, 0xde, 0x51, 0xc4, 0x5f, 0x2a, 0xbd, 0xa3, 0x98, 0x7b, 0x94, 0x23, 0x66,
		0xf3, 0x97, 0xa2, 0x16, 0xec, 0x47, 0x2c, 0xd8, 0x8b, 0x5a, 0xb0, 0x17, 0xb1, 0x20, 0xf2, 0x96,
		0x4a, 0x11, 0x0b, 0xca, 0xbd, 0xf7, 0x99, 0xef, 0x6f, 0xcd, 0xff, 0x6a, 0xa5, 0x97, 0x7f, 0x8f,
		0xfa, 0xdb, 0x41, 0xef, 0xfd, 0x28, 0x9f, 0x87, 0xa0, 0x8e, 0x2d, 0xa8, 0x41, 0x9e, 0xc9, 0x93,
		0x67, 0xf6, 0x14, 0xd7, 0xe6, 0x04, 0x91, 0x53, 0x35, 0xa5, 0x5c, 0x53, 0xa6, 0x71, 0x02, 0x19,
		0xc6, 0x94, 0xf3, 0xfa, 0xf5, 0x26, 0x14, 0xd3, 0xf0, 0xa2, 0x3a, 0xdd, 0xa8, 0xed, 0xa0, 0x48,
		0x71, 0xd4, 0x94, 0xa6, 0x95, 0xc2, 0x08, 0x68, 0x4b, 0x1b, 0x4d, 0xa9, 0x51, 0x93, 0x3c, 0x0d,
		0x28, 0xbc, 0xff, 0xdc, 0x80, 0x61, 0x55, 0x5f, 0xfb, 0xd8, 0x3d, 0x4d, 0xc0, 0xff, 0x44, 0xc3,
		0x7b, 0xc6, 0x5e, 0xe7, 0x92, 0xe2, 0x46, 0x84, 0x5e, 0x66, 0x7a, 0xaf, 0x32, 0xb5, 0x17, 0x59,
		0x9b, 0xd7, 0x58, 0x9b, 0x97, 0x58, 0x8b, 0x57, 0x78, 0xb5, 0x12, 0x99, 0x6a, 0x38, 0x4e, 0x8e,
		0x3a, 0x1e, 0x35, 0xee, 0x3c, 0x4d, 0xea, 0x0f, 0x20, 0x0e, 0x3c, 0x91, 0x07, 0x9c, 0x74, 0x04,
		0x9a, 0xf4, 0x05, 0x98, 0x74, 0x05, 0x96, 0xb4, 0x07, 0x94, 0xb4, 0x07, 0x92, 0xb4, 0x06, 0x90,
		0xd2, 0x65, 0x3e, 0x90, 0x07, 0x8a, 0xf4, 0x06, 0x88, 0x74, 0x04, 0x86, 0xf4, 0x04, 0x84, 0xb4,
		0x86, 0xde, 0xb4, 0x06, 0x80, 0x74, 0x7a, 0x58, 0xb5, 0x7b, 0x56, 0x33, 0x1c, 0xe8, 0xa9, 0xeb,
		0x38, 0xee, 0x24, 0xfc, 0x85, 0x19, 0x0f, 0xe8, 0xd4, 0xd3, 0x1c, 0xc9, 0xd7, 0x2b, 0x46, 0x2a,
		0x10, 0x23, 0x51, 0x62, 0x04, 0x9e, 0xef, 0xb5, 0x09, 0xcc, 0x64, 0x5e, 0xb0, 0x82, 0x0c, 0xd7,
		0x22, 0x00, 0x93, 0xd6, 0x80, 0x46, 0x3d, 0x2d, 0xee, 0x6d, 0x02, 0x37, 0x57, 0xc3, 0x75, 0x1c,
		0x16, 0x54, 0x7f, 0x9a, 0xd6, 0xa3, 0xeb, 0x71, 0x0d, 0x3e, 0x8d, 0xd9, 0x4b, 0xc0, 0xbb, 0x01,
		0xef, 0x06, 0xbc, 0x1b, 0x1b, 0xe5, 0xdd, 0xd0, 0xd1, 0x74, 0x51, 0x43, 0x93, 0x45, 0x4d, 0x6d,
		0x29, 0x34, 0x58, 0x25, 0x3a, 0xdb, 0x50, 0xe8, 0x6e, 0x3f, 0x91, 0x58, 0xc7, 0x01, 0xfd, 0x9d,
		0x06, 0x74, 0x34, 0x79, 0xd6, 0xd9, 0x5e, 0x62, 0x05, 0x4d, 0x0d, 0xd7, 0xe9, 0x6d, 0x03, 0x91,
		0x26, 0x89, 0x48, 0x1b, 0x2d, 0xd7, 0x67, 0x7a, 0x11, 0xe9, 0xf0, 0x12, 0x40, 0xa4, 0x40, 0xa4,
		0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4,
		0xf3, 0x10, 0xe9, 0x93, 0x65, 0xb7, 0xba, 0x9e, 0x66, 0x4c, 0x1a, 0x5e, 0x04, 0xa8, 0x14, 0xa8,
		0x14, 0xa8, 0x14, 0xa8, 0x14, 0xa8, 0x14, 0xa8, 0x14, 0xa8, 0x14, 0xa8, 0x14, 0xa8, 0x14, 0xa8,
		0x74, 0x1e, 0x2a, 0x75, 0x3b, 0xcc, 0xd1, 0x0b, 0x49, 0x07, 0x57, 0x00, 0x1e, 0x05, 0x1e, 0x05,
		0x1e, 0x05, 0x1e, 0x05, 0x1e, 0x05, 0x1e, 0x05, 0x1e, 0x05, 0x1e, 0x05, 0x1e, 0x05, 0x1e, 0x9d,
		0x87, 0x47, 0x87, 0xc3, 0xc2, 0xf5, 0x42, 0xd2, 0xf0, 0x22, 0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5,
		0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5, 0x40, 0xa5, 0xe1, 0x4b,
		0x64, 0x9e, 0xe7, 0x7a, 0xbe, 0xe9, 0xb1, 0x06, 0xb3, 0x5f, 0x09, 0x27, 0xcc, 0x84, 0xaa, 0xe8,
		0xe3, 0x05, 0x80, 0x46, 0x81, 0x46, 0x81, 0x46, 0x81, 0x46, 0x81, 0x46, 0x81, 0x46, 0x81, 0x46,
		0x81, 0x46, 0x81, 0x46, 0x81, 0x46, 0xc3, 0x97, 0xd8, 0x66, 0xbe, 0x6f, 0x3d, 0x33, 0x9d, 0x78,
		0x74, 0xf6, 0x12, 0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4, 0x40,
		0xa4, 0x40, 0xa4, 0x40, 0xa4, 0x40, 0xa4, 0xb3, 0x88, 0xd4, 0x1f, 0xa8, 0x5c, 0x5d, 0x68, 0x34,
		0xd8, 0x1e, 0x48, 0x14, 0x48, 0x14, 0x48, 0x14, 0x48, 0x14, 0x48, 0x14, 0x48, 0x14, 0x48, 0x14,
		0x48, 0x14, 0x48, 0x14, 0x48, 0x34, 0x7c, 0x89, 0xc3, 0xc1, 0x51, 0xc4, 0x00, 0x34, 0xd8, 0x15,
		0xb8, 0x13, 0xb8, 0x13, 0xb8, 0x73, 0xa3, 0x70, 0xa7, 0xcf, 0x3d, 0xdb, 0x79, 0xd6, 0x31, 0x49,
		0xe5, 0xf3, 0x1a, 0xc9, 0xdc, 0x61, 0x0e, 0x3d, 0xbd, 0xd8, 0x1d, 0x6d, 0x0c, 0xc9, 0x0b, 0xc9,
		0x0b, 0xc9, 0xbb, 0x51, 0x92, 0xb7, 0x6b, 0x3b, 0xbc, 0x58, 0xd1, 0x20, 0x79, 0x2b, 0x30, 0xf7,
		0x61, 0xee, 0xc3, 0xdc, 0x17, 0x7b, 0xb5, 0x95, 0x72, 0x79, 0x0f, 0xf6, 0x3d, 0xec, 0xfb, 0x55,
		0xee, 0xb0, 0x19, 0x83, 0xb4, 0xa9, 0x66, 0xb4, 0x6b, 0x98, 0xa3, 0x4d, 0x30, 0x94, 0x7d, 0x35,
		0x63, 0xb4, 0xb9, 0xd5, 0xb0, 0x1a, 0x3e, 0xdd, 0x1c, 0xed, 0xe1, 0x7e, 0x29, 0x1b, 0xa4, 0x5d,
		0xc0, 0x20, 0xed, 0x14, 0x58, 0x19, 0x18, 0xa4, 0x1d, 0xff, 0x89, 0xc8, 0x06, 0x69, 0x37, 0x46,
		0x3c, 0x40, 0xdf, 0x27, 0xa0, 0xbf, 0x2f, 0xad, 0xfb, 0xa1, 0x08, 0xf7, 0x03, 0xdc, 0x0f, 0x70,
		0x3f, 0x50, 0x3c, 0x29, 0x95, 0x00, 0x09, 0x37, 0xec, 0xb8, 0x1e, 0xa7, 0x27, 0xa9, 0x11, 0x13,
		0x04, 0xbb, 0x13, 0xbf, 0xec, 0x13, 0xf6, 0x64, 0x75, 0x5b, 0x5c, 0xcb, 0x30, 0xcc, 0xdc, 0xfe,
		0x21, 0xed, 0x38, 0x46, 0xe2, 0x91, 0xa0, 0xc4, 0x0e, 0x5d, 0x6d, 0x92, 0x55, 0xa7, 0x84, 0xd5,
		0x2f, 0x69, 0x75, 0x4b, 0xdc, 0xc4, 0x24, 0x6f, 0x62, 0x12, 0x38, 0x11, 0x49, 0xac, 0xc9, 0xe9,
		0x40, 0x4c, 0xf1, 0xe4, 0x0e, 0xe2, 0xb9, 0x42, 0xd5, 0x74, 0xba, 0xed, 0x47, 0xe6, 0x69, 0x1c,
		0xa7, 0x5d, 0xd1, 0xb0, 0xb5, 0x1e, 0xef, 0xf1, 0xe8, 0x3f, 0x3d, 0x4c, 0x6a, 0xe8, 0xf6, 0x26,
		0x87, 0x17, 0xd1, 0xec, 0x55, 0x0e, 0xaf, 0x93, 0x94, 0xfb, 0x71, 0x4c, 0xb8, 0xba, 0xdd, 0x90,
		0x9a, 0x78, 0x79, 0x9a, 0x04, 0x34, 0x7a, 0x9d, 0x67, 0x48, 0x40, 0xa3, 0xf7, 0x79, 0x13, 0xc8,
		0xe0, 0x53, 0x36, 0x76, 0x4d, 0xeb, 0x9c, 0x6e, 0x42, 0x36, 0xca, 0xf9, 0xac, 0xe1, 0x31, 0x6e,
		0xfe, 0xc5, 0xde, 0xf4, 0x59, 0x19, 0x13, 0xd7, 0x00, 0xdc, 0x06, 0xdc, 0x06, 0xdc, 0x06, 0xdc,
		0x26, 0xa4, 0x77, 0xcf, 0xed, 0x72, 0xdb, 0x79, 0x36, 0x3b, 0x96, 0xef, 0x07, 0xe4, 0xa3, 0x0f,
		0x73, 0x13, 0xe5, 0xc8, 0x65, 0x45, 0x23, 0x98, 0x2f, 0x96, 0xff, 0x42, 0xd8, 0xcb, 0x61, 0x81,
		0x62, 0x18, 0x5d, 0x0a, 0xfa, 0x01, 0xfa, 0x01, 0xfa, 0x01, 0xfa, 0x81, 0x90, 0xde, 0x1b, 0xde,
		0x5b, 0x87, 0x87, 0xda, 0xc1, 0xe4, 0xfd, 0x0b, 0x42, 0x45, 0xa8, 0xa9, 0x88, 0x80, 0xd1, 0x4d,
		0xab, 0xd9, 0xf4, 0x98, 0xef, 0x6b, 0xd4, 0x0f, 0xd3, 0xd7, 0x81, 0x72, 0x80, 0x72, 0x80, 0x72,
		0x80, 0x72, 0x20, 0xa4, 0x77, 0xbb, 0xa3, 0x49, 0xba, 0x4c, 0xe9, 0x84, 0x43, 0x0d, 0x7b, 0x0f,
		0xcf, 0x26, 0x73, 0xae, 0xfa, 0xf1, 0xc9, 0xbf, 0xee, 0x6b, 0x3c, 0xfb, 0x59, 0xbd, 0xac, 0xf1,
		0x1a, 0x57, 0x16, 0xe7, 0xcc, 0x73, 0xb4, 0xbd, 0x8e, 0xf0, 0x42, 0x5b, 0x77, 0x05, 0xf3, 0xb0,
		0xfe, 0x7e, 0x57, 0x34, 0x0f, 0xeb, 0x83, 0x5f, 0x8b, 0xc1, 0x8f, 0x9f, 0xa5, 0xde, 0x7b, 0xe9,
		0xae, 0x60, 0xee, 0x0f, 0x3f, 0x2d, 0x95, 0xef, 0x0a, 0x66, 0xb9, 0x9e, 0xdf, 0xba, 0xbf, 0xdf,
		0x11, 0x5d, 0x93, 0xff, 0xb9, 0xd7, 0xcb, 0x69, 0x7b, 0x8c, 0xba, 0xce, 0xd7, 0x70, 0x79, 0x73,
		0xfa, 0x9f, 0xc4, 0xde, 0xc5, 0x9f, 0x5b, 0x49, 0xbd, 0x8d, 0xfc, 0x3f, 0x34, 0xbe, 0x0f, 0x3d,
		0xbe, 0xf8, 0xed, 0x0c, 0x8b, 0xa5, 0x0a, 0xc4, 0x92, 0xa8, 0x58, 0x0a, 0xa8, 0xda, 0x32, 0x9f,
		0xaa, 0xe6, 0xd7, 0xfa, 0xcf, 0xe2, 0xf6, 0x7e, 0xef, 0x28, 0xff, 0xf3, 0xa0, 0xf7, 0xf1, 0xc3,
		0xf7, 0x79, 0x5f, 0x2b, 0x6e, 0x1f, 0xf4, 0x8e, 0x22, 0xfe, 0x52, 0xe9, 0x1d, 0xc5, 0xdc, 0xa3,
		0xdc, 0xdb, 0x9a, 0xf9, 0x6a, 0xff, 0xf3, 0x52, 0xd4, 0x82, 0xfd, 0x88, 0x05, 0x7b, 0x51, 0x0b,
		0xf6, 0x22, 0x16, 0x44, 0xde, 0x52, 0x29, 0x62, 0x41, 0xb9, 0xf7, 0x3e, 0xf3, 0xfd, 0xad, 0xf9,
		0x5f, 0xad, 0xf4, 0xf2, 0xef, 0x51, 0x7f, 0x3b, 0xe8, 0xbd, 0x1f, 0xe5, 0xf3, 0x10, 0xd4, 0xb1,
		0x05, 0x35, 0xc8, 0x33, 0x79, 0xf2, 0xcc, 0x9e, 0xe2, 0xda, 0x9c, 0x20, 0x72, 0xaa, 0xf2, 0x66,
		0x89, 0x4b, 0xa1, 0xc6, 0x9e, 0x2a, 0x2d, 0x25, 0x51, 0x83, 0x72, 0x9b, 0x5d, 0xd2, 0x64, 0x7c,
		0x43, 0x4f, 0x89, 0xd4, 0x6d, 0x70, 0xab, 0x0f, 0x43, 0xa7, 0xd4, 0x1a, 0xb5, 0x78, 0x18, 0x94,
		0xa5, 0x91, 0x17, 0x58, 0x50, 0x55, 0xbb, 0x19, 0x3a, 0xeb, 0x2b, 0x4a, 0xa8, 0xaf, 0xc8, 0x90,
		0xe7, 0x10, 0xf5, 0x15, 0xa8, 0xaf, 0x20, 0xdc, 0x1b, 0xf5, 0x15, 0x88, 0xd9, 0x18, 0x88, 0xd9,
		0xa4, 0x4a, 0x02, 0x27, 0x22, 0x89, 0xf5, 0xd8, 0x28, 0xa8, 0xaf, 0x98, 0x2f, 0x62, 0x50, 0x5f,
		0x31, 0x71, 0xe3, 0xa8, 0xaf, 0x50, 0x22, 0x5c, 0xd4, 0x57, 0x08, 0x92, 0x00, 0xea, 0x2b, 0xd2,
		0xe5, 0xc4, 0x32, 0x50, 0x5f, 0x21, 0xeb, 0xa6, 0x40, 0x7d, 0x05, 0xe0, 0x36, 0xe0, 0x36, 0xe0,
		0x76, 0x66, 0xe1, 0x36, 0xea, 0x2b, 0x50, 0x5f, 0x01, 0xfd, 0x00, 0xfd, 0x00, 0xfd, 0x00, 0xfd,
		0x30, 0x8f, 0xde, 0x51, 0x5f, 0x41, 0xaf, 0x22, 0x50, 0x5f, 0x01, 0xe5, 0x00, 0xe5, 0x00, 0xe5,
		0x90, 0x79, 0xe5, 0x80, 0xfa, 0x8a, 0xb9, 0xff, 0xa1, 0xbe, 0x42, 0x4c, 0x32, 0xa3, 0xbe, 0x22,
		0xee, 0x7f, 0xa8, 0xaf, 0x40, 0x7d, 0x45, 0xca, 0xc5, 0x12, 0xea, 0x2b, 0x84, 0xc5, 0x12, 0x12,
		0xd8, 0x51, 0x5f, 0x91, 0x76, 0x41, 0x0d, 0xf2, 0x44, 0x7d, 0x45, 0xc2, 0xf6, 0x90, 0x81, 0xfa,
		0x8a, 0xb8, 0xb6, 0x6e, 0x16, 0xeb, 0x2b, 0x28, 0x73, 0xf1, 0x0d, 0xad, 0xe5, 0x15, 0x04, 0x83,
		0x68, 0xe8, 0xe8, 0x06, 0x43, 0x8d, 0xe2, 0x52, 0x58, 0x3a, 0xa7, 0x1a, 0x0d, 0x68, 0x6a, 0x65,
		0x63, 0x8d, 0x3e, 0x25, 0x48, 0x35, 0xb9, 0xdf, 0x82, 0xbc, 0x98, 0x9c, 0x9a, 0x41, 0x90, 0x3b,
		0xb3, 0x7d, 0x5e, 0xe5, 0x5c, 0xad, 0x34, 0x20, 0x77, 0x6e, 0x3b, 0xb5, 0x16, 0x6b, 0x33, 0x47,
		0x35, 0x1b, 0x2c, 0x77, 0x6e, 0xfd, 0x98, 0xd8, 0x89, 0x76, 0x32, 0x7d, 0xee, 0xd2, 0x6b, 0x32,
		0x8f, 0x35, 0xbf, 0xf4, 0x0f, 0xce, 0xe9, 0xb6, 0x5a, 0x89, 0xbe, 0x2f, 0x22, 0xee, 0xd6, 0xc3,
		0xd5, 0x0a, 0xec, 0x4c, 0xcf, 0xc6, 0x72, 0xfc, 0x2b, 0xce, 0x7d, 0x62, 0x2b, 0x04, 0xdf, 0xbb,
		0xea, 0xfb, 0x26, 0x7e, 0xcf, 0x12, 0x2f, 0x98, 0xf0, 0xc5, 0x8a, 0xbd, 0xd1, 0xf8, 0xef, 0x45,
		0xe0, 0x9d, 0x48, 0x56, 0x3d, 0x2a, 0x55, 0x37, 0x4a, 0x56, 0x31, 0x4a, 0x57, 0x2b, 0xaa, 0xc4,
		0xe1, 0xd4, 0xe3, 0x6c, 0xaa, 0x71, 0x34, 0xb2, 0x38, 0x19, 0x59, 0x1c, 0x8c, 0x24, 0xce, 0xa5,
		0x57, 0xca, 0xc8, 0x56, 0xf5, 0xe5, 0x86, 0x6c, 0x2d, 0xf9, 0xaa, 0x46, 0xc4, 0x12, 0xec, 0x22,
		0x0b, 0x60, 0x94, 0x82, 0xdc, 0xca, 0xc1, 0x6c, 0x8a, 0xa0, 0x35, 0x5d, 0x70, 0x9a, 0x2a, 0x08,
		0x4d, 0x1e, 0x6c, 0x26, 0x0f, 0x2a, 0x93, 0x06, 0x8f, 0x93, 0x85, 0xdc, 0xca, 0x41, 0xdf, 0x09,
		0x6d, 0xe2, 0xd9, 0x8e, 0x4a, 0xff, 0x03, 0xc5, 0xa4, 0x1e, 0x09, 0xb0, 0x24, 0xa1, 0x10, 0xb8,
		0xca, 0x79, 0x8d, 0x27, 0xb4, 0xca, 0xa7, 0x45, 0x41, 0xc6, 0x40, 0xc6, 0x6c, 0xac, 0x8c, 0xb1,
		0x9b, 0xcc, 0xe1, 0x36, 0x7f, 0xf3, 0xd8, 0x13, 0x85, 0xa0, 0x51, 0x31, 0xbc, 0x4f, 0x87, 0xb7,
		0xf2, 0xc5, 0xf2, 0x19, 0xdd, 0xe8, 0xe6, 0x6a, 0xb5, 0xfa, 0x70, 0x53, 0xbb, 0xfe, 0xbd, 0x76,
		0xfd, 0x70, 0xfb, 0xc7, 0x55, 0x4d, 0x95, 0x08, 0x83, 0x0a, 0x3a, 0x9f, 0x24, 0xe8, 0x43, 0xdc,
		0x59, 0xe5, 0xb6, 0x7a, 0x5c, 0x3d, 0xbe, 0xc9, 0xa5, 0xa1, 0x79, 0x0c, 0xf1, 0x93, 0x5d, 0x57,
		0x4f, 0x4e, 0xbf, 0xdd, 0xac, 0x7a, 0xf6, 0x71, 0x3d, 0x69, 0xd9, 0x00, 0x57, 0xc5, 0x5c, 0x57,
		0x85, 0x64, 0xd0, 0x82, 0xc4, 0x51, 0x21, 0x1e, 0x86, 0x10, 0x70, 0x53, 0x7c, 0x22, 0x7c, 0x6b,
		0x23, 0xc7, 0xaf, 0x80, 0xe9, 0x25, 0xe7, 0xe5, 0x95, 0xf7, 0xea, 0x92, 0x7a, 0x71, 0xe5, 0xbc,
		0xb6, 0x71, 0x0f, 0x53, 0x92, 0xf4, 0x89, 0x48, 0x3e, 0x27, 0xe4, 0xbf, 0x52, 0x25, 0xf2, 0x78,
		0xe4, 0xbd, 0x9c, 0x58, 0x17, 0x7f, 0x63, 0xc9, 0xc9, 0x8b, 0x9e, 0xb8, 0xfc, 0x49, 0xc7, 0x38,
		0x5c, 0xc9, 0x43, 0x5d, 0x7c, 0x90, 0xd1, 0xc7, 0xb3, 0xe0, 0x68, 0x62, 0xba, 0x27, 0x85, 0xdc,
		0x91, 0x31, 0xdd, 0x8f, 0xb1, 0xdd, 0x8d, 0x22, 0xd6, 0x8c, 0xb8, 0xd5, 0x22, 0x6a, 0x9d, 0x48,
		0x5b, 0x21, 0xd2, 0xd6, 0x86, 0x94, 0x55, 0x91, 0x62, 0x66, 0x89, 0xa9, 0x6e, 0x45, 0x98, 0x64,
		0xb9, 0x16, 0x5d, 0xc0, 0x1d, 0x9f, 0x04, 0x4e, 0x28, 0xee, 0xc9, 0x88, 0x9c, 0x48, 0x6e, 0x21,
		0x7b, 0xc6, 0x3c, 0x83, 0xf9, 0x4f, 0x3f, 0xfb, 0x6c, 0x73, 0x9e, 0x2b, 0x67, 0xb5, 0x2c, 0xaf,
		0x1d, 0x5d, 0xb4, 0x14, 0xf2, 0xd4, 0xf0, 0x7b, 0x11, 0x27, 0xb3, 0x98, 0xeb, 0x97, 0x72, 0x7b,
		0x1c, 0x2e, 0x9f, 0xe2, 0xee, 0x45, 0x37, 0x23, 0xc2, 0xd8, 0xc2, 0x0c, 0x2d, 0xcc, 0xc8, 0x33,
		0x0c, 0x3c, 0xb8, 0x75, 0x22, 0x8a, 0x5c, 0xe6, 0x8a, 0x1f, 0xbc, 0xb6, 0xf8, 0x22, 0x7e, 0xf0,
		0x75, 0x62, 0x11, 0x5f, 0xd0, 0x24, 0xe2, 0x97, 0x11, 0x41, 0x86, 0xa5, 0xfc, 0x12, 0x22, 0xa1,
		0x11, 0xf4, 0x71, 0xe3, 0x38, 0xb9, 0xc6, 0xe8, 0x4d, 0xc6, 0x3c, 0xbf, 0xb0, 0xd6, 0x54, 0xa4,
		0xe3, 0xae, 0x60, 0xe0, 0x52, 0xd8, 0x4f, 0x2a, 0xe3, 0x17, 0x95, 0x22, 0x37, 0x55, 0xd7, 0xa7,
		0xb2, 0xab, 0x53, 0xd9, 0xb5, 0x29, 0x4b, 0x8e, 0x7a, 0x6c, 0x4f, 0xed, 0xe6, 0x52, 0xf0, 0x74,
		0x83, 0x1f, 0xe2, 0x4d, 0xa2, 0xe3, 0x6a, 0xe9, 0xe0, 0x22, 0x83, 0x1f, 0x42, 0xed, 0x9d, 0x63,
		0x98, 0x46, 0x31, 0x24, 0xa0, 0xdd, 0x14, 0xe7, 0x5e, 0xbb, 0x29, 0xc8, 0xb9, 0x05, 0x70, 0x2e,
		0x38, 0x57, 0x29, 0xae, 0x10, 0xbe, 0xb5, 0x16, 0xb3, 0x9e, 0xc4, 0x62, 0x08, 0xa1, 0xfa, 0x38,
		0x10, 0x58, 0x73, 0x35, 0x14, 0x0e, 0x3b, 0x3b, 0x03, 0xcb, 0x64, 0xd7, 0x6e, 0x26, 0xc9, 0x95,
		0x62, 0xe9, 0x41, 0x52, 0x69, 0x41, 0xd2, 0x5a, 0xb5, 0x04, 0xde, 0x5c, 0x6b, 0xde, 0x14, 0x4d,
		0xe2, 0x11, 0x51, 0x21, 0xf2, 0xaa, 0x44, 0x52, 0xa5, 0x48, 0xab, 0x16, 0x15, 0x32, 0x26, 0x21,
		0x67, 0x55, 0xb2, 0x26, 0x23, 0x6f, 0x32, 0x32, 0xa7, 0x22, 0x77, 0xf1, 0x90, 0x87, 0x21, 0x11,
		0x86, 0x92, 0x0e, 0x7d, 0xab, 0xa7, 0xd5, 0x48, 0xa6, 0xd3, 0xe8, 0xc9, 0x54, 0xf5, 0x98, 0x2f,
		0x29, 0x57, 0xc3, 0xc6, 0x73, 0xa3, 0x1d, 0xc0, 0xe9, 0xe0, 0x74, 0x70, 0x3a, 0x05, 0xa7, 0x0b,
		0x3e, 0x21, 0xfb, 0xc1, 0x3d, 0xcb, 0xec, 0x3a, 0x3e, 0xb7, 0x1e, 0x5b, 0x92, 0xcf, 0xea, 0xb1,
		0x27, 0xe6, 0x31, 0xa7, 0x21, 0xdf, 0x4c, 0x85, 0x20, 0x8b, 0xe8, 0xb4, 0x76, 0xfb, 0xd5, 0xf8,
		0xa3, 0x7a, 0xf1, 0xab, 0x11, 0xd8, 0xcb, 0xc6, 0xb9, 0xdb, 0xec, 0xb6, 0xd8, 0x91, 0x71, 0xe2,
		0x59, 0x4f, 0xdc, 0x30, 0x0d, 0xfe, 0xd6, 0x61, 0x4d, 0xf6, 0x64, 0x8c, 0x44, 0xce, 0xbd, 0xf3,
		0xc2, 0x79, 0xc7, 0x3f, 0xda, 0xdd, 0xe5, 0xae, 0xdb, 0xf2, 0x77, 0x6c, 0xc6, 0x9f, 0x76, 0x5c,
		0xef, 0x79, 0xf7, 0x85, 0xb7, 0x5b, 0xbb, 0xcd, 0xfe, 0x2a, 0xf3, 0xd5, 0x6a, 0xb5, 0x6c, 0xc7,
		0x74, 0x18, 0x6f, 0xbb, 0xcd, 0x01, 0x89, 0x9a, 0xed, 0x60, 0x5f, 0xb3, 0x50, 0x4a, 0x59, 0x82,
		0xdb, 0xf8, 0x25, 0xa4, 0x39, 0xc7, 0x2d, 0xf9, 0xb7, 0x94, 0xfa, 0x94, 0x99, 0x7a, 0x1a, 0x6a,
		0x4e, 0xd8, 0x2b, 0xf3, 0x6c, 0xfe, 0xa6, 0x50, 0x76, 0x32, 0xda, 0x01, 0x9a, 0x1c, 0x9a, 0x7c,
		0x2d, 0x35, 0xb9, 0x5a, 0x9a, 0xaa, 0x4a, 0x7a, 0x2a, 0x4d, 0x5a, 0x6a, 0xf8, 0x20, 0x97, 0x57,
		0xb5, 0x8b, 0xe3, 0xcb, 0x8b, 0xaf, 0xa7, 0xbf, 0x3e, 0x54, 0xcf, 0xaa, 0xd7, 0xe7, 0x0f, 0x37,
		0xb5, 0xdf, 0x6b, 0xd7, 0xa7, 0xb7, 0x7f, 0xc8, 0x52, 0x12, 0x41, 0x42, 0x2a, 0x51, 0xa6, 0xed,
		0xf1, 0xf5, 0xe9, 0xed, 0xe9, 0x71, 0xf5, 0x4c, 0x41, 0xea, 0x6f, 0xaf, 0xfa, 0x19, 0xce, 0xab,
		0xff, 0xf7, 0xf2, 0x3a, 0xcb, 0x0f, 0xf0, 0xef, 0xea, 0xf5, 0xc5, 0xe9, 0xc5, 0xaf, 0x59, 0x7e,
		0x84, 0x6f, 0x17, 0xbf, 0x5d, 0x5c, 0xfe, 0xfb, 0x22, 0xd3, 0x64, 0x74, 0x7a, 0xa1, 0x44, 0x46,
		0x52, 0x2b, 0xeb, 0x29, 0x93, 0xfa, 0x1b, 0x67, 0xdd, 0x8c, 0x60, 0x18, 0xac, 0x9b, 0x34, 0x5b,
		0x37, 0x74, 0x6f, 0x09, 0xd6, 0x4d, 0x8c, 0x57, 0xc4, 0xd9, 0x0f, 0x2e, 0x6f, 0xd9, 0x04, 0xab,
		0x61, 0xd5, 0xc0, 0xaa, 0x81, 0x7f, 0x12, 0xfe, 0x49, 0xfd, 0x1a, 0x7c, 0x20, 0xe1, 0xfb, 0x42,
		0x07, 0x3a, 0x3c, 0xcd, 0x3a, 0x9c, 0xf2, 0x3d, 0x41, 0x8b, 0xc7, 0xd1, 0xe2, 0x76, 0x9b, 0x99,
		0x0d, 0x8f, 0x59, 0x9c, 0x29, 0x64, 0x15, 0x4c, 0xed, 0x02, 0xad, 0x0e, 0xad, 0xbe, 0x96, 0x5a,
		0xbd, 0x4f, 0xe5, 0xdc, 0x6e, 0xfc, 0xe5, 0x57, 0xf6, 0x15, 0x54, 0xbb, 0x44, 0x63, 0xed, 0xdc,
		0x37, 0x67, 0x30, 0x69, 0x35, 0xe7, 0x58, 0x8e, 0xeb, 0xb3, 0x86, 0xeb, 0x34, 0xa5, 0x48, 0x4f,
		0x6d, 0x8e, 0xb2, 0x5a, 0x8b, 0x40, 0x75, 0xad, 0x47, 0x34, 0xe7, 0x98, 0x7c, 0x80, 0x2d, 0xdd,
		0x80, 0xda, 0x9e, 0x5a, 0xef, 0x44, 0xba, 0x23, 0xa6, 0x6d, 0xbd, 0x98, 0xf6, 0x53, 0xdf, 0x24,
		0x7d, 0xff, 0xd6, 0x61, 0xa6, 0x4a, 0x02, 0xe1, 0x68, 0x03, 0x68, 0x79, 0x68, 0xf9, 0xb5, 0xd4,
		0xf2, 0x5d, 0xc7, 0x76, 0x1d, 0x15, 0xd3, 0x5d, 0x62, 0xa8, 0x92, 0xda, 0xd0, 0xa4, 0x75, 0xe8,
		0x48, 0xb6, 0xbd, 0xaa, 0x27, 0x5f, 0xfb, 0x3e, 0x49, 0x33, 0x81, 0xe9, 0xdb, 0x3f, 0xae, 0x6a,
		0x0f, 0xa7, 0x27, 0xeb, 0xdb, 0x30, 0xe9, 0xec, 0x72, 0x2d, 0xbb, 0x25, 0xd5, 0xfe, 0xdf, 0xab,
		0xdb, 0x75, 0x7c, 0xae, 0xea, 0xe9, 0x5a, 0xbe, 0xae, 0xcb, 0x5b, 0x74, 0xb6, 0xa2, 0x86, 0xc4,
		0x70, 0x73, 0xc7, 0x72, 0x9f, 0x0e, 0x20, 0x3a, 0x3c, 0xdd, 0x9a, 0x11, 0xf1, 0x5c, 0x64, 0xbc,
		0xa2, 0x57, 0xb5, 0xb9, 0xc6, 0x6f, 0x76, 0x2b, 0xdc, 0x45, 0x3b, 0xde, 0xc9, 0x14, 0xb8, 0x0b,
		0x74, 0xb6, 0xd3, 0xdd, 0xfa, 0x6b, 0xd8, 0xb9, 0x6e, 0xa9, 0xef, 0x40, 0xac, 0x5f, 0x9d, 0x78,
		0x9f, 0x3a, 0x92, 0xfe, 0x74, 0x62, 0x7d, 0xe9, 0x56, 0xd6, 0xe8, 0x69, 0x82, 0xdc, 0x08, 0x7b,
		0x3d, 0x4d, 0x10, 0x58, 0x46, 0xdb, 0x3d, 0x2d, 0xed, 0x5a, 0x24, 0x72, 0x12, 0x2a, 0x4d, 0x9f,
		0x1a, 0x2d, 0xb7, 0xf1, 0xd7, 0xf2, 0x9e, 0x4f, 0x83, 0xaf, 0x29, 0xb6, 0x7c, 0x2a, 0xd0, 0xb4,
		0x7c, 0xf2, 0xdf, 0xb2, 0xd9, 0xef, 0xa9, 0x7f, 0xdf, 0x49, 0x35, 0x7b, 0x8a, 0xd9, 0xa7, 0x47,
		0xac, 0x3f, 0x4f, 0x5a, 0xda, 0x3d, 0x2d, 0x26, 0x00, 0x59, 0x08, 0xb8, 0xfa, 0x5e, 0x4f, 0x0b,
		0x09, 0x84, 0x46, 0x07, 0xc6, 0x6e, 0xf4, 0xc4, 0xed, 0x36, 0xfb, 0xdb, 0x75, 0x98, 0x29, 0x34,
		0xa9, 0x63, 0x2a, 0x54, 0x39, 0x5e, 0xbe, 0x1e, 0xcd, 0x63, 0xe2, 0x91, 0x9d, 0xaa, 0x05, 0x92,
		0xbe, 0xee, 0x14, 0xb1, 0xc8, 0x52, 0x0f, 0x1c, 0x96, 0x6f, 0x1b, 0x33, 0x45, 0x80, 0xa6, 0xe0,
		0x10, 0x07, 0x41, 0x67, 0x72, 0xdc, 0xa7, 0x51, 0x70, 0x07, 0x28, 0xb8, 0x01, 0x14, 0x42, 0x11,
		0xa7, 0xd5, 0x8b, 0xaa, 0x71, 0x6b, 0xb7, 0x99, 0xf1, 0x5f, 0xd7, 0x61, 0xc6, 0x89, 0xc5, 0xad,
		0x47, 0xcb, 0x1f, 0x96, 0x6f, 0x1e, 0xed, 0xee, 0x7e, 0xff, 0xfe, 0x7d, 0xc7, 0xb6, 0x1c, 0x2b,
		0x30, 0x15, 0x83, 0x1c, 0x9c, 0xfe, 0x91, 0xaf, 0x3a, 0x5c, 0xa5, 0x6a, 0xa7, 0xeb, 0x89, 0x58,
		0xc9, 0x9e, 0xa5, 0xee, 0xf8, 0xd6, 0x27, 0x5a, 0x03, 0x3a, 0xab, 0xfd, 0x9b, 0x03, 0x80, 0x1b,
		0xbf, 0xe7, 0x5b, 0x4c, 0x7c, 0x7e, 0xdc, 0xdf, 0x35, 0x56, 0x93, 0x37, 0xb4, 0x6d, 0x06, 0xc8,
		0x03, 0xc8, 0x03, 0xc8, 0x03, 0xc8, 0x03, 0xc8, 0x03, 0xc8, 0x03, 0xc8, 0x03, 0xc8, 0xd3, 0x06,
		0xf2, 0x88, 0x27, 0x0f, 0x0c, 0x30, 0x5e, 0x86, 0x67, 0x0f, 0x2c, 0xf2, 0xed, 0x8a, 0x9e, 0x83,
		0x92, 0x2b, 0x7a, 0xb1, 0xcf, 0x32, 0x9e, 0xaf, 0x12, 0xce, 0xe8, 0xf4, 0x39, 0xa3, 0x9b, 0x6e,
		0xdb, 0xb2, 0x9d, 0x78, 0x20, 0x33, 0x3c, 0xdb, 0xc9, 0x45, 0xf1, 0x2c, 0x96, 0x02, 0xdc, 0xd2,
		0x59, 0xb5, 0x58, 0x62, 0x43, 0x40, 0x09, 0xf2, 0x98, 0xc6, 0x7a, 0x31, 0xbe, 0x7b, 0xc6, 0x9c,
		0xe7, 0x40, 0x66, 0xc6, 0x83, 0x60, 0x62, 0x23, 0xcd, 0xc4, 0x4d, 0x85, 0xb0, 0x24, 0x42, 0x10,
		0xe0, 0xab, 0xd6, 0x3b, 0xc8, 0xd7, 0x37, 0xf4, 0xc4, 0x66, 0xb5, 0xc9, 0x1f, 0x49, 0xa9, 0xbc,
		0x97, 0x9d, 0x43, 0x21, 0x42, 0x56, 0xf5, 0x18, 0x14, 0x7c, 0x65, 0x71, 0xce, 0x3c, 0x27, 0x36,
		0x09, 0xe7, 0xb6, 0xb6, 0xb6, 0xb6, 0xee, 0x2c, 0xf3, 0xef, 0xaa, 0xf9, 0xdf, 0x82, 0x79, 0xf8,
		0x50, 0x9f, 0xf8, 0xc7, 0xfd, 0xbd, 0xf9, 0x50, 0xcf, 0xff, 0x2c, 0x6c, 0x57, 0x8a, 0xbd, 0xfc,
		0x2f, 0xe3, 0xcf, 0xeb, 0xf7, 0xf7, 0x3b, 0xf9, 0x7f, 0xca, 0xac, 0xfa, 0x25, 0xff, 0xde, 0x5f,
		0x9b, 0xa3, 0x79, 0xd4, 0xcb, 0x9b, 0xd3, 0xff, 0x08, 0x3f, 0xef, 0x9f, 0xab, 0x78, 0xe0, 0x7f,
		0xc4, 0x78, 0x62, 0x0d, 0x3e, 0xc2, 0x17, 0xd7, 0xe7, 0x62, 0xaa, 0x37, 0x5c, 0x01, 0xbd, 0x0b,
		0xbd, 0x0b, 0xbd, 0x0b, 0xbd, 0x0b, 0xbd, 0x0b, 0xbd, 0x0b, 0xbd, 0x2b, 0xa8, 0x77, 0x5b, 0xee,
		0xb3, 0xed, 0x98, 0x8f, 0x96, 0xe3, 0x30, 0x2f, 0xbe, 0xee, 0x9d, 0x5a, 0x05, 0xfd, 0x0b, 0xfd,
		0xfb, 0xe1, 0xbc, 0x63, 0x17, 0x4a, 0xc6, 0x0c, 0x6f, 0xc8, 0xd1, 0x76, 0xdb, 0xe5, 0x4d, 0x61,
		0xd2, 0x9e, 0x5c, 0x04, 0xca, 0x06, 0x65, 0xaf, 0x8e, 0xb2, 0x57, 0xeb, 0x6e, 0x5f, 0x96, 0x63,
		0x12, 0xd7, 0xdf, 0xbe, 0x20, 0xab, 0x24, 0xa6, 0xc3, 0xbd, 0xd3, 0x8d, 0x31, 0xee, 0x37, 0xf8,
		0x56, 0x3a, 0x86, 0xfd, 0xc2, 0xd9, 0x1e, 0x23, 0xf3, 0xbb, 0xd3, 0x15, 0x48, 0xfb, 0xee, 0x74,
		0x91, 0xf3, 0x8d, 0x74, 0xa0, 0xe1, 0x17, 0x6d, 0xa7, 0xc9, 0x7e, 0x48, 0x4c, 0x07, 0x0d, 0x96,
		0x21, 0xfd, 0x47, 0xc0, 0x9a, 0x45, 0xfa, 0x8f, 0x04, 0x52, 0x98, 0xb5, 0x95, 0x56, 0x35, 0x1a,
		0x34, 0x20, 0x78, 0x4c, 0x07, 0x05, 0x63, 0xae, 0x35, 0x63, 0x0a, 0xcf, 0x05, 0x7d, 0xb1, 0xbc,
		0xe6, 0x77, 0xcb, 0x63, 0xa6, 0xed, 0x70, 0xe6, 0x79, 0xdd, 0x8e, 0x42, 0x7f, 0xee, 0x39, 0x7b,
		0xc9, 0x75, 0xfc, 0x2a, 0x66, 0xac, 0xe3, 0x97, 0x18, 0xa1, 0xab, 0x12, 0x3c, 0x19, 0xe1, 0x93,
		0x31, 0x00, 0x09, 0x23, 0x88, 0x31, 0x84, 0x84, 0xff, 0x5c, 0x8a, 0x41, 0xc2, 0x85, 0xd6, 0xeb,
		0xb3, 0xfa, 0xc0, 0x9f, 0xfe, 0x26, 0x92, 0x47, 0x2b, 0xd7, 0x0c, 0x4f, 0x99, 0x45, 0x28, 0x58,
		0x65, 0x1e, 0xcb, 0xf0, 0xb7, 0x8e, 0x54, 0x3e, 0x2a, 0x15, 0xf3, 0x90, 0x33, 0x11, 0x39, 0x33,
		0x45, 0x31, 0xd5, 0xe0, 0xe4, 0x92, 0xee, 0xdd, 0x21, 0x49, 0x35, 0xd2, 0xad, 0xf5, 0x66, 0x68,
		0xa6, 0xc3, 0xbc, 0x06, 0x73, 0xb8, 0xf5, 0xcc, 0x08, 0x5a, 0xae, 0xa9, 0x74, 0x5c, 0x53, 0xeb,
		0x87, 0x3b, 0xfa, 0x4f, 0xbd, 0x71, 0x14, 0x49, 0x7f, 0xdc, 0x70, 0x33, 0xa2, 0x3e, 0xb9, 0xe1,
		0x7e, 0xd4, 0x9d, 0x5b, 0xc7, 0xf4, 0x40, 0xd5, 0xc1, 0x55, 0x91, 0xb4, 0xa7, 0x5f, 0x05, 0x41,
		0x1f, 0xdd, 0x99, 0x57, 0x51, 0x2c, 0x6c, 0xe0, 0xcb, 0xf8, 0xb4, 0x9a, 0xd5, 0xf5, 0x84, 0x3a,
		0x1a, 0x49, 0x10, 0x5b, 0xce, 0x76, 0x7c, 0x6e, 0x39, 0x5c, 0x1d, 0x7d, 0x8c, 0x36, 0x02, 0x02,
		0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x89, 0x81,
		0x40, 0x38, 0xf3, 0x5e, 0xad, 0x16, 0x05, 0x04, 0x19, 0xee, 0x04, 0x0c, 0x02, 0x0c, 0x02, 0x0c,
		0x22, 0x4c, 0x33, 0x3e, 0xb7, 0xb8, 0xa9, 0xc8, 0x44, 0x86, 0xda, 0x60, 0xa1, 0x70, 0x0b, 0xa2,
		0x01, 0x43, 0x80, 0x35, 0x80, 0x35, 0x09, 0xc3, 0x1a, 0xf2, 0x41, 0x45, 0xc0, 0x39, 0x6b, 0x81,
		0x73, 0xda, 0x0a, 0xd4, 0x36, 0x4e, 0x99, 0xb5, 0x7e, 0x00, 0xdd, 0x00, 0xdd, 0x00, 0xdd, 0xc0,
		0xc3, 0x02, 0x28, 0x02, 0x28, 0x02, 0x0f, 0x0b, 0x90, 0x47, 0x2c, 0xe4, 0x61, 0x72, 0xbb, 0xcd,
		0x48, 0xe0, 0xc7, 0x60, 0x27, 0x60, 0x10, 0x60, 0x10, 0x60, 0x10, 0x61, 0x9a, 0x51, 0x1b, 0xd8,
		0x0c, 0xff, 0x0a, 0x40, 0x0d, 0x40, 0x0d, 0xfc, 0x2b, 0x40, 0x39, 0x73, 0x51, 0x8e, 0x02, 0xe3,
		0x8f, 0x01, 0x8e, 0xed, 0x00, 0xdb, 0x00, 0xdb, 0x00, 0xdb, 0xc0, 0xbf, 0x02, 0x28, 0x02, 0x28,
		0x02, 0xff, 0x0a, 0x90, 0x47, 0x2c, 0xe4, 0x41, 0xe5, 0x5f, 0x19, 0xed, 0x04, 0x0c, 0x02, 0x0c,
		0x02, 0x0c, 0x02, 0xff, 0x0a, 0x40, 0x0d, 0x40, 0x0d, 0xfc, 0x2b, 0x40, 0x39, 0xd4, 0x28, 0x47,
		0x6b, 0x19, 0xb4, 0xe4, 0xcc, 0xf2, 0x70, 0x7d, 0xec, 0xc6, 0x59, 0x9d, 0xae, 0xdf, 0xff, 0xbf,
		0x61, 0x17, 0x0e, 0xe5, 0x0e, 0x01, 0x86, 0x40, 0xaf, 0xad, 0x4e, 0xd7, 0xef, 0xff, 0xdf, 0x60,
		0xcc, 0xc7, 0xc3, 0xbf, 0x86, 0x97, 0x3e, 0x0d, 0xaf, 0xac, 0x6b, 0xb8, 0xbc, 0x40, 0xcb, 0x0b,
		0xbb, 0xd9, 0x62, 0xf2, 0xfd, 0x16, 0x82, 0xd5, 0xe8, 0xb0, 0xa0, 0x0f, 0x5c, 0xa2, 0xc3, 0x02,
		0x3a, 0x2c, 0xc0, 0x32, 0x83, 0x65, 0xb6, 0x19, 0x96, 0x19, 0xbc, 0xc3, 0x30, 0xa4, 0xe0, 0x1d,
		0x86, 0xdd, 0x94, 0x71, 0xbb, 0x09, 0x1d, 0x16, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x80, 0x40,
		0x80, 0x40, 0x80, 0x40, 0x80, 0x40, 0x32, 0x82, 0x40, 0xd0, 0x61, 0x01, 0x18, 0x04, 0x18, 0x04,
		0x1d, 0x16, 0x26, 0xb7, 0x40, 0x84, 0x1a, 0xb0, 0x26, 0x9b, 0xb0, 0x06, 0x11, 0x6a, 0xe0, 0x9c,
		0x79, 0x87, 0x8c, 0x0e, 0x0b, 0x40, 0x37, 0x40, 0x37, 0xf0, 0xb0, 0x00, 0x8a, 0x00, 0x8a, 0xc0,
		0xc3, 0x02, 0xe4, 0x61, 0xa0, 0xc3, 0x02, 0x30, 0x08, 0x30, 0xc8, 0x46, 0x61, 0x10, 0x54, 0x00,
		0x00, 0xd4, 0x00, 0xd4, 0xc0, 0xbf, 0x02, 0x94, 0xa3, 0x01, 0xe5, 0xa0, 0xc3, 0x02, 0xb0, 0x0d,
		0xb0, 0x0d, 0xfc, 0x2b, 0x80, 0x22, 0x80, 0x22, 0xf0, 0xaf, 0x00, 0x79, 0xa0, 0xc3, 0x02, 0x30,
		0x08, 0x30, 0x08, 0xfc, 0x2b, 0xf0, 0xaf, 0x00, 0xd4, 0x00, 0xd4, 0xc0, 0xbf, 0x02, 0x94, 0x23,
		0xb9, 0x22, 0x23, 0x1d, 0x16, 0x24, 0x7a, 0x02, 0x18, 0xd2, 0x3d, 0x15, 0x4e, 0xfb, 0x17, 0x4b,
		0x43, 0x1b, 0x05, 0xa7, 0xc9, 0x7e, 0x28, 0xf4, 0x51, 0x08, 0x96, 0xcb, 0x35, 0x52, 0x28, 0xa0,
		0x91, 0x42, 0x92, 0xd8, 0x71, 0x93, 0x1a, 0x29, 0x48, 0x23, 0xc2, 0xf0, 0x7d, 0x77, 0x9d, 0xbe,
		0xf8, 0x91, 0x78, 0xdd, 0xa3, 0x2e, 0x21, 0x87, 0x12, 0x6b, 0x87, 0xb7, 0x2d, 0x87, 0xd1, 0x08,
		0xe0, 0x2f, 0x73, 0xba, 0x6d, 0xe6, 0x0d, 0x24, 0xaf, 0x3a, 0xfc, 0x2d, 0xee, 0x2b, 0xec, 0x51,
		0x73, 0xba, 0xed, 0xfe, 0x1b, 0x4c, 0xd4, 0x92, 0x20, 0x38, 0xc2, 0xae, 0xed, 0xf0, 0xbd, 0x12,
		0xc1, 0xe9, 0x1d, 0x00, 0xec, 0x03, 0xec, 0xa7, 0x1d, 0xec, 0xef, 0x97, 0x0e, 0xf7, 0x0f, 0x2b,
		0x07, 0xa5, 0x43, 0x40, 0xfc, 0x75, 0x83, 0xf8, 0xf5, 0x14, 0x80, 0xd3, 0xbf, 0x98, 0xe7, 0xb0,
		0x96, 0x3c, 0x3a, 0x1d, 0xae, 0x47, 0x9f, 0x2f, 0xc0, 0xd3, 0x54, 0xc1, 0x53, 0xf4, 0xf9, 0x42,
		0x7c, 0x40, 0x0b, 0x13, 0x91, 0x33, 0x53, 0x14, 0x53, 0x21, 0x47, 0x01, 0x39, 0x0a, 0x40, 0xf8,
		0xc8, 0x51, 0x00, 0xb4, 0xcf, 0x20, 0xb4, 0x47, 0x9f, 0x2f, 0x20, 0x10, 0x20, 0x10, 0x20, 0x10,
		0x20, 0x10, 0x20, 0x10, 0x20, 0x10, 0x20, 0x90, 0xac, 0x20, 0x10, 0xf4, 0xf9, 0x02, 0x06, 0x01,
		0x06, 0x41, 0x9f, 0xaf, 0xc9, 0x2d, 0x90, 0x27, 0x09, 0x58, 0x93, 0x4d, 0x58, 0x83, 0x3c, 0x49,
		0xe0, 0x9c, 0x79, 0x87, 0x8c, 0x3e, 0x5f, 0x40, 0x37, 0x40, 0x37, 0xf0, 0xb0, 0x00, 0x8a, 0x00,
		0x8a, 0xc0, 0xc3, 0x02, 0xe4, 0x61, 0xa0, 0xcf, 0x17, 0x30, 0x08, 0x30, 0xc8, 0x46, 0x61, 0x10,
		0xd4, 0xa1, 0x02, 0xd4, 0x00, 0xd4, 0xc0, 0xbf, 0x02, 0x94, 0xa3, 0x01, 0xe5, 0xa0, 0xcf, 0x17,
		0xb0, 0x0d, 0xb0, 0x0d, 0xfc, 0x2b, 0x80, 0x22, 0x80, 0x22, 0xf0, 0xaf, 0x00, 0x79, 0xa0, 0xcf,
		0x17, 0x30, 0x08, 0x30, 0x08, 0xfc, 0x2b, 0xf0, 0xaf, 0x00, 0xd4, 0x00, 0xd4, 0xc0, 0xbf, 0x02,
		0x94, 0x23, 0xb9, 0x22, 0x23, 0x7d, 0xbe, 0xa4, 0xba, 0x02, 0x18, 0xd2, 0x9d, 0xbe, 0x7e, 0x1b,
		0x5c, 0x2e, 0x05, 0xed, 0x14, 0x1c, 0x5b, 0x02, 0xe3, 0x84, 0x3a, 0x33, 0x58, 0x8d, 0x56, 0x0a,
		0xfa, 0x50, 0x24, 0x5a, 0x29, 0xa0, 0x95, 0x02, 0x4c, 0x30, 0x98, 0x60, 0x9b, 0x61, 0x82, 0xc1,
		0x0d, 0x0c, 0x8b, 0x09, 0x6e, 0x60, 0x18, 0x48, 0x19, 0x37, 0x90, 0xd0, 0x4a, 0x01, 0x08, 0x04,
		0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x24, 0x23, 0x08, 0x04, 0xad,
		0x14, 0x80, 0x41, 0x80, 0x41, 0xd0, 0x4a, 0x61, 0x72, 0x0b, 0x84, 0xa2, 0x01, 0x6b, 0xb2, 0x09,
		0x6b, 0x10, 0x8a, 0x06, 0xce, 0x99, 0x77, 0xc8, 0x68, 0xa5, 0x00, 0x74, 0x03, 0x74, 0x03, 0x0f,
		0x0b, 0xa0, 0x08, 0xa0, 0x08, 0x3c, 0x2c, 0x40, 0x1e, 0x06, 0x5a, 0x29, 0x00, 0x83, 0x00, 0x83,
		0x6c, 0x14, 0x06, 0x41, 0xaa, 0x3f, 0x40, 0x0d, 0x40, 0x0d, 0xfc, 0x2b, 0x40, 0x39, 0x1a, 0x50,
		0x0e, 0x5a, 0x29, 0x00, 0xdb, 0x00, 0xdb, 0xc0, 0xbf, 0x02, 0x28, 0x02, 0x28, 0x02, 0xff, 0x0a,
		0x90, 0x07, 0x5a, 0x29, 0x00, 0x83, 0x00, 0x83, 0xc0, 0xbf, 0x02, 0xff, 0x0a, 0x40, 0x0d, 0x40,
		0x0d, 0xfc, 0x2b, 0x40, 0x39, 0x92, 0x2b, 0x32, 0xd2, 0x4a, 0x41, 0xa2, 0x27, 0x80, 0x21, 0xdd,
		0x48, 0xe1, 0xa2, 0x7f, 0xb1, 0x14, 0xb4, 0x51, 0xf0, 0xdd, 0x27, 0xfe, 0xdd, 0xf2, 0xd8, 0x20,
		0x6f, 0xd3, 0xeb, 0x76, 0xb8, 0x7c, 0x53, 0x85, 0x39, 0x7b, 0xa1, 0xc5, 0x82, 0x3e, 0x74, 0x89,
		0x16, 0x0b, 0x68, 0xb1, 0x00, 0xd3, 0x0c, 0xa6, 0xd9, 0x66, 0x98, 0x66, 0x70, 0x0f, 0xc3, 0x92,
		0x82, 0x7b, 0x18, 0x86, 0x53, 0xc6, 0x0d, 0x27, 0xb4, 0x58, 0x00, 0x02, 0x01, 0x02, 0x01, 0x02,
		0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0xc9, 0x08, 0x02, 0x41, 0x8b, 0x05, 0x60, 0x10,
		0x60, 0x10, 0xb4, 0x58, 0x98, 0xdc, 0x02, 0x21, 0x6a, 0xc0, 0x9a, 0x6c, 0xc2, 0x1a, 0x84, 0xa8,
		0x81, 0x73, 0xe6, 0x1d, 0x32, 0x5a, 0x2c, 0x00, 0xdd, 0x00, 0xdd, 0xc0, 0xc3, 0x02, 0x28, 0x02,
		0x28, 0x02, 0x0f, 0x0b, 0x90, 0x87, 0x81, 0x16, 0x0b, 0xc0, 0x20, 0xc0, 0x20, 0x1b, 0x85, 0x41,
		0x50, 0x02, 0x00, 0x50, 0x03, 0x50, 0x03, 0xff, 0x0a, 0x50, 0x8e, 0x06, 0x94, 0x83, 0x16, 0x0b,
		0xc0, 0x36, 0xc0, 0x36, 0xf0, 0xaf, 0x00, 0x8a, 0x00, 0x8a, 0xc0, 0xbf, 0x02, 0xe4, 0x81, 0x16,
		0x0b, 0xc0, 0x20, 0xc0, 0x20, 0xf0, 0xaf, 0xc0, 0xbf, 0x02, 0x50, 0x03, 0x50, 0x03, 0xff, 0x0a,
		0x50, 0x8e, 0xe4, 0x8a, 0x8c, 0xb4, 0x58, 0x50, 0xee, 0x10, 0x60, 0x48, 0x37, 0x5c, 0xb8, 0x19,
		0x5e, 0xfa, 0x34, 0xbc, 0x72, 0x0a, 0xba, 0x2f, 0x70, 0x97, 0x4b, 0x64, 0x55, 0x8f, 0x75, 0x69,
		0xb0, 0x1c, 0x3d, 0x16, 0xf4, 0xc1, 0x4b, 0xf4, 0x58, 0x40, 0x8f, 0x05, 0xd8, 0x66, 0xb0, 0xcd,
		0x36, 0xc3, 0x36, 0x83, 0x7f, 0x18, 0xa6, 0x14, 0xfc, 0xc3, 0xb0, 0x9c, 0x32, 0x6e, 0x39, 0xa1,
		0xc7, 0x02, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x48,
		0x46, 0x10, 0x08, 0x7a, 0x2c, 0x00, 0x83, 0x00, 0x83, 0xa0, 0xc7, 0xc2, 0xe4, 0x16, 0x88, 0x51,
		0x03, 0xd6, 0x64, 0x13, 0xd6, 0x20, 0x46, 0x0d, 0x9c, 0x33, 0xef, 0x90, 0xd1, 0x63, 0x01, 0xe8,
		0x06, 0xe8, 0x06, 0x1e, 0x16, 0x40, 0x11, 0x40, 0x11, 0x78, 0x58, 0x80, 0x3c, 0x0c, 0xf4, 0x58,
		0x00, 0x06, 0x01, 0x06, 0xd9, 0x28, 0x0c, 0x82, 0x1a, 0x00, 0x80, 0x1a, 0x80, 0x1a, 0xf8, 0x57,
		0x80, 0x72, 0x34, 0xa0, 0x1c, 0xf4, 0x58, 0x00, 0xb6, 0x01, 0xb6, 0x81, 0x7f, 0x05, 0x50, 0x04,
		0x50, 0x04, 0xfe, 0x15, 0x20, 0x0f, 0xf4, 0x58, 0x00, 0x06, 0x01, 0x06, 0x81, 0x7f, 0x05, 0xfe,
		0x15, 0x80, 0x1a, 0x80, 0x1a, 0xf8, 0x57, 0x80, 0x72, 0x24, 0x57, 0x64, 0xa4, 0xc7, 0x82, 0x4c,
		0x53, 0x00, 0x43, 0xba, 0xad, 0xc2, 0x6d, 0x70, 0xb5, 0x14, 0xb4, 0x52, 0xe8, 0xfa, 0xcc, 0x93,
		0xef, 0xa4, 0x10, 0xac, 0x46, 0x23, 0x05, 0x7d, 0x18, 0x12, 0x8d, 0x14, 0xd0, 0x48, 0x01, 0x06,
		0x18, 0x0c, 0xb0, 0xcd, 0x30, 0xc0, 0xe0, 0x04, 0x86, 0xbd, 0x04, 0x27, 0x30, 0xcc, 0xa3, 0x8c,
		0x9b, 0x47, 0x68, 0xa4, 0x00, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04,
		0x02, 0x04, 0x92, 0x11, 0x04, 0x82, 0x46, 0x0a, 0xc0, 0x20, 0xc0, 0x20, 0x68, 0xa4, 0x30, 0xb9,
		0x05, 0x02, 0xd1, 0x80, 0x35, 0xd9, 0x84, 0x35, 0x08, 0x44, 0x03, 0xe7, 0xcc, 0x3b, 0x64, 0x34,
		0x52, 0x00, 0xba, 0x01, 0xba, 0x81, 0x87, 0x05, 0x50, 0x04, 0x50, 0x04, 0x1e, 0x16, 0x20, 0x0f,
		0x03, 0x8d, 0x14, 0x80, 0x41, 0x80, 0x41, 0x36, 0x0a, 0x83, 0x20, 0xd1, 0x1f, 0xa0, 0x06, 0xa0,
		0x06, 0xfe, 0x15, 0xa0, 0x1c, 0x0d, 0x28, 0x07, 0x8d, 0x14, 0x80, 0x6d, 0x80, 0x6d, 0xe0, 0x5f,
		0x01, 0x14, 0x01, 0x14, 0x81, 0x7f, 0x05, 0xc8, 0x03, 0x8d, 0x14, 0x80, 0x41, 0x80, 0x41, 0xe0,
		0x5f, 0x81, 0x7f, 0x05, 0xa0, 0x06, 0xa0, 0x06, 0xfe, 0x15, 0xa0, 0x1c, 0xc9, 0x15, 0x19, 0x69,
		0xa4, 0x20, 0xd1, 0x13, 0xc0, 0x90, 0xee, 0xa3, 0xf0, 0xad, 0x7f, 0xb1, 0x14, 0xb4, 0x51, 0xf8,
		0x6e, 0xd9, 0x5c, 0xbe, 0x8d, 0x42, 0xb0, 0x1a, 0x6d, 0x14, 0xf4, 0x21, 0x48, 0xb4, 0x51, 0x40,
		0x1b, 0x05, 0x98, 0x5f, 0x30, 0xbf, 0x36, 0xc3, 0xfc, 0x82, 0x0b, 0x18, 0xd6, 0x12, 0x5c, 0xc0,
		0x30, 0x8e, 0x32, 0x6e, 0x1c, 0xa1, 0x8d, 0x02, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08,
		0x10, 0x08, 0x10, 0x08, 0x10, 0x48, 0x46, 0x10, 0x08, 0xda, 0x28, 0x00, 0x83, 0x00, 0x83, 0xa0,
		0x8d, 0xc2, 0xe4, 0x16, 0x08, 0x43, 0x03, 0xd6, 0x64, 0x13, 0xd6, 0x20, 0x0c, 0x0d, 0x9c, 0x33,
		0xef, 0x90, 0xd1, 0x46, 0x01, 0xe8, 0x06, 0xe8, 0x06, 0x1e, 0x16, 0x40, 0x11, 0x40, 0x11, 0x78,
		0x58, 0x80, 0x3c, 0x0c, 0xb4, 0x51, 0x00, 0x06, 0x01, 0x06, 0xd9, 0x28, 0x0c, 0x82, 0x34, 0x7f,
		0x80, 0x1a, 0x80, 0x1a, 0xf8, 0x57, 0x80, 0x72, 0x34, 0xa0, 0x1c, 0xb4, 0x51, 0x00, 0xb6, 0x01,
		0xb6, 0x81, 0x7f, 0x05, 0x50, 0x04, 0x50, 0x04, 0xfe, 0x15, 0x20, 0x0f, 0xb4, 0x51, 0x00, 0x06,
		0x01, 0x06, 0x81, 0x7f, 0x05, 0xfe, 0x15, 0x80, 0x1a, 0x80, 0x1a, 0xf8, 0x57, 0x80, 0x72, 0x24,
		0x57, 0x64, 0xa4, 0x8d, 0x82, 0x44, 0x4f, 0x00, 0x43, 0xba, 0x8d, 0xc2, 0xbf, 0xfb, 0x17, 0xd3,
		0xd5, 0x46, 0xe1, 0x13, 0xe1, 0x5b, 0x91, 0x7d, 0x1b, 0x92, 0x6f, 0x41, 0xe0, 0x05, 0x48, 0x1d,
		0x7c, 0xbc, 0x33, 0x5f, 0x7e, 0x82, 0x8b, 0xbf, 0xb1, 0xe4, 0x6c, 0xfb, 0x78, 0x70, 0x90, 0x70,
		0xde, 0x64, 0xcb, 0xa0, 0x60, 0xee, 0xcc, 0xf6, 0x79, 0x95, 0xf3, 0x78, 0x9d, 0x01, 0xfa, 0xea,
		0xb5, 0xd6, 0x62, 0x7d, 0x24, 0x17, 0x53, 0x40, 0xf6, 0xb5, 0xc0, 0xc4, 0x0a, 0x39, 0xf1, 0x9d,
		0xbb, 0xf4, 0x9a, 0xcc, 0x63, 0xcd, 0x2f, 0xfd, 0xc7, 0x72, 0xba, 0xad, 0x96, 0xd2, 0xe9, 0x08,
		0x52, 0x9c, 0x30, 0xa5, 0xc5, 0xa0, 0x31, 0x41, 0xda, 0x5a, 0x4c, 0x55, 0xd1, 0xb4, 0x32, 0xff,
		0x2f, 0x11, 0xe7, 0x13, 0xf7, 0x5c, 0x84, 0xce, 0x63, 0xc1, 0x59, 0x08, 0x9c, 0xc1, 0xfc, 0xe7,
		0x9f, 0x7d, 0xba, 0x39, 0x4f, 0x96, 0x6b, 0x3a, 0x7e, 0xe4, 0xe3, 0x84, 0xc0, 0xbc, 0xff, 0xa5,
		0x88, 0x53, 0x59, 0xdc, 0x96, 0x65, 0xa9, 0x4d, 0x1a, 0xc7, 0xe6, 0x8c, 0xdf, 0x4e, 0x25, 0xae,
		0xc5, 0x28, 0x6c, 0x11, 0x0a, 0x5b, 0x7c, 0x42, 0xed, 0x4e, 0xc4, 0xe8, 0x70, 0x59, 0x9b, 0x92,
		0x5c, 0x63, 0x74, 0xe6, 0x4b, 0x0e, 0x61, 0x74, 0xac, 0xc3, 0xef, 0x2f, 0x13, 0x9a, 0xb1, 0xfa,
		0xef, 0xc4, 0x76, 0x42, 0x88, 0x38, 0x1b, 0xc4, 0xfb, 0xe9, 0x88, 0xba, 0x0e, 0xa4, 0x5d, 0x04,
		0xd2, 0xae, 0x00, 0xa9, 0x7e, 0x38, 0x6a, 0x6a, 0x2f, 0x6e, 0x7f, 0x9b, 0x9c, 0xcf, 0x2c, 0xaf,
		0xf1, 0x12, 0xff, 0xf0, 0xc2, 0x0a, 0x94, 0xc1, 0xba, 0x98, 0x07, 0x20, 0xe6, 0xed, 0x12, 0xf6,
		0x6e, 0xc9, 0x78, 0xb3, 0xe4, 0x1b, 0x37, 0xc9, 0xfa, 0xaa, 0x94, 0x7d, 0x53, 0xca, 0xbe, 0x28,
		0xa5, 0xc6, 0x4c, 0xb4, 0x58, 0x57, 0xd8, 0x93, 0x34, 0x56, 0x50, 0x6e, 0xdb, 0xb2, 0x1d, 0x33,
		0x50, 0x96, 0x02, 0x2f, 0x6d, 0x24, 0xd3, 0x04, 0x5c, 0x45, 0xb9, 0x33, 0xe6, 0x3c, 0x07, 0xaa,
		0x5d, 0xcc, 0x97, 0x23, 0x61, 0x48, 0xa9, 0xf8, 0x6a, 0xc6, 0x0e, 0x01, 0x49, 0xaf, 0x1e, 0x95,
		0xb5, 0xaf, 0x6e, 0xdd, 0xcb, 0xf8, 0xf4, 0x55, 0x7c, 0x2b, 0xe1, 0xd1, 0x95, 0xca, 0x7b, 0xd9,
		0x3f, 0x3c, 0x4d, 0x46, 0x6e, 0x5d, 0x80, 0x63, 0xae, 0x2c, 0xce, 0x99, 0xe7, 0x08, 0xb3, 0x4c,
		0x6e, 0x6b, 0x6b, 0x6b, 0xeb, 0xce, 0x32, 0xff, 0xae, 0x9a, 0xff, 0x2d, 0x98, 0x87, 0x0f, 0xf5,
		0x89, 0x7f, 0xdc, 0xdf, 0x9b, 0x0f, 0xf5, 0xfc, 0xcf, 0xc2, 0x76, 0xa5, 0xd8, 0xcb, 0xff, 0x32,
		0xfe, 0xbc, 0x7e, 0x7f, 0xbf, 0x93, 0xff, 0xa7, 0xcc, 0xaa, 0x5f, 0xf2, 0xef, 0xfd, 0xb5, 0x39,
		0x3d, 0x47, 0x70, 0x79, 0x73, 0xfa, 0x1f, 0xe9, 0x73, 0xf8, 0x73, 0x15, 0x07, 0xf1, 0x0f, 0x81,
		0x93, 0x20, 0xd5, 0x02, 0x42, 0x16, 0xb7, 0xbc, 0xe5, 0x4d, 0x6a, 0x81, 0xcf, 0xb5, 0xc4, 0x25,
		0x9b, 0x63, 0x4a, 0xf4, 0x13, 0x55, 0x89, 0x94, 0x4d, 0x22, 0x10, 0x77, 0x70, 0xf7, 0xe6, 0xe3,
		0x9b, 0x8c, 0x27, 0x8e, 0x22, 0x2a, 0x36, 0x85, 0x46, 0xba, 0x3a, 0x9b, 0x9d, 0xa6, 0xc2, 0x13,
		0xa5, 0xcb, 0xd7, 0xd2, 0x74, 0xfc, 0xdd, 0x58, 0x66, 0x9d, 0x80, 0xa7, 0xe1, 0xc4, 0xf1, 0x1f,
		0x86, 0x20, 0x5c, 0xd6, 0xdf, 0xb2, 0xc0, 0x72, 0x7f, 0x71, 0x7d, 0x6e, 0x32, 0x87, 0x7b, 0x36,
		0xf3, 0xe3, 0x9b, 0xae, 0x53, 0xab, 0x60, 0xc0, 0xc2, 0x80, 0xfd, 0x40, 0x4c, 0x6f, 0xe2, 0x46,
		0xec, 0xc4, 0x5a, 0x31, 0x43, 0xb6, 0x08, 0x43, 0x16, 0x86, 0xac, 0x18, 0xa1, 0x8a, 0xba, 0xec,
		0xd4, 0x5c, 0x78, 0x8a, 0x84, 0x2b, 0x4d, 0xc0, 0x2a, 0x84, 0xac, 0x4e, 0xd0, 0x14, 0x18, 0xc9,
		0x40, 0x4b, 0x6d, 0x29, 0x5b, 0x5c, 0xa1, 0xa5, 0x76, 0xcb, 0xb6, 0x7c, 0x82, 0xa6, 0xda, 0xc1,
		0x36, 0x48, 0xc7, 0x93, 0x67, 0x1b, 0x2a, 0xf6, 0x21, 0x67, 0x23, 0x72, 0x76, 0x22, 0x65, 0x2b,
		0x39, 0xf6, 0x52, 0x70, 0x79, 0x19, 0xd4, 0xcd, 0xa4, 0x3c, 0xdb, 0x79, 0x26, 0xc8, 0xc2, 0x2b,
		0x7e, 0x4e, 0xf4, 0x04, 0xa4, 0x9c, 0x07, 0x74, 0xce, 0x04, 0xad, 0xce, 0x85, 0x85, 0xce, 0x86,
		0xa5, 0x61, 0x7f, 0x3a, 0x0a, 0x95, 0x71, 0xc8, 0xf6, 0x51, 0xf5, 0xd0, 0xc0, 0x54, 0x14, 0xe9,
		0xe1, 0x4e, 0x90, 0xea, 0x90, 0xea, 0x90, 0xea, 0xd9, 0x92, 0xea, 0xc9, 0xb4, 0x24, 0xed, 0xbc,
		0xee, 0x9b, 0x56, 0xb3, 0xe9, 0x31, 0x9f, 0x00, 0x42, 0x4e, 0xed, 0x06, 0x99, 0x03, 0x99, 0x03,
		0x99, 0x93, 0x34, 0xff, 0x18, 0x92, 0xb1, 0xfa, 0x59, 0x3e, 0x90, 0x8c, 0xc0, 0xcd, 0x6c, 0xb4,
		0x75, 0x57, 0x30, 0x0f, 0xeb, 0xef, 0x77, 0x45, 0xf3, 0xb0, 0x3e, 0xf8, 0xb5, 0x18, 0xfc, 0xf8,
		0x59, 0xea, 0xbd, 0x97, 0xee, 0x0a, 0xe6, 0xfe, 0xf0, 0xd3, 0x52, 0xf9, 0xae, 0x60, 0x96, 0xeb,
		0xf9, 0xad, 0xfb, 0xfb, 0x1d, 0xd1, 0x35, 0xf9, 0x9f, 0x7b, 0x3d, 0x79, 0x72, 0xa9, 0xab, 0x1c,
		0x93, 0x4a, 0xb4, 0x72, 0x66, 0xb7, 0x3f, 0xb7, 0x92, 0x3a, 0x2d, 0x91, 0x98, 0xe5, 0xcc, 0x79,
		0xc1, 0x4c, 0x81, 0x99, 0xd2, 0x17, 0x56, 0x15, 0x52, 0xe8, 0x50, 0x01, 0x74, 0x00, 0x74, 0x00,
		0x74, 0x58, 0x19, 0xff, 0xa4, 0x10, 0x3a, 0x04, 0x9a, 0xcd, 0x32, 0x9f, 0xaa, 0xe6, 0xd7, 0xfa,
		0xcf, 0xe2, 0xf6, 0x7e, 0xef, 0x28, 0xff, 0xf3, 0xa0, 0xf7, 0xf1, 0xc3, 0xf7, 0x79, 0x5f, 0x2b,
		0x6e, 0x1f, 0xf4, 0x8e, 0x22, 0xfe, 0x52, 0xe9, 0x1d, 0xc5, 0xdc, 0xa3, 0xdc, 0xdb, 0x9a, 0xf9,
		0x6a, 0xff, 0xf3, 0x52, 0xd4, 0x82, 0xfd, 0x88, 0x05, 0x7b, 0x51, 0x0b, 0xf6, 0x22, 0x16, 0x44,
		0xde, 0x52, 0x29, 0x62, 0x41, 0xb9, 0xf7, 0x3e, 0xf3, 0xfd, 0xad, 0xf9, 0x5f, 0xad, 0xf4, 0xf2,
		0xef, 0x51, 0x7f, 0x3b, 0xe8, 0xbd, 0x1f, 0xe5, 0xf3, 0x6b, 0x04, 0xa6, 0x40, 0x3e, 0xc9, 0x93,
		0x0f, 0xc0, 0x25, 0xc0, 0xa5, 0xe4, 0x8a, 0xb4, 0x96, 0xe0, 0x36, 0x1d, 0x7f, 0x77, 0x32, 0x85,
		0x6a, 0xfc, 0x8f, 0xb7, 0x5d, 0xa9, 0x94, 0x02, 0x43, 0x2c, 0x9d, 0xec, 0x5f, 0xae, 0xcf, 0x6b,
		0x83, 0x4b, 0x87, 0xbf, 0xbf, 0xc5, 0x4a, 0x32, 0x93, 0x7f, 0x1f, 0x22, 0x53, 0xce, 0xa5, 0xa3,
		0x16, 0xaa, 0xd1, 0x0a, 0x49, 0xd8, 0x8f, 0xd4, 0x0c, 0xa4, 0x66, 0x68, 0x87, 0xe9, 0xe1, 0xfb,
		0x6e, 0x31, 0xeb, 0xc9, 0x63, 0x4f, 0x32, 0x2f, 0x7c, 0x84, 0xc8, 0x0f, 0x24, 0xd6, 0x5e, 0x0d,
		0xc5, 0xda, 0xce, 0xce, 0x50, 0x46, 0xed, 0x86, 0x4c, 0x96, 0x02, 0x91, 0x31, 0x28, 0xa3, 0x97,
		0x96, 0x17, 0xa2, 0x55, 0xf8, 0x06, 0x45, 0x1e, 0x57, 0x09, 0xc2, 0x02, 0xc2, 0x62, 0xe1, 0x1d,
		0x22, 0x8f, 0x0b, 0x2e, 0x34, 0xb8, 0xd0, 0x32, 0xe8, 0x42, 0x43, 0x1e, 0x17, 0x6c, 0x58, 0xc2,
		0x77, 0x83, 0x3c, 0x2e, 0x48, 0x75, 0x48, 0x75, 0x48, 0x75, 0xe4, 0x71, 0x41, 0xe6, 0x40, 0xe6,
		0x6c, 0x94, 0xcc, 0x41, 0x1e, 0x17, 0xf2, 0xb8, 0x90, 0xc7, 0x05, 0x33, 0x05, 0x79, 0x5c, 0x80,
		0x0e, 0x80, 0x0e, 0x80, 0x0e, 0xc9, 0xf2, 0x8f, 0x81, 0x3c, 0x2e, 0x24, 0xe2, 0x20, 0x8f, 0x0b,
		0xe4, 0x83, 0x3c, 0x2e, 0x80, 0x4b, 0x4a, 0x70, 0xb9, 0xf6, 0x79, 0x5c, 0x32, 0x19, 0x05, 0x06,
		0x45, 0x1a, 0x97, 0x40, 0xc3, 0x7f, 0xf1, 0xb7, 0x41, 0xdb, 0xaf, 0x67, 0x38, 0x10, 0x40, 0x30,
		0x24, 0xb1, 0x3e, 0x9d, 0x0a, 0x63, 0x33, 0x5c, 0x5a, 0xa6, 0x56, 0x2c, 0x20, 0x78, 0xfa, 0x11,
		0x16, 0x91, 0x24, 0x9e, 0x5b, 0xfb, 0x1e, 0x82, 0x02, 0xfd, 0xf5, 0xe4, 0x0f, 0x54, 0x47, 0x3b,
		0x41, 0x9f, 0x79, 0xaf, 0xcc, 0x13, 0xe8, 0x24, 0x38, 0x5a, 0x80, 0x26, 0x82, 0x68, 0x22, 0x38,
		0x49, 0x42, 0x32, 0x5d, 0xf0, 0x83, 0x75, 0x68, 0x1e, 0x98, 0xa0, 0x1f, 0x67, 0xa3, 0x9b, 0x07,
		0xca, 0xfa, 0x39, 0xc7, 0xd9, 0x75, 0x52, 0xae, 0x19, 0xe4, 0xa8, 0xaf, 0xc4, 0x55, 0x89, 0x1c,
		0x75, 0x91, 0xf7, 0x9d, 0x9a, 0x1c, 0xf5, 0x11, 0x8f, 0xa5, 0x20, 0x45, 0x1d, 0xcd, 0x46, 0x21,
		0x2d, 0xd6, 0x51, 0x5a, 0xc8, 0x27, 0xa9, 0x53, 0x05, 0x0a, 0x11, 0x23, 0x44, 0x8c, 0x70, 0x45,
		0xac, 0x25, 0xef, 0x02, 0x35, 0x52, 0x12, 0x23, 0xa4, 0x8c, 0x10, 0x1e, 0x2a, 0xec, 0x31, 0x7c,
		0xa6, 0x95, 0x8f, 0xea, 0x26, 0x4e, 0xbc, 0x9a, 0x39, 0xa3, 0xcf, 0x04, 0x7b, 0x51, 0xc5, 0xc3,
		0xc2, 0x0d, 0xd3, 0x9f, 0x90, 0x35, 0xfa, 0xaf, 0x4e, 0x71, 0x7c, 0x94, 0x31, 0xc5, 0x70, 0xd7,
		0x6c, 0x24, 0x6a, 0x85, 0xe7, 0xa8, 0x36, 0xac, 0x7b, 0x3b, 0x45, 0x6c, 0x5a, 0xd9, 0x1c, 0x36,
		0x45, 0xf4, 0x3a, 0x73, 0xc9, 0x0f, 0x99, 0x11, 0x5c, 0x20, 0xab, 0x4c, 0x25, 0x45, 0x10, 0x09,
		0xf2, 0xa4, 0x93, 0x32, 0x12, 0xc9, 0x43, 0xed, 0xb8, 0x1e, 0x57, 0x37, 0x2b, 0x83, 0x5d, 0x24,
		0x11, 0xfa, 0x09, 0x7b, 0xb2, 0xba, 0x2d, 0xae, 0xc4, 0xa4, 0xb9, 0xf2, 0x9e, 0x1c, 0x79, 0xd4,
		0x61, 0x08, 0xc3, 0x10, 0x86, 0x21, 0x2c, 0xcc, 0xec, 0xa6, 0xd3, 0x6d, 0x3f, 0x0a, 0x4f, 0x81,
		0x9c, 0xc7, 0x42, 0x15, 0x85, 0x2d, 0xae, 0x2d, 0xe7, 0x39, 0x15, 0x96, 0xb0, 0xca, 0x20, 0xe4,
		0x99, 0xcd, 0x46, 0xd3, 0x7d, 0x0b, 0xdb, 0x34, 0xfb, 0x51, 0xcd, 0xfa, 0x9d, 0x25, 0x08, 0xd5,
		0xd9, 0xbf, 0xc4, 0xb6, 0x92, 0xa1, 0x3a, 0x58, 0x39, 0xf2, 0x55, 0x54, 0xca, 0xe5, 0xbd, 0xf2,
		0xe6, 0xbd, 0x8e, 0x75, 0xc7, 0x4b, 0x6b, 0x93, 0x5a, 0x39, 0xcc, 0x0d, 0x1a, 0xfe, 0x4c, 0xa4,
		0x33, 0xde, 0xcd, 0xe0, 0x92, 0xc3, 0x9f, 0x29, 0x6a, 0x89, 0x87, 0xfe, 0x56, 0x9a, 0x61, 0x1f,
		0x42, 0x87, 0x2b, 0x90, 0x26, 0x08, 0x1d, 0xc2, 0x62, 0x82, 0xc5, 0x84, 0xd0, 0x21, 0x42, 0x87,
		0xb1, 0xce, 0x08, 0xa1, 0x43, 0x35, 0x4f, 0x29, 0x42, 0x87, 0x08, 0x1d, 0x22, 0x74, 0x88, 0x18,
		0x0f, 0x42, 0x87, 0x08, 0x1d, 0x22, 0x74, 0x88, 0xd0, 0xe1, 0x3c, 0x8a, 0x46, 0xe8, 0x10, 0x86,
		0x30, 0x0c, 0x61, 0x18, 0xc2, 0x82, 0xcc, 0x8e, 0xd0, 0xe1, 0xd4, 0x8d, 0x20, 0x74, 0x88, 0xd0,
		0xe1, 0x1a, 0xbe, 0x0e, 0x84, 0x0e, 0xe5, 0x89, 0x73, 0x95, 0xa1, 0xc3, 0x04, 0x9a, 0xb1, 0x7c,
		0x88, 0x1c, 0x66, 0xaf, 0x0b, 0x8b, 0x98, 0x23, 0x64, 0x7d, 0x9a, 0xb0, 0x48, 0x46, 0x54, 0xbb,
		0xbe, 0xb0, 0xb6, 0x57, 0x81, 0x85, 0x93, 0x50, 0xd0, 0x1d, 0xdc, 0xbd, 0xf9, 0xf8, 0x26, 0x43,
		0xd2, 0x14, 0x10, 0x70, 0x0a, 0xf6, 0x05, 0x27, 0x91, 0x09, 0x4a, 0x67, 0x3f, 0xb8, 0x67, 0x99,
		0x5d, 0xc7, 0xe7, 0xd6, 0x63, 0x4b, 0xec, 0x3d, 0x4c, 0x1e, 0xba, 0x28, 0xbe, 0x52, 0x08, 0x67,
		0x4b, 0x50, 0x99, 0x41, 0x1c, 0xcc, 0x56, 0xa2, 0x36, 0x43, 0x5b, 0x40, 0x5b, 0x9c, 0xea, 0x24,
		0x34, 0xdc, 0x27, 0x5a, 0x0d, 0x9d, 0xa6, 0x36, 0x4e, 0xd3, 0x1a, 0x52, 0x4f, 0xf7, 0xa6, 0x69,
		0x9d, 0xb8, 0xfe, 0x6d, 0x9b, 0xe2, 0x35, 0x33, 0x92, 0x3b, 0x44, 0x2d, 0xdd, 0x9a, 0x62, 0x25,
		0x15, 0x09, 0x25, 0x11, 0x09, 0x77, 0x6a, 0x2a, 0xa1, 0x53, 0x13, 0xb9, 0x83, 0x25, 0xb1, 0x4e,
		0x4d, 0x96, 0xd7, 0x78, 0x91, 0xe9, 0xd4, 0x14, 0xac, 0x13, 0xeb, 0xd4, 0x54, 0x40, 0xa7, 0x26,
		0x74, 0x6a, 0x92, 0xf4, 0xdc, 0x85, 0xef, 0xab, 0xe9, 0xb6, 0x2d, 0xdb, 0x31, 0x05, 0xe7, 0x5f,
		0xc9, 0x04, 0x76, 0x73, 0x67, 0xcc, 0x79, 0x0e, 0x74, 0x86, 0x76, 0xac, 0xa8, 0xe2, 0x6b, 0x0b,
		0x1d, 0x3a, 0x45, 0x49, 0x48, 0x46, 0xe5, 0xbc, 0x51, 0x77, 0xd6, 0xc8, 0x04, 0x7b, 0x54, 0x7c,
		0x63, 0xe1, 0xd1, 0x95, 0xca, 0x7b, 0xd9, 0x3f, 0x3c, 0x5d, 0xb8, 0x58, 0x80, 0x63, 0x64, 0x83,
		0xd3, 0xb9, 0xad, 0xad, 0xad, 0xad, 0x3b, 0xcb, 0xfc, 0xbb, 0x6a, 0xfe, 0xb7, 0x60, 0x1e, 0x3e,
		0xd4, 0x27, 0xfe, 0x71, 0x7f, 0x6f, 0x3e, 0xd4, 0xf3, 0x3f, 0x0b, 0xdb, 0x95, 0x62, 0x2f, 0xff,
		0xcb, 0xf8, 0xf3, 0xfa, 0xfd, 0xfd, 0x4e, 0xfe, 0x9f, 0x32, 0xab, 0x7e, 0xc9, 0xbf, 0xf7, 0xd7,
		0xe6, 0xf4, 0x1c, 0x81, 0x4a, 0x90, 0x3e, 0xf7, 0xe7, 0x2a, 0x0e, 0x42, 0x20, 0x0c, 0x4d, 0x6b,
		0x24, 0xc1, 0x01, 0x05, 0x07, 0x54, 0x6a, 0x1c, 0x50, 0x59, 0x36, 0x5a, 0x63, 0xfa, 0xc6, 0x45,
		0x4c, 0xd6, 0xe5, 0xce, 0xef, 0x05, 0x06, 0xeb, 0x27, 0x81, 0x13, 0x8a, 0x7b, 0x32, 0x22, 0x27,
		0x92, 0x5b, 0x68, 0x31, 0xc7, 0x3c, 0x83, 0xf9, 0x4f, 0x3f, 0xfb, 0x6c, 0x73, 0x9e, 0x2b, 0xd7,
		0xb2, 0x1b, 0xcc, 0xf1, 0xa3, 0xd9, 0x74, 0xdc, 0x65, 0x71, 0xf8, 0xc5, 0x88, 0xb3, 0x59, 0x6c,
		0x8a, 0x2f, 0xb5, 0x94, 0xe2, 0x58, 0x46, 0x93, 0x96, 0xd0, 0xe2, 0xbb, 0x11, 0x91, 0x3f, 0xc2,
		0xd6, 0x8e, 0xb0, 0x4c, 0xf9, 0x68, 0xcd, 0x8c, 0xee, 0x9d, 0x88, 0x2a, 0x97, 0x99, 0xd0, 0xa3,
		0x37, 0x27, 0xd0, 0x28, 0x3b, 0x5c, 0x91, 0x8d, 0x4e, 0xd9, 0xcb, 0x89, 0x21, 0xbb, 0x3e, 0x98,
		0xa5, 0xc4, 0x92, 0xb0, 0x1f, 0x66, 0x99, 0xbc, 0x90, 0x94, 0x1f, 0x92, 0xa4, 0xb5, 0x32, 0x4f,
		0x8c, 0xd8, 0xd3, 0xac, 0x97, 0x37, 0x26, 0x36, 0x49, 0xea, 0xf1, 0xc8, 0x08, 0xf7, 0xce, 0x46,
		0x2f, 0x5c, 0xad, 0x84, 0x4d, 0x01, 0xf8, 0x8d, 0x4c, 0x14, 0xb5, 0x0a, 0x13, 0xbe, 0xa4, 0xc7,
		0x23, 0xb1, 0xc2, 0xd6, 0xc6, 0xd0, 0x8f, 0xa3, 0x5a, 0xd7, 0x3a, 0xd8, 0x67, 0x95, 0x29, 0xc8,
		0x81, 0x27, 0x0a, 0x59, 0xc8, 0x2b, 0x61, 0x7c, 0x2a, 0x01, 0x40, 0x2e, 0x08, 0xc8, 0x05, 0x02,
		0xb9, 0x60, 0x90, 0x13, 0x10, 0x0a, 0x5e, 0x68, 0x83, 0x36, 0x1b, 0xf9, 0xd1, 0x75, 0x5b, 0xcc,
		0x72, 0x28, 0x6a, 0x72, 0x8b, 0x29, 0xae, 0xd3, 0x18, 0xbe, 0x5f, 0xb3, 0x69, 0x71, 0x4b, 0x5d,
		0x5c, 0x4e, 0xed, 0x06, 0xe1, 0x03, 0xe1, 0x03, 0xe1, 0x23, 0xe7, 0x94, 0x76, 0x6c, 0xd7, 0x41,
		0x3b, 0x80, 0x0f, 0x12, 0xd9, 0x76, 0x2c, 0xef, 0x8d, 0xb0, 0xc2, 0xf8, 0x70, 0x4d, 0x0a, 0xb0,
		0x7d, 0xee, 0xd9, 0xce, 0x33, 0x69, 0xe9, 0x35, 0x2a, 0x1a, 0x23, 0x35, 0xa5, 0xdd, 0xa4, 0xd3,
		0x93, 0x76, 0x13, 0x5a, 0x12, 0x5a, 0x12, 0x5a, 0x72, 0x45, 0x72, 0x4f, 0x51, 0xde, 0x6d, 0x6a,
		0x65, 0xd0, 0x90, 0xe0, 0x46, 0x3f, 0xfd, 0xf0, 0x03, 0xdd, 0xad, 0x05, 0xcf, 0x06, 0xd7, 0x19,
		0xfd, 0xf4, 0xc3, 0x0f, 0xd2, 0xd3, 0x60, 0x50, 0x41, 0x4b, 0xa8, 0x6b, 0x87, 0xac, 0xce, 0x34,
		0x84, 0x67, 0x56, 0x83, 0x74, 0xc7, 0x6c, 0xc3, 0xf9, 0x24, 0x3b, 0x33, 0xdb, 0x70, 0x82, 0xdd,
		0xd0, 0xa1, 0x54, 0x4a, 0x6c, 0x94, 0x20, 0x36, 0x20, 0x36, 0x62, 0xdd, 0x25, 0x02, 0x3a, 0x08,
		0xe8, 0xc0, 0x5a, 0x84, 0xb5, 0xb8, 0x02, 0x6b, 0x71, 0x43, 0x02, 0x3a, 0x4d, 0xe6, 0x37, 0x3c,
		0xbb, 0x23, 0x6d, 0x05, 0x4e, 0x9d, 0xd9, 0xe4, 0x66, 0x10, 0x3d, 0x10, 0x3d, 0x10, 0x3d, 0x9b,
		0xe2, 0xa8, 0x92, 0x90, 0x3c, 0xec, 0x47, 0xc7, 0xf6, 0x02, 0xf7, 0x93, 0xd9, 0x94, 0xb1, 0x61,
		0x66, 0x8e, 0xed, 0xe3, 0x86, 0x90, 0x40, 0x90, 0x40, 0x90, 0x40, 0x52, 0x74, 0xd3, 0xb5, 0x1d,
		0x5e, 0xd9, 0x27, 0x90, 0x40, 0x9f, 0xd1, 0x56, 0xef, 0xc3, 0x66, 0x68, 0xab, 0xa7, 0xf4, 0x2a,
		0x74, 0xb4, 0xd5, 0x53, 0xab, 0x2a, 0x5c, 0x97, 0xb7, 0x83, 0x18, 0xfe, 0x7c, 0x88, 0xc2, 0x9a,
		0x44, 0xd0, 0x84, 0x21, 0x7a, 0x0f, 0x48, 0x02, 0x48, 0x02, 0x7f, 0xcc, 0xa2, 0x7b, 0xb4, 0x1d,
		0xb3, 0xeb, 0x13, 0x18, 0x43, 0xc3, 0x7d, 0x20, 0x70, 0x20, 0x70, 0x20, 0x70, 0x20, 0x70, 0x16,
		0x08, 0x1c, 0xdf, 0xef, 0x32, 0x22, 0x0f, 0xcc, 0xc4, 0x5e, 0x10, 0x3c, 0x10, 0x3c, 0x10, 0x3c,
		0x70, 0xbe, 0xc0, 0xf9, 0x02, 0xe7, 0x0b, 0x9c, 0x2f, 0x70, 0xbe, 0xa0, 0xd4, 0x10, 0xe0, 0x04,
		0xe0, 0x64, 0x0d, 0xc0, 0x09, 0x4a, 0x0d, 0xe7, 0x98, 0x8a, 0x28, 0x35, 0x9c, 0x7f, 0x30, 0x28,
		0x35, 0x4c, 0x52, 0x53, 0xa2, 0xd4, 0x10, 0x5a, 0x12, 0x5a, 0x12, 0x19, 0x5c, 0x49, 0xc9, 0x9d,
		0x57, 0xab, 0x45, 0x21, 0x72, 0x06, 0xdb, 0x40, 0xda, 0x40, 0xda, 0x40, 0xda, 0xc8, 0xc1, 0xcf,
		0x0c, 0x46, 0x2a, 0xd6, 0xbb, 0xb2, 0x59, 0xf3, 0xe4, 0xc3, 0xc8, 0xc2, 0xe6, 0xec, 0xcd, 0x3f,
		0x14, 0xc6, 0x9b, 0xeb, 0xd3, 0x81, 0xde, 0xe9, 0xb6, 0x5a, 0x99, 0x1a, 0x60, 0x16, 0x45, 0xee,
		0xf4, 0x63, 0xcc, 0xa2, 0x08, 0x7c, 0xbd, 0x87, 0x99, 0x7d, 0x3c, 0x5f, 0xba, 0xf6, 0xf0, 0x1f,
		0xcf, 0x33, 0x9b, 0x5d, 0xe2, 0x63, 0xb4, 0x3a, 0x17, 0x3a, 0x0e, 0xa5, 0x6e, 0xf1, 0xee, 0xf3,
		0x73, 0x1f, 0xe2, 0x2f, 0xef, 0x16, 0x3f, 0xfc, 0x62, 0x4a, 0xba, 0xc5, 0xbb, 0xcf, 0xd9, 0xec,
		0x14, 0xef, 0x3e, 0x27, 0xd6, 0x25, 0xbe, 0xe1, 0x3a, 0xbe, 0xdb, 0x12, 0x98, 0xd0, 0x37, 0x5a,
		0x90, 0x91, 0x1e, 0xf1, 0xee, 0xf3, 0x7a, 0xf6, 0x87, 0x77, 0x9f, 0x53, 0xd3, 0x1b, 0x5e, 0xb0,
		0xd1, 0xb6, 0x5c, 0x83, 0xed, 0xd4, 0x77, 0x86, 0x77, 0x9f, 0x37, 0xb3, 0x2b, 0xbc, 0xfb, 0xbc,
		0xaa, 0x8e, 0xf0, 0xda, 0x11, 0xe0, 0x40, 0x99, 0xed, 0x0e, 0x25, 0x9e, 0x78, 0x07, 0xa7, 0xb8,
		0x0a, 0x7a, 0x70, 0x9d, 0x87, 0xe3, 0xc1, 0x75, 0x84, 0x1a, 0x36, 0xc5, 0x40, 0x7f, 0x71, 0x70,
		0x15, 0x6b, 0xb1, 0x06, 0x77, 0x3d, 0x5f, 0x66, 0xd0, 0xe6, 0x68, 0x29, 0xf8, 0x18, 0x7c, 0x2c,
		0xc5, 0xc7, 0xc2, 0x93, 0x1d, 0x46, 0x34, 0xa7, 0xd0, 0x09, 0x68, 0xb4, 0xc3, 0x86, 0x4c, 0x77,
		0x70, 0x9f, 0xd1, 0x08, 0x48, 0x95, 0xe8, 0x93, 0xf1, 0xe6, 0x49, 0x37, 0x01, 0x92, 0x1c, 0x77,
		0xa2, 0x86, 0xca, 0x88, 0x18, 0x24, 0xbd, 0x11, 0x0a, 0xf7, 0x19, 0xd1, 0x89, 0xa4, 0x18, 0x6b,
		0x35, 0x91, 0x09, 0x59, 0x86, 0x0b, 0x37, 0x78, 0xb2, 0x1a, 0x76, 0xcb, 0xe6, 0x6f, 0xea, 0xaf,
		0x79, 0x44, 0x78, 0xe1, 0x8e, 0x8a, 0x2f, 0x45, 0x2d, 0x5c, 0x48, 0xc6, 0x94, 0x94, 0xcc, 0x49,
		0xcf, 0xa4, 0xd4, 0xcc, 0xaa, 0x8d, 0x69, 0xb5, 0x31, 0xaf, 0x16, 0x26, 0x56, 0x63, 0x66, 0x45,
		0xa6, 0x0e, 0x9f, 0x48, 0x39, 0xec, 0x38, 0x43, 0x6f, 0x76, 0x93, 0x39, 0xdc, 0xe6, 0x6f, 0x72,
		0xdd, 0x39, 0x23, 0xf5, 0x25, 0x41, 0x16, 0x78, 0xee, 0x74, 0x78, 0x6b, 0x5f, 0x2c, 0x9f, 0x90,
		0x8c, 0x47, 0x0f, 0x7e, 0xf3, 0xc7, 0xcd, 0xd9, 0xe5, 0xaf, 0x0f, 0x5f, 0xab, 0xc7, 0xa7, 0x67,
		0xa7, 0xb7, 0x7f, 0x50, 0x11, 0x73, 0x90, 0x19, 0xef, 0x2b, 0xe7, 0x37, 0x4e, 0xfe, 0xf7, 0x93,
		0x6c, 0xa7, 0xa9, 0x03, 0x38, 0xbb, 0x3c, 0xae, 0x9e, 0x95, 0x72, 0x64, 0x9b, 0xf7, 0xb6, 0xd3,
		0xfe, 0xc4, 0xd5, 0x6f, 0x27, 0xa7, 0xb7, 0x9b, 0xf4, 0xc0, 0xc1, 0x2b, 0x2e, 0x6f, 0xd6, 0x2b,
		0xbe, 0xfd, 0xd7, 0xd5, 0xf5, 0xe9, 0xef, 0x9b, 0xf4, 0xcc, 0xc7, 0x97, 0x17, 0x37, 0x97, 0x67,
		0xb5, 0x8d, 0x23, 0xec, 0x83, 0x4d, 0x7a, 0xe2, 0x9b, 0x3f, 0x6e, 0x6e, 0x6b, 0xe7, 0x0f, 0x27,
		0xd5, 0xda, 0xf9, 0xe5, 0xc5, 0x26, 0x3d, 0xf8, 0xc5, 0xed, 0xd5, 0x46, 0x09, 0xb0, 0xb3, 0xb3,
		0x8d, 0x63, 0xe4, 0xca, 0x26, 0x3d, 0xf1, 0xb7, 0x9b, 0xda, 0xf5, 0x26, 0x3d, 0xef, 0x79, 0xf5,
		0x74, 0xf3, 0x28, 0xba, 0xb8, 0x71, 0x4f, 0xbc, 0xbf, 0x49, 0x4f, 0xfc, 0x5b, 0xed, 0xfa, 0xa2,
		0xb6, 0x79, 0x54, 0xbd, 0xb7, 0x61, 0x80, 0xeb, 0xec, 0xf2, 0xd7, 0x8d, 0x7b, 0xc7, 0x85, 0x4d,
		0xb3, 0x16, 0x09, 0x9f, 0x97, 0x64, 0xa7, 0x7a, 0x66, 0xfb, 0x11, 0x28, 0xbc, 0xef, 0x9c, 0xcf,
		0x5e, 0x99, 0x47, 0x1a, 0x74, 0x08, 0x77, 0x44, 0xd0, 0x61, 0xe9, 0x59, 0x21, 0xe8, 0x80, 0xa0,
		0x43, 0xf4, 0x13, 0xd1, 0x07, 0x1d, 0xfc, 0x37, 0xbf, 0xe5, 0x3e, 0x9b, 0x44, 0x2c, 0x3a, 0xc9,
		0xa6, 0xc5, 0x7d, 0x82, 0xbd, 0x6a, 0x4e, 0xb7, 0xdd, 0x7f, 0xe0, 0x95, 0x09, 0xd2, 0x44, 0x03,
		0xc6, 0x8a, 0xf5, 0x56, 0x63, 0x11, 0x2e, 0x99, 0x86, 0x18, 0x66, 0xdc, 0x85, 0xbf, 0xed, 0x2a,
		0xe5, 0x6c, 0x18, 0xf2, 0x99, 0x8a, 0x37, 0xa3, 0x5b, 0x09, 0x7f, 0x93, 0x9a, 0x36, 0x29, 0xff,
		0x1e, 0x65, 0x0a, 0x79, 0x95, 0xe3, 0xf5, 0x54, 0x71, 0xfa, 0xb5, 0x2b, 0xe7, 0x45, 0xb2, 0x4c,
		0xf2, 0x2a, 0x2f, 0xab, 0x65, 0xbc, 0xf2, 0x13, 0x2e, 0x67, 0x54, 0xd8, 0x81, 0xc2, 0x1e, 0xb3,
		0x13, 0x2f, 0x43, 0xa6, 0x4e, 0xb1, 0x08, 0x53, 0x46, 0xff, 0x54, 0xa8, 0x1f, 0x22, 0x0c, 0x22,
		0x0c, 0x22, 0x2c, 0x6d, 0x22, 0x2c, 0x64, 0xea, 0x34, 0x8b, 0x30, 0x4e, 0xd2, 0x84, 0x59, 0xb6,
		0xf7, 0x80, 0x41, 0x99, 0xac, 0x5c, 0x82, 0xf0, 0x82, 0xf0, 0x4a, 0x44, 0x78, 0x21, 0x59, 0x19,
		0x7e, 0x43, 0xf8, 0x0d, 0xe1, 0x37, 0x8c, 0x49, 0x6f, 0x48, 0x56, 0x46, 0xb2, 0x32, 0xcd, 0x7f,
		0x48, 0x56, 0x4e, 0xe7, 0x2b, 0x46, 0xb2, 0xf2, 0x9a, 0x3f, 0x33, 0x92, 0x95, 0x37, 0xe0, 0x89,
		0x91, 0xac, 0xbc, 0x21, 0x02, 0x0c, 0xc9, 0xca, 0xeb, 0xfd, 0xc4, 0x48, 0x56, 0xde, 0x00, 0x8a,
		0x46, 0xb2, 0xf2, 0x5a, 0x3f, 0x31, 0x92, 0x95, 0x37, 0x02, 0x70, 0x21, 0x59, 0x79, 0x03, 0xac,
		0x45, 0x24, 0x2b, 0x53, 0xad, 0x46, 0xb2, 0xf2, 0x82, 0x6d, 0x10, 0x74, 0x90, 0x3b, 0x7d, 0x04,
		0x1d, 0x90, 0xac, 0x2c, 0xc0, 0xa6, 0x48, 0x56, 0x16, 0x27, 0xd8, 0xf4, 0x25, 0x2b, 0xab, 0xa4,
		0x6c, 0x18, 0xa4, 0xb9, 0xca, 0x12, 0x03, 0x24, 0xe4, 0xdf, 0xa2, 0xde, 0xb6, 0x81, 0xc3, 0x01,
		0x13, 0xa3, 0x60, 0xbc, 0x21, 0xc9, 0x7d, 0x72, 0xf3, 0x26, 0xc2, 0xd5, 0xd2, 0x73, 0x27, 0xc6,
		0x3b, 0x10, 0xce, 0x9f, 0x08, 0x37, 0x95, 0x9a, 0x43, 0x21, 0xfb, 0x26, 0x12, 0x1b, 0xc7, 0xb2,
		0x94, 0xd3, 0x34, 0x8e, 0x64, 0x59, 0xca, 0x5b, 0xd9, 0x18, 0xcb, 0x92, 0x74, 0x07, 0x69, 0xd1,
		0x66, 0xc9, 0x14, 0xaf, 0x24, 0xd1, 0x3e, 0xd2, 0x42, 0x49, 0x7d, 0x52, 0x49, 0x7c, 0xd2, 0xfd,
		0xa3, 0x4b, 0xe8, 0x1f, 0x4d, 0x09, 0x91, 0x37, 0xb8, 0x0f, 0xbc, 0x28, 0x80, 0x91, 0xe5, 0xe0,
		0xf8, 0xe8, 0x24, 0xb3, 0x33, 0x80, 0xa6, 0x4f, 0x96, 0x70, 0x04, 0xd0, 0xf4, 0x59, 0x4a, 0x4f,
		0x00, 0x5a, 0x30, 0x3d, 0xc6, 0x63, 0x6d, 0x97, 0x33, 0xd3, 0x67, 0xde, 0x2b, 0x8b, 0xd1, 0x38,
		0x3f, 0x94, 0x11, 0x1f, 0xd6, 0x61, 0x8c, 0x0a, 0xc6, 0xa8, 0xcc, 0x21, 0x28, 0x71, 0x25, 0x3a,
		0xbd, 0x1c, 0xc3, 0x18, 0xa0, 0x4c, 0xa5, 0x94, 0xa9, 0xf0, 0x30, 0x06, 0xc9, 0xbe, 0xf3, 0x6a,
		0xfd, 0xe6, 0x31, 0x88, 0x61, 0x25, 0x8e, 0x56, 0x0c, 0x62, 0x88, 0xb1, 0xf0, 0xc5, 0xf5, 0xb9,
		0x7a, 0x61, 0x53, 0xb0, 0x0b, 0x8a, 0x32, 0x51, 0xd7, 0x94, 0x30, 0x53, 0xad, 0xc6, 0x4d, 0x4d,
		0x57, 0x94, 0xa9, 0xc0, 0x37, 0x53, 0x8a, 0xe5, 0x50, 0x61, 0x8f, 0xe1, 0xd3, 0xa8, 0x15, 0x09,
		0x50, 0x96, 0x81, 0x74, 0x4c, 0xab, 0xd9, 0xf4, 0x98, 0xef, 0x53, 0x06, 0x63, 0x0e, 0x09, 0xf6,
		0x22, 0x39, 0x29, 0xba, 0x13, 0x9b, 0x73, 0x72, 0xaf, 0xfb, 0x84, 0x67, 0x37, 0x73, 0x86, 0x9f,
		0x09, 0xf7, 0xbc, 0xb2, 0x38, 0x67, 0x9e, 0x43, 0x5a, 0x9d, 0x12, 0x6c, 0xbc, 0x75, 0x57, 0x30,
		0x0f, 0xeb, 0xef, 0x77, 0x45, 0xf3, 0xb0, 0x3e, 0xf8, 0xb5, 0x18, 0xfc, 0xf8, 0x59, 0xea, 0xbd,
		0x97, 0xee, 0x0a, 0xe6, 0xfe, 0xf0, 0xd3, 0x52, 0xf9, 0xae, 0x60, 0x96, 0xeb, 0xf9, 0xad, 0xfb,
		0xfb, 0x1d, 0xd1, 0x35, 0xf9, 0x9f, 0x7b, 0x3d, 0xba, 0x64, 0x8d, 0x3a, 0xe5, 0xb1, 0x5e, 0xde,
		0x9c, 0xfe, 0x47, 0xdb, 0xd9, 0xfe, 0xb9, 0x95, 0xd4, 0xe9, 0xe6, 0xff, 0x41, 0x78, 0xbe, 0x24,
		0x3b, 0x11, 0xa5, 0x10, 0xe9, 0x61, 0xfb, 0x0a, 0xd8, 0x3e, 0xa0, 0x32, 0xcb, 0x7c, 0xaa, 0x9a,
		0x5f, 0xeb, 0x3f, 0x8b, 0xdb, 0xfb, 0xbd, 0xa3, 0xfc, 0xcf, 0x83, 0xde, 0xc7, 0x0f, 0xdf, 0xe7,
		0x7d, 0xad, 0xb8, 0x7d, 0xd0, 0x3b, 0x8a, 0xf8, 0x4b, 0xa5, 0x77, 0x14, 0x73, 0x8f, 0x72, 0x6f,
		0x6b, 0xe6, 0xab, 0xfd, 0xcf, 0x4b, 0x51, 0x0b, 0xf6, 0x23, 0x16, 0xec, 0x45, 0x2d, 0xd8, 0x8b,
		0x58, 0x10, 0x79, 0x4b, 0xa5, 0x88, 0x05, 0xe5, 0xde, 0xfb, 0xcc, 0xf7, 0xb7, 0xe6, 0x7f, 0xb5,
		0xd2, 0xcb, 0xbf, 0x47, 0xfd, 0xed, 0xa0, 0xf7, 0x7e, 0x94, 0xcf, 0x6f, 0xb0, 0x20, 0x04, 0xb9,
		0x25, 0x4f, 0x6e, 0xe9, 0x53, 0x0c, 0x9f, 0x56, 0x7b, 0x1f, 0x8a, 0x8a, 0x89, 0x10, 0xb9, 0x37,
		0xdd, 0xb6, 0x65, 0x3b, 0x66, 0x10, 0xee, 0x20, 0x84, 0xee, 0x04, 0xfa, 0x27, 0x77, 0xc6, 0x9c,
		0xe7, 0x20, 0xbe, 0x93, 0x3a, 0xf0, 0x7e, 0x6e, 0x3b, 0x64, 0x39, 0x8a, 0xe1, 0xa6, 0x41, 0xe9,
		0xb7, 0x7c, 0xb3, 0x98, 0xc8, 0x7d, 0xbf, 0x7a, 0x56, 0x83, 0xdb, 0xae, 0x73, 0x62, 0x3f, 0xdb,
		0xb2, 0x59, 0x33, 0x8b, 0x49, 0x89, 0x3d, 0x5b, 0xdc, 0x7e, 0xed, 0xdf, 0xfb, 0x93, 0xd5, 0xf2,
		0x59, 0x1a, 0x33, 0xc0, 0x73, 0xe7, 0xd6, 0x0f, 0x7d, 0xaf, 0xac, 0x54, 0xde, 0xc3, 0x4b, 0x23,
		0x13, 0xad, 0x44, 0x02, 0x9a, 0x40, 0x02, 0x51, 0x63, 0x91, 0xdc, 0xd6, 0xd6, 0xd6, 0xd6, 0x9d,
		0x65, 0xfe, 0x5d, 0x35, 0xff, 0x5b, 0x30, 0x0f, 0x1f, 0xea, 0x13, 0xff, 0xb8, 0xbf, 0x37, 0x1f,
		0xea, 0xf9, 0x9f, 0x85, 0xed, 0x4a, 0xb1, 0x97, 0xff, 0x65, 0xfc, 0x79, 0xfd, 0xfe, 0x7e, 0x27,
		0xff, 0x4f, 0x99, 0x55, 0xbf, 0xe4, 0xdf, 0xfb, 0x6b, 0x73, 0xe9, 0x38, 0x4a, 0x1d, 0xd8, 0xae,
		0x8f, 0xe9, 0x92, 0x3f, 0x50, 0x02, 0x34, 0x53, 0x5f, 0x51, 0x6a, 0x70, 0x3d, 0xc5, 0xfd, 0xda,
		0x86, 0xe1, 0xe5, 0x8e, 0xeb, 0x11, 0x04, 0x37, 0x26, 0x37, 0x93, 0xed, 0x84, 0xc5, 0x9e, 0xac,
		0x6e, 0x8b, 0x2b, 0x11, 0x6b, 0xae, 0x5c, 0x94, 0xac, 0x6c, 0xac, 0x23, 0x32, 0x83, 0xc8, 0x8c,
		0xc0, 0x86, 0x88, 0xcc, 0x18, 0xb9, 0x3e, 0xb7, 0x9b, 0x4e, 0xb7, 0xfd, 0xc8, 0x3c, 0x82, 0x00,
		0x4d, 0x45, 0x61, 0x8b, 0x6b, 0xcb, 0x79, 0x4e, 0x45, 0x80, 0x86, 0xd2, 0x52, 0x09, 0xe1, 0x2e,
		0x11, 0x16, 0xd5, 0x06, 0x72, 0xe9, 0xc1, 0x2d, 0x81, 0x25, 0x42, 0x6a, 0x81, 0x84, 0xaf, 0xa2,
		0x52, 0x2e, 0xef, 0x95, 0x37, 0xef, 0x75, 0x00, 0x3e, 0xcd, 0x1c, 0xb2, 0x1f, 0xa8, 0xba, 0x30,
		0xa6, 0xa0, 0xde, 0xf7, 0x76, 0x7a, 0x3f, 0xc0, 0x11, 0xc0, 0x11, 0xc0, 0x11, 0x21, 0x7a, 0x21,
		0x49, 0x8a, 0x58, 0xd3, 0x74, 0x11, 0xd2, 0xa4, 0x07, 0x52, 0xaf, 0x33, 0xbd, 0xcf, 0x27, 0x33,
		0xc9, 0x0d, 0xa9, 0xf6, 0xf3, 0x64, 0x28, 0x89, 0x61, 0x5d, 0x62, 0x43, 0xc4, 0x49, 0x0a, 0x29,
		0x67, 0x53, 0x44, 0x87, 0x33, 0x9b, 0x8c, 0x90, 0x7a, 0xc1, 0x05, 0xb2, 0xca, 0x64, 0xd2, 0xc1,
		0xda, 0xbb, 0xe9, 0xd7, 0xaa, 0x4f, 0xc1, 0x74, 0xdd, 0xe3, 0xf4, 0x3f, 0xe5, 0x07, 0x18, 0x0a,
		0xd6, 0x83, 0x5e, 0x07, 0x57, 0xbd, 0x19, 0xdc, 0xc3, 0xd4, 0xbf, 0xa4, 0x06, 0x17, 0x0a, 0xf4,
		0x2d, 0x10, 0x28, 0x63, 0x93, 0x2a, 0x20, 0x51, 0x49, 0x80, 0x97, 0xf4, 0x03, 0xa0, 0x9a, 0x0a,
		0xd5, 0x54, 0xda, 0xed, 0x76, 0x82, 0x69, 0x5b, 0x2a, 0x53, 0xb6, 0xe6, 0x4c, 0xd7, 0x0a, 0x18,
		0x2c, 0x05, 0x62, 0x62, 0xdc, 0x4c, 0x44, 0x5a, 0x56, 0xc8, 0xf4, 0x23, 0x31, 0x50, 0x7e, 0x09,
		0x81, 0x61, 0xa4, 0xb7, 0xfc, 0x32, 0xec, 0x7e, 0x44, 0x30, 0x1b, 0x53, 0xba, 0x8f, 0x92, 0x41,
		0x39, 0x5e, 0x0e, 0xde, 0x75, 0x78, 0xd7, 0x93, 0xf1, 0xae, 0x2b, 0x8f, 0x97, 0x93, 0x6c, 0x06,
		0x10, 0x49, 0x76, 0xca, 0x83, 0xcd, 0x09, 0x18, 0x91, 0x8c, 0x21, 0x29, 0x19, 0x93, 0x9e, 0x41,
		0xa9, 0x19, 0x55, 0x1b, 0xc3, 0x6a, 0x63, 0x5c, 0x2d, 0x0c, 0xac, 0xee, 0x6e, 0x20, 0xf0, 0x3a,
		0x2b, 0x33, 0x76, 0xb8, 0x11, 0xd9, 0xfc, 0xc8, 0x19, 0x02, 0x26, 0x9a, 0x23, 0xa9, 0x68, 0xd3,
		0x6a, 0x67, 0x7e, 0x1d, 0x42, 0x40, 0x9f, 0x30, 0xd0, 0x25, 0x14, 0xb4, 0x0b, 0x07, 0xed, 0x42,
		0x42, 0xab, 0xb0, 0xa0, 0x11, 0x1a, 0x44, 0xc2, 0x43, 0xdd, 0x86, 0x5f, 0x4a, 0xaf, 0xb4, 0x73,
		0x2a, 0x67, 0xf4, 0x7e, 0x99, 0x70, 0x4f, 0x2d, 0x73, 0x2b, 0x67, 0x0e, 0x44, 0xcf, 0xfc, 0xca,
		0xf0, 0x32, 0x1a, 0xe6, 0x58, 0x8e, 0xfe, 0xfb, 0x49, 0xbe, 0xa3, 0xa1, 0x73, 0xae, 0x25, 0x31,
		0x8f, 0x24, 0x78, 0x12, 0xc4, 0xf3, 0x2e, 0xb3, 0x7b, 0x10, 0xd4, 0x73, 0x30, 0xb3, 0x4c, 0x12,
		0xd4, 0xf3, 0x31, 0xb3, 0x7b, 0x16, 0xe4, 0x73, 0x33, 0x33, 0xce, 0x20, 0x07, 0x38, 0x09, 0x6d,
		0x73, 0x36, 0xb3, 0x7b, 0x20, 0xa4, 0xf3, 0x37, 0x33, 0x2c, 0x38, 0x29, 0xe7, 0x72, 0x66, 0x5c,
		0x50, 0x54, 0x70, 0x12, 0xd4, 0x73, 0x3c, 0xb3, 0x7b, 0x0e, 0xb4, 0xf3, 0x3d, 0x33, 0xce, 0x19,
		0x45, 0x9c, 0x04, 0xfd, 0x3c, 0xd0, 0xec, 0x9e, 0x04, 0xf5, 0x9c, 0xd0, 0x8c, 0xd3, 0xc4, 0x1e,
		0x4e, 0x82, 0x7e, 0xae, 0x68, 0xc6, 0x69, 0xa2, 0x80, 0x93, 0xa0, 0x9e, 0x43, 0x1a, 0x9e, 0x03,
		0xe9, 0x8e, 0xf5, 0xb5, 0x6b, 0x30, 0x43, 0x51, 0x13, 0x4c, 0x36, 0xb7, 0x74, 0x86, 0x26, 0x08,
		0x87, 0x23, 0x1a, 0x08, 0x76, 0x21, 0xd8, 0x35, 0xbc, 0x00, 0x82, 0x5d, 0x19, 0x08, 0x76, 0xd1,
		0xcf, 0x47, 0xfd, 0x28, 0x06, 0x28, 0xe6, 0xa4, 0x86, 0x7b, 0xd2, 0xcc, 0x4b, 0x25, 0x14, 0xec,
		0x2b, 0x4d, 0xa4, 0x20, 0x9a, 0xa7, 0x3a, 0x56, 0x31, 0x94, 0x55, 0x14, 0x73, 0x86, 0xad, 0x92,
		0x24, 0x50, 0x19, 0xa4, 0x85, 0x16, 0x73, 0x06, 0xb1, 0xca, 0xd4, 0x5e, 0xd0, 0xd1, 0x85, 0xca,
		0x68, 0x73, 0xb2, 0x7c, 0x18, 0xea, 0x3c, 0x18, 0x8c, 0x36, 0x5f, 0xa5, 0xca, 0x47, 0xd2, 0x5b,
		0x0a, 0x64, 0x35, 0xfd, 0x68, 0x73, 0xf9, 0x1a, 0x94, 0x48, 0x55, 0x7d, 0x40, 0x53, 0x6d, 0xfd,
		0xa1, 0x46, 0x25, 0x14, 0x22, 0x19, 0x14, 0xa9, 0x64, 0x56, 0x17, 0xb5, 0xb5, 0x05, 0x91, 0x0a,
		0x91, 0x0a, 0x91, 0xba, 0xa9, 0x22, 0x35, 0x14, 0x22, 0x59, 0x14, 0xa9, 0x42, 0x73, 0xb9, 0x97,
		0xcb, 0x53, 0xc1, 0x01, 0xc8, 0x0b, 0xdf, 0x16, 0x95, 0x30, 0x2d, 0x41, 0x98, 0x42, 0x98, 0x66,
		0x4a, 0x98, 0xa2, 0x28, 0x43, 0x75, 0x3b, 0xf8, 0xa9, 0xe1, 0xa7, 0x4e, 0x4c, 0x58, 0xd0, 0xb9,
		0x30, 0x0d, 0x14, 0x65, 0xa0, 0x28, 0x63, 0xe6, 0x32, 0x28, 0xca, 0xd0, 0xc4, 0x23, 0x09, 0x9e,
		0x04, 0x8a, 0x32, 0x50, 0x94, 0x31, 0x43, 0x12, 0x28, 0xca, 0x40, 0x51, 0xc6, 0x7c, 0x06, 0x41,
		0x51, 0x06, 0x8a, 0x32, 0x66, 0x0f, 0x04, 0x45, 0x19, 0x28, 0xca, 0x40, 0x51, 0xc6, 0xec, 0x49,
		0xa0, 0x28, 0x03, 0x45, 0x19, 0x28, 0xca, 0x88, 0x3c, 0x09, 0x14, 0x65, 0xa0, 0x28, 0x03, 0x45,
		0x19, 0x91, 0x7e, 0x1b, 0x9c, 0x04, 0x8a, 0x32, 0x50, 0x94, 0xb1, 0xda, 0x5d, 0x50, 0x94, 0xa1,
		0xb0, 0x1d, 0x82, 0x5d, 0x08, 0x76, 0xcd, 0xbd, 0x00, 0x82, 0x5d, 0x04, 0xbc, 0x8f, 0xa2, 0x8c,
		0xd5, 0xed, 0xb0, 0x69, 0x45, 0x19, 0x14, 0xf9, 0x53, 0x86, 0xee, 0x9a, 0x8c, 0x9b, 0xe0, 0x26,
		0x57, 0x95, 0xec, 0x96, 0x68, 0xdb, 0xe3, 0xdf, 0xd8, 0xdb, 0x64, 0xb2, 0x8b, 0xa1, 0x28, 0x05,
		0x72, 0x67, 0xb6, 0xcf, 0xab, 0x9c, 0x2b, 0xf6, 0x52, 0x3e, 0xb7, 0x9d, 0x5a, 0x8b, 0xf5, 0x05,
		0xbb, 0xe2, 0xb4, 0xd7, 0xdc, 0xb9, 0xf5, 0x63, 0x62, 0xa7, 0xe2, 0xe7, 0xfd, 0xfd, 0xca, 0xc1,
		0xfe, 0x7e, 0xe1, 0x60, 0xef, 0xa0, 0x70, 0x58, 0x2e, 0x17, 0x2b, 0x2a, 0xb1, 0xf8, 0xdc, 0xa5,
		0xd7, 0x64, 0x1e, 0x6b, 0x7e, 0xe9, 0x1f, 0xa1, 0xd3, 0x6d, 0xb5, 0x12, 0x7d, 0x73, 0x44, 0x9c,
		0xaf, 0x9b, 0xe3, 0x73, 0x4a, 0xb9, 0x9b, 0xda, 0x78, 0x3c, 0x87, 0x41, 0x46, 0xda, 0xde, 0xfd,
		0x4a, 0x67, 0x19, 0x85, 0xaf, 0x3a, 0x15, 0x73, 0x4a, 0xa4, 0x92, 0x8f, 0x95, 0x92, 0x8d, 0x95,
		0xe7, 0x93, 0x94, 0x30, 0x9f, 0x64, 0x95, 0xa6, 0xce, 0x3a, 0xcf, 0x27, 0x91, 0x9a, 0xee, 0x35,
		0x43, 0x2c, 0x12, 0x53, 0xbe, 0x88, 0xfc, 0x12, 0x98, 0x4b, 0x92, 0x8c, 0x1f, 0x01, 0x73, 0x49,
		0x08, 0xed, 0x7e, 0x0a, 0xbe, 0x31, 0xd6, 0x77, 0xde, 0xb7, 0x8e, 0x31, 0xc2, 0x87, 0x04, 0x7b,
		0x91, 0x9c, 0x14, 0xdd, 0x89, 0xcd, 0x39, 0x39, 0xd2, 0x49, 0xe9, 0x33, 0x67, 0xf8, 0x99, 0x70,
		0x4f, 0xea, 0xe1, 0xb9, 0xe1, 0xc6, 0xd9, 0x99, 0xa0, 0x3e, 0xfa, 0xaf, 0x4e, 0x79, 0xac, 0x3a,
		0x06, 0x13, 0x87, 0xbb, 0x67, 0x6b, 0xb2, 0x7a, 0x78, 0xbe, 0x69, 0x72, 0x1a, 0xeb, 0x61, 0xfb,
		0x0a, 0xd8, 0x1e, 0xa3, 0xb3, 0x33, 0x3b, 0x91, 0x3d, 0xb3, 0x82, 0x10, 0xe4, 0x96, 0xc9, 0x49,
		0xed, 0xc4, 0x8a, 0x61, 0xd5, 0x93, 0xe3, 0xb7, 0xd3, 0x82, 0xdc, 0x9b, 0x6e, 0xdb, 0xb2, 0x1d,
		0x33, 0xf0, 0x18, 0x12, 0x42, 0x77, 0x02, 0xfd, 0x93, 0x3b, 0x63, 0xce, 0x73, 0xe0, 0x51, 0x4d,
		0x1d, 0x78, 0x3f, 0xb7, 0x1d, 0xfa, 0x2c, 0x82, 0xa0, 0x78, 0x4f, 0xbd, 0x9d, 0xc1, 0xcc, 0xbe,
		0x5f, 0x3d, 0xab, 0xc1, 0x6d, 0xd7, 0x39, 0xb1, 0x9f, 0x6d, 0xd5, 0x38, 0xd0, 0x7c, 0x52, 0x62,
		0xcf, 0x16, 0xb7, 0x5f, 0xfb, 0xf7, 0xfe, 0x64, 0xb5, 0x7c, 0x46, 0x97, 0x39, 0x40, 0xa8, 0x5b,
		0xce, 0xad, 0x1f, 0xfa, 0x5e, 0x59, 0xa9, 0xbc, 0x87, 0x97, 0x46, 0x26, 0x5a, 0x89, 0x04, 0x34,
		0x4d, 0x0b, 0x17, 0x52, 0x2c, 0x92, 0xdb, 0xda, 0xda, 0xda, 0xba, 0xb3, 0xcc, 0xbf, 0xab, 0xe6,
		0x7f, 0x0b, 0xe6, 0xe1, 0x43, 0x7d, 0xe2, 0x1f, 0xf7, 0xf7, 0xe6, 0x43, 0x3d, 0xff, 0xb3, 0xb0,
		0x5d, 0x29, 0xf6, 0xf2, 0xbf, 0x8c, 0x3f, 0xaf, 0xdf, 0xdf, 0xef, 0xe4, 0xff, 0x29, 0xb3, 0xea,
		0x97, 0xfc, 0x7b, 0x7f, 0x6d, 0x2e, 0x1d, 0x47, 0xa9, 0x03, 0xdb, 0xf5, 0x31, 0x5d, 0xf2, 0x07,
		0x4a, 0x80, 0x66, 0xea, 0x2b, 0x4a, 0x8a, 0xa8, 0x27, 0x15, 0xae, 0x95, 0x08, 0x41, 0x0d, 0xa3,
		0xa0, 0x1d, 0xd7, 0x23, 0x08, 0x6e, 0x4c, 0x6e, 0x26, 0x3b, 0xc9, 0x9a, 0x3d, 0x59, 0xdd, 0x16,
		0x57, 0x22, 0xd6, 0x5c, 0xb9, 0x28, 0x59, 0x53, 0x51, 0x47, 0x64, 0x06, 0x91, 0x19, 0x81, 0x0d,
		0x11, 0x99, 0x31, 0x72, 0x7d, 0x6e, 0x37, 0x9d, 0x6e, 0xfb, 0x91, 0x79, 0x04, 0x01, 0x9a, 0x8a,
		0xc2, 0x16, 0xd7, 0x96, 0xf3, 0x9c, 0x8a, 0x00, 0x0d, 0xa5, 0xa5, 0x12, 0xc2, 0x5d, 0xaa, 0xec,
		0x71, 0x5d, 0x20, 0x97, 0x1e, 0xdc, 0x52, 0x54, 0x1d, 0x50, 0x5a, 0x20, 0xe1, 0xab, 0xa8, 0x94,
		0xcb, 0x7b, 0xe5, 0xcd, 0x7b, 0x1d, 0x80, 0x4f, 0x33, 0x87, 0xec, 0x07, 0xaa, 0x2e, 0x8c, 0x29,
		0x28, 0x23, 0xa8, 0x0f, 0xfb, 0x01, 0x8e, 0x00, 0x8e, 0x00, 0x8e, 0x08, 0xd1, 0x0b, 0x49, 0x52,
		0xc4, 0x9a, 0xa6, 0x8b, 0x90, 0x26, 0x3d, 0x90, 0x7a, 0x9d, 0xe9, 0x7d, 0x3e, 0x99, 0x49, 0x6e,
		0x48, 0xb5, 0x9f, 0x27, 0x43, 0x49, 0x0c, 0xeb, 0x12, 0x1b, 0x22, 0x4e, 0x52, 0x48, 0x39, 0x9b,
		0x22, 0x3a, 0x9c, 0xd9, 0x64, 0x84, 0xd4, 0x0b, 0x2e, 0x90, 0x55, 0x26, 0x93, 0x0e, 0xd6, 0xde,
		0x4d, 0xbf, 0x41, 0x55, 0x55, 0x92, 0x05, 0xb3, 0x84, 0x15, 0x55, 0xe2, 0xd5, 0xb0, 0x02, 0xd5,
		0x54, 0x9f, 0x08, 0xdf, 0xe0, 0xa8, 0x9a, 0x55, 0x20, 0xd3, 0x5d, 0xae, 0x60, 0x55, 0xbe, 0x40,
		0x95, 0xb4, 0x20, 0x55, 0xae, 0x00, 0x35, 0xee, 0x61, 0x4a, 0xb2, 0x01, 0x29, 0xf9, 0xe7, 0x84,
		0x8a, 0xed, 0x68, 0x08, 0x3e, 0x1e, 0xa9, 0x2f, 0x27, 0xdc, 0xc5, 0xdf, 0x58, 0xf2, 0x16, 0x44,
		0x4f, 0x5f, 0xf1, 0xd4, 0x63, 0x9c, 0xb3, 0xca, 0xf9, 0x2e, 0x3e, 0xd2, 0xe8, 0x83, 0x9a, 0xff,
		0x97, 0x88, 0xa3, 0x8b, 0x7b, 0x64, 0xa2, 0x47, 0xb5, 0xe0, 0x6c, 0xc4, 0xce, 0x64, 0xfe, 0x29,
		0xcc, 0x3e, 0xe3, 0x9c, 0xe7, 0xcb, 0xb5, 0x59, 0xdb, 0xf5, 0xa2, 0x1b, 0xff, 0x84, 0xa6, 0xcf,
		0xf0, 0x7b, 0x11, 0x27, 0xb4, 0xb8, 0x36, 0x74, 0xa9, 0xd7, 0x32, 0x8e, 0x57, 0x72, 0xd2, 0xeb,
		0xe8, 0xbf, 0x2d, 0x22, 0xac, 0xb8, 0x5e, 0x45, 0x61, 0xaf, 0xa1, 0xb0, 0x57, 0xf0, 0xa3, 0xd7,
		0xaf, 0x7f, 0xdf, 0x44, 0x34, 0xb9, 0xac, 0x56, 0x32, 0xd7, 0x18, 0x9d, 0xf9, 0x92, 0x43, 0x18,
		0x1d, 0x6b, 0xac, 0xa9, 0xa6, 0x31, 0x8b, 0x80, 0x63, 0xbb, 0xa9, 0x45, 0xdc, 0xd1, 0xf1, 0x09,
		0x40, 0xd6, 0xbd, 0x2c, 0xed, 0x46, 0x96, 0x76, 0x17, 0x0b, 0x11, 0x48, 0xba, 0xe5, 0xff, 0x40,
		0x40, 0xc4, 0x1f, 0x8e, 0x1b, 0x53, 0xc4, 0x9d, 0x07, 0xdb, 0xc6, 0x9a, 0x66, 0xbb, 0x40, 0xdc,
		0x2f, 0x94, 0xb4, 0x71, 0x4a, 0xe9, 0x85, 0x4a, 0xe7, 0x85, 0xb9, 0xa4, 0x04, 0x2e, 0x49, 0x19,
		0x97, 0xc4, 0x2d, 0x45, 0xcf, 0x35, 0xdc, 0xae, 0xc3, 0xfb, 0x48, 0x24, 0xf6, 0xf1, 0x8d, 0x05,
		0xee, 0x70, 0x65, 0x5c, 0x1b, 0x44, 0xa8, 0xff, 0x82, 0x70, 0xa4, 0x50, 0x26, 0x32, 0x28, 0x4e,
		0x6c, 0xaa, 0x91, 0x3f, 0xe5, 0x48, 0x9f, 0x72, 0x64, 0x4f, 0x8a, 0x18, 0xf5, 0x58, 0xa5, 0xa2,
		0xfd, 0x12, 0x72, 0x0d, 0xd7, 0xf3, 0x58, 0x83, 0x5b, 0x8f, 0x2d, 0x66, 0xb2, 0x46, 0xc3, 0x64,
		0x9e, 0xe7, 0x7a, 0xbe, 0x7c, 0x1f, 0x91, 0x88, 0xfd, 0xe4, 0x1a, 0x8b, 0x14, 0x64, 0x1b, 0x8b,
		0x14, 0x56, 0xd3, 0x58, 0x44, 0x8c, 0xe0, 0x55, 0x09, 0x9f, 0x8c, 0x01, 0xc8, 0x18, 0x81, 0x84,
		0x21, 0x92, 0x71, 0xbc, 0x49, 0x87, 0xb0, 0xc3, 0xf7, 0xdd, 0xb5, 0x1d, 0x5e, 0xd9, 0x97, 0x79,
		0xdf, 0x43, 0xea, 0x96, 0x08, 0xf1, 0x28, 0x26, 0xcd, 0xa9, 0xb5, 0x49, 0x53, 0xcf, 0xc9, 0x20,
		0x4a, 0x8e, 0x23, 0xcf, 0xc2, 0xa2, 0xcb, 0xbe, 0xea, 0xa9, 0xf5, 0x8f, 0xa3, 0x3b, 0x62, 0xda,
		0xf6, 0x73, 0x69, 0x3f, 0xf5, 0x84, 0x62, 0x01, 0xf5, 0x14, 0xf4, 0xf9, 0xe2, 0x2e, 0xb7, 0x5a,
		0x24, 0xaa, 0x7a, 0x66, 0x27, 0x28, 0x69, 0x28, 0x69, 0x28, 0x69, 0x28, 0x69, 0x28, 0x69, 0x28,
		0x69, 0x28, 0x69, 0x15, 0x25, 0xdd, 0x75, 0xa8, 0xed, 0xea, 0xc8, 0x1d, 0xa1, 0xb4, 0xa1, 0xb4,
		0xa1, 0xb4, 0xa1, 0xb4, 0xa1, 0xb4, 0xa1, 0xb4, 0xa1, 0xb4, 0xe5, 0xbe, 0x99, 0x96, 0x34, 0xa5,
		0x61, 0xc0, 0x34, 0x08, 0x28, 0xee, 0x0a, 0x06, 0x83, 0x0c, 0xe1, 0x00, 0x6a, 0x90, 0x6c, 0xf7,
		0x70, 0x3c, 0xba, 0x0c, 0x55, 0x2a, 0x52, 0x8c, 0xf0, 0xe2, 0x93, 0xc7, 0x98, 0x78, 0x74, 0x2c,
		0x58, 0x25, 0x16, 0x19, 0x2b, 0x20, 0x32, 0x86, 0xc8, 0x98, 0x24, 0x2c, 0x91, 0x87, 0x23, 0x12,
		0x30, 0x44, 0x12, 0x7e, 0x48, 0x80, 0x2c, 0x15, 0xb8, 0xa1, 0x0a, 0x33, 0xc8, 0x14, 0x9d, 0xba,
		0x82, 0x93, 0x29, 0x1f, 0x56, 0x81, 0x11, 0x1a, 0xe0, 0x43, 0x9a, 0x4e, 0x53, 0x93, 0xfa, 0xae,
		0x27, 0xa8, 0x94, 0x3a, 0x2f, 0x6f, 0xbe, 0xdd, 0xb0, 0x5a, 0xe2, 0x8a, 0x29, 0x5c, 0x09, 0xe5,
		0x04, 0xe5, 0x04, 0xe5, 0x04, 0xe5, 0x04, 0xe5, 0x04, 0xe5, 0x44, 0xab, 0x9c, 0x3c, 0x16, 0x54,
		0x4f, 0x34, 0xc5, 0x95, 0x53, 0xb8, 0x12, 0xca, 0x09, 0xca, 0x09, 0xca, 0x09, 0xca, 0x09, 0xca,
		0x09, 0xca, 0x89, 0x56, 0x39, 0x75, 0x7d, 0x19, 0xc5, 0x14, 0xac, 0x82, 0x52, 0x82, 0x52, 0x82,
		0x52, 0x82, 0x52, 0x82, 0x52, 0x82, 0x52, 0x12, 0x50, 0x4a, 0x69, 0x2e, 0x77, 0x8c, 0xdb, 0x45,
		0x43, 0x22, 0x58, 0x97, 0xcd, 0xda, 0xf6, 0x85, 0x75, 0xe2, 0xc2, 0x27, 0xa1, 0x56, 0xd9, 0xee,
		0xfb, 0xd6, 0x33, 0xf3, 0xe3, 0xd4, 0xb6, 0x0f, 0xbf, 0x99, 0x8e, 0xea, 0xf6, 0x25, 0xb7, 0x63,
		0xa4, 0xba, 0xc4, 0x3d, 0xbc, 0x79, 0xd4, 0xb9, 0x4b, 0x62, 0x4e, 0x41, 0x52, 0x90, 0x05, 0x9a,
		0xab, 0x2f, 0xe3, 0x5d, 0x4e, 0x2a, 0x34, 0x2a, 0x20, 0x76, 0x2d, 0xaf, 0xcf, 0x5e, 0x99, 0x67,
		0xf3, 0x37, 0x71, 0xf3, 0x26, 0x5c, 0xb9, 0x1e, 0x26, 0x8e, 0x00, 0xd9, 0xad, 0x9f, 0x9d, 0x13,
		0x9f, 0x2c, 0xd3, 0x66, 0xec, 0xf8, 0x6f, 0x7e, 0xcb, 0x7d, 0x36, 0x05, 0x89, 0x71, 0x4a, 0xde,
		0xed, 0x0b, 0xac, 0xa9, 0x39, 0xdd, 0x76, 0xff, 0x46, 0x7b, 0x6b, 0x0e, 0xf4, 0x06, 0xe4, 0xa0,
		0xa1, 0xb3, 0xc5, 0x60, 0x63, 0x8d, 0xbd, 0x2d, 0x9a, 0xec, 0xb1, 0xfb, 0x6c, 0x32, 0x87, 0x7b,
		0x36, 0xf3, 0xe3, 0xab, 0xc8, 0xe9, 0x65, 0xd0, 0x94, 0xd0, 0x94, 0xf3, 0x09, 0xcb, 0x67, 0xde,
		0xab, 0xdd, 0x90, 0x48, 0xee, 0x9b, 0x5e, 0xbe, 0x1e, 0xfd, 0x2f, 0xa0, 0x33, 0x57, 0xa8, 0x33,
		0x25, 0x3a, 0x61, 0xc4, 0xb2, 0x1a, 0xd4, 0xac, 0x08, 0x45, 0x12, 0x96, 0x26, 0x65, 0x15, 0x92,
		0x26, 0x22, 0x6d, 0x55, 0x12, 0x27, 0x23, 0x75, 0x32, 0x92, 0xa7, 0x23, 0x7d, 0x49, 0xc7, 0x9b,
		0xe0, 0xbb, 0x17, 0x65, 0x89, 0x70, 0x21, 0x73, 0xac, 0xc7, 0x96, 0x40, 0x8c, 0x27, 0x92, 0x72,
		0x46, 0x1b, 0xad, 0x72, 0xdc, 0x5c, 0xe0, 0x12, 0xc5, 0xc0, 0xb9, 0xd5, 0x30, 0x3f, 0x95, 0x10,
		0x20, 0x17, 0x06, 0xe4, 0x42, 0x81, 0x5e, 0x38, 0xc8, 0x09, 0x09, 0x49, 0x61, 0x21, 0x6f, 0x7b,
		0x46, 0x52, 0xce, 0xa3, 0xeb, 0xb6, 0x98, 0xe5, 0x50, 0x0c, 0x7a, 0x29, 0xa6, 0x79, 0xc8, 0x94,
		0x20, 0x04, 0x5e, 0xe0, 0x41, 0x12, 0x01, 0xc3, 0x10, 0x3a, 0x10, 0x3a, 0x10, 0x3a, 0x33, 0x94,
		0x63, 0x37, 0x99, 0xc3, 0x6d, 0xfe, 0xe6, 0xb1, 0x27, 0x0a, 0xc1, 0xa3, 0x50, 0xe9, 0x99, 0x3b,
		0x1d, 0xde, 0xca, 0x17, 0xcb, 0x27, 0xa0, 0xc1, 0xd1, 0x03, 0x9e, 0xd4, 0xbe, 0x7c, 0xfb, 0xf5,
		0xe1, 0xa6, 0x76, 0xfd, 0xfb, 0xe9, 0x71, 0x2d, 0x97, 0xfa, 0x42, 0xcf, 0xf5, 0x18, 0xa7, 0x10,
		0x7a, 0x00, 0xa7, 0xfc, 0x62, 0xbb, 0x53, 0x4e, 0x8c, 0x5d, 0x29, 0x83, 0x50, 0xc6, 0x5b, 0x78,
		0xd2, 0xbf, 0x6c, 0x6d, 0x70, 0x0f, 0x83, 0x7f, 0xdc, 0x0c, 0x6e, 0x21, 0x96, 0x1f, 0x51, 0xfe,
		0x0d, 0x89, 0x74, 0xc4, 0x90, 0xd5, 0x8a, 0x8a, 0xda, 0x30, 0xab, 0xfd, 0x2e, 0x60, 0x5f, 0x67,
		0xd0, 0xbe, 0x56, 0xef, 0x7c, 0xd1, 0x62, 0xd6, 0x93, 0x9c, 0xa6, 0x0a, 0x35, 0xd4, 0x81, 0xc4,
		0xda, 0xab, 0xa1, 0xc0, 0xdb, 0xd9, 0x19, 0x0a, 0xad, 0xdd, 0x11, 0xb7, 0xa5, 0x41, 0x72, 0xc4,
		0xea, 0xc6, 0x1d, 0x2d, 0x37, 0x24, 0x86, 0xda, 0x28, 0x7b, 0xe5, 0x4a, 0x90, 0x1a, 0x90, 0x1a,
		0xf0, 0xca, 0xc1, 0x2b, 0x07, 0x03, 0x19, 0x06, 0x32, 0xbc, 0x72, 0xf0, 0xca, 0x41, 0xe8, 0x40,
		0xe8, 0x40, 0xe8, 0xc0, 0x2b, 0x07, 0xaf, 0xdc, 0xaa, 0xbd, 0x72, 0x9a, 0x87, 0x9c, 0xc6, 0x70,
		0xca, 0x65, 0x6f, 0xc8, 0xa9, 0x60, 0x5a, 0x16, 0xe6, 0x9c, 0x12, 0x73, 0x02, 0x29, 0x07, 0xe8,
		0xe8, 0x27, 0xb8, 0x8c, 0xe6, 0x73, 0x9b, 0x91, 0x0f, 0x2c, 0x92, 0x25, 0xab, 0x7a, 0xbe, 0x18,
		0x7c, 0x87, 0x64, 0xe0, 0xd4, 0x26, 0x03, 0x0f, 0x6f, 0x48, 0x3c, 0x0d, 0x78, 0xb4, 0x50, 0x73,
		0x02, 0x70, 0x09, 0x09, 0xc0, 0xe4, 0xd6, 0x4e, 0xe6, 0x13, 0x80, 0xad, 0x4e, 0xc7, 0x1c, 0x8a,
		0x62, 0xc9, 0x58, 0x43, 0xb8, 0x03, 0x82, 0x94, 0x9a, 0x8d, 0x7e, 0x84, 0x1b, 0x64, 0x8d, 0x31,
		0xf5, 0x20, 0xa5, 0xcf, 0xbd, 0xc5, 0xa3, 0xca, 0x97, 0x8a, 0xeb, 0xcf, 0x5a, 0x9f, 0x90, 0xfd,
		0xe0, 0x9e, 0x65, 0x76, 0x1d, 0x3f, 0x98, 0x95, 0x21, 0xf7, 0xac, 0x1e, 0x7b, 0x62, 0x1e, 0x73,
		0x1a, 0x2b, 0x99, 0x08, 0x30, 0x3a, 0xe8, 0xd3, 0xda, 0xed, 0x57, 0xe3, 0xfa, 0xeb, 0xb1, 0x51,
		0xde, 0x2f, 0xed, 0x6f, 0x1b, 0x37, 0x2c, 0x68, 0x0f, 0x61, 0x54, 0x76, 0x4a, 0x3b, 0xe5, 0x9d,
		0x94, 0x79, 0xdc, 0xc6, 0x07, 0x96, 0x66, 0xa7, 0xdb, 0xe2, 0x13, 0xc5, 0x68, 0x9b, 0x18, 0xc7,
		0xd9, 0xf6, 0x15, 0x6a, 0x64, 0xfa, 0x8b, 0xa1, 0x1b, 0xa1, 0x1b, 0xa1, 0x1b, 0xa9, 0x74, 0xa3,
		0x2e, 0x1e, 0xb7, 0x9b, 0x4a, 0x5c, 0x6e, 0x37, 0xc1, 0xe7, 0xe0, 0x73, 0xf0, 0x39, 0x30, 0xb0,
		0x3e, 0x0c, 0x7c, 0x00, 0x0c, 0x4c, 0x8c, 0x81, 0x0f, 0x80, 0x81, 0x63, 0x1d, 0x67, 0xc7, 0xb3,
		0x5d, 0xa1, 0xae, 0x40, 0x33, 0x64, 0x1d, 0xee, 0x00, 0x2d, 0x09, 0x2d, 0xb9, 0xb6, 0x5a, 0xb2,
		0x6b, 0x3b, 0xfc, 0xb3, 0x82, 0x92, 0x2c, 0x63, 0x8e, 0xa3, 0xe4, 0x3e, 0x98, 0xe3, 0xb8, 0xf4,
		0x88, 0x4b, 0x65, 0x8c, 0x6d, 0x4c, 0x58, 0x19, 0x03, 0xc4, 0xce, 0x40, 0xae, 0x22, 0x30, 0x2c,
		0x2d, 0x86, 0x2d, 0x02, 0xc2, 0xc6, 0x83, 0xb0, 0x6e, 0x43, 0xc5, 0xc7, 0x33, 0x5c, 0x0f, 0xf8,
		0x0a, 0xf8, 0x0a, 0x27, 0x0f, 0x9c, 0x3c, 0xda, 0xf4, 0x63, 0x05, 0x4e, 0x1e, 0x62, 0x05, 0x59,
		0xd9, 0x64, 0x27, 0x0f, 0x69, 0x86, 0x51, 0xed, 0x47, 0x80, 0xfa, 0xe3, 0xb3, 0x8d, 0x7c, 0x4a,
		0x97, 0xdb, 0x30, 0xd9, 0x0f, 0x7e, 0xc4, 0x59, 0x8b, 0xb5, 0x19, 0xf7, 0xde, 0x4c, 0x8b, 0xbb,
		0x6d, 0xbb, 0xa1, 0x96, 0xe3, 0x15, 0xd8, 0x18, 0x0a, 0x49, 0x5e, 0xd4, 0x99, 0x5d, 0x31, 0x0b,
		0x39, 0x55, 0xe4, 0x9e, 0x82, 0xbc, 0x53, 0x50, 0x24, 0x53, 0xdc, 0x68, 0x98, 0xc6, 0xed, 0x0b,
		0x33, 0x6e, 0x82, 0xce, 0xcc, 0xc6, 0x95, 0xe7, 0x72, 0xb7, 0xe1, 0xb6, 0x56, 0x0c, 0x2d, 0x54,
		0xa5, 0x9a, 0x1e, 0x74, 0x11, 0xe7, 0xdc, 0xb2, 0x36, 0xdc, 0x24, 0x6d, 0x95, 0x02, 0x41, 0x12,
		0xf7, 0xae, 0x58, 0xde, 0xad, 0x21, 0x91, 0xbb, 0x1e, 0x54, 0xbd, 0x8c, 0xfe, 0x99, 0x4b, 0x70,
		0x3a, 0x19, 0x5a, 0xf8, 0x23, 0x1b, 0x19, 0x2d, 0xfc, 0x63, 0xaf, 0xd9, 0xb0, 0x16, 0xfe, 0xe4,
		0xd3, 0x9a, 0x26, 0xc5, 0x5d, 0x56, 0xe7, 0x35, 0x2d, 0x1f, 0x36, 0x24, 0x76, 0x1a, 0x4a, 0x33,
		0x9b, 0xdc, 0xae, 0xc3, 0xcd, 0x8e, 0x6b, 0x0f, 0xaa, 0xfb, 0x96, 0xcd, 0x6d, 0x9a, 0xfc, 0xb6,
		0xe2, 0xec, 0xa6, 0x12, 0xcd, 0xec, 0xa6, 0xc5, 0xc3, 0x21, 0xd3, 0x3b, 0xb6, 0x69, 0xe1, 0x70,
		0x47, 0xe2, 0x89, 0x4d, 0x13, 0xaf, 0x2d, 0x7e, 0xf9, 0xd9, 0xe4, 0xa2, 0x6c, 0x4c, 0xa4, 0x88,
		0x37, 0x27, 0x34, 0x7b, 0xf5, 0x67, 0xb1, 0xe6, 0x80, 0x26, 0x54, 0x7a, 0x26, 0x54, 0xc1, 0x13,
		0xbe, 0x1c, 0x81, 0xaa, 0x1d, 0x0c, 0xa3, 0x35, 0x30, 0x8c, 0x96, 0x0a, 0xdc, 0x89, 0x37, 0xfc,
		0x93, 0x69, 0xf4, 0x37, 0xd9, 0xe0, 0x6f, 0x60, 0xef, 0x05, 0xf4, 0x9e, 0xa4, 0x11, 0x26, 0xd4,
		0xc4, 0x4f, 0xaa, 0x79, 0x5f, 0xda, 0x8b, 0x41, 0xc1, 0x97, 0x89, 0xf3, 0xa5, 0x78, 0x09, 0xe8,
		0xab, 0x65, 0xb7, 0xa4, 0x82, 0x29, 0xe3, 0x1a, 0xd0, 0x70, 0x8b, 0xcd, 0x88, 0x8d, 0x8a, 0x91,
		0xb5, 0x0e, 0xdf, 0x65, 0x3a, 0xc3, 0xa2, 0x42, 0x64, 0x2f, 0xe9, 0x9b, 0x5c, 0x49, 0x42, 0x9f,
		0xd0, 0xec, 0xf4, 0x8f, 0xd4, 0xfd, 0x19, 0x19, 0x7d, 0x92, 0xfb, 0x20, 0xa3, 0x6f, 0xe9, 0x11,
		0xd3, 0xcd, 0x62, 0xcf, 0xc2, 0xa9, 0x6f, 0x50, 0xb2, 0x92, 0x5a, 0x57, 0x86, 0x0d, 0xea, 0xc8,
		0x00, 0x65, 0xbc, 0x41, 0xca, 0x78, 0x3d, 0x6a, 0x4d, 0x7d, 0xfb, 0x6f, 0x95, 0xee, 0xee, 0xfd,
		0xd5, 0xe0, 0x6d, 0xf0, 0x36, 0x80, 0x36, 0x80, 0x36, 0x80, 0x36, 0x80, 0x36, 0x80, 0xb6, 0x92,
		0x32, 0xe6, 0xae, 0x67, 0x3d, 0x33, 0xb3, 0xe1, 0xb6, 0x3b, 0xae, 0xc3, 0x62, 0x44, 0xe3, 0x16,
		0xa0, 0x93, 0x8f, 0x5b, 0x41, 0x4d, 0x43, 0x4d, 0xaf, 0x99, 0x9a, 0x5e, 0xf1, 0xbc, 0xa6, 0x5d,
		0xb7, 0x61, 0x76, 0x5a, 0x16, 0x7f, 0x72, 0xbd, 0xf6, 0x51, 0xc8, 0x68, 0xfe, 0xfc, 0x8f, 0xa7,
		0x3e, 0x8d, 0x1f, 0xff, 0xd1, 0x2b, 0x70, 0xba, 0xdc, 0x6e, 0xd9, 0x7f, 0x33, 0x85, 0x42, 0xa4,
		0x70, 0x07, 0x88, 0x17, 0x88, 0x17, 0x58, 0x01, 0xb0, 0x02, 0x60, 0x05, 0xc0, 0x0a, 0x80, 0x15,
		0x20, 0xf7, 0xcd, 0xd4, 0x54, 0x27, 0x4c, 0xa4, 0x71, 0x4e, 0xfe, 0x43, 0x78, 0x7a, 0x47, 0xdc,
		0x44, 0xd5, 0xfe, 0x25, 0xae, 0x82, 0xcb, 0x4d, 0xfc, 0x2e, 0x32, 0xa9, 0x43, 0x77, 0x22, 0xf4,
		0x70, 0x12, 0x47, 0x8c, 0x58, 0x86, 0xd8, 0xf8, 0x0d, 0xf1, 0xb1, 0x1b, 0x24, 0xe3, 0x36, 0xc4,
		0xc6, 0x6c, 0xac, 0x2c, 0x4b, 0x3c, 0x82, 0x0c, 0x09, 0xf3, 0xc5, 0xe7, 0x12, 0x5e, 0x46, 0xf3,
		0xc6, 0x97, 0xe7, 0x5e, 0xcb, 0x9d, 0x8c, 0x4a, 0xfa, 0xb8, 0xc3, 0x3b, 0xcb, 0xb3, 0xc6, 0xfb,
		0x5f, 0x52, 0x4c, 0x16, 0x2f, 0x20, 0x59, 0x3c, 0xa9, 0x64, 0xf1, 0xc6, 0xe8, 0xcc, 0x63, 0xe6,
		0x89, 0xc7, 0x9a, 0xc3, 0x8e, 0x14, 0x71, 0x5a, 0x7b, 0x2d, 0xcd, 0x29, 0xe2, 0x83, 0x79, 0xb7,
		0xa6, 0xc3, 0x3b, 0xa6, 0xd5, 0x0d, 0xa4, 0x9a, 0x60, 0x5a, 0xea, 0xc7, 0x0d, 0xe2, 0xa6, 0x23,
		0x4a, 0x0c, 0xca, 0x15, 0x19, 0x8c, 0x5b, 0x47, 0x02, 0x7b, 0x82, 0x2e, 0x0d, 0x24, 0xb0, 0xcb,
		0x8d, 0x8f, 0x15, 0x1c, 0x17, 0x4b, 0x93, 0x7f, 0x2e, 0x3a, 0x2b, 0x5b, 0x72, 0x36, 0x36, 0x58,
		0x1c, 0x2c, 0x0e, 0x16, 0x5f, 0x0d, 0x8b, 0xf7, 0xb5, 0xb1, 0x1f, 0x10, 0x8a, 0x69, 0x35, 0x9b,
		0x1e, 0xf3, 0x7d, 0x89, 0x32, 0xb0, 0xd9, 0x3d, 0xc0, 0x70, 0x60, 0xb8, 0x84, 0x19, 0xce, 0xee,
		0x08, 0x52, 0xdf, 0x14, 0xcf, 0x1d, 0x0a, 0xac, 0x19, 0xde, 0x63, 0x62, 0x8d, 0x70, 0xec, 0xce,
		0xeb, 0xbe, 0xc4, 0xb3, 0xcd, 0x3c, 0xe3, 0x67, 0xb9, 0xa0, 0x29, 0x67, 0x9e, 0x23, 0x1d, 0xd9,
		0xc8, 0x6d, 0xdd, 0x15, 0xcc, 0xc3, 0xfa, 0xfb, 0x5d, 0xd1, 0x3c, 0xac, 0x0f, 0x7e, 0x2d, 0x06,
		0x3f, 0x7e, 0x96, 0x7a, 0xef, 0xa5, 0xbb, 0x82, 0xb9, 0x3f, 0xfc, 0xb4, 0x54, 0xbe, 0x2b, 0x98,
		0xe5, 0x7a, 0x7e, 0xeb, 0xfe, 0x7e, 0x47, 0x74, 0x4d, 0xfe, 0xe7, 0x5e, 0x4f, 0x3c, 0x8e, 0x55,
		0x97, 0x39, 0x8e, 0xcb, 0x9b, 0xd3, 0xff, 0x28, 0x9f, 0xc9, 0x9f, 0x5b, 0x49, 0x9d, 0x4a, 0xfe,
		0x1f, 0xb9, 0x74, 0xb5, 0xa7, 0x55, 0x63, 0x83, 0x4a, 0x76, 0xd9, 0x20, 0x78, 0x7b, 0x96, 0xf9,
		0x54, 0x35, 0xbf, 0xd6, 0x7f, 0x16, 0xb7, 0xf7, 0x7b, 0x47, 0xf9, 0x9f, 0x07, 0xbd, 0x8f, 0x1f,
		0xbe, 0xcf, 0xfb, 0x5a, 0x71, 0xfb, 0xa0, 0x77, 0x14, 0xf1, 0x97, 0x4a, 0xef, 0x28, 0xe6, 0x1e,
		0xe5, 0xde, 0xd6, 0xcc, 0x57, 0xfb, 0x9f, 0x97, 0xa2, 0x16, 0xec, 0x47, 0x2c, 0xd8, 0x8b, 0x5a,
		0xb0, 0x17, 0xb1, 0x20, 0xf2, 0x96, 0x4a, 0x11, 0x0b, 0xca, 0xbd, 0xf7, 0x99, 0xef, 0x6f, 0xcd,
		0xff, 0x6a, 0xa5, 0x97, 0x7f, 0x8f, 0xfa, 0xdb, 0x41, 0xef, 0xfd, 0x28, 0x9f, 0xcf, 0xa0, 0x60,
		0x00, 0x99, 0x24, 0x4f, 0x26, 0xfa, 0x05, 0x25, 0x75, 0x4f, 0xb4, 0x8c, 0x36, 0x11, 0x72, 0x78,
		0x67, 0x37, 0x96, 0x73, 0x59, 0x20, 0xec, 0x71, 0xc1, 0x3b, 0x0f, 0x43, 0xe3, 0x40, 0xc3, 0x80,
		0xef, 0xbe, 0x7d, 0xf3, 0x17, 0x7b, 0xf3, 0xe3, 0x3b, 0xcf, 0xc3, 0x15, 0x70, 0x9f, 0xc3, 0x7d,
		0x3e, 0x45, 0x44, 0x72, 0xd6, 0x75, 0x7f, 0xa1, 0xe6, 0x7e, 0x0e, 0x30, 0xa9, 0xd7, 0xd5, 0xa4,
		0x16, 0xee, 0xe7, 0x10, 0x33, 0x54, 0x18, 0xf9, 0x9a, 0x63, 0x4b, 0x77, 0x05, 0xc2, 0x95, 0x26,
		0x60, 0x15, 0x42, 0x56, 0x27, 0x68, 0x55, 0xc2, 0x26, 0x23, 0x70, 0x32, 0x42, 0x27, 0x21, 0x78,
		0x71, 0x8c, 0x24, 0x61, 0x7a, 0x0a, 0x33, 0x42, 0xb8, 0xf0, 0x2f, 0xf6, 0x66, 0x4a, 0x8c, 0x7d,
		0x98, 0x21, 0x97, 0xe1, 0x3e, 0x92, 0x07, 0x2c, 0x97, 0x7b, 0xad, 0xcc, 0x28, 0x14, 0x0c, 0x43,
		0xc7, 0x38, 0x54, 0x0c, 0x44, 0xce, 0x48, 0xe4, 0x0c, 0x45, 0xca, 0x58, 0x72, 0x0c, 0x26, 0xc9,
		0x68, 0xf2, 0xce, 0xdc, 0x48, 0x7a, 0xe9, 0xda, 0x0e, 0x2f, 0x56, 0x54, 0xe8, 0x65, 0xc8, 0x3d,
		0x15, 0x85, 0x2d, 0xd4, 0x72, 0xbc, 0xe5, 0x3d, 0x60, 0x33, 0x37, 0x42, 0x91, 0xf3, 0x1d, 0x6e,
		0x46, 0x94, 0xfb, 0x1d, 0xee, 0x47, 0x9d, 0x8d, 0x3c, 0xa6, 0x05, 0xaa, 0xac, 0x64, 0x45, 0xb2,
		0x9e, 0x7e, 0x15, 0x04, 0xb9, 0xe1, 0x33, 0xaf, 0xa2, 0x52, 0x2e, 0xef, 0x95, 0x37, 0xef, 0x75,
		0x7c, 0x5a, 0xcd, 0xea, 0x7a, 0x42, 0x49, 0xea, 0x12, 0xe4, 0x16, 0x20, 0x06, 0xae, 0x22, 0x45,
		0xa7, 0xb0, 0x47, 0xb0, 0x13, 0xd0, 0x07, 0xd0, 0x07, 0xd0, 0x87, 0x10, 0xbd, 0xd8, 0x4d, 0xe6,
		0x70, 0x9b, 0xbf, 0xc9, 0x15, 0xad, 0xce, 0x58, 0xb8, 0x0a, 0xa2, 0x3d, 0x77, 0x3a, 0xbc, 0x95,
		0x2f, 0x96, 0x4f, 0x40, 0x7e, 0xa3, 0x07, 0xbc, 0xb8, 0xbd, 0x7a, 0xa8, 0x7e, 0xbb, 0xfd, 0xd7,
		0xc3, 0xed, 0x1f, 0x57, 0x35, 0x55, 0x12, 0x0c, 0xb4, 0x98, 0xaf, 0x8c, 0x93, 0x68, 0xb0, 0xd2,
		0xfc, 0xc7, 0x3c, 0x3f, 0x29, 0xe7, 0x56, 0xac, 0xaf, 0xea, 0xa9, 0x2f, 0xaa, 0x92, 0xd5, 0x57,
		0xaf, 0x43, 0x14, 0x43, 0xa0, 0xb0, 0x06, 0x5b, 0x41, 0x63, 0x41, 0x63, 0x41, 0x63, 0x09, 0xd1,
		0x8b, 0x74, 0x97, 0xb3, 0x19, 0x65, 0xf5, 0x39, 0x29, 0x69, 0xa3, 0xd5, 0xf5, 0x27, 0x59, 0x7a,
		0x19, 0xae, 0x17, 0x09, 0x6e, 0x8e, 0x82, 0x7f, 0xa3, 0x5f, 0x76, 0xa5, 0xfc, 0xe1, 0x86, 0x58,
		0xf4, 0xf3, 0x82, 0x77, 0x7e, 0x63, 0x6f, 0xfe, 0xf0, 0x67, 0xac, 0x60, 0xa8, 0xfc, 0x1b, 0x10,
		0xe9, 0x55, 0x21, 0xe9, 0x3b, 0x55, 0xf3, 0x99, 0xa2, 0x4f, 0xc5, 0x4a, 0x64, 0x3a, 0xfa, 0x54,
		0x88, 0xbc, 0xef, 0x15, 0xb7, 0xc1, 0xd9, 0xd9, 0x19, 0x0a, 0xa6, 0xdd, 0x21, 0x8b, 0xa5, 0xa2,
		0x93, 0x96, 0xc8, 0xc0, 0x83, 0x39, 0x5a, 0x4f, 0xac, 0xce, 0xdd, 0xa0, 0x88, 0x3b, 0x96, 0x20,
		0x2a, 0x20, 0x2a, 0x16, 0xde, 0x21, 0xe2, 0x8e, 0xb0, 0xa3, 0x60, 0x47, 0x65, 0xd2, 0x8e, 0x42,
		0xdc, 0x71, 0xf2, 0x46, 0x10, 0x77, 0x44, 0xdc, 0x71, 0x0d, 0x5f, 0x07, 0xe2, 0x8e, 0x73, 0x91,
		0x07, 0xe2, 0x8e, 0x40, 0x1f, 0x40, 0x1f, 0xab, 0x44, 0x1f, 0x88, 0x3b, 0x0a, 0x6b, 0x31, 0xc4,
		0x1d, 0xb5, 0x68, 0x1d, 0x03, 0x71, 0x47, 0x68, 0x2c, 0x68, 0x2c, 0x68, 0xac, 0x25, 0xf4, 0x82,
		0xb8, 0xe3, 0x07, 0x9a, 0x58, 0x65, 0xdc, 0x51, 0xc6, 0x1d, 0x6e, 0x28, 0x85, 0x1d, 0x05, 0x5a,
		0xbf, 0x8a, 0x9f, 0x3f, 0x6d, 0x55, 0xd4, 0xb0, 0x35, 0xac, 0x90, 0x6b, 0x54, 0xac, 0x49, 0xec,
		0xa4, 0xdb, 0x44, 0xac, 0x59, 0xec, 0xa4, 0x95, 0xaf, 0xdc, 0x34, 0x36, 0xdc, 0x4c, 0xa8, 0x79,
		0xac, 0xe8, 0x71, 0xea, 0xee, 0x6d, 0x3c, 0x8f, 0xc0, 0xe9, 0x3b, 0x1a, 0xcf, 0x92, 0x74, 0x6e,
		0xed, 0x6b, 0xb1, 0x63, 0xd6, 0x2a, 0xcb, 0x9d, 0xa2, 0x8e, 0x72, 0x6c, 0x9f, 0x79, 0xaf, 0xcc,
		0x13, 0xa8, 0xc6, 0x1e, 0x2d, 0x40, 0x31, 0x36, 0x8a, 0xb1, 0x27, 0x49, 0x48, 0x62, 0xb2, 0xfe,
		0x60, 0x1d, 0x4a, 0xb1, 0x13, 0x04, 0xee, 0x9b, 0x3d, 0x5a, 0x5f, 0xb0, 0x27, 0xdf, 0xcc, 0x7b,
		0x96, 0xeb, 0x97, 0x84, 0xfc, 0xa9, 0x95, 0xd8, 0xa6, 0xc8, 0x9f, 0x12, 0x79, 0xdf, 0xa9, 0xc9,
		0x9f, 0x1a, 0xf1, 0x58, 0x0a, 0x12, 0xa8, 0xd0, 0xba, 0x01, 0xd2, 0x62, 0x1d, 0xa5, 0x85, 0x74,
		0x0a, 0x95, 0xac, 0x02, 0x25, 0x52, 0xa4, 0x70, 0x0a, 0xc3, 0x29, 0xbc, 0xf1, 0x4e, 0xe1, 0x17,
		0xd7, 0xe7, 0x14, 0x2e, 0xe1, 0x43, 0x85, 0x3d, 0xa4, 0x7a, 0xf6, 0x7e, 0xfc, 0x8f, 0x20, 0x85,
		0x4a, 0xa9, 0x5b, 0xb1, 0xce, 0x13, 0xa2, 0x3d, 0x29, 0xba, 0x13, 0x9b, 0x73, 0x72, 0x4a, 0xdd,
		0x90, 0x97, 0x9e, 0xe1, 0x67, 0xc2, 0x3d, 0x55, 0x1b, 0x82, 0x46, 0x6e, 0x9c, 0xde, 0xae, 0xca,
		0x51, 0xff, 0xd5, 0x29, 0x8f, 0x95, 0xa2, 0xd9, 0x6a, 0xe4, 0xee, 0xe9, 0xee, 0xce, 0x1c, 0x79,
		0xbe, 0x24, 0x3b, 0xf5, 0xb6, 0x53, 0xcc, 0xf6, 0x15, 0xb0, 0x3d, 0xda, 0x03, 0x67, 0xa6, 0x8b,
		0xf4, 0xda, 0x08, 0x42, 0x90, 0x5b, 0x26, 0xba, 0x51, 0x6b, 0x56, 0x0c, 0x9f, 0x56, 0x7b, 0x1f,
		0x8a, 0x8a, 0x89, 0x10, 0xb9, 0x37, 0xdd, 0xb6, 0x65, 0x3b, 0x66, 0x8c, 0x99, 0xb2, 0x49, 0xeb,
		0x9f, 0xdc, 0x19, 0x73, 0x9e, 0x03, 0xe7, 0x64, 0xea, 0xc0, 0x3b, 0x65, 0xe5, 0x48, 0xb8, 0x69,
		0x38, 0x52, 0x7b, 0x9b, 0x76, 0x5f, 0x5d, 0xa5, 0x0b, 0x63, 0x52, 0xa2, 0x2e, 0x61, 0x20, 0x86,
		0x6f, 0x06, 0x75, 0x85, 0xc9, 0xcc, 0x2b, 0x2b, 0x95, 0xf7, 0xf0, 0xd2, 0xc8, 0x44, 0x2b, 0x91,
		0x80, 0x26, 0x90, 0x40, 0xd4, 0x58, 0x24, 0xb7, 0xb5, 0xb5, 0xb5, 0x75, 0x67, 0x99, 0x7f, 0x57,
		0xcd, 0xff, 0x16, 0xcc, 0xc3, 0x87, 0xfa, 0xc4, 0x3f, 0xee, 0xef, 0xcd, 0x87, 0x7a, 0xfe, 0x67,
		0x61, 0xbb, 0x52, 0xec, 0xe5, 0x7f, 0x19, 0x7f, 0x5e, 0xbf, 0xbf, 0xdf, 0xc9, 0xff, 0x53, 0x66,
		0xd5, 0x2f, 0xf9, 0xf7, 0xfe, 0xda, 0x5c, 0x3a, 0x8e, 0x52, 0x07, 0xb6, 0xeb, 0x63, 0xba, 0xe4,
		0x0f, 0x94, 0x00, 0xcd, 0xd4, 0x51, 0xa4, 0x35, 0xf3, 0x2e, 0x2d, 0xdf, 0x77, 0x1b, 0x76, 0x90,
		0x16, 0x46, 0x54, 0xac, 0x35, 0xb3, 0xa3, 0xa4, 0xef, 0x58, 0x66, 0xa0, 0xe7, 0xcc, 0x26, 0x37,
		0xb5, 0xeb, 0xdf, 0x6b, 0xd7, 0x72, 0xa4, 0x53, 0x47, 0x98, 0x06, 0x61, 0x1a, 0x81, 0x0d, 0x11,
		0xa6, 0x31, 0x72, 0xcc, 0xe9, 0xb6, 0x99, 0x37, 0xc8, 0x32, 0x25, 0x88, 0xd6, 0xec, 0x2b, 0xec,
		0x51, 0x73, 0xba, 0xed, 0xfe, 0x43, 0xa5, 0xb9, 0xe4, 0xc8, 0x7e, 0xec, 0x7a, 0x3e, 0x57, 0x97,
		0xb9, 0xc3, 0x7d, 0x56, 0x29, 0x69, 0x05, 0x46, 0x29, 0x43, 0xd0, 0x42, 0xd0, 0x42, 0xd0, 0xaa,
		0xd1, 0x8b, 0xf8, 0x68, 0xe8, 0x48, 0x21, 0x5b, 0x4c, 0xb1, 0x80, 0xec, 0xb8, 0x1e, 0x81, 0x78,
		0x0c, 0x76, 0x59, 0xa5, 0x70, 0x2c, 0x96, 0xf6, 0x20, 0x1a, 0x21, 0x1a, 0x21, 0x1a, 0x93, 0x10,
		0x8d, 0x7d, 0x6e, 0x37, 0x9d, 0x6e, 0xfb, 0x31, 0x76, 0x95, 0xc5, 0x22, 0x16, 0x42, 0xd3, 0xa5,
		0x8f, 0x9b, 0xa1, 0xe9, 0x92, 0xd2, 0xab, 0x40, 0xd3, 0x25, 0x34, 0x5d, 0xd2, 0x08, 0x98, 0x3c,
		0xf6, 0xc4, 0x3c, 0x02, 0xc8, 0x34, 0xd8, 0x07, 0x16, 0x25, 0x60, 0x13, 0x60, 0x13, 0x2c, 0xca,
		0xf5, 0xb1, 0x28, 0x5f, 0x99, 0xe7, 0xcb, 0xb6, 0xd2, 0x98, 0x3a, 0xaf, 0xd1, 0x46, 0xab, 0x14,
		0x91, 0xfb, 0x10, 0x8f, 0x10, 0x8f, 0x10, 0x8f, 0x49, 0x88, 0xc7, 0xae, 0xed, 0xf0, 0xcf, 0x04,
		0xc2, 0xb1, 0x0c, 0x7b, 0x32, 0xc2, 0x88, 0x29, 0xc2, 0x9e, 0x4c, 0x8b, 0x3d, 0xb9, 0x0f, 0x5b,
		0x72, 0xdd, 0x6c, 0xc9, 0xb5, 0x69, 0x51, 0x36, 0xec, 0xc4, 0x33, 0xfc, 0x99, 0xc8, 0x60, 0xa4,
		0x9b, 0xc1, 0x25, 0x87, 0x3f, 0x53, 0x34, 0x18, 0x09, 0xb3, 0x4e, 0x34, 0x83, 0x3d, 0x14, 0xea,
		0xaf, 0x40, 0x9a, 0xa0, 0x50, 0x1f, 0x76, 0x12, 0xec, 0x24, 0x14, 0xea, 0x4b, 0xef, 0x81, 0x42,
		0xfd, 0x44, 0x4f, 0x8a, 0xee, 0xc4, 0xe6, 0x9c, 0x1c, 0x0a, 0xf5, 0x51, 0xa8, 0x8f, 0x42, 0x7d,
		0x12, 0xab, 0x51, 0x83, 0xfb, 0xc1, 0x40, 0xa1, 0x3e, 0x0a, 0xf5, 0x51, 0xa8, 0xbf, 0x3e, 0x82,
		0x10, 0xe4, 0x86, 0x42, 0x7d, 0x14, 0xea, 0xa3, 0x50, 0x5f, 0xe5, 0xce, 0x50, 0xa8, 0x3f, 0x45,
		0x4a, 0x28, 0xd4, 0x47, 0xa1, 0x3e, 0xa1, 0x68, 0x35, 0x50, 0xa8, 0x8f, 0x42, 0xfd, 0xd8, 0x98,
		0x0e, 0x85, 0xfa, 0xda, 0xaf, 0x8b, 0x42, 0x7d, 0x14, 0xea, 0xcb, 0x31, 0x3d, 0xc2, 0x34, 0x71,
		0x36, 0x44, 0x98, 0xe6, 0xa3, 0xbb, 0x1e, 0x85, 0xfa, 0x49, 0x4b, 0x5f, 0x14, 0xea, 0x43, 0xd0,
		0x42, 0xd0, 0x42, 0xd0, 0x8a, 0xd3, 0xcb, 0x86, 0x94, 0x55, 0xb8, 0x4f, 0x4f, 0x3e, 0x23, 0x10,
		0x90, 0xc3, 0x7d, 0x20, 0x68, 0x20, 0x68, 0x20, 0x68, 0x84, 0xe8, 0xa5, 0x6b, 0x3b, 0xbc, 0xb2,
		0x4f, 0x20, 0x67, 0x3e, 0xa3, 0x42, 0x21, 0xc2, 0x91, 0x89, 0x8a, 0x77, 0xa9, 0x57, 0xa1, 0xa3,
		0x42, 0x41, 0x6d, 0x8e, 0xf1, 0xba, 0xbc, 0x1d, 0xf8, 0xc9, 0x66, 0x0e, 0xb9, 0xe3, 0xb6, 0x5a,
		0xa6, 0xed, 0x70, 0xe6, 0xbd, 0x5a, 0x2d, 0x8a, 0xd6, 0x41, 0x93, 0xdb, 0x01, 0x96, 0x00, 0x96,
		0x00, 0x96, 0x08, 0xc3, 0x92, 0xbd, 0x12, 0x01, 0x2c, 0x39, 0x00, 0x2c, 0x01, 0x2c, 0x49, 0x3b,
		0x2c, 0xd9, 0x2f, 0x1d, 0xee, 0x1f, 0x56, 0x0e, 0x4a, 0x87, 0x00, 0x23, 0x00, 0x23, 0x68, 0x5f,
		0x08, 0x87, 0x31, 0x00, 0x13, 0x00, 0x93, 0x38, 0xb7, 0xa3, 0x7d, 0x21, 0x50, 0x13, 0xda, 0x17,
		0x02, 0x30, 0x6d, 0x1e, 0x60, 0x42, 0xfb, 0x42, 0xc0, 0x26, 0xc0, 0x26, 0xc0, 0x26, 0x61, 0x7a,
		0xd9, 0x90, 0x38, 0xbb, 0xe7, 0xba, 0xdc, 0x6c, 0xb2, 0x96, 0xf5, 0xa6, 0x2e, 0x24, 0x27, 0xf6,
		0x82, 0xc0, 0x81, 0xc0, 0x81, 0xc0, 0x11, 0xa2, 0x17, 0x38, 0xb6, 0x61, 0xa2, 0xc1, 0xb1, 0x0d,
		0x3b, 0x2d, 0x6d, 0x76, 0x9a, 0xa4, 0x60, 0x64, 0x3f, 0xb8, 0x67, 0x99, 0x5d, 0xc7, 0xe7, 0xd6,
		0x63, 0x4b, 0x51, 0x44, 0x06, 0xc6, 0x17, 0x73, 0x1a, 0xa9, 0x6a, 0xc2, 0x73, 0xfd, 0xf5, 0xd8,
		0x28, 0x1f, 0x16, 0xca, 0x86, 0x69, 0x5c, 0x30, 0xfe, 0xdd, 0xf5, 0xfe, 0x32, 0x6e, 0xed, 0x36,
		0x33, 0xae, 0x3c, 0x97, 0xbb, 0x0d, 0xb7, 0x65, 0xfc, 0x3e, 0x68, 0xe8, 0x6c, 0xec, 0x1f, 0x8d,
		0x3f, 0xb3, 0x9c, 0xe6, 0xbd, 0x53, 0x6d, 0x3d, 0xbb, 0x9e, 0xcd, 0x5f, 0xda, 0xbe, 0x71, 0xd3,
		0x61, 0x0d, 0xfb, 0xc9, 0x6e, 0xa8, 0x26, 0xce, 0x53, 0x63, 0x86, 0x79, 0xd8, 0x61, 0xfc, 0x16,
		0x88, 0x38, 0x8b, 0x1a, 0x46, 0xcc, 0x85, 0x13, 0x1a, 0x5e, 0x13, 0x3c, 0x35, 0xda, 0x0c, 0x11,
		0xdb, 0xef, 0x50, 0xf5, 0x53, 0xff, 0xb8, 0x21, 0x4c, 0x12, 0x98, 0x24, 0x30, 0x49, 0x84, 0x4d,
		0x12, 0xa4, 0x00, 0xc3, 0x24, 0x41, 0x0a, 0x30, 0x8c, 0x13, 0x18, 0x27, 0x30, 0x4e, 0x60, 0x9c,
		0xc0, 0x38, 0xd9, 0x48, 0xe3, 0xc4, 0xe7, 0x9e, 0xc5, 0x07, 0x55, 0xe5, 0x6a, 0x46, 0xc9, 0x68,
		0x23, 0x18, 0x23, 0x30, 0x46, 0x60, 0x8c, 0x08, 0x1b, 0x23, 0x18, 0x98, 0x04, 0x5b, 0x64, 0x23,
		0x6c, 0x91, 0x52, 0x19, 0xa6, 0x07, 0x4c, 0x0f, 0x98, 0x1e, 0x30, 0x3d, 0x60, 0x7a, 0x6c, 0xb6,
		0xe9, 0x81, 0xf9, 0xb2, 0xc8, 0x5f, 0x85, 0xb9, 0x04, 0x73, 0x09, 0xe6, 0x52, 0xda, 0xcc, 0x25,
		0xcc, 0x97, 0x4d, 0x8d, 0xb9, 0x84, 0xf9, 0xb2, 0x6b, 0x07, 0x95, 0xd6, 0x75, 0xbe, 0xac, 0xcc,
		0x8c, 0x54, 0x43, 0x69, 0xbc, 0xec, 0x4d, 0x70, 0x45, 0x5d, 0xd3, 0x65, 0x3f, 0x11, 0xbe, 0x9f,
		0x3e, 0xb4, 0x10, 0x1f, 0x97, 0x99, 0x3b, 0xb3, 0x7d, 0x5e, 0xe5, 0x5c, 0xac, 0xcc, 0xab, 0xaf,
		0x13, 0x6a, 0x2d, 0xd6, 0x87, 0x09, 0x82, 0x8c, 0xde, 0x17, 0x61, 0x13, 0x2b, 0xd5, 0xc2, 0xc6,
		0xb9, 0x4b, 0xaf, 0xc9, 0x3c, 0xd6, 0xfc, 0xd2, 0x7f, 0x70, 0xa7, 0xdb, 0x6a, 0x91, 0x9e, 0xa7,
		0x24, 0x9d, 0x2b, 0xd0, 0x77, 0x4e, 0x68, 0xda, 0xb0, 0x1c, 0x45, 0xc7, 0xa3, 0xe5, 0xe5, 0x94,
		0xb9, 0xf8, 0x1b, 0x4b, 0xce, 0x58, 0xf4, 0x6c, 0x65, 0xce, 0x34, 0xc6, 0x61, 0x8a, 0x1f, 0xe2,
		0xe2, 0xd3, 0x8b, 0x3e, 0x93, 0x05, 0xe7, 0x11, 0x73, 0x6e, 0xb4, 0xd0, 0x9c, 0xe8, 0x98, 0x73,
		0xa1, 0x63, 0xcf, 0x81, 0x16, 0x31, 0xc6, 0xc4, 0x8d, 0x2e, 0x51, 0xe3, 0x4a, 0xda, 0x88, 0x92,
		0x36, 0x96, 0xa4, 0x8c, 0x22, 0x35, 0x0e, 0x89, 0x3b, 0x77, 0x39, 0x67, 0x75, 0xf9, 0x8b, 0xd9,
		0xb6, 0xfd, 0xb6, 0xc5, 0x1b, 0x2f, 0xf1, 0xcf, 0x30, 0x1c, 0x3c, 0x30, 0xb5, 0x3c, 0xae, 0xaa,
		0x11, 0xf2, 0x0d, 0x08, 0xfb, 0x02, 0x64, 0x6c, 0x7f, 0x79, 0x5b, 0x5f, 0xd6, 0xb6, 0x57, 0xb6,
		0xe5, 0x95, 0x6d, 0x77, 0x25, 0x5b, 0x9d, 0x16, 0x7c, 0x08, 0xdb, 0xde, 0xe1, 0xfb, 0x6a, 0xb8,
		0x5d, 0x87, 0x33, 0x4f, 0x28, 0x55, 0x52, 0x22, 0x35, 0x52, 0xd2, 0x9e, 0x96, 0xc0, 0xb7, 0x2a,
		0xf6, 0xb2, 0x6a, 0x38, 0x91, 0xcc, 0x08, 0x53, 0x37, 0xba, 0x64, 0xfc, 0xb5, 0x2a, 0xf6, 0xad,
		0x86, 0x54, 0xc4, 0x34, 0x9d, 0xa6, 0x26, 0x13, 0xa4, 0x4e, 0x05, 0x07, 0x63, 0xa8, 0x79, 0xe6,
		0x58, 0x8f, 0x2d, 0x66, 0x3a, 0xbc, 0x63, 0xf6, 0xb5, 0x8e, 0xb8, 0xae, 0xfa, 0xb8, 0x41, 0x4c,
		0xd9, 0x24, 0xe3, 0x7d, 0x17, 0xe9, 0x18, 0x51, 0x87, 0xd6, 0x84, 0xd6, 0x4c, 0x58, 0x6b, 0x8a,
		0x77, 0x58, 0x10, 0xec, 0xa8, 0x40, 0xc9, 0xf2, 0x4d, 0x59, 0x56, 0x6f, 0x82, 0xc5, 0xc1, 0xe2,
		0x60, 0xf1, 0x54, 0xb3, 0x78, 0x5f, 0x1b, 0xfb, 0x01, 0xa1, 0x84, 0x43, 0xe2, 0x85, 0xb9, 0x7d,
		0xce, 0x1e, 0x60, 0x38, 0x30, 0x5c, 0xc2, 0x0c, 0x67, 0x77, 0x04, 0xa9, 0x6f, 0x8a, 0xe7, 0x0e,
		0x05, 0xd6, 0x0c, 0xef, 0x51, 0xbb, 0x29, 0x3a, 0x7e, 0xb2, 0xd7, 0x7d, 0x89, 0x67, 0x9b, 0x79,
		0x46, 0x89, 0x52, 0x44, 0xe5, 0xc1, 0xb4, 0xb9, 0x60, 0x18, 0x7c, 0xfd, 0xfd, 0xae, 0x68, 0x1e,
		0xd6, 0x07, 0xbf, 0x16, 0x83, 0x1f, 0x3f, 0x4b, 0xbd, 0xf7, 0xd2, 0x5d, 0xc1, 0xdc, 0x1f, 0x7e,
		0x5a, 0x2a, 0xdf, 0x15, 0xcc, 0x72, 0x3d, 0xbf, 0x75, 0x7f, 0xbf, 0x23, 0xba, 0x26, 0xff, 0x73,
		0xaf, 0x27, 0x9e, 0xe6, 0x50, 0x97, 0x39, 0x0e, 0x8a, 0xe1, 0xb2, 0xb9, 0x3f, 0xb7, 0x92, 0x3a,
		0x15, 0x99, 0x11, 0xb2, 0x75, 0x9d, 0xf1, 0x47, 0x35, 0x36, 0xa8, 0x64, 0x97, 0x0d, 0x82, 0xb7,
		0x67, 0x99, 0x4f, 0x55, 0xf3, 0x6b, 0xfd, 0x67, 0x71, 0x7b, 0xbf, 0x77, 0x94, 0xff, 0x79, 0xd0,
		0xfb, 0xf8, 0xe1, 0xfb, 0xbc, 0xaf, 0x15, 0xb7, 0x0f, 0x7a, 0x47, 0x11, 0x7f, 0xa9, 0xf4, 0x8e,
		0x62, 0xee, 0x51, 0xee, 0x6d, 0xcd, 0x7c, 0xb5, 0xff, 0x79, 0x29, 0x6a, 0xc1, 0x7e, 0xc4, 0x82,
		0xbd, 0xa8, 0x05, 0x7b, 0x11, 0x0b, 0x22, 0x6f, 0xa9, 0x14, 0xb1, 0xa0, 0xdc, 0x7b, 0x9f, 0xf9,
		0xfe, 0xd6, 0xfc, 0xaf, 0x56, 0x7a, 0xf9, 0xf7, 0xa8, 0xbf, 0x1d, 0xf4, 0xde, 0x8f, 0xf2, 0xf9,
		0x0c, 0x0a, 0x06, 0x90, 0x49, 0xf2, 0x64, 0xa2, 0x5f, 0x50, 0x26, 0xef, 0xd5, 0x4b, 0x6f, 0x90,
		0x37, 0x66, 0x26, 0x88, 0x48, 0x88, 0x77, 0x79, 0xaa, 0xc7, 0x82, 0x00, 0xef, 0x27, 0x81, 0x13,
		0x8a, 0x7b, 0x32, 0x22, 0x27, 0x92, 0x5b, 0x18, 0x61, 0x8e, 0x79, 0x06, 0xf3, 0x9f, 0x7e, 0xf6,
		0xd9, 0xe6, 0x3c, 0x57, 0xae, 0xe3, 0xb9, 0x0d, 0xe6, 0xfb, 0x2c, 0xda, 0xfc, 0x9b, 0x68, 0x08,
		0x3c, 0xfa, 0x6a, 0xc4, 0xf9, 0x2c, 0x0e, 0x5f, 0x2f, 0xb5, 0xe2, 0xe2, 0x58, 0x6d, 0x93, 0x56,
		0x5a, 0xff, 0x7e, 0x16, 0x9d, 0x5f, 0x4c, 0xb3, 0x4c, 0xd8, 0x0c, 0x13, 0x36, 0xbb, 0x3e, 0x9a,
		0x59, 0xc1, 0x8d, 0x13, 0xd1, 0xe4, 0xb2, 0x80, 0xf3, 0xe8, 0xad, 0xc5, 0xcf, 0x54, 0x18, 0x2d,
		0xc8, 0x46, 0xae, 0xc2, 0x12, 0x22, 0x90, 0xb5, 0xd1, 0x57, 0x9f, 0xac, 0xb0, 0x98, 0x48, 0x68,
		0x44, 0x7d, 0xec, 0x6c, 0x85, 0x8e, 0x2d, 0xe1, 0x0c, 0xee, 0x2f, 0x5a, 0x0f, 0x7f, 0x50, 0x4c,
		0x22, 0x5b, 0x3f, 0x87, 0x50, 0x3c, 0x22, 0x4c, 0x9b, 0x47, 0xa8, 0xc5, 0xac, 0x27, 0x8f, 0x3d,
		0xc9, 0xb8, 0x83, 0x04, 0x1a, 0xc9, 0xf6, 0x6d, 0xc3, 0x40, 0xc1, 0xef, 0xec, 0x0c, 0x70, 0xcd,
		0x6e, 0x9f, 0xe0, 0x13, 0x74, 0xe1, 0xc6, 0xcb, 0x40, 0x9b, 0x39, 0x1d, 0x91, 0x6c, 0xdc, 0x98,
		0x52, 0x5e, 0x58, 0xda, 0x83, 0x31, 0x33, 0xcc, 0x98, 0x71, 0xb5, 0x46, 0xb8, 0xc0, 0xf2, 0x9e,
		0x7d, 0xf1, 0x33, 0x0f, 0x53, 0xdd, 0xfa, 0xab, 0x05, 0x4f, 0x4b, 0xae, 0x0a, 0x4e, 0xba, 0xfa,
		0x4d, 0xa5, 0xea, 0x4d, 0x81, 0x9c, 0x55, 0xc9, 0x9a, 0x8c, 0xbc, 0xc9, 0xc8, 0x9c, 0x86, 0xdc,
		0xc5, 0x2d, 0x6f, 0x09, 0x87, 0xa6, 0x7c, 0xdd, 0xda, 0x64, 0x67, 0x1c, 0xdb, 0x79, 0x56, 0x72,
		0x69, 0x6a, 0x7d, 0x42, 0xa9, 0x22, 0x83, 0x70, 0xb5, 0x74, 0xb1, 0xc1, 0x78, 0x07, 0xc2, 0xa2,
		0x83, 0x70, 0x53, 0xa9, 0xe2, 0x03, 0x71, 0x8a, 0x12, 0x38, 0xeb, 0x5c, 0xa3, 0xd3, 0x35, 0xbb,
		0xbe, 0xf5, 0xcc, 0x86, 0xfe, 0x01, 0x79, 0x59, 0x39, 0xb3, 0x13, 0xe4, 0x26, 0xe4, 0xe6, 0xda,
		0xc9, 0x4d, 0x99, 0xdc, 0xe3, 0x8f, 0x24, 0x2e, 0x13, 0x0c, 0x52, 0xab, 0xed, 0x55, 0x28, 0x70,
		0xa6, 0xa8, 0xe5, 0xa5, 0x6a, 0x79, 0x44, 0x5e, 0x30, 0x4a, 0x57, 0x28, 0xaa, 0x50, 0xab, 0x4b,
		0x52, 0xa3, 0xab, 0xb1, 0xad, 0x6a, 0x9a, 0x4f, 0x3d, 0xa1, 0xf2, 0xd8, 0x7a, 0xaa, 0x34, 0x75,
		0xd7, 0x97, 0x98, 0xb1, 0x37, 0x47, 0x4f, 0x07, 0xfb, 0x40, 0x4b, 0x43, 0x4b, 0x43, 0x4b, 0x43,
		0x4b, 0x43, 0x4b, 0x43, 0x4b, 0x43, 0x4b, 0xd3, 0x68, 0x69, 0x6e, 0xb7, 0xec, 0xbf, 0xe5, 0xfa,
		0x5d, 0x4c, 0xab, 0xe9, 0x89, 0x8d, 0xa0, 0xa7, 0xa1, 0xa7, 0xd7, 0x4e, 0x4f, 0x77, 0x98, 0xd7,
		0x60, 0x0e, 0xb7, 0x9e, 0x99, 0x82, 0xa2, 0x2e, 0x43, 0x51, 0x43, 0x51, 0x6b, 0x53, 0xd4, 0x85,
		0x02, 0xf4, 0xf2, 0x1a, 0xe8, 0xe5, 0x36, 0x6b, 0xbb, 0xde, 0xdb, 0xc0, 0xf0, 0x95, 0x57, 0xca,
		0x53, 0xbb, 0x40, 0x23, 0x43, 0x23, 0xaf, 0x9d, 0x46, 0x96, 0x9e, 0x41, 0x06, 0xb3, 0x19, 0xda,
		0x18, 0x66, 0x33, 0xd4, 0xb3, 0x9a, 0x7a, 0xa6, 0xb0, 0x9c, 0xe7, 0xec, 0x05, 0x55, 0x0d, 0x55,
		0x0d, 0xe3, 0x19, 0xc6, 0x33, 0xd4, 0x35, 0x8c, 0x67, 0x68, 0x67, 0x61, 0xed, 0x3c, 0xac, 0x03,
		0x93, 0xd4, 0xc7, 0xc1, 0x6a, 0x68, 0x60, 0x68, 0x60, 0x24, 0xd1, 0x7e, 0xa4, 0x6f, 0xd1, 0x24,
		0x5a, 0x2d, 0xdc, 0x2d, 0x52, 0x60, 0x35, 0x0b, 0x42, 0x62, 0x17, 0x5a, 0x81, 0xb7, 0xc1, 0xdb,
		0x70, 0x84, 0x01, 0x59, 0x03, 0x59, 0xc3, 0x11, 0x06, 0xa8, 0x1d, 0x75, 0x68, 0x3e, 0xb7, 0x3c,
		0x6e, 0x72, 0x5b, 0x05, 0x70, 0x4f, 0xec, 0x01, 0xd5, 0x0c, 0xd5, 0xbc, 0x76, 0xaa, 0xb9, 0x4f,
		0xd9, 0xdc, 0x6e, 0xfc, 0xe5, 0x27, 0xae, 0x9f, 0xbf, 0x39, 0x03, 0xd1, 0x98, 0x73, 0x2c, 0xc7,
		0xf5, 0x59, 0xc3, 0x75, 0x9a, 0x52, 0x6d, 0xc1, 0xa0, 0xe7, 0xa1, 0xe7, 0xa1, 0xe7, 0xd7, 0x4e,
		0xcf, 0x67, 0x6a, 0x98, 0x54, 0xd8, 0x52, 0x69, 0xf4, 0x9b, 0xf0, 0xac, 0xb4, 0x98, 0x5d, 0xa2,
		0xae, 0x46, 0x17, 0x1a, 0xfd, 0x26, 0x32, 0x22, 0x4d, 0x77, 0xc7, 0xb1, 0xe1, 0x08, 0xb4, 0xe5,
		0x6e, 0x0c, 0xb1, 0x8a, 0x64, 0xf1, 0x0a, 0x64, 0x92, 0x8a, 0x63, 0xb1, 0x0a, 0xe3, 0x55, 0x75,
		0x63, 0x9b, 0xa1, 0x3c, 0xba, 0xae, 0x6c, 0x33, 0xb4, 0x96, 0xcd, 0xee, 0x6c, 0xcb, 0xda, 0x9d,
		0xc9, 0x9c, 0x88, 0x4a, 0xa7, 0x36, 0xdf, 0x7f, 0x31, 0x87, 0x03, 0xe7, 0x96, 0xb6, 0x6a, 0x9b,
		0xf8, 0x6e, 0x3a, 0x7a, 0xb5, 0xf9, 0x6f, 0xbe, 0xc9, 0x99, 0xd7, 0xce, 0x64, 0xbf, 0xb6, 0xf0,
		0xe6, 0x93, 0xea, 0xd9, 0xd6, 0x18, 0x9d, 0x7e, 0xcc, 0x96, 0x6d, 0xc3, 0xef, 0x13, 0x77, 0x6c,
		0x2b, 0x68, 0x9b, 0x2e, 0xb7, 0x8c, 0x14, 0x64, 0x8d, 0xc3, 0x54, 0x8c, 0x98, 0x5b, 0x42, 0x2a,
		0x34, 0x2a, 0x33, 0x76, 0xe7, 0xb6, 0xc1, 0x44, 0x0e, 0xd9, 0x49, 0x1e, 0x5a, 0x07, 0x79, 0xf4,
		0x4f, 0x79, 0xd3, 0xe6, 0x78, 0xc4, 0xa5, 0x7c, 0x55, 0xf7, 0x48, 0x2a, 0x67, 0x0b, 0xc4, 0xe4,
		0x0c, 0x3d, 0x50, 0x7e, 0xed, 0x27, 0x7a, 0x74, 0x3c, 0x97, 0xbb, 0x0d, 0xb7, 0x65, 0xbe, 0x32,
		0xcf, 0x17, 0xb1, 0x58, 0x26, 0x3b, 0x7f, 0x4e, 0xef, 0xa0, 0x93, 0xfb, 0x7f, 0x2f, 0x81, 0xf7,
		0xc1, 0xfb, 0x69, 0xe7, 0x7d, 0xe6, 0x74, 0xdb, 0xcc, 0x13, 0x4d, 0x60, 0x0d, 0xf9, 0x5f, 0x60,
		0x48, 0x7f, 0xae, 0xe6, 0x74, 0x83, 0xce, 0x4f, 0xbd, 0x04, 0x65, 0x86, 0x67, 0x71, 0x66, 0xb6,
		0xec, 0xb6, 0xcd, 0xc5, 0xa5, 0xc5, 0xc4, 0x5a, 0xb0, 0x28, 0x58, 0x74, 0x65, 0x2c, 0xda, 0xb5,
		0x1d, 0x5e, 0xac, 0x48, 0x70, 0x67, 0x05, 0x63, 0x68, 0x35, 0xb9, 0xa5, 0x33, 0x3c, 0x86, 0xb6,
		0x52, 0x2e, 0xef, 0x61, 0xee, 0xac, 0x9a, 0xd7, 0x9e, 0xa8, 0xbd, 0x31, 0xf3, 0xfb, 0x20, 0x54,
		0x56, 0x3d, 0x4d, 0x2f, 0x87, 0x86, 0x82, 0x86, 0x82, 0x86, 0x82, 0x86, 0x82, 0x86, 0x82, 0x86,
		0x22, 0xd3, 0x50, 0xdc, 0x6e, 0x33, 0xb7, 0x2b, 0xa1, 0x9b, 0x46, 0x0b, 0xa1, 0x95, 0xa0, 0x95,
		0xa0, 0x95, 0xa0, 0x95, 0xa0, 0x95, 0xa0, 0x95, 0x32, 0x3c, 0xd9, 0x6f, 0x9c, 0x6d, 0xb0, 0x1b,
		0x2b, 0x12, 0x6d, 0xc4, 0xcf, 0x9c, 0xb8, 0xf1, 0x5f, 0x6e, 0x82, 0x9d, 0x1f, 0x86, 0x5a, 0x4d,
		0x36, 0x95, 0x64, 0x61, 0x0e, 0x47, 0x9c, 0x39, 0x3a, 0x42, 0xf3, 0x73, 0xd2, 0x32, 0x1d, 0x0d,
		0xb1, 0x76, 0x02, 0xb6, 0x41, 0xac, 0x1d, 0xa0, 0x14, 0xa0, 0xd4, 0x40, 0xac, 0x7d, 0x7c, 0x4d,
		0xc4, 0xda, 0xc1, 0xfb, 0xe0, 0x7d, 0x62, 0xde, 0x47, 0xac, 0x3d, 0xf2, 0x68, 0x10, 0x6b, 0x07,
		0x8b, 0xc2, 0x67, 0x04, 0x9f, 0x11, 0x7c, 0x46, 0xf0, 0x19, 0xe9, 0xd0, 0x4d, 0x88, 0xb5, 0x43,
		0x43, 0x41, 0x43, 0x41, 0x43, 0x41, 0x43, 0x41, 0x43, 0x21, 0xd6, 0x0e, 0xad, 0x04, 0xad, 0x04,
		0xad, 0x04, 0xad, 0x04, 0xad, 0xb4, 0xd1, 0x5a, 0x29, 0xed, 0xb1, 0xf6, 0xb8, 0xad, 0x42, 0x84,
		0x43, 0xed, 0x31, 0x5a, 0x83, 0xa4, 0xb5, 0x69, 0xc3, 0xd2, 0xc6, 0x07, 0x32, 0x07, 0xa2, 0xd4,
		0xb5, 0x61, 0x61, 0x72, 0x41, 0xac, 0xa4, 0x82, 0xd8, 0xbd, 0x1a, 0x4a, 0x64, 0xbd, 0x1a, 0xb2,
		0xda, 0xa6, 0x21, 0xb1, 0x0e, 0x0d, 0x8f, 0xae, 0x1b, 0xb3, 0x43, 0xe0, 0x64, 0x68, 0x33, 0x56,
		0x43, 0xc0, 0x98, 0x10, 0x34, 0x89, 0x3e, 0x0d, 0xeb, 0x9a, 0x36, 0xa2, 0x3b, 0x63, 0x24, 0x36,
		0x50, 0x94, 0x6c, 0xa7, 0x27, 0xd0, 0x3e, 0x4f, 0xb6, 0x5d, 0x9e, 0x20, 0x9a, 0x14, 0xc0, 0xc4,
		0x32, 0xe8, 0x51, 0x16, 0x35, 0x2a, 0xc3, 0x1d, 0x79, 0x98, 0x23, 0xd2, 0x70, 0x54, 0x06, 0x15,
		0x12, 0xb6, 0xa7, 0x5b, 0xe5, 0x29, 0x11, 0x81, 0xb5, 0xba, 0x86, 0xbc, 0xc0, 0x46, 0xd7, 0xf3,
		0x98, 0xc3, 0xcd, 0xa6, 0xc5, 0x99, 0x98, 0xa8, 0x9f, 0x59, 0x09, 0x89, 0x0f, 0x89, 0xff, 0xe1,
		0xbc, 0xfb, 0xb4, 0x61, 0x5a, 0x4e, 0x33, 0x6e, 0x8f, 0xe0, 0xf1, 0xb8, 0x82, 0x18, 0xdf, 0xbd,
		0xb2, 0x38, 0x67, 0x9e, 0x13, 0x5b, 0x7c, 0xe7, 0xee, 0x0a, 0xe6, 0x61, 0xfd, 0xe7, 0x7e, 0xef,
		0xfe, 0xde, 0xdc, 0x2a, 0xdc, 0x15, 0xcd, 0xc3, 0xfa, 0x7b, 0xf1, 0xae, 0x60, 0x96, 0xea, 0xf9,
		0x89, 0x4f, 0xee, 0x8a, 0xa5, 0x7a, 0xf0, 0xc5, 0xf7, 0xbd, 0xbb, 0x42, 0xb1, 0x9e, 0xbf, 0xbb,
		0xe5, 0xf5, 0xad, 0xc2, 0xe0, 0x93, 0xe2, 0xe0, 0x47, 0xe9, 0xae, 0x60, 0xee, 0xd5, 0xf3, 0x47,
		0xa3, 0x8f, 0xef, 0x8a, 0x66, 0x79, 0xb0, 0x66, 0xde, 0x67, 0xef, 0x95, 0x42, 0x7e, 0xeb, 0xfe,
		0x7e, 0x27, 0xf8, 0xc7, 0xff, 0xc9, 0xff, 0xb2, 0x75, 0xf7, 0xdf, 0xbf, 0xeb, 0xef, 0x5b, 0x77,
		0xff, 0xc7, 0x14, 0xd8, 0x37, 0x9f, 0x5f, 0xfe, 0x72, 0xeb, 0x71, 0xce, 0xec, 0xf2, 0xe6, 0xf4,
		0x3f, 0xc2, 0x07, 0xf7, 0xe7, 0x56, 0xa6, 0x8f, 0x2e, 0xff, 0x8f, 0xdc, 0x4a, 0x64, 0x6b, 0xd3,
		0x6d, 0x5b, 0xb6, 0x63, 0xc6, 0x1a, 0x6a, 0x33, 0x66, 0x99, 0x89, 0x45, 0x90, 0xa8, 0x90, 0xa8,
		0xd2, 0xe4, 0x21, 0x2c, 0x4f, 0xcf, 0x98, 0xf3, 0x1c, 0xb8, 0x1e, 0xd2, 0x85, 0x86, 0x8b, 0x40,
		0xc3, 0x1f, 0x8f, 0xa4, 0x54, 0xde, 0xdb, 0x3c, 0xf0, 0xab, 0x03, 0x11, 0x6c, 0x6d, 0x6d, 0x6d,
		0xdd, 0x59, 0xe6, 0xdf, 0x55, 0xf3, 0xbf, 0x05, 0xf3, 0xf0, 0xa1, 0x3e, 0xf1, 0x8f, 0xfb, 0x7b,
		0xf3, 0xa1, 0x9e, 0xff, 0x59, 0xd8, 0xae, 0x14, 0x7b, 0xf9, 0x5f, 0xc6, 0x9f, 0xd7, 0xef, 0xef,
		0x77, 0xf2, 0xff, 0x94, 0x59, 0xf5, 0x4b, 0xfe, 0xbd, 0xbf, 0x76, 0xb5, 0x8a, 0x7c, 0x05, 0x0f,
		0xbc, 0x22, 0xed, 0xfb, 0xe2, 0xfa, 0x5c, 0x4c, 0xf5, 0x86, 0x2b, 0xa0, 0x77, 0xa1, 0x77, 0xa1,
		0x77, 0xa1, 0x77, 0xa1, 0x77, 0xa1, 0x77, 0xa1, 0x77, 0x05, 0xf5, 0x6e, 0xcb, 0x7d, 0xb6, 0x1d,
		0xf3, 0xd1, 0x72, 0x1c, 0xe6, 0xc5, 0xd7, 0xbd, 0x53, 0xab, 0xa0, 0x7f, 0xa1, 0x7f, 0x3f, 0x9c,
		0x77, 0xec, 0x09, 0xa8, 0x31, 0x27, 0x9e, 0xca, 0xd1, 0x76, 0xdb, 0xe5, 0x4d, 0x61, 0xd2, 0x9e,
		0x5c, 0x04, 0xca, 0x06, 0x65, 0xaf, 0x8e, 0xb2, 0x57, 0x9b, 0xb5, 0xb2, 0x24, 0x93, 0x27, 0x6e,
		0xc2, 0x4a, 0x74, 0xde, 0x4e, 0xbc, 0x64, 0x15, 0xce, 0x5a, 0x0e, 0xe3, 0xb1, 0xa7, 0x8c, 0x4c,
		0x7f, 0x1d, 0x83, 0x46, 0x30, 0x68, 0x24, 0xce, 0x2b, 0x4f, 0x52, 0x54, 0xa3, 0xf9, 0x09, 0x9a,
		0x9f, 0x18, 0xb9, 0xc0, 0x3a, 0x44, 0x07, 0x04, 0x5a, 0x16, 0x50, 0x66, 0x05, 0x65, 0x96, 0x50,
		0x67, 0x0d, 0x41, 0x87, 0x00, 0xba, 0x9f, 0x0c, 0xae, 0x89, 0x4e, 0x06, 0x60, 0x35, 0x54, 0xe4,
		0xc4, 0x58, 0x82, 0x8a, 0x9c, 0x64, 0x1c, 0xba, 0x12, 0xde, 0x6e, 0x25, 0xaf, 0xf7, 0xcc, 0xd1,
		0xa1, 0x22, 0x47, 0xde, 0x95, 0x4a, 0xab, 0x9b, 0xd0, 0xc9, 0x00, 0x1a, 0x0a, 0x1a, 0x0a, 0x1a,
		0x0a, 0x1a, 0x0a, 0x1a, 0x0a, 0x9d, 0x0c, 0xa0, 0x95, 0xa0, 0x95, 0xa0, 0x95, 0xa0, 0x95, 0xa0,
		0x95, 0x36, 0x5a, 0x2b, 0xa5, 0xb2, 0x93, 0xc1, 0x54, 0xf4, 0x90, 0x7c, 0x70, 0xc0, 0x6d, 0xb0,
		0x3b, 0x66, 0x07, 0x20, 0x7c, 0xa6, 0xa8, 0x80, 0x11, 0x3e, 0x43, 0xf8, 0x0c, 0xd8, 0x34, 0x13,
		0xd8, 0x14, 0xe1, 0x33, 0xb0, 0x1a, 0x58, 0x0d, 0x66, 0x20, 0xcc, 0x40, 0x98, 0x81, 0x30, 0x03,
		0xa5, 0x74, 0x13, 0xc2, 0x67, 0xd0, 0x50, 0xd0, 0x50, 0xd0, 0x50, 0xd0, 0x50, 0xd0, 0x50, 0x08,
		0x9f, 0x41, 0x2b, 0x41, 0x2b, 0x41, 0x2b, 0x41, 0x2b, 0x41, 0x2b, 0x6d, 0xb4, 0x56, 0xca, 0x40,
		0xf8, 0x8c, 0xb8, 0x17, 0xf8, 0x54, 0xf4, 0x2c, 0xc3, 0xed, 0xc0, 0xe3, 0x54, 0x28, 0x4a, 0x1e,
		0x4b, 0xec, 0x3a, 0xcb, 0x4f, 0x0b, 0x1e, 0x7c, 0xd9, 0x03, 0xc7, 0x7d, 0xd0, 0xdc, 0xdc, 0xce,
		0xe3, 0x31, 0x1e, 0x69, 0xfa, 0x29, 0xc6, 0xf7, 0x3a, 0xf8, 0x6d, 0x78, 0xb7, 0x51, 0x77, 0x99,
		0xb3, 0xfd, 0xaf, 0xd6, 0x5f, 0xec, 0xda, 0x75, 0x67, 0xd5, 0xfa, 0xc7, 0x3b, 0xcf, 0x4d, 0xfe,
		0x69, 0xea, 0xce, 0x4e, 0xd8, 0xab, 0xdd, 0x18, 0xd2, 0x57, 0xef, 0x53, 0xef, 0xff, 0x07, 0x00,
		0x00, 0xff, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0x6b, 0x82, 0xbc, 0xdb, 0x63, 0x60, 0x0f, 0x00,
	}
)


// ΛEnumTypes is a map, keyed by a YANG schema path, of the enumerated types that
// correspond with the leaf. The type is represented as a reflect.Type. The naming
// of the map ensures that there are no clashes with valid YANG identifiers.
func initΛEnumTypes(){
  ΛEnumTypes = map[string][]reflect.Type{
	"/components/component/state/last-reboot-reason": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_COMPONENT_REBOOT_REASON)(0)),
	},
	"/components/component/state/last-switchover-reason/trigger": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_ComponentRedundantRoleSwitchoverReasonTrigger)(0)),
	},
	"/components/component/state/oper-status": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_COMPONENT_OPER_STATUS)(0)),
	},
	"/components/component/state/redundant-role": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatform_ComponentRedundantRole)(0)),
	},
	"/components/component/state/temperature/alarm-severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY)(0)),
	},
	"/components/component/state/type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigPlatformTypes_OPENCONFIG_HARDWARE_COMPONENT)(0)),
		reflect.TypeOf((E_OpenconfigPlatformTypes_OPENCONFIG_SOFTWARE_COMPONENT)(0)),
	},
	"/messages/config/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_SyslogSeverity)(0)),
	},
	"/messages/debug-entries/debug-service/config/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/messages/debug-entries/debug-service/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/messages/debug-entries/debug-service/state/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/messages/state/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_SyslogSeverity)(0)),
	},
	"/system/aaa/accounting/config/accounting-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/accounting/events/event/config/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE)(0)),
	},
	"/system/aaa/accounting/events/event/config/record": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record)(0)),
	},
	"/system/aaa/accounting/events/event/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE)(0)),
	},
	"/system/aaa/accounting/events/event/state/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_ACCOUNTING_EVENT_TYPE)(0)),
	},
	"/system/aaa/accounting/events/event/state/record": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Aaa_Accounting_Events_Event_Config_Record)(0)),
	},
	"/system/aaa/accounting/state/accounting-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/authentication/config/authentication-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/authentication/state/authentication-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/authentication/users/user/config/role": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES)(0)),
	},
	"/system/aaa/authentication/users/user/state/role": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_SYSTEM_DEFINED_ROLES)(0)),
	},
	"/system/aaa/authorization/config/authorization-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/authorization/events/event/config/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE)(0)),
	},
	"/system/aaa/authorization/events/event/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE)(0)),
	},
	"/system/aaa/authorization/events/event/state/event-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_AUTHORIZATION_EVENT_TYPE)(0)),
	},
	"/system/aaa/authorization/state/authorization-method": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_METHOD_TYPE)(0)),
	},
	"/system/aaa/server-groups/server-group/config/type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_SERVER_TYPE)(0)),
	},
	"/system/aaa/server-groups/server-group/state/type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAaaTypes_AAA_SERVER_TYPE)(0)),
	},
	"/system/alarms/alarm/state/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_SEVERITY)(0)),
	},
	"/system/alarms/alarm/state/type-id": []reflect.Type{
		reflect.TypeOf((E_OpenconfigAlarmTypes_OPENCONFIG_ALARM_TYPE_ID)(0)),
	},
	"/system/cpus/cpu/index": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Cpus_Cpu_State_Index)(0)),
	},
	"/system/cpus/cpu/state/index": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Cpus_Cpu_State_Index)(0)),
	},
	"/system/logging/console/selectors/selector/config/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/console/selectors/selector/config/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/logging/console/selectors/selector/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/console/selectors/selector/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/logging/console/selectors/selector/state/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/console/selectors/selector/state/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/config/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/config/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/state/facility": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SYSLOG_FACILITY)(0)),
	},
	"/system/logging/remote-servers/remote-server/selectors/selector/state/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystemLogging_SyslogSeverity)(0)),
	},
	"/system/messages/config/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_SyslogSeverity)(0)),
	},
	"/system/messages/debug-entries/debug-service/config/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/system/messages/debug-entries/debug-service/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/system/messages/debug-entries/debug-service/state/service": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_DEBUG_SERVICE)(0)),
	},
	"/system/messages/state/severity": []reflect.Type{
		reflect.TypeOf((E_OpenconfigMessages_SyslogSeverity)(0)),
	},
	"/system/ntp/ntp-keys/ntp-key/config/key-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_NTP_AUTH_TYPE)(0)),
	},
	"/system/ntp/ntp-keys/ntp-key/state/key-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_NTP_AUTH_TYPE)(0)),
	},
	"/system/ntp/servers/server/config/association-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType)(0)),
	},
	"/system/ntp/servers/server/state/association-type": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_Ntp_Servers_Server_Config_AssociationType)(0)),
	},
	"/system/ssh-server/config/protocol-version": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion)(0)),
	},
	"/system/ssh-server/state/protocol-version": []reflect.Type{
		reflect.TypeOf((E_OpenconfigSystem_System_SshServer_Config_ProtocolVersion)(0)),
	},
  }
}

