package main

import (
	gpb "github.com/openconfig/gnmi/proto/gnmi"
	"github.com/openconfig/goyang/pkg/yang"
	"github.com/openconfig/ygot/ygot"
	"github.com/openconfig/ygot/ytypes"

	spb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/southbound"
	"github.com/google/uuid"
)

type FaultyPlugin struct {
	schema *ytypes.Schema
	id     uuid.UUID
}

// SetNode injects schema specific model representation to the transport.
// Needed for type assertion.
func (fp *FaultyPlugin) SetNode(schema *yang.Entry, root interface{}, path *gpb.Path, val interface{}, opts ...ytypes.SetNodeOpt) error {
	return nil
}

// Unmarshal injects schema specific model representation to the transport.
// Needed for type assertion.
func (fp *FaultyPlugin) Unmarshal(bytes []byte, path *gpb.Path, goStruct ygot.ValidatedGoStruct, opt ...ytypes.UnmarshalOpt) error {
	return nil
}

func (fp *FaultyPlugin) Schema() *ytypes.Schema {
	return nil
}

// SetID sets the ID of the cSBI to the provided UUID
func (fp *FaultyPlugin) SetID(id uuid.UUID) {
	fp.id = id
}

// ID returns the Southbound's UUID
func (fp *FaultyPlugin) ID() uuid.UUID {
	return fp.id
}

// SchemTreeGzip returns the gzip'd SBI's SchemaTree
func (fp *FaultyPlugin) SchemaTreeGzip() []byte {
	return []byte{}
}

// Type returns the Southbound's type
func (fp *FaultyPlugin) Type() spb.Type {
	return spb.Type_TYPE_PLUGIN
}

func (fp *FaultyPlugin) Name() string {
	return "csbi"
}
