package store

import "code.fbi.h-da.de/danet/gosdn/controller/config"

// StorageMode decides which backend all stores should use.
type StorageMode int64

const (
	// Memory is the default storage mode.
	Memory StorageMode = iota
	// Filesystem is a persistent storage mode.
	Filesystem
	// Database is a persistent storage mode provided by a database.
	Database
)

// GetStoreMode returns which store should be used.
func GetStoreMode() StorageMode {
	if config.UseDatabase() {
		return Database
	}

	return Filesystem
}

func (s StorageMode) String() string {
	switch s {
	case Filesystem:
		return "Filesystem"
	case Database:
		return "Database"
	}

	return "unknown"
}
