package store

import (
	"os"
	"testing"

	"github.com/google/uuid"
	log "github.com/sirupsen/logrus"
)

// UUIDs for test cases.
var mdid uuid.UUID
var defaultPndID uuid.UUID
var cuid uuid.UUID
var did uuid.UUID
var iid uuid.UUID
var altIid uuid.UUID

func TestMain(m *testing.M) {
	log.SetReportCaller(true)

	if os.Getenv("GOSDN_LOG") == "nolog" {
		log.SetLevel(log.PanicLevel)
	}
	readTestUUIDs()
	os.Exit(m.Run())
}

func readTestUUIDs() {
	var err error
	mdid, err = uuid.Parse("688a264e-5f85-40f8-bd13-afc42fcd5c7a")
	if err != nil {
		log.Fatal(err)
	}
	defaultPndID, err = uuid.Parse("b4016412-eec5-45a1-aa29-f59915357bad")
	if err != nil {
		log.Fatal(err)
	}
	cuid, err = uuid.Parse("3e8219b0-e926-400d-8660-217f2a25a7c6")
	if err != nil {
		log.Fatal(err)
	}
	did, err = uuid.Parse("4d8246f8-e884-41d6-87f5-c2c784df9e44")
	if err != nil {
		log.Fatal(err)
	}
	iid, err = uuid.Parse("8495a8ac-a1e8-418e-b787-10f5878b2690")
	if err != nil {
		log.Fatal(err)
	}
	altIid, err = uuid.Parse("edc5de93-2d15-4586-b2a7-fb1bc770986b")
	if err != nil {
		log.Fatal(err)
	}
}
