package rbac

import (
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/rbac"
	"code.fbi.h-da.de/danet/gosdn/controller/store"
)

// NewUserStore returns a userStore.
func NewUserStore() rbac.UserStore {
	storeMode := store.GetStoreMode()

	switch storeMode {
	case store.Database:
		return &DatabaseUserStore{"user.json"}
	default:
		store := NewFileSystemUserStore()
		return store
	}
}
