package rbac

import (
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/rbac"
	"code.fbi.h-da.de/danet/gosdn/controller/store"
)

// NewRoleStore returns a roleStore.
func NewRoleStore() rbac.RoleStore {
	storeMode := store.GetStoreMode()

	switch storeMode {
	case store.Database:
		return &DatabaseRoleStore{"role.json"}
	default:
		store := NewFileSystemRoleStore()
		return store
	}
}
