package rbac

import (
	"log"
	"os"
	"path/filepath"

	"code.fbi.h-da.de/danet/gosdn/controller/store"
)

func ensureStoreFileForTestsIsRemoved(storeName string) {
	if err := store.EnsureFilesystemStorePathExists(storeName); err != nil {
		log.Println(err)
	}

	wildcartFilename := "*" + storeName
	path := store.GetCompletePathToFileStore(wildcartFilename)

	files, err := filepath.Glob(path)

	if err != nil {
		log.Println(err)
	}
	for _, f := range files {
		if err := os.Remove(f); err != nil {
			log.Println(err)
		}
	}
}
