package proto

import (
	"fmt"
	"os"
	"path/filepath"

	"google.golang.org/protobuf/proto"
)

/*
Copycat source: https://dev.to/techschoolguru/go-generate-serialize-protobuf-message-4m7a
*/

// Write writes protocol buffer message to binary file.
func Write(message proto.Message, filename string) error {
	data, err := proto.Marshal(message)
	if err != nil {
		return fmt.Errorf("cannot marshal proto message to binary: %w", err)
	}

	err = os.WriteFile(filename, data, 0600)
	if err != nil {
		return fmt.Errorf("cannot write binary data to file: %w", err)
	}

	return nil
}

// Read reads a binary file (containing a marshaled protocol buffer message)
// and unmarshals it back into a protocol buffer message.
func Read(filename string, message proto.Message) error {
	data, err := os.ReadFile(filepath.Clean(filename))
	if err != nil {
		return fmt.Errorf("cannot read binary data from file: %w", err)
	}
	err = proto.Unmarshal(data, message)
	if err != nil {
		return fmt.Errorf("cannot unmarshal binary to proto message: %w", err)
	}

	return nil
}
