package path

import (
	"strings"

	gpb "github.com/openconfig/gnmi/proto/gnmi"
)

// ToStrings translates a gNMI path to a slice of strings.
func ToStrings(path *gpb.Path) []string {
	elems := make([]string, len(path.Elem))
	for i, e := range path.Elem {
		//nolint
		elems[i] = strings.Title(e.Name)
	}
	return elems
}
