package gnmi

import "github.com/openconfig/gnmi/proto/gnmi"

// IsGNMINotificationEmpty checks if the given gnmi.Notification does not
// contain any updates or deletes.
func IsGNMINotificationEmpty(n *gnmi.Notification) bool {
	if n.Update == nil || len(n.Update) == 0 {
		if n.Delete == nil || len(n.Delete) == 0 {
			return true
		}
	}
	return false
}
