package types

// CtxKeyType is a custom type to be used as key in a context.WithValue() or
// context.Value() call. For more information see:
// https://www.calhoun.io/pitfalls-of-context-values-and-how-to-avoid-or-mitigate-them/
// TODO: Unexport to comply with best practice.
type CtxKeyType string

const (
	// CtxKeyOpts context key for gnmi.SubscribeOptions.
	CtxKeyOpts CtxKeyType = "opts"
	// CtxKeyConfig is a context key for gnmi.Config.
	CtxKeyConfig = "config"
	// CtxKeyOperation is a context key for a gNMI operation (update, replace, delete).
	CtxKeyOperation = "op"
)
