package nucleus

import (
	tpb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/transport"
	"code.fbi.h-da.de/danet/gosdn/controller/customerrs"
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/transport"
	"code.fbi.h-da.de/danet/gosdn/controller/plugin/shared"
)

// NewTransport receives TransportOptions and returns an appropriate Transport
// implementation.
func NewTransport(opts *tpb.TransportOption, model shared.DeviceModel) (transport.Transport, error) {
	if opts == nil {
		return nil, &customerrs.InvalidParametersError{
			Func:  NewTransport,
			Param: "'opt' cannot be 'nil'",
		}
	}
	if model == nil {
		return nil, customerrs.InvalidParametersError{
			Param: "'model' cannot be 'nil'",
		}
	}
	if !validTransportOptions(opts) {
		return nil, &customerrs.InvalidTransportOptionsError{Opt: opts}
	}
	switch o := opts.TransportOption.(type) {
	case *tpb.TransportOption_GnmiTransportOption:
		return newGnmiTransport(opts, model)
	default:
		return nil, &customerrs.InvalidTransportOptionsError{Opt: o}
	}
}

func validTransportOptions(opt *tpb.TransportOption) bool {
	return opt.GetGnmiTransportOption() != nil ||
		opt.GetRestconfTransportOption() != nil
}
