package nucleus

import (
	"context"
	"reflect"
	"testing"

	"github.com/openconfig/ygot/ytypes"
)

func TestRestconf_Get(t *testing.T) {
	type args struct {
		ctx    context.Context
		params []string
	}
	tests := []struct {
		name    string
		args    args
		want    interface{}
		wantErr bool
	}{
		{name: "not implemented", args: args{}, want: nil, wantErr: true},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			r := Restconf{}
			got, err := r.Get(tt.args.ctx, tt.args.params...)
			if (err != nil) != tt.wantErr {
				t.Errorf("Get() error = %v, wantErr %v", err, tt.wantErr)
				return
			}
			if !reflect.DeepEqual(got, tt.want) {
				t.Errorf("Get() got = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestRestconf_ProcessResponse(t *testing.T) {
	type args struct {
		resp   interface{}
		root   interface{}
		models *ytypes.Schema
	}
	tests := []struct {
		name    string
		args    args
		wantErr bool
	}{
		{name: "not implemented", args: args{}, wantErr: true},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			r := Restconf{}
			if err := r.ProcessResponse(tt.args.resp, tt.args.root, tt.args.models); (err != nil) != tt.wantErr {
				t.Errorf("ProcessResponse() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func TestRestconf_Set(t *testing.T) {
	type args struct {
		ctx    context.Context
		params []interface{}
	}
	tests := []struct {
		name    string
		args    args
		wantErr bool
	}{
		{name: "not implemented", args: args{}, wantErr: true},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			r := Restconf{}
			err := r.Set(tt.args.ctx, tt.args.params...)
			if (err != nil) != tt.wantErr {
				t.Errorf("Set() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func TestRestconf_Subscribe(t *testing.T) {
	type args struct {
		ctx    context.Context
		params []string
	}
	tests := []struct {
		name    string
		args    args
		wantErr bool
	}{
		{name: "not implemented", args: args{}, wantErr: true},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			r := Restconf{}
			if err := r.Subscribe(tt.args.ctx, tt.args.params...); (err != nil) != tt.wantErr {
				t.Errorf("Subscribe() error = %v, wantErr %v", err, tt.wantErr)
			}
		})
	}
}

func TestRestconf_Type(t *testing.T) {
	tests := []struct {
		name string
		want string
	}{
		{name: "not implemented", want: "restconf"},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			r := Restconf{}
			if got := r.Type(); got != tt.want {
				t.Errorf("Type() = %v, want %v", got, tt.want)
			}
		})
	}
}
