package nucleus

import (
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/networkdomain"
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/networkelement"
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/plugin"
	"code.fbi.h-da.de/danet/gosdn/controller/store"
	"github.com/google/uuid"
	log "github.com/sirupsen/logrus"
)

// LoadedPnd represents a Principal Network Domain that was loaeded by using
// the Load() method of the PndStore.
type LoadedPnd struct {
	ID          string `json:"id" bson:"_id,omitempty"`
	Name        string `json:"name,omitempty"`
	Description string `json:"description,omitempty"`
}

// PndStore is used to store PrincipalNetworkDomains.
type PndStore struct {
}

// NewPndStore returns a PndStore.
func NewPndStore(pluginService plugin.Service) networkdomain.PndStore {
	storeMode := store.GetStoreMode()
	log.Debugf("StoreMode: %s", storeMode)

	switch storeMode {
	case store.Database:
		return &DatabasePndStore{
			pendingChannels: make(map[uuid.UUID]chan networkelement.Details),
			pndStoreName:    "pnd-store.json",
			pluginService:   pluginService,
		}

	default:
		store := NewFilesystemPndStore(pluginService)
		return &store
	}
}
