package nucleus

//import (
//	"testing"
//
//	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/plugin"
//	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/southbound"
//	"code.fbi.h-da.de/danet/gosdn/controller/mocks"
//	"code.fbi.h-da.de/danet/gosdn/controller/nucleus/util"
//	"github.com/google/go-cmp/cmp"
//	"github.com/google/uuid"
//)
//
//func Test_plugin_BuildPlugin(t *testing.T) {
//	type args struct {
//		path      string
//		fileNames []string
//	}
//	tests := []struct {
//		name    string
//		args    args
//		wantErr bool
//	}{
//		{
//			name: "build success",
//			args: args{
//				path:      "../test/plugin",
//				fileNames: []string{util.GoStructName, util.GoStructAdditionsName},
//			},
//			wantErr: false,
//		},
//		{
//			name: "fail: file does not exist",
//			args: args{
//				path:      "../test/plugin",
//				fileNames: []string{"doesNotExist.go"},
//			},
//			wantErr: true,
//		},
//	}
//	for _, tt := range tests {
//		t.Run(tt.name, func(t *testing.T) {
//			err := BuildPlugin(tt.args.path, tt.args.fileNames, "-race")
//			if (err != nil) != tt.wantErr {
//				t.Errorf("BuildPlugin() error = %v, wantErr %v", err, tt.wantErr)
//				return
//			}
//		})
//	}
//}
//
//func Test_plugin_LoadPlugin(t *testing.T) {
//	type args struct {
//		path string
//	}
//	tests := []struct {
//		name    string
//		args    args
//		wantErr bool
//	}{
//		{
//			name: "load success",
//			args: args{
//				path: "../test/plugin",
//			},
//			wantErr: false,
//		},
//		{
//			name: "symbol not provided",
//			args: args{
//				path: "../test/plugin/faulty",
//			},
//			wantErr: true,
//		},
//		{
//			name: "fail: wrong path",
//			args: args{
//				path: "../test/plugin/wrong/path",
//			},
//			wantErr: true,
//		},
//	}
//	for _, tt := range tests {
//		t.Run(tt.name, func(t *testing.T) {
//			if tt.name != "fail: wrong path" {
//				if err := BuildPlugin(tt.args.path, []string{util.GoStructName, util.GoStructAdditionsName}, "-race"); err != nil {
//					t.Errorf("LoadPlugin() error = %v", err)
//					return
//				}
//			}
//
//			ps, err := LoadPlugin(tt.args.path)
//			if (err != nil) != tt.wantErr {
//				t.Errorf("LoadPlugin() error = %v, wantErr %v", err, tt.wantErr)
//				return
//			}
//			// the plugin provided for test cases should be assertable to type
//			// southbound.SouthboundInterface
//			if tt.name == "load success" {
//				if _, ok := ps.(southbound.SouthboundInterface); !ok {
//					t.Error("LoadPlugin() error = plugin.Symbol was not assertable to southbound.SouthboundInterface")
//				}
//			}
//		})
//	}
//}
//
//func Test_plugin_UpdatePlugin(t *testing.T) {
//	newPlugin := func(id uuid.UUID, path string, state plugin.State, manifest *plugin.Manifest) *mocks.Plugin {
//		p := &mocks.Plugin{}
//		p.On("Path").Return(path)
//		p.On("ID").Return(id)
//		p.On("State").Return(state)
//		p.On("Manifest").Return(manifest)
//		return p
//	}
//
//	type args struct {
//		id       uuid.UUID
//		path     string
//		state    plugin.State
//		manifest *plugin.Manifest
//	}
//	tests := []struct {
//		name    string
//		args    args
//		want    bool
//		wantErr bool
//	}{
//		{
//			name: "Update success",
//			args: args{
//				id:    uuid.New(),
//				path:  "../test/plugin",
//				state: plugin.State(2),
//				manifest: &plugin.Manifest{
//					Name:    "test",
//					Author:  "goSDN-Team",
//					Version: "v1.0.2",
//				},
//			},
//			want:    true,
//			wantErr: false,
//		},
//		{
//			name: "Plugin to Update is of older version",
//			args: args{
//				id:    uuid.New(),
//				path:  "../test/plugin",
//				state: plugin.State(2),
//				manifest: &plugin.Manifest{
//					Name:    "test",
//					Author:  "goSDN-Team",
//					Version: "v2.2.2",
//				},
//			},
//			want:    false,
//			wantErr: true,
//		},
//		{
//			name: "missing folder",
//			args: args{
//				id:    uuid.New(),
//				path:  "../test/plugin/missing-folder",
//				state: plugin.State(2),
//				manifest: &plugin.Manifest{
//					Name:    "test",
//					Author:  "goSDN-Team",
//					Version: "v1.0.0",
//				},
//			},
//			want:    false,
//			wantErr: true,
//		},
//		{
//			name: "Faulty manifest file",
//			args: args{
//				id:    uuid.New(),
//				path:  "../test/plugin/faulty",
//				state: plugin.State(2),
//				manifest: &plugin.Manifest{
//					Name:    "test",
//					Author:  "goSDN-Team",
//					Version: "v1.0.0",
//				},
//			},
//			want:    false,
//			wantErr: true,
//		},
//		{
//			name: "wrong path",
//			args: args{
//				id:    uuid.New(),
//				path:  "../test/plugin/wrong/path",
//				state: plugin.State(2),
//				manifest: &plugin.Manifest{
//					Name:    "test",
//					Author:  "goSDN-Team",
//					Version: "v1.0.2",
//				},
//			},
//			want:    false,
//			wantErr: true,
//		},
//	}
//	for _, tt := range tests {
//		t.Run(tt.name, func(t *testing.T) {
//			p := newPlugin(tt.args.id, tt.args.path, tt.args.state, tt.args.manifest)
//
//			got, err := UpdatePlugin(p)
//			if (err != nil) != tt.wantErr {
//				t.Errorf("UpdatePlugin() error = %v, wantErr %v", err, tt.wantErr)
//				return
//			}
//
//			if !cmp.Equal(got, tt.want) {
//				t.Errorf("BuildPlugin() got = %v, want %v", got, tt.want)
//			}
//		})
//	}
//}
