package nucleus

import (
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/plugin"
	"code.fbi.h-da.de/danet/gosdn/controller/store"
)

// NewPluginStore returns a pluginStore.
func NewPluginStore() plugin.Store {
	storeMode := store.GetStoreMode()

	switch storeMode {
	case store.Database:
		return &DatabasePluginStore{
			pluginStoreName: store.PluginFilenameSuffix,
		}

	default:
		store := NewFilesystemPluginStore()
		return store
	}
}
