package nucleus

import (
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/plugin"
	"code.fbi.h-da.de/danet/gosdn/controller/store"
	"github.com/google/uuid"
)

// PluginServiceMock provides a in-memory implementation for multiple stores.
type PluginServiceMock struct {
	Store map[uuid.UUID]plugin.Plugin
}

// NewPluginSerivceMock returns a specific in-memory store for plugin service.
func NewPluginServiceMock() plugin.Service {
	return &PluginServiceMock{
		Store: make(map[uuid.UUID]plugin.Plugin),
	}
}

// Add adds a item plugin.
func (t *PluginServiceMock) Add(item plugin.Plugin) error {
	_, ok := t.Store[item.ID()]
	if ok {
		return nil
	}

	t.Store[item.ID()] = item

	return nil
}

// Delete deletes a item plugin.
func (t *PluginServiceMock) Delete(item plugin.Plugin) error {
	delete(t.Store, item.ID())

	return nil
}

// Get gets a plugin.
func (t *PluginServiceMock) Get(query store.Query) (plugin.Plugin, error) {
	// search for direct hit on UUID.
	item, ok := t.Store[query.ID]
	if !ok {
		return item, nil
	}

	return item, nil
}

// GetAll gets all plugins.
func (t *PluginServiceMock) GetAll() ([]plugin.Plugin, error) {
	var allItems []plugin.Plugin

	for _, item := range t.Store {
		allItems = append(allItems, item)
	}

	return allItems, nil
}

// RequestPlugin is a mock for requesting a plugin from the registry.
// TODO: add plugin mock here.
func (t *PluginServiceMock) RequestPlugin(uuid.UUID) (plugin.Plugin, error) {
	return nil, nil
}
