package nucleus

import (
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/networkelement"
	"code.fbi.h-da.de/danet/gosdn/controller/store"

	log "github.com/sirupsen/logrus"
)

// NewNetworkElementStore returns a NetworkElementStore.
func NewNetworkElementStore() networkelement.Store {
	storeMode := store.GetStoreMode()
	log.Debugf("StoreMode: %s", storeMode)

	switch storeMode {
	case store.Database:
		return &DatabaseNetworkElementStore{
			storeName: "networkElement-store.json",
		}

	default:
		store := NewFilesystemNetworkElementStore()
		return store
	}
}
