package server

import (
	"github.com/prometheus/client_golang/prometheus"
	"github.com/prometheus/client_golang/prometheus/promauto"
)

var (
	grpcRequestsTotal = promauto.NewCounterVec(
		prometheus.CounterOpts{
			Name: "grpc_requests_total",
			Help: "Total number of gRPC requests sent to the API",
		},
		[]string{"service", "rpc"},
	)

	grpcAPIErrorsTotal = promauto.NewCounterVec(
		prometheus.CounterOpts{
			Name: "grpc_api_errors_total",
			Help: "Total number of errors returned by the API",
		},
		[]string{"service", "rpc", "error"},
	)

	grpcRequestDurationSecondsTotal = promauto.NewCounterVec(
		prometheus.CounterOpts{
			Name: "grpc_request_duration_seconds_total",
			Help: "Cumulative time required to handle gRPC requests",
		},
		[]string{"service", "rpc"},
	)

	grpcRequestDurationSeconds = promauto.NewHistogramVec(
		prometheus.HistogramOpts{
			Name: "grpc_request_duration_seconds",
			Help: "Histogram of gRPC request handling times",
		},
		[]string{"service", "rpc"},
	)
)
