package client

import (
	spb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/southbound"
	"google.golang.org/grpc"
)

// SbiClient returns a client for the gRPC SBI service. It takes
// the address of the gRPC endpoint and optional grpc.DialOption
// as argument.
func SbiClient(addr string, opts ...grpc.DialOption) (spb.SbiServiceClient, error) {
	conn, err := grpc.Dial(addr, opts...)
	if err != nil {
		return nil, err
	}
	return spb.NewSbiServiceClient(conn), nil
}
