package client

import (
	apb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/rbac"
	"google.golang.org/grpc"
)

// AuthClient returns a client for the gRPC Auth service. It takes
// the address of the gRPC endpoint and optional grpc.DialOption
// as argument.
func AuthClient(addr string, opts ...grpc.DialOption) (apb.AuthServiceClient, error) {
	conn, err := grpc.Dial(addr, opts...)
	if err != nil {
		return nil, err
	}
	return apb.NewAuthServiceClient(conn), nil
}

// UserClient returns a client for the gRPC User service. It takes
// the address of the gRPC endpoint and optional grpc.DialOption
// as argument.
func UserClient(addr string, opts ...grpc.DialOption) (apb.UserServiceClient, error) {
	conn, err := grpc.Dial(addr, opts...)
	if err != nil {
		return nil, err
	}
	return apb.NewUserServiceClient(conn), nil
}

// RoleClient returns a client for the gRPC Role service. It takes
// the address of the gRPC endpoint and optional grpc.DialOption
// as argument.
func RoleClient(addr string, opts ...grpc.DialOption) (apb.RoleServiceClient, error) {
	conn, err := grpc.Dial(addr, opts...)
	if err != nil {
		return nil, err
	}
	return apb.NewRoleServiceClient(conn), nil
}
