package client

import (
	ppb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/pnd"
	"google.golang.org/grpc"
)

// PndClient returns a client for the gRPC PND service. It takes
// the address of the gRPC endpoint and optional grpc.DialOption
// as argument.
func PndClient(addr string, opts ...grpc.DialOption) (ppb.PndServiceClient, error) {
	conn, err := grpc.Dial(addr, opts...)
	if err != nil {
		return nil, err
	}
	return ppb.NewPndServiceClient(conn), nil
}
