package client

import (
	mnepb "code.fbi.h-da.de/danet/gosdn/api/go/gosdn/networkelement"
	"google.golang.org/grpc"
)

// NetworkElementClient returns a client for the gRPC NetworkElement service. It takes
// the address of the gRPC endpoint and optional grpc.DialOption
// as argument.
func NetworkElementClient(addr string, opts ...grpc.DialOption) (mnepb.NetworkElementServiceClient, error) {
	conn, err := grpc.Dial(addr, opts...)
	if err != nil {
		return nil, err
	}
	return mnepb.NewNetworkElementServiceClient(conn), nil
}
