package mocks

import (
	"encoding/json"

	"github.com/google/uuid"
)

// MarshalJSON implements the MarshalJSON interface to store a PND as JSON.
func (n NetworkDomain) MarshalJSON() ([]byte, error) {
	return json.Marshal(&struct {
		ID          uuid.UUID
		Name        string
		Description string
	}{
		ID:          n.ID(),
		Name:        n.GetName(),
		Description: n.GetDescription(),
	})
}
