package metrics

import (
	"time"

	"github.com/prometheus/client_golang/prometheus"
)

// nolint
// TODO: add description
func StartHook(labels prometheus.Labels, counter *prometheus.CounterVec) time.Time {
	counter.With(labels).Inc()
	return time.Now()
}

// nolint
// TODO: add description
func FinishHook(labels prometheus.Labels, start time.Time, counter *prometheus.CounterVec, hist *prometheus.HistogramVec) {
	duration := time.Since(start)
	counter.With(labels).Add(duration.Seconds())
	hist.With(labels).Observe(duration.Seconds())
}

// nolint
// TODO: add description
func HandleError(labels prometheus.Labels, err error, counter *prometheus.CounterVec) error {
	errLabels := make(prometheus.Labels)
	for k, v := range labels {
		errLabels[k] = v
	}
	errLabels["error"] = err.Error()
	counter.With(errLabels).Inc()
	return err
}
