package transport

import (
	"context"

	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/change"

	gpb "github.com/openconfig/gnmi/proto/gnmi"
)

// Transport provides an interface for Transport implementations
// like RESTCONF or gnmi.
type Transport interface {
	Get(ctx context.Context, params ...string) (any, error)
	Set(ctx context.Context, payload change.Payload) error
	CustomSet(ctx context.Context, req *gpb.SetRequest) (*gpb.SetResponse, error)
	Subscribe(ctx context.Context, params ...string) error
	ControlPlaneSubscribe(ctx context.Context, subscribeCallbackFunc HandleSubscribeResponse,
		subscriptionInfo *SubscriptionInformation) error
	Type() string
	ProcessResponse(resp interface{}) error
	ProcessControlPlaneSubscribeResponse(resp *gpb.SubscribeResponse_Update) error
}

type (
	// HandleSubscribeResponse is the callback function to handle subcription responses.
	HandleSubscribeResponse func(*gpb.SubscribeResponse, *SubscriptionInformation)
)

// SubscriptionInformation contains additional information used for internal subscriptions
// for distinguishing from which network element the information is from, to stop subscriptions and
// error handling.
type SubscriptionInformation struct {
	PndID              string
	NetworkElementID   string
	NetworkElementName string
	StopContext        context.Context
}
