package store

import "github.com/google/uuid"

// Storable provides an interface for the controller's storage architecture.
type Storable interface {
	ID() uuid.UUID
}

// Store describes an interface for store implementations.
type Store interface {
	Exists(id uuid.UUID) bool
	Add(item Storable) error
	Get(id uuid.UUID) (Storable, error)
	Delete(id uuid.UUID) error
	UUIDs() []uuid.UUID
}
