package rbac

import (
	"code.fbi.h-da.de/danet/gosdn/controller/store"
)

// UserStore describes an interface for user store implementations.
type UserStore interface {
	Add(u User) error
	Update(u User) error
	Delete(User) error
	Get(store.Query) (LoadedUser, error)
	GetAll() ([]LoadedUser, error)
}
