package rbac

import (
	"github.com/google/uuid"

	"code.fbi.h-da.de/danet/gosdn/controller/conflict"
)

// User represents an User which is managed by rbac.
type User interface {
	ID() uuid.UUID
	Name() string
	GetRoles() map[string]string
	GetPassword() string
	GetToken() string
	SetToken(string)
	GetSalt() string
	GetMetadata() conflict.Metadata
}

// LoadedUser represents a User that was loaded.
type LoadedUser struct {
	ID       string            `json:"_id" bson:"_id"`
	UserName string            `json:"username"`
	Roles    map[string]string `json:"roles,omitempty"`
	Password string            `json:"password"`
	Token    string            `json:"token,omitempty"`
	Salt     string            `json:"salt" bson:"salt"`
	Metadata conflict.Metadata `json:"metadata" bson:"metadata"`
}
