package rbac

import "github.com/google/uuid"

// Role represents a role with permissions.
type Role interface {
	ID() uuid.UUID
	Name() string
	GetDescription() string
	GetPermissions() []string
	RemovePermissionsFromRole([]string)
}

// LoadedRole represents a Role that was loaded.
type LoadedRole struct {
	ID          string   `json:"_id" bson:"_id"`
	RoleName    string   `json:"rolename"`
	Description string   `json:"description,omitempty"`
	Permissions []string `json:"permissions,omitempty"`
}
