package rbac

import (
	"code.fbi.h-da.de/danet/gosdn/controller/store"
)

// UserService describes an interface for user service implementation.
type UserService interface {
	Add(User) error
	Delete(User) error
	Update(User) error
	Get(store.Query) (User, error)
	GetAll() ([]User, error)
}

// RoleService describes an interface for role service implementations.
type RoleService interface {
	Add(Role) error
	Delete(Role) error
	Update(Role) error
	Get(store.Query) (Role, error)
	GetAll() ([]Role, error)
}
