package networkelement

import (
	"code.fbi.h-da.de/danet/gosdn/controller/store"
	"github.com/google/uuid"
)

// Service describes an interface for network element service implementations.
type Service interface {
	Add(NetworkElement) error
	Update(NetworkElement) error
	UpdateModel(uuid.UUID, string) error
	Delete(NetworkElement) error
	Get(store.Query) (NetworkElement, error)
	GetAll() ([]NetworkElement, error)
	GetAllAsLoaded() ([]LoadedNetworkElement, error)
}
