package networkdomain

import (
	"code.fbi.h-da.de/danet/gosdn/controller/interfaces/networkelement"
	"code.fbi.h-da.de/danet/gosdn/controller/store"
	"github.com/google/uuid"
)

// PndStore describes an interface for pnd store implementations.
type PndStore interface {
	Add(NetworkDomain) error
	Delete(NetworkDomain) error
	Get(store.Query) (LoadedPnd, error)
	GetAll() ([]LoadedPnd, error)
	PendingChannels(id uuid.UUID, parseErrors ...error) (chan networkelement.Details, error)
	AddPendingChannel(id uuid.UUID, ch chan networkelement.Details)
	RemovePendingChannel(id uuid.UUID)
}
