package networkdomain

import (
	"code.fbi.h-da.de/danet/gosdn/controller/store"
)

// Service describes an interface for PND service implementation.
type Service interface {
	Add(NetworkDomain) error
	Delete(NetworkDomain) error
	Get(store.Query) (NetworkDomain, error)
	GetAll() ([]NetworkDomain, error)
	// Note: Implement these in case we want to use cSBI again.
	// PendingChannels(id uuid.UUID, parseErrors ...error) (chan networkelement.Details, error)
	// AddPendingChannel(id uuid.UUID, ch chan networkelement.Details)
	// RemovePendingChannel(id uuid.UUID)
}
